/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.util;

import arc.Core;
import arc.files.Fi;
import arc.func.Boolf;
import arc.func.Cons;
import arc.graphics.Color;
import arc.graphics.Gl;
import arc.graphics.Pixmap;
import arc.graphics.PixmapIO;
import arc.graphics.Texture;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureAtlas;
import arc.graphics.g2d.TextureRegion;
import arc.graphics.gl.FrameBuffer;
import arc.math.Interp;
import arc.math.Mat;
import arc.struct.Seq;
import arc.struct.StringMap;
import arc.util.Log;
import arc.util.ScreenUtils;
import arc.util.Tmp;
import arc.util.serialization.JsonValue;
import arc.util.serialization.JsonWriter;
import java.io.File;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Objects;
import mindustry.Vars;
import mindustry.ctype.Content;
import mindustry.ctype.ContentType;
import mindustry.ctype.UnlockableContent;
import mindustry.entities.bullet.BulletType;
import mindustry.game.Team;
import mindustry.gen.Icon;
import mindustry.graphics.Pal;
import mindustry.type.Category;
import mindustry.type.Planet;
import mindustry.type.Sector;
import mindustry.world.Block;
import newhorizon.NewHorizon;
import newhorizon.util.graphic.DrawFunc;

public class DebugFunc {
    public static final String NH_ROOT_PATH = "E:/project/MindustryModDevLib/NewHorizonMod";
    public static final String NH_BUNDLE_PATH = "E:/project/MindustryModDevLib/NewHorizonMod/assets/bundles/blank/";
    public static final String NH_SPRITE_PATH = "E:/project/MindustryModDevLib/NewHorizonMod/assets/sprites";
    public static final String NH_ENV_AUTOTILE_PATH = "E:/project/MindustryModDevLib/NewHorizonMod/assets/sprites/blocks/environment/ancient/autotile/";
    public static final String NH_DEBUG_GRAPHIC_FOLDER = "E:/project/MindustryModDevLib/NewHorizonMod/assets/sprites/debug/";
    public static final String NH_DEBUG_JSON_DATA_FOLDER = "E:/project/MindustryModDevLib/NewHorizonMod/data/";
    public static final String NH_SPRITE_ICON_PATH = "E:/project/MindustryModDevLib/NewHorizonMod/icons/";
    public static final Color[] NH_SPRITE_PALETTE = new Color[]{Color.valueOf((String)"abb1bf"), Color.valueOf((String)"8e909c"), Color.valueOf((String)"5a5d70"), Color.valueOf((String)"2e3039")};
    public static final Color[] EXOPROSOPA_SPRITE_PALETTE = new Color[]{Color.valueOf((String)"6b6881"), Color.valueOf((String)"4b495a"), Color.valueOf((String)"32303c"), Color.valueOf((String)"26262f")};
    public static final Color[] ASTHOSUS_SPRITE_PALETTE = new Color[]{Color.valueOf((String)"8f8a77"), Color.valueOf((String)"7a7564"), Color.valueOf((String)"5b574e"), Color.valueOf((String)"44413a")};

    public static void generateBlankBundle() {
        StringBuilder sb = new StringBuilder();
        sb.append("#TO TRANSLATORS:\n#The following parts are mainly New Horizon's content translations (items, blocks, etc.)\n#For some content's name, they are random created word if you couldnt find the word root.\n#In this case, its ok for you to create your own translation in your own language\n#For the content details, its ok to add content for your self, for example lore or even memes.\n#The .detail is ok for that, just keep the .description accurate.\n#If you want to make the .detail, remove the '#' mark in the line.\n#Its ok to add credit with your name inside the translate bundle.\n\n#THANK YOU FOR HELP TRANSLATING THIS MOD!\n");
        sb.append("\n\n#[[REGION ITEM]]\n\n\n");
        DebugFunc.contentIterator(ContentType.item, (Cons<UnlockableContent>)((Cons)content -> sb.append(DebugFunc.contentBlankBundle(content))));
        sb.append("\n\n#[[REGION LIQUID]]\n\n\n");
        DebugFunc.contentIterator(ContentType.liquid, (Cons<UnlockableContent>)((Cons)content -> sb.append(DebugFunc.contentBlankBundle(content))));
        Boolf modFilter = content -> {
            if (!(content instanceof Block)) return false;
            Block block = (Block)content;
            if (block.minfo.mod != NewHorizon.MOD) return false;
            return true;
        };
        sb.append("\n\n#[[REGION BLOCK]]\n\n\n");
        sb.append("#TURRET PART\n");
        DebugFunc.contentIterator(ContentType.block, (Boolf<UnlockableContent>)((Boolf)content -> modFilter.get(content) && ((Block)content).category == Category.turret), (Cons<UnlockableContent>)((Cons)content -> sb.append(DebugFunc.contentBlankBundle(content))));
        sb.append("#PRODUCTION PART\n");
        DebugFunc.contentIterator(ContentType.block, (Boolf<UnlockableContent>)((Boolf)content -> modFilter.get(content) && ((Block)content).category == Category.production), (Cons<UnlockableContent>)((Cons)content -> sb.append(DebugFunc.contentBlankBundle(content))));
        sb.append("#DISTRIBUTION PART\n");
        DebugFunc.contentIterator(ContentType.block, (Boolf<UnlockableContent>)((Boolf)content -> modFilter.get(content) && ((Block)content).category == Category.distribution), (Cons<UnlockableContent>)((Cons)content -> sb.append(DebugFunc.contentBlankBundle(content))));
        sb.append("#LIQUID PART\n");
        DebugFunc.contentIterator(ContentType.block, (Boolf<UnlockableContent>)((Boolf)content -> modFilter.get(content) && ((Block)content).category == Category.liquid), (Cons<UnlockableContent>)((Cons)content -> sb.append(DebugFunc.contentBlankBundle(content))));
        sb.append("#POWER PART\n");
        DebugFunc.contentIterator(ContentType.block, (Boolf<UnlockableContent>)((Boolf)content -> modFilter.get(content) && ((Block)content).category == Category.power), (Cons<UnlockableContent>)((Cons)content -> sb.append(DebugFunc.contentBlankBundle(content))));
        sb.append("#DEFENSE PART\n");
        DebugFunc.contentIterator(ContentType.block, (Boolf<UnlockableContent>)((Boolf)content -> modFilter.get(content) && ((Block)content).category == Category.defense), (Cons<UnlockableContent>)((Cons)content -> sb.append(DebugFunc.contentBlankBundle(content))));
        sb.append("#CRAFTING PART\n");
        DebugFunc.contentIterator(ContentType.block, (Boolf<UnlockableContent>)((Boolf)content -> modFilter.get(content) && ((Block)content).category == Category.crafting), (Cons<UnlockableContent>)((Cons)content -> sb.append(DebugFunc.contentBlankBundle(content))));
        sb.append("#UNIT PART\n");
        DebugFunc.contentIterator(ContentType.block, (Boolf<UnlockableContent>)((Boolf)content -> modFilter.get(content) && ((Block)content).category == Category.units), (Cons<UnlockableContent>)((Cons)content -> sb.append(DebugFunc.contentBlankBundle(content))));
        sb.append("#SPECIAL PART\n");
        DebugFunc.contentIterator(ContentType.block, (Boolf<UnlockableContent>)((Boolf)content -> modFilter.get(content) && ((Block)content).category == Category.effect), (Cons<UnlockableContent>)((Cons)content -> sb.append(DebugFunc.contentBlankBundle(content))));
        sb.append("#LOGIC PART\n");
        DebugFunc.contentIterator(ContentType.block, (Boolf<UnlockableContent>)((Boolf)content -> modFilter.get(content) && ((Block)content).category == Category.logic), (Cons<UnlockableContent>)((Cons)content -> sb.append(DebugFunc.contentBlankBundle(content))));
        sb.append("\n\n#[[REGION UNIT]]\n\n\n");
        DebugFunc.contentIterator(ContentType.unit, (Cons<UnlockableContent>)((Cons)content -> sb.append(DebugFunc.contentBlankBundle(content))));
        sb.append("\n\n#[[REGION STATUS]]\n\n\n");
        DebugFunc.contentIterator(ContentType.status, (Cons<UnlockableContent>)((Cons)content -> sb.append(DebugFunc.contentBlankBundle(content))));
        sb.append("\n\n#[[REGION PLANET]]\n\n\n");
        DebugFunc.contentIterator(ContentType.planet, (Cons<UnlockableContent>)((Cons)content -> sb.append(DebugFunc.contentBlankBundle(content))));
        sb.append("\n\n#[[REGION SECTOR]]\n\n\n");
        DebugFunc.contentIterator(ContentType.sector, (Cons<UnlockableContent>)((Cons)content -> sb.append(DebugFunc.contentBlankBundle(content))));
        sb.append("\n\n#[[REGION WEATHER]]\n\n\n");
        DebugFunc.contentIterator(ContentType.weather, (Cons<UnlockableContent>)((Cons)content -> sb.append(DebugFunc.contentBlankBundle(content))));
        Fi blankBundle = new Fi("E:/project/MindustryModDevLib/NewHorizonMod/assets/bundles/blank/bundle.blank-content.txt");
        blankBundle.writeString(sb.toString());
    }

    public static String contentBlankBundle(UnlockableContent content) {
        String prefix = content.getContentType().name() + ".";
        return prefix + content.name + ".name = \n" + prefix + content.name + ".description = \n#" + prefix + content.name + ".detail = \n";
    }

    public static void contentIterator(ContentType type, Boolf<UnlockableContent> filter, Cons<UnlockableContent> iterator) {
        for (Content content : Vars.content.getBy(type)) {
            UnlockableContent unlockableContent;
            if (!(content instanceof UnlockableContent) || !filter.get((Object)(unlockableContent = (UnlockableContent)content))) continue;
            iterator.get((Object)unlockableContent);
        }
    }

    public static void contentIterator(ContentType type, Cons<UnlockableContent> iterator) {
        DebugFunc.contentIterator(type, (Boolf<UnlockableContent>)((Boolf)c -> c.minfo.mod == NewHorizon.MOD), iterator);
    }

    public static Fi createPNGFile(String fileName) {
        return new Fi(NH_DEBUG_GRAPHIC_FOLDER + fileName + ".png");
    }

    public static Fi createIconPNGFile(String fileName) {
        return new Fi(NH_SPRITE_ICON_PATH + fileName + ".png");
    }

    public static Fi createJsonFile(String fileName) {
        return new Fi(NH_DEBUG_JSON_DATA_FOLDER + fileName + ".json");
    }

    public static void processTiles() {
        Fi folder = new Fi("E:/project/MindustryModDevLib/NewHorizonMod/debug");
        for (Fi image : folder.list()) {
            if (!image.name().endsWith(".png")) continue;
            Pixmap pixmap = PixmapIO.readPNG((Fi)image);
            if (pixmap.width == 128 && pixmap.height == 128 || pixmap.width == 136 && pixmap.height == 136) {
                ProcessBuilder pb = new ProcessBuilder("tile-gen.exe", "proc", image.name());
                pb.directory(new File("E:/project/MindustryModDevLib/NewHorizonMod/debug"));
                pb.inheritIO();
                try {
                    Process p = pb.start();
                    p.waitFor();
                }
                catch (IOException | InterruptedException e) {
                    Log.err((Throwable)e);
                }
            }
            pixmap.dispose();
        }
    }

    public static void outputAtlas() {
        int i = 0;
        for (Texture tex : Core.atlas.getTextures()) {
            ++i;
            int w = tex.width;
            int h = tex.height;
            FrameBuffer fb = new FrameBuffer(w, h);
            fb.begin();
            Draw.reset();
            Draw.proj().setOrtho(0.0f, 0.0f, (float)w, (float)h);
            Draw.color();
            Draw.shader();
            tex.bind();
            TextureRegion region = new TextureRegion(tex);
            Draw.rect((TextureRegion)region, (float)((float)w / 2.0f), (float)((float)h / 2.0f), (float)w, (float)(-h));
            Gl.pixelStorei((int)3333, (int)1);
            ByteBuffer buffer = ByteBuffer.allocateDirect(w * h * 4);
            Gl.readPixels((int)0, (int)0, (int)w, (int)h, (int)6408, (int)5121, (Buffer)buffer);
            Pixmap pixmap = new Pixmap(buffer, w, h);
            fb.end();
            fb.dispose();
            PixmapIO.writePng((Fi)DebugFunc.createPNGFile("atlas_" + i + ".png"), (Pixmap)pixmap);
            pixmap.dispose();
        }
    }

    public static void outputIcon() {
        Icon.icons.each((name, drawable) -> {
            TextureRegion region = drawable.getRegion();
            DebugFunc.outputTextureRegion(name, region);
        });
    }

    public static void outlineIcon() {
        Fi folder = new Fi(NH_DEBUG_GRAPHIC_FOLDER);
        folder.findAll().each(sprite -> DebugFunc.outlineSprite(sprite, Pal.gray, 4, true, false));
    }

    public static void outlineSprite(Fi sprite, Color color, int stroke, boolean expand, boolean smooth) {
        int pad = expand ? stroke * 2 : 0;
        Pixmap process = PixmapIO.readPNG((Fi)sprite);
        Pixmap result = new Pixmap(process.width + pad, process.height + pad);
        result.fill(Color.clear);
        result.draw(process, stroke, stroke);
        Pixmap out = smooth ? DebugFunc.outlineSmooth(result, color, stroke) : result.outline(color, stroke);
        Fi fi = new Fi("E:/project/MindustryModDevLib/NewHorizonMod/assets/sprites/debug//outline/" + sprite.nameWithoutExtension() + "-outline.png");
        PixmapIO.writePng((Fi)fi, (Pixmap)out);
        process.dispose();
        result.dispose();
        out.dispose();
    }

    public static Pixmap outlineSmooth(Pixmap pixmap, Color color, int radius) {
        int x;
        int y;
        int alphaThreshold = 10;
        Pixmap result = pixmap.copy();
        float[][] distance = new float[pixmap.width][pixmap.height];
        for (y = 0; y < pixmap.height; ++y) {
            for (x = 0; x < pixmap.width; ++x) {
                distance[x][y] = pixmap.getA(x, y) >= 10 ? 0.0f : Float.POSITIVE_INFINITY;
            }
        }
        for (y = 0; y < pixmap.height; ++y) {
            for (x = 0; x < pixmap.width; ++x) {
                if (distance[x][y] == 0.0f) continue;
                for (int yy = Math.max(0, y - radius); yy <= Math.min(pixmap.height - 1, y + radius); ++yy) {
                    for (int xx = Math.max(0, x - radius); xx <= Math.min(pixmap.width - 1, x + radius); ++xx) {
                        float dy;
                        float dx;
                        float distSq;
                        if (distance[xx][yy] != 0.0f || !((distSq = (dx = (float)(x - xx)) * dx + (dy = (float)(y - yy)) * dy) < distance[x][y] * distance[x][y])) continue;
                        distance[x][y] = (float)Math.sqrt(distSq);
                    }
                }
            }
        }
        for (y = 0; y < pixmap.height; ++y) {
            for (x = 0; x < pixmap.width; ++x) {
                float d = distance[x][y];
                if (!(d > 0.0f) || !(d <= (float)radius)) continue;
                float alpha = Interp.pow10Out.apply(1.0f - d / (float)radius);
                int rgba = Tmp.c1.set(color).a(alpha).rgba8888();
                result.setRaw(x, y, rgba);
            }
        }
        return result;
    }

    public static void outputTextureRegion(String name, TextureRegion region) {
        Draw.blend();
        Draw.reset();
        Tmp.m1.set(Draw.proj());
        Tmp.m2.set(Draw.trans());
        FrameBuffer buffer = new FrameBuffer(region.width, region.height);
        buffer.begin(Color.clear);
        Draw.proj().setOrtho(0.0f, (float)buffer.getHeight(), (float)buffer.getWidth(), (float)(-buffer.getHeight()));
        Draw.flush();
        Draw.rect((TextureRegion)region, (float)((float)region.width / 2.0f), (float)((float)region.height / 2.0f), (float)region.width, (float)region.height);
        Draw.flush();
        Draw.trans().idt();
        buffer.end();
        Draw.proj((Mat)Tmp.m1);
        Draw.trans((Mat)Tmp.m2);
        Draw.flush();
        buffer.begin();
        Pixmap pixmap = ScreenUtils.getFrameBufferPixmap((int)0, (int)0, (int)buffer.getWidth(), (int)buffer.getHeight());
        Fi fi = DebugFunc.createPNGFile(name);
        fi.writePng(pixmap);
        buffer.end();
        buffer.dispose();
    }

    public static void unlockModContent() {
        for (Seq contents : Vars.content.getContentMap()) {
            for (Content content : contents) {
                if (!(content instanceof UnlockableContent)) continue;
                UnlockableContent unlockableContent = (UnlockableContent)content;
                if (unlockableContent.minfo.mod != NewHorizon.MOD) continue;
                unlockableContent.quietUnlock();
            }
        }
    }

    public static void replaceAllSpriteColor(String path, Color[] palette) {
        Fi fi = new Fi(path);
        fi.walk(file -> DebugFunc.replaceSpriteColor(path, file, palette));
    }

    public static void replaceSpriteColor(String parentPath, Fi sprite, Color[] palette) {
        if (!Objects.equals(sprite.extension(), "png")) {
            return;
        }
        Fi parent = sprite.parent();
        Fi out = new Fi(NH_DEBUG_GRAPHIC_FOLDER + parent.name().replace(parentPath, "") + "/" + sprite.name());
        Pixmap pixmap = new Pixmap(sprite);
        pixmap.each((x, y) -> {
            if (pixmap.get(x, y) == palette[0].rgba()) {
                pixmap.set(x, y, NH_SPRITE_PALETTE[0]);
            }
            if (pixmap.get(x, y) == palette[1].rgba()) {
                pixmap.set(x, y, NH_SPRITE_PALETTE[1]);
            }
            if (pixmap.get(x, y) == palette[2].rgba()) {
                pixmap.set(x, y, NH_SPRITE_PALETTE[2]);
            }
            if (pixmap.get(x, y) == palette[3].rgba()) {
                pixmap.set(x, y, NH_SPRITE_PALETTE[3]);
            }
        });
        PixmapIO.writePng((Fi)out, (Pixmap)pixmap);
        pixmap.dispose();
    }

    public static void replaceAtlas(Color[] palette) {
        for (TextureAtlas.AtlasRegion region : Core.atlas.getRegions()) {
            Pixmap pixmap = region.pixmapRegion.pixmap;
            pixmap.each((x, y) -> {
                if (pixmap.get(x, y) == palette[0].rgba()) {
                    pixmap.set(x, y, NH_SPRITE_PALETTE[0]);
                }
                if (pixmap.get(x, y) == palette[1].rgba()) {
                    pixmap.set(x, y, NH_SPRITE_PALETTE[1]);
                }
                if (pixmap.get(x, y) == palette[2].rgba()) {
                    pixmap.set(x, y, NH_SPRITE_PALETTE[2]);
                }
                if (pixmap.get(x, y) == palette[3].rgba()) {
                    pixmap.set(x, y, NH_SPRITE_PALETTE[3]);
                }
            });
        }
    }

    public static void outputSettings() {
        StringBuilder sb = new StringBuilder();
        for (String string : Core.settings.keys()) {
            sb.append(string).append("\n");
        }
        Core.app.setClipboardText(sb.toString());
    }

    public static void outputContentSprites() {
        for (Seq contents : Vars.content.getContentMap()) {
            for (Content content : contents) {
                if (content.minfo.mod != NewHorizon.MOD) continue;
                String name = "content";
                TextureRegion icon = null;
                if (content instanceof UnlockableContent) {
                    name = ((UnlockableContent)content).name;
                    icon = ((UnlockableContent)content).fullIcon;
                }
                if (icon == null) continue;
                Fi fi = DebugFunc.createIconPNGFile(name);
                Pixmap pixmap = Core.atlas.getPixmap(icon).crop();
                PixmapIO.writePng((Fi)fi, (Pixmap)pixmap);
                pixmap.dispose();
            }
        }
    }

    public static void writeBulletTypeList() {
        StringBuilder sb = new StringBuilder();
        for (BulletType type : Vars.content.bullets()) {
            String id = type.id + "";
            String name = type.getClass().getName();
            sb.append(id);
            sb.append(" ");
            sb.append(name);
            sb.append("\n");
        }
        Core.app.setClipboardText(sb.toString());
    }

    public static void writeBlockList() {
        StringBuilder sb = new StringBuilder();
        for (Block block : Vars.content.blocks()) {
            if (!block.isModded() || !block.name.startsWith("new-horizon")) continue;
            sb.append(DebugFunc.writeBlock(block));
        }
        Core.app.setClipboardText(sb.toString());
    }

    public static void updateBlockList() {
        StringMap map = new StringMap();
        String prev = DebugFunc.readBlockList();
        String[] lists = prev.split("\n");
        for (String list : lists) {
            map.put((Object)list.split(" ")[0], (Object)list);
        }
        for (Block block : Vars.content.blocks()) {
            if (!block.isModded() || !block.name.startsWith("new-horizon")) continue;
            String blockData = DebugFunc.writeBlockNoLine(block);
            map.put((Object)blockData.split(" ")[0], (Object)blockData);
        }
        Seq ordered = new Seq(map.size);
        map.each((ignored, data) -> ordered.add(data));
        ordered.sort(String::compareTo);
        StringBuilder sb = new StringBuilder();
        ordered.each(data -> sb.append((String)data).append("\n"));
        Fi.get((String)NH_ROOT_PATH).child("blocklist.txt").writeString(sb.toString());
    }

    public static String readBlockList() {
        Fi fi = Fi.get((String)NH_ROOT_PATH).child("blocklist.txt");
        if (fi.exists()) {
            return fi.readString();
        }
        return "";
    }

    public static String writeBlockNoLine(Block block) {
        return block.name + " " + (block.synthetic() ? "1" : "0") + " " + (block.solid ? "1" : "0") + " " + block.size + " " + block.mapColor.rgb888();
    }

    public static String writeBlock(Block block) {
        return block.name + " " + (block.synthetic() ? "1" : "0") + " " + (block.solid ? "1" : "0") + " " + block.size + " " + block.mapColor.rgb888() + "\n";
    }

    public static void writeTeamList() {
        JsonValue json = new JsonValue(JsonValue.ValueType.object);
        for (Team team : Team.all) {
            json.addChild(String.valueOf(team.id), new JsonValue((long)team.color.rgba8888()));
        }
        DebugFunc.createJsonFile("teamlist").writeString(json.prettyPrint(JsonWriter.OutputType.json, 2));
    }

    public static void writeVanillaBlockList() {
        JsonValue json = new JsonValue(JsonValue.ValueType.object);
        DebugFunc.contentIterator(ContentType.block, (Boolf<UnlockableContent>)((Boolf)Content::isVanilla), (Cons<UnlockableContent>)((Cons)content -> DebugFunc.writeBlockJsonValue(content, json)));
        DebugFunc.createJsonFile("blocklist-vanilla").writeString(json.prettyPrint(JsonWriter.OutputType.json, 2));
        Vars.mods.list().each(mod -> {
            if (mod.meta.hidden || !mod.enabled()) {
                return;
            }
            JsonValue modJson = new JsonValue(JsonValue.ValueType.object);
            DebugFunc.contentIterator(ContentType.block, (Boolf<UnlockableContent>)((Boolf)content -> content.minfo != null && content.minfo.mod == mod), (Cons<UnlockableContent>)((Cons)content -> DebugFunc.writeBlockJsonValue(content, modJson)));
            DebugFunc.createJsonFile("blocklist-" + mod.name).writeString(modJson.prettyPrint(JsonWriter.OutputType.json, 2));
        });
    }

    public static void writeBlockJsonValue(UnlockableContent content, JsonValue json) {
        if (content instanceof Block) {
            Block block = (Block)content;
            JsonValue data = new JsonValue(JsonValue.ValueType.object);
            data.addChild("synthetic", new JsonValue(block.synthetic()));
            data.addChild("solid", new JsonValue(block.solid));
            data.addChild("size", new JsonValue((long)block.size));
            data.addChild("color", new JsonValue((long)block.mapColor.rgba8888()));
            json.addChild(block.name, data);
        }
    }

    public static void renderSectorId() {
        Planet planet = Vars.ui.planet.state.planet;
        Draw.color((Color)Color.white);
        for (Sector sec : planet.sectors) {
            if (sec == null) continue;
            String secText = "[" + sec.id + "]";
            Vars.renderer.planets.drawPlane(sec, () -> DrawFunc.drawText(secText, 0.0f, 15.0f, 1.8f));
        }
        Draw.reset();
    }
}

