/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.util;

import arc.files.Fi;
import arc.graphics.Color;
import arc.graphics.Pixmap;
import arc.graphics.PixmapIO;
import arc.graphics.Pixmaps;
import arc.graphics.Texture;
import arc.graphics.g2d.TextureRegion;
import arc.math.geom.Point2;
import arc.struct.ObjectIntMap;
import arc.struct.Seq;
import arc.util.Log;
import arc.util.Scaling;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.gen.Building;
import mindustry.ui.dialogs.BaseDialog;
import mindustry.world.blocks.logic.CanvasBlock;
import newhorizon.content.NHPostProcess;

public class PixelArtGenerator {
    public static Fi toRead;
    public static Point2 leftDown;
    public static Point2 rightTop;
    static ObjectIntMap<Color> cache;
    static Seq<CanvasBlock.CanvasBuild> builds;
    static int height;
    static int width;

    public static boolean process() {
        int i;
        Pixmap pixmap;
        builds.clear();
        if (toRead == null) {
            return false;
        }
        Pixmap finalPixmap = pixmap = PixmapIO.readPNG((Fi)toRead);
        pixmap.each((x, y) -> finalPixmap.set(x, y, PixelArtGenerator.color8888(PixelArtGenerator.findMostSimilar(Tmp.c1.rgba8888(finalPixmap.get(x, y))))));
        Log.info((Object)"lerp complete");
        CanvasBlock type = null;
        for (int i2 = PixelArtGenerator.leftDown.x; i2 <= PixelArtGenerator.rightTop.x; ++i2) {
            for (int j = PixelArtGenerator.rightTop.y; j >= PixelArtGenerator.leftDown.y; --j) {
                Building building = Vars.world.build(i2, j);
                if (!(building instanceof CanvasBlock.CanvasBuild)) {
                    return false;
                }
                CanvasBlock.CanvasBuild b = (CanvasBlock.CanvasBuild)building;
                type = (CanvasBlock)b.block;
                builds.addUnique((Object)b);
            }
        }
        Log.info((Object)"convert complete");
        if (type == null) {
            return false;
        }
        height = (PixelArtGenerator.rightTop.y - PixelArtGenerator.leftDown.y) / type.size * type.canvasSize;
        width = (PixelArtGenerator.rightTop.x - PixelArtGenerator.leftDown.x) / type.size * type.canvasSize;
        if (pixmap.width > height || pixmap.height > width) {
            return false;
        }
        int xScl = 1;
        int yScl = 1;
        xScl = width / pixmap.width;
        yScl = height / pixmap.height;
        int scl = Math.min(xScl, yScl);
        final Pixmap finalPixmap1 = pixmap = Pixmaps.resize((Pixmap)pixmap, (int)width, (int)height);
        new BaseDialog("Preview"){
            {
                super(arg0);
                this.addCloseButton();
                this.cont.table(t -> t.image(new TextureRegion(new Texture(finalPixmap1))).scaling(Scaling.stretch)).grow();
            }
        }.show();
        Log.info((Object)"fetch complete");
        Seq split = new Seq(PixelArtGenerator.builds.size);
        for (i = 0; i <= width / type.canvasSize; ++i) {
            for (int j = 0; j <= height / type.canvasSize; ++j) {
                split.add((Object)Pixmaps.crop((Pixmap)pixmap, (int)(i * type.canvasSize), (int)(j * type.canvasSize), (int)type.canvasSize, (int)type.canvasSize));
            }
        }
        for (i = 0; i < PixelArtGenerator.builds.size; ++i) {
            CanvasBlock.CanvasBuild b = (CanvasBlock.CanvasBuild)builds.get(i);
            b.configure((Object)b.packPixmap((Pixmap)split.get(Math.min(i, split.size - 1))));
        }
        Log.info((Object)"draw complete");
        split.each(Pixmap::dispose);
        pixmap.dispose();
        return true;
    }

    public static int findMostSimilar(Color color) {
        if (cache.containsKey((Object)color)) {
            return cache.get((Object)color);
        }
        float diff = Float.POSITIVE_INFINITY;
        int tgtColor = 0;
        for (int i = 0; i < NHPostProcess.validColor.size; ++i) {
            Color c = (Color)NHPostProcess.validColor.get(i);
            float d = PixelArtGenerator.colorDst(color, c);
            if (!(d < diff)) continue;
            diff = d;
            tgtColor = i;
        }
        cache.put((Object)color, tgtColor);
        return tgtColor;
    }

    public static int color8888(int index) {
        return ((Color)NHPostProcess.validColor.get(index)).rgba8888();
    }

    public static float colorDst(Color color1, Color color2) {
        return color1.diff(color2);
    }

    static {
        leftDown = new Point2();
        rightTop = new Point2();
        cache = new ObjectIntMap();
        builds = new Seq();
    }
}

