/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.util.func;

import arc.func.Boolf;
import arc.func.Cons;
import arc.func.Intc2;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.math.Mathf;
import arc.math.Rand;
import arc.math.geom.Geometry;
import arc.math.geom.Intersector;
import arc.math.geom.Point2;
import arc.math.geom.Position;
import arc.math.geom.Rect;
import arc.math.geom.Vec2;
import arc.struct.IntFloatMap;
import arc.struct.IntSeq;
import arc.struct.IntSet;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import arc.util.Log;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.pooling.Pools;
import mindustry.Vars;
import mindustry.core.World;
import mindustry.entities.Effect;
import mindustry.entities.Fires;
import mindustry.entities.Units;
import mindustry.entities.bullet.BulletType;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Bullet;
import mindustry.gen.Hitboxc;
import mindustry.gen.Player;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.gen.WaterMovec;
import mindustry.graphics.Pal;
import mindustry.type.StatusEffect;
import mindustry.type.UnitType;
import mindustry.world.Tile;
import mindustry.world.blocks.defense.turrets.ItemTurret;
import mindustry.world.blocks.environment.Floor;
import newhorizon.content.NHFx;
import newhorizon.expand.entities.Spawner;

public class NHFunc {
    public static final Rand globalEffectRand = new Rand(0L);
    public static final Rand rand = new Rand(0L);
    public static final Effect debugEffect = new Effect(120.0f, 300.0f, e -> {
        if (!(e.data instanceof Seq)) {
            return;
        }
        Seq data = (Seq)e.data();
        Draw.color((Color)Pal.lancerLaser);
        Draw.z((float)117.0f);
        for (Rect r : data) {
            r.getCenter(Tmp.v1);
            Fill.square((float)Tmp.v1.x, (float)Tmp.v1.y, (float)4.0f);
        }
    });
    private static final float MAX_TELEPORT_DST_NET = 4.0f;
    private static final Seq<Tile> tiles = new Seq();
    private static final IntSeq buildingIDSeq = new IntSeq();
    private static final int maxCompute = 32;
    private static final Vec2 vec21 = new Vec2();
    private static final Vec2 vec22 = new Vec2();
    private static final Vec2 vec23 = new Vec2();
    private static final Rect rect = new Rect();
    private static final Rect hitrect = new Rect();
    private static final Vec2 tr = new Vec2();
    private static final Vec2 seg1 = new Vec2();
    private static final Vec2 seg2 = new Vec2();
    private static final Seq<Unit> units = new Seq();
    private static final IntSet collidedBlocks = new IntSet();
    private static final IntFloatMap damages = new IntFloatMap();
    private static final Vec2 point1 = new Vec2();
    private static final Vec2 point2 = new Vec2();
    private static final Vec2 point3 = new Vec2();
    private static final Vec2 point4 = new Vec2();
    private static final Rect r1 = new Rect();
    private static final Rect r2 = new Rect();
    private static long seedR = 0L;
    private static Tile tileParma;
    private static Floor floorParma;
    private static Tile furthest;
    private static Building tmpBuilding;
    private static Unit tmpUnit;

    public static long getSeed() {
        return seedR++;
    }

    public static void extinguish(Team team, float x, float y, float range, float intensity) {
        Vars.indexer.eachBlock(team, x, y, range, b -> true, b -> Fires.extinguish((Tile)b.tile, (float)intensity));
    }

    public static void extinguish(Teamc teamc, float range, float intensity) {
        Vars.indexer.eachBlock(teamc.team(), teamc.x(), teamc.y(), range, b -> true, b -> Fires.extinguish((Tile)b.tile, (float)intensity));
    }

    public static Position collideBuild(Team team, float x1, float y1, float x2, float y2, Boolf<Building> boolf) {
        tmpBuilding = null;
        boolean found = World.raycast((int)World.toTile((float)x1), (int)World.toTile((float)y1), (int)World.toTile((float)x2), (int)World.toTile((float)y2), (x, y) -> {
            tmpBuilding = Vars.world.build(x, y);
            return tmpBuilding != null && NHFunc.tmpBuilding.team != team && boolf.get((Object)tmpBuilding);
        });
        return found ? tmpBuilding : vec21.set(x2, y2);
    }

    public static Position collideBuildOnLength(Team team, float x1, float y1, float length, float ang, Boolf<Building> boolf) {
        vec22.trns(ang, length).add(x1, y1);
        return NHFunc.collideBuild(team, x1, y1, NHFunc.vec22.x, NHFunc.vec22.y, boolf);
    }

    public static float findLaserLength(Bullet b, float angle, float length) {
        Tmp.v1.trnsExact(angle, length);
        tileParma = null;
        boolean found = World.raycast((int)b.tileX(), (int)b.tileY(), (int)World.toTile((float)(b.x + Tmp.v1.x)), (int)World.toTile((float)(b.y + Tmp.v1.y)), (x, y) -> {
            tileParma = Vars.world.tile(x, y);
            return tileParma != null && tileParma.team() != b.team && NHFunc.tileParma.block().absorbLasers;
        });
        return found && tileParma != null ? Math.max(6.0f, b.dst(tileParma.worldx(), tileParma.worldy())) : length;
    }

    public static void collideLine(Bullet hitter, Team team, Effect effect, float x, float y, float angle, float length, boolean large, boolean laser) {
        if (laser) {
            length = NHFunc.findLaserLength(hitter, angle, length);
        }
        collidedBlocks.clear();
        tr.trnsExact(angle, length);
        Intc2 collider = (cx, cy) -> {
            boolean collide;
            Building tile = Vars.world.build(cx, cy);
            boolean bl = collide = tile != null && collidedBlocks.add(tile.pos());
            if (hitter.damage > 0.0f) {
                float health;
                float f = health = !collide ? 0.0f : tile.health;
                if (collide && tile.team != team && tile.collide(hitter)) {
                    tile.collision(hitter);
                    hitter.type.hit(hitter, tile.x, tile.y);
                }
                if (collide && hitter.type.testCollision(hitter, tile)) {
                    hitter.type.hitTile(hitter, tile, (float)(cx * 8), (float)(cy * 8), health, false);
                }
            }
        };
        if (hitter.type.collidesGround) {
            seg1.set(x, y);
            seg2.set(seg1).add(tr);
            World.raycastEachWorld((float)x, (float)y, (float)NHFunc.seg2.x, (float)NHFunc.seg2.y, (cx, cy) -> {
                collider.get(cx, cy);
                for (Point2 p : Geometry.d4) {
                    Tile other = Vars.world.tile(p.x + cx, p.y + cy);
                    if (other == null || !large && !Intersector.intersectSegmentRectangle((Vec2)seg1, (Vec2)seg2, (Rect)other.getBounds(Tmp.r1))) continue;
                    collider.get(cx + p.x, cy + p.y);
                }
                return false;
            });
        }
        rect.setPosition(x, y).setSize(NHFunc.tr.x, NHFunc.tr.y);
        float x2 = NHFunc.tr.x + x;
        float y2 = NHFunc.tr.y + y;
        if (NHFunc.rect.width < 0.0f) {
            NHFunc.rect.x += NHFunc.rect.width;
            NHFunc.rect.width *= -1.0f;
        }
        if (NHFunc.rect.height < 0.0f) {
            NHFunc.rect.y += NHFunc.rect.height;
            NHFunc.rect.height *= -1.0f;
        }
        float expand = 3.0f;
        NHFunc.rect.y -= expand;
        NHFunc.rect.x -= expand;
        NHFunc.rect.width += expand * 2.0f;
        NHFunc.rect.height += expand * 2.0f;
        Cons cons = e -> {
            e.hitbox(hitrect);
            Vec2 vec = Geometry.raycastRect((float)x, (float)y, (float)x2, (float)y2, (Rect)hitrect.grow(expand * 2.0f));
            if (vec != null && hitter.damage > 0.0f) {
                effect.at(vec.x, vec.y);
                e.collision((Hitboxc)hitter, vec.x, vec.y);
                hitter.collision((Hitboxc)e, vec.x, vec.y);
            }
        };
        units.clear();
        Units.nearbyEnemies((Team)team, (Rect)rect, u -> {
            if (u.checkTarget(hitter.type.collidesAir, hitter.type.collidesGround)) {
                units.add(u);
            }
        });
        units.sort(u -> u.dst2((Position)hitter));
        units.each(cons);
    }

    public static void randFadeLightningEffect(float x, float y, float range, float lightningPieceLength, Color color, boolean in) {
        NHFunc.randFadeLightningEffectScl(x, y, range, 0.55f, 1.1f, lightningPieceLength, color, in);
    }

    public static void randFadeLightningEffectScl(float x, float y, float range, float sclMin, float sclMax, float lightningPieceLength, Color color, boolean in) {
        vec21.rnd(range).scl(Mathf.random((float)sclMin, (float)sclMax)).add(x, y);
        (in ? NHFx.chainLightningFadeReversed : NHFx.chainLightningFade).at(x, y, lightningPieceLength, color, (Object)vec21.cpy());
    }

    public static Unit teleportUnitNet(Unit before, float x, float y, float angle, Player player) {
        if (Vars.net.active() || Vars.headless) {
            if (player != null) {
                player.set(x, y);
                player.snapInterpolation();
                player.snapSync();
                player.updateSpacing = 0L;
                player.lastUpdated = 0L;
            }
            before.set(x, y);
            before.snapInterpolation();
            before.snapSync();
            before.updateSpacing = 0L;
            before.lastUpdated = 0L;
        } else {
            before.set(x, y);
        }
        before.rotation = angle;
        return before;
    }

    public static Seq<Tile> getAcceptableTiles(int x, int y, int range, Boolf<Tile> bool) {
        Seq tiles = new Seq(true, (int)((float)Mathf.pow((int)range, (int)2) * (float)Math.PI), Tile.class);
        Geometry.circle((int)x, (int)y, (int)range, (x1, y1) -> {
            tileParma = Vars.world.tile(x1, y1);
            if (tileParma != null && bool.get((Object)tileParma)) {
                tiles.add((Object)Vars.world.tile(x1, y1));
            }
        });
        return tiles;
    }

    private static void clearTmp() {
        tileParma = null;
        floorParma = null;
        buildingIDSeq.clear();
        tiles.clear();
    }

    public static Color getColor(Color defaultColor, Team team) {
        return defaultColor == null ? team.color : defaultColor;
    }

    public static void limitRangeWithoutNew(ItemTurret turret, float margin) {
        for (ObjectMap.Entry entry : turret.ammoTypes.entries()) {
            ((BulletType)entry.value).lifetime = (turret.range + margin) / ((BulletType)entry.value).speed;
        }
    }

    public static void spawnSingleUnit(UnitType type, Team team, int spawnNum, float x, float y) {
        for (int spawned = 0; spawned < spawnNum; ++spawned) {
            Time.run((float)((float)spawned * Time.delta), () -> {
                Unit unit = type.create(team);
                if (unit != null) {
                    unit.set(x, y);
                    unit.add();
                } else {
                    Log.info((Object)"Unit == null");
                }
            });
        }
    }

    public static float regSize(UnitType type) {
        return type.hitSize / 8.0f / 8.0f / 3.25f;
    }

    public static Seq<Boolf<Tile>> formats() {
        Seq seq = new Seq(3);
        seq.add(tile -> Vars.world.getQuadBounds(Tmp.r1).contains(tile.getBounds(Tmp.r2)), tile -> tile.floor().isLiquid && !tile.cblock().solid && !tile.floor().solid && !tile.overlay().solid && !tile.block().solidifes, tile -> !tile.floor().isDeep() && !tile.cblock().solid && !tile.floor().solid && !tile.overlay().solid && !tile.block().solidifes);
        return seq;
    }

    public static Boolf<Tile> ableToSpawn(UnitType type) {
        Seq<Boolf<Tile>> boolves = NHFunc.formats();
        Boolf boolf = type.flying ? (Boolf)boolves.get(0) : (WaterMovec.class.isAssignableFrom(((Unit)type.constructor.get()).getClass()) ? (Boolf)boolves.get(1) : (Boolf)boolves.get(2));
        return boolf;
    }

    public static Seq<Tile> ableToSpawn(UnitType type, float x, float y, float range) {
        Seq tSeq = new Seq(Tile.class);
        Boolf<Tile> boolf = NHFunc.ableToSpawn(type);
        return tSeq.addAll(NHFunc.getAcceptableTiles(World.toTile((float)x), World.toTile((float)y), World.toTile((float)range), boolf));
    }

    public static boolean ableToSpawnPoints(Seq<Vec2> spawnPoints, UnitType type, float x, float y, float range, int num, long seed) {
        Seq<Tile> tSeq = NHFunc.ableToSpawn(type, x, y, range);
        rand.setSeed(seed);
        for (int i = 0; i < num; ++i) {
            Tile[] positions = (Tile[])tSeq.shrink();
            if (positions.length < num) {
                return false;
            }
            spawnPoints.add((Object)new Vec2().set((Position)positions[rand.nextInt(positions.length)]));
        }
        return true;
    }

    public static boolean spawnUnit(Team team, float x, float y, float angle, float spawnRange, float spawnReloadTime, float spawnDelay, UnitType type, int spawnNum, Cons<Spawner> modifier) {
        if (type == null) {
            return false;
        }
        NHFunc.clearTmp();
        Seq vectorSeq = new Seq();
        if (!NHFunc.ableToSpawnPoints((Seq<Vec2>)vectorSeq, type, x, y, spawnRange, spawnNum, rand.nextLong())) {
            return false;
        }
        int i = 0;
        for (Vec2 s : vectorSeq) {
            Spawner spawner = (Spawner)Pools.obtain(Spawner.class, Spawner::new);
            spawner.init(type, team, (Position)s, angle, spawnReloadTime + (float)i * spawnDelay);
            modifier.get((Object)spawner);
            if (!Vars.net.client()) {
                spawner.add();
            }
            ++i;
        }
        return true;
    }

    public static boolean spawnUnit(Team team, float x, float y, float angle, float spawnRange, float spawnReloadTime, float spawnDelay, UnitType type, int spawnNum) {
        return NHFunc.spawnUnit(team, x, y, angle, spawnRange, spawnReloadTime, spawnDelay, type, spawnNum, (Cons<Spawner>)((Cons)t -> {}));
    }

    public static boolean spawnUnit(Team team, float x, float y, float angle, float spawnRange, float spawnReloadTime, float spawnDelay, UnitType type, int spawnNum, StatusEffect statusEffect, float statusDuration) {
        return NHFunc.spawnUnit(team, x, y, angle, spawnRange, spawnReloadTime, spawnDelay, type, spawnNum, (Cons<Spawner>)((Cons)s -> s.setStatus(statusEffect, statusDuration)));
    }

    public static boolean spawnUnit(Team team, float x, float y, float angle, float spawnRange, float spawnReloadTime, float spawnDelay, UnitType type, int spawnNum, StatusEffect statusEffect, float statusDuration, double frag) {
        return NHFunc.spawnUnit(team, x, y, angle, spawnRange, spawnReloadTime, spawnDelay, type, spawnNum, (Cons<Spawner>)((Cons)s -> {
            s.setStatus(statusEffect, statusDuration);
            s.flagToApply = frag;
        }));
    }

    public static void spawnSingleUnit(Team team, float x, float y, float angle, float delay, UnitType type) {
        Spawner spawner = (Spawner)Pools.obtain(Spawner.class, Spawner::new);
        spawner.init(type, team, (Position)vec21.set(x, y), angle, delay);
        if (!Vars.net.client()) {
            spawner.add();
        }
    }

    public static void spawnSingleUnit(Team team, float x, float y, float angle, float delay, UnitType type, Cons<Spawner> modifier) {
        Spawner spawner = (Spawner)Pools.obtain(Spawner.class, Spawner::new);
        spawner.init(type, team, (Position)vec21.set(x, y), angle, delay);
        modifier.get((Object)spawner);
        if (!Vars.net.client()) {
            spawner.add();
        }
    }

    public static <T> void shuffle(Seq<T> seq, Rand rand) {
        Object[] items = seq.items;
        for (int i = seq.size - 1; i >= 0; --i) {
            int ii = Mathf.random((int)i);
            Object temp = items[i];
            items[i] = items[ii];
            items[ii] = temp;
        }
    }

    public static Rand rand(long id) {
        rand.setSeed(id);
        return rand;
    }
}

