/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.util.func;

public class NHMath {
    public static final float PI = (float)Math.PI;
    public static final float pi = (float)Math.PI;
    public static final float halfPi = 1.5707964f;
    public static final float radiansToDegrees = 57.295776f;
    public static final float degreesToRadians = (float)Math.PI / 180;
    private static final int asinBits = 14;
    private static final int asinMask = 16383;
    private static final int asinCount = 16384;
    private static final float[] asinTable = new float[16384];
    private static final float radFull = (float)Math.PI * 2;
    private static final float sinToIndex = 8192.0f;

    public static int index(float sin) {
        return (int)((sin + 1.0f) * 8192.0f) & 0x3FFF;
    }

    public static float acosRad(float cos) {
        return asinTable[NHMath.index((float)Math.sqrt(1.0f - cos * cos))];
    }

    public static float asinDeg(float sin) {
        return asinTable[NHMath.index(sin)] * 57.295776f;
    }

    static {
        for (int i = 0; i < 16384; ++i) {
            NHMath.asinTable[i] = (float)(Math.asin(((float)i + 0.5f) / 16384.0f * 2.0f - 1.0f) + 6.2831854820251465);
        }
        NHMath.asinTable[0] = 4.712389f;
        NHMath.asinTable[NHMath.asinTable.length - 1] = 7.853982f;
        NHMath.asinTable[NHMath.index((float)1.5f)] = 7.853982f;
        NHMath.asinTable[NHMath.index((float)0.5f)] = 10.995575f;
    }
}

