/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.util.game;

import arc.Core;
import arc.Events;
import arc.math.Mathf;
import arc.math.geom.Vec2;
import arc.struct.ObjectFloatMap;
import arc.struct.Seq;
import arc.util.Interval;
import arc.util.Nullable;
import arc.util.Reflect;
import mindustry.Vars;
import mindustry.core.World;
import mindustry.entities.units.BuildPlan;
import mindustry.game.EventType;
import mindustry.input.InputHandler;
import mindustry.input.MobileInput;
import mindustry.type.Item;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.Floor;
import mindustry.world.blocks.production.Drill;
import newhorizon.expand.block.environment.OreVein;

public class UpdateProxy {
    private static final Interval timer = new Interval(10);
    private static final ObjectFloatMap<Item> oreCount = new ObjectFloatMap();
    private static final Seq<Item> itemArray = new Seq();
    private static final Seq<Tile> tempTiles = new Seq();
    @Nullable
    private static Item returnItem;
    private static int returnCount;
    private static final Seq<Drill> registerDrills;

    public static void init() {
        Vars.content.blocks().each(block -> {
            if (block instanceof Drill) {
                registerDrills.add((Object)((Drill)block));
            }
        });
        Thread thread = new Thread(() -> {
            Events.run((Object)EventType.Trigger.draw, () -> {
                InputHandler input = Vars.control.input;
                Block patt1454$temp = input.block;
                if (patt1454$temp instanceof Drill) {
                    Drill drill = (Drill)patt1454$temp;
                    Tile tile = null;
                    if (Vars.mobile) {
                        for (BuildPlan plan : input.selectPlans) {
                            if (plan.breaking || plan != ((MobileInput)input).lastPlaced || plan.block == null) continue;
                            tile = plan.tile();
                        }
                    } else {
                        Vec2 vec = Core.input.mouseWorld((float)Core.input.mouseX(), (float)Core.input.mouseY());
                        if (input.selectedBlock()) {
                            vec.sub(input.block.offset, input.block.offset);
                        }
                        int worldX = World.toTile((float)vec.x);
                        int worldY = World.toTile((float)vec.y);
                        tile = Vars.world.tile(worldX, worldY);
                    }
                    if (tile != null) {
                        UpdateProxy.countOreForDrill(drill, tile);
                        UpdateProxy.updateDrillStat(drill, tile);
                    }
                }
            });
            Events.run((Object)EventType.Trigger.afterGameUpdate, () -> {
                if (timer.get(0, 60.0f)) {
                    Vars.state.teams.getActive().each(teamData -> registerDrills.each(drill -> {
                        Seq buildings = (Seq)teamData.buildingTypes.get(drill);
                        if (buildings != null && !buildings.isEmpty()) {
                            ((Seq)teamData.buildingTypes.get(drill)).each(building -> {
                                if (building instanceof Drill.DrillBuild) {
                                    Drill.DrillBuild drillBuild = (Drill.DrillBuild)building;
                                    UpdateProxy.countOreForDrill(drill, drillBuild.tile);
                                    UpdateProxy.updateDrill(drillBuild);
                                }
                            });
                        }
                    }));
                }
            });
        });
        thread.setPriority(4);
        thread.setDaemon(true);
        thread.start();
    }

    public static void countOreForDrill(Drill drill, Tile tile) {
        returnItem = null;
        returnCount = 0;
        oreCount.clear();
        itemArray.clear();
        for (Tile other : tile.getLinkedTilesAs((Block)drill, tempTiles)) {
            if (!drill.canMine(other)) continue;
            Floor floor = other.overlay();
            if (floor instanceof OreVein) {
                OreVein ore = (OreVein)floor;
                oreCount.increment((Object)drill.getDrop(other), 0.0f, ore.density);
                continue;
            }
            oreCount.increment((Object)drill.getDrop(other), 0.0f, 1.0f);
        }
        for (Item item : oreCount.keys()) {
            itemArray.add((Object)item);
        }
        itemArray.sort((item1, item2) -> {
            int type = Boolean.compare(!item1.lowPriority, !item2.lowPriority);
            if (type != 0) {
                return type;
            }
            int amounts = Integer.compare(Mathf.round((float)oreCount.get(item1, 0.0f)), Mathf.round((float)oreCount.get(item2, 0.0f)));
            if (amounts != 0) {
                return amounts;
            }
            return Integer.compare(item1.id, item2.id);
        });
        if (UpdateProxy.itemArray.size == 0) {
            return;
        }
        returnItem = (Item)itemArray.peek();
        returnCount = Mathf.round((float)oreCount.get((Object)((Item)itemArray.peek()), 0.0f));
    }

    public static void updateDrillStat(Drill drill, Tile tile) {
        Reflect.set(Drill.class, (Object)drill, (String)"returnItem", (Object)returnItem);
        Reflect.set(Drill.class, (Object)drill, (String)"returnCount", (Object)100);
        drill.drawPlaceText(returnCount + "", (int)tile.x, tile.y + 1, true);
    }

    public static void updateDrill(Drill.DrillBuild building) {
        building.dominantItems = returnCount;
        building.dominantItem = returnItem;
    }

    static {
        registerDrills = new Seq();
    }
}

