/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.util.struct;

import arc.struct.Queue;

public class TimeQueue<T extends Timed> {
    public Queue<T> queue = new Queue();
    public T current;

    public void add(T item) {
        this.queue.addFirst(item);
    }

    public void addAll(T ... items) {
        for (T item : items) {
            this.queue.addFirst(item);
        }
    }

    public void clear() {
        this.queue.clear();
        this.current = null;
    }

    public void update() {
        if (this.current == null && !this.queue.isEmpty()) {
            this.current = (Timed)this.queue.removeLast();
            this.current.begin();
        }
        if (this.current != null && this.current.complete()) {
            this.current.end();
            this.current = null;
        }
        if (this.current != null && !this.current.complete()) {
            this.current.update();
        }
    }

    public boolean complete() {
        return this.current == null && this.queue.isEmpty();
    }

    public static interface Timed {
        public void begin();

        public void update();

        public void end();

        public boolean complete();
    }
}

