/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.util.struct;

import arc.func.Boolf;
import arc.func.Cons;
import arc.func.Floatc2;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.struct.FloatSeq;
import arc.struct.Seq;
import arc.util.Eachable;
import java.util.Iterator;
import newhorizon.util.annotation.CacheBanned;

public class Vec2Seq
implements Iterable<Vec2>,
Eachable<Vec2> {
    private final FloatSeq coordinates;
    private final Vec2 tmp = new Vec2();

    public Vec2Seq() {
        this.coordinates = new FloatSeq(true, 8);
    }

    public Vec2Seq(int length) {
        this.coordinates = new FloatSeq(true, length * 2);
    }

    public Vec2Seq(Seq<Vec2> vec2s) {
        this(vec2s.size / 2);
        this.addAll((Iterable<Vec2>)vec2s);
    }

    public Vec2Seq(FloatSeq vec2s) {
        this.coordinates = FloatSeq.with((float[])((float[])vec2s.items.clone()));
        if (this.coordinates.size % 2 == 1) {
            this.coordinates.pop();
        }
    }

    public Vec2Seq(float[] vec2s) {
        this(vec2s.length / 2);
        this.coordinates.items = vec2s;
        this.coordinates.size = vec2s.length;
    }

    public int size() {
        return this.coordinates.size / 2;
    }

    public FloatSeq getCoordinates() {
        return this.coordinates;
    }

    public FloatSeq coordinates() {
        return this.coordinates;
    }

    public boolean any() {
        return this.size() > 0;
    }

    public void add(float x, float y) {
        this.coordinates.add(x, y);
    }

    public void add(Vec2 vec2) {
        this.add(vec2.x, vec2.y);
    }

    public void add(Position vec2) {
        this.add(vec2.getX(), vec2.getY());
    }

    public void addAll(FloatSeq arr) {
        for (int i = 0; i < arr.size / 2; ++i) {
            this.add(arr.get(i), arr.get(i + 1));
        }
    }

    public void addAll(float[] arr) {
        for (int i = 0; i < arr.length / 2; ++i) {
            this.add(arr[i], arr[i + 1]);
        }
    }

    public void addAll(Iterable<Vec2> vecs) {
        for (Vec2 v : vecs) {
            this.add(v);
        }
    }

    public void addAll(Vec2[] vec2s) {
        for (Vec2 vec2 : vec2s) {
            this.add(vec2);
        }
    }

    public Vec2Seq addAll(Vec2Seq vec2s) {
        vec2s.each(this::add);
        return this;
    }

    public Vec2Seq copy() {
        return new Vec2Seq((float[])this.coordinates.items.clone());
    }

    public int count(Boolf<Vec2> bf) {
        int i = 0;
        Vec2 vec2 = new Vec2();
        for (int j = 0; j < this.size(); ++j) {
            if (!bf.get((Object)this.setVec2(j, vec2))) continue;
            ++i;
        }
        return i;
    }

    public boolean contains(Boolf<Vec2> bf) {
        Vec2 vec2 = new Vec2();
        for (int j = 0; j < this.size(); ++j) {
            this.setVec2(j, vec2);
            if (!bf.get((Object)vec2)) continue;
            return true;
        }
        return false;
    }

    public Seq<Vec2> asSeq() {
        Seq seq = new Seq(true, this.size());
        for (int j = 0; j < this.size(); ++j) {
            seq.add((Object)this.newVec2(j));
        }
        return seq;
    }

    public Vec2 currentTmp() {
        return this.tmp;
    }

    @CacheBanned
    public Vec2 tmpVec2(int index) {
        return this.tmp.set(this.coordinates.items[index * 2], this.coordinates.items[index * 2 + 1]);
    }

    public Vec2 setVec2(int index, Vec2 vec2) {
        return vec2.set(this.coordinates.items[index * 2], this.coordinates.items[index * 2 + 1]);
    }

    public Vec2 newVec2(int index) {
        return new Vec2(this.coordinates.items[index * 2], this.coordinates.items[index * 2 + 1]);
    }

    public void get(int index, Floatc2 operator) {
        operator.get(this.coordinates.items[index * 2], this.coordinates.items[index * 2 + 1]);
    }

    public void remove(int index) {
        this.coordinates.removeRange(index * 2, index * 2 + 1);
    }

    public void removeRange(int start, int end) {
        this.coordinates.removeRange(start * 2, end * 2 + 1);
    }

    public void removeFirst() {
        this.remove(0);
    }

    public void removeLast() {
        this.remove(this.size() - 1);
    }

    public Vec2 firstTmp() {
        return this.tmpVec2(0);
    }

    public Vec2 peekTmp() {
        return this.tmpVec2(this.size() - 1);
    }

    public Vec2 popTmp() {
        this.peekTmp();
        this.removeLast();
        return this.tmp;
    }

    public void each(Floatc2 f) {
        for (int i = 0; i < this.size(); ++i) {
            f.get(this.coordinates.items[i * 2], this.coordinates.items[i * 2 + 1]);
        }
    }

    public boolean check() {
        return this.coordinates.size % 2 == 0;
    }

    public void each(Cons<? super Vec2> cons) {
        for (int i = 0; i < this.size(); ++i) {
            cons.get((Object)this.tmpVec2(i));
        }
    }

    @Override
    public Iterator<Vec2> iterator() {
        return this.asSeq().iterator();
    }
}

