/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.util.ui;

import arc.Core;
import arc.func.Cons;
import arc.func.Prov;
import arc.scene.Element;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.ButtonGroup;
import arc.scene.ui.ImageButton;
import arc.scene.ui.ScrollPane;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Nullable;
import mindustry.Vars;
import mindustry.gen.Tex;
import mindustry.ui.Styles;
import mindustry.world.Block;

public class ContentSelectionTable {
    public static void buildModuleTable(@Nullable Block block, Table table, Seq<Block> items, Prov<Block> holder, Cons<Block> consumer) {
        ButtonGroup group = new ButtonGroup();
        group.setMinCheckCount(0);
        Table cont = new Table().top();
        cont.defaults().size(240.0f, 48.0f);
        Runnable rebuild = () -> {
            group.clear();
            cont.clearChildren();
            for (Block item : items) {
                if (!item.unlockedNow()) continue;
                ImageButton button = (ImageButton)cont.button(Tex.whiteui, Styles.clearNoneTogglei, 48.0f, () -> Vars.control.input.config.hideConfig()).group(group).get();
                button.table(t -> t.label(() -> item.localizedName).size(180.0f, 0.0f)).padLeft(6.0f).padRight(6.0f);
                button.changed(() -> consumer.get(button.isChecked() ? item : null));
                button.getStyle().imageUp = new TextureRegionDrawable(item.uiIcon);
                button.update(() -> button.setChecked(holder.get() == item));
                cont.row();
            }
        };
        rebuild.run();
        Table main = new Table().background(Styles.black6);
        ScrollPane pane = new ScrollPane((Element)cont, Styles.smallPane);
        pane.setScrollingDisabled(true, false);
        pane.exited(() -> {
            if (pane.hasScroll()) {
                Core.scene.setScrollFocus(null);
            }
        });
        if (block != null) {
            pane.setScrollYForce(block.selectScroll);
            pane.update(() -> {
                block.selectScroll = pane.getScrollY();
            });
        }
        pane.setOverscroll(false, false);
        main.add((Element)pane).maxHeight(192.0f);
        table.top().add((Element)main);
    }
}

