/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.util.ui;

import arc.func.Intp;
import arc.func.Prov;
import arc.graphics.Color;
import arc.graphics.g2d.TextureRegion;
import arc.scene.Element;
import arc.scene.style.Style;
import arc.scene.ui.Image;
import arc.scene.ui.layout.Stack;
import arc.scene.ui.layout.Table;
import arc.util.Scaling;
import mindustry.core.UI;
import mindustry.graphics.Pal;
import mindustry.type.Item;
import mindustry.ui.Styles;
import mindustry.world.modules.ItemModule;

public class ItemImageDynamic
extends Stack {
    public ItemImageDynamic(TextureRegion region, Intp amountp, Prov<Color> colorProv) {
        this.add((Element)new Table(o -> {
            o.left();
            o.add((Element)new Image(region)).size(32.0f).scaling(Scaling.fit);
        }));
        this.add((Element)new Table(t -> {
            t.left().bottom();
            t.label(() -> {
                int amount = amountp.get();
                return amount >= 1000 ? UI.formatAmount((long)amount) : amount + "";
            }).style((Style)Styles.outlineLabel).color((Color)colorProv.get());
            t.pack();
        }));
    }

    public ItemImageDynamic(Item item, Intp amountp) {
        this(item.uiIcon, amountp, (Prov<Color>)((Prov)() -> Color.lightGray));
    }

    public ItemImageDynamic(Item item, Intp amountp, ItemModule module) {
        this(item.uiIcon, amountp, (Prov<Color>)((Prov)() -> module.has(item, amountp.get()) ? Color.white : Pal.redderDust));
    }
}

