/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.util.ui;

import arc.Core;
import arc.audio.Sound;
import arc.func.Cons;
import arc.graphics.Color;
import arc.math.Interp;
import arc.scene.Action;
import arc.scene.Element;
import arc.scene.actions.Actions;
import arc.scene.event.Touchable;
import arc.scene.style.Drawable;
import arc.scene.ui.Label;
import arc.scene.ui.ScrollPane;
import arc.scene.ui.layout.Table;
import arc.struct.OrderedMap;
import arc.struct.Seq;
import arc.util.Scaling;
import arc.util.Time;
import mindustry.Vars;
import mindustry.ctype.UnlockableContent;
import mindustry.gen.Icon;
import mindustry.gen.Tex;
import mindustry.graphics.Pal;
import mindustry.ui.Links;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatCat;
import mindustry.world.meta.StatValue;
import mindustry.world.meta.Stats;
import newhorizon.NHUI;
import newhorizon.NHVars;
import newhorizon.util.annotation.HeadlessDisabled;
import newhorizon.util.func.NHInterp;

public class NHUIFunc {
    private static long lastToast;
    private static long waiting;

    public static void init() {
    }

    public static void show(Table p, UnlockableContent content) {
        p.clear();
        Table table = new Table();
        table.margin(10.0f);
        content.checkStats();
        table.table(title1 -> {
            title1.image(content.uiIcon).size(48.0f).scaling(Scaling.fit);
            title1.add((CharSequence)("[accent]" + content.localizedName + (Core.settings.getBool("console") ? "\n[gray]" + content.name : ""))).padLeft(5.0f);
        });
        table.row();
        if (content.description != null) {
            boolean any;
            boolean bl = any = content.stats.toMap().size > 0;
            if (any) {
                table.add((CharSequence)"@category.purpose").color(Pal.accent).fillX().padTop(10.0f);
                table.row();
            }
            table.add((CharSequence)("[lightgray]" + content.displayDescription())).wrap().fillX().padLeft(any ? 10.0f : 0.0f).width(500.0f).padTop(any ? 0.0f : 10.0f).left();
            table.row();
            if (!content.stats.useCategories && any) {
                table.add((CharSequence)"@category.general").fillX().color(Pal.accent);
                table.row();
            }
        }
        Stats stats = content.stats;
        for (StatCat cat : stats.toMap().keys()) {
            OrderedMap map = (OrderedMap)stats.toMap().get((Object)cat);
            if (map.size == 0) continue;
            if (stats.useCategories) {
                table.add((CharSequence)("@category." + cat.name)).color(Pal.accent).fillX();
                table.row();
            }
            for (Stat stat : map.keys()) {
                table.table(inset -> {
                    inset.left();
                    inset.add((CharSequence)("[lightgray]" + stat.localized() + ":[] ")).left().top();
                    Seq arr = (Seq)map.get((Object)stat);
                    for (StatValue value : arr) {
                        value.display(inset);
                        inset.add().size(10.0f);
                    }
                }).fillX().padLeft(10.0f);
                table.row();
            }
        }
        if (content.details != null) {
            table.add((CharSequence)("[gray]" + (content.unlocked() || !content.hideDetails ? content.details : "\ue88d " + Core.bundle.get("unlock.incampaign")))).pad(6.0f).padTop(20.0f).width(400.0f).wrap().fillX();
            table.row();
        }
        content.displayExtra(table);
        ScrollPane pane = new ScrollPane((Element)table);
        p.add((Element)pane);
    }

    @HeadlessDisabled
    public static void showLabel(final float duration, Cons<Table> modifier) {
        if (Vars.state.isMenu() || Vars.headless) {
            return;
        }
        NHUIFunc.scheduleToast(duration, () -> {
            if (Vars.state.isMenu()) {
                return;
            }
            Table table = new Table(){
                {
                    this.touchable = Touchable.disabled;
                    this.update(() -> {
                        if (Vars.state.isMenu()) {
                            this.remove();
                        }
                        this.setWidth(NHUI.getWidth());
                        this.setPosition(0.0f, (NHUI.getHeight() - this.height) / 2.0f);
                    });
                    this.color.a(0.0f);
                    this.actions(new Action[]{Actions.fadeIn((float)0.45f, (Interp)NHInterp.bounce5Out), Actions.delay((float)duration), Actions.fadeOut((float)0.5f), Actions.remove()});
                }
            }.margin(4.0f);
            modifier.get((Object)table);
            table.pack();
            table.act(0.0f);
            NHVars.cutsceneUI.overlay.addChild((Element)table);
        });
    }

    @HeadlessDisabled
    private static void scheduleToast(float time, Runnable run) {
        if (waiting > 5L) {
            return;
        }
        long duration = (int)((time + 1.25f) * 1000.0f);
        long since = Time.timeSinceMillis((long)lastToast);
        if (since > duration) {
            lastToast = Time.millis();
            run.run();
        } else {
            ++waiting;
            Time.runTask((float)((float)(duration - since) / 1000.0f * 60.0f), () -> {
                --waiting;
                run.run();
            });
            lastToast += duration;
        }
    }

    private static void scheduleToast(Runnable run) {
        long duration = 3500L;
        long since = Time.timeSinceMillis((long)lastToast);
        if (since > duration) {
            lastToast = Time.millis();
            run.run();
        } else {
            Time.runTask((float)((float)(duration - since) / 1000.0f * 60.0f), (Runnable)run);
            lastToast += duration;
        }
    }

    public static void showToast(Drawable icon, String text, Sound sound) {
        if (Vars.state.isMenu()) {
            return;
        }
        if (Vars.headless) {
            return;
        }
        NHUIFunc.scheduleToast(() -> {
            sound.play();
            Table table = new Table(Tex.pane2);
            table.update(() -> {
                if (Vars.state.isMenu() || !Vars.ui.hudfrag.shown) {
                    table.remove();
                }
            });
            table.margin(12.0f);
            table.image(icon).size(48.0f).scaling(Scaling.fit).pad(-4.0f).padLeft(12.0f);
            ((Label)table.add((CharSequence)text).wrap().width(280.0f).get()).setAlignment(1, 1);
            table.pack();
            Table container = Core.scene.table();
            container.top().add((Element)table);
            container.setTranslation(0.0f, table.getPrefHeight());
            container.actions(new Action[]{Actions.translateBy((float)0.0f, (float)(-table.getPrefHeight()), (float)1.0f, (Interp)Interp.fade), Actions.delay((float)2.5f), Actions.run(() -> container.actions(new Action[]{Actions.translateBy((float)0.0f, (float)table.getPrefHeight(), (float)1.0f, (Interp)Interp.fade), Actions.remove()}))});
        });
    }

    public static class LinkTable
    extends Table {
        protected static float h = Core.graphics.isPortrait() ? 90.0f : 80.0f;
        protected static float w = Core.graphics.isPortrait() ? 330.0f : 600.0f;

        public LinkTable(Links.LinkEntry link) {
            this.background(Tex.underline);
            this.margin(0.0f);
            this.table(img -> {
                img.image().height(h - 6.0f).width(60.0f).color(link.color);
                img.row();
                img.image().height(6.0f).width(60.0f).color(link.color.cpy().mul(0.8f, 0.8f, 0.8f, 1.0f));
            }).expandY();
            this.table(i -> {
                i.background(Tex.buttonEdge3);
                i.image(link.icon);
            }).size(h - 6.0f, h);
            this.table(inset -> {
                inset.add((CharSequence)("[accent]" + link.title)).growX().left();
                inset.row();
                inset.labelWrap(link.description).width(w - 60.0f).color(Color.lightGray).growX();
            }).padLeft(8.0f);
            this.button((Drawable)Icon.link, () -> {
                if (!Core.app.openURI(link.link)) {
                    Vars.ui.showErrorMessage("@linkfail");
                    Core.app.setClipboardText(link.link);
                }
            }).size(h);
        }

        public static void sync() {
            h = Core.graphics.isPortrait() ? 90.0f : 80.0f;
            w = Core.graphics.isPortrait() ? 300.0f : 600.0f;
        }
    }
}

