/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.util.ui;

import arc.func.Boolp;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.math.Interp;
import arc.math.Mathf;
import arc.scene.Action;
import arc.scene.Element;
import arc.scene.actions.Actions;
import mindustry.graphics.Pal;

public class ObjectiveSign
extends Element {
    public Color outerColor = Color.lightGray;
    public Color innerColor = Pal.accent;
    public float margin = 6.0f;
    public float outerStroke = 6.0f;
    public float pad = 7.0f;
    public Boolp trigger = () -> false;
    public boolean finished = false;
    protected float lerpAlpha = 1.0f;
    protected float outerSize = 12.0f;
    protected float innerSize = 6.0f;

    public ObjectiveSign() {
    }

    public ObjectiveSign(Color outerColor, Color innerColor, float margin, float outerStroke, float pad, Boolp trigger) {
        this.outerColor = outerColor;
        this.innerColor = innerColor;
        this.margin = margin;
        this.outerStroke = outerStroke;
        this.pad = pad;
        this.trigger = trigger;
    }

    public Element setTrigger(Boolp boolp) {
        this.trigger = boolp;
        return this;
    }

    public void setFinished(boolean b) {
        this.finished = b;
    }

    public void setMargin(float margin) {
        this.margin = margin;
    }

    public void draw() {
        super.draw();
        Draw.color((Color)this.innerColor);
        Draw.alpha((float)this.color.a);
        Fill.square((float)(this.x + this.width / 2.0f), (float)(this.y + this.height / 2.0f), (float)this.innerSize, (float)45.0f);
        Draw.color((Color)this.innerColor);
        Draw.alpha((float)(this.lerpAlpha * this.color.a));
        Fill.square((float)(this.x + this.width / 2.0f), (float)(this.y + this.height / 2.0f), (float)(this.innerSize * (3.0f - this.lerpAlpha * 2.0f)), (float)45.0f);
        Lines.stroke((float)this.outerStroke);
        Draw.color((Color)this.innerColor, (Color)this.outerColor, (float)this.lerpAlpha);
        Draw.alpha((float)this.color.a);
        Lines.square((float)(this.x + this.width / 2.0f), (float)(this.y + this.height / 2.0f), (float)((this.outerSize - this.outerStroke / 2.0f) * this.color.a), (float)45.0f);
        Draw.color();
    }

    public void act(float delta) {
        super.act(delta);
        if (!this.finished) {
            this.finished = this.trigger.get();
        } else {
            this.lerpAlpha = Mathf.approachDelta((float)this.lerpAlpha, (float)0.0f, (float)0.075f);
        }
        if (this.hasParent()) {
            this.color.a(this.parent.color.a);
        }
        this.outerSize = Math.max(Math.min(this.width, this.height) - this.margin * 2.0f, 0.0f) / 2.0f * Mathf.sqrt2;
        this.innerSize = Math.max(this.outerSize - this.pad * 2.0f, 0.0f) / 2.0f * Mathf.sqrt2;
    }

    public void fadeOut() {
        this.actions(new Action[]{Actions.delay((float)1.5f), Actions.alpha((float)0.0f, (float)0.45f, (Interp)Interp.fade), Actions.remove()});
    }
}

