/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.util.ui;

import arc.Core;
import arc.func.Boolp;
import arc.func.Cons;
import arc.func.Floatp;
import arc.func.Prov;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.input.KeyCode;
import arc.math.Angles;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.math.geom.Vec2;
import arc.scene.Action;
import arc.scene.Element;
import arc.scene.actions.Actions;
import arc.scene.event.EventListener;
import arc.scene.event.InputEvent;
import arc.scene.event.InputListener;
import arc.scene.event.Touchable;
import arc.scene.style.Drawable;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.Image;
import arc.scene.ui.Label;
import arc.scene.ui.ScrollPane;
import arc.scene.ui.TextArea;
import arc.scene.ui.Tooltip;
import arc.scene.ui.layout.Table;
import arc.util.Log;
import arc.util.Time;
import arc.util.Tmp;
import java.lang.reflect.Field;
import java.text.DecimalFormat;
import mindustry.Vars;
import mindustry.content.UnitTypes;
import mindustry.core.UI;
import mindustry.core.World;
import mindustry.entities.EntityGroup;
import mindustry.entities.bullet.BulletType;
import mindustry.game.Team;
import mindustry.gen.Groups;
import mindustry.gen.Icon;
import mindustry.gen.Player;
import mindustry.gen.Tex;
import mindustry.graphics.Pal;
import mindustry.type.Item;
import mindustry.type.ItemStack;
import mindustry.type.UnitType;
import mindustry.ui.Links;
import mindustry.ui.Styles;
import mindustry.world.Tile;
import mindustry.world.modules.ItemModule;
import newhorizon.NewHorizon;
import newhorizon.expand.entities.UltFire;
import newhorizon.util.PixelArtGenerator;
import newhorizon.util.func.NHFunc;
import newhorizon.util.ui.NHUIFunc;
import newhorizon.util.ui.dialog.DebugDialog;

public class TableFunc {
    public static final String tabSpace = "    ";
    public static final float LEN = 60.0f;
    public static final float OFFSET = 12.0f;
    public static final TextArea textArea = Vars.headless ? null : new TextArea("");
    private static final Vec2 ctrlVec = new Vec2();
    private static final int tableZ = 2;
    private static final DecimalFormat df = new DecimalFormat("######0.0");
    private static final Vec2 point = new Vec2(-1.0f, -1.0f);
    private static final Table starter = new Table(Tex.paneSolid){};
    private static int tmpX = 0;
    private static int tmpY = 0;
    private static int spawnNum = 1;
    private static Team selectTeam = Team.sharded;
    private static UnitType selected = UnitTypes.alpha;
    private static long lastToast;
    private static Table pTable;
    private static Table floatTable;

    public static String format(float value) {
        return df.format(value);
    }

    public static String judge(boolean value) {
        return value ? "[heal]" + Core.bundle.get("yes") + "[]" : "[#ff7b69]" + Core.bundle.get("no") + "[]";
    }

    public static String getPercent(float value) {
        return Mathf.floor((float)(value * 100.0f)) + "%";
    }

    private static boolean pointValid() {
        return TableFunc.point.x >= 0.0f && TableFunc.point.y >= 0.0f && TableFunc.point.x <= (float)(Vars.world.width() * 8) && TableFunc.point.y <= (float)(Vars.world.height() * 8);
    }

    public static int getLineNum(String string) {
        string.replaceAll("\r", "\n");
        return string.split("\n").length;
    }

    public static void disableTable() {
        Core.scene.root.removeChild((Element)starter);
    }

    public static void showTable() {
        Core.scene.root.addChildAt(3, (Element)starter);
    }

    public static void showInner(Table parent, Table children) {
        Inner inner = new Inner();
        parent.addChildAt(parent.getZIndex() + 1, (Element)inner);
        inner.init(parent.getWidth() + children.getWidth() + 12.0f);
        children.fill().pack();
        children.setTransform(true);
        inner.addChildAt(parent.getZIndex() + 2, (Element)children);
        inner.setScale(parent.scaleX, parent.scaleY);
        children.setScale(parent.scaleX, parent.scaleY);
        children.setPosition(inner.getWidth() - children.getWidth(), inner.y + (inner.getHeight() - children.getHeight()) / 2.0f);
        inner.actions(new Action[]{Actions.moveTo((float)0.0f, (float)inner.y, (float)0.35f, (Interp)Interp.pow3Out)});
    }

    public static void tableMain() {
        if (Vars.headless) {
            return;
        }
        starter.setSize(72.0f, 216.0f);
        starter.update(() -> {
            starter.setPosition(0.0f, ((float)Core.graphics.getHeight() - starter.getHeight()) / 2.0f);
            if (Core.input.mouseX() < 120 && TableFunc.starter.x < -1.0f && !starter.hasActions()) {
                starter.actions(new Action[]{Actions.moveTo((float)0.0f, (float)(((float)Core.graphics.getHeight() - starter.getHeight()) / 2.0f), (float)0.1f)});
            } else if (TableFunc.starter.x > -1.0f && !starter.hasActions()) {
                starter.actions(new Action[]{Actions.moveTo((float)(-starter.getWidth()), (float)(((float)Core.graphics.getHeight() - starter.getHeight()) / 2.0f), (float)0.1f)});
            }
        });
        starter.visible(() -> !Vars.state.isMenu() && Vars.ui.hudfrag.shown && (!Vars.net.client() || NewHorizon.DEBUGGING) && TableFunc.starter.color.a > 0.01f);
        starter.touchable(() -> !Vars.state.isMenu() && Vars.ui.hudfrag.shown && !Vars.net.client() ? Touchable.enabled : Touchable.disabled);
        Player player = Vars.player;
        Boolp hasInner = () -> starter.getChildren().contains(e -> "INNER".equals(e.name));
        starter.table(table -> {
            table.defaults().size(starter.getWidth() - 12.0f);
            table.button((Drawable)Icon.settings, Styles.cleari, () -> TableFunc.showInner(starter, new ToolTable())).grow().disabled(b -> hasInner.get()).row();
        }).grow().row();
        Core.scene.root.addChildAt(1, (Element)starter);
    }

    public static void buildBulletTypeInfo(Table t, BulletType type) {
        t.table(table -> {
            Field[] fields;
            if (type == null) {
                return;
            }
            Class<?> typeClass = type.getClass();
            for (Field field : fields = typeClass.getFields()) {
                try {
                    BulletType inner;
                    if (field.getGenericType().toString().equals("boolean")) {
                        table.add((CharSequence)new StringBuilder().append("[gray]").append(field.getName()).append(": ").append(TableFunc.judge(field.getBoolean(type))).append("[]")).left().row();
                    }
                    if (field.getGenericType().toString().equals("float") && field.getFloat(type) > 0.0f) {
                        table.add((CharSequence)new StringBuilder().append("[gray]").append(field.getName()).append(": [accent]").append(field.getFloat(type)).append("[]")).left().row();
                    }
                    if (field.getGenericType().toString().equals("int") && field.getInt(type) > 0) {
                        table.add((CharSequence)new StringBuilder().append("[gray]").append(field.getName()).append(": [accent]").append(field.getInt(type)).append("[]")).left().row();
                    }
                    if (!field.getType().getSimpleName().equals("BulletType") || (inner = (BulletType)field.get(type)) == null || inner.toString().equals("bullet#0") || inner.toString().equals("bullet#1") || inner.toString().equals("bullet#2")) continue;
                    table.add((CharSequence)("[gray]" + field.getName() + "{ ")).left().row();
                    table.table(in -> TableFunc.buildBulletTypeInfo(in, inner)).padLeft(60.0f).row();
                    table.add((CharSequence)"[gray]}").left().row();
                }
                catch (IllegalAccessException err) {
                    throw new RuntimeException(err);
                }
            }
        }).row();
    }

    public static Table tableImageShrink(TextureRegion tex, float size, Table table) {
        return TableFunc.tableImageShrink(tex, size, table, (Cons<Image>)((Cons)c -> {}));
    }

    public static Table tableImageShrink(TextureRegion tex, float size, Table table, Cons<Image> modifier) {
        float parma = Math.max(tex.height, tex.width);
        float f = Math.min(size, parma);
        Image image = new Image(tex);
        modifier.get((Object)image);
        table.add((Element)image).size((float)tex.width * f / parma, (float)tex.height * f / parma);
        return table;
    }

    public static void itemStack(Table parent, ItemStack stack, ItemModule itemModule) {
        float size = 48.0f;
        parent.table(t -> {
            t.image(stack.item.fullIcon).size(size).left();
            t.table(n -> {
                Label l = new Label((CharSequence)"");
                n.add((CharSequence)(stack.item.localizedName + " ")).left();
                n.add((Element)l).left();
                n.add((CharSequence)("/" + UI.formatAmount((long)stack.amount))).left().growX();
                n.update(() -> {
                    int amount = itemModule == null ? 0 : itemModule.get(stack.item);
                    l.setText((CharSequence)UI.formatAmount((long)amount));
                    l.setColor(amount < stack.amount ? Pal.redderDust : Color.white);
                });
            }).growX().height(size).padLeft(6.0f).left();
        }).growX().height(size).left().row();
    }

    public static void selectPos(Table parentT, Cons<Point2> cons) {
        Prov original = parentT.touchablility;
        Touchable parentTouchable = parentT.touchable;
        parentT.touchablility = () -> Touchable.disabled;
        if (!pTable.hasParent()) {
            ctrlVec.set(Core.camera.unproject(Core.input.mouse()));
        }
        if (!pTable.hasParent()) {
            pTable = new Table(Tex.clear){
                {
                    this.update(() -> {
                        if (Vars.state.isMenu()) {
                            this.remove();
                        } else {
                            Vec2 v = Core.camera.project((float)(World.toTile((float)ctrlVec.x) * 8), (float)(World.toTile((float)ctrlVec.y) * 8));
                            this.setPosition(v.x, v.y, 0);
                        }
                    });
                }

                public void draw() {
                    super.draw();
                    Lines.stroke((float)9.0f, (Color)Pal.gray);
                    this.drawLines();
                    Lines.stroke((float)3.0f, (Color)Pal.accent);
                    this.drawLines();
                }

                private void drawLines() {
                    Lines.square((float)this.x, (float)this.y, (float)28.0f, (float)45.0f);
                    Lines.line((float)(this.x - 48.0f), (float)this.y, (float)0.0f, (float)this.y);
                    Lines.line((float)(this.x + 48.0f), (float)this.y, (float)Core.graphics.getWidth(), (float)this.y);
                    Lines.line((float)this.x, (float)(this.y - 48.0f), (float)this.x, (float)0.0f);
                    Lines.line((float)this.x, (float)(this.y + 48.0f), (float)this.x, (float)Core.graphics.getHeight());
                }
            };
        }
        if (!pTable.hasParent()) {
            floatTable = new Table(Tex.clear){
                {
                    this.update(() -> {
                        if (Vars.state.isMenu()) {
                            this.remove();
                        }
                    });
                    this.touchable = Touchable.enabled;
                    this.setFillParent(true);
                    this.addListener((EventListener)new InputListener(){

                        public boolean touchDown(InputEvent event, float x, float y, int pointer, KeyCode button) {
                            ctrlVec.set(Core.camera.unproject(x, y));
                            return false;
                        }
                    });
                }
            };
        }
        pTable.button((Drawable)Icon.cancel, Styles.emptyi, () -> {
            cons.get((Object)Tmp.p1.set(World.toTile((float)TableFunc.ctrlVec.x), World.toTile((float)TableFunc.ctrlVec.y)));
            parentT.touchablility = original;
            parentT.touchable = parentTouchable;
            pTable.remove();
            floatTable.remove();
        }).center();
        Core.scene.root.addChildAt(Math.max(parentT.getZIndex() - 1, 0), (Element)pTable);
        Core.scene.root.addChildAt(Math.max(parentT.getZIndex() - 2, 0), (Element)floatTable);
    }

    public static void countdown(Element e, Floatp remainTime) {
        e.addListener((EventListener)new Tooltip(t2 -> {
            t2.background(Tex.bar);
            t2.color.set(Color.black);
            t2.color.a = 0.35f;
            t2.add((CharSequence)"Remain Time: 00:00 ").update(l -> {
                float remain = remainTime.get();
                l.setText((CharSequence)("[gray]Remain Time: " + (remain / 60.0f > 15.0f ? "[]" : "[accent]") + Mathf.floor((float)(remain / 3600.0f)) + ":" + Mathf.floor((float)(remain % 3600.0f / 60.0f))));
            }).left().fillY().growX().row();
        }));
    }

    public static void link(Table parent, Links.LinkEntry link) {
        parent.add((Element)new NHUIFunc.LinkTable(link)).size(NHUIFunc.LinkTable.w + 24.0f, NHUIFunc.LinkTable.h).padTop(6.0f).row();
    }

    static {
        pTable = new Table();
        floatTable = new Table();
    }

    private static class Inner
    extends Table {
        Inner() {
            this.name = "INNER";
            this.background(Tex.paneSolid);
            this.left();
            this.table(table -> table.button((Drawable)Icon.cancel, Styles.cleari, () -> this.actions(new Action[]{Actions.touchable((Touchable)Touchable.disabled), Actions.moveBy((float)(-this.width), (float)0.0f, (float)0.4f, (Interp)Interp.pow3In), Actions.remove()})).width(60.0f).growY()).growY().fillX().padRight(12.0f);
        }

        public void init(float width) {
            this.setSize(width, starter.getHeight());
            this.setPosition(-this.width, starter.originY);
        }
    }

    private static class ToolTable
    extends Table {
        ToolTable() {
            this.setSize((float)Core.graphics.getWidth() / (Vars.mobile ? 2.0f : 4.0f), (float)Core.graphics.getHeight() * 0.75f);
            this.background(Tex.button);
            Table in = new Table(){
                {
                    Label label = new Label((CharSequence)"Spawn");
                    this.update(() -> {
                        label.setText((CharSequence)(Core.bundle.get("waves.perspawn") + ": [accent]" + spawnNum + "[]* | At: " + tmpX + ", " + tmpY));
                        label.setWidth(this.getWidth());
                    });
                    this.add((Element)label).growX().fillY().pad(12.0f).align(10).row();
                    this.button("Copy Coords", (Drawable)Icon.copy, Styles.cleart, () -> Core.app.setClipboardText(tmpX + ", " + tmpY)).growX().marginLeft(12.0f).fillY().row();
                    this.button("Copy Unit Coords", (Drawable)Icon.copy, Styles.cleart, () -> Core.app.setClipboardText(tmpX * 8 + 4 + ", " + (tmpY * 8 + 4))).growX().marginLeft(12.0f).fillY().row();
                    this.pane(con -> {
                        con.button((Drawable)Icon.leftOpen, Styles.cleari, () -> spawnNum = Mathf.clamp((int)(--spawnNum), (int)1, (int)100)).size(42.0f);
                        con.slider(1.0f, 100.0f, 2.0f, (float)spawnNum, f -> spawnNum = (int)f).growX().height(42.0f).padLeft(6.0f).padRight(6.0f);
                        con.button((Drawable)Icon.rightOpen, Styles.cleari, () -> spawnNum = Mathf.clamp((int)(++spawnNum), (int)1, (int)100)).size(42.0f);
                    }).growX().height(60.0f).row();
                    this.table(con -> {
                        con.button("@mod.ui.select-target", (Drawable)Icon.move, Styles.cleart, 60.0f, () -> TableFunc.selectPos(starter, (Cons<Point2>)((Cons)p -> {
                            tmpX = p.x;
                            tmpY = p.y;
                            point.set(World.unconv((float)p.x), World.unconv((float)p.y));
                        }))).grow();
                        con.button((Drawable)Icon.cancel, Styles.cleari, () -> point.set(-1.0f, -1.0f)).size(60.0f);
                    }).growX().height(60.0f).row();
                    ScrollPane p = (ScrollPane)this.pane(table -> {
                        int num = 0;
                        for (UnitType type : Vars.content.units()) {
                            if (type.isHidden()) continue;
                            if (num % 5 == 0) {
                                table.row();
                            }
                            table.button((Drawable)new TextureRegionDrawable(type.fullIcon), Styles.clearTogglei, 60.0f, () -> selected = type).update(b -> b.setChecked(selected == type)).size(60.0f);
                            ++num;
                        }
                    }).fillX().height(180.0f).get();
                    this.row();
                    p.setFadeScrollBars(true);
                    p.setupFadeScrollBars(0.35f, 0.45f);
                    this.keyDown(c -> {
                        if (c == KeyCode.left) {
                            spawnNum = Mathf.clamp((int)(--spawnNum), (int)1, (int)100);
                        }
                        if (c == KeyCode.right) {
                            spawnNum = Mathf.clamp((int)(++spawnNum), (int)1, (int)100);
                        }
                    });
                    Table t = new Table(tin -> {
                        tin.table(con -> {
                            float size = this.getPrefWidth() / 8.0f;
                            con.image((Drawable)Icon.players).size(size).padRight(size);
                            for (Team team : Team.baseTeams) {
                                con.button(Tex.whiteui, Styles.clearTogglei, size - 8.0f, () -> Vars.player.team(team)).update(b -> {
                                    b.setChecked(Vars.player.team() == team);
                                    b.getStyle().imageUpColor = team.color;
                                }).size(size);
                            }
                        }).growX().height(60.0f).row();
                        tin.image().color(Pal.gray).height(4.0f).growX().row();
                        tin.table(con -> {
                            float size = this.getPrefWidth() / 8.0f;
                            con.image((Drawable)Icon.units).size(size).padRight(size);
                            for (Team team : Team.baseTeams) {
                                con.button(Tex.whiteui, Styles.clearTogglei, size - 8.0f, () -> selectTeam = team).update(b -> {
                                    b.setChecked(selectTeam == team);
                                    b.getStyle().imageUpColor = team.color;
                                }).size(size);
                            }
                        }).growX().height(60.0f).row();
                        tin.pane(con -> {
                            con.button("SpawnPos", (Drawable)Icon.link, Styles.cleart, () -> NHFunc.spawnSingleUnit(selected, selectTeam, spawnNum, point.x, point.y)).disabled(b -> !TableFunc.pointValid()).grow();
                            con.button("SpawnCur", (Drawable)Icon.add, Styles.cleart, () -> NHFunc.spawnSingleUnit(selected, selectTeam, spawnNum, Vars.player.x, Vars.player.y)).grow();
                        }).growX().height(60.0f).row();
                        tin.pane(con -> {
                            con.button("Remove Units", Styles.cleart, () -> ((EntityGroup)Groups.unit).clear()).grow();
                            con.button("Remove Fires", Styles.cleart, () -> {
                                for (int i = 0; i < 20; ++i) {
                                    Time.run((float)((float)i * Time.delta * 3.0f), () -> ((EntityGroup)Groups.fire).clear());
                                }
                            }).grow();
                            con.button("Cathc Fires", Styles.cleart, () -> Geometry.circle((int)World.toTile((float)point.x), (int)World.toTile((float)point.y), (int)10, (x1, y1) -> {
                                Tile tile = Vars.world.tile(x1, y1);
                                if (tile != null) {
                                    UltFire.create(tile);
                                }
                            })).disabled(b -> !TableFunc.pointValid()).grow();
                        }).growX().height(60.0f).row();
                        tin.pane(con -> {
                            con.button("Add Items", Styles.cleart, () -> {
                                for (Item item : Vars.content.items()) {
                                    Vars.player.team().core().items.add(item, 1000000);
                                }
                            }).size(120.0f, 60.0f);
                            con.button("Debug", Styles.cleart, () -> new DebugDialog("debug").show()).size(120.0f, 60.0f);
                            con.button("Pixel Art", Styles.cleart, () -> TableFunc.selectPos(starter, (Cons<Point2>)((Cons)po -> {
                                PixelArtGenerator.leftDown.set(po.x, po.y);
                                Log.info((Object)(po.x + " | " + po.y));
                                Core.app.post(() -> TableFunc.selectPos(starter, (Cons<Point2>)((Cons)poi -> {
                                    PixelArtGenerator.rightTop.set(poi.x, poi.y);
                                    Log.info((Object)(poi.x + " | " + poi.y));
                                    Vars.platform.showMultiFileChooser(fi -> {
                                        PixelArtGenerator.toRead = fi;
                                        boolean b = PixelArtGenerator.process();
                                        if (b) {
                                            Vars.ui.showInfoToast("Generate Successful", 1.0f);
                                        } else {
                                            Vars.ui.showInfoToast("Generate Failed", 1.0f);
                                        }
                                    }, new String[]{"png"});
                                })));
                            }))).size(120.0f, 60.0f);
                        }).grow().row();
                    });
                    this.pane((Element)t).fillX().height(t.getHeight()).padTop(12.0f).row();
                    this.table().fill();
                }
            };
            ScrollPane p = (ScrollPane)this.pane((Element)in).grow().get();
            p.setStyle(Styles.horizontalPane);
            p.setFadeScrollBars(true);
            p.setupFadeScrollBars(0.35f, 0.45f);
        }

        public void draw() {
            if (TableFunc.pointValid()) {
                Vec2 drawVec = Core.camera.project(Tmp.v1.set(point));
                float sX = this.x + this.width - 11.0f;
                float sY = this.y + this.height - 4.0f;
                float rad = 14.0f + Mathf.absin((float)16.0f, (float)8.0f);
                float out = this.width / 1.8f;
                Lines.stroke((float)5.0f);
                Draw.color((Color)Pal.gray, (Color)Color.white, (float)Mathf.absin((float)4.0f, (float)0.4f));
                Lines.line((float)sX, (float)sY, (float)(sX + out), (float)sY, (boolean)false);
                Fill.circle((float)(sX + out), (float)sY, (float)(Lines.getStroke() / 2.0f));
                Tmp.v2.trns(Angles.angle((float)drawVec.x, (float)drawVec.y, (float)(sX + out), (float)sY), rad).add(drawVec);
                Lines.line((float)(sX + out), (float)sY, (float)Tmp.v2.x, (float)Tmp.v2.y, (boolean)false);
                Lines.circle((float)drawVec.x, (float)drawVec.y, (float)rad);
            }
            super.draw();
        }
    }
}

