/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.util.ui;

import arc.scene.style.Style;
import arc.struct.Seq;
import mindustry.Vars;
import mindustry.core.UI;
import mindustry.ctype.UnlockableContent;
import mindustry.game.Team;
import mindustry.type.Item;
import mindustry.ui.CoreItemsDisplay;
import mindustry.ui.Styles;
import mindustry.world.Block;
import newhorizon.NHVars;
import newhorizon.expand.block.inner.ModulePayload;

public class TeamPayloadDisplay
extends CoreItemsDisplay {
    public Seq<Block> payloadBlocks = Vars.content.blocks().select(b -> b instanceof ModulePayload);

    public void rebuild() {
        this.clear();
        this.update(() -> {});
        Team team = Vars.player == null ? Team.derelict : Vars.player.team();
        this.table(itemDisplay -> {
            int i = 0;
            for (Item item : Vars.content.items()) {
                if (!team.items().has(item)) continue;
                itemDisplay.image(item.uiIcon).size(24.0f).padRight(3.0f).tooltip(t -> t.background(Styles.black6).margin(4.0f).add((CharSequence)item.localizedName).style((Style)Styles.outlineLabel));
                itemDisplay.label(() -> UI.formatAmount((long)team.items().get(item))).padRight(3.0f).minWidth(52.0f).left().tooltip(t -> t.background(Styles.black6).margin(4.0f).label(() -> team.items().get(item) + "").style((Style)Styles.outlineLabel));
                if (++i % 4 != 0) continue;
                this.row();
            }
        }).width(328.0f);
        this.image().color(team.color).size(320.0f, 4.0f);
        this.table(payloadDisplay -> {
            int i = 0;
            for (UnlockableContent content : this.payloadBlocks) {
                if (NHVars.worldData.teamPayloadData.getPayload(team).get(content) <= 0) continue;
                payloadDisplay.image(content.uiIcon).size(24.0f).padRight(3.0f).tooltip(t -> t.background(Styles.black6).margin(4.0f).add((CharSequence)content.localizedName).style((Style)Styles.outlineLabel));
                payloadDisplay.label(() -> UI.formatAmount((long)NHVars.worldData.teamPayloadData.getPayload(team).get(content))).padRight(3.0f).minWidth(52.0f).left().style((Style)Styles.outlineLabel);
                if (++i % 4 != 0) continue;
                this.row();
            }
        }).width(328.0f);
    }
}

