/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.util.ui.dialog;

import arc.Core;
import arc.audio.Sound;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.math.Interp;
import arc.math.Mathf;
import arc.scene.Element;
import arc.scene.style.Drawable;
import arc.scene.style.Style;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.Dialog;
import arc.scene.ui.ImageButton;
import arc.scene.ui.Label;
import arc.scene.ui.TextButton;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Scaling;
import java.lang.reflect.Field;
import java.util.concurrent.atomic.AtomicInteger;
import mindustry.Vars;
import mindustry.content.TechTree;
import mindustry.core.Logic;
import mindustry.ctype.Content;
import mindustry.ctype.ContentType;
import mindustry.ctype.UnlockableContent;
import mindustry.gen.Groups;
import mindustry.gen.Icon;
import mindustry.gen.Sounds;
import mindustry.gen.Tex;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.type.StatusEffect;
import mindustry.type.UnitType;
import mindustry.type.Weather;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import newhorizon.content.NHContent;
import newhorizon.content.NHSounds;
import newhorizon.util.Tool_Internal;
import newhorizon.util.func.NHInterp;
import newhorizon.util.func.NHPixmap;

public class DebugDialog
extends BaseDialog {
    public DebugDialog(String title) {
        this(title, (Dialog.DialogStyle)Core.scene.getStyle(Dialog.DialogStyle.class));
        this.cont.pane(t -> {
            t.defaults().size(180.0f, 60.0f).pad(6.0f).style((Style)Styles.cleart);
            t.button("Icons", () -> new BaseDialog("Icons"){
                {
                    Class<Icon> c = Icon.class;
                    Field[] fields = c.getFields();
                    this.cont.pane(t -> {
                        int index = 0;
                        for (Field f : fields) {
                            try {
                                if (!f.getType().getSimpleName().equals("TextureRegionDrawable")) continue;
                                if (index % 6 == 0) {
                                    t.row();
                                }
                                t.table(inner -> {
                                    try {
                                        inner.image((Drawable)f.get(null)).pad(4.0f);
                                    }
                                    catch (IllegalAccessException err) {
                                        throw new IllegalArgumentException(err);
                                    }
                                    inner.add((CharSequence)f.getName());
                                }).size(180.0f, 60.0f).pad(4.0f);
                                ++index;
                            }
                            catch (IllegalArgumentException err) {
                                throw new IllegalArgumentException(err);
                            }
                        }
                    }).grow();
                    this.addCloseListener();
                }
            }.show());
            t.button("TableTexes", () -> new BaseDialog("TableTexes"){
                {
                    Class<Tex> c = Tex.class;
                    Field[] fields = c.getFields();
                    this.cont.pane(t -> {
                        int index = 0;
                        for (Field f : fields) {
                            try {
                                if (!Drawable.class.isAssignableFrom(f.getType())) continue;
                                if (index % 6 == 0) {
                                    t.row();
                                }
                                t.table(inner -> {
                                    try {
                                        inner.table((Drawable)f.get(null), de -> de.add((CharSequence)f.getName())).size(180.0f, 60.0f).pad(4.0f);
                                    }
                                    catch (IllegalAccessException err) {
                                        throw new IllegalArgumentException(err);
                                    }
                                }).size(180.0f, 60.0f).pad(4.0f);
                                ++index;
                            }
                            catch (IllegalArgumentException err) {
                                throw new IllegalArgumentException(err);
                            }
                        }
                    }).grow();
                    this.addCloseListener();
                }
            }.show());
            t.button("ButtonTexts", () -> new BaseDialog("ButtonTexts"){
                {
                    Class<Styles> c = Styles.class;
                    Field[] fields = c.getFields();
                    this.cont.pane(t -> {
                        t.background(Tex.selection);
                        int index = 0;
                        for (Field f : fields) {
                            try {
                                if (!f.getType().getSimpleName().equals("TextButtonStyle")) continue;
                                if (index % 6 == 0) {
                                    t.row();
                                }
                                t.table(inner -> {
                                    try {
                                        inner.button(f.getName(), (TextButton.TextButtonStyle)f.get(null), () -> {}).size(180.0f, 60.0f).row();
                                        inner.button(f.getName(), (TextButton.TextButtonStyle)f.get(null), () -> {}).size(180.0f, 60.0f).pad(4.0f).disabled(b -> true).row();
                                    }
                                    catch (IllegalAccessException err) {
                                        throw new IllegalArgumentException(err);
                                    }
                                }).grow().pad(4.0f);
                                ++index;
                            }
                            catch (IllegalArgumentException err) {
                                throw new IllegalArgumentException(err);
                            }
                        }
                    }).grow();
                    this.addCloseListener();
                }
            }.show());
            t.button("ButtonImages", () -> new BaseDialog("ButtonImages"){
                {
                    Class<Styles> c = Styles.class;
                    Field[] fields = c.getFields();
                    this.cont.pane(t -> {
                        t.background(Tex.selection);
                        int index = 0;
                        for (Field f : fields) {
                            try {
                                if (!f.getType().getSimpleName().equals("ImageButtonStyle")) continue;
                                if (index % 6 == 0) {
                                    t.row();
                                }
                                t.table(inner -> {
                                    inner.table(de -> {
                                        try {
                                            de.button((Drawable)Icon.none, (ImageButton.ImageButtonStyle)f.get(null), () -> {}).size(180.0f, 60.0f).row();
                                        }
                                        catch (IllegalAccessException err) {
                                            throw new IllegalArgumentException(err);
                                        }
                                        de.add((CharSequence)f.getName()).pad(4.0f);
                                    }).row();
                                    inner.table(de -> {
                                        try {
                                            de.button((Drawable)Icon.none, (ImageButton.ImageButtonStyle)f.get(null), () -> {}).disabled(b -> true).size(180.0f, 60.0f).row();
                                        }
                                        catch (IllegalAccessException err) {
                                            throw new IllegalArgumentException(err);
                                        }
                                        de.add((CharSequence)f.getName()).pad(4.0f);
                                    }).row();
                                }).grow().pad(4.0f);
                                ++index;
                            }
                            catch (IllegalArgumentException err) {
                                throw new IllegalArgumentException(err);
                            }
                        }
                    }).grow();
                    this.addCloseListener();
                }
            }.show());
            t.button("Unit Icons", () -> new BaseDialog("Units"){
                {
                    this.cont.pane(table -> {
                        AtomicInteger index = new AtomicInteger();
                        Vars.content.units().each(unit -> {
                            if (!unit.isHidden()) {
                                if (index.get() % 8 == 0) {
                                    table.row();
                                }
                                table.table(Tex.buttonEdge3, t -> {
                                    t.button((Drawable)new TextureRegionDrawable(unit.fullIcon), Styles.cleari, 180.0f, () -> {
                                        BaseDialog d = new BaseDialog("info", (UnitType)unit){
                                            final /* synthetic */ UnitType val$unit;
                                            {
                                                this.val$unit = unitType;
                                                super(arg0);
                                                this.cont.image(this.val$unit.fullIcon).scaling(Scaling.fit);
                                            }
                                        };
                                        d.addCloseButton();
                                        d.show();
                                    }).grow().row();
                                    t.pane(in -> in.add((CharSequence)unit.localizedName).height(60.0f).fillX()).height(60.0f).growX();
                                });
                                index.getAndIncrement();
                            }
                        });
                    }).fill();
                    this.addCloseListener();
                }
            }.show());
            t.row();
            t.button("Interps", () -> {
                BaseDialog dialog = new BaseDialog("Interpolation", Styles.fullDialog);
                dialog.setFillParent(true);
                dialog.cont.pane(t1 -> {
                    this.setFillParent(true);
                    final float unitLength = 2.0f;
                    final float offset = 50.0f * unitLength;
                    final float len = 100.0f;
                    final float sigs = 100.0f;
                    Seq fields = new Seq();
                    fields.addAll((Object[])Interp.class.getFields());
                    fields.addAll((Object[])NHInterp.class.getFields());
                    int i = 0;
                    for (final Field field : fields) {
                        if (!Interp.class.isAssignableFrom(field.getType())) continue;
                        if (i++ % 4 == 0) {
                            t1.row();
                        }
                        try {
                            final Interp interp = (Interp)field.get(null);
                            Table table = new Table(Tex.pane){
                                {
                                    super(arg0);
                                    this.fill(Tex.clear, inner -> {
                                        Label l = (Label)inner.add((CharSequence)field.getName()).color(Color.white).align(10).get();
                                        l.getStyle().background = Styles.black3;
                                    });
                                }

                                public void draw() {
                                    this.background(Tex.pane);
                                    super.draw();
                                    Lines.stroke((float)unitLength);
                                    Draw.color((Color)Color.gray);
                                    Lines.line((float)this.x, (float)(this.y + offset), (float)(this.x + this.width), (float)(this.y + offset), (boolean)false);
                                    Lines.line((float)(this.x + offset), (float)this.y, (float)(this.x + offset), (float)(this.y + this.height), (boolean)false);
                                    Drawf.arrow((float)this.x, (float)(this.y + offset), (float)(this.x + this.width), (float)(this.y + offset), (float)(this.width - unitLength * 5.75f), (float)(unitLength * 5.0f), (Color)Pal.gray);
                                    Drawf.arrow((float)(this.x + offset), (float)this.y, (float)(this.x + offset), (float)(this.y + this.height), (float)(this.height - unitLength * 5.75f), (float)(unitLength * 5.0f), (Color)Pal.gray);
                                    Draw.color((Color)Color.gray);
                                    Lines.line((float)(this.x + offset), (float)(this.y + offset + unitLength * len), (float)(this.x + offset + unitLength * len), (float)(this.y + offset + unitLength * len), (boolean)false);
                                    Lines.line((float)(this.x + offset + unitLength * len), (float)(this.y + offset), (float)(this.x + offset + unitLength * len), (float)(this.y + offset + unitLength * len), (boolean)false);
                                    Fill.square((float)(this.x + offset + unitLength * len), (float)(this.y + offset + unitLength * len), (float)(unitLength * 3.0f), (float)45.0f);
                                    Draw.color((Color)Pal.accent);
                                    Lines.beginLine();
                                    for (float i = 0.0f; i <= len; i += len / sigs) {
                                        Lines.linePoint((float)(this.x + i * unitLength + offset), (float)(this.y + interp.apply(i / sigs) * len * unitLength + offset));
                                    }
                                    Lines.endLine((boolean)false);
                                    Draw.reset();
                                    this.background(Tex.clear);
                                    super.draw();
                                }
                            };
                            t1.table(table1 -> table1.add((Element)table).size(len * unitLength + offset * 2.0f).pad(6.0f).row());
                        }
                        catch (IllegalAccessException illegalAccessException) {}
                    }
                }).grow();
                dialog.addCloseButton();
                dialog.show();
            });
            t.button("Status", () -> new BaseDialog("Status"){
                {
                    this.addCloseButton();
                    Seq seq = Vars.content.statusEffects();
                    this.cont.pane(t -> {
                        int index = 0;
                        for (StatusEffect s : seq) {
                            if (index % 6 == 0) {
                                t.row();
                            }
                            t.table(inner -> inner.table(Tex.pane, de -> {
                                de.margin(6.0f);
                                de.image(s.fullIcon).size(60.0f);
                                de.button((Drawable)Icon.play, Styles.cleari, () -> Vars.player.unit().apply(s, 600.0f)).growY().scaling(Scaling.fit);
                            }).size(180.0f, 60.0f).pad(4.0f)).size(180.0f, 60.0f).pad(4.0f);
                            ++index;
                        }
                    }).grow();
                }
            }.show());
            t.button("Sounds", () -> new BaseDialog("ICONS"){
                {
                    this.addCloseButton();
                    Class<Sounds> c = Sounds.class;
                    Seq fields = Seq.with((Object[])Sounds.class.getFields()).addAll((Object[])NHSounds.class.getFields());
                    this.cont.pane(t -> {
                        int index = 0;
                        for (Field f : fields) {
                            try {
                                if (!Sound.class.isAssignableFrom(f.getType())) continue;
                                if (index % 6 == 0) {
                                    t.row();
                                }
                                t.table(inner -> inner.table(Tex.pane, de -> {
                                    de.margin(6.0f);
                                    de.add((CharSequence)f.getName()).growX();
                                    de.button((Drawable)Icon.play, Styles.cleari, () -> {
                                        try {
                                            ((Sound)f.get(null)).play();
                                        }
                                        catch (IllegalAccessException e) {
                                            e.printStackTrace();
                                        }
                                    }).growY().scaling(Scaling.fit);
                                }).size(180.0f, 60.0f).pad(4.0f)).size(180.0f, 60.0f).pad(4.0f);
                                ++index;
                            }
                            catch (IllegalArgumentException err) {
                                throw new IllegalArgumentException(err);
                            }
                        }
                    }).grow();
                }
            }.show());
            t.button("Weathers", () -> {
                BaseDialog dialog = new BaseDialog("");
                dialog.cont.pane(t1 -> {
                    t1.image().growX().height(3.0f).pad(6.0f).color(Pal.accent).row();
                    t1.pane(table -> {
                        for (Content content : Vars.content.getBy(ContentType.weather)) {
                            if (!(content instanceof Weather)) continue;
                            Weather c = (Weather)content;
                            table.button(c.localizedName, (Drawable)new TextureRegionDrawable(c.fullIcon), () -> {
                                float intensity = Mathf.random((int)2, (int)10);
                                c.create(intensity, 600.0f);
                            }).growX().padTop(6.0f).fillY().row();
                        }
                    }).grow().row();
                    t1.image().growX().height(3.0f).pad(6.0f).color(Pal.accent).row();
                    t1.button("Remove", () -> Groups.weather.clear()).growX().height(60.0f);
                }).grow();
                dialog.addCloseButton();
                dialog.show();
            });
            t.row();
            t.button("Unlock ALL", () -> TechTree.all.each(c -> c.content.unlock()));
            t.button("Unlock Single", () -> new BaseDialog("UNLOCK"){
                {
                    Seq all = TechTree.all.map(n -> n.content);
                    this.cont.pane(t -> {
                        for (int i = 0; i < all.size; ++i) {
                            if (i % 4 == 0) {
                                t.row();
                            }
                            UnlockableContent c = (UnlockableContent)all.get(i);
                            t.table(Tex.pane, table -> {
                                table.image(c.fullIcon).size(30.0f);
                                table.add((CharSequence)c.localizedName).padLeft(6.0f);
                                table.button((Drawable)Icon.lock, Styles.cleari, () -> {
                                    if (c.unlocked()) {
                                        c.clearUnlock();
                                    } else {
                                        c.unlock();
                                    }
                                }).size(30.0f).update(b -> {
                                    b.getStyle().imageUp = c.unlocked() ? Icon.lockOpen : Icon.lock;
                                });
                            }).fill().pad(3.0f);
                        }
                    }).grow();
                    this.addCloseButton();
                }
            }.show());
            t.button("Apply Default Waves", () -> {
                Vars.state.rules.spawns.clear();
                Vars.state.rules.spawns.addAll(Vars.waves.get());
            });
            t.button("Clear Fog", () -> {
                Vars.state.rules.fog = false;
            });
            t.button("Remove Limit", () -> {
                Vars.state.rules.limitMapArea = false;
            });
            t.button("Show UI Structure", () -> new BaseDialog(""){
                {
                    this.addCloseButton();
                    this.cont.pane(t -> t.add((CharSequence)Vars.ui.hudGroup.toString())).grow();
                }
            }.show());
            t.row();
            t.button("Generate Icon", () -> Vars.ui.loadAnd("[accent]Generating", () -> {
                Vars.content.units().each(u -> {
                    if (u.name.contains("new-horizon")) {
                        NHPixmap.saveUnitPixmap(Core.atlas.getPixmap(u.fullIcon).crop(), u);
                    }
                });
                NHPixmap.saveAddProcessed();
            })).disabled(b -> !NHPixmap.isDebugging());
            t.button("Fire Tool", Tool_Internal::fireAnime);
            t.button("Texture Lerp Tool", Tool_Internal::textureLerp);
            t.button("Texture Pick Tool", Tool_Internal::texturePick);
            t.button("Bundle Tool", Tool_Internal::patchBundle);
            t.row();
            t.button("+10 Wave", () -> Vars.state.wave += 10);
            t.button("-10 Wave", () -> {
                Vars.state.wave = Math.max(0, Vars.state.wave - 10);
            });
            t.button("capture", Logic::sectorCapture).disabled(b -> !Vars.state.isCampaign());
            t.row();
            t.button("see Tex", () -> Tool_Internal.showTexture(NHContent.smoothNoise));
        }).grow();
        this.addCloseButton();
    }

    public DebugDialog(String title, Dialog.DialogStyle style) {
        super(title, style);
    }
}

