/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.util.ui.dialog;

import arc.Core;
import arc.graphics.Color;
import arc.scene.Element;
import arc.scene.style.Drawable;
import arc.scene.ui.Label;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Scaling;
import mindustry.gen.Icon;
import mindustry.gen.Tex;
import mindustry.graphics.Pal;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import mindustry.ui.dialogs.ContentInfoDialog;
import newhorizon.NewHorizon;
import newhorizon.content.NHContent;
import newhorizon.util.ui.FeatureLog;
import newhorizon.util.ui.NHUIFunc;

public class NewFeatureDialog
extends BaseDialog {
    public NewFeatureDialog() {
        super(Core.bundle.get("nh.new-feature.title"));
        this.shown(this::build);
        this.onResize(this::build);
        this.addCloseListener();
    }

    public static FeatureLog[] getUpdateContent() {
        Seq updates = Seq.with((Object[])new FeatureLog[]{new FeatureLog(0, FeatureLog.featureType.IMPORTANT, NHContent.icon2)});
        return (FeatureLog[])updates.toArray(FeatureLog.class);
    }

    public void build() {
        this.cont.clear();
        this.cont.pane(main -> {
            main.background(Styles.black9);
            main.top();
            this.buildMainChangelog((Table)main);
            this.buildFeatureLog((Table)main);
        }).grow().padLeft(60.0f).padRight(60.0f).padTop(60.0f).row();
        this.cont.button("@back", (Drawable)Icon.left, Styles.cleart, () -> ((NewFeatureDialog)this).hide()).growX().height(60.0f).bottom().growX().height(60.0f).padTop(12.0f).padLeft(60.0f).padRight(60.0f);
    }

    private void buildMainChangelog(Table main) {
        main.pane(table -> {
            table.align(10);
            table.add((CharSequence)(NewHorizon.MOD.meta.version + ": ")).row();
            table.image().height(4.0f).growX().color(Pal.accent).row();
            table.add((CharSequence)Core.bundle.get("mod.ui.update-log")).left();
        }).growX().fillY().padBottom(60.0f).row();
        main.image().growX().height(4.0f).pad(6.0f).color(Color.lightGray).row();
    }

    private void buildFeatureLog(Table main) {
        main.pane(t -> {
            for (FeatureLog feature : NewFeatureDialog.getUpdateContent()) {
                Table importantLabel = new Table(table -> {
                    Label label = new Label((CharSequence)"[ancient]<<IMPORTANT UPDATE>>");
                    label.setStyle(Styles.techLabel);
                    label.setFontScale(1.25f);
                    table.add((Element)label).row();
                });
                Table info = new Table(Tex.pane, table -> {
                    if (feature.important) {
                        table.background(Tex.whitePane);
                        table.color.set(Pal.accent);
                    }
                    table.image(feature.icon).size(120.0f).scaling(Scaling.bounded);
                    table.pane(i -> {
                        i.top();
                        if (feature.important) {
                            i.add((Element)importantLabel).pad(2.0f, 2.0f, 4.0f, 2.0f).row();
                        }
                        i.add((CharSequence)(feature.type.localizedName + " [accent]" + feature.getLocalizedTitle() + "[]")).left().row();
                        i.image().growX().height(4.0f).pad(4.0f).color(Color.lightGray).row();
                        if (feature.description != null) {
                            i.add((CharSequence)Core.bundle.get("nh.new-feature.description")).left().row();
                            i.add((CharSequence)feature.getLocalizedDescription()).padLeft(60.0f).left().growX().wrap();
                        }
                        if (feature.modifier != null) {
                            i.table(i1 -> {
                                NHUIFunc.show(i1, feature.content);
                                feature.modifier.get(i);
                            }).grow().left().row();
                        }
                    }).grow().padLeft(12.0f).top();
                    table.button((Drawable)Icon.info, Styles.cleari, 60.0f, () -> {
                        ContentInfoDialog dialog = new ContentInfoDialog();
                        dialog.show(feature.content);
                    }).growY().width(60.0f).padLeft(12.0f).disabled(b -> feature.content == null);
                });
                t.add((Element)info).grow().row();
            }
        }).growX().top().row();
    }
}

