/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.util.ui.display;

import arc.scene.Element;
import arc.scene.style.Style;
import arc.scene.ui.layout.Table;
import arc.util.Strings;
import mindustry.type.Item;
import mindustry.type.ItemStack;
import mindustry.ui.Styles;
import mindustry.world.meta.StatUnit;
import newhorizon.util.ui.display.ItemImage;

public class ItemDisplay
extends Table {
    public final Item item;
    public final int amount;

    public ItemDisplay(Item item) {
        this(item, 0);
    }

    public ItemDisplay(Item item, int amount, boolean showName) {
        this.add((Element)new ItemImage(new ItemStack(item, amount)));
        if (showName) {
            this.add(item.localizedName).padLeft(4 + amount > 99 ? 4.0f : 0.0f);
        }
        this.item = item;
        this.amount = amount;
    }

    public ItemDisplay(Item item, int amount) {
        this(item, amount, true);
    }

    public ItemDisplay(Item item, int amount, float timePeriod, boolean showName) {
        this.add((Element)new ItemImage(item.uiIcon, amount));
        this.add((showName ? item.localizedName + "\n" : "") + "[lightgray]" + Strings.autoFixed((float)((float)amount / (timePeriod / 60.0f)), (int)2) + StatUnit.perSecond.localized()).padLeft(2.0f).padRight(5.0f).style((Style)Styles.outlineLabel);
        this.item = item;
        this.amount = amount;
    }
}

