/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.util.ui.frag;

import arc.func.Prov;
import arc.graphics.g2d.TextureRegion;
import arc.scene.Element;
import arc.scene.Group;
import arc.scene.event.Touchable;
import arc.scene.ui.Image;
import arc.scene.ui.layout.Stack;
import arc.scene.ui.layout.Table;
import arc.util.Log;
import arc.util.Reflect;
import mindustry.Vars;
import mindustry.core.UI;
import mindustry.ctype.UnlockableContent;
import mindustry.gen.Building;
import mindustry.gen.Tex;
import mindustry.type.PayloadSeq;
import newhorizon.NHUI;
import newhorizon.content.blocks.ModuleBlock;

public class PayloadInventoryFragment {
    public Table table = new Table();

    public void build(Group parent) {
        this.table.name = "inventoryPayload";
        this.table.setTransform(true);
        parent.setTransform(true);
        parent.addChild((Element)this.table);
    }

    public void rebuild() {
        if (!this.table.visible) {
            return;
        }
        this.table.clear();
        this.table.background(Tex.inventory);
        this.table.touchable = Touchable.disabled;
        this.table.margin(4.0f);
        this.table.defaults().size(40.0f).pad(4.0f);
        int row = 0;
        int cols = 3;
        Building b = this.getBuild();
        if (b != null && b.getPayloads() != null && !b.getPayloads().isEmpty()) {
            PayloadSeq inv = b.getPayloads();
            for (UnlockableContent content : ModuleBlock.modules) {
                if (!inv.contains(content)) continue;
                Element image = this.itemImage(content.uiIcon, (Prov<CharSequence>)((Prov)() -> !b.isValid() ? "" : this.round(inv.get(content))));
                this.table.add(image);
                if (row++ % cols != cols - 1) continue;
                this.table.row();
            }
        } else {
            this.table.visible = false;
        }
        this.updateTablePosition();
    }

    private Building getBuild() {
        try {
            return (Building)Reflect.get((Object)Vars.control.input.inv, (String)"build");
        }
        catch (Exception e) {
            Log.err((Throwable)e);
            return null;
        }
    }

    private String round(float f) {
        if ((f = (float)((int)f)) >= 1000000.0f) {
            return (int)(f / 1000000.0f) + "[gray]" + UI.millions;
        }
        if (f >= 1000.0f) {
            return (int)(f / 1000.0f) + UI.thousands;
        }
        return (int)f + "";
    }

    private void updateTablePosition() {
        this.table.pack();
        Table t = NHUI.itemInv;
        this.table.setPosition(t.x, t.y + t.getPrefHeight() - 4.0f, 12);
    }

    private Element itemImage(TextureRegion region, Prov<CharSequence> text) {
        Stack stack = new Stack();
        Table t = new Table().left().bottom();
        t.label(text);
        stack.add((Element)new Image(region));
        stack.add((Element)t);
        return stack;
    }
}

