/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.clickgui.components;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import net.wurstclient.WurstClient;
import net.wurstclient.clickgui.ClickGui;
import net.wurstclient.clickgui.Component;
import net.wurstclient.clickgui.Window;
import net.wurstclient.settings.CheckboxSetting;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

public final class CheckboxComponent
extends Component {
    private final class_310 MC = WurstClient.MC;
    private final ClickGui GUI = WurstClient.INSTANCE.getGui();
    private final CheckboxSetting setting;

    public CheckboxComponent(CheckboxSetting setting) {
        this.setting = setting;
        this.setWidth(this.getDefaultWidth());
        this.setHeight(this.getDefaultHeight());
    }

    @Override
    public void handleMouseClick(double mouseX, double mouseY, int mouseButton) {
        switch (mouseButton) {
            case 0: {
                this.setting.setChecked(!this.setting.isChecked());
                break;
            }
            case 1: {
                this.setting.setChecked(this.setting.isCheckedByDefault());
            }
        }
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY, float partialTicks) {
        class_4587 matrixStack = context.method_51448();
        int x1 = this.getX();
        int x2 = x1 + this.getWidth();
        int x3 = x1 + 11;
        int y1 = this.getY();
        int y2 = y1 + this.getHeight();
        boolean hovering = this.isHovering(mouseX, mouseY, x1, x2, y1, y2);
        RenderSystem.setShader(class_757::method_34539);
        if (hovering && mouseX >= x3) {
            this.setTooltip();
        }
        if (this.setting.isLocked()) {
            hovering = false;
        }
        this.drawBackground(matrixStack, x2, x3, y1, y2);
        this.drawBox(matrixStack, x1, x3, y1, y2, hovering);
        if (this.setting.isChecked()) {
            this.drawCheck(matrixStack, x1, y1, hovering);
        }
        this.drawName(context, x3, y1);
    }

    private boolean isHovering(int mouseX, int mouseY, int x1, int x2, int y1, int y2) {
        Window parent = this.getParent();
        boolean scrollEnabled = parent.isScrollingEnabled();
        int scroll = scrollEnabled ? parent.getScrollOffset() : 0;
        return mouseX >= x1 && mouseY >= y1 && mouseX < x2 && mouseY < y2 && mouseY >= -scroll && mouseY < parent.getHeight() - 13 - scroll;
    }

    private void setTooltip() {
        Object tooltip = this.setting.getWrappedDescription(200);
        if (this.setting.isLocked()) {
            tooltip = (String)tooltip + "\n\nThis checkbox is locked to ";
            tooltip = (String)tooltip + this.setting.isChecked() + ".";
        }
        this.GUI.setTooltip((String)tooltip);
    }

    private void drawBackground(class_4587 matrixStack, int x2, int x3, int y1, int y2) {
        float[] bgColor = this.GUI.getBgColor();
        float opacity = this.GUI.getOpacity();
        Matrix4f matrix = matrixStack.method_23760().method_23761();
        class_289 tessellator = RenderSystem.renderThreadTesselator();
        class_287 bufferBuilder = tessellator.method_1349();
        RenderSystem.setShaderColor((float)bgColor[0], (float)bgColor[1], (float)bgColor[2], (float)opacity);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1592);
        bufferBuilder.method_22918(matrix, (float)x3, (float)y1, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, (float)x3, (float)y2, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, (float)x2, (float)y2, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, (float)x2, (float)y1, 0.0f).method_1344();
        tessellator.method_1350();
    }

    private void drawBox(class_4587 matrixStack, int x1, int x3, int y1, int y2, boolean hovering) {
        float[] bgColor = this.GUI.getBgColor();
        float[] acColor = this.GUI.getAcColor();
        float opacity = this.GUI.getOpacity();
        Matrix4f matrix = matrixStack.method_23760().method_23761();
        class_289 tessellator = RenderSystem.renderThreadTesselator();
        class_287 bufferBuilder = tessellator.method_1349();
        RenderSystem.setShaderColor((float)bgColor[0], (float)bgColor[1], (float)bgColor[2], (float)(hovering ? opacity * 1.5f : opacity));
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1592);
        bufferBuilder.method_22918(matrix, (float)x1, (float)y1, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, (float)x1, (float)y2, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, (float)x3, (float)y2, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, (float)x3, (float)y1, 0.0f).method_1344();
        tessellator.method_1350();
        RenderSystem.setShaderColor((float)acColor[0], (float)acColor[1], (float)acColor[2], (float)0.5f);
        bufferBuilder.method_1328(class_293.class_5596.field_29345, class_290.field_1592);
        bufferBuilder.method_22918(matrix, (float)x1, (float)y1, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, (float)x1, (float)y2, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, (float)x3, (float)y2, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, (float)x3, (float)y1, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, (float)x1, (float)y1, 0.0f).method_1344();
        tessellator.method_1350();
    }

    private void drawCheck(class_4587 matrixStack, int x1, int y1, boolean hovering) {
        Matrix4f matrix = matrixStack.method_23760().method_23761();
        class_289 tessellator = RenderSystem.renderThreadTesselator();
        class_287 bufferBuilder = tessellator.method_1349();
        float xc1 = (float)x1 + 2.5f;
        float xc2 = (float)x1 + 3.5f;
        float xc3 = (float)x1 + 4.5f;
        float xc4 = (float)x1 + 7.5f;
        float xc5 = (float)x1 + 8.5f;
        float yc1 = (float)y1 + 2.5f;
        float yc2 = (float)y1 + 3.5f;
        float yc3 = (float)y1 + 5.5f;
        float yc4 = (float)y1 + 6.5f;
        float yc5 = (float)y1 + 8.5f;
        if (this.setting.isLocked()) {
            RenderSystem.setShaderColor((float)0.5f, (float)0.5f, (float)0.5f, (float)0.75f);
        } else {
            RenderSystem.setShaderColor((float)0.0f, (float)(hovering ? 1.0f : 0.85f), (float)0.0f, (float)1.0f);
        }
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1592);
        bufferBuilder.method_22918(matrix, xc2, yc3, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, xc3, yc4, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, xc3, yc5, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, xc1, yc4, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, xc4, yc1, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, xc5, yc2, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, xc3, yc5, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, xc3, yc4, 0.0f).method_1344();
        tessellator.method_1350();
        RenderSystem.setShaderColor((float)0.0625f, (float)0.0625f, (float)0.0625f, (float)0.5f);
        bufferBuilder.method_1328(class_293.class_5596.field_29345, class_290.field_1592);
        bufferBuilder.method_22918(matrix, xc2, yc3, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, xc3, yc4, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, xc4, yc1, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, xc5, yc2, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, xc3, yc5, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, xc1, yc4, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, xc2, yc3, 0.0f).method_1344();
        tessellator.method_1350();
    }

    private void drawName(class_332 context, int x3, int y1) {
        ClickGui gui = WurstClient.INSTANCE.getGui();
        int txtColor = gui.getTxtColor();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        String name = this.setting.getName();
        int tx = x3 + 2;
        int ty = y1 + 2;
        context.method_51433(this.MC.field_1772, name, tx, ty, txtColor, false);
        GL11.glEnable((int)3042);
    }

    @Override
    public int getDefaultWidth() {
        return this.MC.field_1772.method_1727(this.setting.getName()) + 13;
    }

    @Override
    public int getDefaultHeight() {
        return 11;
    }
}

