/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.clickgui.components;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import net.wurstclient.WurstClient;
import net.wurstclient.clickgui.ClickGui;
import net.wurstclient.clickgui.ComboBoxPopup;
import net.wurstclient.clickgui.Component;
import net.wurstclient.clickgui.Window;
import net.wurstclient.settings.EnumSetting;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

public final class ComboBoxComponent<T extends Enum<T>>
extends Component {
    private final ClickGui gui = WurstClient.INSTANCE.getGui();
    private final class_327 tr;
    private final EnumSetting<T> setting;
    private final int popupWidth;
    private ComboBoxPopup<T> popup;

    public ComboBoxComponent(EnumSetting<T> setting) {
        this.tr = WurstClient.MC.field_1772;
        this.setting = setting;
        this.popupWidth = this.calculatePopupWitdh();
        this.setWidth(this.getDefaultWidth());
        this.setHeight(this.getDefaultHeight());
    }

    private int calculatePopupWitdh() {
        Stream<Enum> values = Arrays.stream(this.setting.getValues());
        Stream<String> vNames = values.map(Enum::toString);
        IntStream vWidths = vNames.mapToInt(s -> this.tr.method_1727(s));
        return vWidths.max().getAsInt();
    }

    @Override
    public void handleMouseClick(double mouseX, double mouseY, int mouseButton) {
        if (mouseX < (double)(this.getX() + this.getWidth() - this.popupWidth - 15)) {
            return;
        }
        switch (mouseButton) {
            case 0: {
                this.handleLeftClick();
                break;
            }
            case 1: {
                this.handleRightClick();
            }
        }
    }

    private void handleLeftClick() {
        if (this.isPopupOpen()) {
            this.popup.close();
            this.popup = null;
            return;
        }
        this.popup = new ComboBoxPopup<T>(this, this.setting, this.popupWidth);
        this.gui.addPopup(this.popup);
    }

    private void handleRightClick() {
        if (this.isPopupOpen()) {
            return;
        }
        T defaultSelected = this.setting.getDefaultSelected();
        this.setting.setSelected(defaultSelected);
    }

    private boolean isPopupOpen() {
        return this.popup != null && !this.popup.isClosing();
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY, float partialTicks) {
        int y2;
        class_4587 matrixStack = context.method_51448();
        int x1 = this.getX();
        int x2 = x1 + this.getWidth();
        int x3 = x2 - 11;
        int x4 = x3 - this.popupWidth - 4;
        int y1 = this.getY();
        boolean hovering = this.isHovering(mouseX, mouseY, x1, x2, y1, y2 = y1 + this.getHeight());
        boolean hText = hovering && mouseX < x4;
        boolean hBox = hovering && mouseX >= x4;
        RenderSystem.setShader(class_757::method_34539);
        if (hText) {
            this.gui.setTooltip(this.setting.getWrappedDescription(200));
        }
        this.drawBackground(matrixStack, x1, x4, y1, y2);
        this.drawBox(matrixStack, x2, x4, y1, y2, hBox);
        this.drawSeparator(matrixStack, x3, y1, y2);
        this.drawArrow(matrixStack, x2, x3, y1, y2, hBox);
        this.drawNameAndValue(context, x1, x4, y1);
    }

    private boolean isHovering(int mouseX, int mouseY, int x1, int x2, int y1, int y2) {
        Window parent = this.getParent();
        boolean scrollEnabled = parent.isScrollingEnabled();
        int scroll = scrollEnabled ? parent.getScrollOffset() : 0;
        return mouseX >= x1 && mouseY >= y1 && mouseX < x2 && mouseY < y2 && mouseY >= -scroll && mouseY < parent.getHeight() - 13 - scroll;
    }

    private void drawBackground(class_4587 matrixStack, int x1, int x4, int y1, int y2) {
        float[] bgColor = this.gui.getBgColor();
        float opacity = this.gui.getOpacity();
        Matrix4f matrix = matrixStack.method_23760().method_23761();
        class_289 tessellator = RenderSystem.renderThreadTesselator();
        class_287 bufferBuilder = tessellator.method_1349();
        RenderSystem.setShaderColor((float)bgColor[0], (float)bgColor[1], (float)bgColor[2], (float)opacity);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1592);
        bufferBuilder.method_22918(matrix, (float)x1, (float)y1, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, (float)x1, (float)y2, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, (float)x4, (float)y2, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, (float)x4, (float)y1, 0.0f).method_1344();
        tessellator.method_1350();
    }

    private void drawBox(class_4587 matrixStack, int x2, int x4, int y1, int y2, boolean hBox) {
        float[] bgColor = this.gui.getBgColor();
        float[] acColor = this.gui.getAcColor();
        float opacity = this.gui.getOpacity();
        Matrix4f matrix = matrixStack.method_23760().method_23761();
        class_289 tessellator = RenderSystem.renderThreadTesselator();
        class_287 bufferBuilder = tessellator.method_1349();
        float bgAlpha = hBox ? opacity * 1.5f : opacity;
        RenderSystem.setShaderColor((float)bgColor[0], (float)bgColor[1], (float)bgColor[2], (float)bgAlpha);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1592);
        bufferBuilder.method_22918(matrix, (float)x4, (float)y1, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, (float)x4, (float)y2, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, (float)x2, (float)y2, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, (float)x2, (float)y1, 0.0f).method_1344();
        tessellator.method_1350();
        RenderSystem.setShaderColor((float)acColor[0], (float)acColor[1], (float)acColor[2], (float)0.5f);
        bufferBuilder.method_1328(class_293.class_5596.field_29345, class_290.field_1592);
        bufferBuilder.method_22918(matrix, (float)x4, (float)y1, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, (float)x4, (float)y2, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, (float)x2, (float)y2, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, (float)x2, (float)y1, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, (float)x4, (float)y1, 0.0f).method_1344();
        tessellator.method_1350();
    }

    private void drawSeparator(class_4587 matrixStack, int x3, int y1, int y2) {
        Matrix4f matrix = matrixStack.method_23760().method_23761();
        class_289 tessellator = RenderSystem.renderThreadTesselator();
        class_287 bufferBuilder = tessellator.method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_29344, class_290.field_1592);
        bufferBuilder.method_22918(matrix, (float)x3, (float)y1, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, (float)x3, (float)y2, 0.0f).method_1344();
        tessellator.method_1350();
    }

    private void drawArrow(class_4587 matrixStack, int x2, int x3, int y1, int y2, boolean hBox) {
        float ya2;
        float ya1;
        Matrix4f matrix = matrixStack.method_23760().method_23761();
        class_289 tessellator = RenderSystem.renderThreadTesselator();
        class_287 bufferBuilder = tessellator.method_1349();
        float xa1 = x3 + 1;
        float xa2 = (float)(x3 + x2) / 2.0f;
        float xa3 = x2 - 1;
        if (this.isPopupOpen()) {
            ya1 = (float)y2 - 3.5f;
            ya2 = y1 + 3;
            RenderSystem.setShaderColor((float)(hBox ? 1.0f : 0.85f), (float)0.0f, (float)0.0f, (float)1.0f);
        } else {
            ya1 = (float)y1 + 3.5f;
            ya2 = y2 - 3;
            RenderSystem.setShaderColor((float)0.0f, (float)(hBox ? 1.0f : 0.85f), (float)0.0f, (float)1.0f);
        }
        bufferBuilder.method_1328(class_293.class_5596.field_27379, class_290.field_1592);
        bufferBuilder.method_22918(matrix, xa1, ya1, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, xa3, ya1, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, xa2, ya2, 0.0f).method_1344();
        tessellator.method_1350();
        RenderSystem.setShaderColor((float)0.0625f, (float)0.0625f, (float)0.0625f, (float)0.5f);
        bufferBuilder.method_1328(class_293.class_5596.field_29345, class_290.field_1592);
        bufferBuilder.method_22918(matrix, xa1, ya1, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, xa3, ya1, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, xa2, ya2, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, xa1, ya1, 0.0f).method_1344();
        tessellator.method_1350();
    }

    private void drawNameAndValue(class_332 context, int x1, int x4, int y1) {
        ClickGui gui = WurstClient.INSTANCE.getGui();
        int txtColor = gui.getTxtColor();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        String name = this.setting.getName();
        String value = "" + this.setting.getSelected();
        context.method_51433(this.tr, name, x1, y1 + 2, txtColor, false);
        context.method_51433(this.tr, value, x4 + 2, y1 + 2, txtColor, false);
        GL11.glEnable((int)3042);
    }

    @Override
    public int getDefaultWidth() {
        return this.tr.method_1727(this.setting.getName()) + this.popupWidth + 17;
    }

    @Override
    public int getDefaultHeight() {
        return 11;
    }
}

