/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.commands;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Arrays;
import net.minecraft.class_151;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2596;
import net.minecraft.class_2873;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.wurstclient.command.CmdError;
import net.wurstclient.command.CmdException;
import net.wurstclient.command.CmdSyntaxError;
import net.wurstclient.command.Command;
import net.wurstclient.util.ChatUtils;
import net.wurstclient.util.MathUtils;

public final class GiveCmd
extends Command {
    public GiveCmd() {
        super("give", "Gives you an item with custom NBT data.\nRequires creative mode.", ".give <item> [<amount>] [<nbt>]", ".give <id> [<amount>] [<nbt>]");
    }

    @Override
    public void call(String[] args) throws CmdException {
        if (args.length < 1) {
            throw new CmdSyntaxError();
        }
        if (!GiveCmd.MC.field_1724.method_31549().field_7477) {
            throw new CmdError("Creative mode only.");
        }
        class_1792 item = this.getItem(args[0]);
        if (item == class_1802.field_8162 && MathUtils.isInteger(args[0])) {
            item = class_1792.method_7875((int)Integer.parseInt(args[0]));
        }
        if (item == class_1802.field_8162) {
            throw new CmdError("Item \"" + args[0] + "\" could not be found.");
        }
        int amount = 1;
        if (args.length >= 2) {
            if (!MathUtils.isInteger(args[1])) {
                throw new CmdSyntaxError("Not a number: " + args[1]);
            }
            amount = Integer.parseInt(args[1]);
            if (amount < 1) {
                throw new CmdError("Amount cannot be less than 1.");
            }
            if (amount > 64) {
                throw new CmdError("Amount cannot be more than 64.");
            }
        }
        String nbt = null;
        if (args.length >= 3) {
            nbt = String.join((CharSequence)" ", Arrays.copyOfRange(args, 2, args.length));
        }
        class_1799 stack = new class_1799((class_1935)item, amount);
        if (nbt != null) {
            try {
                class_2487 tag = class_2522.method_10718((String)nbt);
                stack.method_7980(tag);
            }
            catch (CommandSyntaxException e) {
                ChatUtils.message(e.getMessage());
                throw new CmdSyntaxError("NBT data is invalid.");
            }
        }
        if (!this.placeStackInHotbar(stack)) {
            throw new CmdError("Please clear a slot in your hotbar.");
        }
        ChatUtils.message("Item" + (amount > 1 ? "s" : "") + " created.");
    }

    private class_1792 getItem(String id) throws CmdSyntaxError {
        try {
            return (class_1792)class_7923.field_41178.method_10223(new class_2960(id));
        }
        catch (class_151 e) {
            throw new CmdSyntaxError("Invalid item: " + id);
        }
    }

    private boolean placeStackInHotbar(class_1799 stack) {
        for (int i = 0; i < 9; ++i) {
            if (!GiveCmd.MC.field_1724.method_31548().method_5438(i).method_7960()) continue;
            GiveCmd.MC.field_1724.field_3944.method_2883((class_2596)new class_2873(36 + i, stack));
            return true;
        }
        return false;
    }
}

