/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.commands;

import java.util.List;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_151;
import net.minecraft.class_1799;
import net.minecraft.class_1812;
import net.minecraft.class_1844;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.wurstclient.command.CmdError;
import net.wurstclient.command.CmdException;
import net.wurstclient.command.CmdSyntaxError;
import net.wurstclient.command.Command;
import net.wurstclient.util.ChatUtils;
import net.wurstclient.util.MathUtils;

public final class PotionCmd
extends Command {
    public PotionCmd() {
        super("potion", "Changes the effects of the held potion.", ".potion add (<effect> <amplifier> <duration>)...", ".potion set (<effect> <amplifier> <duration>)...", ".potion remove <effect>");
    }

    @Override
    public void call(String[] args) throws CmdException {
        if (args.length == 0) {
            throw new CmdSyntaxError();
        }
        if (!PotionCmd.MC.field_1724.method_31549().field_7477) {
            throw new CmdError("Creative mode only.");
        }
        class_1799 stack = PotionCmd.MC.field_1724.method_31548().method_7391();
        if (!(stack.method_7909() instanceof class_1812)) {
            throw new CmdError("You must hold a potion in your main hand.");
        }
        if (args[0].equalsIgnoreCase("remove")) {
            this.remove(stack, args);
            return;
        }
        if ((args.length - 1) % 3 != 0) {
            throw new CmdSyntaxError();
        }
        class_2499 effects = switch (args[0].toLowerCase()) {
            case "add" -> this.convertEffectsToNbt(stack);
            case "set" -> new class_2499();
            default -> throw new CmdSyntaxError();
        };
        for (int i = 0; i < (args.length - 1) / 3; ++i) {
            class_2487 effect = new class_2487();
            effect.method_10569("Id", this.parseEffectId(args[1 + i * 3]));
            effect.method_10569("Amplifier", this.parseInt(args[2 + i * 3]) - 1);
            effect.method_10569("Duration", this.parseInt(args[3 + i * 3]) * 20);
            effects.add((Object)effect);
        }
        class_2487 nbt = new class_2487();
        nbt.method_10566("CustomPotionEffects", (class_2520)effects);
        stack.method_7980(nbt);
        ChatUtils.message("Potion modified.");
    }

    private class_2499 convertEffectsToNbt(class_1799 stack) {
        class_2499 nbt = new class_2499();
        List effects = class_1844.method_8068((class_1799)stack);
        for (class_1293 effect : effects) {
            class_2487 tag = new class_2487();
            int id = class_1291.method_5554((class_1291)effect.method_5579());
            tag.method_10569("Id", id);
            tag.method_10569("Amplifier", effect.method_5578());
            tag.method_10569("Duration", effect.method_5584());
            nbt.add((Object)tag);
        }
        return nbt;
    }

    private void remove(class_1799 stack, String[] args) throws CmdSyntaxError {
        if (args.length != 2) {
            throw new CmdSyntaxError();
        }
        int id = this.parseEffectId(args[1]);
        List oldEffects = class_1844.method_8068((class_1799)stack);
        class_2499 newEffects = new class_2499();
        for (class_1293 oldEffect : oldEffects) {
            int oldId = class_1291.method_5554((class_1291)oldEffect.method_5579());
            if (oldId == id) continue;
            class_2487 effect = new class_2487();
            effect.method_10569("Id", oldId);
            effect.method_10569("Amplifier", oldEffect.method_5578());
            effect.method_10569("Duration", oldEffect.method_5584());
            newEffects.add((Object)effect);
        }
        class_2487 nbt = new class_2487();
        nbt.method_10566("CustomPotionEffects", (class_2520)newEffects);
        stack.method_7980(nbt);
        ChatUtils.message("Effect removed.");
    }

    private int parseEffectId(String input) throws CmdSyntaxError {
        int id = 0;
        if (MathUtils.isInteger(input)) {
            id = Integer.parseInt(input);
        } else {
            try {
                class_2960 identifier = new class_2960(input);
                class_1291 effect = (class_1291)class_7923.field_41174.method_10223(identifier);
                id = class_1291.method_5554((class_1291)effect);
            }
            catch (class_151 e) {
                throw new CmdSyntaxError("Invalid effect: " + input);
            }
        }
        if (id < 1) {
            throw new CmdSyntaxError();
        }
        return id;
    }

    private int parseInt(String s) throws CmdSyntaxError {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            throw new CmdSyntaxError("Not a number: " + s);
        }
    }
}

