/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.hacks;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1041;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import net.wurstclient.Category;
import net.wurstclient.ai.PathFinder;
import net.wurstclient.ai.PathProcessor;
import net.wurstclient.commands.PathCmd;
import net.wurstclient.events.GUIRenderListener;
import net.wurstclient.events.RenderListener;
import net.wurstclient.events.UpdateListener;
import net.wurstclient.hack.Hack;
import net.wurstclient.settings.EnumSetting;
import net.wurstclient.settings.SliderSetting;
import net.wurstclient.util.BlockBreaker;
import net.wurstclient.util.BlockUtils;
import net.wurstclient.util.RenderUtils;
import net.wurstclient.util.RotationUtils;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

public final class ExcavatorHack
extends Hack
implements UpdateListener,
RenderListener,
GUIRenderListener {
    private Step step;
    private class_2338 posLookingAt;
    private Area area;
    private class_2338 currentBlock;
    private ExcavatorPathFinder pathFinder;
    private PathProcessor processor;
    private final SliderSetting range = new SliderSetting("\u8ddd\u79bb", 5.0, 2.0, 6.0, 0.05, SliderSetting.ValueDisplay.DECIMAL);
    private final EnumSetting<Mode> mode = new EnumSetting("\u6a21\u5f0f", (Enum[])Mode.values(), (Enum)Mode.FAST);

    public ExcavatorHack() {
        super("\u65e0\u5dee\u522b\u7834\u574f");
        this.setCategory(Category.BLOCKS);
        this.addSetting(this.range);
        this.addSetting(this.mode);
    }

    @Override
    public String getRenderName() {
        Object name = this.getName();
        if (this.step == Step.EXCAVATE && this.area != null) {
            name = (String)name + " " + (int)((float)(this.area.blocksList.size() - this.area.remainingBlocks) / (float)this.area.blocksList.size() * 100.0f) + "%";
        }
        return name;
    }

    @Override
    public void onEnable() {
        ExcavatorHack.WURST.getHax().autoMineHack.setEnabled(false);
        ExcavatorHack.WURST.getHax().bowAimbotHack.setEnabled(false);
        ExcavatorHack.WURST.getHax().nukerHack.setEnabled(false);
        ExcavatorHack.WURST.getHax().nukerLegitHack.setEnabled(false);
        ExcavatorHack.WURST.getHax().speedNukerHack.setEnabled(false);
        ExcavatorHack.WURST.getHax().tunnellerHack.setEnabled(false);
        this.step = Step.START_POS;
        EVENTS.add(UpdateListener.class, this);
        EVENTS.add(RenderListener.class, this);
        EVENTS.add(GUIRenderListener.class, this);
    }

    @Override
    public void onDisable() {
        EVENTS.remove(UpdateListener.class, this);
        EVENTS.remove(RenderListener.class, this);
        EVENTS.remove(GUIRenderListener.class, this);
        for (Step step : Step.values()) {
            step.pos = null;
        }
        this.posLookingAt = null;
        this.area = null;
        ExcavatorHack.MC.field_1761.method_2925();
        this.currentBlock = null;
        this.pathFinder = null;
        this.processor = null;
        PathProcessor.releaseControls();
    }

    @Override
    public void onUpdate() {
        if (this.step.selectPos) {
            this.handlePositionSelection();
        } else if (this.step == Step.SCAN_AREA) {
            this.scanArea();
        } else if (this.step == Step.EXCAVATE) {
            this.excavate();
        }
    }

    @Override
    public void onRender(class_4587 matrixStack, float partialTicks) {
        if (this.pathFinder != null) {
            PathCmd pathCmd = ExcavatorHack.WURST.getCmds().pathCmd;
            this.pathFinder.renderPath(matrixStack, pathCmd.isDebugMode(), pathCmd.isDepthTest());
        }
        float scale = 0.875f;
        double offset = (1.0 - (double)scale) / 2.0;
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)2884);
        GL11.glDisable((int)2929);
        matrixStack.method_22903();
        class_2338 camPos = RenderUtils.getCameraBlockPos();
        int regionX = (camPos.method_10263() >> 9) * 512;
        int regionZ = (camPos.method_10260() >> 9) * 512;
        RenderUtils.applyRegionalRenderOffset(matrixStack, regionX, regionZ);
        RenderSystem.setShader(class_757::method_34539);
        if (this.area != null) {
            GL11.glEnable((int)2929);
            if (this.step == Step.SCAN_AREA && this.area.progress < 1.0f) {
                for (int i = Math.max(0, this.area.blocksList.size() - this.area.scanSpeed); i < this.area.blocksList.size(); ++i) {
                    class_2338 pos = this.area.blocksList.get(i);
                    matrixStack.method_22903();
                    matrixStack.method_46416((float)(pos.method_10263() - regionX), (float)pos.method_10264(), (float)(pos.method_10260() - regionZ));
                    matrixStack.method_22904(-0.005, -0.005, -0.005);
                    matrixStack.method_22905(1.01f, 1.01f, 1.01f);
                    RenderSystem.setShaderColor((float)0.0f, (float)1.0f, (float)0.0f, (float)0.15f);
                    RenderUtils.drawSolidBox(matrixStack);
                    RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.5f);
                    RenderUtils.drawOutlinedBox(matrixStack);
                    matrixStack.method_22909();
                }
            }
            matrixStack.method_22903();
            matrixStack.method_22904((double)this.area.minX + offset - (double)regionX, (double)this.area.minY + offset, (double)this.area.minZ + offset - (double)regionZ);
            matrixStack.method_22905((float)this.area.sizeX + scale, (float)this.area.sizeY + scale, (float)this.area.sizeZ + scale);
            if (this.area.progress < 1.0f) {
                matrixStack.method_22903();
                matrixStack.method_46416(0.0f, 0.0f, this.area.progress);
                matrixStack.method_22905(1.0f, 1.0f, 0.0f);
                RenderSystem.setShaderColor((float)0.0f, (float)1.0f, (float)0.0f, (float)0.3f);
                RenderUtils.drawSolidBox(matrixStack);
                RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.5f);
                RenderUtils.drawOutlinedBox(matrixStack);
                matrixStack.method_22909();
            }
            RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.5f);
            RenderUtils.drawOutlinedBox(matrixStack);
            matrixStack.method_22909();
            GL11.glDisable((int)2929);
        }
        for (Step step : Step.SELECT_POSITION_STEPS) {
            class_2338 pos = step.pos;
            if (pos == null) continue;
            matrixStack.method_22903();
            matrixStack.method_46416((float)(pos.method_10263() - regionX), (float)pos.method_10264(), (float)(pos.method_10260() - regionZ));
            matrixStack.method_22904(offset, offset, offset);
            matrixStack.method_22905(scale, scale, scale);
            RenderSystem.setShaderColor((float)0.0f, (float)1.0f, (float)0.0f, (float)0.15f);
            RenderUtils.drawSolidBox(matrixStack);
            RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.5f);
            RenderUtils.drawOutlinedBox(matrixStack);
            matrixStack.method_22909();
        }
        if (this.area == null && this.step == Step.END_POS && this.step.pos != null) {
            Area preview = new Area(Step.START_POS.pos, Step.END_POS.pos);
            GL11.glEnable((int)2929);
            matrixStack.method_22903();
            matrixStack.method_22904((double)preview.minX + offset - (double)regionX, (double)preview.minY + offset, (double)preview.minZ + offset - (double)regionZ);
            matrixStack.method_22905((float)preview.sizeX + scale, (float)preview.sizeY + scale, (float)preview.sizeZ + scale);
            RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.5f);
            RenderUtils.drawOutlinedBox(matrixStack);
            matrixStack.method_22909();
            GL11.glDisable((int)2929);
        }
        if (this.posLookingAt != null) {
            matrixStack.method_22903();
            matrixStack.method_46416((float)(this.posLookingAt.method_10263() - regionX), (float)this.posLookingAt.method_10264(), (float)(this.posLookingAt.method_10260() - regionZ));
            matrixStack.method_22904(offset, offset, offset);
            matrixStack.method_22905(scale, scale, scale);
            RenderSystem.setShader(class_757::method_34539);
            RenderSystem.setShaderColor((float)0.25f, (float)0.25f, (float)0.25f, (float)0.15f);
            RenderUtils.drawSolidBox(matrixStack);
            RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.5f);
            RenderUtils.drawOutlinedBox(matrixStack);
            matrixStack.method_22909();
        }
        if (this.currentBlock != null) {
            matrixStack.method_46416((float)(this.currentBlock.method_10263() - regionX), (float)this.currentBlock.method_10264(), (float)(this.currentBlock.method_10260() - regionZ));
            float progress = BlockUtils.getHardness(this.currentBlock) < 1.0f ? IMC.getInteractionManager().getCurrentBreakingProgress() : 1.0f;
            if (progress < 1.0f) {
                matrixStack.method_22904(0.5, 0.5, 0.5);
                matrixStack.method_22905(progress, progress, progress);
                matrixStack.method_22904(-0.5, -0.5, -0.5);
            }
            float red = progress * 2.0f;
            float green = 2.0f - red;
            RenderSystem.setShaderColor((float)red, (float)green, (float)0.0f, (float)0.25f);
            RenderUtils.drawSolidBox(matrixStack);
            RenderSystem.setShaderColor((float)red, (float)green, (float)0.0f, (float)0.5f);
            RenderUtils.drawOutlinedBox(matrixStack);
        }
        matrixStack.method_22909();
        GL11.glEnable((int)2929);
        GL11.glDisable((int)3042);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void onRenderGUI(class_332 context, float partialTicks) {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)2884);
        class_4587 matrixStack = context.method_51448();
        matrixStack.method_22903();
        Matrix4f matrix = matrixStack.method_23760().method_23761();
        class_289 tessellator = RenderSystem.renderThreadTesselator();
        class_287 bufferBuilder = tessellator.method_1349();
        String message = this.step.selectPos && this.step.pos != null ? "Press enter to confirm, or select a different position." : this.step.message;
        class_327 tr = ExcavatorHack.MC.field_1772;
        class_1041 sr = MC.method_22683();
        int msgWidth = tr.method_1727(message);
        matrixStack.method_46416((float)(sr.method_4486() / 2 - msgWidth / 2), (float)(sr.method_4502() / 2 + 1), 0.0f);
        RenderSystem.setShader(class_757::method_34539);
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.5f);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1592);
        bufferBuilder.method_22918(matrix, 0.0f, 0.0f, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, (float)(msgWidth + 2), 0.0f, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, (float)(msgWidth + 2), 10.0f, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, 0.0f, 10.0f, 0.0f).method_1344();
        tessellator.method_1350();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        context.method_51433(tr, message, 2, 1, -1, false);
        matrixStack.method_22909();
        GL11.glEnable((int)2884);
        GL11.glDisable((int)3042);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void enableWithArea(class_2338 pos1, class_2338 pos2) {
        this.setEnabled(true);
        Step.START_POS.pos = pos1;
        Step.END_POS.pos = pos2;
        this.step = Step.SCAN_AREA;
    }

    private void handlePositionSelection() {
        if (this.step.pos != null && class_3675.method_15987((long)MC.method_22683().method_4490(), (int)257)) {
            this.step = Step.values()[this.step.ordinal() + 1];
            if (!this.step.selectPos) {
                this.posLookingAt = null;
            }
            return;
        }
        if (ExcavatorHack.MC.field_1765 instanceof class_3965) {
            this.posLookingAt = ((class_3965)ExcavatorHack.MC.field_1765).method_17777();
            if (ExcavatorHack.MC.field_1690.field_1832.method_1434()) {
                this.posLookingAt = this.posLookingAt.method_10093(((class_3965)ExcavatorHack.MC.field_1765).method_17780());
            }
        } else {
            this.posLookingAt = null;
        }
        if (this.posLookingAt != null && ExcavatorHack.MC.field_1690.field_1904.method_1434()) {
            this.step.pos = this.posLookingAt;
        }
    }

    private void scanArea() {
        if (this.area == null) {
            this.area = new Area(Step.START_POS.pos, Step.END_POS.pos);
            Step.START_POS.pos = null;
            Step.END_POS.pos = null;
        }
        for (int i = 0; i < this.area.scanSpeed && this.area.iterator.hasNext(); ++i) {
            ++this.area.scannedBlocks;
            class_2338 pos = this.area.iterator.next();
            if (!BlockUtils.canBeClicked(pos)) continue;
            this.area.blocksList.add(pos);
            this.area.blocksSet.add(pos);
        }
        this.area.progress = (float)this.area.scannedBlocks / (float)this.area.totalBlocks;
        if (!this.area.iterator.hasNext()) {
            this.area.remainingBlocks = this.area.blocksList.size();
            this.step = Step.values()[this.step.ordinal() + 1];
        }
    }

    private void excavate() {
        boolean legit = this.mode.getSelected() == Mode.LEGIT;
        this.currentBlock = null;
        ArrayList<class_2338> validBlocks = this.getValidBlocks(this.range.getValue(), pos -> this.area.blocksSet.contains(pos));
        if (ExcavatorHack.MC.field_1724.method_31549().field_7477 && !legit) {
            ExcavatorHack.MC.field_1761.method_2925();
            Iterator iterator = validBlocks.iterator();
            if (iterator.hasNext()) {
                class_2338 pos2 = (class_2338)iterator.next();
                this.currentBlock = pos2;
            }
            BlockBreaker.breakBlocksWithPacketSpam(validBlocks);
        } else {
            ArrayList<class_2338> blocks = new ArrayList<class_2338>();
            for (class_2338 pos3 : validBlocks) {
                blocks.add(pos3);
            }
            blocks.sort(Comparator.comparingInt(pos -> -pos.method_10264()));
            for (class_2338 pos3 : blocks) {
                boolean successful = BlockBreaker.breakOneBlock(pos3);
                if (!successful) continue;
                this.currentBlock = pos3;
                break;
            }
            if (this.currentBlock == null) {
                ExcavatorHack.MC.field_1761.method_2925();
            }
        }
        Predicate<class_2338> pClickable = BlockUtils::canBeClicked;
        this.area.remainingBlocks = (int)this.area.blocksList.parallelStream().filter(pClickable).count();
        if (this.area.remainingBlocks == 0) {
            this.setEnabled(false);
            return;
        }
        if (this.pathFinder == null) {
            Comparator<class_2338> cDistance = Comparator.comparingDouble(pos -> ExcavatorHack.MC.field_1724.method_5707(class_243.method_24953((class_2382)pos)));
            Comparator<class_2338> cAltitude = Comparator.comparingInt(pos -> -pos.method_10264());
            class_2338 closestBlock = this.area.blocksList.parallelStream().filter(pClickable).min(cAltitude.thenComparing(cDistance)).get();
            this.pathFinder = new ExcavatorPathFinder(closestBlock);
        }
        if (!this.pathFinder.isDone() && !this.pathFinder.isFailed()) {
            PathProcessor.lockControls();
            this.pathFinder.think();
            if (!this.pathFinder.isDone() && !this.pathFinder.isFailed()) {
                return;
            }
            this.pathFinder.formatPath();
            this.processor = this.pathFinder.getProcessor();
        }
        if (this.processor != null && !this.pathFinder.isPathStillValid(this.processor.getIndex())) {
            this.pathFinder = new ExcavatorPathFinder(this.pathFinder);
            return;
        }
        this.processor.process();
        if (this.processor.isDone()) {
            this.pathFinder = null;
            this.processor = null;
            PathProcessor.releaseControls();
        }
    }

    private ArrayList<class_2338> getValidBlocks(double range, Predicate<class_2338> validator) {
        class_243 eyesVec = RotationUtils.getEyesPos().method_1023(0.5, 0.5, 0.5);
        double rangeSq = Math.pow(range + 0.5, 2.0);
        int rangeI = (int)Math.ceil(range);
        class_2338 center = class_2338.method_49638((class_2374)RotationUtils.getEyesPos());
        class_2338 min = center.method_10069(-rangeI, -rangeI, -rangeI);
        class_2338 max = center.method_10069(rangeI, rangeI, rangeI);
        return BlockUtils.getAllInBox(min, max).stream().filter(pos -> eyesVec.method_1025(class_243.method_24954((class_2382)pos)) <= rangeSq).filter(BlockUtils::canBeClicked).filter(validator).sorted(Comparator.comparingDouble(pos -> eyesVec.method_1025(class_243.method_24954((class_2382)pos)))).collect(Collectors.toCollection(ArrayList::new));
    }

    private static enum Mode {
        FAST("Fast"),
        LEGIT("Legit");

        private final String name;

        private Mode(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    private static enum Step {
        START_POS("Select start position.", true),
        END_POS("Select end position.", true),
        SCAN_AREA("Scanning area...", false),
        EXCAVATE("Excavating...", false);

        private static final Step[] SELECT_POSITION_STEPS;
        private final String message;
        private boolean selectPos;
        private class_2338 pos;

        private Step(String message, boolean selectPos) {
            this.message = message;
            this.selectPos = selectPos;
        }

        static {
            SELECT_POSITION_STEPS = new Step[]{START_POS, END_POS};
        }
    }

    private static class Area {
        private final int minX;
        private final int minY;
        private final int minZ;
        private final int sizeX;
        private final int sizeY;
        private final int sizeZ;
        private final int totalBlocks;
        private final int scanSpeed;
        private final Iterator<class_2338> iterator;
        private int scannedBlocks;
        private int remainingBlocks;
        private float progress;
        private final ArrayList<class_2338> blocksList = new ArrayList();
        private final HashSet<class_2338> blocksSet = new HashSet();

        private Area(class_2338 start, class_2338 end) {
            int startX = start.method_10263();
            int startY = start.method_10264();
            int startZ = start.method_10260();
            int endX = end.method_10263();
            int endY = end.method_10264();
            int endZ = end.method_10260();
            this.minX = Math.min(startX, endX);
            this.minY = Math.min(startY, endY);
            this.minZ = Math.min(startZ, endZ);
            this.sizeX = Math.abs(startX - endX);
            this.sizeY = Math.abs(startY - endY);
            this.sizeZ = Math.abs(startZ - endZ);
            this.totalBlocks = (this.sizeX + 1) * (this.sizeY + 1) * (this.sizeZ + 1);
            this.scanSpeed = class_3532.method_15340((int)(this.totalBlocks / 30), (int)1, (int)16384);
            this.iterator = BlockUtils.getAllInBox(start, end).iterator();
        }
    }

    private static class ExcavatorPathFinder
    extends PathFinder {
        public ExcavatorPathFinder(class_2338 goal) {
            super(goal);
            this.setThinkTime(10);
        }

        public ExcavatorPathFinder(ExcavatorPathFinder pathFinder) {
            super(pathFinder);
        }

        @Override
        protected boolean checkDone() {
            class_2338 goal = this.getGoal();
            this.done = goal.method_10087(2).equals((Object)this.current) || goal.method_10084().equals((Object)this.current) || goal.method_10095().equals((Object)this.current) || goal.method_10072().equals((Object)this.current) || goal.method_10067().equals((Object)this.current) || goal.method_10078().equals((Object)this.current) || goal.method_10074().method_10095().equals((Object)this.current) || goal.method_10074().method_10072().equals((Object)this.current) || goal.method_10074().method_10067().equals((Object)this.current) || goal.method_10074().method_10078().equals((Object)this.current);
            return this.done;
        }
    }
}

