/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.hacks.autocomplete;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import net.wurstclient.hacks.autocomplete.MessageCompleter;
import net.wurstclient.hacks.autocomplete.ModelSettings;
import net.wurstclient.util.json.JsonException;
import net.wurstclient.util.json.JsonUtils;
import net.wurstclient.util.json.WsonObject;

public final class OpenAiMessageCompleter
extends MessageCompleter {
    public OpenAiMessageCompleter(ModelSettings modelSettings) {
        super(modelSettings);
    }

    @Override
    protected JsonObject buildParams(String prompt) {
        JsonObject params = new JsonObject();
        params.addProperty("stop", this.modelSettings.stopSequence.getSelected().getSequence());
        params.addProperty("model", "" + this.modelSettings.openAiModel.getSelected());
        params.addProperty("max_tokens", (Number)this.modelSettings.maxTokens.getValueI());
        params.addProperty("temperature", (Number)this.modelSettings.temperature.getValue());
        params.addProperty("top_p", (Number)this.modelSettings.topP.getValue());
        params.addProperty("presence_penalty", (Number)this.modelSettings.presencePenalty.getValue());
        params.addProperty("frequency_penalty", (Number)this.modelSettings.frequencyPenalty.getValue());
        if (this.modelSettings.openAiModel.getSelected().isChatModel()) {
            JsonArray messages = new JsonArray();
            JsonObject promptMessage = new JsonObject();
            promptMessage.addProperty("role", "user");
            promptMessage.addProperty("content", prompt);
            messages.add((JsonElement)promptMessage);
            params.add("messages", (JsonElement)messages);
        } else {
            params.addProperty("prompt", prompt);
        }
        return params;
    }

    @Override
    protected WsonObject requestCompletion(JsonObject parameters) throws IOException, JsonException {
        URL url = this.modelSettings.openAiModel.getSelected().isChatModel() ? new URL(this.modelSettings.openaiChatEndpoint.getValue()) : new URL(this.modelSettings.openaiLegacyEndpoint.getValue());
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setRequestProperty("Authorization", "Bearer " + System.getenv("WURST_OPENAI_KEY"));
        conn.setDoOutput(true);
        try (OutputStream os = conn.getOutputStream();){
            os.write(JsonUtils.GSON.toJson((JsonElement)parameters).getBytes());
            os.flush();
        }
        return JsonUtils.parseConnectionToObject(conn);
    }

    @Override
    protected String extractCompletion(WsonObject response) throws JsonException {
        String completion = this.modelSettings.openAiModel.getSelected().isChatModel() ? response.getArray("choices").getObject(0).getObject("message").getString("content") : response.getArray("choices").getObject(0).getString("text");
        completion = completion.replace("\n", " ");
        return completion;
    }
}

