/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.navigator;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import net.wurstclient.Feature;
import net.wurstclient.WurstClient;
import net.wurstclient.clickgui.ClickGui;
import net.wurstclient.hacks.TooManyHaxHack;
import net.wurstclient.navigator.Navigator;
import net.wurstclient.navigator.NavigatorFeatureScreen;
import net.wurstclient.navigator.NavigatorScreen;
import net.wurstclient.util.ChatUtils;
import net.wurstclient.util.RenderUtils;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

public final class NavigatorMainScreen
extends NavigatorScreen {
    private static final ArrayList<Feature> navigatorDisplayList = new ArrayList();
    private class_342 searchBar;
    private String lastSearchText = "";
    private String tooltip;
    private int hoveredFeature = -1;
    private int selectedFeature = 0;
    private boolean mouseMoved = false;
    private boolean hoveringArrow;
    private int clickTimer = -1;
    private boolean expanding = false;
    private Feature expandingFeature;

    public NavigatorMainScreen() {
        this.hasBackground = false;
        this.nonScrollableArea = 0;
        Navigator navigator = WurstClient.INSTANCE.getNavigator();
        navigator.copyNavigatorList(navigatorDisplayList);
    }

    @Override
    protected void onResize() {
        ClickGui gui = WurstClient.INSTANCE.getGui();
        int txtColor = gui.getTxtColor();
        class_327 tr = WurstClient.MC.field_1772;
        this.searchBar = new class_342(tr, 0, 32, 200, 20, (class_2561)class_2561.method_43470((String)""));
        this.searchBar.method_1868(txtColor);
        this.searchBar.method_1858(false);
        this.searchBar.method_1880(128);
        this.method_25429((class_364)this.searchBar);
        this.method_25395((class_364)this.searchBar);
        this.searchBar.method_25365(true);
        this.searchBar.method_46421(this.middleX - 100);
        this.setContentHeight(navigatorDisplayList.size() / 3 * 20);
    }

    @Override
    protected void onKeyPress(int keyCode, int scanCode, int int_3) {
        if (keyCode == 257) {
            this.leftClick(this.selectedFeature);
        }
        if (keyCode == 32) {
            this.expand(this.selectedFeature);
        }
        if (keyCode == 262 || keyCode == 258 && !NavigatorMainScreen.method_25442()) {
            if (this.selectedFeature + 1 < navigatorDisplayList.size()) {
                ++this.selectedFeature;
            }
        } else if (keyCode == 263 || keyCode == 258 && NavigatorMainScreen.method_25442()) {
            if (this.selectedFeature - 1 > -1) {
                --this.selectedFeature;
            }
        } else if (keyCode == 264) {
            if (this.selectedFeature + 3 < navigatorDisplayList.size()) {
                this.selectedFeature += 3;
            }
        } else if (keyCode == 265 && this.selectedFeature - 3 > -1) {
            this.selectedFeature -= 3;
        }
    }

    @Override
    protected void onMouseClick(double x, double y, int button) {
        if (this.clickTimer != -1) {
            return;
        }
        if (button == 3) {
            WurstClient.MC.method_1507((class_437)null);
            return;
        }
        if (this.hoveredFeature == -1) {
            return;
        }
        if (button == 0 && (NavigatorMainScreen.method_25442() || this.hoveringArrow) || button == 2) {
            this.expand(this.hoveredFeature);
            return;
        }
        if (button == 0) {
            this.leftClick(this.hoveredFeature);
        }
    }

    private void expand(int i) {
        if (i < 0 || i >= navigatorDisplayList.size()) {
            return;
        }
        this.expandingFeature = navigatorDisplayList.get(i);
        this.expanding = true;
    }

    private void leftClick(int i) {
        if (i < 0 || i >= navigatorDisplayList.size()) {
            return;
        }
        Feature feature = navigatorDisplayList.get(i);
        if (feature.getPrimaryAction().isEmpty()) {
            this.expanding = true;
            this.expandingFeature = feature;
            return;
        }
        WurstClient wurst = WurstClient.INSTANCE;
        TooManyHaxHack tooManyHax = wurst.getHax().tooManyHaxHack;
        if (tooManyHax.isEnabled() && tooManyHax.isBlocked(feature)) {
            ChatUtils.error(feature.getName() + " is blocked by TooManyHax.");
            return;
        }
        feature.doPrimaryAction();
        wurst.getNavigator().addPreference(feature.getName());
    }

    @Override
    protected void onUpdate() {
        this.searchBar.method_1865();
        String newText = this.searchBar.method_1882();
        if (this.clickTimer == -1 && !newText.equals(this.lastSearchText)) {
            Navigator navigator = WurstClient.INSTANCE.getNavigator();
            if (newText.isEmpty()) {
                navigator.copyNavigatorList(navigatorDisplayList);
            } else {
                newText = newText.toLowerCase().trim();
                navigator.getSearchResults(navigatorDisplayList, newText);
            }
            this.setContentHeight(navigatorDisplayList.size() / 3 * 20);
            this.lastSearchText = newText;
            this.selectedFeature = 0;
        }
        if (this.expanding) {
            if (this.clickTimer < 4) {
                ++this.clickTimer;
            } else {
                WurstClient.MC.method_1507((class_437)new NavigatorFeatureScreen(this.expandingFeature, this));
            }
        } else if (!this.expanding && this.clickTimer > -1) {
            --this.clickTimer;
        }
        this.scrollbarLocked = this.clickTimer != -1;
    }

    public void method_16014(double mouseX, double mouseY) {
        this.mouseMoved = true;
    }

    @Override
    protected void onRender(class_332 context, int mouseX, int mouseY, float partialTicks) {
        class_4587 matrixStack = context.method_51448();
        ClickGui gui = WurstClient.INSTANCE.getGui();
        float[] bgColor = gui.getBgColor();
        float[] acColor = gui.getAcColor();
        int txtColor = gui.getTxtColor();
        boolean clickTimerRunning = this.clickTimer != -1;
        this.tooltip = null;
        if (!clickTimerRunning) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            context.method_25303(WurstClient.MC.field_1772, "Search: ", this.middleX - 150, 32, txtColor);
            this.searchBar.method_25394(context, mouseX, mouseY, partialTicks);
            GL11.glEnable((int)3042);
        }
        int listX = this.middleX - 154;
        if (!clickTimerRunning) {
            this.hoveredFeature = -1;
        }
        RenderUtils.scissorBox(0, 59, this.field_22789, this.field_22790 - 42);
        GL11.glEnable((int)3089);
        for (int i = Math.max(-this.scroll * 3 / 20 - 3, 0); i < navigatorDisplayList.size(); ++i) {
            int featureX = listX + 104 * (i % 3);
            int featureY = 60 + i / 3 * 20 + this.scroll;
            if (featureY < 40) continue;
            if (featureY > this.field_22790 - 40) break;
            this.renderFeature(context, mouseX, mouseY, partialTicks, i, featureX, featureY);
        }
        GL11.glDisable((int)3089);
        if (this.tooltip != null) {
            String[] lines = this.tooltip.split("\n");
            class_327 tr = this.field_22787.field_1772;
            int tw = 0;
            int n = lines.length;
            Objects.requireNonNull(tr);
            int th = n * 9;
            for (String line : lines) {
                int lw = tr.method_1727(line);
                if (lw <= tw) continue;
                tw = lw;
            }
            int sw = this.field_22787.field_1755.field_22789;
            int sh = this.field_22787.field_1755.field_22790;
            int xt1 = mouseX + tw + 11 <= sw ? mouseX + 8 : mouseX - tw - 8;
            int xt2 = xt1 + tw + 3;
            int yt1 = mouseY + th - 2 <= sh ? mouseY - 4 : mouseY - th - 4;
            int yt2 = yt1 + th + 2;
            Matrix4f matrix = matrixStack.method_23760().method_23761();
            class_289 tessellator = RenderSystem.renderThreadTesselator();
            class_287 bufferBuilder = tessellator.method_1349();
            RenderSystem.setShader(class_757::method_34539);
            RenderSystem.setShaderColor((float)bgColor[0], (float)bgColor[1], (float)bgColor[2], (float)0.75f);
            bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1592);
            bufferBuilder.method_22918(matrix, (float)xt1, (float)yt1, 0.0f).method_1344();
            bufferBuilder.method_22918(matrix, (float)xt1, (float)yt2, 0.0f).method_1344();
            bufferBuilder.method_22918(matrix, (float)xt2, (float)yt2, 0.0f).method_1344();
            bufferBuilder.method_22918(matrix, (float)xt2, (float)yt1, 0.0f).method_1344();
            tessellator.method_1350();
            RenderSystem.setShaderColor((float)acColor[0], (float)acColor[1], (float)acColor[2], (float)0.5f);
            bufferBuilder.method_1328(class_293.class_5596.field_29345, class_290.field_1592);
            bufferBuilder.method_22918(matrix, (float)xt1, (float)yt1, 0.0f).method_1344();
            bufferBuilder.method_22918(matrix, (float)xt1, (float)yt2, 0.0f).method_1344();
            bufferBuilder.method_22918(matrix, (float)xt2, (float)yt2, 0.0f).method_1344();
            bufferBuilder.method_22918(matrix, (float)xt2, (float)yt1, 0.0f).method_1344();
            bufferBuilder.method_22918(matrix, (float)xt1, (float)yt1, 0.0f).method_1344();
            tessellator.method_1350();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            for (int i = 0; i < lines.length; ++i) {
                String string = lines[i];
                Objects.requireNonNull(tr);
                context.method_51433(tr, string, xt1 + 2, yt1 + 2 + i * 9, txtColor, false);
            }
        }
    }

    private void renderFeature(class_332 context, int mouseX, int mouseY, float partialTicks, int i, int x, int y) {
        boolean renderAsHovered;
        class_4587 matrixStack = context.method_51448();
        ClickGui gui = WurstClient.INSTANCE.getGui();
        float[] bgColor = gui.getBgColor();
        int txtColor = gui.getTxtColor();
        float opacity = gui.getOpacity();
        boolean clickTimerRunning = this.clickTimer != -1;
        Feature feature = navigatorDisplayList.get(i);
        Rectangle area = new Rectangle(x, y, 100, 16);
        if (clickTimerRunning) {
            if (feature != this.expandingFeature) {
                return;
            }
            float factor = this.expanding ? (this.clickTimer == 4 ? 1.0f : ((float)this.clickTimer + partialTicks) / 4.0f) : (this.clickTimer == 0 ? 0.0f : ((float)this.clickTimer - partialTicks) / 4.0f);
            float antiFactor = 1.0f - factor;
            area.x = (int)((float)area.x * antiFactor + (float)(this.middleX - 154) * factor);
            area.y = (int)((float)area.y * antiFactor + 60.0f * factor);
            area.width = (int)((float)area.width * antiFactor + 308.0f * factor);
            area.height = (int)((float)area.height * antiFactor + (float)(this.field_22790 - 103) * factor);
            this.drawBackgroundBox(matrixStack, area.x, area.y, area.x + area.width, area.y + area.height);
            return;
        }
        boolean hovering = area.contains(mouseX, mouseY);
        if (hovering) {
            this.hoveredFeature = i;
            if (this.mouseMoved) {
                this.selectedFeature = i;
                this.mouseMoved = false;
            }
        }
        boolean bl = renderAsHovered = hovering || this.selectedFeature == i;
        if (feature.isEnabled()) {
            RenderSystem.setShaderColor((float)0.0f, (float)1.0f, (float)0.0f, (float)(renderAsHovered ? opacity * 1.5f : opacity));
        } else {
            RenderSystem.setShaderColor((float)bgColor[0], (float)bgColor[1], (float)bgColor[2], (float)(renderAsHovered ? opacity * 1.5f : opacity));
        }
        String tt = feature.getWrappedDescription(200);
        if (hovering) {
            this.tooltip = tt;
        }
        this.drawBox(matrixStack, area.x, area.y, area.x + area.width, area.y + area.height);
        Matrix4f matrix = matrixStack.method_23760().method_23761();
        class_289 tessellator = RenderSystem.renderThreadTesselator();
        class_287 bufferBuilder = tessellator.method_1349();
        RenderSystem.setShader(class_757::method_34539);
        int bx1 = area.x + area.width - area.height;
        int by1 = area.y + 2;
        int by2 = by1 + area.height - 4;
        float[] acColor = WurstClient.INSTANCE.getGui().getAcColor();
        RenderSystem.setShaderColor((float)acColor[0], (float)acColor[1], (float)acColor[2], (float)0.5f);
        bufferBuilder.method_1328(class_293.class_5596.field_29344, class_290.field_1592);
        bufferBuilder.method_22918(matrix, (float)bx1, (float)by1, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, (float)bx1, (float)by2, 0.0f).method_1344();
        tessellator.method_1350();
        if (hovering) {
            this.hoveringArrow = mouseX >= bx1;
        }
        float oneThrird = (float)area.height / 3.0f;
        float twoThrirds = (float)area.height * 2.0f / 3.0f;
        float ax1 = (float)bx1 + oneThrird - 2.0f;
        float ax2 = (float)bx1 + twoThrirds + 2.0f;
        float ax3 = (float)bx1 + (float)area.height / 2.0f;
        float ay1 = (float)area.y + oneThrird;
        float ay2 = (float)area.y + twoThrirds;
        RenderSystem.setShaderColor((float)0.0f, (float)(hovering ? 1.0f : 0.85f), (float)0.0f, (float)1.0f);
        bufferBuilder.method_1328(class_293.class_5596.field_27379, class_290.field_1592);
        bufferBuilder.method_22918(matrix, ax1, ay1, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, ax2, ay1, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, ax3, ay2, 0.0f).method_1344();
        tessellator.method_1350();
        RenderSystem.setShaderColor((float)0.0625f, (float)0.0625f, (float)0.0625f, (float)0.5f);
        bufferBuilder.method_1328(class_293.class_5596.field_29345, class_290.field_1592);
        bufferBuilder.method_22918(matrix, ax1, ay1, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, ax2, ay1, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, ax3, ay2, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, ax1, ay1, 0.0f).method_1344();
        tessellator.method_1350();
        if (!clickTimerRunning) {
            RenderSystem.setShader(class_757::method_34539);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            String buttonText = feature.getName();
            context.method_51433(this.field_22787.field_1772, buttonText, area.x + 4, area.y + 4, txtColor, false);
            GL11.glEnable((int)3042);
        }
    }

    public void setExpanding(boolean expanding) {
        this.expanding = expanding;
    }

    @Override
    protected void onMouseDrag(double mouseX, double mouseY, int button, double double_3, double double_4) {
    }

    @Override
    protected void onMouseRelease(double x, double y, int button) {
    }
}

