/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.navigator;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.wurstclient.WurstClient;
import net.wurstclient.clickgui.ClickGui;
import net.wurstclient.keybinds.PossibleKeybind;
import net.wurstclient.mixinterface.IScreen;
import net.wurstclient.navigator.NavigatorFeatureScreen;
import net.wurstclient.navigator.NavigatorScreen;
import net.wurstclient.util.RenderUtils;
import org.lwjgl.opengl.GL11;

public class NavigatorRemoveKeybindScreen
extends NavigatorScreen {
    private NavigatorFeatureScreen parent;
    private TreeMap<String, PossibleKeybind> existingKeybinds;
    private String hoveredKey = "";
    private String selectedKey = "";
    private String text = "Select the keybind you want to remove.";
    private class_4185 removeButton;

    public NavigatorRemoveKeybindScreen(TreeMap<String, PossibleKeybind> existingKeybinds, NavigatorFeatureScreen parent) {
        this.existingKeybinds = existingKeybinds;
        this.parent = parent;
    }

    @Override
    protected void onResize() {
        this.removeButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Remove"), b -> this.remove()).method_46434(this.field_22789 / 2 - 151, this.field_22790 - 65, 149, 18).method_46431();
        this.removeButton.field_22763 = !this.selectedKey.isEmpty();
        this.method_37063((class_364)this.removeButton);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Cancel"), b -> this.field_22787.method_1507((class_437)this.parent)).method_46434(this.field_22789 / 2 + 2, this.field_22790 - 65, 149, 18).method_46431());
    }

    private void remove() {
        String oldCommands = WurstClient.INSTANCE.getKeybinds().getCommands(this.selectedKey);
        if (oldCommands == null) {
            return;
        }
        ArrayList<String> commandsList = new ArrayList<String>(Arrays.asList(oldCommands.replace(";", "\u00a7").replace("\u00a7\u00a7", ";").split("\u00a7")));
        for (int i = 0; i < commandsList.size(); ++i) {
            commandsList.set(i, commandsList.get(i).trim());
        }
        String command = this.existingKeybinds.get(this.selectedKey).getCommand();
        while (commandsList.contains(command)) {
            commandsList.remove(command);
        }
        if (commandsList.isEmpty()) {
            WurstClient.INSTANCE.getKeybinds().remove(this.selectedKey);
        } else {
            String newCommands = String.join((CharSequence)"\u00a7", commandsList).replace(";", "\u00a7\u00a7").replace("\u00a7", ";");
            WurstClient.INSTANCE.getKeybinds().add(this.selectedKey, newCommands);
        }
        WurstClient.INSTANCE.getNavigator().addPreference(this.parent.getFeature().getName());
        this.field_22787.method_1507((class_437)this.parent);
    }

    @Override
    protected void onKeyPress(int keyCode, int scanCode, int int_3) {
        if (keyCode == 256 || keyCode == 259) {
            this.field_22787.method_1507((class_437)this.parent);
        }
    }

    @Override
    protected void onMouseClick(double x, double y, int button) {
        if (button == 3) {
            WurstClient.MC.method_1507((class_437)this.parent);
            return;
        }
        if (!this.hoveredKey.isEmpty()) {
            this.selectedKey = this.hoveredKey;
            this.removeButton.field_22763 = true;
        }
    }

    @Override
    protected void onUpdate() {
        this.setContentHeight(this.existingKeybinds.size() * 24 - 10);
    }

    @Override
    protected void onRender(class_332 context, int mouseX, int mouseY, float partialTicks) {
        int y2;
        int y1;
        int x2;
        class_4587 matrixStack = context.method_51448();
        ClickGui gui = WurstClient.INSTANCE.getGui();
        int txtColor = gui.getTxtColor();
        context.method_25300(this.field_22787.field_1772, "Remove Keybind", this.middleX, 32, txtColor);
        GL11.glEnable((int)3042);
        int bgx1 = this.middleX - 154;
        int bgx2 = this.middleX + 154;
        int bgy1 = 60;
        int bgy2 = this.field_22790 - 43;
        RenderUtils.scissorBox(bgx1, bgy1, bgx2, bgy2 - (((IScreen)((Object)this)).getButtons().isEmpty() ? 0 : 24));
        GL11.glEnable((int)3089);
        this.hoveredKey = "";
        int yi = bgy1 - 12 + this.scroll;
        for (Map.Entry<String, PossibleKeybind> entry : this.existingKeybinds.entrySet()) {
            String key = entry.getKey();
            PossibleKeybind keybind = entry.getValue();
            int x1 = bgx1 + 2;
            x2 = bgx2 - 2;
            y1 = yi += 24;
            y2 = y1 + 20;
            if (mouseX >= x1 && mouseX <= x2 && mouseY >= y1 && mouseY <= y2) {
                this.hoveredKey = key;
                if (key.equals(this.selectedKey)) {
                    RenderSystem.setShaderColor((float)0.0f, (float)1.0f, (float)0.0f, (float)0.375f);
                } else {
                    RenderSystem.setShaderColor((float)0.25f, (float)0.25f, (float)0.25f, (float)0.375f);
                }
            } else if (key.equals(this.selectedKey)) {
                RenderSystem.setShaderColor((float)0.0f, (float)1.0f, (float)0.0f, (float)0.25f);
            } else {
                RenderSystem.setShaderColor((float)0.25f, (float)0.25f, (float)0.25f, (float)0.25f);
            }
            this.drawBox(matrixStack, x1, y1, x2, y2);
            context.method_25303(this.field_22787.field_1772, key.replace("key.keyboard.", "") + ": " + keybind.getDescription(), x1 + 1, y1 + 1, txtColor);
            class_327 class_3272 = this.field_22787.field_1772;
            String string = keybind.getCommand();
            Objects.requireNonNull(this.field_22787.field_1772);
            context.method_25303(class_3272, string, x1 + 1, y1 + 1 + 9, txtColor);
            GL11.glEnable((int)3042);
        }
        int textY = bgy1 + this.scroll + 2;
        for (String line : this.text.split("\n")) {
            context.method_25303(this.field_22787.field_1772, line, bgx1 + 2, textY, txtColor);
            Objects.requireNonNull(this.field_22787.field_1772);
            textY += 9;
        }
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3089);
        for (class_4068 d : ((IScreen)((Object)this)).getButtons()) {
            if (!(d instanceof class_339)) continue;
            class_339 button = (class_339)d;
            int x1 = button.method_46426();
            x2 = x1 + button.method_25368();
            y1 = button.method_46427();
            y2 = y1 + 18;
            if (!button.field_22763) {
                RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.25f);
            } else if (mouseX >= x1 && mouseX <= x2 && mouseY >= y1 && mouseY <= y2) {
                RenderSystem.setShaderColor((float)0.375f, (float)0.375f, (float)0.375f, (float)0.25f);
            } else {
                RenderSystem.setShaderColor((float)0.25f, (float)0.25f, (float)0.25f, (float)0.25f);
            }
            this.drawBox(matrixStack, x1, y1, x2, y2);
            context.method_25300(this.field_22787.field_1772, button.method_25369().getString(), (x1 + x2) / 2, y1 + 5, txtColor);
            GL11.glEnable((int)3042);
        }
    }

    @Override
    protected void onMouseDrag(double mouseX, double mouseY, int button, double double_3, double double_4) {
    }

    @Override
    protected void onMouseRelease(double x, double y, int button) {
    }

    public boolean method_25422() {
        return false;
    }
}

