/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.navigator;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Rectangle;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import net.wurstclient.WurstClient;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

public abstract class NavigatorScreen
extends class_437 {
    protected int scroll = 0;
    private int scrollKnobPosition = 2;
    private boolean scrolling;
    private int maxScroll;
    protected boolean scrollbarLocked;
    protected int middleX;
    protected boolean hasBackground = true;
    protected int nonScrollableArea = 26;
    private boolean showScrollbar;

    public NavigatorScreen() {
        super((class_2561)class_2561.method_43470((String)""));
    }

    protected final void method_25426() {
        this.middleX = this.field_22789 / 2;
        this.onResize();
    }

    public final boolean method_25404(int keyCode, int scanCode, int int_3) {
        this.onKeyPress(keyCode, scanCode, int_3);
        return super.method_25404(keyCode, scanCode, int_3);
    }

    public final boolean method_25402(double x, double y, int button) {
        if (new Rectangle(this.field_22789 / 2 + 170, 60, 12, this.field_22790 - 103).contains(x, y)) {
            this.scrolling = true;
        }
        this.onMouseClick(x, y, button);
        return super.method_25402(x, y, button);
    }

    public final boolean method_25403(double mouseX, double mouseY, int mouseButton, double double_3, double double_4) {
        if (this.scrolling && !this.scrollbarLocked && mouseButton == 0) {
            this.scroll = this.maxScroll == 0 ? 0 : (int)((mouseY - 72.0) * (double)this.maxScroll / (double)(this.field_22790 - 131));
            if (this.scroll > 0) {
                this.scroll = 0;
            } else if (this.scroll < this.maxScroll) {
                this.scroll = this.maxScroll;
            }
            this.scrollKnobPosition = this.maxScroll == 0 ? 0 : (int)((float)((this.field_22790 - 131) * this.scroll) / (float)this.maxScroll);
            this.scrollKnobPosition += 2;
        }
        this.onMouseDrag(mouseX, mouseY, mouseButton, double_3, double_4);
        return super.method_25403(mouseX, mouseY, mouseButton, double_3, double_4);
    }

    public final boolean method_25406(double x, double y, int button) {
        this.scrolling = false;
        this.onMouseRelease(x, y, button);
        return super.method_25406(x, y, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        if (!this.scrollbarLocked) {
            this.scroll = (int)((double)this.scroll + delta * 4.0);
            if (this.scroll > 0) {
                this.scroll = 0;
            } else if (this.scroll < this.maxScroll) {
                this.scroll = this.maxScroll;
            }
            this.scrollKnobPosition = this.maxScroll == 0 ? 0 : (int)((float)((this.field_22790 - 131) * this.scroll) / (float)this.maxScroll);
            this.scrollKnobPosition += 2;
        }
        return super.method_25401(mouseX, mouseY, delta);
    }

    public final void method_25393() {
        this.onUpdate();
    }

    public final void method_25394(class_332 context, int mouseX, int mouseY, float partialTicks) {
        class_4587 matrixStack = context.method_51448();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)2884);
        int bgx1 = this.middleX - 154;
        int bgx2 = this.middleX + 154;
        int bgy1 = 60;
        int bgy2 = this.field_22790 - 43;
        if (this.hasBackground) {
            this.drawBackgroundBox(matrixStack, bgx1, bgy1, bgx2, bgy2);
        }
        if (this.showScrollbar) {
            int x1 = bgx2 + 16;
            int x2 = x1 + 12;
            int y1 = bgy1;
            int y2 = bgy2;
            this.drawBackgroundBox(matrixStack, x1, y1, x2, y2);
            y2 = (y1 += this.scrollKnobPosition) + 24;
            this.drawForegroundBox(matrixStack, x1 += 2, y1, x2 -= 2, y2);
            ++x1;
            --x2;
            y1 += 8;
            y2 -= 15;
            for (int i = 0; i < 3; ++i) {
                this.drawDownShadow(matrixStack, x1, y1, x2, y2);
                y1 += 4;
                y2 += 4;
            }
        }
        this.onRender(context, mouseX, mouseY, partialTicks);
        GL11.glEnable((int)2884);
        GL11.glDisable((int)3042);
    }

    public final boolean method_25421() {
        return false;
    }

    protected abstract void onResize();

    protected abstract void onKeyPress(int var1, int var2, int var3);

    protected abstract void onMouseClick(double var1, double var3, int var5);

    protected abstract void onMouseDrag(double var1, double var3, int var5, double var6, double var8);

    protected abstract void onMouseRelease(double var1, double var3, int var5);

    protected abstract void onUpdate();

    protected abstract void onRender(class_332 var1, int var2, int var3, float var4);

    protected final int getStringHeight(String s) {
        int fontHeight;
        Objects.requireNonNull(this.field_22787.field_1772);
        int height = fontHeight = 9;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != '\n') continue;
            height += fontHeight;
        }
        return height;
    }

    protected final void setContentHeight(int contentHeight) {
        this.maxScroll = this.field_22790 - contentHeight - this.nonScrollableArea - 120;
        if (this.maxScroll > 0) {
            this.maxScroll = 0;
        }
        boolean bl = this.showScrollbar = this.maxScroll != 0;
        if (this.scroll < this.maxScroll) {
            this.scroll = this.maxScroll;
        }
    }

    protected final void drawQuads(class_4587 matrixStack, int x1, int y1, int x2, int y2) {
        Matrix4f matrix = matrixStack.method_23760().method_23761();
        class_289 tessellator = RenderSystem.renderThreadTesselator();
        class_287 bufferBuilder = tessellator.method_1349();
        RenderSystem.setShader(class_757::method_34539);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1592);
        bufferBuilder.method_22918(matrix, (float)x1, (float)y1, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, (float)x2, (float)y1, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, (float)x2, (float)y2, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, (float)x1, (float)y2, 0.0f).method_1344();
        tessellator.method_1350();
    }

    protected final void drawBoxShadow(class_4587 matrixStack, int x1, int y1, int x2, int y2) {
        float[] acColor = WurstClient.INSTANCE.getGui().getAcColor();
        float xi1 = (float)x1 - 0.1f;
        float xi2 = (float)x2 + 0.1f;
        float yi1 = (float)y1 - 0.1f;
        float yi2 = (float)y2 + 0.1f;
        Matrix4f matrix = matrixStack.method_23760().method_23761();
        class_289 tessellator = RenderSystem.renderThreadTesselator();
        class_287 bufferBuilder = tessellator.method_1349();
        RenderSystem.setShader(class_757::method_34539);
        RenderSystem.setShaderColor((float)acColor[0], (float)acColor[1], (float)acColor[2], (float)0.5f);
        bufferBuilder.method_1328(class_293.class_5596.field_29345, class_290.field_1592);
        bufferBuilder.method_22918(matrix, xi1, yi1, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, xi2, yi1, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, xi2, yi2, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, xi1, yi2, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, xi1, yi1, 0.0f).method_1344();
        tessellator.method_1350();
        xi1 = (float)((double)xi1 - 0.9);
        xi2 = (float)((double)xi2 + 0.9);
        yi1 = (float)((double)yi1 - 0.9);
        yi2 = (float)((double)yi2 + 0.9);
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        bufferBuilder.method_22918(matrix, (float)x1, (float)y1, 0.0f).method_22915(acColor[0], acColor[1], acColor[2], 0.75f).method_1344();
        bufferBuilder.method_22918(matrix, (float)x2, (float)y1, 0.0f).method_22915(acColor[0], acColor[1], acColor[2], 0.75f).method_1344();
        bufferBuilder.method_22918(matrix, xi2, yi1, 0.0f).method_1336(0, 0, 0, 0).method_1344();
        bufferBuilder.method_22918(matrix, xi1, yi1, 0.0f).method_1336(0, 0, 0, 0).method_1344();
        bufferBuilder.method_22918(matrix, xi1, yi1, 0.0f).method_1336(0, 0, 0, 0).method_1344();
        bufferBuilder.method_22918(matrix, xi1, yi2, 0.0f).method_1336(0, 0, 0, 0).method_1344();
        bufferBuilder.method_22918(matrix, (float)x1, (float)y2, 0.0f).method_22915(acColor[0], acColor[1], acColor[2], 0.75f).method_1344();
        bufferBuilder.method_22918(matrix, (float)x1, (float)y1, 0.0f).method_22915(acColor[0], acColor[1], acColor[2], 0.75f).method_1344();
        bufferBuilder.method_22918(matrix, (float)x2, (float)y2, 0.0f).method_22915(acColor[0], acColor[1], acColor[2], 0.75f).method_1344();
        bufferBuilder.method_22918(matrix, (float)x2, (float)y1, 0.0f).method_22915(acColor[0], acColor[1], acColor[2], 0.75f).method_1344();
        bufferBuilder.method_22918(matrix, xi2, yi1, 0.0f).method_1336(0, 0, 0, 0).method_1344();
        bufferBuilder.method_22918(matrix, xi2, yi2, 0.0f).method_1336(0, 0, 0, 0).method_1344();
        bufferBuilder.method_22918(matrix, xi2, yi2, 0.0f).method_1336(0, 0, 0, 0).method_1344();
        bufferBuilder.method_22918(matrix, xi1, yi2, 0.0f).method_1336(0, 0, 0, 0).method_1344();
        bufferBuilder.method_22918(matrix, (float)x1, (float)y2, 0.0f).method_22915(acColor[0], acColor[1], acColor[2], 0.75f).method_1344();
        bufferBuilder.method_22918(matrix, (float)x2, (float)y2, 0.0f).method_22915(acColor[0], acColor[1], acColor[2], 0.75f).method_1344();
        tessellator.method_1350();
    }

    protected final void drawDownShadow(class_4587 matrixStack, int x1, int y1, int x2, int y2) {
        float[] acColor = WurstClient.INSTANCE.getGui().getAcColor();
        Matrix4f matrix = matrixStack.method_23760().method_23761();
        class_289 tessellator = RenderSystem.renderThreadTesselator();
        class_287 bufferBuilder = tessellator.method_1349();
        RenderSystem.setShader(class_757::method_34539);
        float yi1 = (float)y1 + 0.1f;
        RenderSystem.setShaderColor((float)acColor[0], (float)acColor[1], (float)acColor[2], (float)0.5f);
        bufferBuilder.method_1328(class_293.class_5596.field_29344, class_290.field_1592);
        bufferBuilder.method_22918(matrix, (float)x1, yi1, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, (float)x2, yi1, 0.0f).method_1344();
        tessellator.method_1350();
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        bufferBuilder.method_22918(matrix, (float)x1, (float)y1, 0.0f).method_22915(acColor[0], acColor[1], acColor[2], 0.75f).method_1344();
        bufferBuilder.method_22918(matrix, (float)x2, (float)y1, 0.0f).method_22915(acColor[0], acColor[1], acColor[2], 0.75f).method_1344();
        bufferBuilder.method_22918(matrix, (float)x2, (float)y2, 0.0f).method_1336(0, 0, 0, 0).method_1344();
        bufferBuilder.method_22918(matrix, (float)x1, (float)y2, 0.0f).method_1336(0, 0, 0, 0).method_1344();
        tessellator.method_1350();
    }

    protected final void drawBox(class_4587 matrixStack, int x1, int y1, int x2, int y2) {
        this.drawQuads(matrixStack, x1, y1, x2, y2);
        this.drawBoxShadow(matrixStack, x1, y1, x2, y2);
    }

    protected final void setColorToBackground() {
        WurstClient.INSTANCE.getGui().updateColors();
        float[] bgColor = WurstClient.INSTANCE.getGui().getBgColor();
        float opacity = WurstClient.INSTANCE.getGui().getOpacity();
        RenderSystem.setShaderColor((float)bgColor[0], (float)bgColor[1], (float)bgColor[2], (float)opacity);
    }

    protected final void setColorToForeground() {
        WurstClient.INSTANCE.getGui().updateColors();
        float[] bgColor = WurstClient.INSTANCE.getGui().getBgColor();
        float opacity = WurstClient.INSTANCE.getGui().getOpacity();
        RenderSystem.setShaderColor((float)bgColor[0], (float)bgColor[1], (float)bgColor[2], (float)opacity);
    }

    protected final void drawBackgroundBox(class_4587 matrixStack, int x1, int y1, int x2, int y2) {
        this.setColorToBackground();
        this.drawBox(matrixStack, x1, y1, x2, y2);
    }

    protected final void drawForegroundBox(class_4587 matrixStack, int x1, int y1, int x2, int y2) {
        this.setColorToForeground();
        this.drawBox(matrixStack, x1, y1, x2, y2);
    }
}

