/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.serverfinder;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_500;
import net.minecraft.class_642;
import net.wurstclient.mixinterface.IMultiplayerScreen;
import net.wurstclient.serverfinder.WurstServerPinger;
import net.wurstclient.util.MathUtils;

public class ServerFinderScreen
extends class_437 {
    private class_500 prevScreen;
    private class_342 ipBox;
    private class_342 maxThreadsBox;
    private class_4185 searchButton;
    private ServerFinderState state;
    private int maxThreads;
    private int checked;
    private int working;

    public ServerFinderScreen(class_500 prevMultiplayerMenu) {
        super((class_2561)class_2561.method_43470((String)""));
        this.prevScreen = prevMultiplayerMenu;
    }

    public void method_25426() {
        this.searchButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Search"), b -> this.searchOrCancel()).method_46434(this.field_22789 / 2 - 100, this.field_22790 / 4 + 96 + 12, 200, 20).method_46431();
        this.method_37063((class_364)this.searchButton);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Tutorial"), b -> class_156.method_668().method_670("https://www.wurstclient.net/serverfinder-tutorial/")).method_46434(this.field_22789 / 2 - 100, this.field_22790 / 4 + 120 + 12, 200, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Back"), b -> this.field_22787.method_1507((class_437)this.prevScreen)).method_46434(this.field_22789 / 2 - 100, this.field_22790 / 4 + 144 + 12, 200, 20).method_46431());
        this.ipBox = new class_342(this.field_22793, this.field_22789 / 2 - 100, this.field_22790 / 4 + 34, 200, 20, (class_2561)class_2561.method_43470((String)""));
        this.ipBox.method_1880(200);
        this.ipBox.method_25365(true);
        this.method_25429((class_364)this.ipBox);
        this.maxThreadsBox = new class_342(this.field_22793, this.field_22789 / 2 - 32, this.field_22790 / 4 + 58, 26, 12, (class_2561)class_2561.method_43470((String)""));
        this.maxThreadsBox.method_1880(3);
        this.maxThreadsBox.method_1852("128");
        this.method_25429((class_364)this.maxThreadsBox);
        this.method_25395((class_364)this.ipBox);
        this.state = ServerFinderState.NOT_RUNNING;
    }

    private void searchOrCancel() {
        if (this.state.isRunning()) {
            this.state = ServerFinderState.CANCELLED;
            return;
        }
        this.state = ServerFinderState.RESOLVING;
        this.maxThreads = Integer.parseInt(this.maxThreadsBox.method_1882());
        this.checked = 0;
        this.working = 0;
        new Thread(this::findServers, "Server Finder").start();
    }

    private void findServers() {
        try {
            int[] changes;
            InetAddress addr = InetAddress.getByName(this.ipBox.method_1882().split(":")[0].trim());
            int[] ipParts = new int[4];
            for (int i = 0; i < 4; ++i) {
                ipParts[i] = addr.getAddress()[i] & 0xFF;
            }
            this.state = ServerFinderState.SEARCHING;
            ArrayList<WurstServerPinger> pingers = new ArrayList<WurstServerPinger>();
            for (int change : changes = new int[]{0, 1, -1, 2, -2, 3, -3}) {
                for (int i2 = 0; i2 <= 255; ++i2) {
                    if (this.state == ServerFinderState.CANCELLED) {
                        return;
                    }
                    int[] ipParts2 = (int[])ipParts.clone();
                    ipParts2[2] = ipParts[2] + change & 0xFF;
                    ipParts2[3] = i2;
                    String ip = ipParts2[0] + "." + ipParts2[1] + "." + ipParts2[2] + "." + ipParts2[3];
                    WurstServerPinger pinger = new WurstServerPinger();
                    pinger.ping(ip);
                    pingers.add(pinger);
                    while (pingers.size() >= this.maxThreads) {
                        if (this.state == ServerFinderState.CANCELLED) {
                            return;
                        }
                        this.updatePingers(pingers);
                    }
                }
            }
            while (pingers.size() > 0) {
                if (this.state == ServerFinderState.CANCELLED) {
                    return;
                }
                this.updatePingers(pingers);
            }
            this.state = ServerFinderState.DONE;
        }
        catch (UnknownHostException e) {
            this.state = ServerFinderState.UNKNOWN_HOST;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.state = ServerFinderState.ERROR;
        }
    }

    public void method_25393() {
        this.ipBox.method_1865();
        this.searchButton.method_25355((class_2561)class_2561.method_43470((String)(this.state.isRunning() ? "Cancel" : "Search")));
        this.ipBox.field_22763 = !this.state.isRunning();
        this.maxThreadsBox.field_22763 = !this.state.isRunning();
        this.searchButton.field_22763 = MathUtils.isInteger(this.maxThreadsBox.method_1882()) && !this.ipBox.method_1882().isEmpty();
    }

    private boolean isServerInList(String ip) {
        for (int i = 0; i < this.prevScreen.method_2529().method_2984(); ++i) {
            if (!this.prevScreen.method_2529().method_2982((int)i).field_3761.equals(ip)) continue;
            return true;
        }
        return false;
    }

    private void updatePingers(ArrayList<WurstServerPinger> pingers) {
        for (int i = 0; i < pingers.size(); ++i) {
            if (pingers.get(i).isStillPinging()) continue;
            ++this.checked;
            if (pingers.get(i).isWorking()) {
                ++this.working;
                if (!this.isServerInList(pingers.get(i).getServerIP())) {
                    this.prevScreen.method_2529().method_2988(new class_642("Grief me #" + this.working, pingers.get(i).getServerIP(), false), false);
                    this.prevScreen.method_2529().method_2987();
                    ((IMultiplayerScreen)this.prevScreen).getServerListSelector().method_20122(null);
                    ((IMultiplayerScreen)this.prevScreen).getServerListSelector().method_20125(this.prevScreen.method_2529());
                }
            }
            pingers.remove(i);
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int int_3) {
        if (keyCode == 257) {
            this.searchButton.method_25306();
        }
        return super.method_25404(keyCode, scanCode, int_3);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(context);
        context.method_25300(this.field_22793, "Server Finder", this.field_22789 / 2, 20, 0xFFFFFF);
        context.method_25300(this.field_22793, "This will search for servers with similar IPs", this.field_22789 / 2, 40, 0xA0A0A0);
        context.method_25300(this.field_22793, "to the IP you type into the field below.", this.field_22789 / 2, 50, 0xA0A0A0);
        context.method_25300(this.field_22793, "The servers it finds will be added to your server list.", this.field_22789 / 2, 60, 0xA0A0A0);
        context.method_25303(this.field_22793, "Server address:", this.field_22789 / 2 - 100, this.field_22790 / 4 + 24, 0xA0A0A0);
        this.ipBox.method_25394(context, mouseX, mouseY, partialTicks);
        context.method_25303(this.field_22793, "Max. threads:", this.field_22789 / 2 - 100, this.field_22790 / 4 + 60, 0xA0A0A0);
        this.maxThreadsBox.method_25394(context, mouseX, mouseY, partialTicks);
        context.method_25300(this.field_22793, this.state.toString(), this.field_22789 / 2, this.field_22790 / 4 + 73, 0xA0A0A0);
        context.method_25303(this.field_22793, "Checked: " + this.checked + " / 1792", this.field_22789 / 2 - 100, this.field_22790 / 4 + 84, 0xA0A0A0);
        context.method_25303(this.field_22793, "Working: " + this.working, this.field_22789 / 2 - 100, this.field_22790 / 4 + 94, 0xA0A0A0);
        super.method_25394(context, mouseX, mouseY, partialTicks);
    }

    public void method_25419() {
        this.state = ServerFinderState.CANCELLED;
        super.method_25419();
    }

    static enum ServerFinderState {
        NOT_RUNNING(""),
        SEARCHING("\u00a72Searching..."),
        RESOLVING("\u00a72Resolving..."),
        UNKNOWN_HOST("\u00a74Unknown Host!"),
        CANCELLED("\u00a74Cancelled!"),
        DONE("\u00a72Done!"),
        ERROR("\u00a74An error occurred!");

        private final String name;

        private ServerFinderState(String name) {
            this.name = name;
        }

        public boolean isRunning() {
            return this == SEARCHING || this == RESOLVING;
        }

        public String toString() {
            return this.name;
        }
    }
}

