/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.settings;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_1887;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.wurstclient.WurstClient;
import net.wurstclient.clickgui.Component;
import net.wurstclient.clickgui.components.BookOffersEditButton;
import net.wurstclient.hacks.autolibrarian.BookOffer;
import net.wurstclient.keybinds.PossibleKeybind;
import net.wurstclient.settings.Setting;
import net.wurstclient.util.json.JsonException;
import net.wurstclient.util.json.JsonUtils;
import net.wurstclient.util.json.WsonArray;
import net.wurstclient.util.json.WsonObject;

public final class BookOffersSetting
extends Setting {
    private final ArrayList<BookOffer> offers = new ArrayList();
    private final BookOffer[] defaultOffers;

    public BookOffersSetting(String name, String description, String ... enchantments) {
        super(name, description);
        Arrays.stream(enchantments).map(s -> (class_1887)class_7923.field_41176.method_10223(new class_2960(s))).filter(Objects::nonNull).map(BookOffer::create).filter(BookOffer::isValid).distinct().sorted().forEach(this.offers::add);
        this.defaultOffers = this.offers.toArray(new BookOffer[0]);
    }

    public List<BookOffer> getOffers() {
        return Collections.unmodifiableList(this.offers);
    }

    public int indexOf(BookOffer offer) {
        return Collections.binarySearch(this.offers, offer);
    }

    public boolean contains(BookOffer offer) {
        return this.indexOf(offer) >= 0;
    }

    public boolean isWanted(BookOffer offer) {
        int index = this.indexOf(offer);
        if (index < 0) {
            return false;
        }
        int maxPrice = this.offers.get(index).price();
        return offer.price() <= maxPrice;
    }

    public void add(BookOffer offer) {
        if (offer == null || !offer.isValid()) {
            return;
        }
        if (this.contains(offer)) {
            return;
        }
        this.offers.add(offer);
        Collections.sort(this.offers);
        WurstClient.INSTANCE.saveSettings();
    }

    public void remove(int index) {
        if (index < 0 || index >= this.offers.size()) {
            return;
        }
        this.offers.remove(index);
        WurstClient.INSTANCE.saveSettings();
    }

    public void replace(int index, BookOffer offer) {
        if (index < 0 || index >= this.offers.size()) {
            return;
        }
        if (offer == null || !offer.isValid()) {
            return;
        }
        if (!offer.equals(this.offers.get(index)) && this.contains(offer)) {
            return;
        }
        this.offers.remove(index);
        this.offers.add(offer);
        Collections.sort(this.offers);
        WurstClient.INSTANCE.saveSettings();
    }

    public void resetToDefaults() {
        this.offers.clear();
        this.offers.addAll(Arrays.asList(this.defaultOffers));
        WurstClient.INSTANCE.saveSettings();
    }

    @Override
    public Component getComponent() {
        return new BookOffersEditButton(this);
    }

    @Override
    public void fromJson(JsonElement json) {
        try {
            WsonArray wson = JsonUtils.getAsArray(json);
            this.offers.clear();
            wson.getAllObjects().parallelStream().map(this::loadOffer).filter(Objects::nonNull).filter(BookOffer::isValid).distinct().sorted().forEachOrdered(this.offers::add);
        }
        catch (JsonException e) {
            System.out.println("Invalid book offer list: " + json);
            e.printStackTrace();
            this.resetToDefaults();
        }
    }

    private BookOffer loadOffer(WsonObject wson) {
        try {
            String id = wson.getString("id");
            int level = wson.getInt("level");
            int price = wson.getInt("max_price", 64);
            return new BookOffer(id, level, price);
        }
        catch (JsonException e) {
            System.out.println("Invalid book offer: " + wson);
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public JsonElement toJson() {
        JsonArray json = new JsonArray();
        this.offers.forEach(offer -> {
            JsonObject jsonOffer = new JsonObject();
            jsonOffer.addProperty("id", offer.id());
            jsonOffer.addProperty("level", (Number)offer.level());
            if (offer.price() < 64) {
                jsonOffer.addProperty("max_price", (Number)offer.price());
            }
            json.add((JsonElement)jsonOffer);
        });
        return json;
    }

    @Override
    public JsonObject exportWikiData() {
        JsonObject json = new JsonObject();
        json.addProperty("name", this.getName());
        json.addProperty("descriptionKey", this.getDescriptionKey());
        json.addProperty("type", "BookOffers");
        JsonArray jsonDefaultOffers = new JsonArray();
        for (BookOffer offer : this.defaultOffers) {
            JsonObject jsonOffer = new JsonObject();
            jsonOffer.addProperty("id", offer.id());
            jsonOffer.addProperty("level", (Number)offer.level());
            if (offer.price() < 64) {
                jsonOffer.addProperty("max_price", (Number)offer.price());
            }
            jsonDefaultOffers.add((JsonElement)jsonOffer);
        }
        json.add("defaultOffers", (JsonElement)jsonDefaultOffers);
        return json;
    }

    @Override
    public Set<PossibleKeybind> getPossibleKeybinds(String featureName) {
        return new LinkedHashSet<PossibleKeybind>();
    }
}

