/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.update;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.wurstclient.WurstClient;
import net.wurstclient.events.UpdateListener;
import net.wurstclient.update.Version;
import net.wurstclient.util.ChatUtils;
import net.wurstclient.util.json.JsonException;
import net.wurstclient.util.json.JsonUtils;
import net.wurstclient.util.json.WsonArray;
import net.wurstclient.util.json.WsonObject;

public final class WurstUpdater
implements UpdateListener {
    private Thread thread;
    private boolean outdated;
    private class_2561 component;

    @Override
    public void onUpdate() {
        if (this.thread == null) {
            this.thread = new Thread(this::checkForUpdates, "WurstUpdater");
            this.thread.start();
            return;
        }
        if (this.thread.isAlive()) {
            return;
        }
        if (this.component != null) {
            ChatUtils.component(this.component);
        }
        WurstClient.INSTANCE.getEventManager().remove(UpdateListener.class, this);
    }

    public void checkForUpdates() {
        Version currentVersion = new Version("7.37");
        Version latestVersion = null;
        try {
            WsonArray wson = JsonUtils.parseURLToArray("https://api.github.com/repos/Wurst-Imperium/Wurst-MCX2/releases");
            for (WsonObject release : wson.getAllObjects()) {
                if (!currentVersion.isPreRelease() && release.getBoolean("prerelease") || !this.containsCompatibleAsset(release.getArray("assets"))) continue;
                String tagName = release.getString("tag_name");
                latestVersion = new Version(tagName.substring(1));
                break;
            }
            if (latestVersion == null) {
                throw new NullPointerException("Latest version is missing!");
            }
            System.out.println("[Updater] Current version: " + currentVersion);
            System.out.println("[Updater] Latest version: " + latestVersion);
            this.outdated = currentVersion.shouldUpdateTo(latestVersion);
        }
        catch (Exception e) {
            System.err.println("[Updater] An error occurred!");
            e.printStackTrace();
        }
        if (latestVersion == null || latestVersion.isInvalid()) {
            String text = "An error occurred while checking for updates. Click \u00a7nhere\u00a7r to check manually.";
            String url = "https://www.wurstclient.net/download/?utm_source=Wurst+Client&utm_medium=WurstUpdater+chat+message&utm_content=An+error+occurred+while+checking+for+updates.";
            this.showLink(text, url);
            return;
        }
        if (!this.outdated) {
            return;
        }
        String textPart1 = "Wurst " + latestVersion + " MC1.20.1 is now available.";
        String text = textPart1 + " Click \u00a7nhere\u00a7r to download the update.";
        String url = "https://www.wurstclient.net/download/?utm_source=Wurst+Client&utm_medium=WurstUpdater+chat+message&utm_content=" + URLEncoder.encode(textPart1, StandardCharsets.UTF_8);
        this.showLink(text, url);
    }

    private void showLink(String text, String url) {
        class_2558 event = new class_2558(class_2558.class_2559.field_11749, url);
        this.component = class_2561.method_43470((String)text).method_27694(s -> s.method_10958(event));
    }

    private boolean containsCompatibleAsset(WsonArray wsonArray) throws JsonException {
        String compatibleSuffix = "MC1.20.1.jar";
        for (WsonObject asset : wsonArray.getAllObjects()) {
            String assetName = asset.getString("name");
            if (!assetName.endsWith(compatibleSuffix)) continue;
            return true;
        }
        return false;
    }

    public boolean isOutdated() {
        return this.outdated;
    }
}

