/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;

public class GoogleTranslate {
    public String translate(String text, String langFrom, String langTo) {
        String html = this.getHTML(text, langFrom, langTo);
        String translated = this.parseHTML(html);
        if (text.equalsIgnoreCase(translated)) {
            return null;
        }
        return translated;
    }

    private String getHTML(String text, String langFrom, String langTo) {
        String string;
        URL url = this.createURL(text, langFrom, langTo);
        URLConnection connection = this.setupConnection(url);
        BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream(), "UTF-8"));
        try {
            String line;
            StringBuilder html = new StringBuilder();
            while ((line = br.readLine()) != null) {
                html.append(line + "\n");
            }
            string = html.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    br.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return null;
            }
        }
        br.close();
        return string;
    }

    private URL createURL(String text, String langFrom, String langTo) {
        try {
            String encodedText = URLEncoder.encode(text.trim(), "UTF-8");
            String urlString = String.format("https://translate.google.com/m?hl=en&sl=%s&tl=%s&ie=UTF-8&prev=_m&q=%s", langFrom, langTo, encodedText);
            return new URL(urlString);
        }
        catch (UnsupportedEncodingException | MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private URLConnection setupConnection(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        connection.setConnectTimeout(5000);
        connection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11");
        return connection;
    }

    private String parseHTML(String html) {
        String regex = "class=\"result-container\">([^<]*)<\\/div>";
        Pattern pattern = Pattern.compile(regex, 8);
        Matcher matcher = pattern.matcher(html);
        matcher.find();
        String match = matcher.group(1);
        if (match == null || match.isEmpty()) {
            return null;
        }
        return StringEscapeUtils.unescapeHtml4((String)match);
    }
}

