/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.util;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_362;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

public abstract class ListWidget
extends class_362
implements class_4068 {
    protected final class_310 client;
    protected int width;
    protected int height;
    protected int top;
    protected int bottom;
    protected int right;
    protected int left;
    protected final int itemHeight;
    protected boolean centerListVertically = true;
    protected int yDrag = -2;
    protected double scrollAmount;
    protected boolean visible = true;
    protected boolean renderSelection = true;
    protected boolean renderHeader;
    protected int headerHeight;
    private boolean scrolling;

    public ListWidget(class_310 client, int width, int height, int top, int bottom, int itemHeight) {
        this.client = client;
        this.width = width;
        this.height = height;
        this.top = top;
        this.bottom = bottom;
        this.itemHeight = itemHeight;
        this.left = 0;
        this.right = width;
    }

    public boolean isVisible() {
        return this.visible;
    }

    protected abstract int getItemCount();

    public List<? extends class_364> method_25396() {
        return Collections.emptyList();
    }

    protected boolean selectItem(int index, int button, double mouseX, double mouseY) {
        return true;
    }

    protected abstract boolean isSelectedItem(int var1);

    protected int getMaxPosition() {
        return this.getItemCount() * this.itemHeight + this.headerHeight;
    }

    protected abstract void renderBackground();

    protected void updateItemPosition(int index, int x, int y, float delta) {
    }

    protected abstract void renderItem(class_332 var1, int var2, int var3, int var4, int var5, int var6, int var7, float var8);

    protected void renderHeader(int x, int y, class_289 tessellator) {
    }

    protected void clickedHeader(int i, int j) {
    }

    protected void renderDecorations(int mouseX, int mouseY) {
    }

    public int getItemAtPosition(double mouseX, double mouseY) {
        int i = this.left + this.width / 2 - this.getRowWidth() / 2;
        int j = this.left + this.width / 2 + this.getRowWidth() / 2;
        int k = class_3532.method_15357((double)(mouseY - (double)this.top)) - this.headerHeight + (int)this.scrollAmount - 4;
        int l = k / this.itemHeight;
        return mouseX < (double)this.getScrollbarPosition() && mouseX >= (double)i && mouseX <= (double)j && l >= 0 && k >= 0 && l < this.getItemCount() ? l : -1;
    }

    protected void capYPosition() {
        this.scrollAmount = class_3532.method_15350((double)this.scrollAmount, (double)0.0, (double)this.getMaxScroll());
    }

    public int getMaxScroll() {
        return Math.max(0, this.getMaxPosition() - (this.bottom - this.top - 4));
    }

    public boolean isMouseInList(double mouseX, double mouseY) {
        return mouseY >= (double)this.top && mouseY <= (double)this.bottom && mouseX >= (double)this.left && mouseX <= (double)this.right;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        if (this.visible) {
            this.renderBackground();
            int i = this.getScrollbarPosition();
            int j = i + 6;
            this.capYPosition();
            class_289 tessellator = class_289.method_1348();
            class_287 bufferBuilder = tessellator.method_1349();
            RenderSystem.setShaderTexture((int)0, (class_2960)class_437.field_44669);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShader(class_757::method_34543);
            bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
            bufferBuilder.method_22912((double)this.left, (double)this.bottom, 0.0).method_22913((float)this.left / 32.0f, (float)(this.bottom + (int)this.scrollAmount) / 32.0f).method_1336(32, 32, 32, 255).method_1344();
            bufferBuilder.method_22912((double)this.right, (double)this.bottom, 0.0).method_22913((float)this.right / 32.0f, (float)(this.bottom + (int)this.scrollAmount) / 32.0f).method_1336(32, 32, 32, 255).method_1344();
            bufferBuilder.method_22912((double)this.right, (double)this.top, 0.0).method_22913((float)this.right / 32.0f, (float)(this.top + (int)this.scrollAmount) / 32.0f).method_1336(32, 32, 32, 255).method_1344();
            bufferBuilder.method_22912((double)this.left, (double)this.top, 0.0).method_22913((float)this.left / 32.0f, (float)(this.top + (int)this.scrollAmount) / 32.0f).method_1336(32, 32, 32, 255).method_1344();
            tessellator.method_1350();
            int k = this.left + this.width / 2 - this.getRowWidth() / 2 + 2;
            int l = this.top + 4 - (int)this.scrollAmount;
            if (this.renderHeader) {
                this.renderHeader(k, l, tessellator);
            }
            this.renderList(context, k, l, mouseX, mouseY, delta);
            RenderSystem.disableDepthTest();
            this.renderHoleBackground(0, this.top, 255, 255);
            this.renderHoleBackground(this.bottom, this.height, 255, 255);
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ZERO, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
            bufferBuilder.method_22912((double)this.left, (double)(this.top + 4), 0.0).method_22913(0.0f, 1.0f).method_1336(0, 0, 0, 0).method_1344();
            bufferBuilder.method_22912((double)this.right, (double)(this.top + 4), 0.0).method_22913(1.0f, 1.0f).method_1336(0, 0, 0, 0).method_1344();
            bufferBuilder.method_22912((double)this.right, (double)this.top, 0.0).method_22913(1.0f, 0.0f).method_1336(0, 0, 0, 255).method_1344();
            bufferBuilder.method_22912((double)this.left, (double)this.top, 0.0).method_22913(0.0f, 0.0f).method_1336(0, 0, 0, 255).method_1344();
            tessellator.method_1350();
            bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
            bufferBuilder.method_22912((double)this.left, (double)this.bottom, 0.0).method_22913(0.0f, 1.0f).method_1336(0, 0, 0, 255).method_1344();
            bufferBuilder.method_22912((double)this.right, (double)this.bottom, 0.0).method_22913(1.0f, 1.0f).method_1336(0, 0, 0, 255).method_1344();
            bufferBuilder.method_22912((double)this.right, (double)(this.bottom - 4), 0.0).method_22913(1.0f, 0.0f).method_1336(0, 0, 0, 0).method_1344();
            bufferBuilder.method_22912((double)this.left, (double)(this.bottom - 4), 0.0).method_22913(0.0f, 0.0f).method_1336(0, 0, 0, 0).method_1344();
            tessellator.method_1350();
            int n = this.getMaxScroll();
            if (n > 0) {
                int o = (int)((float)((this.bottom - this.top) * (this.bottom - this.top)) / (float)this.getMaxPosition());
                int p = (int)this.scrollAmount * (this.bottom - this.top - (o = class_3532.method_15340((int)o, (int)32, (int)(this.bottom - this.top - 8)))) / n + this.top;
                if (p < this.top) {
                    p = this.top;
                }
                RenderSystem.setShader(class_757::method_34540);
                bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
                bufferBuilder.method_22912((double)i, (double)this.bottom, 0.0).method_1336(0, 0, 0, 255).method_1344();
                bufferBuilder.method_22912((double)j, (double)this.bottom, 0.0).method_1336(0, 0, 0, 255).method_1344();
                bufferBuilder.method_22912((double)j, (double)this.top, 0.0).method_1336(0, 0, 0, 255).method_1344();
                bufferBuilder.method_22912((double)i, (double)this.top, 0.0).method_1336(0, 0, 0, 255).method_1344();
                tessellator.method_1350();
                bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
                bufferBuilder.method_22912((double)i, (double)(p + o), 0.0).method_1336(128, 128, 128, 255).method_1344();
                bufferBuilder.method_22912((double)j, (double)(p + o), 0.0).method_1336(128, 128, 128, 255).method_1344();
                bufferBuilder.method_22912((double)j, (double)p, 0.0).method_1336(128, 128, 128, 255).method_1344();
                bufferBuilder.method_22912((double)i, (double)p, 0.0).method_1336(128, 128, 128, 255).method_1344();
                tessellator.method_1350();
                bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
                bufferBuilder.method_22912((double)i, (double)(p + o - 1), 0.0).method_1336(192, 192, 192, 255).method_1344();
                bufferBuilder.method_22912((double)(j - 1), (double)(p + o - 1), 0.0).method_1336(192, 192, 192, 255).method_1344();
                bufferBuilder.method_22912((double)(j - 1), (double)p, 0.0).method_1336(192, 192, 192, 255).method_1344();
                bufferBuilder.method_22912((double)i, (double)p, 0.0).method_1336(192, 192, 192, 255).method_1344();
                tessellator.method_1350();
            }
            this.renderDecorations(mouseX, mouseY);
            RenderSystem.disableBlend();
        }
    }

    protected void updateScrollingState(double mouseX, double mouseY, int button) {
        this.scrolling = button == 0 && mouseX >= (double)this.getScrollbarPosition() && mouseX < (double)(this.getScrollbarPosition() + 6);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.updateScrollingState(mouseX, mouseY, button);
        if (!this.isVisible() || !this.isMouseInList(mouseX, mouseY)) {
            return false;
        }
        int i = this.getItemAtPosition(mouseX, mouseY);
        if (i == -1 && button == 0) {
            this.clickedHeader((int)(mouseX - (double)(this.left + this.width / 2 - this.getRowWidth() / 2)), (int)(mouseY - (double)this.top) + (int)this.scrollAmount - 4);
            return true;
        }
        if (i == -1 || !this.selectItem(i, button, mouseX, mouseY)) {
            return this.scrolling;
        }
        if (this.method_25396().size() > i) {
            this.method_25395(this.method_25396().get(i));
        }
        this.method_25398(true);
        return true;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.method_25399() != null) {
            this.method_25399().method_25406(mouseX, mouseY, button);
        }
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (super.method_25403(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        if (!this.isVisible() || button != 0 || !this.scrolling) {
            return false;
        }
        if (mouseY < (double)this.top) {
            this.scrollAmount = 0.0;
        } else if (mouseY > (double)this.bottom) {
            this.scrollAmount = this.getMaxScroll();
        } else {
            double d = this.getMaxScroll();
            if (d < 1.0) {
                d = 1.0;
            }
            int i = (int)((float)((this.bottom - this.top) * (this.bottom - this.top)) / (float)this.getMaxPosition());
            double e = d / (double)(this.bottom - this.top - (i = class_3532.method_15340((int)i, (int)32, (int)(this.bottom - this.top - 8))));
            if (e < 1.0) {
                e = 1.0;
            }
            this.scrollAmount += deltaY * e;
            this.capYPosition();
        }
        return true;
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (!this.isVisible()) {
            return false;
        }
        this.scrollAmount -= amount * (double)this.itemHeight / 2.0;
        return true;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (!this.isVisible()) {
            return false;
        }
        if (super.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 264) {
            this.moveSelection(1);
            return true;
        }
        if (keyCode == 265) {
            this.moveSelection(-1);
            return true;
        }
        return false;
    }

    protected void moveSelection(int by) {
    }

    public boolean method_25400(char chr, int keyCode) {
        return !this.isVisible() ? false : super.method_25400(chr, keyCode);
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return this.isMouseInList(mouseX, mouseY);
    }

    public int getRowWidth() {
        return 220;
    }

    protected void renderList(class_332 context, int i, int j, int k, int l, float f) {
        int m = this.getItemCount();
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        for (int n = 0; n < m; ++n) {
            int o = j + n * this.itemHeight + this.headerHeight;
            int p = this.itemHeight - 4;
            if (o > this.bottom || o + p < this.top) {
                this.updateItemPosition(n, i, o, f);
            }
            if (this.renderSelection && this.isSelectedItem(n)) {
                int q = this.left + this.width / 2 - this.getRowWidth() / 2;
                int r = this.left + this.width / 2 + this.getRowWidth() / 2;
                float g = this.method_25370() ? 1.0f : 0.5f;
                RenderSystem.setShaderColor((float)g, (float)g, (float)g, (float)1.0f);
                bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1592);
                bufferBuilder.method_22912((double)q, (double)(o + p + 2), 0.0).method_1344();
                bufferBuilder.method_22912((double)r, (double)(o + p + 2), 0.0).method_1344();
                bufferBuilder.method_22912((double)r, (double)(o - 2), 0.0).method_1344();
                bufferBuilder.method_22912((double)q, (double)(o - 2), 0.0).method_1344();
                tessellator.method_1350();
                RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1592);
                bufferBuilder.method_22912((double)(q + 1), (double)(o + p + 1), 0.0).method_1344();
                bufferBuilder.method_22912((double)(r - 1), (double)(o + p + 1), 0.0).method_1344();
                bufferBuilder.method_22912((double)(r - 1), (double)(o - 1), 0.0).method_1344();
                bufferBuilder.method_22912((double)(q + 1), (double)(o - 1), 0.0).method_1344();
                tessellator.method_1350();
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.renderItem(context, n, i, o, p, k, l, f);
        }
    }

    public boolean method_25370() {
        return false;
    }

    protected int getScrollbarPosition() {
        return this.width / 2 + 124;
    }

    protected void renderHoleBackground(int top, int bottom, int topAlpha, int bottomAlpha) {
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        RenderSystem.setShaderTexture((int)0, (class_2960)class_437.field_44669);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(class_757::method_34543);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
        bufferBuilder.method_22912((double)this.left, (double)bottom, 0.0).method_22913(0.0f, (float)bottom / 32.0f).method_1336(64, 64, 64, bottomAlpha).method_1344();
        bufferBuilder.method_22912((double)(this.left + this.width), (double)bottom, 0.0).method_22913((float)this.width / 32.0f, (float)bottom / 32.0f).method_1336(64, 64, 64, bottomAlpha).method_1344();
        bufferBuilder.method_22912((double)(this.left + this.width), (double)top, 0.0).method_22913((float)this.width / 32.0f, (float)top / 32.0f).method_1336(64, 64, 64, topAlpha).method_1344();
        bufferBuilder.method_22912((double)this.left, (double)top, 0.0).method_22913(0.0f, (float)top / 32.0f).method_1336(64, 64, 64, topAlpha).method_1344();
        tessellator.method_1350();
    }

    public double getScrollAmount() {
        return this.scrollAmount;
    }

    protected void drawSelectionOutline(class_4587 matrixStack, int x, int y) {
        GL11.glDisable((int)2884);
        GL11.glEnable((int)3042);
        Matrix4f matrix = matrixStack.method_23760().method_23761();
        class_289 tessellator = RenderSystem.renderThreadTesselator();
        class_287 bufferBuilder = tessellator.method_1349();
        RenderSystem.setShader(class_757::method_34539);
        RenderSystem.setShaderColor((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1592);
        bufferBuilder.method_22918(matrix, (float)(x - 2), (float)(y - 2), 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, (float)(x + 218), (float)(y - 2), 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, (float)(x + 218), (float)(y + 28), 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, (float)(x - 2), (float)(y + 28), 0.0f).method_1344();
        tessellator.method_1350();
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1592);
        bufferBuilder.method_22918(matrix, (float)(x - 1), (float)(y - 1), 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, (float)(x + 217), (float)(y - 1), 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, (float)(x + 217), (float)(y + 27), 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, (float)(x - 1), (float)(y + 27), 0.0f).method_1344();
        tessellator.method_1350();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)2884);
        GL11.glDisable((int)3042);
    }
}

