"""
Prompt templates for LLM interactions
"""
from .paper_extraction import EXTRACT_PROMPTS
from .content_planning import (
    PAPER_SLIDES_PLANNING_PROMPT,
    PAPER_POSTER_PLANNING_PROMPT,
    PAPER_POSTER_DENSITY_GUIDELINES,
    GENERAL_SLIDES_PLANNING_PROMPT,
    GENERAL_POSTER_PLANNING_PROMPT,
    GENERAL_POSTER_DENSITY_GUIDELINES,
)
from .image_generation import (
    STYLE_PROCESS_PROMPT,
    FORMAT_POSTER,
    FORMAT_SLIDE,
    POSTER_STYLE_HINTS,
    SLIDE_STYLE_HINTS,
    SLIDE_LAYOUTS_ACADEMIC,
    SLIDE_LAYOUTS_DORAEMON,
    SLIDE_LAYOUTS_DEFAULT,
    SLIDE_COMMON_STYLE_RULES,
    POSTER_COMMON_STYLE_RULES,
    VISUALIZATION_HINTS,
    CONSISTENCY_HINT,
    SLIDE_FIGURE_HINT,
    POSTER_FIGURE_HINT,
)

__all__ = [
    # Paper extraction
    "EXTRACT_PROMPTS",
    # Content planning
    "PAPER_SLIDES_PLANNING_PROMPT",
    "PAPER_POSTER_PLANNING_PROMPT",
    "PAPER_POSTER_DENSITY_GUIDELINES",
    "GENERAL_SLIDES_PLANNING_PROMPT",
    "GENERAL_POSTER_PLANNING_PROMPT",
    "GENERAL_POSTER_DENSITY_GUIDELINES",
    # Image generation
    "STYLE_PROCESS_PROMPT",
    "FORMAT_POSTER",
    "FORMAT_SLIDE",
    "POSTER_STYLE_HINTS",
    "SLIDE_STYLE_HINTS",
    "SLIDE_LAYOUTS_ACADEMIC",
    "SLIDE_LAYOUTS_DORAEMON",
    "SLIDE_LAYOUTS_DEFAULT",
    "SLIDE_COMMON_STYLE_RULES",
    "POSTER_COMMON_STYLE_RULES",
    "VISUALIZATION_HINTS",
    "CONSISTENCY_HINT",
    "SLIDE_FIGURE_HINT",
    "POSTER_FIGURE_HINT",
]

