import { lib, game, ui, get, ai, _status } from "noname";

const translates = {
	ol_sb_chengyu: "OL谋程昱",
	ol_sb_chengyu_prefix: "OL谋",
	olsbliduan: "戾断",
	olsbliduan_info: "你使用【杀】后，令你使用的下一张锦囊牌可以多指定一个目标；你使用锦囊牌后，令你使用的下一张【杀】可以多指定一个目标。",
	olsbdanchi: "胆持",
	olsbdanchi_info: "你每回合首次因牌造成伤害或受到伤害后，你可令此牌目标角色同时猜测，伤害来源本回合使用的下一张牌为【杀】或锦囊牌。此回合结束时，若有角色猜对，你摸两张牌；若有角色猜错，你视为使用一张【杀】",
	ol_sb_dongzhao: "OL谋董昭",
	ol_sb_dongzhao_prefix: "OL谋",
	olsbshunji: "顺机",
	olsbshunji_info: "每轮每名角色限一次，当一名角色受到伤害后，你可摸一张牌，然后交给其一张牌。若你因此失去了一个牌名的所有牌（每个牌名限一次），你对其造成1点伤害。",
	olsbyishi: "移势",
	olsbyishi_info: "出牌阶段限一次，你可保留手牌中每个花色各一张牌并展示，将其余牌置入弃牌堆，然后移动场上的一张牌。若你未因此失去手牌，直到你的下个回合开始，你不因使用而失去与移动牌花色相同的牌后，摸一张牌",
	ol_sb_xizhicai: "OL谋戏志才",
	ol_sb_xizhicai_prefix: "OL谋",
	olsbxinchuan: "薪传",
	olsbxinchuan_info: "你使用的锦囊牌进入弃牌堆后，你可以令一名角色依次执行X次摸一张牌和X次弃置一张牌（X为本回合弃牌堆缺少的花色数），然后若其手牌数变为体力值，令其下家执行剩余流程。",
	olsbjinjin: "金烬",
	olsbjinjin_info: "你需要使用普通锦囊牌时，可以将本回合进入弃牌堆的任意张花色各不相同的牌移出游戏并失去〖金烬〗，视为使用之；然后你于下个受到过伤害的回合结束时令一名角色获得移出游戏的牌和〖金烬〗。",
	ol_jsrg_zhujun: "闪朱儁",
	ol_jsrg_zhujun_prefix: "闪",
	ol_fendi: "分敌",
	ol_fendi_info: "你使用【杀】指定唯一目标后，可以展示其至多X张手牌（X为你的体力上限）。若如此做，直到此【杀】结算结束，其只能使用或打出对应实体牌全为这些牌的牌，且此【杀】对其造成伤害后，你获得其手牌或弃牌堆中的这些牌。",
	ol_juxiang: "拒降",
	ol_juxiang_info: "每回合限一次，你于摸牌阶段获得牌后，可以弃置这些牌，令当前回合角色本回合出【杀】次数+X（X为你以此法弃置的牌数）。",
	ol_jsrg_sunjian: "闪孙坚",
	ol_jsrg_sunjian_prefix: "闪",
	ol_pingtao: "平讨",
	ol_pingtao_info: "出牌阶段限一次，你可令一名其他角色选择一项：1.交给你一张牌，你本回合使用的下一张【杀】可额外指定一个目标；2.你视为对其使用一张有次数限制的【杀】。",
	ol_juelie: "绝烈",
	ol_juelie_info: "你使用【杀】指定目标后，可以弃置至多X张牌（X为你的体力值），然后令其弃置等量的牌；然后若你的手牌数或体力值为全场最小，此【杀】基础伤害+1。你因此【杀】杀死一名角色后，将手牌摸至体力上限。",
	dm_sunquan: "魔孙权",
	dm_sunquan_prefix: "魔",
	olquanyu: "权御",
	olquanyu_info: `锁定技，每轮开始时，你令所有角色同时选择一项其本局未选择过的“${get.poptip({
		id: "quanyu_effect",
		name: "权御",
		type: "character",
		info: "<li>白虹：伤害+1<br><li>青冥：额外指定一个目标<br><li>辟邪：无视防具<br><li>紫电：不可响应<br><li>百里：额外结算一次<br><li>流星：无次数限制",
	})}”效果，然后你摸X张牌（X为与你选择效果相同的角色数）。你使用的指定唯一目标的【杀】附带你本轮所选的“权御”效果。`,
	oltianen: "天恩",
	oltianen_info: `锁定技，每回合各限一次，你使用牌指定唯一目标后：若本轮你与其选择的“权御”效果不同，你随机弃置其一张牌，对其发动一次${get.poptip("olquanyu")}；若与你相同，你从牌堆获得一张不计入手牌上限的【杀】。`,
	olqiangang: "乾纲",
	olqiangang_info: `出牌阶段，你可${get.poptip("rule_rumo")}，失去〖天恩〗，然后本局你使用指定唯一目标的【杀】均执行目标所选择过的所有“权御”效果。`,
	ol_sb_guojia: "OL谋郭嘉",
	ol_sb_guojia_prefix: "OL谋",
	olsbdinglun: "定论",
	olsbdinglun_info: `出牌阶段限一次，你可选择至多半数角色（向上取整），若这些角色的手牌数之和大于其他角色的手牌数之和，这些角色获得${get.poptip("olsbquxi")}至你下个准备阶段并摸一张牌。`,
	olsbquxi: "趋袭",
	olsbquxi_info: "出牌阶段各限一次，你的【闪】/【桃】可以当做【过河拆桥】/【顺手牵羊】使用。",
	olsbjieli: "解罹",
	olsbjieli_info: "每轮限一次，当你成为一张牌的唯一目标时，你可以选择一项：1.由你重新选择此牌的目标；2观看一名其他角色的所有手牌，获得其中与此牌花色相同的牌。",
	ol_re_yujin: "OL界于禁",
	ol_re_yujin_prefix: "OL|界",
	ol_zhenjun: "镇军",
	ol_zhenjun_info: "准备阶段，你可弃置一名角色X张牌（X为其手牌数减体力值且至少为1），然后你选择一项：1.你弃置与其中非装备牌数等量的牌：2.结束阶段，其摸与其中非装备牌数等量的牌。",
	ol_yizhong: "毅重",
	ol_yizhong_info: "锁定技，体力值大于你的角色对你使用的黑色【杀】无效，手牌数小于你的角色无法响应你使用的黑色【杀】。",
	ol_sb_xuyou: "OL谋许攸",
	ol_sb_xuyou_prefix: "OL谋",
	olsbqianfu: "迁附",
	olsbqianfu_info: "转换技，出牌阶段，阳：你可以将一张黑色牌当【过河拆桥】使用：阴：你可以将一张红色牌当【火攻】使用。结算后，你可将因此弃置的牌置于牌堆顶。",
	olsbyushi: "驭势",
	olsbyushi_info: `你造成或受到伤害后，你可令一名：有转换技的角色切换其一个转换技的状态：无转换技的角色获得出牌阶段各限一次的${get.poptip("olsbqianfu")}，直到其失去最后的手牌。每轮前X次，有转换技切换状态后，你摸一张牌（X为你的体力上限）。`,
	olsbfenchao: "焚巢",
	olsbfenchao_info: "限定技，结束阶段，你可以令一名角色获得弃牌堆中的伤害牌（不超过存活人数）且令这些牌造成伤害时改为火焰伤害。",
	ol_sb_lusu: "OL谋鲁肃",
	ol_sb_lusu_prefix: "OL谋",
	lusu_phaseZhunbei: "准备阶段",
	lusu_phaseZhunbei_info: "准备阶段",
	lusu_phaseJudge: "判定阶段",
	lusu_phaseJudge_info: "判定阶段",
	lusu_phaseDraw: "摸牌阶段",
	lusu_phaseDraw_info: "摸牌阶段",
	lusu_phaseUse: "出牌阶段",
	lusu_phaseUse_info: "出牌阶段",
	lusu_phaseDiscard: "弃牌阶段",
	lusu_phaseDiscard_info: "弃牌阶段",
	lusu_phaseJieshu: "结束阶段",
	lusu_phaseJieshu_info: "结束阶段",
	olsbduduan: "独断",
	olsbduduan_info: "回合开始时，你可以摸一张牌，跳过本回合判定、摸牌、出牌和弃牌阶段中的一个阶段（每阶段限一次），并交换其中另外两个阶段。",
	olsbyinglve: "英略",
	olsbyinglve_info: "出牌阶段各限一次，你可以令一名角色：1.失去1点体力，下个摸牌阶段摸牌数+2；2.摸两张牌，下个弃牌阶段手牌上限-2。",
	olsbmengshi: "盟势",
	olsbmengshi_info: "限定技，结束阶段，你可失去X点体力，然后交换两名其他角色的体力值（X为两者体力值的差）。每个回合结束时，你摸一张牌并回复1点体力，直到“盟势”一方死亡。",
	ol_sb_zhugeliang: "OL谋诸葛亮",
	ol_sb_zhugeliang_prefix: "OL谋",
	olsbzhitian: "知天",
	olsbzhitian_info: "出牌阶段，牌堆顶的七张牌对你可见。你的【火攻】结算中，你可观看并选择牌堆顶七张牌中的一张牌代替【火攻】弃牌。",
	olsbwujing: "武靖",
	olsbwujing_info: "锁定技，你的回合内，有牌不因使用而进入弃牌堆后，你使用的下一张牌无次数限制；每回合首次有不为手牌的牌进入弃牌堆后，你摸一张牌。",
	olsbzhijue: "智绝",
	olsbzhijue_info: "转换技，阳：出牌阶段，你可将牌堆顶的一张牌当【火攻】使用；阴：将一种颜色的手牌置入弃牌堆（每种颜色每回合限一次），然后可视为使用其中一张基本牌或普通锦囊牌。若你以此法未造成伤害，你令〖知天〗可见牌与观看牌数-1（至多减至1），然后你摸两张牌。",
	ol_madai: "OL界马岱",
	ol_madai_prefix: "OL界",
	olqianxi: "潜袭",
	olqianxi_info: "出牌阶段开始时，你可以展示一张牌，本回合距离为1的其他角色不能使用或打出与此牌颜色相同的手牌，且你本回合使用此牌造成的伤害+1。",
	ol_sb_yl_luzhi: "OL谋卢植",
	ol_sb_yl_luzhi_prefix: "OL谋",
	olsibing: "司兵",
	olsibing_info: "①每回合限一次，当你使用伤害牌指定唯一目标时，你可以弃置任意张红色牌令目标弃置等量红色手牌，否则不能响应该牌；②以你为目标的伤害牌结算完成后，若未对你造成伤害，你可以弃置一张黑色牌并视为使用一张【杀】。",
	olliance: "敛策",
	olliance_info: "每轮限一次，当你的手牌数变化后，若为全场最少，你可将手牌摸至体力上限，然后本回合下一次有角色造成伤害时，此伤害+1",
	ol_guanzhang: "OL界关兴张苞",
	ol_guanzhang_prefix: "OL界",
	olfuhun: "父魂",
	olfuhun_info: `你可将两张牌当【杀】使用或打出。你使用的转化【杀】目标角色只能使用颜色相同的手牌响应；你于出牌阶段使用【杀】造成伤害后，你本回合获得${get.poptip("new_rewusheng")}和${get.poptip("olpaoxiao")}。`,
	ol_sunxiu: "OL界孙休",
	ol_sunxiu_prefix: "OL界",
	ol_sb_zhangxiu: "OL谋张绣",
	ol_sb_zhangxiu_prefix: "OL谋",
	olsbchoulie: "仇猎",
	olsbchoulie_info: "限定技，回合开始时，你可选择一名其他角色。本回合你的每个阶段开始时，你可弃置一张牌视为对其使用一张【杀】。其可弃置一张基本牌或武器牌令此【杀】无效。",
	olsbzhuijiao: "追剿",
	olsbzhuijiao_info: "锁定技。你使用【杀】时，若你使用的上一张牌未造成伤害，则你摸一张牌并令此【杀】伤害+1。此【杀】结算后，若仍未造成伤害，你弃置一张牌。",
	ol_sb_zhaoyun: "OL谋赵云",
	ol_sb_zhaoyun_prefix: "OL谋",
	olsbnilan: "逆澜",
	olsbnilan_info: "当你不因此技能造成伤害后，你可以选择一项：1.弃置所有手牌，若其中有【杀】，你可对一名其他角色造成1点伤害；2.摸两张牌。若如此做，你下次受到伤害后可以执行另一项。",
	olsbjueya: "绝崖",
	olsbjueya_info: "当你需要使用一张你未以此法使用过的基本牌时，若你没有手牌，你可以视为使用之。",
	ol_sb_zhangfei: "OL谋张飞",
	ol_sb_zhangfei_prefix: "OL谋",
	olsbjingxian: "敬贤",
	olsbjingxian_info: "出牌阶段每名角色限一次，你可以交给其至多两张非基本牌，然后其选择等量项：1.其与你各摸一张牌；2.令你从牌堆中获得一张【杀】。",
	olsbxieyong: "狭勇",
	olsbxieyong_info: "出牌阶段限一次，你可以选择一名其他角色，直至其下个回合结束，你处于【酒】的状态。其于此期间使用一张牌后（目标不为其自己），你可以对其使用一张无视防具的【杀】。",
	ol_liaohua: "OL界廖化",
	ol_liaohua_prefix: "OL界",
	oldangxian: "当先",
	oldangxian_info: "回合开始时，你执行一个额外的出牌阶段。此阶段开始时，你可以从牌堆或弃牌堆获得一张无距离限制的【杀】，若如此做，此阶段结束时，若你未于此阶段造成过伤害，则你对自己造成1点伤害。",
	olfuli: "伏枥",
	olfuli_info: "限定技，当你处于濒死状态时，你可将体力回复至X点，将手牌摸至X张。若你本局游戏造成的伤害数小于X，则你将武将牌翻面（X为存活势力数）。",
	ol_sb_huangyueying: "OL谋黄月英",
	ol_sb_huangyueying_prefix: "OL谋",
	olsblixian: "理贤",
	olsblixian_info: "当你受到伤害后，你可将一张牌当【无中生有】使用。当你以此法使用过三种不同牌名的锦囊牌后，此技能于你的结束阶段也可发动。",
	olsbbingcai: "并才",
	olsbbingcai_info: "每回合第一张基本牌被使用时，你可重铸一张牌。若两张牌均为伤害类或非伤害类，则此牌额外结算一次。然后若重铸的牌为锦囊牌，你为〖理贤〗添加一个牌名：【顺手牵羊】；【过河拆桥】；【铁索连环】。以上牌名均添加后，〖理贤〗于你的准备阶段也可发动。",
	old_olsblixian: "理贤",
	old_olsblixian_info: "锁定技，每个结束阶段，你获得弃牌堆中所有本回合目标包含你的锦囊牌。你以此法获得的牌仅可当作【杀】或【闪】使用。",
	ol_sb_jushou: "OL谋沮授",
	ol_sb_jushou_prefix: "OL谋",
	olsbguliang: "固粮",
	olsbguliang_info: "每回合限一次，其他角色对你使用牌时，你可令此牌对你无效，若如此做，你无法响应其对你使用的牌直到回合结束。",
	olsbxutu: "徐图",
	olsbxutu_info: "锁定技，游戏开始时，你将牌堆顶三张牌置于你的武将牌上，称为“资”。每个结束阶段，你将本回合弃牌堆的一张牌与一张“资”交换，令一名角色获得三张花色或点数相同的“资”，然后将“资”补至三张。",
	ol_lingtong: "OL界凌统",
	ol_lingtong_prefix: "OL界",
	olxuanfeng: "旋风",
	olxuanfeng_info: "当你一次性失去至少两张牌后，或失去装备区的牌后，你可以依次弃置一至两名其他角色的共计两张牌。",
	ol_jianyong: "OL界简雍",
	ol_jianyong_prefix: "OL界",
	olqiaoshui: "巧说",
	olqiaoshui_info: "出牌阶段，你可与一名其他角色拼点。若你赢，你本回合使用下一张基本牌或普通锦囊牌时，可以为此牌增加或减少一个目标；若你没赢，此技能于本回合失效且本回合你不能使用锦囊牌。",
	ol_caozhang: "OL界曹彰",
	ol_caozhang_prefix: "OL界",
	oljiangchi: "将驰",
	oljiangchi_info: "摸牌阶段结束时，你可以选择一项：①摸一张牌，本回合使用【杀】的次数上限-1，且【杀】不计入手牌上限。②重铸一张牌，本回合使用【杀】无距离限制，且使用【杀】的次数上限+1。",
	ol_sb_jiangwei: "OL谋姜维",
	ol_sb_jiangwei_prefix: "OL谋",
	olsbzhuri: "逐日",
	olsbzhuri_info: "你的阶段结束时，若你本阶段失去过手牌或得到过牌，则你可以与一名角色拼点。若你赢，你可以使用其中一张拼点牌；若你没赢，你失去1点体力或令此技能于本回合无效。",
	olsbranji: "燃己",
	olsbranji_info: `限定技，结束阶段。若你本回合使用过牌的阶段数大于等于/小于等于体力值，你可以获得技能${get.poptip("kunfenx")}/${get.poptip("zhaxiang")}（同时满足则都获得，以此法获得的〖困奋〗直接修改为非锁定技）。若如此做，你将手牌数调整至手牌上限或将体力值回复至体力上限，然后你不能回复体力直到你杀死角色。`,
	kunfenx: "困奋",
	kunfenx_info: "结束阶段开始时，你可以失去1点体力，然后摸两张牌。",
	ol_sb_guanyu: "OL谋关羽",
	ol_sb_guanyu_prefix: "OL谋",
	olsbfumeng: "赴梦",
	olsbfumeng_info: "每轮开始时，你可以令任意张手牌的牌名视为【杀】。",
	olsbguidao: "归刀",
	olsbguidao_info: "出牌阶段，你可以重铸两张牌并视为使用一张【决斗】（重铸的【杀】数须比本回合上次发动〖归刀〗重铸的【杀】数多）。目标角色受到此牌伤害时，其须猜测你手牌中牌名为【杀】的牌数量多还是牌名不为【杀】的牌数多，若其猜错，则此【决斗】对其造成的伤害+1。",
	ol_sb_taishici: "OL谋太史慈",
	ol_sb_taishici_prefix: "OL谋",
	olsbdulie: "笃烈",
	olsbdulie_info: "每回合限一次，当你成为其他角色使用基本牌或普通锦囊牌的唯一目标时，你可以令此牌额外结算一次。若如此做，此牌结算完毕后，你摸X张牌（X为你的攻击范围且至多为5）。",
	olsbdouchan: "斗缠",
	olsbdouchan_info: "锁定技，准备阶段，你从牌堆中获得一张【决斗】，若牌堆没有【决斗】，则你的攻击范围和出牌阶段使用【杀】的次数上限+1（增加次数不超过本局游戏人数）。",
	olsbweilin: "威临",
	olsbweilin_info: "每回合限一次，你可以将一张牌当作任意【杀】或【酒】使用，且目标角色本回合与此牌颜色相同的手牌均视为【杀】。",
	olsbduoshou: "夺首",
	olsbduoshou_info: "锁定技。①你每回合使用的第一张红色牌无距离限制。②你每回合使用的第一张基本牌不计入使用次数。③你每回合第一次造成伤害后，你摸一张牌。",
	ol_gaoshun: "OL界高顺",
	ol_gaoshun_prefix: "OL界",
	olxianzhen: "陷阵",
	olxianzhen_info: "出牌阶段限一次，你可以与一名角色拼点。若你赢，本回合你无视该角色的防具且对其使用牌没有次数和距离限制，且当你使用【杀】或普通锦囊牌指定目标时，可以令该角色也成为此牌的目标；若你没赢，本回合你不能对其使用【杀】且你的【杀】不计入手牌上限。",
	ol_sb_yuanshao: "OL谋袁绍",
	ol_sb_yuanshao_prefix: "OL谋",
	olsbhetao: "合讨",
	olsbhetao_info: "其他角色使用牌指定第一个目标后，若此牌指定的目标数大于1，则你可以弃置一张与此牌颜色相同的牌并令此牌改为对其中一名目标角色结算两次。",
	olsbshenli: "神离",
	olsbshenli_info: "出牌阶段限一次，当你使用【杀】指定目标后，你可以令所有可成为此牌目标的其他角色均成为此牌目标，此牌结算完毕后，若你因此牌造成的伤害值X：大于你的手牌数，你摸X张牌（至多摸五张）；大于你的体力值，你再次对所有目标角色中可以成为此牌目标的角色使用此牌。",
	olsbyufeng: "玉锋",
	olsbyufeng_block: "思召剑",
	olsbyufeng_info: `游戏开始时，你将${get.poptip("sizhaojian")}置入装备区。`,
	sizhaojian: "思召剑",
	sizhaojian_info: "当你使用有点数的【杀】指定目标后，你令目标角色只能使用无点数或点数大于等于此【杀】的【闪】响应此牌。",
	sizhaojian_append: '<span class="text" style="font-family: yuanli">【思召剑】于闪闪节（3月2日-3月15日）外离开装备区后，销毁此牌</span>',
	sizhaojian_skill: "思召剑",
	sizhaojian_skill_info: "当你使用有点数的【杀】指定目标后，你令目标角色只能使用无点数或点数大于等于此【杀】的【闪】响应此牌。",
	olsbshishou: "士首",
	olsbshishou_info: `主公技，其他群势力角色失去装备区的牌后，若你的装备区中没有武器牌，其可将${get.poptip("sizhaojian")}置入你的装备区。`,
	ol_yufan: "OL界虞翻",
	ol_yufan_prefix: "OL界",
	olzongxuan: "纵玄",
	olzongxuan_info: "当你弃置而失去牌后，或你的上家每回合因弃置首次失去牌后，你可以将位于弃牌堆的这些牌中的任意牌以任意顺序置于牌堆顶。",
	olzhiyan: "直言",
	olzhiyan_info: "你或你的上家的结束阶段，你可以令一名角色正面朝上摸一张牌，然后若此牌：为装备牌，则其使用此牌并回复1点体力；不为装备牌且其体力值不等于你，则其失去1点体力。",
	ol_chengpu: "OL界程普",
	ol_chengpu_prefix: "OL界",
	dclihuo: "疠火",
	dclihuo_info: "①你使用的非火【杀】可以改为火【杀】，若如此做，此牌结算完毕后，若此牌造成过伤害，则你弃置一张牌或失去1点体力。②你使用火【杀】可以额外指定一个目标。",
	olchunlao: "醇醪",
	olchunlao_info: "①当你或你的上下家的【杀】因弃置进入弃牌堆后，你将位于弃牌堆的这些牌称为“醇”置于武将牌上（最多为9）。②一名角色处于濒死状态时，你可以将X张“醇”置入弃牌堆，然后令其视为使用一张【酒】（X为你本轮以此法使用【酒】的次数）。",
	ol_wangyi: "OL界王异",
	ol_wangyi_prefix: "OL界",
	olzhenlie: "贞烈",
	olzhenlie_info: `当你成为其他角色使用【杀】或普通锦囊牌的目标后，你可以失去1点体力并令此牌对你无效，然后你选择一项：①获得使用者的一张牌；②于本回合的结束阶段发动一次${get.poptip("olmiji")}。`,
	olzhenlie_effect: "秘计",
	olmiji: "秘计",
	olmiji_info: "结束阶段，若你已受伤，则你可以摸X张牌，然后你可以将至多X张牌任意分配给其他角色（X为你已损失的体力值）。",
	ol_sb_pangtong: "OL谋庞统",
	ol_sb_pangtong_prefix: "OL谋",
	olsbhongtu: "鸿图",
	olsbhongtu_info: `一名角色的阶段结束时，若你于此阶段得到过至少两张牌，你可以摸三张牌，展示三张手牌，令一名其他角色选择是否使用其中一张牌并令你随机弃置其中另一张牌。若使用牌的点数于三张牌中满足以下条件，其获得如下技能或效果直到其下一个回合的回合结束：唯一最大，其获得${get.poptip("nzry_feijun")}；不为最大且不为最小，其获得${get.poptip("qianxi")}；唯一最小，其手牌上限+2。若其未以此法使用牌，你对其与你各造成1点火焰伤害。`,
	olsbqiwu: "栖梧",
	olsbqiwu_info: "当你每回合首次受到伤害时，若伤害来源为你或在你的攻击范围内，你可以弃置一张红色牌，防止此伤害。",
	ol_fazheng: "OL界法正",
	ol_fazheng_prefix: "OL界",
	olxuanhuo: "眩惑",
	olxuanhuo_info: "摸牌阶段结束时，你可以交给一名其他角色两张牌，然后其选择一项：1.对你选择的另一名其他角色使用一张【杀】，2.令你观看并获得其两张牌。",
	olenyuan: "恩怨",
	olenyuan1: "恩怨",
	olenyuan2: "恩怨",
	olenyuan_info: "①当你一次性获得一名其他角色超过一张牌后，你可以令其摸一张牌。②当你受到1点伤害后，你可以令伤害来源选择一项：1.将一张红色手牌交给你；2.失去1点体力。",
	ol_caifuren: "OL界蔡夫人",
	ol_caifuren_prefix: "OL界",
	olqieting: "窃听",
	olqieting_info: "其他角色的回合结束后，若其本回合未对其他角色造成伤害/使用过牌，你可以选择一项/至多两项：1.将其装备区的一张牌置入你的装备区；2.摸一张牌。",
	ol_liru: "OL界李儒",
	ol_liru_prefix: "OL界",
	oljuece: "绝策",
	oljuece_info: "结束阶段，你可以对一名手牌数不大于你的其他角色造成1点伤害。",
	olmieji: "灭计",
	olmieji_info: "出牌阶段限一次，你可以将一张锦囊牌置于牌堆顶，然后令一名有手牌的其他角色弃置一张锦囊牌或依次弃置两张牌。",
	ol_liubiao: "OL界刘表",
	ol_liubiao_prefix: "OL界",
	olzishou: "自守",
	olzishou_info: "摸牌阶段，你可以多摸X张牌，你以此法摸牌的结束阶段，若你本回合使用过伤害牌，你弃置X张牌（X为全场势力数）。",
	olzongshi: "宗室",
	olzongshi_info: "锁定技。①你的手牌上限+X（X为全场势力数）。②每种势力限一次，当其他角色对你造成伤害时，你防止此伤害并令其获得你区域内一张牌。",
	ol_wuguotai: "OL界吴国太",
	ol_wuguotai_prefix: "OL界",
	olganlu: "甘露",
	olganlu_info: "出牌阶段限一次，你可以交换两名角色装备区内的牌，然后若你的已损失体力值小于X，你弃置X张牌（X为交换前两者装备区牌数之差）。",
	olbuyi: "补益",
	olbuyi_info: "一名角色进入濒死状态时，你可展示其一张牌。若此牌不为基本牌，则其弃置此牌并回复1点体力。",
	ol_sb_kongrong: "OL谋孔融",
	ol_sb_kongrong_prefix: "OL谋",
	olsbliwen: "立文",
	olsbliwen_info: (() => {
		let list = ["游戏开始时，你获得3枚“贤”标记（一名角色的“贤”标记上限为5）", "当你使用或打出牌后，若此牌与你使用或打出的上一张牌的花色或类型相同，则你获得1枚“贤”标记", "回合结束时，你依次执行：⒈你可以将任意枚“贤”标记分配给其他角色；⒉场上所有有“贤”标记的角色按照“贤”标记由大到小的顺序（“贤”标记数相同的角色按座次逆时针排序）依次选择是否使用一张手牌，若不选择使用，则其移去所有“贤”标记，然后你摸等量的牌"];
		return list.map((item, i) => ["①", "②", "③"][i] + item).join("。") + "。";
	})(),
	olsbzhengyi: "争义",
	olsbzhengyi_info: "当一名有“贤”标记的角色受到伤害时，其以外所有有“贤”标记的角色同时选择是否取消此伤害，所有角色选择完毕后，若有角色选择是，则取消此伤害，然后选择是的角色中体力值最大的角色依次失去X点体力（X为伤害值）。",
	ol_zhangchunhua: "OL界张春华",
	ol_zhangchunhua_prefix: "OL界",
	oljianmie: "翦灭",
	oljianmie_info: "出牌阶段限一次，你可以选择一名其他角色，你与其同时选择一个颜色，然后弃置各自选择颜色的手牌，若你/其以此法弃置了更多手牌，则你/其视为对其/你使用一张【决斗】。",
	ol_caochong: "OL界曹冲",
	ol_caochong_prefix: "OL界",
	olchengxiang: "称象",
	olchengxiang_info: "当你受到1点伤害后，你可以亮出牌堆顶的四张牌，然后获得其中任意张点数之和不大于13的牌；若获得的牌点数之和刚好为13，下次发动〖称象〗额外亮出一张牌。",
	olrenxin: "仁心",
	olrenxin_info: "当一名其他角色进入濒死状态时，你可以翻面并弃置一张装备牌，然后令该角色回复体力至1点。",
	ol_sb_sunjian: "OL谋孙坚",
	ol_sb_sunjian_prefix: "OL谋",
	olsbhulie: "虎烈",
	olsbhulie_info: "每回合各限一次，当你使用【杀】或【决斗】指定唯一目标后，你可以令此牌伤害值基数+1。若此牌未造成伤害，你可以令目标角色视为对你使用一张【杀】。",
	olsbyipo: "毅魄",
	olsbyipo_info: "你的体力值变化后，若你体力值大于0且为你首次达到，你可以选择一名角色并选择一项：1.令其摸X张牌，然后弃置一张牌；2.令其摸一张牌，然后其弃置X张牌（X为你已损失体力值且至少为1）。",
	ol_sb_yuanshu: "OL谋袁术",
	ol_sb_yuanshu_prefix: "OL谋",
	olsbjinming: "矜名",
	olsbjinming_info: "回合开始时，你可以选择一项：1.回复过1点体力；2.弃置过两张牌；3.使用过三种类型的牌；4.造成过4点伤害。然后本回合结束时你摸X张牌，若未满足选择的条件，则删除此选项（X为你最后一次发动〖矜名〗选择的选项序号）。",
	olsbxiaoshi: "枭噬",
	olsbxiaoshi_info: "出牌阶段限一次，你使用牌可以额外指定一个目标（无距离限制）。此牌结算完毕后，若此牌未造成过伤害，你失去1点体力或令其中一个目标摸X张牌（X为你最后一次发动〖矜名〗选择的选项序号）。",
	olsbyanliang: "厌粱",
	olsbyanliang_info: "主公技，其他群势力角色的出牌阶段限一次，其可以交给你一张装备牌，视为使用一张【酒】。",
	ol_caozhi: "OL界曹植",
	ol_caozhi_prefix: "OL界",
	oljiushi: "酒诗",
	oljiushi_info: "①当你需要使用【酒】时，若你的武将牌正面向上，你可以翻面，视为使用一张【酒】。②当你受到伤害后，若你的武将牌于受到伤害时背面向上，或当你于回合外累计因〖落英〗获取至少X张牌（X为你的体力上限）后，若你的武将牌背面向上，你可以翻面。③若你的武将牌背面向上，你使用因〖落英〗获得的牌无距离限制且不可被响应。",
	ol_sb_huaxiong: "OL谋华雄",
	ol_sb_huaxiong_prefix: "OL谋",
	olsbbojue: "搏决",
	olsbbojue_info: "出牌阶段限两次，你可以选择一名其他角色，然后同时与其选择摸一张牌或弃置一张牌，然后若你与其的手牌数之和的变化值为：0，你与其依次弃置对方一张牌；2，你与其依次视为对对方使用一张【杀】。",
	olsbyangwei: "扬威",
	olsbyangwei_info: "锁定技。当你于摸牌/弃牌阶段外摸/弃置了本回合的第二张牌后，你下一次造成/受到的伤害+1。",
	ol_sb_dongzhuo: "OL谋董卓",
	ol_sb_dongzhuo_prefix: "OL谋",
	olguanbian: "观变",
	olguanbian_info: "锁定技。①游戏开始时，你的手牌上限、其他角色计算与你的距离、你计算与其他角色的距离+X（X为游戏人数）。②首轮结束时，或当你发动〖凶逆〗或〖封赏〗后，你失去〖观变〗。",
	olxiongni: "凶逆",
	olxiongni_info: "出牌阶段开始时，你可以弃置一张牌，然后所有其他角色选择一项：1.弃置一张与此牌花色相同的牌；2.受到你的1点伤害。",
	olfengshang: "封赏",
	olfengshang_info: "出牌阶段限一次或有角色进入濒死状态时（每回合限一次），你可以将两张本回合进入弃牌堆中的本轮未以此法选择过的相同花色的牌分配给等量角色。若你未以此法获得牌，你视为使用一张不计入次数的【酒】。",
	olzhibin: "执柄",
	olzhibin_info: `主公技，锁定技。准备阶段，若其他群势力角色累计使用黑色牌的次数达到：三张，你增加1点体力上限并回复1点体力；六张，你获得${get.poptip("dcfencheng")}；九张：你获得${get.poptip("benghuai")}。`,
	ol_sb_dengai: "OL谋邓艾",
	ol_sb_dengai_prefix: "OL谋",
	olsbjigu: "积谷",
	olsbjigu_info: "锁定技。一名角色于其出牌阶段外使用的牌进入弃牌堆后，若“谷”的数量小于你的体力上限，你将其中的非♥牌至于你的武将牌上，称为“谷”。体力上限与你相同的角色的回合开始时，你用任意张手牌替换等量“谷”。",
	olsbjiewan: "解腕",
	olsbjiewan_info: "①每个准备阶段，你可以减少1点体力上限或移去两张“谷”，然后将一张手牌当距离限制为X的【顺手牵羊】使用（X为你的“谷”数且至少为1）。②每个结束阶段，若你的手牌数与“谷”的数量相同且你的体力上限不为全场唯一最高，你增加1点体力上限。",
	ol_sb_gongsunzan: "OL谋公孙瓒",
	ol_sb_gongsunzan_prefix: "OL谋",
	olsbjiaodi: "剿狄",
	olsbjiaodi_info: "锁定技。①你的攻击范围视为你的体力值。②当你使用【杀】指定唯一目标时，若其攻击范围：小于等于你，你令此牌造成的伤害+1，获得其一张手牌；大于等于你，你弃置其区域一张牌，选择一名角色作为此牌的额外目标。",
	olsbbaojing: "保京",
	olsbbaojing_info: "出牌阶段限一次，你可以令一名其他角色的攻击范围+1或-1（至多减至1）直到你的下个出牌阶段开始。",
	ol_guohuai: "OL界郭淮",
	ol_guohuai_prefix: "OL界",
	oljingce: "精策",
	oljingce_info: "当你于回合内首次使用某种花色的手牌时，你的手牌上限+1。一名角色的出牌阶段结束时，你可以摸X张牌（X为你本阶段内使用过的牌的类型数）。",
	ol_fuhuanghou: "OL界伏寿",
	ol_fuhuanghou_prefix: "OL界",
	olqiuyuan: "求援",
	olqiuyuan_info: "当你成为【杀】或伤害锦囊牌的目标时，你可以令另一名其他角色选择一项：1.交给你一张与此牌同类型且不同牌名的牌；2.成为此牌的额外目标。",
	ol_sb_zhangrang: "OL谋张让",
	ol_sb_zhangrang_prefix: "OL谋",
	olsblucun: "赂存",
	olsblucun_info: "每回合限一次，你可以视为使用一张本轮未以此法使用过的基本牌或普通锦囊牌。此牌结算完毕后，当前回合角色将一张手牌置于你的武将牌上，称为“赂”；本回合结束时，你将一张“赂”置入弃牌堆并摸一张牌（若你本回合因此技能使用的牌名包含你选择移去的“赂”的牌名，则你额外摸一张牌）。",
	olsbtuisheng: "蜕生",
	olsbtuisheng_info: "限定技，准备阶段或当你进入濒死状态时，你可以重置你本轮〖赂存〗使用过的牌名，然后你选择一项并回复1点体力：①将所有手牌置于你的武将牌上，称为“赂”；②令当前回合角色获得你的所有“赂”且你回复1点体力。",
	ol_sb_wenchou: "OL谋文丑",
	ol_sb_wenchou_prefix: "OL谋",
	olsblunzhan: "轮战",
	olsblunzhan_info: "出牌阶段，你可将任意张牌当作【决斗】使用（至多五张，且选择的转化牌数不得为你本回合发动〖轮战〗已经转化过的牌数）。若你因此对唯一目标造成了伤害，你可以摸X张牌，然后你本回合不能再对其发动此技能（X为本回合你使用牌指定其为目标的次数）。",
	olsbjuejue: "决绝",
	olsbjuejue_info: "锁定技，当你于回合内首次仅使用所有手牌指定仅一名其他角色为目标时，你令其弃置X张牌（X为本回合你使用牌指定其为目标的次数）。",
	ol_sb_jiaxu: "OL谋贾诩",
	ol_sb_jiaxu_prefix: "OL谋",
	olsbwance: "完策",
	olsbwance_info: "出牌阶段限一次，你可以选择一名有手牌的角色并选择一个单目标普通锦囊牌牌名，其依次将X张手牌当作此普通锦囊牌使用（X为游戏轮数且至多为3）。其以此法使用的牌指定目标时，你可以弃置一张牌并修改此牌的目标。",
	olsbchenzhi: "沉智",
	olsbchenzhi_info: "①当你受到伤害时，若你本轮已受到过X次伤害，则防止之（X为游戏轮数且至多为3）。②每局游戏限一次，每轮结束时，若你本轮未发动过〖沉智①〗，则你可以复原一名角色的一个限定技。",
	olsbluanchao: "乱朝",
	olsbluanchao_info: "限定技，每轮开始时，你可以令所有角色依次选择从牌堆中获得一张【杀】或【闪】。选择获得【杀】的角色本轮首次造成的伤害+1。",
	ol_jsrg_zhaoyun: "闪赵云",
	ol_jsrg_zhaoyun_prefix: "闪",
	ollonglin: "龙临",
	ollonglin_info: "其他角色于其出牌阶段内首次使用【杀】指定目标后，你可以弃置一张牌令此【杀】无效，然后其可以视为对你使用一张【决斗】，你以此法造成伤害后，其本阶段使用的下一张牌不能指定其他角色为目标。",
	olzhendan: "镇胆",
	olzhendan_info: "①你可以将一张非基本手牌当作本轮未使用过的任意基本牌使用或打出。②当你受到伤害后或每轮结束时，你摸X张牌并令该技能本轮失效（X为本轮所有角色执行过的回合数且至多为5）。",
	ol_jsrg_liuhong: "闪刘宏",
	ol_jsrg_liuhong_prefix: "闪",
	olchaozheng: "朝争",
	olchaozheng_info: "①准备阶段，你可以与所有其他角色议事。若结果为：红色，意见为红色的角色各回复1点体力；黑色，意见为红色的其他角色各失去1点体力。然后你摸X张牌（X为此次议事意见与你相同的角色数且至多为2）。②当你参与的议事展示意见时，你的意见权重+1。",
	olshenchong: "甚宠",
	olshenchong_info: `限定技。准备阶段，你可以令一名其他角色获得${get.poptip("olrefeiyang")}和${get.poptip("jsrgbahu")}。若如此做，当你死亡时，杀死你的角色弃置所有手牌，其失去所有技能。`,
	oljulian: "聚敛",
	oljulian_info: "主公技。①其他群势力角色每回合限一次。当其不于摸牌阶段且不因〖聚敛〗摸牌后，其可以摸一张牌。②结束阶段，你可以获得所有其他群势力角色各一张牌。",
	olrefeiyang: "飞扬",
	olrefeiyang_info: "判定阶段开始时，若你的判定区有牌，则你可以弃置两张牌，然后弃置你判定区的所有牌。",
	dm_simayi: "魔司马懿",
	dm_simayi_prefix: "魔",
	olguifu: "诡伏",
	olguifu_info: "①每轮开始时或你受到伤害、失去体力、回复体力后，你可以随机从牌堆或弃牌堆获得一张不计入手牌上限的【闪】。②本局游戏中牌或技能直接造成伤害后，你记录此牌名或技能。③每回合每种牌名限一次，你可以将因此技能获得的【闪】当做不计入次数限制的〖诡伏②〗记录过的牌名使用。",
	olmoubian: "谋变",
	olmoubian_info: `准备阶段，若你记录的牌名和技能之和大于等于3，你可以${get.poptip("rule_rumo")}，获得记录的全部技能，然后获得${get.poptip("olzhouxi")}。`,
	//olmoubian_append: `<span style="font-family:yuanli"><li>入魔：每局游戏限一次，当你满足条件后，可入魔。入魔后，每轮结束时，若本轮你未造成过伤害，你失去1点体力。</span>`,
	olzhouxi: "骤袭",
	olzhouxi_info: "①准备阶段，你从三个可造成伤害的技能中选择一个获得直到你的下回合开始。②本轮受到你伤害的角色于本轮结束时视为对你使用一张【杀】。",
	olrumo: "入魔",
	olrumo_info: "每局游戏限一次，当你满足条件后，可入魔。入魔后，每轮结束时，若本轮你未造成过伤害，你失去1点体力。",
	ol_sb_xiaoqiao: "OL谋小乔",
	ol_sb_xiaoqiao_prefix: "OL谋",
	olmiluo: "迷落",
	olmiluo_info: "出牌阶段限一次，你可展示并交给至多两名其他角色各一张牌，这些牌本轮称为“迷落”牌。每轮结束时，你可令其中一名手牌中没有/有“迷落”牌的角色失去/回复1点体力。",
	oljueyan: "绝颜",
	oljueyan_info: "每轮各限一次，当你需要使用手牌中一张普通锦囊牌或红色基本牌时，可改为展示并视为使用之；你每轮首次展示一种花色的手牌后摸一张牌。",
	ol_guohuanghou: "OL界郭皇后",
	ol_guohuanghou_prefix: "OL界",
	oljiaozhao: "矫诏",
	oljiaozhao_info: "出牌阶段限一次，你可以展示一张手牌并声明一种未以此法声明过的基本牌或普通锦囊牌，你本回合可以将展示牌当声明的牌使用（不能对自己使用）。",
	oljiaozhao_lv1: "矫诏·升级lv1",
	oljiaozhao_lv1_info: "出牌阶段限一次，你可以展示一张手牌并声明一种基本牌或普通锦囊牌，你本回合可以将展示牌当声明的牌使用（不能对自己使用）。",
	oljiaozhao_lv2: "矫诏·升级lv2",
	oljiaozhao_lv2_info: "出牌阶段限一次，你可以视为使用一张基本牌或普通锦囊牌（不能对自己使用）。",
	oldanxin: "殚心",
	oldanxin_info: "当你受到伤害后，你可以摸一张牌并升级〖矫诏〗。",
	ol_sunluban: "OL界孙鲁班",
	ol_sunluban_prefix: "OL界",
	olzenhui: "谮毁",
	olzenhui_info: "出牌阶段各限一次，你使用【杀】或普通锦囊牌（【借刀杀人】等带有指向性目标的牌除外）指定目标时，可以令一名能成为此牌目标的角色选择一项：1.交给你一张牌并代替你成为此牌使用者（不计次数）；2.成为此牌的额外目标。",
	oljiaojin: "骄矜",
	oljiaojin_info: "你受到伤害时，可以弃置一张非伤害牌并防止此伤害，然后获得造成伤害的牌。",
	dm_diaochan: "魔貂蝉",
	dm_diaochan_prefix: "魔",
	olhuanhuo: "幻惑",
	olhuanhuo_info: "每轮开始时，你摸两张牌，然后弃置至多两张牌并选择等量其他角色。其下回合出牌阶段需要使用牌时强制选中一张可用的手牌（不能使用主动技能），且每使用一张牌后随机弃一张牌，直到其使用了两张牌后。",
	olqingshi: "倾世",
	olqingshi_info: `准备阶段，你可${get.poptip("rule_rumo")}，令所有角色获得一张单目标伤害牌。其他角色使用此牌指定唯一目标时，你可弃置一张牌，重新指定牌的目标（无距离限制)。这些牌：造成伤害后，你摸一张牌；未因使用进入弃牌堆后，你获得之。（准备阶段，若这些牌均离开其手牌区，你再令所有角色获得牌。）`,
	dm_lvbu: "魔吕布",
	dm_lvbu_prefix: "魔",
	olduoqi: "夺炁",
	olduoqi_info: "锁定技。①所有角色的初始手牌称为“炁”。②一号位首个回合开始前，你执行一个不能使用延时锦囊牌的出牌阶段。③你每回合对一名角色首次造成伤害后，你从弃牌堆、牌堆、场上角色的区域内中获得其一张“炁”。",
	olduoqi_tag: "炁",
	olkuangmo: "狂魔",
	olkuangmo_info: `出牌阶段，你可以${get.poptip("rule_rumo")}并选择一名其他角色，你与其成为“狂”角色，每回合对彼此首次造成的伤害+1；杀死对方后，获得对方所有“炁”。“狂”角色死亡后，你重新指定。`,
	olgangquan: "罡拳",
	olgangquan_info: "若你使用的上一张牌为“炁”，你可以将一张装备牌当指定相邻角色为目标的火【杀】使用；否则，你可以将一张锦囊牌当【决斗】使用。",
	ol_jsrg_zhangliao: "闪张辽",
	ol_jsrg_zhangliao_prefix: "闪",
	olzhengbing: "整兵",
	olzhengbing_info: "群势力技。出牌阶段限三次。你可以重铸一张牌，若此牌为：【杀】，你的手牌上限+1；【闪】，你摸一张牌；【桃】/【酒】，你于此回合结束时执行一个出牌阶段。然后若你以此法触发过所有选项，变更势力为魏。",
	dm_caocao: "OL魔曹操",
	dm_caocao_prefix: "OL|魔",
	olbachao: "霸朝",
	olbachao_info: `出牌阶段开始时，你可以令所有其他角色同时选择是否交给你一张牌，然后你可对一名未以此法交给你非基本牌的角色造成1点伤害；若该角色为你，本阶段你使用当前手牌无距离次数限制并${get.poptip("rule_rumo")}。`,
	olfuzai: "覆载",
	olfuzai_info: "锁定技，①你的装备牌只能当【借刀杀人】或【无中生有】使用。②若你的装备区没有牌，你视为装备着随机武器和防具各一件（优先装备攻击距离/牌名字数与你的体力值相同的武器/防具）。",
};

export default translates;
