/* soapC.cpp
   Generated by gSOAP 2.8.17r from DumpUploader.h

Copyright(C) 2000-2013, Robert van Engelen, Genivia Inc. All Rights Reserved.
The generated code is released under one of the following licenses:
GPL or Genivia's license for commercial use.
This program is released under the GPL with the additional exemption that
compiling, linking, and/or using OpenSSL is allowed.
*/

#if defined(__BORLANDC__)
#pragma option push -w-8060
#pragma option push -w-8004
#endif

#include "soapH.h"

SOAP_SOURCE_STAMP("@(#) soapC.cpp ver 2.8.17r 2014-08-13 22:23:36 GMT")


#ifndef WITH_NOGLOBAL

SOAP_FMAC3 int SOAP_FMAC4 soap_getheader(struct soap *soap)
{
    soap->part = SOAP_IN_HEADER;
    soap->header = soap_in_SOAP_ENV__Header(soap, "SOAP-ENV:Header", soap->header, NULL);
    soap->part = SOAP_END_HEADER;
    return soap->header == NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putheader(struct soap *soap)
{
    if (soap->version && soap->header)
    {   soap->part = SOAP_IN_HEADER;
        if (soap_out_SOAP_ENV__Header(soap, "SOAP-ENV:Header", 0, soap->header, NULL))
            return soap->error;
        soap->part = SOAP_END_HEADER;
    }
    return SOAP_OK;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serializeheader(struct soap *soap)
{
    if (soap->version && soap->header)
        soap_serialize_SOAP_ENV__Header(soap, soap->header);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_header(struct soap *soap)
{
    if (soap->header == NULL)
    {   if ((soap->header = soap_new_SOAP_ENV__Header(soap, -1)))
            soap_default_SOAP_ENV__Header(soap, soap->header);
    }
}

SOAP_FMAC3 void SOAP_FMAC4 soap_fault(struct soap *soap)
{
    if (soap->fault == NULL)
    {   soap->fault = soap_new_SOAP_ENV__Fault(soap, -1);
        if (soap->fault == NULL)
            return;
        soap_default_SOAP_ENV__Fault(soap, soap->fault);
    }
    if (soap->version == 2 && !soap->fault->SOAP_ENV__Code)
    {   soap->fault->SOAP_ENV__Code = soap_new_SOAP_ENV__Code(soap, -1);
        soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code);
    }
    if (soap->version == 2 && !soap->fault->SOAP_ENV__Reason)
    {   soap->fault->SOAP_ENV__Reason = soap_new_SOAP_ENV__Reason(soap, -1);
        soap_default_SOAP_ENV__Reason(soap, soap->fault->SOAP_ENV__Reason);
    }
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serializefault(struct soap *soap)
{
    soap_fault(soap);
    if (soap->fault)
        soap_serialize_SOAP_ENV__Fault(soap, soap->fault);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putfault(struct soap *soap)
{
    if (soap->fault)
        return soap_put_SOAP_ENV__Fault(soap, soap->fault, "SOAP-ENV:Fault", NULL);
    return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getfault(struct soap *soap)
{
    return (soap->fault = soap_get_SOAP_ENV__Fault(soap, NULL, "SOAP-ENV:Fault", NULL)) == NULL;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultcode(struct soap *soap)
{
    soap_fault(soap);
    if (soap->version == 2 && soap->fault->SOAP_ENV__Code)
        return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Value;
    return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultsubcode(struct soap *soap)
{
    soap_fault(soap);
    if (soap->version == 2)
    {   if (soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode == NULL)
        {   soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode = soap_new_SOAP_ENV__Code(soap, -1);
            soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode);
        }
        return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode->SOAP_ENV__Value;
    }
    return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char * SOAP_FMAC4 soap_check_faultsubcode(struct soap *soap)
{
    soap_fault(soap);
    if (soap->version == 2)
    {   if (soap->fault->SOAP_ENV__Code && soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode && soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode)
            return soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode->SOAP_ENV__Value;
        return NULL;
    }
    return soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultstring(struct soap *soap)
{
    soap_fault(soap);
    if (soap->version == 2)
        return (const char**)&soap->fault->SOAP_ENV__Reason->SOAP_ENV__Text;
    return (const char**)&soap->fault->faultstring;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultdetail(struct soap *soap)
{
    soap_fault(soap);
    if (soap->version == 2)
    {   if (soap->fault->SOAP_ENV__Detail == NULL)
        {   soap->fault->SOAP_ENV__Detail = soap_new_SOAP_ENV__Detail(soap, -1);
            soap_default_SOAP_ENV__Detail(soap, soap->fault->SOAP_ENV__Detail);
        }
        return (const char**)&soap->fault->SOAP_ENV__Detail->__any;
    }
    if (soap->fault->detail == NULL)
    {   soap->fault->detail = soap_new_SOAP_ENV__Detail(soap, -1);
        soap_default_SOAP_ENV__Detail(soap, soap->fault->detail);
    }
    return (const char**)&soap->fault->detail->__any;
}

SOAP_FMAC3 const char * SOAP_FMAC4 soap_check_faultdetail(struct soap *soap)
{
    soap_fault(soap);
    if (soap->version == 2 && soap->fault->SOAP_ENV__Detail)
        return soap->fault->SOAP_ENV__Detail->__any;
    if (soap->fault->detail)
        return soap->fault->detail->__any;
    return NULL;
}

#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_getindependent(struct soap *soap)
{
    int t;
    if (soap->version == 1)
    {   for (;;)
        {   if (!soap_getelement(soap, &t))
                if (soap->error || soap_ignore_element(soap))
                    break;
        }
    }
    if (soap->error == SOAP_NO_TAG || soap->error == SOAP_EOF)
        soap->error = SOAP_OK;
    return soap->error;
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
SOAP_FMAC3 void * SOAP_FMAC4 soap_getelement(struct soap *soap, int *type)
{   (void)type;
    if (soap_peek_element(soap))
        return NULL;
#ifndef WITH_NOIDREF
    if (!*soap->id || !(*type = soap_lookup_type(soap, soap->id)))
        *type = soap_lookup_type(soap, soap->href);
    switch (*type)
    {
    case SOAP_TYPE_xsd__byte:
        return soap_in_xsd__byte(soap, NULL, NULL, "xsd:byte");
    case SOAP_TYPE_byte:
        return soap_in_byte(soap, NULL, NULL, "xsd:byte");
    case SOAP_TYPE_short:
        return soap_in_short(soap, NULL, NULL, "xsd:short");
    case SOAP_TYPE_ns3__char:
        return soap_in_ns3__char(soap, NULL, NULL, "ns3:char");
    case SOAP_TYPE_int:
        return soap_in_int(soap, NULL, NULL, "xsd:int");
    case SOAP_TYPE_LONG64:
        return soap_in_LONG64(soap, NULL, NULL, "xsd:long");
    case SOAP_TYPE_float:
        return soap_in_float(soap, NULL, NULL, "xsd:float");
    case SOAP_TYPE_double:
        return soap_in_double(soap, NULL, NULL, "xsd:double");
    case SOAP_TYPE_xsd__unsignedByte:
        return soap_in_xsd__unsignedByte(soap, NULL, NULL, "xsd:unsignedByte");
    case SOAP_TYPE_unsignedByte:
        return soap_in_unsignedByte(soap, NULL, NULL, "xsd:unsignedByte");
    case SOAP_TYPE_unsignedShort:
        return soap_in_unsignedShort(soap, NULL, NULL, "xsd:unsignedShort");
    case SOAP_TYPE_unsignedInt:
        return soap_in_unsignedInt(soap, NULL, NULL, "xsd:unsignedInt");
    case SOAP_TYPE_unsignedLONG64:
        return soap_in_unsignedLONG64(soap, NULL, NULL, "xsd:unsignedLong");
    case SOAP_TYPE_time:
        return soap_in_time(soap, NULL, NULL, "xsd:dateTime");
    case SOAP_TYPE_ns4__HaveSolutionResponse_SolutionType:
        return soap_in_ns4__HaveSolutionResponse_SolutionType(soap, NULL, NULL, "ns4:HaveSolutionResponse.SolutionType");
    case SOAP_TYPE_ns4__ClientLib_ClientType:
        return soap_in_ns4__ClientLib_ClientType(soap, NULL, NULL, "ns4:ClientLib.ClientType");
    case SOAP_TYPE_ns4__ClientLib_Architecture:
        return soap_in_ns4__ClientLib_Architecture(soap, NULL, NULL, "ns4:ClientLib.Architecture");
    case SOAP_TYPE_bool:
        return soap_in_bool(soap, NULL, NULL, "xsd:boolean");
    case SOAP_TYPE_ns4__HaveSolutionResponse_SolutionType_:
        return soap_in_ns4__HaveSolutionResponse_SolutionType_(soap, NULL, NULL, "ns4:HaveSolutionResponse.SolutionType");
    case SOAP_TYPE_ns4__ClientLib_ClientType_:
        return soap_in_ns4__ClientLib_ClientType_(soap, NULL, NULL, "ns4:ClientLib.ClientType");
    case SOAP_TYPE_ns4__ClientLib_Architecture_:
        return soap_in_ns4__ClientLib_Architecture_(soap, NULL, NULL, "ns4:ClientLib.Architecture");
    case SOAP_TYPE_ns3__guid__:
        return soap_in_ns3__guid__(soap, NULL, NULL, "ns3:guid");
    case SOAP_TYPE_ns3__guid:
        return soap_in_ns3__guid(soap, NULL, NULL, "ns3:guid");
    case SOAP_TYPE_ns3__duration__:
        return soap_in_ns3__duration__(soap, NULL, NULL, "ns3:duration");
    case SOAP_TYPE_ns3__duration:
        return soap_in_ns3__duration(soap, NULL, NULL, "ns3:duration");
    case SOAP_TYPE_ns3__char__:
        return soap_in_ns3__char__(soap, NULL, NULL, "ns3:char");
    case SOAP_TYPE_ns5__ArrayOfstring:
        return soap_in_ns5__ArrayOfstring(soap, NULL, NULL, "ns5:ArrayOfstring");
    case SOAP_TYPE_ns1__NeedMoreInfoResponse:
        return soap_in_ns1__NeedMoreInfoResponse(soap, NULL, NULL, "ns1:NeedMoreInfoResponse");
    case SOAP_TYPE_ns1__NeedFullDumpResponse:
        return soap_in_ns1__NeedFullDumpResponse(soap, NULL, NULL, "ns1:NeedFullDumpResponse");
    case SOAP_TYPE_ns1__NeedMiniDumpResponse:
        return soap_in_ns1__NeedMiniDumpResponse(soap, NULL, NULL, "ns1:NeedMiniDumpResponse");
    case SOAP_TYPE_ns1__NeedSymbolsThenMiniDumpResponse:
        return soap_in_ns1__NeedSymbolsThenMiniDumpResponse(soap, NULL, NULL, "ns1:NeedSymbolsThenMiniDumpResponse");
    case SOAP_TYPE_ns1__HaveSolutionResponse:
        return soap_in_ns1__HaveSolutionResponse(soap, NULL, NULL, "ns1:HaveSolutionResponse");
    case SOAP_TYPE_ns1__ErrorResponse:
        return soap_in_ns1__ErrorResponse(soap, NULL, NULL, "ns1:ErrorResponse");
    case SOAP_TYPE_ns1__StopResponse:
        return soap_in_ns1__StopResponse(soap, NULL, NULL, "ns1:StopResponse");
    case SOAP_TYPE_ns1__Response:
        return soap_in_ns1__Response(soap, NULL, NULL, "ns1:Response");
    case SOAP_TYPE_ns1__Pdb70File:
        return soap_in_ns1__Pdb70File(soap, NULL, NULL, "ns1:Pdb70File");
    case SOAP_TYPE_ns1__ModuleSymbolInfo:
        return soap_in_ns1__ModuleSymbolInfo(soap, NULL, NULL, "ns1:ModuleSymbolInfo");
    case SOAP_TYPE_ns1__ArrayOfModuleSymbolInfo:
        return soap_in_ns1__ArrayOfModuleSymbolInfo(soap, NULL, NULL, "ns1:ArrayOfModuleSymbolInfo");
    case SOAP_TYPE_ns1__DumpAdditionalInfo:
        return soap_in_ns1__DumpAdditionalInfo(soap, NULL, NULL, "ns1:DumpAdditionalInfo");
    case SOAP_TYPE_ns1__AppAdditionalInfo:
        return soap_in_ns1__AppAdditionalInfo(soap, NULL, NULL, "ns1:AppAdditionalInfo");
    case SOAP_TYPE_ns1__Application:
        return soap_in_ns1__Application(soap, NULL, NULL, "ns1:Application");
    case SOAP_TYPE_ns1__ClientLib:
        return soap_in_ns1__ClientLib(soap, NULL, NULL, "ns1:ClientLib");
    case SOAP_TYPE_xsd__unsignedShort:
        return soap_in_xsd__unsignedShort(soap, NULL, NULL, "xsd:unsignedShort");
    case SOAP_TYPE_xsd__unsignedLong:
        return soap_in_xsd__unsignedLong(soap, NULL, NULL, "xsd:unsignedLong");
    case SOAP_TYPE_xsd__unsignedInt:
        return soap_in_xsd__unsignedInt(soap, NULL, NULL, "xsd:unsignedInt");
    case SOAP_TYPE_xsd__unsignedByte_:
        return soap_in_xsd__unsignedByte_(soap, NULL, NULL, "xsd:unsignedByte");
    case SOAP_TYPE_xsd__string:
        return soap_in_xsd__string(soap, NULL, NULL, "xsd:string");
    case SOAP_TYPE_xsd__short:
        return soap_in_xsd__short(soap, NULL, NULL, "xsd:short");
    case SOAP_TYPE_xsd__long:
        return soap_in_xsd__long(soap, NULL, NULL, "xsd:long");
    case SOAP_TYPE_xsd__int:
        return soap_in_xsd__int(soap, NULL, NULL, "xsd:int");
    case SOAP_TYPE_xsd__float:
        return soap_in_xsd__float(soap, NULL, NULL, "xsd:float");
    case SOAP_TYPE_xsd__duration_:
        return soap_in_xsd__duration_(soap, NULL, NULL, "xsd:duration");
    case SOAP_TYPE_xsd__duration:
        return soap_in_xsd__duration(soap, NULL, NULL, "xsd:duration");
    case SOAP_TYPE_xsd__double:
        return soap_in_xsd__double(soap, NULL, NULL, "xsd:double");
    case SOAP_TYPE_xsd__decimal_:
        return soap_in_xsd__decimal_(soap, NULL, NULL, "xsd:decimal");
    case SOAP_TYPE_xsd__decimal:
        return soap_in_xsd__decimal(soap, NULL, NULL, "xsd:decimal");
    case SOAP_TYPE_xsd__dateTime:
        return soap_in_xsd__dateTime(soap, NULL, NULL, "xsd:dateTime");
    case SOAP_TYPE_xsd__byte_:
        return soap_in_xsd__byte_(soap, NULL, NULL, "xsd:byte");
    case SOAP_TYPE_xsd__boolean:
        return soap_in_xsd__boolean(soap, NULL, NULL, "xsd:boolean");
    case SOAP_TYPE_xsd__base64Binary:
        return soap_in_xsd__base64Binary(soap, NULL, NULL, "xsd:base64Binary");
    case SOAP_TYPE_xsd__anyURI_:
        return soap_in_xsd__anyURI_(soap, NULL, NULL, "xsd:anyURI");
    case SOAP_TYPE_xsd__anyURI:
        return soap_in_xsd__anyURI(soap, NULL, NULL, "xsd:anyURI");
    case SOAP_TYPE_xsd__QName_:
        return soap_in_xsd__QName_(soap, NULL, NULL, "xsd:QName");
    case SOAP_TYPE_xsd__IDREF_:
        return soap_in_xsd__IDREF_(soap, NULL, NULL, "xsd:IDREF");
    case SOAP_TYPE_xsd__IDREF:
        return soap_in_xsd__IDREF(soap, NULL, NULL, "xsd:IDREF");
    case SOAP_TYPE_xsd__ID_:
        return soap_in_xsd__ID_(soap, NULL, NULL, "xsd:ID");
    case SOAP_TYPE_xsd__ID:
        return soap_in_xsd__ID(soap, NULL, NULL, "xsd:ID");
    case SOAP_TYPE_std__wstring:
        return soap_in_std__wstring(soap, NULL, NULL, "xsd:string");
    case SOAP_TYPE_xsd__QName:
        return soap_in_xsd__QName(soap, NULL, NULL, "xsd:QName");
    case SOAP_TYPE_std__string:
        return soap_in_std__string(soap, NULL, NULL, "xsd:string");
    case SOAP_TYPE_xsd__anyType:
        return soap_in_xsd__anyType(soap, NULL, NULL, "xsd:anyType");
    case SOAP_TYPE_PointerTo_ns1__UploadSymbolResponse:
        return soap_in_PointerTo_ns1__UploadSymbolResponse(soap, NULL, NULL, "ns1:UploadSymbolResponse");
    case SOAP_TYPE_PointerTo_ns1__UploadSymbol:
        return soap_in_PointerTo_ns1__UploadSymbol(soap, NULL, NULL, "ns1:UploadSymbol");
    case SOAP_TYPE_PointerTo_ns1__RejectedToSendAdditionalInfoResponse:
        return soap_in_PointerTo_ns1__RejectedToSendAdditionalInfoResponse(soap, NULL, NULL, "ns1:RejectedToSendAdditionalInfoResponse");
    case SOAP_TYPE_PointerTo_ns1__RejectedToSendAdditionalInfo:
        return soap_in_PointerTo_ns1__RejectedToSendAdditionalInfo(soap, NULL, NULL, "ns1:RejectedToSendAdditionalInfo");
    case SOAP_TYPE_PointerTo_ns1__UploadAdditionalInfoResponse:
        return soap_in_PointerTo_ns1__UploadAdditionalInfoResponse(soap, NULL, NULL, "ns1:UploadAdditionalInfoResponse");
    case SOAP_TYPE_PointerTo_ns1__UploadAdditionalInfo:
        return soap_in_PointerTo_ns1__UploadAdditionalInfo(soap, NULL, NULL, "ns1:UploadAdditionalInfo");
    case SOAP_TYPE_PointerTo_ns1__UploadFullDumpResponse:
        return soap_in_PointerTo_ns1__UploadFullDumpResponse(soap, NULL, NULL, "ns1:UploadFullDumpResponse");
    case SOAP_TYPE_PointerTo_ns1__UploadFullDump:
        return soap_in_PointerTo_ns1__UploadFullDump(soap, NULL, NULL, "ns1:UploadFullDump");
    case SOAP_TYPE_PointerTo_ns1__UploadMiniDumpResponse:
        return soap_in_PointerTo_ns1__UploadMiniDumpResponse(soap, NULL, NULL, "ns1:UploadMiniDumpResponse");
    case SOAP_TYPE_PointerTo_ns1__UploadMiniDump:
        return soap_in_PointerTo_ns1__UploadMiniDump(soap, NULL, NULL, "ns1:UploadMiniDump");
    case SOAP_TYPE_PointerTo_ns1__HelloResponse:
        return soap_in_PointerTo_ns1__HelloResponse(soap, NULL, NULL, "ns1:HelloResponse");
    case SOAP_TYPE_PointerTo_ns1__Hello:
        return soap_in_PointerTo_ns1__Hello(soap, NULL, NULL, "ns1:Hello");
    case SOAP_TYPE_PointerTons5__ArrayOfstring:
        return soap_in_PointerTons5__ArrayOfstring(soap, NULL, NULL, "ns5:ArrayOfstring");
    case SOAP_TYPE_PointerTobool:
        return soap_in_PointerTobool(soap, NULL, NULL, "xsd:boolean");
    case SOAP_TYPE_PointerTons1__Response:
        return soap_in_PointerTons1__Response(soap, NULL, NULL, "ns1:Response");
    case SOAP_TYPE_PointerTons1__ArrayOfModuleSymbolInfo:
        return soap_in_PointerTons1__ArrayOfModuleSymbolInfo(soap, NULL, NULL, "ns1:ArrayOfModuleSymbolInfo");
    case SOAP_TYPE_PointerTons1__DumpAdditionalInfo:
        return soap_in_PointerTons1__DumpAdditionalInfo(soap, NULL, NULL, "ns1:DumpAdditionalInfo");
    case SOAP_TYPE_PointerTons1__AppAdditionalInfo:
        return soap_in_PointerTons1__AppAdditionalInfo(soap, NULL, NULL, "ns1:AppAdditionalInfo");
    case SOAP_TYPE_PointerTons1__Application:
        return soap_in_PointerTons1__Application(soap, NULL, NULL, "ns1:Application");
    case SOAP_TYPE_PointerTons1__ClientLib:
        return soap_in_PointerTons1__ClientLib(soap, NULL, NULL, "ns1:ClientLib");
    case SOAP_TYPE_PointerToint:
        return soap_in_PointerToint(soap, NULL, NULL, "xsd:int");
    case SOAP_TYPE_PointerTo_xop__Include:
        return soap_in_PointerTo_xop__Include(soap, NULL, NULL, "xop:Include");
    case SOAP_TYPE_PointerTons1__Pdb70File:
        return soap_in_PointerTons1__Pdb70File(soap, NULL, NULL, "ns1:Pdb70File");
    case SOAP_TYPE_PointerTons1__ModuleSymbolInfo:
        return soap_in_PointerTons1__ModuleSymbolInfo(soap, NULL, NULL, "ns1:ModuleSymbolInfo");
    case SOAP_TYPE_PointerTostd__wstring:
        return soap_in_PointerTostd__wstring(soap, NULL, NULL, "xsd:string");
    case SOAP_TYPE_PointerTounsignedByte:
        return soap_in_PointerTounsignedByte(soap, NULL, NULL, "xsd:unsignedByte");
    case SOAP_TYPE__QName:
    {   char **s;
        s = soap_in__QName(soap, NULL, NULL, "xsd:QName");
        return s ? *s : NULL;
    }
    case SOAP_TYPE_string:
    {   char **s;
        s = soap_in_string(soap, NULL, NULL, "xsd:string");
        return s ? *s : NULL;
    }
    default:
#else
    *type = 0;
#endif
    {   const char *t = soap->type;
        if (!*t)
            t = soap->tag;
        if (!soap_match_tag(soap, t, "ns4:HaveSolutionResponse.SolutionType"))
        {   *type = SOAP_TYPE_ns4__HaveSolutionResponse_SolutionType_;
            return soap_in_ns4__HaveSolutionResponse_SolutionType_(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "ns4:ClientLib.ClientType"))
        {   *type = SOAP_TYPE_ns4__ClientLib_ClientType_;
            return soap_in_ns4__ClientLib_ClientType_(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "ns4:ClientLib.Architecture"))
        {   *type = SOAP_TYPE_ns4__ClientLib_Architecture_;
            return soap_in_ns4__ClientLib_Architecture_(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "ns3:guid"))
        {   *type = SOAP_TYPE_ns3__guid__;
            return soap_in_ns3__guid__(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "ns3:guid"))
        {   *type = SOAP_TYPE_ns3__guid;
            return soap_in_ns3__guid(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "ns3:duration"))
        {   *type = SOAP_TYPE_ns3__duration__;
            return soap_in_ns3__duration__(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "ns3:duration"))
        {   *type = SOAP_TYPE_ns3__duration;
            return soap_in_ns3__duration(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "ns3:char"))
        {   *type = SOAP_TYPE_ns3__char__;
            return soap_in_ns3__char__(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "ns5:ArrayOfstring"))
        {   *type = SOAP_TYPE_ns5__ArrayOfstring;
            return soap_in_ns5__ArrayOfstring(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "ns1:NeedMoreInfoResponse"))
        {   *type = SOAP_TYPE_ns1__NeedMoreInfoResponse;
            return soap_in_ns1__NeedMoreInfoResponse(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "ns1:NeedFullDumpResponse"))
        {   *type = SOAP_TYPE_ns1__NeedFullDumpResponse;
            return soap_in_ns1__NeedFullDumpResponse(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "ns1:NeedMiniDumpResponse"))
        {   *type = SOAP_TYPE_ns1__NeedMiniDumpResponse;
            return soap_in_ns1__NeedMiniDumpResponse(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "ns1:NeedSymbolsThenMiniDumpResponse"))
        {   *type = SOAP_TYPE_ns1__NeedSymbolsThenMiniDumpResponse;
            return soap_in_ns1__NeedSymbolsThenMiniDumpResponse(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "ns1:HaveSolutionResponse"))
        {   *type = SOAP_TYPE_ns1__HaveSolutionResponse;
            return soap_in_ns1__HaveSolutionResponse(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "ns1:ErrorResponse"))
        {   *type = SOAP_TYPE_ns1__ErrorResponse;
            return soap_in_ns1__ErrorResponse(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "ns1:StopResponse"))
        {   *type = SOAP_TYPE_ns1__StopResponse;
            return soap_in_ns1__StopResponse(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "ns1:Response"))
        {   *type = SOAP_TYPE_ns1__Response;
            return soap_in_ns1__Response(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "ns1:Pdb70File"))
        {   *type = SOAP_TYPE_ns1__Pdb70File;
            return soap_in_ns1__Pdb70File(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "ns1:ModuleSymbolInfo"))
        {   *type = SOAP_TYPE_ns1__ModuleSymbolInfo;
            return soap_in_ns1__ModuleSymbolInfo(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "ns1:ArrayOfModuleSymbolInfo"))
        {   *type = SOAP_TYPE_ns1__ArrayOfModuleSymbolInfo;
            return soap_in_ns1__ArrayOfModuleSymbolInfo(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "ns1:DumpAdditionalInfo"))
        {   *type = SOAP_TYPE_ns1__DumpAdditionalInfo;
            return soap_in_ns1__DumpAdditionalInfo(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "ns1:AppAdditionalInfo"))
        {   *type = SOAP_TYPE_ns1__AppAdditionalInfo;
            return soap_in_ns1__AppAdditionalInfo(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "ns1:Application"))
        {   *type = SOAP_TYPE_ns1__Application;
            return soap_in_ns1__Application(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "ns1:ClientLib"))
        {   *type = SOAP_TYPE_ns1__ClientLib;
            return soap_in_ns1__ClientLib(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "xsd:unsignedShort"))
        {   *type = SOAP_TYPE_xsd__unsignedShort;
            return soap_in_xsd__unsignedShort(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "xsd:unsignedLong"))
        {   *type = SOAP_TYPE_xsd__unsignedLong;
            return soap_in_xsd__unsignedLong(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "xsd:unsignedInt"))
        {   *type = SOAP_TYPE_xsd__unsignedInt;
            return soap_in_xsd__unsignedInt(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "xsd:unsignedByte"))
        {   *type = SOAP_TYPE_xsd__unsignedByte_;
            return soap_in_xsd__unsignedByte_(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "xsd:string"))
        {   *type = SOAP_TYPE_xsd__string;
            return soap_in_xsd__string(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "xsd:short"))
        {   *type = SOAP_TYPE_xsd__short;
            return soap_in_xsd__short(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "xsd:long"))
        {   *type = SOAP_TYPE_xsd__long;
            return soap_in_xsd__long(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "xsd:int"))
        {   *type = SOAP_TYPE_xsd__int;
            return soap_in_xsd__int(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "xsd:float"))
        {   *type = SOAP_TYPE_xsd__float;
            return soap_in_xsd__float(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "xsd:duration"))
        {   *type = SOAP_TYPE_xsd__duration_;
            return soap_in_xsd__duration_(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "xsd:duration"))
        {   *type = SOAP_TYPE_xsd__duration;
            return soap_in_xsd__duration(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "xsd:double"))
        {   *type = SOAP_TYPE_xsd__double;
            return soap_in_xsd__double(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "xsd:decimal"))
        {   *type = SOAP_TYPE_xsd__decimal_;
            return soap_in_xsd__decimal_(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "xsd:decimal"))
        {   *type = SOAP_TYPE_xsd__decimal;
            return soap_in_xsd__decimal(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "xsd:dateTime"))
        {   *type = SOAP_TYPE_xsd__dateTime;
            return soap_in_xsd__dateTime(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "xsd:byte"))
        {   *type = SOAP_TYPE_xsd__byte_;
            return soap_in_xsd__byte_(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "xsd:boolean"))
        {   *type = SOAP_TYPE_xsd__boolean;
            return soap_in_xsd__boolean(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "xsd:base64Binary"))
        {   *type = SOAP_TYPE_xsd__base64Binary;
            return soap_in_xsd__base64Binary(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "xsd:anyURI"))
        {   *type = SOAP_TYPE_xsd__anyURI_;
            return soap_in_xsd__anyURI_(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "xsd:anyURI"))
        {   *type = SOAP_TYPE_xsd__anyURI;
            return soap_in_xsd__anyURI(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "xsd:QName"))
        {   *type = SOAP_TYPE_xsd__QName_;
            return soap_in_xsd__QName_(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "xsd:IDREF"))
        {   *type = SOAP_TYPE_xsd__IDREF_;
            return soap_in_xsd__IDREF_(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "xsd:IDREF"))
        {   *type = SOAP_TYPE_xsd__IDREF;
            return soap_in_xsd__IDREF(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "xsd:ID"))
        {   *type = SOAP_TYPE_xsd__ID_;
            return soap_in_xsd__ID_(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "xsd:ID"))
        {   *type = SOAP_TYPE_xsd__ID;
            return soap_in_xsd__ID(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "xsd:string"))
        {   *type = SOAP_TYPE_std__wstring;
            return soap_in_std__wstring(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "xsd:QName"))
        {   *type = SOAP_TYPE_xsd__QName;
            return soap_in_xsd__QName(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "xsd:string"))
        {   *type = SOAP_TYPE_std__string;
            return soap_in_std__string(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "xsd:anyType"))
        {   *type = SOAP_TYPE_xsd__anyType;
            return soap_in_xsd__anyType(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "xsd:byte"))
        {   *type = SOAP_TYPE_xsd__byte;
            return soap_in_xsd__byte(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "xsd:byte"))
        {   *type = SOAP_TYPE_byte;
            return soap_in_byte(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "xsd:short"))
        {   *type = SOAP_TYPE_short;
            return soap_in_short(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "ns3:char"))
        {   *type = SOAP_TYPE_ns3__char;
            return soap_in_ns3__char(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "xsd:int"))
        {   *type = SOAP_TYPE_int;
            return soap_in_int(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "xsd:long"))
        {   *type = SOAP_TYPE_LONG64;
            return soap_in_LONG64(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "xsd:float"))
        {   *type = SOAP_TYPE_float;
            return soap_in_float(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "xsd:double"))
        {   *type = SOAP_TYPE_double;
            return soap_in_double(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "xsd:unsignedByte"))
        {   *type = SOAP_TYPE_xsd__unsignedByte;
            return soap_in_xsd__unsignedByte(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "xsd:unsignedByte"))
        {   *type = SOAP_TYPE_unsignedByte;
            return soap_in_unsignedByte(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "xsd:unsignedShort"))
        {   *type = SOAP_TYPE_unsignedShort;
            return soap_in_unsignedShort(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "xsd:unsignedInt"))
        {   *type = SOAP_TYPE_unsignedInt;
            return soap_in_unsignedInt(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "xsd:unsignedLong"))
        {   *type = SOAP_TYPE_unsignedLONG64;
            return soap_in_unsignedLONG64(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "xsd:dateTime"))
        {   *type = SOAP_TYPE_time;
            return soap_in_time(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "ns4:HaveSolutionResponse.SolutionType"))
        {   *type = SOAP_TYPE_ns4__HaveSolutionResponse_SolutionType;
            return soap_in_ns4__HaveSolutionResponse_SolutionType(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "ns4:ClientLib.ClientType"))
        {   *type = SOAP_TYPE_ns4__ClientLib_ClientType;
            return soap_in_ns4__ClientLib_ClientType(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "ns4:ClientLib.Architecture"))
        {   *type = SOAP_TYPE_ns4__ClientLib_Architecture;
            return soap_in_ns4__ClientLib_Architecture(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "xsd:boolean"))
        {   *type = SOAP_TYPE_bool;
            return soap_in_bool(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "xsd:QName"))
        {   char **s;
            *type = SOAP_TYPE__QName;
            s = soap_in__QName(soap, NULL, NULL, NULL);
            return s ? *s : NULL;
        }
        if (!soap_match_tag(soap, t, "xsd:string"))
        {   char **s;
            *type = SOAP_TYPE_string;
            s = soap_in_string(soap, NULL, NULL, NULL);
            return s ? *s : NULL;
        }
        t = soap->tag;
        if (!soap_match_tag(soap, t, "ns1:UploadSymbolResponse"))
        {   *type = SOAP_TYPE__ns1__UploadSymbolResponse;
            return soap_in__ns1__UploadSymbolResponse(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "ns1:UploadSymbol"))
        {   *type = SOAP_TYPE__ns1__UploadSymbol;
            return soap_in__ns1__UploadSymbol(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "ns1:RejectedToSendAdditionalInfoResponse"))
        {   *type = SOAP_TYPE__ns1__RejectedToSendAdditionalInfoResponse;
            return soap_in__ns1__RejectedToSendAdditionalInfoResponse(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "ns1:RejectedToSendAdditionalInfo"))
        {   *type = SOAP_TYPE__ns1__RejectedToSendAdditionalInfo;
            return soap_in__ns1__RejectedToSendAdditionalInfo(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "ns1:UploadAdditionalInfoResponse"))
        {   *type = SOAP_TYPE__ns1__UploadAdditionalInfoResponse;
            return soap_in__ns1__UploadAdditionalInfoResponse(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "ns1:UploadAdditionalInfo"))
        {   *type = SOAP_TYPE__ns1__UploadAdditionalInfo;
            return soap_in__ns1__UploadAdditionalInfo(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "ns1:UploadFullDumpResponse"))
        {   *type = SOAP_TYPE__ns1__UploadFullDumpResponse;
            return soap_in__ns1__UploadFullDumpResponse(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "ns1:UploadFullDump"))
        {   *type = SOAP_TYPE__ns1__UploadFullDump;
            return soap_in__ns1__UploadFullDump(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "ns1:UploadMiniDumpResponse"))
        {   *type = SOAP_TYPE__ns1__UploadMiniDumpResponse;
            return soap_in__ns1__UploadMiniDumpResponse(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "ns1:UploadMiniDump"))
        {   *type = SOAP_TYPE__ns1__UploadMiniDump;
            return soap_in__ns1__UploadMiniDump(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "ns1:HelloResponse"))
        {   *type = SOAP_TYPE__ns1__HelloResponse;
            return soap_in__ns1__HelloResponse(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "ns1:Hello"))
        {   *type = SOAP_TYPE__ns1__Hello;
            return soap_in__ns1__Hello(soap, NULL, NULL, NULL);
        }
        if (!soap_match_tag(soap, t, "xop:Include"))
        {   *type = SOAP_TYPE__xop__Include;
            return soap_in__xop__Include(soap, NULL, NULL, NULL);
        }
#ifndef WITH_NOIDREF
    }
#endif
    }
    soap->error = SOAP_TAG_MISMATCH;
    return NULL;
}

#ifdef __cplusplus
}
#endif

SOAP_FMAC3 int SOAP_FMAC4 soap_ignore_element(struct soap *soap)
{
    if (!soap_peek_element(soap))
    {   int t;
        DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Unexpected element '%s' in input (level=%u, %d)\n", soap->tag, soap->level, soap->body));
        if (soap->mustUnderstand && !soap->other)
            return soap->error = SOAP_MUSTUNDERSTAND;
        if (((soap->mode & SOAP_XML_STRICT) && soap->part != SOAP_IN_HEADER) || !soap_match_tag(soap, soap->tag, "SOAP-ENV:"))
        {   DBGLOG(TEST, SOAP_MESSAGE(fdebug, "REJECTING element '%s'\n", soap->tag));
            return soap->error = SOAP_TAG_MISMATCH;
        }
        if (!*soap->id || !soap_getelement(soap, &t))
        {   soap->peeked = 0;
            if (soap->fignore)
                soap->error = soap->fignore(soap, soap->tag);
            else
                soap->error = SOAP_OK;
            DBGLOG(TEST, if (!soap->error) SOAP_MESSAGE(fdebug, "IGNORING element '%s'\n", soap->tag));
            if (!soap->error && soap->body)
            {   soap->level++;
                while (!soap_ignore_element(soap))
                    ;
                if (soap->error == SOAP_NO_TAG)
                    soap->error = soap_element_end_in(soap, NULL);
            }
        }
    }
    return soap->error;
}

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_putindependent(struct soap *soap)
{
    int i;
    struct soap_plist *pp;
    if (soap->version == 1 && soap->encodingStyle && !(soap->mode & (SOAP_XML_TREE | SOAP_XML_GRAPH)))
        for (i = 0; i < SOAP_PTRHASH; i++)
            for (pp = soap->pht[i]; pp; pp = pp->next)
                if (pp->mark1 == 2 || pp->mark2 == 2)
                    if (soap_putelement(soap, pp->ptr, "id", pp->id, pp->type))
                        return soap->error;
    return SOAP_OK;
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
SOAP_FMAC3 int SOAP_FMAC4 soap_putelement(struct soap *soap, const void *ptr, const char *tag, int id, int type)
{   (void)tag;
    switch (type)
    {
    case SOAP_TYPE_xsd__byte:
        return soap_out_xsd__byte(soap, tag, id, (const char *)ptr, "xsd:byte");
    case SOAP_TYPE_byte:
        return soap_out_byte(soap, tag, id, (const char *)ptr, "xsd:byte");
    case SOAP_TYPE_short:
        return soap_out_short(soap, tag, id, (const short *)ptr, "xsd:short");
    case SOAP_TYPE_ns3__char:
        return soap_out_ns3__char(soap, tag, id, (const int *)ptr, "ns3:char");
    case SOAP_TYPE_int:
        return soap_out_int(soap, tag, id, (const int *)ptr, "xsd:int");
    case SOAP_TYPE_LONG64:
        return soap_out_LONG64(soap, tag, id, (const LONG64 *)ptr, "xsd:long");
    case SOAP_TYPE_float:
        return soap_out_float(soap, tag, id, (const float *)ptr, "xsd:float");
    case SOAP_TYPE_double:
        return soap_out_double(soap, tag, id, (const double *)ptr, "xsd:double");
    case SOAP_TYPE_xsd__unsignedByte:
        return soap_out_xsd__unsignedByte(soap, tag, id, (const unsigned char *)ptr, "xsd:unsignedByte");
    case SOAP_TYPE_unsignedByte:
        return soap_out_unsignedByte(soap, tag, id, (const unsigned char *)ptr, "xsd:unsignedByte");
    case SOAP_TYPE_unsignedShort:
        return soap_out_unsignedShort(soap, tag, id, (const unsigned short *)ptr, "xsd:unsignedShort");
    case SOAP_TYPE_unsignedInt:
        return soap_out_unsignedInt(soap, tag, id, (const unsigned int *)ptr, "xsd:unsignedInt");
    case SOAP_TYPE_unsignedLONG64:
        return soap_out_unsignedLONG64(soap, tag, id, (const ULONG64 *)ptr, "xsd:unsignedLong");
    case SOAP_TYPE_time:
        return soap_out_time(soap, tag, id, (const time_t *)ptr, "xsd:dateTime");
    case SOAP_TYPE_ns4__HaveSolutionResponse_SolutionType:
        return soap_out_ns4__HaveSolutionResponse_SolutionType(soap, tag, id, (const enum ns4__HaveSolutionResponse_SolutionType *)ptr, "ns4:HaveSolutionResponse.SolutionType");
    case SOAP_TYPE_ns4__ClientLib_ClientType:
        return soap_out_ns4__ClientLib_ClientType(soap, tag, id, (const enum ns4__ClientLib_ClientType *)ptr, "ns4:ClientLib.ClientType");
    case SOAP_TYPE_ns4__ClientLib_Architecture:
        return soap_out_ns4__ClientLib_Architecture(soap, tag, id, (const enum ns4__ClientLib_Architecture *)ptr, "ns4:ClientLib.Architecture");
    case SOAP_TYPE_bool:
        return soap_out_bool(soap, tag, id, (const bool *)ptr, "xsd:boolean");
    case SOAP_TYPE_ns4__HaveSolutionResponse_SolutionType_:
        return ((ns4__HaveSolutionResponse_SolutionType_ *)ptr)->soap_out(soap, tag, id, "ns4:HaveSolutionResponse.SolutionType");
    case SOAP_TYPE_ns4__ClientLib_ClientType_:
        return ((ns4__ClientLib_ClientType_ *)ptr)->soap_out(soap, tag, id, "ns4:ClientLib.ClientType");
    case SOAP_TYPE_ns4__ClientLib_Architecture_:
        return ((ns4__ClientLib_Architecture_ *)ptr)->soap_out(soap, tag, id, "ns4:ClientLib.Architecture");
    case SOAP_TYPE_ns3__guid__:
        return ((ns3__guid__ *)ptr)->soap_out(soap, tag, id, "ns3:guid");
    case SOAP_TYPE_ns3__guid:
        return soap_out_ns3__guid(soap, tag, id, (const std::wstring *)ptr, "ns3:guid");
    case SOAP_TYPE_ns3__duration__:
        return ((ns3__duration__ *)ptr)->soap_out(soap, tag, id, "ns3:duration");
    case SOAP_TYPE_ns3__duration:
        return soap_out_ns3__duration(soap, tag, id, (const std::wstring *)ptr, "ns3:duration");
    case SOAP_TYPE_ns3__char__:
        return ((ns3__char__ *)ptr)->soap_out(soap, tag, id, "ns3:char");
    case SOAP_TYPE_ns5__ArrayOfstring:
        return ((ns5__ArrayOfstring *)ptr)->soap_out(soap, tag, id, "ns5:ArrayOfstring");
    case SOAP_TYPE__ns1__UploadSymbolResponse:
        return ((_ns1__UploadSymbolResponse *)ptr)->soap_out(soap, "ns1:UploadSymbolResponse", id, NULL);
    case SOAP_TYPE__ns1__UploadSymbol:
        return ((_ns1__UploadSymbol *)ptr)->soap_out(soap, "ns1:UploadSymbol", id, NULL);
    case SOAP_TYPE__ns1__RejectedToSendAdditionalInfoResponse:
        return ((_ns1__RejectedToSendAdditionalInfoResponse *)ptr)->soap_out(soap, "ns1:RejectedToSendAdditionalInfoResponse", id, NULL);
    case SOAP_TYPE__ns1__RejectedToSendAdditionalInfo:
        return ((_ns1__RejectedToSendAdditionalInfo *)ptr)->soap_out(soap, "ns1:RejectedToSendAdditionalInfo", id, NULL);
    case SOAP_TYPE__ns1__UploadAdditionalInfoResponse:
        return ((_ns1__UploadAdditionalInfoResponse *)ptr)->soap_out(soap, "ns1:UploadAdditionalInfoResponse", id, NULL);
    case SOAP_TYPE__ns1__UploadAdditionalInfo:
        return ((_ns1__UploadAdditionalInfo *)ptr)->soap_out(soap, "ns1:UploadAdditionalInfo", id, NULL);
    case SOAP_TYPE__ns1__UploadFullDumpResponse:
        return ((_ns1__UploadFullDumpResponse *)ptr)->soap_out(soap, "ns1:UploadFullDumpResponse", id, NULL);
    case SOAP_TYPE__ns1__UploadFullDump:
        return ((_ns1__UploadFullDump *)ptr)->soap_out(soap, "ns1:UploadFullDump", id, NULL);
    case SOAP_TYPE__ns1__UploadMiniDumpResponse:
        return ((_ns1__UploadMiniDumpResponse *)ptr)->soap_out(soap, "ns1:UploadMiniDumpResponse", id, NULL);
    case SOAP_TYPE__ns1__UploadMiniDump:
        return ((_ns1__UploadMiniDump *)ptr)->soap_out(soap, "ns1:UploadMiniDump", id, NULL);
    case SOAP_TYPE__ns1__HelloResponse:
        return ((_ns1__HelloResponse *)ptr)->soap_out(soap, "ns1:HelloResponse", id, NULL);
    case SOAP_TYPE__ns1__Hello:
        return ((_ns1__Hello *)ptr)->soap_out(soap, "ns1:Hello", id, NULL);
    case SOAP_TYPE_ns1__NeedMoreInfoResponse:
        return ((ns1__NeedMoreInfoResponse *)ptr)->soap_out(soap, tag, id, "ns1:NeedMoreInfoResponse");
    case SOAP_TYPE_ns1__NeedFullDumpResponse:
        return ((ns1__NeedFullDumpResponse *)ptr)->soap_out(soap, tag, id, "ns1:NeedFullDumpResponse");
    case SOAP_TYPE_ns1__NeedMiniDumpResponse:
        return ((ns1__NeedMiniDumpResponse *)ptr)->soap_out(soap, tag, id, "ns1:NeedMiniDumpResponse");
    case SOAP_TYPE_ns1__NeedSymbolsThenMiniDumpResponse:
        return ((ns1__NeedSymbolsThenMiniDumpResponse *)ptr)->soap_out(soap, tag, id, "ns1:NeedSymbolsThenMiniDumpResponse");
    case SOAP_TYPE_ns1__HaveSolutionResponse:
        return ((ns1__HaveSolutionResponse *)ptr)->soap_out(soap, tag, id, "ns1:HaveSolutionResponse");
    case SOAP_TYPE_ns1__ErrorResponse:
        return ((ns1__ErrorResponse *)ptr)->soap_out(soap, tag, id, "ns1:ErrorResponse");
    case SOAP_TYPE_ns1__StopResponse:
        return ((ns1__StopResponse *)ptr)->soap_out(soap, tag, id, "ns1:StopResponse");
    case SOAP_TYPE_ns1__Response:
        return ((ns1__Response *)ptr)->soap_out(soap, tag, id, "ns1:Response");
    case SOAP_TYPE_ns1__Pdb70File:
        return ((ns1__Pdb70File *)ptr)->soap_out(soap, tag, id, "ns1:Pdb70File");
    case SOAP_TYPE_ns1__ModuleSymbolInfo:
        return ((ns1__ModuleSymbolInfo *)ptr)->soap_out(soap, tag, id, "ns1:ModuleSymbolInfo");
    case SOAP_TYPE_ns1__ArrayOfModuleSymbolInfo:
        return ((ns1__ArrayOfModuleSymbolInfo *)ptr)->soap_out(soap, tag, id, "ns1:ArrayOfModuleSymbolInfo");
    case SOAP_TYPE_ns1__DumpAdditionalInfo:
        return ((ns1__DumpAdditionalInfo *)ptr)->soap_out(soap, tag, id, "ns1:DumpAdditionalInfo");
    case SOAP_TYPE_ns1__AppAdditionalInfo:
        return ((ns1__AppAdditionalInfo *)ptr)->soap_out(soap, tag, id, "ns1:AppAdditionalInfo");
    case SOAP_TYPE_ns1__Application:
        return ((ns1__Application *)ptr)->soap_out(soap, tag, id, "ns1:Application");
    case SOAP_TYPE_ns1__ClientLib:
        return ((ns1__ClientLib *)ptr)->soap_out(soap, tag, id, "ns1:ClientLib");
    case SOAP_TYPE_xsd__unsignedShort:
        return ((xsd__unsignedShort *)ptr)->soap_out(soap, tag, id, "xsd:unsignedShort");
    case SOAP_TYPE_xsd__unsignedLong:
        return ((xsd__unsignedLong *)ptr)->soap_out(soap, tag, id, "xsd:unsignedLong");
    case SOAP_TYPE_xsd__unsignedInt:
        return ((xsd__unsignedInt *)ptr)->soap_out(soap, tag, id, "xsd:unsignedInt");
    case SOAP_TYPE_xsd__unsignedByte_:
        return ((xsd__unsignedByte_ *)ptr)->soap_out(soap, tag, id, "xsd:unsignedByte");
    case SOAP_TYPE_xsd__string:
        return ((xsd__string *)ptr)->soap_out(soap, tag, id, "xsd:string");
    case SOAP_TYPE_xsd__short:
        return ((xsd__short *)ptr)->soap_out(soap, tag, id, "xsd:short");
    case SOAP_TYPE_xsd__long:
        return ((xsd__long *)ptr)->soap_out(soap, tag, id, "xsd:long");
    case SOAP_TYPE_xsd__int:
        return ((xsd__int *)ptr)->soap_out(soap, tag, id, "xsd:int");
    case SOAP_TYPE_xsd__float:
        return ((xsd__float *)ptr)->soap_out(soap, tag, id, "xsd:float");
    case SOAP_TYPE_xsd__duration_:
        return ((xsd__duration_ *)ptr)->soap_out(soap, tag, id, "xsd:duration");
    case SOAP_TYPE_xsd__duration:
        return soap_out_xsd__duration(soap, tag, id, (const std::wstring *)ptr, "xsd:duration");
    case SOAP_TYPE_xsd__double:
        return ((xsd__double *)ptr)->soap_out(soap, tag, id, "xsd:double");
    case SOAP_TYPE_xsd__decimal_:
        return ((xsd__decimal_ *)ptr)->soap_out(soap, tag, id, "xsd:decimal");
    case SOAP_TYPE_xsd__decimal:
        return soap_out_xsd__decimal(soap, tag, id, (const std::wstring *)ptr, "xsd:decimal");
    case SOAP_TYPE_xsd__dateTime:
        return ((xsd__dateTime *)ptr)->soap_out(soap, tag, id, "xsd:dateTime");
    case SOAP_TYPE_xsd__byte_:
        return ((xsd__byte_ *)ptr)->soap_out(soap, tag, id, "xsd:byte");
    case SOAP_TYPE_xsd__boolean:
        return ((xsd__boolean *)ptr)->soap_out(soap, tag, id, "xsd:boolean");
    case SOAP_TYPE_xsd__base64Binary:
        return ((xsd__base64Binary *)ptr)->soap_out(soap, tag, id, "xsd:base64Binary");
    case SOAP_TYPE_xsd__anyURI_:
        return ((xsd__anyURI_ *)ptr)->soap_out(soap, tag, id, "xsd:anyURI");
    case SOAP_TYPE_xsd__anyURI:
        return soap_out_xsd__anyURI(soap, tag, id, (const std::wstring *)ptr, "xsd:anyURI");
    case SOAP_TYPE_xsd__QName_:
        return ((xsd__QName_ *)ptr)->soap_out(soap, tag, id, "xsd:QName");
    case SOAP_TYPE_xsd__IDREF_:
        return ((xsd__IDREF_ *)ptr)->soap_out(soap, tag, id, "xsd:IDREF");
    case SOAP_TYPE_xsd__IDREF:
        return soap_out_xsd__IDREF(soap, tag, id, (const std::wstring *)ptr, "xsd:IDREF");
    case SOAP_TYPE_xsd__ID_:
        return ((xsd__ID_ *)ptr)->soap_out(soap, tag, id, "xsd:ID");
    case SOAP_TYPE_xsd__ID:
        return soap_out_xsd__ID(soap, tag, id, (const std::wstring *)ptr, "xsd:ID");
    case SOAP_TYPE_std__wstring:
        return soap_out_std__wstring(soap, tag, id, (const std::wstring *)ptr, "xsd:string");
    case SOAP_TYPE_xsd__QName:
        return soap_out_xsd__QName(soap, tag, id, (const std::string *)ptr, "xsd:QName");
    case SOAP_TYPE_std__string:
        return soap_out_std__string(soap, tag, id, (const std::string *)ptr, "xsd:string");
    case SOAP_TYPE_xsd__anyType:
        return ((xsd__anyType *)ptr)->soap_out(soap, tag, id, "xsd:anyType");
    case SOAP_TYPE__xop__Include:
        return soap_out__xop__Include(soap, "xop:Include", id, (const struct _xop__Include *)ptr, NULL);
    case SOAP_TYPE_PointerTo_ns1__UploadSymbolResponse:
        return soap_out_PointerTo_ns1__UploadSymbolResponse(soap, tag, id, (_ns1__UploadSymbolResponse *const*)ptr, "ns1:UploadSymbolResponse");
    case SOAP_TYPE_PointerTo_ns1__UploadSymbol:
        return soap_out_PointerTo_ns1__UploadSymbol(soap, tag, id, (_ns1__UploadSymbol *const*)ptr, "ns1:UploadSymbol");
    case SOAP_TYPE_PointerTo_ns1__RejectedToSendAdditionalInfoResponse:
        return soap_out_PointerTo_ns1__RejectedToSendAdditionalInfoResponse(soap, tag, id, (_ns1__RejectedToSendAdditionalInfoResponse *const*)ptr, "ns1:RejectedToSendAdditionalInfoResponse");
    case SOAP_TYPE_PointerTo_ns1__RejectedToSendAdditionalInfo:
        return soap_out_PointerTo_ns1__RejectedToSendAdditionalInfo(soap, tag, id, (_ns1__RejectedToSendAdditionalInfo *const*)ptr, "ns1:RejectedToSendAdditionalInfo");
    case SOAP_TYPE_PointerTo_ns1__UploadAdditionalInfoResponse:
        return soap_out_PointerTo_ns1__UploadAdditionalInfoResponse(soap, tag, id, (_ns1__UploadAdditionalInfoResponse *const*)ptr, "ns1:UploadAdditionalInfoResponse");
    case SOAP_TYPE_PointerTo_ns1__UploadAdditionalInfo:
        return soap_out_PointerTo_ns1__UploadAdditionalInfo(soap, tag, id, (_ns1__UploadAdditionalInfo *const*)ptr, "ns1:UploadAdditionalInfo");
    case SOAP_TYPE_PointerTo_ns1__UploadFullDumpResponse:
        return soap_out_PointerTo_ns1__UploadFullDumpResponse(soap, tag, id, (_ns1__UploadFullDumpResponse *const*)ptr, "ns1:UploadFullDumpResponse");
    case SOAP_TYPE_PointerTo_ns1__UploadFullDump:
        return soap_out_PointerTo_ns1__UploadFullDump(soap, tag, id, (_ns1__UploadFullDump *const*)ptr, "ns1:UploadFullDump");
    case SOAP_TYPE_PointerTo_ns1__UploadMiniDumpResponse:
        return soap_out_PointerTo_ns1__UploadMiniDumpResponse(soap, tag, id, (_ns1__UploadMiniDumpResponse *const*)ptr, "ns1:UploadMiniDumpResponse");
    case SOAP_TYPE_PointerTo_ns1__UploadMiniDump:
        return soap_out_PointerTo_ns1__UploadMiniDump(soap, tag, id, (_ns1__UploadMiniDump *const*)ptr, "ns1:UploadMiniDump");
    case SOAP_TYPE_PointerTo_ns1__HelloResponse:
        return soap_out_PointerTo_ns1__HelloResponse(soap, tag, id, (_ns1__HelloResponse *const*)ptr, "ns1:HelloResponse");
    case SOAP_TYPE_PointerTo_ns1__Hello:
        return soap_out_PointerTo_ns1__Hello(soap, tag, id, (_ns1__Hello *const*)ptr, "ns1:Hello");
    case SOAP_TYPE_PointerTons5__ArrayOfstring:
        return soap_out_PointerTons5__ArrayOfstring(soap, tag, id, (ns5__ArrayOfstring *const*)ptr, "ns5:ArrayOfstring");
    case SOAP_TYPE_PointerTobool:
        return soap_out_PointerTobool(soap, tag, id, (bool *const*)ptr, "xsd:boolean");
    case SOAP_TYPE_PointerTons1__Response:
        return soap_out_PointerTons1__Response(soap, tag, id, (ns1__Response *const*)ptr, "ns1:Response");
    case SOAP_TYPE_PointerTons1__ArrayOfModuleSymbolInfo:
        return soap_out_PointerTons1__ArrayOfModuleSymbolInfo(soap, tag, id, (ns1__ArrayOfModuleSymbolInfo *const*)ptr, "ns1:ArrayOfModuleSymbolInfo");
    case SOAP_TYPE_PointerTons1__DumpAdditionalInfo:
        return soap_out_PointerTons1__DumpAdditionalInfo(soap, tag, id, (ns1__DumpAdditionalInfo *const*)ptr, "ns1:DumpAdditionalInfo");
    case SOAP_TYPE_PointerTons1__AppAdditionalInfo:
        return soap_out_PointerTons1__AppAdditionalInfo(soap, tag, id, (ns1__AppAdditionalInfo *const*)ptr, "ns1:AppAdditionalInfo");
    case SOAP_TYPE_PointerTons1__Application:
        return soap_out_PointerTons1__Application(soap, tag, id, (ns1__Application *const*)ptr, "ns1:Application");
    case SOAP_TYPE_PointerTons1__ClientLib:
        return soap_out_PointerTons1__ClientLib(soap, tag, id, (ns1__ClientLib *const*)ptr, "ns1:ClientLib");
    case SOAP_TYPE_PointerToint:
        return soap_out_PointerToint(soap, tag, id, (int *const*)ptr, "xsd:int");
    case SOAP_TYPE_PointerTo_xop__Include:
        return soap_out_PointerTo_xop__Include(soap, tag, id, (struct _xop__Include *const*)ptr, "xop:Include");
    case SOAP_TYPE_PointerTons1__Pdb70File:
        return soap_out_PointerTons1__Pdb70File(soap, tag, id, (ns1__Pdb70File *const*)ptr, "ns1:Pdb70File");
    case SOAP_TYPE_PointerTons1__ModuleSymbolInfo:
        return soap_out_PointerTons1__ModuleSymbolInfo(soap, tag, id, (ns1__ModuleSymbolInfo *const*)ptr, "ns1:ModuleSymbolInfo");
    case SOAP_TYPE_PointerTostd__wstring:
        return soap_out_PointerTostd__wstring(soap, tag, id, (std::wstring *const*)ptr, "xsd:string");
    case SOAP_TYPE_PointerTounsignedByte:
        return soap_out_PointerTounsignedByte(soap, tag, id, (unsigned char *const*)ptr, "xsd:unsignedByte");
    case SOAP_TYPE__QName:
        return soap_out_string(soap, tag, id, (char*const*)&ptr, "xsd:QName");
    case SOAP_TYPE_string:
        return soap_out_string(soap, tag, id, (char*const*)&ptr, "xsd:string");
    }
    return SOAP_OK;
}

#ifdef __cplusplus
}
#endif

#ifndef WITH_NOIDREF

#ifdef __cplusplus
extern "C" {
#endif
SOAP_FMAC3 void SOAP_FMAC4 soap_markelement(struct soap *soap, const void *ptr, int type)
{
    (void)soap; (void)ptr; (void)type; /* appease -Wall -Werror */
    switch (type)
    {
    case SOAP_TYPE_ns4__HaveSolutionResponse_SolutionType_:
        ((ns4__HaveSolutionResponse_SolutionType_ *)ptr)->soap_serialize(soap);
        break;
    case SOAP_TYPE_ns4__ClientLib_ClientType_:
        ((ns4__ClientLib_ClientType_ *)ptr)->soap_serialize(soap);
        break;
    case SOAP_TYPE_ns4__ClientLib_Architecture_:
        ((ns4__ClientLib_Architecture_ *)ptr)->soap_serialize(soap);
        break;
    case SOAP_TYPE_ns3__guid__:
        ((ns3__guid__ *)ptr)->soap_serialize(soap);
        break;
    case SOAP_TYPE_ns3__guid:
        soap_serialize_ns3__guid(soap, (const std::wstring *)ptr);
        break;
    case SOAP_TYPE_ns3__duration__:
        ((ns3__duration__ *)ptr)->soap_serialize(soap);
        break;
    case SOAP_TYPE_ns3__duration:
        soap_serialize_ns3__duration(soap, (const std::wstring *)ptr);
        break;
    case SOAP_TYPE_ns3__char__:
        ((ns3__char__ *)ptr)->soap_serialize(soap);
        break;
    case SOAP_TYPE_ns5__ArrayOfstring:
        ((ns5__ArrayOfstring *)ptr)->soap_serialize(soap);
        break;
    case SOAP_TYPE__ns1__UploadSymbolResponse:
        ((_ns1__UploadSymbolResponse *)ptr)->soap_serialize(soap);
        break;
    case SOAP_TYPE__ns1__UploadSymbol:
        ((_ns1__UploadSymbol *)ptr)->soap_serialize(soap);
        break;
    case SOAP_TYPE__ns1__RejectedToSendAdditionalInfoResponse:
        ((_ns1__RejectedToSendAdditionalInfoResponse *)ptr)->soap_serialize(soap);
        break;
    case SOAP_TYPE__ns1__RejectedToSendAdditionalInfo:
        ((_ns1__RejectedToSendAdditionalInfo *)ptr)->soap_serialize(soap);
        break;
    case SOAP_TYPE__ns1__UploadAdditionalInfoResponse:
        ((_ns1__UploadAdditionalInfoResponse *)ptr)->soap_serialize(soap);
        break;
    case SOAP_TYPE__ns1__UploadAdditionalInfo:
        ((_ns1__UploadAdditionalInfo *)ptr)->soap_serialize(soap);
        break;
    case SOAP_TYPE__ns1__UploadFullDumpResponse:
        ((_ns1__UploadFullDumpResponse *)ptr)->soap_serialize(soap);
        break;
    case SOAP_TYPE__ns1__UploadFullDump:
        ((_ns1__UploadFullDump *)ptr)->soap_serialize(soap);
        break;
    case SOAP_TYPE__ns1__UploadMiniDumpResponse:
        ((_ns1__UploadMiniDumpResponse *)ptr)->soap_serialize(soap);
        break;
    case SOAP_TYPE__ns1__UploadMiniDump:
        ((_ns1__UploadMiniDump *)ptr)->soap_serialize(soap);
        break;
    case SOAP_TYPE__ns1__HelloResponse:
        ((_ns1__HelloResponse *)ptr)->soap_serialize(soap);
        break;
    case SOAP_TYPE__ns1__Hello:
        ((_ns1__Hello *)ptr)->soap_serialize(soap);
        break;
    case SOAP_TYPE_ns1__NeedMoreInfoResponse:
        ((ns1__NeedMoreInfoResponse *)ptr)->soap_serialize(soap);
        break;
    case SOAP_TYPE_ns1__NeedFullDumpResponse:
        ((ns1__NeedFullDumpResponse *)ptr)->soap_serialize(soap);
        break;
    case SOAP_TYPE_ns1__NeedMiniDumpResponse:
        ((ns1__NeedMiniDumpResponse *)ptr)->soap_serialize(soap);
        break;
    case SOAP_TYPE_ns1__NeedSymbolsThenMiniDumpResponse:
        ((ns1__NeedSymbolsThenMiniDumpResponse *)ptr)->soap_serialize(soap);
        break;
    case SOAP_TYPE_ns1__HaveSolutionResponse:
        ((ns1__HaveSolutionResponse *)ptr)->soap_serialize(soap);
        break;
    case SOAP_TYPE_ns1__ErrorResponse:
        ((ns1__ErrorResponse *)ptr)->soap_serialize(soap);
        break;
    case SOAP_TYPE_ns1__StopResponse:
        ((ns1__StopResponse *)ptr)->soap_serialize(soap);
        break;
    case SOAP_TYPE_ns1__Response:
        ((ns1__Response *)ptr)->soap_serialize(soap);
        break;
    case SOAP_TYPE_ns1__Pdb70File:
        ((ns1__Pdb70File *)ptr)->soap_serialize(soap);
        break;
    case SOAP_TYPE_ns1__ModuleSymbolInfo:
        ((ns1__ModuleSymbolInfo *)ptr)->soap_serialize(soap);
        break;
    case SOAP_TYPE_ns1__ArrayOfModuleSymbolInfo:
        ((ns1__ArrayOfModuleSymbolInfo *)ptr)->soap_serialize(soap);
        break;
    case SOAP_TYPE_ns1__DumpAdditionalInfo:
        ((ns1__DumpAdditionalInfo *)ptr)->soap_serialize(soap);
        break;
    case SOAP_TYPE_ns1__AppAdditionalInfo:
        ((ns1__AppAdditionalInfo *)ptr)->soap_serialize(soap);
        break;
    case SOAP_TYPE_ns1__Application:
        ((ns1__Application *)ptr)->soap_serialize(soap);
        break;
    case SOAP_TYPE_ns1__ClientLib:
        ((ns1__ClientLib *)ptr)->soap_serialize(soap);
        break;
    case SOAP_TYPE_xsd__unsignedShort:
        ((xsd__unsignedShort *)ptr)->soap_serialize(soap);
        break;
    case SOAP_TYPE_xsd__unsignedLong:
        ((xsd__unsignedLong *)ptr)->soap_serialize(soap);
        break;
    case SOAP_TYPE_xsd__unsignedInt:
        ((xsd__unsignedInt *)ptr)->soap_serialize(soap);
        break;
    case SOAP_TYPE_xsd__unsignedByte_:
        ((xsd__unsignedByte_ *)ptr)->soap_serialize(soap);
        break;
    case SOAP_TYPE_xsd__string:
        ((xsd__string *)ptr)->soap_serialize(soap);
        break;
    case SOAP_TYPE_xsd__short:
        ((xsd__short *)ptr)->soap_serialize(soap);
        break;
    case SOAP_TYPE_xsd__long:
        ((xsd__long *)ptr)->soap_serialize(soap);
        break;
    case SOAP_TYPE_xsd__int:
        ((xsd__int *)ptr)->soap_serialize(soap);
        break;
    case SOAP_TYPE_xsd__float:
        ((xsd__float *)ptr)->soap_serialize(soap);
        break;
    case SOAP_TYPE_xsd__duration_:
        ((xsd__duration_ *)ptr)->soap_serialize(soap);
        break;
    case SOAP_TYPE_xsd__duration:
        soap_serialize_xsd__duration(soap, (const std::wstring *)ptr);
        break;
    case SOAP_TYPE_xsd__double:
        ((xsd__double *)ptr)->soap_serialize(soap);
        break;
    case SOAP_TYPE_xsd__decimal_:
        ((xsd__decimal_ *)ptr)->soap_serialize(soap);
        break;
    case SOAP_TYPE_xsd__decimal:
        soap_serialize_xsd__decimal(soap, (const std::wstring *)ptr);
        break;
    case SOAP_TYPE_xsd__dateTime:
        ((xsd__dateTime *)ptr)->soap_serialize(soap);
        break;
    case SOAP_TYPE_xsd__byte_:
        ((xsd__byte_ *)ptr)->soap_serialize(soap);
        break;
    case SOAP_TYPE_xsd__boolean:
        ((xsd__boolean *)ptr)->soap_serialize(soap);
        break;
    case SOAP_TYPE_xsd__base64Binary:
        ((xsd__base64Binary *)ptr)->soap_serialize(soap);
        break;
    case SOAP_TYPE_xsd__anyURI_:
        ((xsd__anyURI_ *)ptr)->soap_serialize(soap);
        break;
    case SOAP_TYPE_xsd__anyURI:
        soap_serialize_xsd__anyURI(soap, (const std::wstring *)ptr);
        break;
    case SOAP_TYPE_xsd__QName_:
        ((xsd__QName_ *)ptr)->soap_serialize(soap);
        break;
    case SOAP_TYPE_xsd__IDREF_:
        ((xsd__IDREF_ *)ptr)->soap_serialize(soap);
        break;
    case SOAP_TYPE_xsd__IDREF:
        soap_serialize_xsd__IDREF(soap, (const std::wstring *)ptr);
        break;
    case SOAP_TYPE_xsd__ID_:
        ((xsd__ID_ *)ptr)->soap_serialize(soap);
        break;
    case SOAP_TYPE_xsd__ID:
        soap_serialize_xsd__ID(soap, (const std::wstring *)ptr);
        break;
    case SOAP_TYPE_std__wstring:
        soap_serialize_std__wstring(soap, (const std::wstring *)ptr);
        break;
    case SOAP_TYPE_xsd__QName:
        soap_serialize_xsd__QName(soap, (const std::string *)ptr);
        break;
    case SOAP_TYPE_std__string:
        soap_serialize_std__string(soap, (const std::string *)ptr);
        break;
    case SOAP_TYPE_xsd__anyType:
        ((xsd__anyType *)ptr)->soap_serialize(soap);
        break;
    case SOAP_TYPE___ns1__UploadSymbol:
        soap_serialize___ns1__UploadSymbol(soap, (const struct __ns1__UploadSymbol *)ptr);
        break;
    case SOAP_TYPE___ns1__RejectedToSendAdditionalInfo:
        soap_serialize___ns1__RejectedToSendAdditionalInfo(soap, (const struct __ns1__RejectedToSendAdditionalInfo *)ptr);
        break;
    case SOAP_TYPE___ns1__UploadAdditionalInfo:
        soap_serialize___ns1__UploadAdditionalInfo(soap, (const struct __ns1__UploadAdditionalInfo *)ptr);
        break;
    case SOAP_TYPE___ns1__UploadFullDump:
        soap_serialize___ns1__UploadFullDump(soap, (const struct __ns1__UploadFullDump *)ptr);
        break;
    case SOAP_TYPE___ns1__UploadMiniDump:
        soap_serialize___ns1__UploadMiniDump(soap, (const struct __ns1__UploadMiniDump *)ptr);
        break;
    case SOAP_TYPE___ns1__Hello:
        soap_serialize___ns1__Hello(soap, (const struct __ns1__Hello *)ptr);
        break;
    case SOAP_TYPE__xop__Include:
        soap_serialize__xop__Include(soap, (const struct _xop__Include *)ptr);
        break;
    case SOAP_TYPE_PointerTo_ns1__UploadSymbolResponse:
        soap_serialize_PointerTo_ns1__UploadSymbolResponse(soap, (_ns1__UploadSymbolResponse *const*)ptr);
        break;
    case SOAP_TYPE_PointerTo_ns1__UploadSymbol:
        soap_serialize_PointerTo_ns1__UploadSymbol(soap, (_ns1__UploadSymbol *const*)ptr);
        break;
    case SOAP_TYPE_PointerTo_ns1__RejectedToSendAdditionalInfoResponse:
        soap_serialize_PointerTo_ns1__RejectedToSendAdditionalInfoResponse(soap, (_ns1__RejectedToSendAdditionalInfoResponse *const*)ptr);
        break;
    case SOAP_TYPE_PointerTo_ns1__RejectedToSendAdditionalInfo:
        soap_serialize_PointerTo_ns1__RejectedToSendAdditionalInfo(soap, (_ns1__RejectedToSendAdditionalInfo *const*)ptr);
        break;
    case SOAP_TYPE_PointerTo_ns1__UploadAdditionalInfoResponse:
        soap_serialize_PointerTo_ns1__UploadAdditionalInfoResponse(soap, (_ns1__UploadAdditionalInfoResponse *const*)ptr);
        break;
    case SOAP_TYPE_PointerTo_ns1__UploadAdditionalInfo:
        soap_serialize_PointerTo_ns1__UploadAdditionalInfo(soap, (_ns1__UploadAdditionalInfo *const*)ptr);
        break;
    case SOAP_TYPE_PointerTo_ns1__UploadFullDumpResponse:
        soap_serialize_PointerTo_ns1__UploadFullDumpResponse(soap, (_ns1__UploadFullDumpResponse *const*)ptr);
        break;
    case SOAP_TYPE_PointerTo_ns1__UploadFullDump:
        soap_serialize_PointerTo_ns1__UploadFullDump(soap, (_ns1__UploadFullDump *const*)ptr);
        break;
    case SOAP_TYPE_PointerTo_ns1__UploadMiniDumpResponse:
        soap_serialize_PointerTo_ns1__UploadMiniDumpResponse(soap, (_ns1__UploadMiniDumpResponse *const*)ptr);
        break;
    case SOAP_TYPE_PointerTo_ns1__UploadMiniDump:
        soap_serialize_PointerTo_ns1__UploadMiniDump(soap, (_ns1__UploadMiniDump *const*)ptr);
        break;
    case SOAP_TYPE_PointerTo_ns1__HelloResponse:
        soap_serialize_PointerTo_ns1__HelloResponse(soap, (_ns1__HelloResponse *const*)ptr);
        break;
    case SOAP_TYPE_PointerTo_ns1__Hello:
        soap_serialize_PointerTo_ns1__Hello(soap, (_ns1__Hello *const*)ptr);
        break;
    case SOAP_TYPE_PointerTons5__ArrayOfstring:
        soap_serialize_PointerTons5__ArrayOfstring(soap, (ns5__ArrayOfstring *const*)ptr);
        break;
    case SOAP_TYPE_PointerTobool:
        soap_serialize_PointerTobool(soap, (bool *const*)ptr);
        break;
    case SOAP_TYPE_PointerTons1__Response:
        soap_serialize_PointerTons1__Response(soap, (ns1__Response *const*)ptr);
        break;
    case SOAP_TYPE_PointerTons1__ArrayOfModuleSymbolInfo:
        soap_serialize_PointerTons1__ArrayOfModuleSymbolInfo(soap, (ns1__ArrayOfModuleSymbolInfo *const*)ptr);
        break;
    case SOAP_TYPE_PointerTons1__DumpAdditionalInfo:
        soap_serialize_PointerTons1__DumpAdditionalInfo(soap, (ns1__DumpAdditionalInfo *const*)ptr);
        break;
    case SOAP_TYPE_PointerTons1__AppAdditionalInfo:
        soap_serialize_PointerTons1__AppAdditionalInfo(soap, (ns1__AppAdditionalInfo *const*)ptr);
        break;
    case SOAP_TYPE_PointerTons1__Application:
        soap_serialize_PointerTons1__Application(soap, (ns1__Application *const*)ptr);
        break;
    case SOAP_TYPE_PointerTons1__ClientLib:
        soap_serialize_PointerTons1__ClientLib(soap, (ns1__ClientLib *const*)ptr);
        break;
    case SOAP_TYPE_PointerToint:
        soap_serialize_PointerToint(soap, (int *const*)ptr);
        break;
    case SOAP_TYPE_PointerTo_xop__Include:
        soap_serialize_PointerTo_xop__Include(soap, (struct _xop__Include *const*)ptr);
        break;
    case SOAP_TYPE_PointerTons1__Pdb70File:
        soap_serialize_PointerTons1__Pdb70File(soap, (ns1__Pdb70File *const*)ptr);
        break;
    case SOAP_TYPE_PointerTons1__ModuleSymbolInfo:
        soap_serialize_PointerTons1__ModuleSymbolInfo(soap, (ns1__ModuleSymbolInfo *const*)ptr);
        break;
    case SOAP_TYPE_PointerTostd__wstring:
        soap_serialize_PointerTostd__wstring(soap, (std::wstring *const*)ptr);
        break;
    case SOAP_TYPE_PointerTounsignedByte:
        soap_serialize_PointerTounsignedByte(soap, (unsigned char *const*)ptr);
        break;
    case SOAP_TYPE__QName:
        soap_serialize_string(soap, (char*const*)&ptr);
        break;
    case SOAP_TYPE_string:
        soap_serialize_string(soap, (char*const*)&ptr);
        break;
    }
}

#ifdef __cplusplus
}
#endif
#endif

SOAP_FMAC3 void * SOAP_FMAC4 soap_instantiate(struct soap *soap, int t, const char *type, const char *arrayType, size_t *n)
{   (void)type;
    switch (t)
    {
    case SOAP_TYPE_xsd__anyType:
        return (void*)soap_instantiate_xsd__anyType(soap, -1, type, arrayType, n);
    case SOAP_TYPE_std__string:
        return (void*)soap_instantiate_std__string(soap, -1, type, arrayType, n);
    case SOAP_TYPE__xop__Include:
        return (void*)soap_instantiate__xop__Include(soap, -1, type, arrayType, n);
    case SOAP_TYPE_std__wstring:
        return (void*)soap_instantiate_std__wstring(soap, -1, type, arrayType, n);
    case SOAP_TYPE_xsd__ID_:
        return (void*)soap_instantiate_xsd__ID_(soap, -1, type, arrayType, n);
    case SOAP_TYPE_xsd__IDREF_:
        return (void*)soap_instantiate_xsd__IDREF_(soap, -1, type, arrayType, n);
    case SOAP_TYPE_xsd__QName_:
        return (void*)soap_instantiate_xsd__QName_(soap, -1, type, arrayType, n);
    case SOAP_TYPE_xsd__anyURI_:
        return (void*)soap_instantiate_xsd__anyURI_(soap, -1, type, arrayType, n);
    case SOAP_TYPE_xsd__base64Binary:
        return (void*)soap_instantiate_xsd__base64Binary(soap, -1, type, arrayType, n);
    case SOAP_TYPE_xsd__boolean:
        return (void*)soap_instantiate_xsd__boolean(soap, -1, type, arrayType, n);
    case SOAP_TYPE_xsd__byte_:
        return (void*)soap_instantiate_xsd__byte_(soap, -1, type, arrayType, n);
    case SOAP_TYPE_xsd__dateTime:
        return (void*)soap_instantiate_xsd__dateTime(soap, -1, type, arrayType, n);
    case SOAP_TYPE_xsd__decimal_:
        return (void*)soap_instantiate_xsd__decimal_(soap, -1, type, arrayType, n);
    case SOAP_TYPE_xsd__double:
        return (void*)soap_instantiate_xsd__double(soap, -1, type, arrayType, n);
    case SOAP_TYPE_xsd__duration_:
        return (void*)soap_instantiate_xsd__duration_(soap, -1, type, arrayType, n);
    case SOAP_TYPE_xsd__float:
        return (void*)soap_instantiate_xsd__float(soap, -1, type, arrayType, n);
    case SOAP_TYPE_xsd__int:
        return (void*)soap_instantiate_xsd__int(soap, -1, type, arrayType, n);
    case SOAP_TYPE_xsd__long:
        return (void*)soap_instantiate_xsd__long(soap, -1, type, arrayType, n);
    case SOAP_TYPE_xsd__short:
        return (void*)soap_instantiate_xsd__short(soap, -1, type, arrayType, n);
    case SOAP_TYPE_xsd__string:
        return (void*)soap_instantiate_xsd__string(soap, -1, type, arrayType, n);
    case SOAP_TYPE_xsd__unsignedByte_:
        return (void*)soap_instantiate_xsd__unsignedByte_(soap, -1, type, arrayType, n);
    case SOAP_TYPE_xsd__unsignedInt:
        return (void*)soap_instantiate_xsd__unsignedInt(soap, -1, type, arrayType, n);
    case SOAP_TYPE_xsd__unsignedLong:
        return (void*)soap_instantiate_xsd__unsignedLong(soap, -1, type, arrayType, n);
    case SOAP_TYPE_xsd__unsignedShort:
        return (void*)soap_instantiate_xsd__unsignedShort(soap, -1, type, arrayType, n);
    case SOAP_TYPE_ns3__char__:
        return (void*)soap_instantiate_ns3__char__(soap, -1, type, arrayType, n);
    case SOAP_TYPE_ns3__duration__:
        return (void*)soap_instantiate_ns3__duration__(soap, -1, type, arrayType, n);
    case SOAP_TYPE_ns3__guid__:
        return (void*)soap_instantiate_ns3__guid__(soap, -1, type, arrayType, n);
    case SOAP_TYPE_ns4__ClientLib_Architecture_:
        return (void*)soap_instantiate_ns4__ClientLib_Architecture_(soap, -1, type, arrayType, n);
    case SOAP_TYPE_ns4__ClientLib_ClientType_:
        return (void*)soap_instantiate_ns4__ClientLib_ClientType_(soap, -1, type, arrayType, n);
    case SOAP_TYPE_ns4__HaveSolutionResponse_SolutionType_:
        return (void*)soap_instantiate_ns4__HaveSolutionResponse_SolutionType_(soap, -1, type, arrayType, n);
    case SOAP_TYPE_ns1__ClientLib:
        return (void*)soap_instantiate_ns1__ClientLib(soap, -1, type, arrayType, n);
    case SOAP_TYPE_ns1__Application:
        return (void*)soap_instantiate_ns1__Application(soap, -1, type, arrayType, n);
    case SOAP_TYPE_ns1__AppAdditionalInfo:
        return (void*)soap_instantiate_ns1__AppAdditionalInfo(soap, -1, type, arrayType, n);
    case SOAP_TYPE_ns1__DumpAdditionalInfo:
        return (void*)soap_instantiate_ns1__DumpAdditionalInfo(soap, -1, type, arrayType, n);
    case SOAP_TYPE_ns1__ArrayOfModuleSymbolInfo:
        return (void*)soap_instantiate_ns1__ArrayOfModuleSymbolInfo(soap, -1, type, arrayType, n);
    case SOAP_TYPE_ns1__ModuleSymbolInfo:
        return (void*)soap_instantiate_ns1__ModuleSymbolInfo(soap, -1, type, arrayType, n);
    case SOAP_TYPE_ns1__Pdb70File:
        return (void*)soap_instantiate_ns1__Pdb70File(soap, -1, type, arrayType, n);
    case SOAP_TYPE_ns1__Response:
        return (void*)soap_instantiate_ns1__Response(soap, -1, type, arrayType, n);
    case SOAP_TYPE__ns1__Hello:
        return (void*)soap_instantiate__ns1__Hello(soap, -1, type, arrayType, n);
    case SOAP_TYPE__ns1__HelloResponse:
        return (void*)soap_instantiate__ns1__HelloResponse(soap, -1, type, arrayType, n);
    case SOAP_TYPE__ns1__UploadMiniDump:
        return (void*)soap_instantiate__ns1__UploadMiniDump(soap, -1, type, arrayType, n);
    case SOAP_TYPE__ns1__UploadMiniDumpResponse:
        return (void*)soap_instantiate__ns1__UploadMiniDumpResponse(soap, -1, type, arrayType, n);
    case SOAP_TYPE__ns1__UploadFullDump:
        return (void*)soap_instantiate__ns1__UploadFullDump(soap, -1, type, arrayType, n);
    case SOAP_TYPE__ns1__UploadFullDumpResponse:
        return (void*)soap_instantiate__ns1__UploadFullDumpResponse(soap, -1, type, arrayType, n);
    case SOAP_TYPE__ns1__UploadAdditionalInfo:
        return (void*)soap_instantiate__ns1__UploadAdditionalInfo(soap, -1, type, arrayType, n);
    case SOAP_TYPE__ns1__UploadAdditionalInfoResponse:
        return (void*)soap_instantiate__ns1__UploadAdditionalInfoResponse(soap, -1, type, arrayType, n);
    case SOAP_TYPE__ns1__RejectedToSendAdditionalInfo:
        return (void*)soap_instantiate__ns1__RejectedToSendAdditionalInfo(soap, -1, type, arrayType, n);
    case SOAP_TYPE__ns1__RejectedToSendAdditionalInfoResponse:
        return (void*)soap_instantiate__ns1__RejectedToSendAdditionalInfoResponse(soap, -1, type, arrayType, n);
    case SOAP_TYPE__ns1__UploadSymbol:
        return (void*)soap_instantiate__ns1__UploadSymbol(soap, -1, type, arrayType, n);
    case SOAP_TYPE__ns1__UploadSymbolResponse:
        return (void*)soap_instantiate__ns1__UploadSymbolResponse(soap, -1, type, arrayType, n);
    case SOAP_TYPE_ns5__ArrayOfstring:
        return (void*)soap_instantiate_ns5__ArrayOfstring(soap, -1, type, arrayType, n);
    case SOAP_TYPE_ns1__StopResponse:
        return (void*)soap_instantiate_ns1__StopResponse(soap, -1, type, arrayType, n);
    case SOAP_TYPE_ns1__ErrorResponse:
        return (void*)soap_instantiate_ns1__ErrorResponse(soap, -1, type, arrayType, n);
    case SOAP_TYPE_ns1__HaveSolutionResponse:
        return (void*)soap_instantiate_ns1__HaveSolutionResponse(soap, -1, type, arrayType, n);
    case SOAP_TYPE_ns1__NeedSymbolsThenMiniDumpResponse:
        return (void*)soap_instantiate_ns1__NeedSymbolsThenMiniDumpResponse(soap, -1, type, arrayType, n);
    case SOAP_TYPE_ns1__NeedMiniDumpResponse:
        return (void*)soap_instantiate_ns1__NeedMiniDumpResponse(soap, -1, type, arrayType, n);
    case SOAP_TYPE_ns1__NeedFullDumpResponse:
        return (void*)soap_instantiate_ns1__NeedFullDumpResponse(soap, -1, type, arrayType, n);
    case SOAP_TYPE_ns1__NeedMoreInfoResponse:
        return (void*)soap_instantiate_ns1__NeedMoreInfoResponse(soap, -1, type, arrayType, n);
    case SOAP_TYPE___ns1__Hello:
        return (void*)soap_instantiate___ns1__Hello(soap, -1, type, arrayType, n);
    case SOAP_TYPE___ns1__UploadMiniDump:
        return (void*)soap_instantiate___ns1__UploadMiniDump(soap, -1, type, arrayType, n);
    case SOAP_TYPE___ns1__UploadFullDump:
        return (void*)soap_instantiate___ns1__UploadFullDump(soap, -1, type, arrayType, n);
    case SOAP_TYPE___ns1__UploadAdditionalInfo:
        return (void*)soap_instantiate___ns1__UploadAdditionalInfo(soap, -1, type, arrayType, n);
    case SOAP_TYPE___ns1__RejectedToSendAdditionalInfo:
        return (void*)soap_instantiate___ns1__RejectedToSendAdditionalInfo(soap, -1, type, arrayType, n);
    case SOAP_TYPE___ns1__UploadSymbol:
        return (void*)soap_instantiate___ns1__UploadSymbol(soap, -1, type, arrayType, n);
#ifndef WITH_NOGLOBAL
    case SOAP_TYPE_SOAP_ENV__Header:
        return (void*)soap_instantiate_SOAP_ENV__Header(soap, -1, type, arrayType, n);
#endif
#ifndef WITH_NOGLOBAL
    case SOAP_TYPE_SOAP_ENV__Code:
        return (void*)soap_instantiate_SOAP_ENV__Code(soap, -1, type, arrayType, n);
#endif
#ifndef WITH_NOGLOBAL
    case SOAP_TYPE_SOAP_ENV__Detail:
        return (void*)soap_instantiate_SOAP_ENV__Detail(soap, -1, type, arrayType, n);
#endif
#ifndef WITH_NOGLOBAL
    case SOAP_TYPE_SOAP_ENV__Reason:
        return (void*)soap_instantiate_SOAP_ENV__Reason(soap, -1, type, arrayType, n);
#endif
#ifndef WITH_NOGLOBAL
    case SOAP_TYPE_SOAP_ENV__Fault:
        return (void*)soap_instantiate_SOAP_ENV__Fault(soap, -1, type, arrayType, n);
#endif
    case SOAP_TYPE_xsd__QName:
        return (void*)soap_instantiate_xsd__QName(soap, -1, type, arrayType, n);
    case SOAP_TYPE_xsd__ID:
        return (void*)soap_instantiate_xsd__ID(soap, -1, type, arrayType, n);
    case SOAP_TYPE_xsd__IDREF:
        return (void*)soap_instantiate_xsd__IDREF(soap, -1, type, arrayType, n);
    case SOAP_TYPE_xsd__anyURI:
        return (void*)soap_instantiate_xsd__anyURI(soap, -1, type, arrayType, n);
    case SOAP_TYPE_xsd__decimal:
        return (void*)soap_instantiate_xsd__decimal(soap, -1, type, arrayType, n);
    case SOAP_TYPE_xsd__duration:
        return (void*)soap_instantiate_xsd__duration(soap, -1, type, arrayType, n);
    case SOAP_TYPE_ns3__duration:
        return (void*)soap_instantiate_ns3__duration(soap, -1, type, arrayType, n);
    case SOAP_TYPE_ns3__guid:
        return (void*)soap_instantiate_ns3__guid(soap, -1, type, arrayType, n);
    case SOAP_TYPE_std__vectorTemplateOfstd__wstring:
        return (void*)soap_instantiate_std__vectorTemplateOfstd__wstring(soap, -1, type, arrayType, n);
    case SOAP_TYPE_std__vectorTemplateOfPointerTons1__ModuleSymbolInfo:
        return (void*)soap_instantiate_std__vectorTemplateOfPointerTons1__ModuleSymbolInfo(soap, -1, type, arrayType, n);
    }
    return NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_fdelete(struct soap_clist *p)
{   switch (p->type)
    {
    case SOAP_TYPE_xsd__anyType:
        if (p->size < 0)
            SOAP_DELETE((xsd__anyType*)p->ptr);
        else
            SOAP_DELETE_ARRAY((xsd__anyType*)p->ptr);
        break;
    case SOAP_TYPE_std__string:
        if (p->size < 0)
            SOAP_DELETE((std::string*)p->ptr);
        else
            SOAP_DELETE_ARRAY((std::string*)p->ptr);
        break;
    case SOAP_TYPE__xop__Include:
        if (p->size < 0)
            SOAP_DELETE((struct _xop__Include*)p->ptr);
        else
            SOAP_DELETE_ARRAY((struct _xop__Include*)p->ptr);
        break;
    case SOAP_TYPE_std__wstring:
        if (p->size < 0)
            SOAP_DELETE((std::wstring*)p->ptr);
        else
            SOAP_DELETE_ARRAY((std::wstring*)p->ptr);
        break;
    case SOAP_TYPE_xsd__ID_:
        if (p->size < 0)
            SOAP_DELETE((xsd__ID_*)p->ptr);
        else
            SOAP_DELETE_ARRAY((xsd__ID_*)p->ptr);
        break;
    case SOAP_TYPE_xsd__IDREF_:
        if (p->size < 0)
            SOAP_DELETE((xsd__IDREF_*)p->ptr);
        else
            SOAP_DELETE_ARRAY((xsd__IDREF_*)p->ptr);
        break;
    case SOAP_TYPE_xsd__QName_:
        if (p->size < 0)
            SOAP_DELETE((xsd__QName_*)p->ptr);
        else
            SOAP_DELETE_ARRAY((xsd__QName_*)p->ptr);
        break;
    case SOAP_TYPE_xsd__anyURI_:
        if (p->size < 0)
            SOAP_DELETE((xsd__anyURI_*)p->ptr);
        else
            SOAP_DELETE_ARRAY((xsd__anyURI_*)p->ptr);
        break;
    case SOAP_TYPE_xsd__base64Binary:
        if (p->size < 0)
            SOAP_DELETE((xsd__base64Binary*)p->ptr);
        else
            SOAP_DELETE_ARRAY((xsd__base64Binary*)p->ptr);
        break;
    case SOAP_TYPE_xsd__boolean:
        if (p->size < 0)
            SOAP_DELETE((xsd__boolean*)p->ptr);
        else
            SOAP_DELETE_ARRAY((xsd__boolean*)p->ptr);
        break;
    case SOAP_TYPE_xsd__byte_:
        if (p->size < 0)
            SOAP_DELETE((xsd__byte_*)p->ptr);
        else
            SOAP_DELETE_ARRAY((xsd__byte_*)p->ptr);
        break;
    case SOAP_TYPE_xsd__dateTime:
        if (p->size < 0)
            SOAP_DELETE((xsd__dateTime*)p->ptr);
        else
            SOAP_DELETE_ARRAY((xsd__dateTime*)p->ptr);
        break;
    case SOAP_TYPE_xsd__decimal_:
        if (p->size < 0)
            SOAP_DELETE((xsd__decimal_*)p->ptr);
        else
            SOAP_DELETE_ARRAY((xsd__decimal_*)p->ptr);
        break;
    case SOAP_TYPE_xsd__double:
        if (p->size < 0)
            SOAP_DELETE((xsd__double*)p->ptr);
        else
            SOAP_DELETE_ARRAY((xsd__double*)p->ptr);
        break;
    case SOAP_TYPE_xsd__duration_:
        if (p->size < 0)
            SOAP_DELETE((xsd__duration_*)p->ptr);
        else
            SOAP_DELETE_ARRAY((xsd__duration_*)p->ptr);
        break;
    case SOAP_TYPE_xsd__float:
        if (p->size < 0)
            SOAP_DELETE((xsd__float*)p->ptr);
        else
            SOAP_DELETE_ARRAY((xsd__float*)p->ptr);
        break;
    case SOAP_TYPE_xsd__int:
        if (p->size < 0)
            SOAP_DELETE((xsd__int*)p->ptr);
        else
            SOAP_DELETE_ARRAY((xsd__int*)p->ptr);
        break;
    case SOAP_TYPE_xsd__long:
        if (p->size < 0)
            SOAP_DELETE((xsd__long*)p->ptr);
        else
            SOAP_DELETE_ARRAY((xsd__long*)p->ptr);
        break;
    case SOAP_TYPE_xsd__short:
        if (p->size < 0)
            SOAP_DELETE((xsd__short*)p->ptr);
        else
            SOAP_DELETE_ARRAY((xsd__short*)p->ptr);
        break;
    case SOAP_TYPE_xsd__string:
        if (p->size < 0)
            SOAP_DELETE((xsd__string*)p->ptr);
        else
            SOAP_DELETE_ARRAY((xsd__string*)p->ptr);
        break;
    case SOAP_TYPE_xsd__unsignedByte_:
        if (p->size < 0)
            SOAP_DELETE((xsd__unsignedByte_*)p->ptr);
        else
            SOAP_DELETE_ARRAY((xsd__unsignedByte_*)p->ptr);
        break;
    case SOAP_TYPE_xsd__unsignedInt:
        if (p->size < 0)
            SOAP_DELETE((xsd__unsignedInt*)p->ptr);
        else
            SOAP_DELETE_ARRAY((xsd__unsignedInt*)p->ptr);
        break;
    case SOAP_TYPE_xsd__unsignedLong:
        if (p->size < 0)
            SOAP_DELETE((xsd__unsignedLong*)p->ptr);
        else
            SOAP_DELETE_ARRAY((xsd__unsignedLong*)p->ptr);
        break;
    case SOAP_TYPE_xsd__unsignedShort:
        if (p->size < 0)
            SOAP_DELETE((xsd__unsignedShort*)p->ptr);
        else
            SOAP_DELETE_ARRAY((xsd__unsignedShort*)p->ptr);
        break;
    case SOAP_TYPE_ns3__char__:
        if (p->size < 0)
            SOAP_DELETE((ns3__char__*)p->ptr);
        else
            SOAP_DELETE_ARRAY((ns3__char__*)p->ptr);
        break;
    case SOAP_TYPE_ns3__duration__:
        if (p->size < 0)
            SOAP_DELETE((ns3__duration__*)p->ptr);
        else
            SOAP_DELETE_ARRAY((ns3__duration__*)p->ptr);
        break;
    case SOAP_TYPE_ns3__guid__:
        if (p->size < 0)
            SOAP_DELETE((ns3__guid__*)p->ptr);
        else
            SOAP_DELETE_ARRAY((ns3__guid__*)p->ptr);
        break;
    case SOAP_TYPE_ns4__ClientLib_Architecture_:
        if (p->size < 0)
            SOAP_DELETE((ns4__ClientLib_Architecture_*)p->ptr);
        else
            SOAP_DELETE_ARRAY((ns4__ClientLib_Architecture_*)p->ptr);
        break;
    case SOAP_TYPE_ns4__ClientLib_ClientType_:
        if (p->size < 0)
            SOAP_DELETE((ns4__ClientLib_ClientType_*)p->ptr);
        else
            SOAP_DELETE_ARRAY((ns4__ClientLib_ClientType_*)p->ptr);
        break;
    case SOAP_TYPE_ns4__HaveSolutionResponse_SolutionType_:
        if (p->size < 0)
            SOAP_DELETE((ns4__HaveSolutionResponse_SolutionType_*)p->ptr);
        else
            SOAP_DELETE_ARRAY((ns4__HaveSolutionResponse_SolutionType_*)p->ptr);
        break;
    case SOAP_TYPE_ns1__ClientLib:
        if (p->size < 0)
            SOAP_DELETE((ns1__ClientLib*)p->ptr);
        else
            SOAP_DELETE_ARRAY((ns1__ClientLib*)p->ptr);
        break;
    case SOAP_TYPE_ns1__Application:
        if (p->size < 0)
            SOAP_DELETE((ns1__Application*)p->ptr);
        else
            SOAP_DELETE_ARRAY((ns1__Application*)p->ptr);
        break;
    case SOAP_TYPE_ns1__AppAdditionalInfo:
        if (p->size < 0)
            SOAP_DELETE((ns1__AppAdditionalInfo*)p->ptr);
        else
            SOAP_DELETE_ARRAY((ns1__AppAdditionalInfo*)p->ptr);
        break;
    case SOAP_TYPE_ns1__DumpAdditionalInfo:
        if (p->size < 0)
            SOAP_DELETE((ns1__DumpAdditionalInfo*)p->ptr);
        else
            SOAP_DELETE_ARRAY((ns1__DumpAdditionalInfo*)p->ptr);
        break;
    case SOAP_TYPE_ns1__ArrayOfModuleSymbolInfo:
        if (p->size < 0)
            SOAP_DELETE((ns1__ArrayOfModuleSymbolInfo*)p->ptr);
        else
            SOAP_DELETE_ARRAY((ns1__ArrayOfModuleSymbolInfo*)p->ptr);
        break;
    case SOAP_TYPE_ns1__ModuleSymbolInfo:
        if (p->size < 0)
            SOAP_DELETE((ns1__ModuleSymbolInfo*)p->ptr);
        else
            SOAP_DELETE_ARRAY((ns1__ModuleSymbolInfo*)p->ptr);
        break;
    case SOAP_TYPE_ns1__Pdb70File:
        if (p->size < 0)
            SOAP_DELETE((ns1__Pdb70File*)p->ptr);
        else
            SOAP_DELETE_ARRAY((ns1__Pdb70File*)p->ptr);
        break;
    case SOAP_TYPE_ns1__Response:
        if (p->size < 0)
            SOAP_DELETE((ns1__Response*)p->ptr);
        else
            SOAP_DELETE_ARRAY((ns1__Response*)p->ptr);
        break;
    case SOAP_TYPE__ns1__Hello:
        if (p->size < 0)
            SOAP_DELETE((_ns1__Hello*)p->ptr);
        else
            SOAP_DELETE_ARRAY((_ns1__Hello*)p->ptr);
        break;
    case SOAP_TYPE__ns1__HelloResponse:
        if (p->size < 0)
            SOAP_DELETE((_ns1__HelloResponse*)p->ptr);
        else
            SOAP_DELETE_ARRAY((_ns1__HelloResponse*)p->ptr);
        break;
    case SOAP_TYPE__ns1__UploadMiniDump:
        if (p->size < 0)
            SOAP_DELETE((_ns1__UploadMiniDump*)p->ptr);
        else
            SOAP_DELETE_ARRAY((_ns1__UploadMiniDump*)p->ptr);
        break;
    case SOAP_TYPE__ns1__UploadMiniDumpResponse:
        if (p->size < 0)
            SOAP_DELETE((_ns1__UploadMiniDumpResponse*)p->ptr);
        else
            SOAP_DELETE_ARRAY((_ns1__UploadMiniDumpResponse*)p->ptr);
        break;
    case SOAP_TYPE__ns1__UploadFullDump:
        if (p->size < 0)
            SOAP_DELETE((_ns1__UploadFullDump*)p->ptr);
        else
            SOAP_DELETE_ARRAY((_ns1__UploadFullDump*)p->ptr);
        break;
    case SOAP_TYPE__ns1__UploadFullDumpResponse:
        if (p->size < 0)
            SOAP_DELETE((_ns1__UploadFullDumpResponse*)p->ptr);
        else
            SOAP_DELETE_ARRAY((_ns1__UploadFullDumpResponse*)p->ptr);
        break;
    case SOAP_TYPE__ns1__UploadAdditionalInfo:
        if (p->size < 0)
            SOAP_DELETE((_ns1__UploadAdditionalInfo*)p->ptr);
        else
            SOAP_DELETE_ARRAY((_ns1__UploadAdditionalInfo*)p->ptr);
        break;
    case SOAP_TYPE__ns1__UploadAdditionalInfoResponse:
        if (p->size < 0)
            SOAP_DELETE((_ns1__UploadAdditionalInfoResponse*)p->ptr);
        else
            SOAP_DELETE_ARRAY((_ns1__UploadAdditionalInfoResponse*)p->ptr);
        break;
    case SOAP_TYPE__ns1__RejectedToSendAdditionalInfo:
        if (p->size < 0)
            SOAP_DELETE((_ns1__RejectedToSendAdditionalInfo*)p->ptr);
        else
            SOAP_DELETE_ARRAY((_ns1__RejectedToSendAdditionalInfo*)p->ptr);
        break;
    case SOAP_TYPE__ns1__RejectedToSendAdditionalInfoResponse:
        if (p->size < 0)
            SOAP_DELETE((_ns1__RejectedToSendAdditionalInfoResponse*)p->ptr);
        else
            SOAP_DELETE_ARRAY((_ns1__RejectedToSendAdditionalInfoResponse*)p->ptr);
        break;
    case SOAP_TYPE__ns1__UploadSymbol:
        if (p->size < 0)
            SOAP_DELETE((_ns1__UploadSymbol*)p->ptr);
        else
            SOAP_DELETE_ARRAY((_ns1__UploadSymbol*)p->ptr);
        break;
    case SOAP_TYPE__ns1__UploadSymbolResponse:
        if (p->size < 0)
            SOAP_DELETE((_ns1__UploadSymbolResponse*)p->ptr);
        else
            SOAP_DELETE_ARRAY((_ns1__UploadSymbolResponse*)p->ptr);
        break;
    case SOAP_TYPE_ns5__ArrayOfstring:
        if (p->size < 0)
            SOAP_DELETE((ns5__ArrayOfstring*)p->ptr);
        else
            SOAP_DELETE_ARRAY((ns5__ArrayOfstring*)p->ptr);
        break;
    case SOAP_TYPE_ns1__StopResponse:
        if (p->size < 0)
            SOAP_DELETE((ns1__StopResponse*)p->ptr);
        else
            SOAP_DELETE_ARRAY((ns1__StopResponse*)p->ptr);
        break;
    case SOAP_TYPE_ns1__ErrorResponse:
        if (p->size < 0)
            SOAP_DELETE((ns1__ErrorResponse*)p->ptr);
        else
            SOAP_DELETE_ARRAY((ns1__ErrorResponse*)p->ptr);
        break;
    case SOAP_TYPE_ns1__HaveSolutionResponse:
        if (p->size < 0)
            SOAP_DELETE((ns1__HaveSolutionResponse*)p->ptr);
        else
            SOAP_DELETE_ARRAY((ns1__HaveSolutionResponse*)p->ptr);
        break;
    case SOAP_TYPE_ns1__NeedSymbolsThenMiniDumpResponse:
        if (p->size < 0)
            SOAP_DELETE((ns1__NeedSymbolsThenMiniDumpResponse*)p->ptr);
        else
            SOAP_DELETE_ARRAY((ns1__NeedSymbolsThenMiniDumpResponse*)p->ptr);
        break;
    case SOAP_TYPE_ns1__NeedMiniDumpResponse:
        if (p->size < 0)
            SOAP_DELETE((ns1__NeedMiniDumpResponse*)p->ptr);
        else
            SOAP_DELETE_ARRAY((ns1__NeedMiniDumpResponse*)p->ptr);
        break;
    case SOAP_TYPE_ns1__NeedFullDumpResponse:
        if (p->size < 0)
            SOAP_DELETE((ns1__NeedFullDumpResponse*)p->ptr);
        else
            SOAP_DELETE_ARRAY((ns1__NeedFullDumpResponse*)p->ptr);
        break;
    case SOAP_TYPE_ns1__NeedMoreInfoResponse:
        if (p->size < 0)
            SOAP_DELETE((ns1__NeedMoreInfoResponse*)p->ptr);
        else
            SOAP_DELETE_ARRAY((ns1__NeedMoreInfoResponse*)p->ptr);
        break;
    case SOAP_TYPE___ns1__Hello:
        if (p->size < 0)
            SOAP_DELETE((struct __ns1__Hello*)p->ptr);
        else
            SOAP_DELETE_ARRAY((struct __ns1__Hello*)p->ptr);
        break;
    case SOAP_TYPE___ns1__UploadMiniDump:
        if (p->size < 0)
            SOAP_DELETE((struct __ns1__UploadMiniDump*)p->ptr);
        else
            SOAP_DELETE_ARRAY((struct __ns1__UploadMiniDump*)p->ptr);
        break;
    case SOAP_TYPE___ns1__UploadFullDump:
        if (p->size < 0)
            SOAP_DELETE((struct __ns1__UploadFullDump*)p->ptr);
        else
            SOAP_DELETE_ARRAY((struct __ns1__UploadFullDump*)p->ptr);
        break;
    case SOAP_TYPE___ns1__UploadAdditionalInfo:
        if (p->size < 0)
            SOAP_DELETE((struct __ns1__UploadAdditionalInfo*)p->ptr);
        else
            SOAP_DELETE_ARRAY((struct __ns1__UploadAdditionalInfo*)p->ptr);
        break;
    case SOAP_TYPE___ns1__RejectedToSendAdditionalInfo:
        if (p->size < 0)
            SOAP_DELETE((struct __ns1__RejectedToSendAdditionalInfo*)p->ptr);
        else
            SOAP_DELETE_ARRAY((struct __ns1__RejectedToSendAdditionalInfo*)p->ptr);
        break;
    case SOAP_TYPE___ns1__UploadSymbol:
        if (p->size < 0)
            SOAP_DELETE((struct __ns1__UploadSymbol*)p->ptr);
        else
            SOAP_DELETE_ARRAY((struct __ns1__UploadSymbol*)p->ptr);
        break;
#ifndef WITH_NOGLOBAL
    case SOAP_TYPE_SOAP_ENV__Header:
        if (p->size < 0)
            SOAP_DELETE((struct SOAP_ENV__Header*)p->ptr);
        else
            SOAP_DELETE_ARRAY((struct SOAP_ENV__Header*)p->ptr);
        break;
#endif
#ifndef WITH_NOGLOBAL
    case SOAP_TYPE_SOAP_ENV__Code:
        if (p->size < 0)
            SOAP_DELETE((struct SOAP_ENV__Code*)p->ptr);
        else
            SOAP_DELETE_ARRAY((struct SOAP_ENV__Code*)p->ptr);
        break;
#endif
#ifndef WITH_NOGLOBAL
    case SOAP_TYPE_SOAP_ENV__Detail:
        if (p->size < 0)
            SOAP_DELETE((struct SOAP_ENV__Detail*)p->ptr);
        else
            SOAP_DELETE_ARRAY((struct SOAP_ENV__Detail*)p->ptr);
        break;
#endif
#ifndef WITH_NOGLOBAL
    case SOAP_TYPE_SOAP_ENV__Reason:
        if (p->size < 0)
            SOAP_DELETE((struct SOAP_ENV__Reason*)p->ptr);
        else
            SOAP_DELETE_ARRAY((struct SOAP_ENV__Reason*)p->ptr);
        break;
#endif
#ifndef WITH_NOGLOBAL
    case SOAP_TYPE_SOAP_ENV__Fault:
        if (p->size < 0)
            SOAP_DELETE((struct SOAP_ENV__Fault*)p->ptr);
        else
            SOAP_DELETE_ARRAY((struct SOAP_ENV__Fault*)p->ptr);
        break;
#endif
    case SOAP_TYPE_xsd__QName:
        if (p->size < 0)
            SOAP_DELETE((std::string*)p->ptr);
        else
            SOAP_DELETE_ARRAY((std::string*)p->ptr);
        break;
    case SOAP_TYPE_xsd__ID:
        if (p->size < 0)
            SOAP_DELETE((std::wstring*)p->ptr);
        else
            SOAP_DELETE_ARRAY((std::wstring*)p->ptr);
        break;
    case SOAP_TYPE_xsd__IDREF:
        if (p->size < 0)
            SOAP_DELETE((std::wstring*)p->ptr);
        else
            SOAP_DELETE_ARRAY((std::wstring*)p->ptr);
        break;
    case SOAP_TYPE_xsd__anyURI:
        if (p->size < 0)
            SOAP_DELETE((std::wstring*)p->ptr);
        else
            SOAP_DELETE_ARRAY((std::wstring*)p->ptr);
        break;
    case SOAP_TYPE_xsd__decimal:
        if (p->size < 0)
            SOAP_DELETE((std::wstring*)p->ptr);
        else
            SOAP_DELETE_ARRAY((std::wstring*)p->ptr);
        break;
    case SOAP_TYPE_xsd__duration:
        if (p->size < 0)
            SOAP_DELETE((std::wstring*)p->ptr);
        else
            SOAP_DELETE_ARRAY((std::wstring*)p->ptr);
        break;
    case SOAP_TYPE_ns3__duration:
        if (p->size < 0)
            SOAP_DELETE((std::wstring*)p->ptr);
        else
            SOAP_DELETE_ARRAY((std::wstring*)p->ptr);
        break;
    case SOAP_TYPE_ns3__guid:
        if (p->size < 0)
            SOAP_DELETE((std::wstring*)p->ptr);
        else
            SOAP_DELETE_ARRAY((std::wstring*)p->ptr);
        break;
    case SOAP_TYPE_std__vectorTemplateOfstd__wstring:
        if (p->size < 0)
            SOAP_DELETE((std::vector<std::wstring >*)p->ptr);
        else
            SOAP_DELETE_ARRAY((std::vector<std::wstring >*)p->ptr);
        break;
    case SOAP_TYPE_std__vectorTemplateOfPointerTons1__ModuleSymbolInfo:
        if (p->size < 0)
            SOAP_DELETE((std::vector<ns1__ModuleSymbolInfo * >*)p->ptr);
        else
            SOAP_DELETE_ARRAY((std::vector<ns1__ModuleSymbolInfo * >*)p->ptr);
        break;
    default:    return SOAP_ERR;
    }
    return SOAP_OK;
}

SOAP_FMAC3 void* SOAP_FMAC4 soap_class_id_enter(struct soap *soap, const char *id, void *p, int t, size_t n, const char *type, const char *arrayType)
{   return soap_id_enter(soap, id, p, t, n, 0, type, arrayType, soap_instantiate);
}

SOAP_FMAC3 void* SOAP_FMAC4 soap_container_id_forward(struct soap *soap, const char *href, void *p, size_t len, int st, int tt, size_t n, unsigned int k)
{   return soap_id_forward(soap, href, p, len, st, tt, n, k, soap_container_insert);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_container_insert(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
#ifdef WIN32
#pragma warning(push)
#pragma warning(disable:4065)
#endif
{
    (void)soap; (void)st; (void)p; (void)len; (void)q; (void)n; /* appease -Wall -Werror */
    switch (tt)
    {
    case SOAP_TYPE_std__vectorTemplateOfstd__wstring:
        DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container soap_container_insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
        (*(std::vector<std::wstring >*)p)[len] = *(std::wstring *)q;
        break;
    case SOAP_TYPE_std__vectorTemplateOfPointerTons1__ModuleSymbolInfo:
        DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container soap_container_insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
        (*(std::vector<ns1__ModuleSymbolInfo * >*)p)[len] = *(ns1__ModuleSymbolInfo **)q;
        break;
    default:
        DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Could not insert type=%d in %d\n", st, tt));
    }
#ifdef WIN32
#pragma warning(pop)
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__byte(struct soap *soap, const char *tag, int id, const char *a, const char *type)
{   (void)soap; (void)type; (void)tag; (void)id;
    return soap_outbyte(soap, tag, id, a, type, SOAP_TYPE_xsd__byte);
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_in_xsd__byte(struct soap *soap, const char *tag, char *a, const char *type)
{   char *p;
    p = soap_inbyte(soap, tag, a, type, SOAP_TYPE_xsd__byte);
    return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__byte(struct soap *soap, const char *a, const char *tag, const char *type)
{
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xsd__byte);
    if (soap_out_xsd__byte(soap, tag?tag:"xsd:byte", id, a, type))
        return soap->error;
    return soap_putindependent(soap);
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_get_xsd__byte(struct soap *soap, char *p, const char *tag, const char *type)
{
    if ((p = soap_in_xsd__byte(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_byte(struct soap *soap, char *a)
{
    (void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_byte
    *a = SOAP_DEFAULT_byte;
#else
    *a = (char)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_byte(struct soap *soap, const char *tag, int id, const char *a, const char *type)
{   (void)soap; (void)type; (void)tag; (void)id;
    return soap_outbyte(soap, tag, id, a, type, SOAP_TYPE_byte);
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_in_byte(struct soap *soap, const char *tag, char *a, const char *type)
{   char *p;
    p = soap_inbyte(soap, tag, a, type, SOAP_TYPE_byte);
    return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_byte(struct soap *soap, const char *a, const char *tag, const char *type)
{
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_byte);
    if (soap_out_byte(soap, tag?tag:"byte", id, a, type))
        return soap->error;
    return soap_putindependent(soap);
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_get_byte(struct soap *soap, char *p, const char *tag, const char *type)
{
    if ((p = soap_in_byte(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_short(struct soap *soap, short *a)
{
    (void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_short
    *a = SOAP_DEFAULT_short;
#else
    *a = (short)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_short(struct soap *soap, const char *tag, int id, const short *a, const char *type)
{   (void)soap; (void)type; (void)tag; (void)id;
    return soap_outshort(soap, tag, id, a, type, SOAP_TYPE_short);
}

SOAP_FMAC3 short * SOAP_FMAC4 soap_in_short(struct soap *soap, const char *tag, short *a, const char *type)
{   short *p;
    p = soap_inshort(soap, tag, a, type, SOAP_TYPE_short);
    return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_short(struct soap *soap, const short *a, const char *tag, const char *type)
{
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_short);
    if (soap_out_short(soap, tag?tag:"short", id, a, type))
        return soap->error;
    return soap_putindependent(soap);
}

SOAP_FMAC3 short * SOAP_FMAC4 soap_get_short(struct soap *soap, short *p, const char *tag, const char *type)
{
    if ((p = soap_in_short(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns3__char(struct soap *soap, const char *tag, int id, const int *a, const char *type)
{   (void)soap; (void)type; (void)tag; (void)id;
    return soap_outint(soap, tag, id, a, type, SOAP_TYPE_ns3__char);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_in_ns3__char(struct soap *soap, const char *tag, int *a, const char *type)
{   int *p;
    p = soap_inint(soap, tag, a, type, SOAP_TYPE_ns3__char);
    return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns3__char(struct soap *soap, const int *a, const char *tag, const char *type)
{
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns3__char);
    if (soap_out_ns3__char(soap, tag?tag:"ns3:char", id, a, type))
        return soap->error;
    return soap_putindependent(soap);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_get_ns3__char(struct soap *soap, int *p, const char *tag, const char *type)
{
    if ((p = soap_in_ns3__char(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_int(struct soap *soap, int *a)
{
    (void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_int
    *a = SOAP_DEFAULT_int;
#else
    *a = (int)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_int(struct soap *soap, const char *tag, int id, const int *a, const char *type)
{   (void)soap; (void)type; (void)tag; (void)id;
    return soap_outint(soap, tag, id, a, type, SOAP_TYPE_int);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_in_int(struct soap *soap, const char *tag, int *a, const char *type)
{   int *p;
    p = soap_inint(soap, tag, a, type, SOAP_TYPE_int);
    return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_int(struct soap *soap, const int *a, const char *tag, const char *type)
{
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_int);
    if (soap_out_int(soap, tag?tag:"int", id, a, type))
        return soap->error;
    return soap_putindependent(soap);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_get_int(struct soap *soap, int *p, const char *tag, const char *type)
{
    if ((p = soap_in_int(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_LONG64(struct soap *soap, LONG64 *a)
{
    (void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_LONG64
    *a = SOAP_DEFAULT_LONG64;
#else
    *a = (LONG64)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_LONG64(struct soap *soap, const char *tag, int id, const LONG64 *a, const char *type)
{   (void)soap; (void)type; (void)tag; (void)id;
    return soap_outLONG64(soap, tag, id, a, type, SOAP_TYPE_LONG64);
}

SOAP_FMAC3 LONG64 * SOAP_FMAC4 soap_in_LONG64(struct soap *soap, const char *tag, LONG64 *a, const char *type)
{   LONG64 *p;
    p = soap_inLONG64(soap, tag, a, type, SOAP_TYPE_LONG64);
    return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_LONG64(struct soap *soap, const LONG64 *a, const char *tag, const char *type)
{
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_LONG64);
    if (soap_out_LONG64(soap, tag?tag:"long", id, a, type))
        return soap->error;
    return soap_putindependent(soap);
}

SOAP_FMAC3 LONG64 * SOAP_FMAC4 soap_get_LONG64(struct soap *soap, LONG64 *p, const char *tag, const char *type)
{
    if ((p = soap_in_LONG64(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_float(struct soap *soap, float *a)
{
    (void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_float
    *a = SOAP_DEFAULT_float;
#else
    *a = (float)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_float(struct soap *soap, const char *tag, int id, const float *a, const char *type)
{   (void)soap; (void)type; (void)tag; (void)id;
    return soap_outfloat(soap, tag, id, a, type, SOAP_TYPE_float);
}

SOAP_FMAC3 float * SOAP_FMAC4 soap_in_float(struct soap *soap, const char *tag, float *a, const char *type)
{   float *p;
    p = soap_infloat(soap, tag, a, type, SOAP_TYPE_float);
    return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_float(struct soap *soap, const float *a, const char *tag, const char *type)
{
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_float);
    if (soap_out_float(soap, tag?tag:"float", id, a, type))
        return soap->error;
    return soap_putindependent(soap);
}

SOAP_FMAC3 float * SOAP_FMAC4 soap_get_float(struct soap *soap, float *p, const char *tag, const char *type)
{
    if ((p = soap_in_float(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_double(struct soap *soap, double *a)
{
    (void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_double
    *a = SOAP_DEFAULT_double;
#else
    *a = (double)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_double(struct soap *soap, const char *tag, int id, const double *a, const char *type)
{   (void)soap; (void)type; (void)tag; (void)id;
    return soap_outdouble(soap, tag, id, a, type, SOAP_TYPE_double);
}

SOAP_FMAC3 double * SOAP_FMAC4 soap_in_double(struct soap *soap, const char *tag, double *a, const char *type)
{   double *p;
    p = soap_indouble(soap, tag, a, type, SOAP_TYPE_double);
    return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_double(struct soap *soap, const double *a, const char *tag, const char *type)
{
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_double);
    if (soap_out_double(soap, tag?tag:"double", id, a, type))
        return soap->error;
    return soap_putindependent(soap);
}

SOAP_FMAC3 double * SOAP_FMAC4 soap_get_double(struct soap *soap, double *p, const char *tag, const char *type)
{
    if ((p = soap_in_double(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__unsignedByte(struct soap *soap, const char *tag, int id, const unsigned char *a, const char *type)
{   (void)soap; (void)type; (void)tag; (void)id;
    return soap_outunsignedByte(soap, tag, id, a, type, SOAP_TYPE_xsd__unsignedByte);
}

SOAP_FMAC3 unsigned char * SOAP_FMAC4 soap_in_xsd__unsignedByte(struct soap *soap, const char *tag, unsigned char *a, const char *type)
{   unsigned char *p;
    p = soap_inunsignedByte(soap, tag, a, type, SOAP_TYPE_xsd__unsignedByte);
    return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__unsignedByte(struct soap *soap, const unsigned char *a, const char *tag, const char *type)
{
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xsd__unsignedByte);
    if (soap_out_xsd__unsignedByte(soap, tag?tag:"xsd:unsignedByte", id, a, type))
        return soap->error;
    return soap_putindependent(soap);
}

SOAP_FMAC3 unsigned char * SOAP_FMAC4 soap_get_xsd__unsignedByte(struct soap *soap, unsigned char *p, const char *tag, const char *type)
{
    if ((p = soap_in_xsd__unsignedByte(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_unsignedByte(struct soap *soap, unsigned char *a)
{
    (void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_unsignedByte
    *a = SOAP_DEFAULT_unsignedByte;
#else
    *a = (unsigned char)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_unsignedByte(struct soap *soap, const char *tag, int id, const unsigned char *a, const char *type)
{   (void)soap; (void)type; (void)tag; (void)id;
    return soap_outunsignedByte(soap, tag, id, a, type, SOAP_TYPE_unsignedByte);
}

SOAP_FMAC3 unsigned char * SOAP_FMAC4 soap_in_unsignedByte(struct soap *soap, const char *tag, unsigned char *a, const char *type)
{   unsigned char *p;
    p = soap_inunsignedByte(soap, tag, a, type, SOAP_TYPE_unsignedByte);
    return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_unsignedByte(struct soap *soap, const unsigned char *a, const char *tag, const char *type)
{
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_unsignedByte);
    if (soap_out_unsignedByte(soap, tag?tag:"unsignedByte", id, a, type))
        return soap->error;
    return soap_putindependent(soap);
}

SOAP_FMAC3 unsigned char * SOAP_FMAC4 soap_get_unsignedByte(struct soap *soap, unsigned char *p, const char *tag, const char *type)
{
    if ((p = soap_in_unsignedByte(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_unsignedShort(struct soap *soap, unsigned short *a)
{
    (void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_unsignedShort
    *a = SOAP_DEFAULT_unsignedShort;
#else
    *a = (unsigned short)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_unsignedShort(struct soap *soap, const char *tag, int id, const unsigned short *a, const char *type)
{   (void)soap; (void)type; (void)tag; (void)id;
    return soap_outunsignedShort(soap, tag, id, a, type, SOAP_TYPE_unsignedShort);
}

SOAP_FMAC3 unsigned short * SOAP_FMAC4 soap_in_unsignedShort(struct soap *soap, const char *tag, unsigned short *a, const char *type)
{   unsigned short *p;
    p = soap_inunsignedShort(soap, tag, a, type, SOAP_TYPE_unsignedShort);
    return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_unsignedShort(struct soap *soap, const unsigned short *a, const char *tag, const char *type)
{
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_unsignedShort);
    if (soap_out_unsignedShort(soap, tag?tag:"unsignedShort", id, a, type))
        return soap->error;
    return soap_putindependent(soap);
}

SOAP_FMAC3 unsigned short * SOAP_FMAC4 soap_get_unsignedShort(struct soap *soap, unsigned short *p, const char *tag, const char *type)
{
    if ((p = soap_in_unsignedShort(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_unsignedInt(struct soap *soap, unsigned int *a)
{
    (void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_unsignedInt
    *a = SOAP_DEFAULT_unsignedInt;
#else
    *a = (unsigned int)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_unsignedInt(struct soap *soap, const char *tag, int id, const unsigned int *a, const char *type)
{   (void)soap; (void)type; (void)tag; (void)id;
    return soap_outunsignedInt(soap, tag, id, a, type, SOAP_TYPE_unsignedInt);
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_in_unsignedInt(struct soap *soap, const char *tag, unsigned int *a, const char *type)
{   unsigned int *p;
    p = soap_inunsignedInt(soap, tag, a, type, SOAP_TYPE_unsignedInt);
    return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_unsignedInt(struct soap *soap, const unsigned int *a, const char *tag, const char *type)
{
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_unsignedInt);
    if (soap_out_unsignedInt(soap, tag?tag:"unsignedInt", id, a, type))
        return soap->error;
    return soap_putindependent(soap);
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_get_unsignedInt(struct soap *soap, unsigned int *p, const char *tag, const char *type)
{
    if ((p = soap_in_unsignedInt(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_unsignedLONG64(struct soap *soap, ULONG64 *a)
{
    (void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_unsignedLONG64
    *a = SOAP_DEFAULT_unsignedLONG64;
#else
    *a = (ULONG64)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_unsignedLONG64(struct soap *soap, const char *tag, int id, const ULONG64 *a, const char *type)
{   (void)soap; (void)type; (void)tag; (void)id;
    return soap_outULONG64(soap, tag, id, a, type, SOAP_TYPE_unsignedLONG64);
}

SOAP_FMAC3 ULONG64 * SOAP_FMAC4 soap_in_unsignedLONG64(struct soap *soap, const char *tag, ULONG64 *a, const char *type)
{   ULONG64 *p;
    p = soap_inULONG64(soap, tag, a, type, SOAP_TYPE_unsignedLONG64);
    return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_unsignedLONG64(struct soap *soap, const ULONG64 *a, const char *tag, const char *type)
{
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_unsignedLONG64);
    if (soap_out_unsignedLONG64(soap, tag?tag:"unsignedLong", id, a, type))
        return soap->error;
    return soap_putindependent(soap);
}

SOAP_FMAC3 ULONG64 * SOAP_FMAC4 soap_get_unsignedLONG64(struct soap *soap, ULONG64 *p, const char *tag, const char *type)
{
    if ((p = soap_in_unsignedLONG64(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_time(struct soap *soap, time_t *a)
{
    (void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_time
    *a = SOAP_DEFAULT_time;
#else
    *a = (time_t)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_time(struct soap *soap, const char *tag, int id, const time_t *a, const char *type)
{   (void)soap; (void)type; (void)tag; (void)id;
    return soap_outdateTime(soap, tag, id, a, type, SOAP_TYPE_time);
}

SOAP_FMAC3 time_t * SOAP_FMAC4 soap_in_time(struct soap *soap, const char *tag, time_t *a, const char *type)
{   time_t *p;
    p = soap_indateTime(soap, tag, a, type, SOAP_TYPE_time);
    return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_time(struct soap *soap, const time_t *a, const char *tag, const char *type)
{
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_time);
    if (soap_out_time(soap, tag?tag:"dateTime", id, a, type))
        return soap->error;
    return soap_putindependent(soap);
}

SOAP_FMAC3 time_t * SOAP_FMAC4 soap_get_time(struct soap *soap, time_t *p, const char *tag, const char *type)
{
    if ((p = soap_in_time(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns4__HaveSolutionResponse_SolutionType(struct soap *soap, enum ns4__HaveSolutionResponse_SolutionType *a)
{
    (void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_ns4__HaveSolutionResponse_SolutionType
    *a = SOAP_DEFAULT_ns4__HaveSolutionResponse_SolutionType;
#else
    *a = (enum ns4__HaveSolutionResponse_SolutionType)0;
#endif
}

static const struct soap_code_map soap_codes_ns4__HaveSolutionResponse_SolutionType[] =
{   { (long)ns4__HaveSolutionResponse_SolutionType__Url, "Url" },
    { (long)ns4__HaveSolutionResponse_SolutionType__Exe, "Exe" },
    { 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_ns4__HaveSolutionResponse_SolutionType2s(struct soap *soap, enum ns4__HaveSolutionResponse_SolutionType n)
{   const char *s = soap_code_str(soap_codes_ns4__HaveSolutionResponse_SolutionType, (long)n);
    if (s)
        return s;
    return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns4__HaveSolutionResponse_SolutionType(struct soap *soap, const char *tag, int id, const enum ns4__HaveSolutionResponse_SolutionType *a, const char *type)
{   if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns4__HaveSolutionResponse_SolutionType), type) || soap_send(soap, soap_ns4__HaveSolutionResponse_SolutionType2s(soap, *a)))
        return soap->error;
    return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2ns4__HaveSolutionResponse_SolutionType(struct soap *soap, const char *s, enum ns4__HaveSolutionResponse_SolutionType *a)
{
    const struct soap_code_map *map;
    if (!s)
        return soap->error;
    map = soap_code(soap_codes_ns4__HaveSolutionResponse_SolutionType, s);
    if (map)
        *a = (enum ns4__HaveSolutionResponse_SolutionType)map->code;
    else
    {   long n;
        if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 1)))
            return soap->error = SOAP_TYPE;
        *a = (enum ns4__HaveSolutionResponse_SolutionType)n;
    }
    return SOAP_OK;
}

SOAP_FMAC3 enum ns4__HaveSolutionResponse_SolutionType * SOAP_FMAC4 soap_in_ns4__HaveSolutionResponse_SolutionType(struct soap *soap, const char *tag, enum ns4__HaveSolutionResponse_SolutionType *a, const char *type)
{
    if (soap_element_begin_in(soap, tag, 0, type))
        return NULL;
    a = (enum ns4__HaveSolutionResponse_SolutionType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns4__HaveSolutionResponse_SolutionType, sizeof(enum ns4__HaveSolutionResponse_SolutionType), 0, NULL, NULL, NULL);
    if (!a)
        return NULL;
    if (soap->body && !*soap->href)
    {   if (!a || soap_s2ns4__HaveSolutionResponse_SolutionType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
            return NULL;
    }
    else
    {   a = (enum ns4__HaveSolutionResponse_SolutionType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns4__HaveSolutionResponse_SolutionType, 0, sizeof(enum ns4__HaveSolutionResponse_SolutionType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns4__HaveSolutionResponse_SolutionType(struct soap *soap, const enum ns4__HaveSolutionResponse_SolutionType *a, const char *tag, const char *type)
{
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns4__HaveSolutionResponse_SolutionType);
    if (soap_out_ns4__HaveSolutionResponse_SolutionType(soap, tag?tag:"ns4:HaveSolutionResponse.SolutionType", id, a, type))
        return soap->error;
    return soap_putindependent(soap);
}

SOAP_FMAC3 enum ns4__HaveSolutionResponse_SolutionType * SOAP_FMAC4 soap_get_ns4__HaveSolutionResponse_SolutionType(struct soap *soap, enum ns4__HaveSolutionResponse_SolutionType *p, const char *tag, const char *type)
{
    if ((p = soap_in_ns4__HaveSolutionResponse_SolutionType(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns4__ClientLib_ClientType(struct soap *soap, enum ns4__ClientLib_ClientType *a)
{
    (void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_ns4__ClientLib_ClientType
    *a = SOAP_DEFAULT_ns4__ClientLib_ClientType;
#else
    *a = (enum ns4__ClientLib_ClientType)0;
#endif
}

static const struct soap_code_map soap_codes_ns4__ClientLib_ClientType[] =
{   { (long)ns4__ClientLib_ClientType__CrashHandler_1_0, "CrashHandler_1_0" },
    { (long)ns4__ClientLib_ClientType__WebCrashRptGate, "WebCrashRptGate" },
    { (long)ns4__ClientLib_ClientType__DumpUploader, "DumpUploader" },
    { (long)ns4__ClientLib_ClientType__CrashHandler_2_0_CrashRptBased, "CrashHandler_2_0_CrashRptBased" },
    { (long)ns4__ClientLib_ClientType__SymbolUploader, "SymbolUploader" },
    { 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_ns4__ClientLib_ClientType2s(struct soap *soap, enum ns4__ClientLib_ClientType n)
{   const char *s = soap_code_str(soap_codes_ns4__ClientLib_ClientType, (long)n);
    if (s)
        return s;
    return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns4__ClientLib_ClientType(struct soap *soap, const char *tag, int id, const enum ns4__ClientLib_ClientType *a, const char *type)
{   if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns4__ClientLib_ClientType), type) || soap_send(soap, soap_ns4__ClientLib_ClientType2s(soap, *a)))
        return soap->error;
    return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2ns4__ClientLib_ClientType(struct soap *soap, const char *s, enum ns4__ClientLib_ClientType *a)
{
    const struct soap_code_map *map;
    if (!s)
        return soap->error;
    map = soap_code(soap_codes_ns4__ClientLib_ClientType, s);
    if (map)
        *a = (enum ns4__ClientLib_ClientType)map->code;
    else
    {   long n;
        if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 4)))
            return soap->error = SOAP_TYPE;
        *a = (enum ns4__ClientLib_ClientType)n;
    }
    return SOAP_OK;
}

SOAP_FMAC3 enum ns4__ClientLib_ClientType * SOAP_FMAC4 soap_in_ns4__ClientLib_ClientType(struct soap *soap, const char *tag, enum ns4__ClientLib_ClientType *a, const char *type)
{
    if (soap_element_begin_in(soap, tag, 0, type))
        return NULL;
    a = (enum ns4__ClientLib_ClientType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns4__ClientLib_ClientType, sizeof(enum ns4__ClientLib_ClientType), 0, NULL, NULL, NULL);
    if (!a)
        return NULL;
    if (soap->body && !*soap->href)
    {   if (!a || soap_s2ns4__ClientLib_ClientType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
            return NULL;
    }
    else
    {   a = (enum ns4__ClientLib_ClientType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns4__ClientLib_ClientType, 0, sizeof(enum ns4__ClientLib_ClientType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns4__ClientLib_ClientType(struct soap *soap, const enum ns4__ClientLib_ClientType *a, const char *tag, const char *type)
{
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns4__ClientLib_ClientType);
    if (soap_out_ns4__ClientLib_ClientType(soap, tag?tag:"ns4:ClientLib.ClientType", id, a, type))
        return soap->error;
    return soap_putindependent(soap);
}

SOAP_FMAC3 enum ns4__ClientLib_ClientType * SOAP_FMAC4 soap_get_ns4__ClientLib_ClientType(struct soap *soap, enum ns4__ClientLib_ClientType *p, const char *tag, const char *type)
{
    if ((p = soap_in_ns4__ClientLib_ClientType(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns4__ClientLib_Architecture(struct soap *soap, enum ns4__ClientLib_Architecture *a)
{
    (void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_ns4__ClientLib_Architecture
    *a = SOAP_DEFAULT_ns4__ClientLib_Architecture;
#else
    *a = (enum ns4__ClientLib_Architecture)0;
#endif
}

static const struct soap_code_map soap_codes_ns4__ClientLib_Architecture[] =
{   { (long)ns4__ClientLib_Architecture__x86, "x86" },
    { (long)ns4__ClientLib_Architecture__x64, "x64" },
    { (long)ns4__ClientLib_Architecture__DotNet, "DotNet" },
    { 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_ns4__ClientLib_Architecture2s(struct soap *soap, enum ns4__ClientLib_Architecture n)
{   const char *s = soap_code_str(soap_codes_ns4__ClientLib_Architecture, (long)n);
    if (s)
        return s;
    return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns4__ClientLib_Architecture(struct soap *soap, const char *tag, int id, const enum ns4__ClientLib_Architecture *a, const char *type)
{   if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns4__ClientLib_Architecture), type) || soap_send(soap, soap_ns4__ClientLib_Architecture2s(soap, *a)))
        return soap->error;
    return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2ns4__ClientLib_Architecture(struct soap *soap, const char *s, enum ns4__ClientLib_Architecture *a)
{
    const struct soap_code_map *map;
    if (!s)
        return soap->error;
    map = soap_code(soap_codes_ns4__ClientLib_Architecture, s);
    if (map)
        *a = (enum ns4__ClientLib_Architecture)map->code;
    else
    {   long n;
        if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 2)))
            return soap->error = SOAP_TYPE;
        *a = (enum ns4__ClientLib_Architecture)n;
    }
    return SOAP_OK;
}

SOAP_FMAC3 enum ns4__ClientLib_Architecture * SOAP_FMAC4 soap_in_ns4__ClientLib_Architecture(struct soap *soap, const char *tag, enum ns4__ClientLib_Architecture *a, const char *type)
{
    if (soap_element_begin_in(soap, tag, 0, type))
        return NULL;
    a = (enum ns4__ClientLib_Architecture *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns4__ClientLib_Architecture, sizeof(enum ns4__ClientLib_Architecture), 0, NULL, NULL, NULL);
    if (!a)
        return NULL;
    if (soap->body && !*soap->href)
    {   if (!a || soap_s2ns4__ClientLib_Architecture(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
            return NULL;
    }
    else
    {   a = (enum ns4__ClientLib_Architecture *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns4__ClientLib_Architecture, 0, sizeof(enum ns4__ClientLib_Architecture), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns4__ClientLib_Architecture(struct soap *soap, const enum ns4__ClientLib_Architecture *a, const char *tag, const char *type)
{
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns4__ClientLib_Architecture);
    if (soap_out_ns4__ClientLib_Architecture(soap, tag?tag:"ns4:ClientLib.Architecture", id, a, type))
        return soap->error;
    return soap_putindependent(soap);
}

SOAP_FMAC3 enum ns4__ClientLib_Architecture * SOAP_FMAC4 soap_get_ns4__ClientLib_Architecture(struct soap *soap, enum ns4__ClientLib_Architecture *p, const char *tag, const char *type)
{
    if ((p = soap_in_ns4__ClientLib_Architecture(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_bool(struct soap *soap, bool *a)
{
    (void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_bool
    *a = SOAP_DEFAULT_bool;
#else
    *a = (bool)0;
#endif
}

static const struct soap_code_map soap_codes_bool[] =
{   { (long)false, "false" },
    { (long)true, "true" },
    { 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_bool2s(struct soap *soap, bool n)
{
    (void)soap; /* appease -Wall -Werror */
return soap_code_str(soap_codes_bool, n!=0);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_bool(struct soap *soap, const char *tag, int id, const bool *a, const char *type)
{   if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_bool), type) || soap_send(soap, soap_bool2s(soap, *a)))
        return soap->error;
    return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2bool(struct soap *soap, const char *s, bool *a)
{
    const struct soap_code_map *map;
    if (!s)
        return soap->error;
    map = soap_code(soap_codes_bool, s);
    if (map)
        *a = (bool)(map->code != 0);
    else
    {   long n;
        if (soap_s2long(soap, s, &n) || n < 0 || n > 1)
            return soap->error = SOAP_TYPE;
        *a = (bool)(n != 0);
    }
    return SOAP_OK;
}

SOAP_FMAC3 bool * SOAP_FMAC4 soap_in_bool(struct soap *soap, const char *tag, bool *a, const char *type)
{
    if (soap_element_begin_in(soap, tag, 0, NULL))
        return NULL;
    if (*soap->type && soap_match_tag(soap, soap->type, type) && soap_match_tag(soap, soap->type, ":boolean"))
    {   soap->error = SOAP_TYPE;
        return NULL;
    }
    a = (bool *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_bool, sizeof(bool), 0, NULL, NULL, NULL);
    if (!a)
        return NULL;
    if (soap->body && !*soap->href)
    {   if (!a || soap_s2bool(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
            return NULL;
    }
    else
    {   a = (bool *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_bool, 0, sizeof(bool), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_bool(struct soap *soap, const bool *a, const char *tag, const char *type)
{
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_bool);
    if (soap_out_bool(soap, tag?tag:"boolean", id, a, type))
        return soap->error;
    return soap_putindependent(soap);
}

SOAP_FMAC3 bool * SOAP_FMAC4 soap_get_bool(struct soap *soap, bool *p, const char *tag, const char *type)
{
    if ((p = soap_in_bool(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

void ns4__HaveSolutionResponse_SolutionType_::soap_default(struct soap *soap)
{
    this->soap = soap;
    this->xsd__anyType::soap_default(soap);
    soap_default_ns4__HaveSolutionResponse_SolutionType(soap, &this->ns4__HaveSolutionResponse_SolutionType_::__item);
}

void ns4__HaveSolutionResponse_SolutionType_::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
    (void)soap; /* appease -Wall -Werror */
    this->xsd__anyType::soap_serialize(soap);
#endif
}

int ns4__HaveSolutionResponse_SolutionType_::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
    return soap_out_ns4__HaveSolutionResponse_SolutionType_(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns4__HaveSolutionResponse_SolutionType_(struct soap *soap, const char *tag, int id, const ns4__HaveSolutionResponse_SolutionType_ *a, const char *type)
{
    return soap_out_ns4__HaveSolutionResponse_SolutionType(soap, tag, id, &(a->ns4__HaveSolutionResponse_SolutionType_::__item), "ns4:HaveSolutionResponse.SolutionType");
}

void *ns4__HaveSolutionResponse_SolutionType_::soap_in(struct soap *soap, const char *tag, const char *type)
{   return soap_in_ns4__HaveSolutionResponse_SolutionType_(soap, tag, this, type);
}

SOAP_FMAC3 ns4__HaveSolutionResponse_SolutionType_ * SOAP_FMAC4 soap_in_ns4__HaveSolutionResponse_SolutionType_(struct soap *soap, const char *tag, ns4__HaveSolutionResponse_SolutionType_ *a, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    if (soap_element_begin_in(soap, tag, 1, NULL))
        return NULL;
    if (!(a = (ns4__HaveSolutionResponse_SolutionType_ *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns4__HaveSolutionResponse_SolutionType_, sizeof(ns4__HaveSolutionResponse_SolutionType_), soap->type, soap->arrayType)))
    {   soap->error = SOAP_TAG_MISMATCH;
        return NULL;
    }
    soap_revert(soap);
    *soap->id = '\0';
    if (soap->alloced)
    {   a->soap_default(soap);
        if (soap->clist->type != SOAP_TYPE_ns4__HaveSolutionResponse_SolutionType_)
            return (ns4__HaveSolutionResponse_SolutionType_ *)a->soap_in(soap, tag, type);
    }
    if (!soap_in_ns4__HaveSolutionResponse_SolutionType(soap, tag, &(a->ns4__HaveSolutionResponse_SolutionType_::__item), "ns4:HaveSolutionResponse.SolutionType"))
        return NULL;
    return a;
}

int ns4__HaveSolutionResponse_SolutionType_::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
    register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns4__HaveSolutionResponse_SolutionType_);
    if (this->soap_out(soap, tag?tag:"ns4:HaveSolutionResponse.SolutionType", id, type))
        return soap->error;
    return soap_putindependent(soap);
}

void *ns4__HaveSolutionResponse_SolutionType_::soap_get(struct soap *soap, const char *tag, const char *type)
{
    return soap_get_ns4__HaveSolutionResponse_SolutionType_(soap, this, tag, type);
}

SOAP_FMAC3 ns4__HaveSolutionResponse_SolutionType_ * SOAP_FMAC4 soap_get_ns4__HaveSolutionResponse_SolutionType_(struct soap *soap, ns4__HaveSolutionResponse_SolutionType_ *p, const char *tag, const char *type)
{
    if ((p = soap_in_ns4__HaveSolutionResponse_SolutionType_(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 ns4__HaveSolutionResponse_SolutionType_ * SOAP_FMAC2 soap_instantiate_ns4__HaveSolutionResponse_SolutionType_(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns4__HaveSolutionResponse_SolutionType_(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns4__HaveSolutionResponse_SolutionType_, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(ns4__HaveSolutionResponse_SolutionType_);
        if (size)
            *size = sizeof(ns4__HaveSolutionResponse_SolutionType_);
        ((ns4__HaveSolutionResponse_SolutionType_*)cp->ptr)->soap = soap;
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(ns4__HaveSolutionResponse_SolutionType_, n);
        if (size)
            *size = n * sizeof(ns4__HaveSolutionResponse_SolutionType_);
        if (cp->ptr)
            for (int i = 0; i < n; i++)
                ((ns4__HaveSolutionResponse_SolutionType_*)cp->ptr)[i].soap = soap;
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (ns4__HaveSolutionResponse_SolutionType_*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns4__HaveSolutionResponse_SolutionType_(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns4__HaveSolutionResponse_SolutionType_ %p -> %p\n", q, p));
    *(ns4__HaveSolutionResponse_SolutionType_*)p = *(ns4__HaveSolutionResponse_SolutionType_*)q;
}

void ns4__ClientLib_ClientType_::soap_default(struct soap *soap)
{
    this->soap = soap;
    this->xsd__anyType::soap_default(soap);
    soap_default_ns4__ClientLib_ClientType(soap, &this->ns4__ClientLib_ClientType_::__item);
}

void ns4__ClientLib_ClientType_::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
    (void)soap; /* appease -Wall -Werror */
    this->xsd__anyType::soap_serialize(soap);
#endif
}

int ns4__ClientLib_ClientType_::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
    return soap_out_ns4__ClientLib_ClientType_(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns4__ClientLib_ClientType_(struct soap *soap, const char *tag, int id, const ns4__ClientLib_ClientType_ *a, const char *type)
{
    return soap_out_ns4__ClientLib_ClientType(soap, tag, id, &(a->ns4__ClientLib_ClientType_::__item), "ns4:ClientLib.ClientType");
}

void *ns4__ClientLib_ClientType_::soap_in(struct soap *soap, const char *tag, const char *type)
{   return soap_in_ns4__ClientLib_ClientType_(soap, tag, this, type);
}

SOAP_FMAC3 ns4__ClientLib_ClientType_ * SOAP_FMAC4 soap_in_ns4__ClientLib_ClientType_(struct soap *soap, const char *tag, ns4__ClientLib_ClientType_ *a, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    if (soap_element_begin_in(soap, tag, 1, NULL))
        return NULL;
    if (!(a = (ns4__ClientLib_ClientType_ *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns4__ClientLib_ClientType_, sizeof(ns4__ClientLib_ClientType_), soap->type, soap->arrayType)))
    {   soap->error = SOAP_TAG_MISMATCH;
        return NULL;
    }
    soap_revert(soap);
    *soap->id = '\0';
    if (soap->alloced)
    {   a->soap_default(soap);
        if (soap->clist->type != SOAP_TYPE_ns4__ClientLib_ClientType_)
            return (ns4__ClientLib_ClientType_ *)a->soap_in(soap, tag, type);
    }
    if (!soap_in_ns4__ClientLib_ClientType(soap, tag, &(a->ns4__ClientLib_ClientType_::__item), "ns4:ClientLib.ClientType"))
        return NULL;
    return a;
}

int ns4__ClientLib_ClientType_::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
    register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns4__ClientLib_ClientType_);
    if (this->soap_out(soap, tag?tag:"ns4:ClientLib.ClientType", id, type))
        return soap->error;
    return soap_putindependent(soap);
}

void *ns4__ClientLib_ClientType_::soap_get(struct soap *soap, const char *tag, const char *type)
{
    return soap_get_ns4__ClientLib_ClientType_(soap, this, tag, type);
}

SOAP_FMAC3 ns4__ClientLib_ClientType_ * SOAP_FMAC4 soap_get_ns4__ClientLib_ClientType_(struct soap *soap, ns4__ClientLib_ClientType_ *p, const char *tag, const char *type)
{
    if ((p = soap_in_ns4__ClientLib_ClientType_(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 ns4__ClientLib_ClientType_ * SOAP_FMAC2 soap_instantiate_ns4__ClientLib_ClientType_(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns4__ClientLib_ClientType_(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns4__ClientLib_ClientType_, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(ns4__ClientLib_ClientType_);
        if (size)
            *size = sizeof(ns4__ClientLib_ClientType_);
        ((ns4__ClientLib_ClientType_*)cp->ptr)->soap = soap;
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(ns4__ClientLib_ClientType_, n);
        if (size)
            *size = n * sizeof(ns4__ClientLib_ClientType_);
        if (cp->ptr)
            for (int i = 0; i < n; i++)
                ((ns4__ClientLib_ClientType_*)cp->ptr)[i].soap = soap;
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (ns4__ClientLib_ClientType_*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns4__ClientLib_ClientType_(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns4__ClientLib_ClientType_ %p -> %p\n", q, p));
    *(ns4__ClientLib_ClientType_*)p = *(ns4__ClientLib_ClientType_*)q;
}

void ns4__ClientLib_Architecture_::soap_default(struct soap *soap)
{
    this->soap = soap;
    this->xsd__anyType::soap_default(soap);
    soap_default_ns4__ClientLib_Architecture(soap, &this->ns4__ClientLib_Architecture_::__item);
}

void ns4__ClientLib_Architecture_::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
    (void)soap; /* appease -Wall -Werror */
    this->xsd__anyType::soap_serialize(soap);
#endif
}

int ns4__ClientLib_Architecture_::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
    return soap_out_ns4__ClientLib_Architecture_(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns4__ClientLib_Architecture_(struct soap *soap, const char *tag, int id, const ns4__ClientLib_Architecture_ *a, const char *type)
{
    return soap_out_ns4__ClientLib_Architecture(soap, tag, id, &(a->ns4__ClientLib_Architecture_::__item), "ns4:ClientLib.Architecture");
}

void *ns4__ClientLib_Architecture_::soap_in(struct soap *soap, const char *tag, const char *type)
{   return soap_in_ns4__ClientLib_Architecture_(soap, tag, this, type);
}

SOAP_FMAC3 ns4__ClientLib_Architecture_ * SOAP_FMAC4 soap_in_ns4__ClientLib_Architecture_(struct soap *soap, const char *tag, ns4__ClientLib_Architecture_ *a, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    if (soap_element_begin_in(soap, tag, 1, NULL))
        return NULL;
    if (!(a = (ns4__ClientLib_Architecture_ *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns4__ClientLib_Architecture_, sizeof(ns4__ClientLib_Architecture_), soap->type, soap->arrayType)))
    {   soap->error = SOAP_TAG_MISMATCH;
        return NULL;
    }
    soap_revert(soap);
    *soap->id = '\0';
    if (soap->alloced)
    {   a->soap_default(soap);
        if (soap->clist->type != SOAP_TYPE_ns4__ClientLib_Architecture_)
            return (ns4__ClientLib_Architecture_ *)a->soap_in(soap, tag, type);
    }
    if (!soap_in_ns4__ClientLib_Architecture(soap, tag, &(a->ns4__ClientLib_Architecture_::__item), "ns4:ClientLib.Architecture"))
        return NULL;
    return a;
}

int ns4__ClientLib_Architecture_::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
    register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns4__ClientLib_Architecture_);
    if (this->soap_out(soap, tag?tag:"ns4:ClientLib.Architecture", id, type))
        return soap->error;
    return soap_putindependent(soap);
}

void *ns4__ClientLib_Architecture_::soap_get(struct soap *soap, const char *tag, const char *type)
{
    return soap_get_ns4__ClientLib_Architecture_(soap, this, tag, type);
}

SOAP_FMAC3 ns4__ClientLib_Architecture_ * SOAP_FMAC4 soap_get_ns4__ClientLib_Architecture_(struct soap *soap, ns4__ClientLib_Architecture_ *p, const char *tag, const char *type)
{
    if ((p = soap_in_ns4__ClientLib_Architecture_(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 ns4__ClientLib_Architecture_ * SOAP_FMAC2 soap_instantiate_ns4__ClientLib_Architecture_(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns4__ClientLib_Architecture_(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns4__ClientLib_Architecture_, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(ns4__ClientLib_Architecture_);
        if (size)
            *size = sizeof(ns4__ClientLib_Architecture_);
        ((ns4__ClientLib_Architecture_*)cp->ptr)->soap = soap;
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(ns4__ClientLib_Architecture_, n);
        if (size)
            *size = n * sizeof(ns4__ClientLib_Architecture_);
        if (cp->ptr)
            for (int i = 0; i < n; i++)
                ((ns4__ClientLib_Architecture_*)cp->ptr)[i].soap = soap;
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (ns4__ClientLib_Architecture_*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns4__ClientLib_Architecture_(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns4__ClientLib_Architecture_ %p -> %p\n", q, p));
    *(ns4__ClientLib_Architecture_*)p = *(ns4__ClientLib_Architecture_*)q;
}

void ns3__guid__::soap_default(struct soap *soap)
{
    this->soap = soap;
    this->xsd__anyType::soap_default(soap);
    soap_default_ns3__guid(soap, &this->ns3__guid__::__item);
}

void ns3__guid__::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
    (void)soap; /* appease -Wall -Werror */
    soap_serialize_ns3__guid(soap, &this->ns3__guid__::__item);
    this->xsd__anyType::soap_serialize(soap);
#endif
}

int ns3__guid__::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
    return soap_out_ns3__guid__(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns3__guid__(struct soap *soap, const char *tag, int id, const ns3__guid__ *a, const char *type)
{
    return soap_out_ns3__guid(soap, tag, id, &(a->ns3__guid__::__item), "ns3:guid");
}

void *ns3__guid__::soap_in(struct soap *soap, const char *tag, const char *type)
{   return soap_in_ns3__guid__(soap, tag, this, type);
}

SOAP_FMAC3 ns3__guid__ * SOAP_FMAC4 soap_in_ns3__guid__(struct soap *soap, const char *tag, ns3__guid__ *a, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    if (soap_element_begin_in(soap, tag, 1, NULL))
        return NULL;
    if (!(a = (ns3__guid__ *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns3__guid__, sizeof(ns3__guid__), soap->type, soap->arrayType)))
    {   soap->error = SOAP_TAG_MISMATCH;
        return NULL;
    }
    soap_revert(soap);
    *soap->id = '\0';
    if (soap->alloced)
    {   a->soap_default(soap);
        if (soap->clist->type != SOAP_TYPE_ns3__guid__)
            return (ns3__guid__ *)a->soap_in(soap, tag, type);
    }
    if (!soap_in_ns3__guid(soap, tag, &(a->ns3__guid__::__item), "ns3:guid"))
        return NULL;
    return a;
}

int ns3__guid__::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
    register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns3__guid__);
    if (this->soap_out(soap, tag?tag:"ns3:guid", id, type))
        return soap->error;
    return soap_putindependent(soap);
}

void *ns3__guid__::soap_get(struct soap *soap, const char *tag, const char *type)
{
    return soap_get_ns3__guid__(soap, this, tag, type);
}

SOAP_FMAC3 ns3__guid__ * SOAP_FMAC4 soap_get_ns3__guid__(struct soap *soap, ns3__guid__ *p, const char *tag, const char *type)
{
    if ((p = soap_in_ns3__guid__(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 ns3__guid__ * SOAP_FMAC2 soap_instantiate_ns3__guid__(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns3__guid__(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns3__guid__, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(ns3__guid__);
        if (size)
            *size = sizeof(ns3__guid__);
        ((ns3__guid__*)cp->ptr)->soap = soap;
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(ns3__guid__, n);
        if (size)
            *size = n * sizeof(ns3__guid__);
        if (cp->ptr)
            for (int i = 0; i < n; i++)
                ((ns3__guid__*)cp->ptr)[i].soap = soap;
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (ns3__guid__*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns3__guid__(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns3__guid__ %p -> %p\n", q, p));
    *(ns3__guid__*)p = *(ns3__guid__*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns3__guid(struct soap *soap, const std::wstring *a)
{   (void)soap; (void)a; /* appease -Wall -Werror */
}
SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns3__guid(struct soap *soap, const char *tag, int id, const std::wstring *s, const char *type)
{
    if ((soap->mode & SOAP_C_NILSTRING) && s->empty())
        return soap_element_null(soap, tag, id, type);
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, s, SOAP_TYPE_ns3__guid), type) || soap_wstring_out(soap, s->c_str(), 0) || soap_element_end_out(soap, tag))
        return soap->error;
    return SOAP_OK;
}

SOAP_FMAC3 std::wstring * SOAP_FMAC4 soap_in_ns3__guid(struct soap *soap, const char *tag, std::wstring *s, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    if (soap_element_begin_in(soap, tag, 1, NULL))
        return NULL;
    if (!s)
        s = soap_new_std__wstring(soap, -1);
    if (soap->null)
        if (s)
            s->erase();
    if (soap->body && !*soap->href)
    {   wchar_t *t;
        s = (std::wstring*)soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_ns3__guid, sizeof(std::wstring), soap->type, soap->arrayType);
        if (s)
        {   if (!(t = soap_wstring_in(soap, 1, 0, -1)))
                return NULL;
            s->assign(t);
        }
    }
    else
        s = (std::wstring*)soap_id_forward(soap, soap->href, soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_ns3__guid, sizeof(std::wstring), soap->type, soap->arrayType), 0, SOAP_TYPE_ns3__guid, 0, sizeof(std::wstring), 0, soap_copy_ns3__guid);
    if (soap->body && soap_element_end_in(soap, tag))
        return NULL;
    return s;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns3__guid(struct soap *soap, const std::wstring *a, const char *tag, const char *type)
{
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns3__guid);
    if (soap_out_ns3__guid(soap, tag?tag:"ns3:guid", id, a, type))
        return soap->error;
    return soap_putindependent(soap);
}

SOAP_FMAC3 std::wstring * SOAP_FMAC4 soap_get_ns3__guid(struct soap *soap, std::wstring *p, const char *tag, const char *type)
{
    if ((p = soap_in_ns3__guid(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

void ns3__duration__::soap_default(struct soap *soap)
{
    this->soap = soap;
    this->xsd__anyType::soap_default(soap);
    soap_default_ns3__duration(soap, &this->ns3__duration__::__item);
}

void ns3__duration__::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
    (void)soap; /* appease -Wall -Werror */
    soap_serialize_ns3__duration(soap, &this->ns3__duration__::__item);
    this->xsd__anyType::soap_serialize(soap);
#endif
}

int ns3__duration__::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
    return soap_out_ns3__duration__(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns3__duration__(struct soap *soap, const char *tag, int id, const ns3__duration__ *a, const char *type)
{
    return soap_out_ns3__duration(soap, tag, id, &(a->ns3__duration__::__item), "ns3:duration");
}

void *ns3__duration__::soap_in(struct soap *soap, const char *tag, const char *type)
{   return soap_in_ns3__duration__(soap, tag, this, type);
}

SOAP_FMAC3 ns3__duration__ * SOAP_FMAC4 soap_in_ns3__duration__(struct soap *soap, const char *tag, ns3__duration__ *a, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    if (soap_element_begin_in(soap, tag, 1, NULL))
        return NULL;
    if (!(a = (ns3__duration__ *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns3__duration__, sizeof(ns3__duration__), soap->type, soap->arrayType)))
    {   soap->error = SOAP_TAG_MISMATCH;
        return NULL;
    }
    soap_revert(soap);
    *soap->id = '\0';
    if (soap->alloced)
    {   a->soap_default(soap);
        if (soap->clist->type != SOAP_TYPE_ns3__duration__)
            return (ns3__duration__ *)a->soap_in(soap, tag, type);
    }
    if (!soap_in_ns3__duration(soap, tag, &(a->ns3__duration__::__item), "ns3:duration"))
        return NULL;
    return a;
}

int ns3__duration__::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
    register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns3__duration__);
    if (this->soap_out(soap, tag?tag:"ns3:duration", id, type))
        return soap->error;
    return soap_putindependent(soap);
}

void *ns3__duration__::soap_get(struct soap *soap, const char *tag, const char *type)
{
    return soap_get_ns3__duration__(soap, this, tag, type);
}

SOAP_FMAC3 ns3__duration__ * SOAP_FMAC4 soap_get_ns3__duration__(struct soap *soap, ns3__duration__ *p, const char *tag, const char *type)
{
    if ((p = soap_in_ns3__duration__(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 ns3__duration__ * SOAP_FMAC2 soap_instantiate_ns3__duration__(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns3__duration__(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns3__duration__, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(ns3__duration__);
        if (size)
            *size = sizeof(ns3__duration__);
        ((ns3__duration__*)cp->ptr)->soap = soap;
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(ns3__duration__, n);
        if (size)
            *size = n * sizeof(ns3__duration__);
        if (cp->ptr)
            for (int i = 0; i < n; i++)
                ((ns3__duration__*)cp->ptr)[i].soap = soap;
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (ns3__duration__*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns3__duration__(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns3__duration__ %p -> %p\n", q, p));
    *(ns3__duration__*)p = *(ns3__duration__*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns3__duration(struct soap *soap, const std::wstring *a)
{   (void)soap; (void)a; /* appease -Wall -Werror */
}
SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns3__duration(struct soap *soap, const char *tag, int id, const std::wstring *s, const char *type)
{
    if ((soap->mode & SOAP_C_NILSTRING) && s->empty())
        return soap_element_null(soap, tag, id, type);
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, s, SOAP_TYPE_ns3__duration), type) || soap_wstring_out(soap, s->c_str(), 0) || soap_element_end_out(soap, tag))
        return soap->error;
    return SOAP_OK;
}

SOAP_FMAC3 std::wstring * SOAP_FMAC4 soap_in_ns3__duration(struct soap *soap, const char *tag, std::wstring *s, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    if (soap_element_begin_in(soap, tag, 1, NULL))
        return NULL;
    if (!s)
        s = soap_new_std__wstring(soap, -1);
    if (soap->null)
        if (s)
            s->erase();
    if (soap->body && !*soap->href)
    {   wchar_t *t;
        s = (std::wstring*)soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_ns3__duration, sizeof(std::wstring), soap->type, soap->arrayType);
        if (s)
        {   if (!(t = soap_wstring_in(soap, 1, 0, -1)))
                return NULL;
            s->assign(t);
        }
    }
    else
        s = (std::wstring*)soap_id_forward(soap, soap->href, soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_ns3__duration, sizeof(std::wstring), soap->type, soap->arrayType), 0, SOAP_TYPE_ns3__duration, 0, sizeof(std::wstring), 0, soap_copy_ns3__duration);
    if (soap->body && soap_element_end_in(soap, tag))
        return NULL;
    return s;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns3__duration(struct soap *soap, const std::wstring *a, const char *tag, const char *type)
{
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns3__duration);
    if (soap_out_ns3__duration(soap, tag?tag:"ns3:duration", id, a, type))
        return soap->error;
    return soap_putindependent(soap);
}

SOAP_FMAC3 std::wstring * SOAP_FMAC4 soap_get_ns3__duration(struct soap *soap, std::wstring *p, const char *tag, const char *type)
{
    if ((p = soap_in_ns3__duration(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

void ns3__char__::soap_default(struct soap *soap)
{
    this->soap = soap;
    this->xsd__anyType::soap_default(soap);
    soap_default_ns3__char(soap, &this->ns3__char__::__item);
}

void ns3__char__::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
    (void)soap; /* appease -Wall -Werror */
    this->xsd__anyType::soap_serialize(soap);
#endif
}

int ns3__char__::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
    return soap_out_ns3__char__(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns3__char__(struct soap *soap, const char *tag, int id, const ns3__char__ *a, const char *type)
{
    return soap_out_ns3__char(soap, tag, id, &(a->ns3__char__::__item), "ns3:char");
}

void *ns3__char__::soap_in(struct soap *soap, const char *tag, const char *type)
{   return soap_in_ns3__char__(soap, tag, this, type);
}

SOAP_FMAC3 ns3__char__ * SOAP_FMAC4 soap_in_ns3__char__(struct soap *soap, const char *tag, ns3__char__ *a, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    if (soap_element_begin_in(soap, tag, 1, NULL))
        return NULL;
    if (!(a = (ns3__char__ *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns3__char__, sizeof(ns3__char__), soap->type, soap->arrayType)))
    {   soap->error = SOAP_TAG_MISMATCH;
        return NULL;
    }
    soap_revert(soap);
    *soap->id = '\0';
    if (soap->alloced)
    {   a->soap_default(soap);
        if (soap->clist->type != SOAP_TYPE_ns3__char__)
            return (ns3__char__ *)a->soap_in(soap, tag, type);
    }
    if (!soap_in_ns3__char(soap, tag, &(a->ns3__char__::__item), "ns3:char"))
        return NULL;
    return a;
}

int ns3__char__::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
    register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns3__char__);
    if (this->soap_out(soap, tag?tag:"ns3:char", id, type))
        return soap->error;
    return soap_putindependent(soap);
}

void *ns3__char__::soap_get(struct soap *soap, const char *tag, const char *type)
{
    return soap_get_ns3__char__(soap, this, tag, type);
}

SOAP_FMAC3 ns3__char__ * SOAP_FMAC4 soap_get_ns3__char__(struct soap *soap, ns3__char__ *p, const char *tag, const char *type)
{
    if ((p = soap_in_ns3__char__(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 ns3__char__ * SOAP_FMAC2 soap_instantiate_ns3__char__(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns3__char__(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns3__char__, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(ns3__char__);
        if (size)
            *size = sizeof(ns3__char__);
        ((ns3__char__*)cp->ptr)->soap = soap;
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(ns3__char__, n);
        if (size)
            *size = n * sizeof(ns3__char__);
        if (cp->ptr)
            for (int i = 0; i < n; i++)
                ((ns3__char__*)cp->ptr)[i].soap = soap;
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (ns3__char__*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns3__char__(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns3__char__ %p -> %p\n", q, p));
    *(ns3__char__*)p = *(ns3__char__*)q;
}

void ns5__ArrayOfstring::soap_default(struct soap *soap)
{
    this->soap = soap;
    this->xsd__anyType::soap_default(soap);
    soap_default_std__vectorTemplateOfstd__wstring(soap, &this->ns5__ArrayOfstring::string);
}

void ns5__ArrayOfstring::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
    (void)soap; /* appease -Wall -Werror */
    soap_serialize_std__vectorTemplateOfstd__wstring(soap, &this->ns5__ArrayOfstring::string);
    this->xsd__anyType::soap_serialize(soap);
#endif
}

int ns5__ArrayOfstring::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
    return soap_out_ns5__ArrayOfstring(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns5__ArrayOfstring(struct soap *soap, const char *tag, int id, const ns5__ArrayOfstring *a, const char *type)
{
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns5__ArrayOfstring), "ns5:ArrayOfstring"))
        return soap->error;
    /* transient soap skipped */
    if (soap_out_std__vectorTemplateOfstd__wstring(soap, "ns5:string", -1, &(a->ns5__ArrayOfstring::string), ""))
        return soap->error;
    return soap_element_end_out(soap, tag);
}

void *ns5__ArrayOfstring::soap_in(struct soap *soap, const char *tag, const char *type)
{   return soap_in_ns5__ArrayOfstring(soap, tag, this, type);
}

SOAP_FMAC3 ns5__ArrayOfstring * SOAP_FMAC4 soap_in_ns5__ArrayOfstring(struct soap *soap, const char *tag, ns5__ArrayOfstring *a, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    if (soap_element_begin_in(soap, tag, 0, NULL))
        return NULL;
    a = (ns5__ArrayOfstring *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns5__ArrayOfstring, sizeof(ns5__ArrayOfstring), soap->type, soap->arrayType);
    if (!a)
        return NULL;
    if (soap->alloced)
    {   a->soap_default(soap);
        if (soap->clist->type != SOAP_TYPE_ns5__ArrayOfstring)
        {   soap_revert(soap);
            *soap->id = '\0';
            return (ns5__ArrayOfstring *)a->soap_in(soap, tag, type);
        }
    }
    size_t soap_flag___item2 = 1;
    if (soap->body && !*soap->href)
    {
        for (;;)
        {   soap->error = SOAP_TAG_MISMATCH;
            /* transient soap skipped */
            if (soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_std__vectorTemplateOfstd__wstring(soap, "ns5:string", &(a->ns5__ArrayOfstring::string), "xsd:string"))
                    continue;
            if (soap_flag___item2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
                if (soap_inliteral(soap, "-item", &(a->xsd__anyType::__item)))
                {   soap_flag___item2--;
                    continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
                soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
                break;
            if (soap->error)
                return NULL;
        }
        if (soap_element_end_in(soap, tag))
            return NULL;
    }
    else
    {   a = (ns5__ArrayOfstring *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns5__ArrayOfstring, 0, sizeof(ns5__ArrayOfstring), 0, soap_copy_ns5__ArrayOfstring);
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    return a;
}

int ns5__ArrayOfstring::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
    register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns5__ArrayOfstring);
    if (this->soap_out(soap, tag?tag:"ns5:ArrayOfstring", id, type))
        return soap->error;
    return soap_putindependent(soap);
}

void *ns5__ArrayOfstring::soap_get(struct soap *soap, const char *tag, const char *type)
{
    return soap_get_ns5__ArrayOfstring(soap, this, tag, type);
}

SOAP_FMAC3 ns5__ArrayOfstring * SOAP_FMAC4 soap_get_ns5__ArrayOfstring(struct soap *soap, ns5__ArrayOfstring *p, const char *tag, const char *type)
{
    if ((p = soap_in_ns5__ArrayOfstring(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 ns5__ArrayOfstring * SOAP_FMAC2 soap_instantiate_ns5__ArrayOfstring(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns5__ArrayOfstring(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns5__ArrayOfstring, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(ns5__ArrayOfstring);
        if (size)
            *size = sizeof(ns5__ArrayOfstring);
        ((ns5__ArrayOfstring*)cp->ptr)->soap = soap;
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(ns5__ArrayOfstring, n);
        if (size)
            *size = n * sizeof(ns5__ArrayOfstring);
        if (cp->ptr)
            for (int i = 0; i < n; i++)
                ((ns5__ArrayOfstring*)cp->ptr)[i].soap = soap;
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (ns5__ArrayOfstring*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns5__ArrayOfstring(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns5__ArrayOfstring %p -> %p\n", q, p));
    *(ns5__ArrayOfstring*)p = *(ns5__ArrayOfstring*)q;
}

void _ns1__UploadSymbolResponse::soap_default(struct soap *soap)
{
    this->soap = soap;
    this->_ns1__UploadSymbolResponse::UploadSymbolResult = NULL;
    /* transient soap skipped */
}

void _ns1__UploadSymbolResponse::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
    (void)soap; /* appease -Wall -Werror */
    soap_serialize_PointerTostd__wstring(soap, &this->_ns1__UploadSymbolResponse::UploadSymbolResult);
    /* transient soap skipped */
#endif
}

int _ns1__UploadSymbolResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
    return soap_out__ns1__UploadSymbolResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__UploadSymbolResponse(struct soap *soap, const char *tag, int id, const _ns1__UploadSymbolResponse *a, const char *type)
{
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__UploadSymbolResponse), type))
        return soap->error;
    if (a->UploadSymbolResult)
        soap_element_result(soap, "ns1:UploadSymbolResult");
    if (soap_out_PointerTostd__wstring(soap, "ns1:UploadSymbolResult", -1, &(a->_ns1__UploadSymbolResponse::UploadSymbolResult), ""))
        return soap->error;
    /* transient soap skipped */
    return soap_element_end_out(soap, tag);
}

void *_ns1__UploadSymbolResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{   return soap_in__ns1__UploadSymbolResponse(soap, tag, this, type);
}

SOAP_FMAC3 _ns1__UploadSymbolResponse * SOAP_FMAC4 soap_in__ns1__UploadSymbolResponse(struct soap *soap, const char *tag, _ns1__UploadSymbolResponse *a, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    if (soap_element_begin_in(soap, tag, 0, NULL))
        return NULL;
    a = (_ns1__UploadSymbolResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__UploadSymbolResponse, sizeof(_ns1__UploadSymbolResponse), soap->type, soap->arrayType);
    if (!a)
        return NULL;
    if (soap->alloced)
    {   a->soap_default(soap);
        if (soap->clist->type != SOAP_TYPE__ns1__UploadSymbolResponse)
        {   soap_revert(soap);
            *soap->id = '\0';
            return (_ns1__UploadSymbolResponse *)a->soap_in(soap, tag, type);
        }
    }
    size_t soap_flag_UploadSymbolResult1 = 1;
    if (soap->body && !*soap->href)
    {
        for (;;)
        {   soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_UploadSymbolResult1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
                if (soap_in_PointerTostd__wstring(soap, "ns1:UploadSymbolResult", &(a->_ns1__UploadSymbolResponse::UploadSymbolResult), "xsd:string"))
                {   soap_flag_UploadSymbolResult1--;
                    continue;
                }
            /* transient soap skipped */
            soap_check_result(soap, "ns1:UploadSymbolResult");
            if (soap->error == SOAP_TAG_MISMATCH)
                soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
                break;
            if (soap->error)
                return NULL;
        }
        if (soap_element_end_in(soap, tag))
            return NULL;
    }
    else
    {   a = (_ns1__UploadSymbolResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__UploadSymbolResponse, 0, sizeof(_ns1__UploadSymbolResponse), 0, soap_copy__ns1__UploadSymbolResponse);
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    return a;
}

int _ns1__UploadSymbolResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
    register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ns1__UploadSymbolResponse);
    if (this->soap_out(soap, tag?tag:"ns1:UploadSymbolResponse", id, type))
        return soap->error;
    return soap_putindependent(soap);
}

void *_ns1__UploadSymbolResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
    return soap_get__ns1__UploadSymbolResponse(soap, this, tag, type);
}

SOAP_FMAC3 _ns1__UploadSymbolResponse * SOAP_FMAC4 soap_get__ns1__UploadSymbolResponse(struct soap *soap, _ns1__UploadSymbolResponse *p, const char *tag, const char *type)
{
    if ((p = soap_in__ns1__UploadSymbolResponse(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 _ns1__UploadSymbolResponse * SOAP_FMAC2 soap_instantiate__ns1__UploadSymbolResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ns1__UploadSymbolResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ns1__UploadSymbolResponse, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(_ns1__UploadSymbolResponse);
        if (size)
            *size = sizeof(_ns1__UploadSymbolResponse);
        ((_ns1__UploadSymbolResponse*)cp->ptr)->soap = soap;
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(_ns1__UploadSymbolResponse, n);
        if (size)
            *size = n * sizeof(_ns1__UploadSymbolResponse);
        if (cp->ptr)
            for (int i = 0; i < n; i++)
                ((_ns1__UploadSymbolResponse*)cp->ptr)[i].soap = soap;
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (_ns1__UploadSymbolResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__ns1__UploadSymbolResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ns1__UploadSymbolResponse %p -> %p\n", q, p));
    *(_ns1__UploadSymbolResponse*)p = *(_ns1__UploadSymbolResponse*)q;
}

void _ns1__UploadSymbol::soap_default(struct soap *soap)
{
    this->soap = soap;
    this->_ns1__UploadSymbol::client = NULL;
    this->_ns1__UploadSymbol::app = NULL;
    this->_ns1__UploadSymbol::publish = NULL;
    this->_ns1__UploadSymbol::sym = NULL;
    /* transient soap skipped */
}

void _ns1__UploadSymbol::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
    (void)soap; /* appease -Wall -Werror */
    soap_serialize_PointerTons1__ClientLib(soap, &this->_ns1__UploadSymbol::client);
    soap_serialize_PointerTons1__Application(soap, &this->_ns1__UploadSymbol::app);
    soap_serialize_PointerTobool(soap, &this->_ns1__UploadSymbol::publish);
    soap_serialize_PointerTo_xop__Include(soap, &this->_ns1__UploadSymbol::sym);
    /* transient soap skipped */
#endif
}

int _ns1__UploadSymbol::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
    return soap_out__ns1__UploadSymbol(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__UploadSymbol(struct soap *soap, const char *tag, int id, const _ns1__UploadSymbol *a, const char *type)
{
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__UploadSymbol), type))
        return soap->error;
    if (soap_out_PointerTons1__ClientLib(soap, "ns1:client", -1, &(a->_ns1__UploadSymbol::client), ""))
        return soap->error;
    if (soap_out_PointerTons1__Application(soap, "ns1:app", -1, &(a->_ns1__UploadSymbol::app), ""))
        return soap->error;
    if (soap_out_PointerTobool(soap, "ns1:publish", -1, &(a->_ns1__UploadSymbol::publish), ""))
        return soap->error;
    if (soap_out_PointerTo_xop__Include(soap, "ns1:sym", -1, &(a->_ns1__UploadSymbol::sym), ""))
        return soap->error;
    /* transient soap skipped */
    return soap_element_end_out(soap, tag);
}

void *_ns1__UploadSymbol::soap_in(struct soap *soap, const char *tag, const char *type)
{   return soap_in__ns1__UploadSymbol(soap, tag, this, type);
}

SOAP_FMAC3 _ns1__UploadSymbol * SOAP_FMAC4 soap_in__ns1__UploadSymbol(struct soap *soap, const char *tag, _ns1__UploadSymbol *a, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    if (soap_element_begin_in(soap, tag, 0, NULL))
        return NULL;
    a = (_ns1__UploadSymbol *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__UploadSymbol, sizeof(_ns1__UploadSymbol), soap->type, soap->arrayType);
    if (!a)
        return NULL;
    if (soap->alloced)
    {   a->soap_default(soap);
        if (soap->clist->type != SOAP_TYPE__ns1__UploadSymbol)
        {   soap_revert(soap);
            *soap->id = '\0';
            return (_ns1__UploadSymbol *)a->soap_in(soap, tag, type);
        }
    }
    size_t soap_flag_client1 = 1;
    size_t soap_flag_app1 = 1;
    size_t soap_flag_publish1 = 1;
    size_t soap_flag_sym1 = 1;
    if (soap->body && !*soap->href)
    {
        for (;;)
        {   soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_client1 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerTons1__ClientLib(soap, "ns1:client", &(a->_ns1__UploadSymbol::client), "ns1:ClientLib"))
                {   soap_flag_client1--;
                    continue;
                }
            if (soap_flag_app1 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerTons1__Application(soap, "ns1:app", &(a->_ns1__UploadSymbol::app), "ns1:Application"))
                {   soap_flag_app1--;
                    continue;
                }
            if (soap_flag_publish1 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerTobool(soap, "ns1:publish", &(a->_ns1__UploadSymbol::publish), "xsd:boolean"))
                {   soap_flag_publish1--;
                    continue;
                }
            if (soap_flag_sym1 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerTo_xop__Include(soap, "ns1:sym", &(a->_ns1__UploadSymbol::sym), ""))
                {   soap_flag_sym1--;
                    continue;
                }
            /* transient soap skipped */
            if (soap->error == SOAP_TAG_MISMATCH)
                soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
                break;
            if (soap->error)
                return NULL;
        }
        if (soap_element_end_in(soap, tag))
            return NULL;
    }
    else
    {   a = (_ns1__UploadSymbol *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__UploadSymbol, 0, sizeof(_ns1__UploadSymbol), 0, soap_copy__ns1__UploadSymbol);
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    return a;
}

int _ns1__UploadSymbol::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
    register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ns1__UploadSymbol);
    if (this->soap_out(soap, tag?tag:"ns1:UploadSymbol", id, type))
        return soap->error;
    return soap_putindependent(soap);
}

void *_ns1__UploadSymbol::soap_get(struct soap *soap, const char *tag, const char *type)
{
    return soap_get__ns1__UploadSymbol(soap, this, tag, type);
}

SOAP_FMAC3 _ns1__UploadSymbol * SOAP_FMAC4 soap_get__ns1__UploadSymbol(struct soap *soap, _ns1__UploadSymbol *p, const char *tag, const char *type)
{
    if ((p = soap_in__ns1__UploadSymbol(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 _ns1__UploadSymbol * SOAP_FMAC2 soap_instantiate__ns1__UploadSymbol(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ns1__UploadSymbol(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ns1__UploadSymbol, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(_ns1__UploadSymbol);
        if (size)
            *size = sizeof(_ns1__UploadSymbol);
        ((_ns1__UploadSymbol*)cp->ptr)->soap = soap;
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(_ns1__UploadSymbol, n);
        if (size)
            *size = n * sizeof(_ns1__UploadSymbol);
        if (cp->ptr)
            for (int i = 0; i < n; i++)
                ((_ns1__UploadSymbol*)cp->ptr)[i].soap = soap;
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (_ns1__UploadSymbol*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__ns1__UploadSymbol(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ns1__UploadSymbol %p -> %p\n", q, p));
    *(_ns1__UploadSymbol*)p = *(_ns1__UploadSymbol*)q;
}

void _ns1__RejectedToSendAdditionalInfoResponse::soap_default(struct soap *soap)
{
    this->soap = soap;
    this->_ns1__RejectedToSendAdditionalInfoResponse::RejectedToSendAdditionalInfoResult = NULL;
    /* transient soap skipped */
}

void _ns1__RejectedToSendAdditionalInfoResponse::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
    (void)soap; /* appease -Wall -Werror */
    soap_serialize_PointerTons1__Response(soap, &this->_ns1__RejectedToSendAdditionalInfoResponse::RejectedToSendAdditionalInfoResult);
    /* transient soap skipped */
#endif
}

int _ns1__RejectedToSendAdditionalInfoResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
    return soap_out__ns1__RejectedToSendAdditionalInfoResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__RejectedToSendAdditionalInfoResponse(struct soap *soap, const char *tag, int id, const _ns1__RejectedToSendAdditionalInfoResponse *a, const char *type)
{
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__RejectedToSendAdditionalInfoResponse), type))
        return soap->error;
    if (a->RejectedToSendAdditionalInfoResult)
        soap_element_result(soap, "ns1:RejectedToSendAdditionalInfoResult");
    if (soap_out_PointerTons1__Response(soap, "ns1:RejectedToSendAdditionalInfoResult", -1, &(a->_ns1__RejectedToSendAdditionalInfoResponse::RejectedToSendAdditionalInfoResult), ""))
        return soap->error;
    /* transient soap skipped */
    return soap_element_end_out(soap, tag);
}

void *_ns1__RejectedToSendAdditionalInfoResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{   return soap_in__ns1__RejectedToSendAdditionalInfoResponse(soap, tag, this, type);
}

SOAP_FMAC3 _ns1__RejectedToSendAdditionalInfoResponse * SOAP_FMAC4 soap_in__ns1__RejectedToSendAdditionalInfoResponse(struct soap *soap, const char *tag, _ns1__RejectedToSendAdditionalInfoResponse *a, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    if (soap_element_begin_in(soap, tag, 0, NULL))
        return NULL;
    a = (_ns1__RejectedToSendAdditionalInfoResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__RejectedToSendAdditionalInfoResponse, sizeof(_ns1__RejectedToSendAdditionalInfoResponse), soap->type, soap->arrayType);
    if (!a)
        return NULL;
    if (soap->alloced)
    {   a->soap_default(soap);
        if (soap->clist->type != SOAP_TYPE__ns1__RejectedToSendAdditionalInfoResponse)
        {   soap_revert(soap);
            *soap->id = '\0';
            return (_ns1__RejectedToSendAdditionalInfoResponse *)a->soap_in(soap, tag, type);
        }
    }
    size_t soap_flag_RejectedToSendAdditionalInfoResult1 = 1;
    if (soap->body && !*soap->href)
    {
        for (;;)
        {   soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_RejectedToSendAdditionalInfoResult1 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerTons1__Response(soap, "ns1:RejectedToSendAdditionalInfoResult", &(a->_ns1__RejectedToSendAdditionalInfoResponse::RejectedToSendAdditionalInfoResult), "ns1:Response"))
                {   soap_flag_RejectedToSendAdditionalInfoResult1--;
                    continue;
                }
            /* transient soap skipped */
            soap_check_result(soap, "ns1:RejectedToSendAdditionalInfoResult");
            if (soap->error == SOAP_TAG_MISMATCH)
                soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
                break;
            if (soap->error)
                return NULL;
        }
        if (soap_element_end_in(soap, tag))
            return NULL;
    }
    else
    {   a = (_ns1__RejectedToSendAdditionalInfoResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__RejectedToSendAdditionalInfoResponse, 0, sizeof(_ns1__RejectedToSendAdditionalInfoResponse), 0, soap_copy__ns1__RejectedToSendAdditionalInfoResponse);
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    return a;
}

int _ns1__RejectedToSendAdditionalInfoResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
    register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ns1__RejectedToSendAdditionalInfoResponse);
    if (this->soap_out(soap, tag?tag:"ns1:RejectedToSendAdditionalInfoResponse", id, type))
        return soap->error;
    return soap_putindependent(soap);
}

void *_ns1__RejectedToSendAdditionalInfoResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
    return soap_get__ns1__RejectedToSendAdditionalInfoResponse(soap, this, tag, type);
}

SOAP_FMAC3 _ns1__RejectedToSendAdditionalInfoResponse * SOAP_FMAC4 soap_get__ns1__RejectedToSendAdditionalInfoResponse(struct soap *soap, _ns1__RejectedToSendAdditionalInfoResponse *p, const char *tag, const char *type)
{
    if ((p = soap_in__ns1__RejectedToSendAdditionalInfoResponse(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 _ns1__RejectedToSendAdditionalInfoResponse * SOAP_FMAC2 soap_instantiate__ns1__RejectedToSendAdditionalInfoResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ns1__RejectedToSendAdditionalInfoResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ns1__RejectedToSendAdditionalInfoResponse, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(_ns1__RejectedToSendAdditionalInfoResponse);
        if (size)
            *size = sizeof(_ns1__RejectedToSendAdditionalInfoResponse);
        ((_ns1__RejectedToSendAdditionalInfoResponse*)cp->ptr)->soap = soap;
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(_ns1__RejectedToSendAdditionalInfoResponse, n);
        if (size)
            *size = n * sizeof(_ns1__RejectedToSendAdditionalInfoResponse);
        if (cp->ptr)
            for (int i = 0; i < n; i++)
                ((_ns1__RejectedToSendAdditionalInfoResponse*)cp->ptr)[i].soap = soap;
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (_ns1__RejectedToSendAdditionalInfoResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__ns1__RejectedToSendAdditionalInfoResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ns1__RejectedToSendAdditionalInfoResponse %p -> %p\n", q, p));
    *(_ns1__RejectedToSendAdditionalInfoResponse*)p = *(_ns1__RejectedToSendAdditionalInfoResponse*)q;
}

void _ns1__RejectedToSendAdditionalInfo::soap_default(struct soap *soap)
{
    this->soap = soap;
    this->_ns1__RejectedToSendAdditionalInfo::client = NULL;
    this->_ns1__RejectedToSendAdditionalInfo::app = NULL;
    this->_ns1__RejectedToSendAdditionalInfo::miniDumpID = NULL;
    this->_ns1__RejectedToSendAdditionalInfo::context = NULL;
    /* transient soap skipped */
}

void _ns1__RejectedToSendAdditionalInfo::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
    (void)soap; /* appease -Wall -Werror */
    soap_serialize_PointerTons1__ClientLib(soap, &this->_ns1__RejectedToSendAdditionalInfo::client);
    soap_serialize_PointerTons1__Application(soap, &this->_ns1__RejectedToSendAdditionalInfo::app);
    soap_serialize_PointerToint(soap, &this->_ns1__RejectedToSendAdditionalInfo::miniDumpID);
    soap_serialize_PointerTo_xop__Include(soap, &this->_ns1__RejectedToSendAdditionalInfo::context);
    /* transient soap skipped */
#endif
}

int _ns1__RejectedToSendAdditionalInfo::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
    return soap_out__ns1__RejectedToSendAdditionalInfo(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__RejectedToSendAdditionalInfo(struct soap *soap, const char *tag, int id, const _ns1__RejectedToSendAdditionalInfo *a, const char *type)
{
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__RejectedToSendAdditionalInfo), type))
        return soap->error;
    if (soap_out_PointerTons1__ClientLib(soap, "ns1:client", -1, &(a->_ns1__RejectedToSendAdditionalInfo::client), ""))
        return soap->error;
    if (soap_out_PointerTons1__Application(soap, "ns1:app", -1, &(a->_ns1__RejectedToSendAdditionalInfo::app), ""))
        return soap->error;
    if (soap_out_PointerToint(soap, "ns1:miniDumpID", -1, &(a->_ns1__RejectedToSendAdditionalInfo::miniDumpID), ""))
        return soap->error;
    if (soap_out_PointerTo_xop__Include(soap, "ns1:context", -1, &(a->_ns1__RejectedToSendAdditionalInfo::context), ""))
        return soap->error;
    /* transient soap skipped */
    return soap_element_end_out(soap, tag);
}

void *_ns1__RejectedToSendAdditionalInfo::soap_in(struct soap *soap, const char *tag, const char *type)
{   return soap_in__ns1__RejectedToSendAdditionalInfo(soap, tag, this, type);
}

SOAP_FMAC3 _ns1__RejectedToSendAdditionalInfo * SOAP_FMAC4 soap_in__ns1__RejectedToSendAdditionalInfo(struct soap *soap, const char *tag, _ns1__RejectedToSendAdditionalInfo *a, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    if (soap_element_begin_in(soap, tag, 0, NULL))
        return NULL;
    a = (_ns1__RejectedToSendAdditionalInfo *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__RejectedToSendAdditionalInfo, sizeof(_ns1__RejectedToSendAdditionalInfo), soap->type, soap->arrayType);
    if (!a)
        return NULL;
    if (soap->alloced)
    {   a->soap_default(soap);
        if (soap->clist->type != SOAP_TYPE__ns1__RejectedToSendAdditionalInfo)
        {   soap_revert(soap);
            *soap->id = '\0';
            return (_ns1__RejectedToSendAdditionalInfo *)a->soap_in(soap, tag, type);
        }
    }
    size_t soap_flag_client1 = 1;
    size_t soap_flag_app1 = 1;
    size_t soap_flag_miniDumpID1 = 1;
    size_t soap_flag_context1 = 1;
    if (soap->body && !*soap->href)
    {
        for (;;)
        {   soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_client1 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerTons1__ClientLib(soap, "ns1:client", &(a->_ns1__RejectedToSendAdditionalInfo::client), "ns1:ClientLib"))
                {   soap_flag_client1--;
                    continue;
                }
            if (soap_flag_app1 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerTons1__Application(soap, "ns1:app", &(a->_ns1__RejectedToSendAdditionalInfo::app), "ns1:Application"))
                {   soap_flag_app1--;
                    continue;
                }
            if (soap_flag_miniDumpID1 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerToint(soap, "ns1:miniDumpID", &(a->_ns1__RejectedToSendAdditionalInfo::miniDumpID), "xsd:int"))
                {   soap_flag_miniDumpID1--;
                    continue;
                }
            if (soap_flag_context1 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerTo_xop__Include(soap, "ns1:context", &(a->_ns1__RejectedToSendAdditionalInfo::context), ""))
                {   soap_flag_context1--;
                    continue;
                }
            /* transient soap skipped */
            if (soap->error == SOAP_TAG_MISMATCH)
                soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
                break;
            if (soap->error)
                return NULL;
        }
        if (soap_element_end_in(soap, tag))
            return NULL;
    }
    else
    {   a = (_ns1__RejectedToSendAdditionalInfo *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__RejectedToSendAdditionalInfo, 0, sizeof(_ns1__RejectedToSendAdditionalInfo), 0, soap_copy__ns1__RejectedToSendAdditionalInfo);
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    return a;
}

int _ns1__RejectedToSendAdditionalInfo::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
    register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ns1__RejectedToSendAdditionalInfo);
    if (this->soap_out(soap, tag?tag:"ns1:RejectedToSendAdditionalInfo", id, type))
        return soap->error;
    return soap_putindependent(soap);
}

void *_ns1__RejectedToSendAdditionalInfo::soap_get(struct soap *soap, const char *tag, const char *type)
{
    return soap_get__ns1__RejectedToSendAdditionalInfo(soap, this, tag, type);
}

SOAP_FMAC3 _ns1__RejectedToSendAdditionalInfo * SOAP_FMAC4 soap_get__ns1__RejectedToSendAdditionalInfo(struct soap *soap, _ns1__RejectedToSendAdditionalInfo *p, const char *tag, const char *type)
{
    if ((p = soap_in__ns1__RejectedToSendAdditionalInfo(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 _ns1__RejectedToSendAdditionalInfo * SOAP_FMAC2 soap_instantiate__ns1__RejectedToSendAdditionalInfo(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ns1__RejectedToSendAdditionalInfo(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ns1__RejectedToSendAdditionalInfo, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(_ns1__RejectedToSendAdditionalInfo);
        if (size)
            *size = sizeof(_ns1__RejectedToSendAdditionalInfo);
        ((_ns1__RejectedToSendAdditionalInfo*)cp->ptr)->soap = soap;
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(_ns1__RejectedToSendAdditionalInfo, n);
        if (size)
            *size = n * sizeof(_ns1__RejectedToSendAdditionalInfo);
        if (cp->ptr)
            for (int i = 0; i < n; i++)
                ((_ns1__RejectedToSendAdditionalInfo*)cp->ptr)[i].soap = soap;
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (_ns1__RejectedToSendAdditionalInfo*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__ns1__RejectedToSendAdditionalInfo(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ns1__RejectedToSendAdditionalInfo %p -> %p\n", q, p));
    *(_ns1__RejectedToSendAdditionalInfo*)p = *(_ns1__RejectedToSendAdditionalInfo*)q;
}

void _ns1__UploadAdditionalInfoResponse::soap_default(struct soap *soap)
{
    this->soap = soap;
    this->_ns1__UploadAdditionalInfoResponse::UploadAdditionalInfoResult = NULL;
    /* transient soap skipped */
}

void _ns1__UploadAdditionalInfoResponse::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
    (void)soap; /* appease -Wall -Werror */
    soap_serialize_PointerTons1__Response(soap, &this->_ns1__UploadAdditionalInfoResponse::UploadAdditionalInfoResult);
    /* transient soap skipped */
#endif
}

int _ns1__UploadAdditionalInfoResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
    return soap_out__ns1__UploadAdditionalInfoResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__UploadAdditionalInfoResponse(struct soap *soap, const char *tag, int id, const _ns1__UploadAdditionalInfoResponse *a, const char *type)
{
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__UploadAdditionalInfoResponse), type))
        return soap->error;
    if (a->UploadAdditionalInfoResult)
        soap_element_result(soap, "ns1:UploadAdditionalInfoResult");
    if (soap_out_PointerTons1__Response(soap, "ns1:UploadAdditionalInfoResult", -1, &(a->_ns1__UploadAdditionalInfoResponse::UploadAdditionalInfoResult), ""))
        return soap->error;
    /* transient soap skipped */
    return soap_element_end_out(soap, tag);
}

void *_ns1__UploadAdditionalInfoResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{   return soap_in__ns1__UploadAdditionalInfoResponse(soap, tag, this, type);
}

SOAP_FMAC3 _ns1__UploadAdditionalInfoResponse * SOAP_FMAC4 soap_in__ns1__UploadAdditionalInfoResponse(struct soap *soap, const char *tag, _ns1__UploadAdditionalInfoResponse *a, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    if (soap_element_begin_in(soap, tag, 0, NULL))
        return NULL;
    a = (_ns1__UploadAdditionalInfoResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__UploadAdditionalInfoResponse, sizeof(_ns1__UploadAdditionalInfoResponse), soap->type, soap->arrayType);
    if (!a)
        return NULL;
    if (soap->alloced)
    {   a->soap_default(soap);
        if (soap->clist->type != SOAP_TYPE__ns1__UploadAdditionalInfoResponse)
        {   soap_revert(soap);
            *soap->id = '\0';
            return (_ns1__UploadAdditionalInfoResponse *)a->soap_in(soap, tag, type);
        }
    }
    size_t soap_flag_UploadAdditionalInfoResult1 = 1;
    if (soap->body && !*soap->href)
    {
        for (;;)
        {   soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_UploadAdditionalInfoResult1 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerTons1__Response(soap, "ns1:UploadAdditionalInfoResult", &(a->_ns1__UploadAdditionalInfoResponse::UploadAdditionalInfoResult), "ns1:Response"))
                {   soap_flag_UploadAdditionalInfoResult1--;
                    continue;
                }
            /* transient soap skipped */
            soap_check_result(soap, "ns1:UploadAdditionalInfoResult");
            if (soap->error == SOAP_TAG_MISMATCH)
                soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
                break;
            if (soap->error)
                return NULL;
        }
        if (soap_element_end_in(soap, tag))
            return NULL;
    }
    else
    {   a = (_ns1__UploadAdditionalInfoResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__UploadAdditionalInfoResponse, 0, sizeof(_ns1__UploadAdditionalInfoResponse), 0, soap_copy__ns1__UploadAdditionalInfoResponse);
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    return a;
}

int _ns1__UploadAdditionalInfoResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
    register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ns1__UploadAdditionalInfoResponse);
    if (this->soap_out(soap, tag?tag:"ns1:UploadAdditionalInfoResponse", id, type))
        return soap->error;
    return soap_putindependent(soap);
}

void *_ns1__UploadAdditionalInfoResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
    return soap_get__ns1__UploadAdditionalInfoResponse(soap, this, tag, type);
}

SOAP_FMAC3 _ns1__UploadAdditionalInfoResponse * SOAP_FMAC4 soap_get__ns1__UploadAdditionalInfoResponse(struct soap *soap, _ns1__UploadAdditionalInfoResponse *p, const char *tag, const char *type)
{
    if ((p = soap_in__ns1__UploadAdditionalInfoResponse(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 _ns1__UploadAdditionalInfoResponse * SOAP_FMAC2 soap_instantiate__ns1__UploadAdditionalInfoResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ns1__UploadAdditionalInfoResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ns1__UploadAdditionalInfoResponse, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(_ns1__UploadAdditionalInfoResponse);
        if (size)
            *size = sizeof(_ns1__UploadAdditionalInfoResponse);
        ((_ns1__UploadAdditionalInfoResponse*)cp->ptr)->soap = soap;
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(_ns1__UploadAdditionalInfoResponse, n);
        if (size)
            *size = n * sizeof(_ns1__UploadAdditionalInfoResponse);
        if (cp->ptr)
            for (int i = 0; i < n; i++)
                ((_ns1__UploadAdditionalInfoResponse*)cp->ptr)[i].soap = soap;
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (_ns1__UploadAdditionalInfoResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__ns1__UploadAdditionalInfoResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ns1__UploadAdditionalInfoResponse %p -> %p\n", q, p));
    *(_ns1__UploadAdditionalInfoResponse*)p = *(_ns1__UploadAdditionalInfoResponse*)q;
}

void _ns1__UploadAdditionalInfo::soap_default(struct soap *soap)
{
    this->soap = soap;
    this->_ns1__UploadAdditionalInfo::client = NULL;
    this->_ns1__UploadAdditionalInfo::app = NULL;
    this->_ns1__UploadAdditionalInfo::miniDumpID = NULL;
    this->_ns1__UploadAdditionalInfo::info = NULL;
    this->_ns1__UploadAdditionalInfo::context = NULL;
    /* transient soap skipped */
}

void _ns1__UploadAdditionalInfo::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
    (void)soap; /* appease -Wall -Werror */
    soap_serialize_PointerTons1__ClientLib(soap, &this->_ns1__UploadAdditionalInfo::client);
    soap_serialize_PointerTons1__Application(soap, &this->_ns1__UploadAdditionalInfo::app);
    soap_serialize_PointerToint(soap, &this->_ns1__UploadAdditionalInfo::miniDumpID);
    soap_serialize_PointerTo_xop__Include(soap, &this->_ns1__UploadAdditionalInfo::info);
    soap_serialize_PointerTo_xop__Include(soap, &this->_ns1__UploadAdditionalInfo::context);
    /* transient soap skipped */
#endif
}

int _ns1__UploadAdditionalInfo::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
    return soap_out__ns1__UploadAdditionalInfo(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__UploadAdditionalInfo(struct soap *soap, const char *tag, int id, const _ns1__UploadAdditionalInfo *a, const char *type)
{
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__UploadAdditionalInfo), type))
        return soap->error;
    if (soap_out_PointerTons1__ClientLib(soap, "ns1:client", -1, &(a->_ns1__UploadAdditionalInfo::client), ""))
        return soap->error;
    if (soap_out_PointerTons1__Application(soap, "ns1:app", -1, &(a->_ns1__UploadAdditionalInfo::app), ""))
        return soap->error;
    if (soap_out_PointerToint(soap, "ns1:miniDumpID", -1, &(a->_ns1__UploadAdditionalInfo::miniDumpID), ""))
        return soap->error;
    if (soap_out_PointerTo_xop__Include(soap, "ns1:info", -1, &(a->_ns1__UploadAdditionalInfo::info), ""))
        return soap->error;
    if (soap_out_PointerTo_xop__Include(soap, "ns1:context", -1, &(a->_ns1__UploadAdditionalInfo::context), ""))
        return soap->error;
    /* transient soap skipped */
    return soap_element_end_out(soap, tag);
}

void *_ns1__UploadAdditionalInfo::soap_in(struct soap *soap, const char *tag, const char *type)
{   return soap_in__ns1__UploadAdditionalInfo(soap, tag, this, type);
}

SOAP_FMAC3 _ns1__UploadAdditionalInfo * SOAP_FMAC4 soap_in__ns1__UploadAdditionalInfo(struct soap *soap, const char *tag, _ns1__UploadAdditionalInfo *a, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    if (soap_element_begin_in(soap, tag, 0, NULL))
        return NULL;
    a = (_ns1__UploadAdditionalInfo *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__UploadAdditionalInfo, sizeof(_ns1__UploadAdditionalInfo), soap->type, soap->arrayType);
    if (!a)
        return NULL;
    if (soap->alloced)
    {   a->soap_default(soap);
        if (soap->clist->type != SOAP_TYPE__ns1__UploadAdditionalInfo)
        {   soap_revert(soap);
            *soap->id = '\0';
            return (_ns1__UploadAdditionalInfo *)a->soap_in(soap, tag, type);
        }
    }
    size_t soap_flag_client1 = 1;
    size_t soap_flag_app1 = 1;
    size_t soap_flag_miniDumpID1 = 1;
    size_t soap_flag_info1 = 1;
    size_t soap_flag_context1 = 1;
    if (soap->body && !*soap->href)
    {
        for (;;)
        {   soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_client1 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerTons1__ClientLib(soap, "ns1:client", &(a->_ns1__UploadAdditionalInfo::client), "ns1:ClientLib"))
                {   soap_flag_client1--;
                    continue;
                }
            if (soap_flag_app1 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerTons1__Application(soap, "ns1:app", &(a->_ns1__UploadAdditionalInfo::app), "ns1:Application"))
                {   soap_flag_app1--;
                    continue;
                }
            if (soap_flag_miniDumpID1 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerToint(soap, "ns1:miniDumpID", &(a->_ns1__UploadAdditionalInfo::miniDumpID), "xsd:int"))
                {   soap_flag_miniDumpID1--;
                    continue;
                }
            if (soap_flag_info1 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerTo_xop__Include(soap, "ns1:info", &(a->_ns1__UploadAdditionalInfo::info), ""))
                {   soap_flag_info1--;
                    continue;
                }
            if (soap_flag_context1 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerTo_xop__Include(soap, "ns1:context", &(a->_ns1__UploadAdditionalInfo::context), ""))
                {   soap_flag_context1--;
                    continue;
                }
            /* transient soap skipped */
            if (soap->error == SOAP_TAG_MISMATCH)
                soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
                break;
            if (soap->error)
                return NULL;
        }
        if (soap_element_end_in(soap, tag))
            return NULL;
    }
    else
    {   a = (_ns1__UploadAdditionalInfo *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__UploadAdditionalInfo, 0, sizeof(_ns1__UploadAdditionalInfo), 0, soap_copy__ns1__UploadAdditionalInfo);
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    return a;
}

int _ns1__UploadAdditionalInfo::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
    register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ns1__UploadAdditionalInfo);
    if (this->soap_out(soap, tag?tag:"ns1:UploadAdditionalInfo", id, type))
        return soap->error;
    return soap_putindependent(soap);
}

void *_ns1__UploadAdditionalInfo::soap_get(struct soap *soap, const char *tag, const char *type)
{
    return soap_get__ns1__UploadAdditionalInfo(soap, this, tag, type);
}

SOAP_FMAC3 _ns1__UploadAdditionalInfo * SOAP_FMAC4 soap_get__ns1__UploadAdditionalInfo(struct soap *soap, _ns1__UploadAdditionalInfo *p, const char *tag, const char *type)
{
    if ((p = soap_in__ns1__UploadAdditionalInfo(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 _ns1__UploadAdditionalInfo * SOAP_FMAC2 soap_instantiate__ns1__UploadAdditionalInfo(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ns1__UploadAdditionalInfo(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ns1__UploadAdditionalInfo, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(_ns1__UploadAdditionalInfo);
        if (size)
            *size = sizeof(_ns1__UploadAdditionalInfo);
        ((_ns1__UploadAdditionalInfo*)cp->ptr)->soap = soap;
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(_ns1__UploadAdditionalInfo, n);
        if (size)
            *size = n * sizeof(_ns1__UploadAdditionalInfo);
        if (cp->ptr)
            for (int i = 0; i < n; i++)
                ((_ns1__UploadAdditionalInfo*)cp->ptr)[i].soap = soap;
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (_ns1__UploadAdditionalInfo*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__ns1__UploadAdditionalInfo(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ns1__UploadAdditionalInfo %p -> %p\n", q, p));
    *(_ns1__UploadAdditionalInfo*)p = *(_ns1__UploadAdditionalInfo*)q;
}

void _ns1__UploadFullDumpResponse::soap_default(struct soap *soap)
{
    this->soap = soap;
    this->_ns1__UploadFullDumpResponse::UploadFullDumpResult = NULL;
    /* transient soap skipped */
}

void _ns1__UploadFullDumpResponse::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
    (void)soap; /* appease -Wall -Werror */
    soap_serialize_PointerTons1__Response(soap, &this->_ns1__UploadFullDumpResponse::UploadFullDumpResult);
    /* transient soap skipped */
#endif
}

int _ns1__UploadFullDumpResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
    return soap_out__ns1__UploadFullDumpResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__UploadFullDumpResponse(struct soap *soap, const char *tag, int id, const _ns1__UploadFullDumpResponse *a, const char *type)
{
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__UploadFullDumpResponse), type))
        return soap->error;
    if (a->UploadFullDumpResult)
        soap_element_result(soap, "ns1:UploadFullDumpResult");
    if (soap_out_PointerTons1__Response(soap, "ns1:UploadFullDumpResult", -1, &(a->_ns1__UploadFullDumpResponse::UploadFullDumpResult), ""))
        return soap->error;
    /* transient soap skipped */
    return soap_element_end_out(soap, tag);
}

void *_ns1__UploadFullDumpResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{   return soap_in__ns1__UploadFullDumpResponse(soap, tag, this, type);
}

SOAP_FMAC3 _ns1__UploadFullDumpResponse * SOAP_FMAC4 soap_in__ns1__UploadFullDumpResponse(struct soap *soap, const char *tag, _ns1__UploadFullDumpResponse *a, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    if (soap_element_begin_in(soap, tag, 0, NULL))
        return NULL;
    a = (_ns1__UploadFullDumpResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__UploadFullDumpResponse, sizeof(_ns1__UploadFullDumpResponse), soap->type, soap->arrayType);
    if (!a)
        return NULL;
    if (soap->alloced)
    {   a->soap_default(soap);
        if (soap->clist->type != SOAP_TYPE__ns1__UploadFullDumpResponse)
        {   soap_revert(soap);
            *soap->id = '\0';
            return (_ns1__UploadFullDumpResponse *)a->soap_in(soap, tag, type);
        }
    }
    size_t soap_flag_UploadFullDumpResult1 = 1;
    if (soap->body && !*soap->href)
    {
        for (;;)
        {   soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_UploadFullDumpResult1 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerTons1__Response(soap, "ns1:UploadFullDumpResult", &(a->_ns1__UploadFullDumpResponse::UploadFullDumpResult), "ns1:Response"))
                {   soap_flag_UploadFullDumpResult1--;
                    continue;
                }
            /* transient soap skipped */
            soap_check_result(soap, "ns1:UploadFullDumpResult");
            if (soap->error == SOAP_TAG_MISMATCH)
                soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
                break;
            if (soap->error)
                return NULL;
        }
        if (soap_element_end_in(soap, tag))
            return NULL;
    }
    else
    {   a = (_ns1__UploadFullDumpResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__UploadFullDumpResponse, 0, sizeof(_ns1__UploadFullDumpResponse), 0, soap_copy__ns1__UploadFullDumpResponse);
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    return a;
}

int _ns1__UploadFullDumpResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
    register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ns1__UploadFullDumpResponse);
    if (this->soap_out(soap, tag?tag:"ns1:UploadFullDumpResponse", id, type))
        return soap->error;
    return soap_putindependent(soap);
}

void *_ns1__UploadFullDumpResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
    return soap_get__ns1__UploadFullDumpResponse(soap, this, tag, type);
}

SOAP_FMAC3 _ns1__UploadFullDumpResponse * SOAP_FMAC4 soap_get__ns1__UploadFullDumpResponse(struct soap *soap, _ns1__UploadFullDumpResponse *p, const char *tag, const char *type)
{
    if ((p = soap_in__ns1__UploadFullDumpResponse(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 _ns1__UploadFullDumpResponse * SOAP_FMAC2 soap_instantiate__ns1__UploadFullDumpResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ns1__UploadFullDumpResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ns1__UploadFullDumpResponse, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(_ns1__UploadFullDumpResponse);
        if (size)
            *size = sizeof(_ns1__UploadFullDumpResponse);
        ((_ns1__UploadFullDumpResponse*)cp->ptr)->soap = soap;
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(_ns1__UploadFullDumpResponse, n);
        if (size)
            *size = n * sizeof(_ns1__UploadFullDumpResponse);
        if (cp->ptr)
            for (int i = 0; i < n; i++)
                ((_ns1__UploadFullDumpResponse*)cp->ptr)[i].soap = soap;
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (_ns1__UploadFullDumpResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__ns1__UploadFullDumpResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ns1__UploadFullDumpResponse %p -> %p\n", q, p));
    *(_ns1__UploadFullDumpResponse*)p = *(_ns1__UploadFullDumpResponse*)q;
}

void _ns1__UploadFullDump::soap_default(struct soap *soap)
{
    this->soap = soap;
    this->_ns1__UploadFullDump::client = NULL;
    this->_ns1__UploadFullDump::app = NULL;
    this->_ns1__UploadFullDump::miniDumpID = NULL;
    this->_ns1__UploadFullDump::dumpInZip = NULL;
    this->_ns1__UploadFullDump::context = NULL;
    /* transient soap skipped */
}

void _ns1__UploadFullDump::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
    (void)soap; /* appease -Wall -Werror */
    soap_serialize_PointerTons1__ClientLib(soap, &this->_ns1__UploadFullDump::client);
    soap_serialize_PointerTons1__Application(soap, &this->_ns1__UploadFullDump::app);
    soap_serialize_PointerToint(soap, &this->_ns1__UploadFullDump::miniDumpID);
    soap_serialize_PointerTo_xop__Include(soap, &this->_ns1__UploadFullDump::dumpInZip);
    soap_serialize_PointerTo_xop__Include(soap, &this->_ns1__UploadFullDump::context);
    /* transient soap skipped */
#endif
}

int _ns1__UploadFullDump::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
    return soap_out__ns1__UploadFullDump(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__UploadFullDump(struct soap *soap, const char *tag, int id, const _ns1__UploadFullDump *a, const char *type)
{
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__UploadFullDump), type))
        return soap->error;
    if (soap_out_PointerTons1__ClientLib(soap, "ns1:client", -1, &(a->_ns1__UploadFullDump::client), ""))
        return soap->error;
    if (soap_out_PointerTons1__Application(soap, "ns1:app", -1, &(a->_ns1__UploadFullDump::app), ""))
        return soap->error;
    if (soap_out_PointerToint(soap, "ns1:miniDumpID", -1, &(a->_ns1__UploadFullDump::miniDumpID), ""))
        return soap->error;
    if (soap_out_PointerTo_xop__Include(soap, "ns1:dumpInZip", -1, &(a->_ns1__UploadFullDump::dumpInZip), ""))
        return soap->error;
    if (soap_out_PointerTo_xop__Include(soap, "ns1:context", -1, &(a->_ns1__UploadFullDump::context), ""))
        return soap->error;
    /* transient soap skipped */
    return soap_element_end_out(soap, tag);
}

void *_ns1__UploadFullDump::soap_in(struct soap *soap, const char *tag, const char *type)
{   return soap_in__ns1__UploadFullDump(soap, tag, this, type);
}

SOAP_FMAC3 _ns1__UploadFullDump * SOAP_FMAC4 soap_in__ns1__UploadFullDump(struct soap *soap, const char *tag, _ns1__UploadFullDump *a, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    if (soap_element_begin_in(soap, tag, 0, NULL))
        return NULL;
    a = (_ns1__UploadFullDump *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__UploadFullDump, sizeof(_ns1__UploadFullDump), soap->type, soap->arrayType);
    if (!a)
        return NULL;
    if (soap->alloced)
    {   a->soap_default(soap);
        if (soap->clist->type != SOAP_TYPE__ns1__UploadFullDump)
        {   soap_revert(soap);
            *soap->id = '\0';
            return (_ns1__UploadFullDump *)a->soap_in(soap, tag, type);
        }
    }
    size_t soap_flag_client1 = 1;
    size_t soap_flag_app1 = 1;
    size_t soap_flag_miniDumpID1 = 1;
    size_t soap_flag_dumpInZip1 = 1;
    size_t soap_flag_context1 = 1;
    if (soap->body && !*soap->href)
    {
        for (;;)
        {   soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_client1 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerTons1__ClientLib(soap, "ns1:client", &(a->_ns1__UploadFullDump::client), "ns1:ClientLib"))
                {   soap_flag_client1--;
                    continue;
                }
            if (soap_flag_app1 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerTons1__Application(soap, "ns1:app", &(a->_ns1__UploadFullDump::app), "ns1:Application"))
                {   soap_flag_app1--;
                    continue;
                }
            if (soap_flag_miniDumpID1 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerToint(soap, "ns1:miniDumpID", &(a->_ns1__UploadFullDump::miniDumpID), "xsd:int"))
                {   soap_flag_miniDumpID1--;
                    continue;
                }
            if (soap_flag_dumpInZip1 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerTo_xop__Include(soap, "ns1:dumpInZip", &(a->_ns1__UploadFullDump::dumpInZip), ""))
                {   soap_flag_dumpInZip1--;
                    continue;
                }
            if (soap_flag_context1 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerTo_xop__Include(soap, "ns1:context", &(a->_ns1__UploadFullDump::context), ""))
                {   soap_flag_context1--;
                    continue;
                }
            /* transient soap skipped */
            if (soap->error == SOAP_TAG_MISMATCH)
                soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
                break;
            if (soap->error)
                return NULL;
        }
        if (soap_element_end_in(soap, tag))
            return NULL;
    }
    else
    {   a = (_ns1__UploadFullDump *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__UploadFullDump, 0, sizeof(_ns1__UploadFullDump), 0, soap_copy__ns1__UploadFullDump);
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    return a;
}

int _ns1__UploadFullDump::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
    register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ns1__UploadFullDump);
    if (this->soap_out(soap, tag?tag:"ns1:UploadFullDump", id, type))
        return soap->error;
    return soap_putindependent(soap);
}

void *_ns1__UploadFullDump::soap_get(struct soap *soap, const char *tag, const char *type)
{
    return soap_get__ns1__UploadFullDump(soap, this, tag, type);
}

SOAP_FMAC3 _ns1__UploadFullDump * SOAP_FMAC4 soap_get__ns1__UploadFullDump(struct soap *soap, _ns1__UploadFullDump *p, const char *tag, const char *type)
{
    if ((p = soap_in__ns1__UploadFullDump(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 _ns1__UploadFullDump * SOAP_FMAC2 soap_instantiate__ns1__UploadFullDump(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ns1__UploadFullDump(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ns1__UploadFullDump, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(_ns1__UploadFullDump);
        if (size)
            *size = sizeof(_ns1__UploadFullDump);
        ((_ns1__UploadFullDump*)cp->ptr)->soap = soap;
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(_ns1__UploadFullDump, n);
        if (size)
            *size = n * sizeof(_ns1__UploadFullDump);
        if (cp->ptr)
            for (int i = 0; i < n; i++)
                ((_ns1__UploadFullDump*)cp->ptr)[i].soap = soap;
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (_ns1__UploadFullDump*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__ns1__UploadFullDump(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ns1__UploadFullDump %p -> %p\n", q, p));
    *(_ns1__UploadFullDump*)p = *(_ns1__UploadFullDump*)q;
}

void _ns1__UploadMiniDumpResponse::soap_default(struct soap *soap)
{
    this->soap = soap;
    this->_ns1__UploadMiniDumpResponse::UploadMiniDumpResult = NULL;
    /* transient soap skipped */
}

void _ns1__UploadMiniDumpResponse::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
    (void)soap; /* appease -Wall -Werror */
    soap_serialize_PointerTons1__Response(soap, &this->_ns1__UploadMiniDumpResponse::UploadMiniDumpResult);
    /* transient soap skipped */
#endif
}

int _ns1__UploadMiniDumpResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
    return soap_out__ns1__UploadMiniDumpResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__UploadMiniDumpResponse(struct soap *soap, const char *tag, int id, const _ns1__UploadMiniDumpResponse *a, const char *type)
{
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__UploadMiniDumpResponse), type))
        return soap->error;
    if (a->UploadMiniDumpResult)
        soap_element_result(soap, "ns1:UploadMiniDumpResult");
    if (soap_out_PointerTons1__Response(soap, "ns1:UploadMiniDumpResult", -1, &(a->_ns1__UploadMiniDumpResponse::UploadMiniDumpResult), ""))
        return soap->error;
    /* transient soap skipped */
    return soap_element_end_out(soap, tag);
}

void *_ns1__UploadMiniDumpResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{   return soap_in__ns1__UploadMiniDumpResponse(soap, tag, this, type);
}

SOAP_FMAC3 _ns1__UploadMiniDumpResponse * SOAP_FMAC4 soap_in__ns1__UploadMiniDumpResponse(struct soap *soap, const char *tag, _ns1__UploadMiniDumpResponse *a, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    if (soap_element_begin_in(soap, tag, 0, NULL))
        return NULL;
    a = (_ns1__UploadMiniDumpResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__UploadMiniDumpResponse, sizeof(_ns1__UploadMiniDumpResponse), soap->type, soap->arrayType);
    if (!a)
        return NULL;
    if (soap->alloced)
    {   a->soap_default(soap);
        if (soap->clist->type != SOAP_TYPE__ns1__UploadMiniDumpResponse)
        {   soap_revert(soap);
            *soap->id = '\0';
            return (_ns1__UploadMiniDumpResponse *)a->soap_in(soap, tag, type);
        }
    }
    size_t soap_flag_UploadMiniDumpResult1 = 1;
    if (soap->body && !*soap->href)
    {
        for (;;)
        {   soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_UploadMiniDumpResult1 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerTons1__Response(soap, "ns1:UploadMiniDumpResult", &(a->_ns1__UploadMiniDumpResponse::UploadMiniDumpResult), "ns1:Response"))
                {   soap_flag_UploadMiniDumpResult1--;
                    continue;
                }
            /* transient soap skipped */
            soap_check_result(soap, "ns1:UploadMiniDumpResult");
            if (soap->error == SOAP_TAG_MISMATCH)
                soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
                break;
            if (soap->error)
                return NULL;
        }
        if (soap_element_end_in(soap, tag))
            return NULL;
    }
    else
    {   a = (_ns1__UploadMiniDumpResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__UploadMiniDumpResponse, 0, sizeof(_ns1__UploadMiniDumpResponse), 0, soap_copy__ns1__UploadMiniDumpResponse);
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    return a;
}

int _ns1__UploadMiniDumpResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
    register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ns1__UploadMiniDumpResponse);
    if (this->soap_out(soap, tag?tag:"ns1:UploadMiniDumpResponse", id, type))
        return soap->error;
    return soap_putindependent(soap);
}

void *_ns1__UploadMiniDumpResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
    return soap_get__ns1__UploadMiniDumpResponse(soap, this, tag, type);
}

SOAP_FMAC3 _ns1__UploadMiniDumpResponse * SOAP_FMAC4 soap_get__ns1__UploadMiniDumpResponse(struct soap *soap, _ns1__UploadMiniDumpResponse *p, const char *tag, const char *type)
{
    if ((p = soap_in__ns1__UploadMiniDumpResponse(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 _ns1__UploadMiniDumpResponse * SOAP_FMAC2 soap_instantiate__ns1__UploadMiniDumpResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ns1__UploadMiniDumpResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ns1__UploadMiniDumpResponse, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(_ns1__UploadMiniDumpResponse);
        if (size)
            *size = sizeof(_ns1__UploadMiniDumpResponse);
        ((_ns1__UploadMiniDumpResponse*)cp->ptr)->soap = soap;
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(_ns1__UploadMiniDumpResponse, n);
        if (size)
            *size = n * sizeof(_ns1__UploadMiniDumpResponse);
        if (cp->ptr)
            for (int i = 0; i < n; i++)
                ((_ns1__UploadMiniDumpResponse*)cp->ptr)[i].soap = soap;
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (_ns1__UploadMiniDumpResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__ns1__UploadMiniDumpResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ns1__UploadMiniDumpResponse %p -> %p\n", q, p));
    *(_ns1__UploadMiniDumpResponse*)p = *(_ns1__UploadMiniDumpResponse*)q;
}

void _ns1__UploadMiniDump::soap_default(struct soap *soap)
{
    this->soap = soap;
    this->_ns1__UploadMiniDump::client = NULL;
    this->_ns1__UploadMiniDump::app = NULL;
    this->_ns1__UploadMiniDump::addInfo = NULL;
    this->_ns1__UploadMiniDump::dump = NULL;
    this->_ns1__UploadMiniDump::context = NULL;
    /* transient soap skipped */
}

void _ns1__UploadMiniDump::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
    (void)soap; /* appease -Wall -Werror */
    soap_serialize_PointerTons1__ClientLib(soap, &this->_ns1__UploadMiniDump::client);
    soap_serialize_PointerTons1__Application(soap, &this->_ns1__UploadMiniDump::app);
    soap_serialize_PointerTons1__DumpAdditionalInfo(soap, &this->_ns1__UploadMiniDump::addInfo);
    soap_serialize_PointerTo_xop__Include(soap, &this->_ns1__UploadMiniDump::dump);
    soap_serialize_PointerTo_xop__Include(soap, &this->_ns1__UploadMiniDump::context);
    /* transient soap skipped */
#endif
}

int _ns1__UploadMiniDump::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
    return soap_out__ns1__UploadMiniDump(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__UploadMiniDump(struct soap *soap, const char *tag, int id, const _ns1__UploadMiniDump *a, const char *type)
{
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__UploadMiniDump), type))
        return soap->error;
    if (soap_out_PointerTons1__ClientLib(soap, "ns1:client", -1, &(a->_ns1__UploadMiniDump::client), ""))
        return soap->error;
    if (soap_out_PointerTons1__Application(soap, "ns1:app", -1, &(a->_ns1__UploadMiniDump::app), ""))
        return soap->error;
    if (soap_out_PointerTons1__DumpAdditionalInfo(soap, "ns1:addInfo", -1, &(a->_ns1__UploadMiniDump::addInfo), ""))
        return soap->error;
    if (soap_out_PointerTo_xop__Include(soap, "ns1:dump", -1, &(a->_ns1__UploadMiniDump::dump), ""))
        return soap->error;
    if (soap_out_PointerTo_xop__Include(soap, "ns1:context", -1, &(a->_ns1__UploadMiniDump::context), ""))
        return soap->error;
    /* transient soap skipped */
    return soap_element_end_out(soap, tag);
}

void *_ns1__UploadMiniDump::soap_in(struct soap *soap, const char *tag, const char *type)
{   return soap_in__ns1__UploadMiniDump(soap, tag, this, type);
}

SOAP_FMAC3 _ns1__UploadMiniDump * SOAP_FMAC4 soap_in__ns1__UploadMiniDump(struct soap *soap, const char *tag, _ns1__UploadMiniDump *a, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    if (soap_element_begin_in(soap, tag, 0, NULL))
        return NULL;
    a = (_ns1__UploadMiniDump *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__UploadMiniDump, sizeof(_ns1__UploadMiniDump), soap->type, soap->arrayType);
    if (!a)
        return NULL;
    if (soap->alloced)
    {   a->soap_default(soap);
        if (soap->clist->type != SOAP_TYPE__ns1__UploadMiniDump)
        {   soap_revert(soap);
            *soap->id = '\0';
            return (_ns1__UploadMiniDump *)a->soap_in(soap, tag, type);
        }
    }
    size_t soap_flag_client1 = 1;
    size_t soap_flag_app1 = 1;
    size_t soap_flag_addInfo1 = 1;
    size_t soap_flag_dump1 = 1;
    size_t soap_flag_context1 = 1;
    if (soap->body && !*soap->href)
    {
        for (;;)
        {   soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_client1 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerTons1__ClientLib(soap, "ns1:client", &(a->_ns1__UploadMiniDump::client), "ns1:ClientLib"))
                {   soap_flag_client1--;
                    continue;
                }
            if (soap_flag_app1 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerTons1__Application(soap, "ns1:app", &(a->_ns1__UploadMiniDump::app), "ns1:Application"))
                {   soap_flag_app1--;
                    continue;
                }
            if (soap_flag_addInfo1 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerTons1__DumpAdditionalInfo(soap, "ns1:addInfo", &(a->_ns1__UploadMiniDump::addInfo), "ns1:DumpAdditionalInfo"))
                {   soap_flag_addInfo1--;
                    continue;
                }
            if (soap_flag_dump1 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerTo_xop__Include(soap, "ns1:dump", &(a->_ns1__UploadMiniDump::dump), ""))
                {   soap_flag_dump1--;
                    continue;
                }
            if (soap_flag_context1 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerTo_xop__Include(soap, "ns1:context", &(a->_ns1__UploadMiniDump::context), ""))
                {   soap_flag_context1--;
                    continue;
                }
            /* transient soap skipped */
            if (soap->error == SOAP_TAG_MISMATCH)
                soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
                break;
            if (soap->error)
                return NULL;
        }
        if (soap_element_end_in(soap, tag))
            return NULL;
    }
    else
    {   a = (_ns1__UploadMiniDump *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__UploadMiniDump, 0, sizeof(_ns1__UploadMiniDump), 0, soap_copy__ns1__UploadMiniDump);
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    return a;
}

int _ns1__UploadMiniDump::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
    register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ns1__UploadMiniDump);
    if (this->soap_out(soap, tag?tag:"ns1:UploadMiniDump", id, type))
        return soap->error;
    return soap_putindependent(soap);
}

void *_ns1__UploadMiniDump::soap_get(struct soap *soap, const char *tag, const char *type)
{
    return soap_get__ns1__UploadMiniDump(soap, this, tag, type);
}

SOAP_FMAC3 _ns1__UploadMiniDump * SOAP_FMAC4 soap_get__ns1__UploadMiniDump(struct soap *soap, _ns1__UploadMiniDump *p, const char *tag, const char *type)
{
    if ((p = soap_in__ns1__UploadMiniDump(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 _ns1__UploadMiniDump * SOAP_FMAC2 soap_instantiate__ns1__UploadMiniDump(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ns1__UploadMiniDump(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ns1__UploadMiniDump, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(_ns1__UploadMiniDump);
        if (size)
            *size = sizeof(_ns1__UploadMiniDump);
        ((_ns1__UploadMiniDump*)cp->ptr)->soap = soap;
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(_ns1__UploadMiniDump, n);
        if (size)
            *size = n * sizeof(_ns1__UploadMiniDump);
        if (cp->ptr)
            for (int i = 0; i < n; i++)
                ((_ns1__UploadMiniDump*)cp->ptr)[i].soap = soap;
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (_ns1__UploadMiniDump*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__ns1__UploadMiniDump(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ns1__UploadMiniDump %p -> %p\n", q, p));
    *(_ns1__UploadMiniDump*)p = *(_ns1__UploadMiniDump*)q;
}

void _ns1__HelloResponse::soap_default(struct soap *soap)
{
    this->soap = soap;
    this->_ns1__HelloResponse::HelloResult = NULL;
    /* transient soap skipped */
}

void _ns1__HelloResponse::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
    (void)soap; /* appease -Wall -Werror */
    soap_serialize_PointerTons1__Response(soap, &this->_ns1__HelloResponse::HelloResult);
    /* transient soap skipped */
#endif
}

int _ns1__HelloResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
    return soap_out__ns1__HelloResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__HelloResponse(struct soap *soap, const char *tag, int id, const _ns1__HelloResponse *a, const char *type)
{
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__HelloResponse), type))
        return soap->error;
    if (a->HelloResult)
        soap_element_result(soap, "ns1:HelloResult");
    if (soap_out_PointerTons1__Response(soap, "ns1:HelloResult", -1, &(a->_ns1__HelloResponse::HelloResult), ""))
        return soap->error;
    /* transient soap skipped */
    return soap_element_end_out(soap, tag);
}

void *_ns1__HelloResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{   return soap_in__ns1__HelloResponse(soap, tag, this, type);
}

SOAP_FMAC3 _ns1__HelloResponse * SOAP_FMAC4 soap_in__ns1__HelloResponse(struct soap *soap, const char *tag, _ns1__HelloResponse *a, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    if (soap_element_begin_in(soap, tag, 0, NULL))
        return NULL;
    a = (_ns1__HelloResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__HelloResponse, sizeof(_ns1__HelloResponse), soap->type, soap->arrayType);
    if (!a)
        return NULL;
    if (soap->alloced)
    {   a->soap_default(soap);
        if (soap->clist->type != SOAP_TYPE__ns1__HelloResponse)
        {   soap_revert(soap);
            *soap->id = '\0';
            return (_ns1__HelloResponse *)a->soap_in(soap, tag, type);
        }
    }
    size_t soap_flag_HelloResult1 = 1;
    if (soap->body && !*soap->href)
    {
        for (;;)
        {   soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_HelloResult1 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerTons1__Response(soap, "ns1:HelloResult", &(a->_ns1__HelloResponse::HelloResult), "ns1:Response"))
                {   soap_flag_HelloResult1--;
                    continue;
                }
            /* transient soap skipped */
            soap_check_result(soap, "ns1:HelloResult");
            if (soap->error == SOAP_TAG_MISMATCH)
                soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
                break;
            if (soap->error)
                return NULL;
        }
        if (soap_element_end_in(soap, tag))
            return NULL;
    }
    else
    {   a = (_ns1__HelloResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__HelloResponse, 0, sizeof(_ns1__HelloResponse), 0, soap_copy__ns1__HelloResponse);
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    return a;
}

int _ns1__HelloResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
    register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ns1__HelloResponse);
    if (this->soap_out(soap, tag?tag:"ns1:HelloResponse", id, type))
        return soap->error;
    return soap_putindependent(soap);
}

void *_ns1__HelloResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
    return soap_get__ns1__HelloResponse(soap, this, tag, type);
}

SOAP_FMAC3 _ns1__HelloResponse * SOAP_FMAC4 soap_get__ns1__HelloResponse(struct soap *soap, _ns1__HelloResponse *p, const char *tag, const char *type)
{
    if ((p = soap_in__ns1__HelloResponse(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 _ns1__HelloResponse * SOAP_FMAC2 soap_instantiate__ns1__HelloResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ns1__HelloResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ns1__HelloResponse, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(_ns1__HelloResponse);
        if (size)
            *size = sizeof(_ns1__HelloResponse);
        ((_ns1__HelloResponse*)cp->ptr)->soap = soap;
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(_ns1__HelloResponse, n);
        if (size)
            *size = n * sizeof(_ns1__HelloResponse);
        if (cp->ptr)
            for (int i = 0; i < n; i++)
                ((_ns1__HelloResponse*)cp->ptr)[i].soap = soap;
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (_ns1__HelloResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__ns1__HelloResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ns1__HelloResponse %p -> %p\n", q, p));
    *(_ns1__HelloResponse*)p = *(_ns1__HelloResponse*)q;
}

void _ns1__Hello::soap_default(struct soap *soap)
{
    this->soap = soap;
    this->_ns1__Hello::clientLib = NULL;
    this->_ns1__Hello::app = NULL;
    this->_ns1__Hello::appAddInfo = NULL;
    this->_ns1__Hello::addInfo = NULL;
    this->_ns1__Hello::availableSymbols = NULL;
    this->_ns1__Hello::stack = NULL;
    /* transient soap skipped */
}

void _ns1__Hello::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
    (void)soap; /* appease -Wall -Werror */
    soap_serialize_PointerTons1__ClientLib(soap, &this->_ns1__Hello::clientLib);
    soap_serialize_PointerTons1__Application(soap, &this->_ns1__Hello::app);
    soap_serialize_PointerTons1__AppAdditionalInfo(soap, &this->_ns1__Hello::appAddInfo);
    soap_serialize_PointerTons1__DumpAdditionalInfo(soap, &this->_ns1__Hello::addInfo);
    soap_serialize_PointerTons1__ArrayOfModuleSymbolInfo(soap, &this->_ns1__Hello::availableSymbols);
    soap_serialize_PointerTo_xop__Include(soap, &this->_ns1__Hello::stack);
    /* transient soap skipped */
#endif
}

int _ns1__Hello::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
    return soap_out__ns1__Hello(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__Hello(struct soap *soap, const char *tag, int id, const _ns1__Hello *a, const char *type)
{
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__Hello), type))
        return soap->error;
    if (soap_out_PointerTons1__ClientLib(soap, "ns1:clientLib", -1, &(a->_ns1__Hello::clientLib), ""))
        return soap->error;
    if (soap_out_PointerTons1__Application(soap, "ns1:app", -1, &(a->_ns1__Hello::app), ""))
        return soap->error;
    if (soap_out_PointerTons1__AppAdditionalInfo(soap, "ns1:appAddInfo", -1, &(a->_ns1__Hello::appAddInfo), ""))
        return soap->error;
    if (soap_out_PointerTons1__DumpAdditionalInfo(soap, "ns1:addInfo", -1, &(a->_ns1__Hello::addInfo), ""))
        return soap->error;
    if (soap_out_PointerTons1__ArrayOfModuleSymbolInfo(soap, "ns1:availableSymbols", -1, &(a->_ns1__Hello::availableSymbols), ""))
        return soap->error;
    if (soap_out_PointerTo_xop__Include(soap, "ns1:stack", -1, &(a->_ns1__Hello::stack), ""))
        return soap->error;
    /* transient soap skipped */
    return soap_element_end_out(soap, tag);
}

void *_ns1__Hello::soap_in(struct soap *soap, const char *tag, const char *type)
{   return soap_in__ns1__Hello(soap, tag, this, type);
}

SOAP_FMAC3 _ns1__Hello * SOAP_FMAC4 soap_in__ns1__Hello(struct soap *soap, const char *tag, _ns1__Hello *a, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    if (soap_element_begin_in(soap, tag, 0, NULL))
        return NULL;
    a = (_ns1__Hello *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__Hello, sizeof(_ns1__Hello), soap->type, soap->arrayType);
    if (!a)
        return NULL;
    if (soap->alloced)
    {   a->soap_default(soap);
        if (soap->clist->type != SOAP_TYPE__ns1__Hello)
        {   soap_revert(soap);
            *soap->id = '\0';
            return (_ns1__Hello *)a->soap_in(soap, tag, type);
        }
    }
    size_t soap_flag_clientLib1 = 1;
    size_t soap_flag_app1 = 1;
    size_t soap_flag_appAddInfo1 = 1;
    size_t soap_flag_addInfo1 = 1;
    size_t soap_flag_availableSymbols1 = 1;
    size_t soap_flag_stack1 = 1;
    if (soap->body && !*soap->href)
    {
        for (;;)
        {   soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_clientLib1 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerTons1__ClientLib(soap, "ns1:clientLib", &(a->_ns1__Hello::clientLib), "ns1:ClientLib"))
                {   soap_flag_clientLib1--;
                    continue;
                }
            if (soap_flag_app1 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerTons1__Application(soap, "ns1:app", &(a->_ns1__Hello::app), "ns1:Application"))
                {   soap_flag_app1--;
                    continue;
                }
            if (soap_flag_appAddInfo1 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerTons1__AppAdditionalInfo(soap, "ns1:appAddInfo", &(a->_ns1__Hello::appAddInfo), "ns1:AppAdditionalInfo"))
                {   soap_flag_appAddInfo1--;
                    continue;
                }
            if (soap_flag_addInfo1 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerTons1__DumpAdditionalInfo(soap, "ns1:addInfo", &(a->_ns1__Hello::addInfo), "ns1:DumpAdditionalInfo"))
                {   soap_flag_addInfo1--;
                    continue;
                }
            if (soap_flag_availableSymbols1 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerTons1__ArrayOfModuleSymbolInfo(soap, "ns1:availableSymbols", &(a->_ns1__Hello::availableSymbols), "ns1:ArrayOfModuleSymbolInfo"))
                {   soap_flag_availableSymbols1--;
                    continue;
                }
            if (soap_flag_stack1 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerTo_xop__Include(soap, "ns1:stack", &(a->_ns1__Hello::stack), ""))
                {   soap_flag_stack1--;
                    continue;
                }
            /* transient soap skipped */
            if (soap->error == SOAP_TAG_MISMATCH)
                soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
                break;
            if (soap->error)
                return NULL;
        }
        if (soap_element_end_in(soap, tag))
            return NULL;
    }
    else
    {   a = (_ns1__Hello *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__Hello, 0, sizeof(_ns1__Hello), 0, soap_copy__ns1__Hello);
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    return a;
}

int _ns1__Hello::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
    register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ns1__Hello);
    if (this->soap_out(soap, tag?tag:"ns1:Hello", id, type))
        return soap->error;
    return soap_putindependent(soap);
}

void *_ns1__Hello::soap_get(struct soap *soap, const char *tag, const char *type)
{
    return soap_get__ns1__Hello(soap, this, tag, type);
}

SOAP_FMAC3 _ns1__Hello * SOAP_FMAC4 soap_get__ns1__Hello(struct soap *soap, _ns1__Hello *p, const char *tag, const char *type)
{
    if ((p = soap_in__ns1__Hello(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 _ns1__Hello * SOAP_FMAC2 soap_instantiate__ns1__Hello(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ns1__Hello(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ns1__Hello, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(_ns1__Hello);
        if (size)
            *size = sizeof(_ns1__Hello);
        ((_ns1__Hello*)cp->ptr)->soap = soap;
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(_ns1__Hello, n);
        if (size)
            *size = n * sizeof(_ns1__Hello);
        if (cp->ptr)
            for (int i = 0; i < n; i++)
                ((_ns1__Hello*)cp->ptr)[i].soap = soap;
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (_ns1__Hello*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__ns1__Hello(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ns1__Hello %p -> %p\n", q, p));
    *(_ns1__Hello*)p = *(_ns1__Hello*)q;
}

void ns1__NeedMoreInfoResponse::soap_default(struct soap *soap)
{
    this->soap = soap;
    this->ns1__Response::soap_default(soap);
    this->ns1__NeedMoreInfoResponse::infoModule = NULL;
    this->ns1__NeedMoreInfoResponse::infoModuleCfg = NULL;
}

void ns1__NeedMoreInfoResponse::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
    (void)soap; /* appease -Wall -Werror */
    soap_serialize_PointerTo_xop__Include(soap, &this->ns1__NeedMoreInfoResponse::infoModule);
    soap_serialize_PointerTostd__wstring(soap, &this->ns1__NeedMoreInfoResponse::infoModuleCfg);
    this->ns1__Response::soap_serialize(soap);
#endif
}

int ns1__NeedMoreInfoResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
    return soap_out_ns1__NeedMoreInfoResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__NeedMoreInfoResponse(struct soap *soap, const char *tag, int id, const ns1__NeedMoreInfoResponse *a, const char *type)
{
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__NeedMoreInfoResponse), "ns1:NeedMoreInfoResponse"))
        return soap->error;
    /* transient soap skipped */
    if (soap_out_PointerTostd__wstring(soap, "ns1:clientID", -1, &(a->ns1__Response::clientID), ""))
        return soap->error;
    if (soap_out_PointerTo_xop__Include(soap, "ns1:context", -1, &(a->ns1__Response::context), ""))
        return soap->error;
    if (soap_out_PointerToint(soap, "ns1:dumpGroupID", -1, &(a->ns1__Response::dumpGroupID), ""))
        return soap->error;
    if (soap_out_PointerToint(soap, "ns1:dumpID", -1, &(a->ns1__Response::dumpID), ""))
        return soap->error;
    if (soap_out_PointerTo_xop__Include(soap, "ns1:garbage", -1, &(a->ns1__Response::garbage), ""))
        return soap->error;
    if (soap_out_PointerToint(soap, "ns1:problemID", -1, &(a->ns1__Response::problemID), ""))
        return soap->error;
    if (soap_out_PointerTostd__wstring(soap, "ns1:urlToProblem", -1, &(a->ns1__Response::urlToProblem), ""))
        return soap->error;
    if (soap_out_PointerTo_xop__Include(soap, "ns1:infoModule", -1, &(a->ns1__NeedMoreInfoResponse::infoModule), ""))
        return soap->error;
    if (soap_out_PointerTostd__wstring(soap, "ns1:infoModuleCfg", -1, &(a->ns1__NeedMoreInfoResponse::infoModuleCfg), ""))
        return soap->error;
    return soap_element_end_out(soap, tag);
}

void *ns1__NeedMoreInfoResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{   return soap_in_ns1__NeedMoreInfoResponse(soap, tag, this, type);
}

SOAP_FMAC3 ns1__NeedMoreInfoResponse * SOAP_FMAC4 soap_in_ns1__NeedMoreInfoResponse(struct soap *soap, const char *tag, ns1__NeedMoreInfoResponse *a, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    if (soap_element_begin_in(soap, tag, 0, NULL))
        return NULL;
    a = (ns1__NeedMoreInfoResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__NeedMoreInfoResponse, sizeof(ns1__NeedMoreInfoResponse), soap->type, soap->arrayType);
    if (!a)
        return NULL;
    if (soap->alloced)
    {   a->soap_default(soap);
        if (soap->clist->type != SOAP_TYPE_ns1__NeedMoreInfoResponse)
        {   soap_revert(soap);
            *soap->id = '\0';
            return (ns1__NeedMoreInfoResponse *)a->soap_in(soap, tag, type);
        }
    }
    size_t soap_flag___item3 = 1;
    size_t soap_flag_clientID2 = 1;
    size_t soap_flag_context2 = 1;
    size_t soap_flag_dumpGroupID2 = 1;
    size_t soap_flag_dumpID2 = 1;
    size_t soap_flag_garbage2 = 1;
    size_t soap_flag_problemID2 = 1;
    size_t soap_flag_urlToProblem2 = 1;
    size_t soap_flag_infoModule1 = 1;
    size_t soap_flag_infoModuleCfg1 = 1;
    if (soap->body && !*soap->href)
    {
        for (;;)
        {   soap->error = SOAP_TAG_MISMATCH;
            /* transient soap skipped */
            if (soap_flag_clientID2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
                if (soap_in_PointerTostd__wstring(soap, "ns1:clientID", &(a->ns1__Response::clientID), "xsd:string"))
                {   soap_flag_clientID2--;
                    continue;
                }
            if (soap_flag_context2 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerTo_xop__Include(soap, "ns1:context", &(a->ns1__Response::context), ""))
                {   soap_flag_context2--;
                    continue;
                }
            if (soap_flag_dumpGroupID2 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerToint(soap, "ns1:dumpGroupID", &(a->ns1__Response::dumpGroupID), "xsd:int"))
                {   soap_flag_dumpGroupID2--;
                    continue;
                }
            if (soap_flag_dumpID2 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerToint(soap, "ns1:dumpID", &(a->ns1__Response::dumpID), "xsd:int"))
                {   soap_flag_dumpID2--;
                    continue;
                }
            if (soap_flag_garbage2 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerTo_xop__Include(soap, "ns1:garbage", &(a->ns1__Response::garbage), ""))
                {   soap_flag_garbage2--;
                    continue;
                }
            if (soap_flag_problemID2 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerToint(soap, "ns1:problemID", &(a->ns1__Response::problemID), "xsd:int"))
                {   soap_flag_problemID2--;
                    continue;
                }
            if (soap_flag_urlToProblem2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
                if (soap_in_PointerTostd__wstring(soap, "ns1:urlToProblem", &(a->ns1__Response::urlToProblem), "xsd:string"))
                {   soap_flag_urlToProblem2--;
                    continue;
                }
            if (soap_flag_infoModule1 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerTo_xop__Include(soap, "ns1:infoModule", &(a->ns1__NeedMoreInfoResponse::infoModule), ""))
                {   soap_flag_infoModule1--;
                    continue;
                }
            if (soap_flag_infoModuleCfg1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
                if (soap_in_PointerTostd__wstring(soap, "ns1:infoModuleCfg", &(a->ns1__NeedMoreInfoResponse::infoModuleCfg), "xsd:string"))
                {   soap_flag_infoModuleCfg1--;
                    continue;
                }
            if (soap_flag___item3 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
                if (soap_inliteral(soap, "-item", &(a->xsd__anyType::__item)))
                {   soap_flag___item3--;
                    continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
                soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
                break;
            if (soap->error)
                return NULL;
        }
        if (soap_element_end_in(soap, tag))
            return NULL;
    }
    else
    {   a = (ns1__NeedMoreInfoResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__NeedMoreInfoResponse, 0, sizeof(ns1__NeedMoreInfoResponse), 0, soap_copy_ns1__NeedMoreInfoResponse);
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    return a;
}

int ns1__NeedMoreInfoResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
    register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns1__NeedMoreInfoResponse);
    if (this->soap_out(soap, tag?tag:"ns1:NeedMoreInfoResponse", id, type))
        return soap->error;
    return soap_putindependent(soap);
}

void *ns1__NeedMoreInfoResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
    return soap_get_ns1__NeedMoreInfoResponse(soap, this, tag, type);
}

SOAP_FMAC3 ns1__NeedMoreInfoResponse * SOAP_FMAC4 soap_get_ns1__NeedMoreInfoResponse(struct soap *soap, ns1__NeedMoreInfoResponse *p, const char *tag, const char *type)
{
    if ((p = soap_in_ns1__NeedMoreInfoResponse(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 ns1__NeedMoreInfoResponse * SOAP_FMAC2 soap_instantiate_ns1__NeedMoreInfoResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns1__NeedMoreInfoResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns1__NeedMoreInfoResponse, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(ns1__NeedMoreInfoResponse);
        if (size)
            *size = sizeof(ns1__NeedMoreInfoResponse);
        ((ns1__NeedMoreInfoResponse*)cp->ptr)->soap = soap;
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(ns1__NeedMoreInfoResponse, n);
        if (size)
            *size = n * sizeof(ns1__NeedMoreInfoResponse);
        if (cp->ptr)
            for (int i = 0; i < n; i++)
                ((ns1__NeedMoreInfoResponse*)cp->ptr)[i].soap = soap;
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (ns1__NeedMoreInfoResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns1__NeedMoreInfoResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns1__NeedMoreInfoResponse %p -> %p\n", q, p));
    *(ns1__NeedMoreInfoResponse*)p = *(ns1__NeedMoreInfoResponse*)q;
}

void ns1__NeedFullDumpResponse::soap_default(struct soap *soap)
{
    this->soap = soap;
    this->ns1__Response::soap_default(soap);
    soap_default_bool(soap, &this->ns1__NeedFullDumpResponse::attachUserInfo);
    soap_default_unsignedInt(soap, &this->ns1__NeedFullDumpResponse::restrictedDumpType);
}

void ns1__NeedFullDumpResponse::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
    (void)soap; /* appease -Wall -Werror */
    soap_embedded(soap, &this->ns1__NeedFullDumpResponse::attachUserInfo, SOAP_TYPE_bool);
    this->ns1__Response::soap_serialize(soap);
#endif
}

int ns1__NeedFullDumpResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
    return soap_out_ns1__NeedFullDumpResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__NeedFullDumpResponse(struct soap *soap, const char *tag, int id, const ns1__NeedFullDumpResponse *a, const char *type)
{
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__NeedFullDumpResponse), "ns1:NeedFullDumpResponse"))
        return soap->error;
    /* transient soap skipped */
    if (soap_out_PointerTostd__wstring(soap, "ns1:clientID", -1, &(a->ns1__Response::clientID), ""))
        return soap->error;
    if (soap_out_PointerTo_xop__Include(soap, "ns1:context", -1, &(a->ns1__Response::context), ""))
        return soap->error;
    if (soap_out_PointerToint(soap, "ns1:dumpGroupID", -1, &(a->ns1__Response::dumpGroupID), ""))
        return soap->error;
    if (soap_out_PointerToint(soap, "ns1:dumpID", -1, &(a->ns1__Response::dumpID), ""))
        return soap->error;
    if (soap_out_PointerTo_xop__Include(soap, "ns1:garbage", -1, &(a->ns1__Response::garbage), ""))
        return soap->error;
    if (soap_out_PointerToint(soap, "ns1:problemID", -1, &(a->ns1__Response::problemID), ""))
        return soap->error;
    if (soap_out_PointerTostd__wstring(soap, "ns1:urlToProblem", -1, &(a->ns1__Response::urlToProblem), ""))
        return soap->error;
    if (soap_out_bool(soap, "ns1:attachUserInfo", -1, &(a->ns1__NeedFullDumpResponse::attachUserInfo), ""))
        return soap->error;
    if (soap_out_unsignedInt(soap, "ns1:restrictedDumpType", -1, &(a->ns1__NeedFullDumpResponse::restrictedDumpType), ""))
        return soap->error;
    return soap_element_end_out(soap, tag);
}

void *ns1__NeedFullDumpResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{   return soap_in_ns1__NeedFullDumpResponse(soap, tag, this, type);
}

SOAP_FMAC3 ns1__NeedFullDumpResponse * SOAP_FMAC4 soap_in_ns1__NeedFullDumpResponse(struct soap *soap, const char *tag, ns1__NeedFullDumpResponse *a, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    if (soap_element_begin_in(soap, tag, 0, NULL))
        return NULL;
    a = (ns1__NeedFullDumpResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__NeedFullDumpResponse, sizeof(ns1__NeedFullDumpResponse), soap->type, soap->arrayType);
    if (!a)
        return NULL;
    if (soap->alloced)
    {   a->soap_default(soap);
        if (soap->clist->type != SOAP_TYPE_ns1__NeedFullDumpResponse)
        {   soap_revert(soap);
            *soap->id = '\0';
            return (ns1__NeedFullDumpResponse *)a->soap_in(soap, tag, type);
        }
    }
    size_t soap_flag___item3 = 1;
    size_t soap_flag_clientID2 = 1;
    size_t soap_flag_context2 = 1;
    size_t soap_flag_dumpGroupID2 = 1;
    size_t soap_flag_dumpID2 = 1;
    size_t soap_flag_garbage2 = 1;
    size_t soap_flag_problemID2 = 1;
    size_t soap_flag_urlToProblem2 = 1;
    size_t soap_flag_attachUserInfo1 = 1;
    size_t soap_flag_restrictedDumpType1 = 1;
    if (soap->body && !*soap->href)
    {
        for (;;)
        {   soap->error = SOAP_TAG_MISMATCH;
            /* transient soap skipped */
            if (soap_flag_clientID2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
                if (soap_in_PointerTostd__wstring(soap, "ns1:clientID", &(a->ns1__Response::clientID), "xsd:string"))
                {   soap_flag_clientID2--;
                    continue;
                }
            if (soap_flag_context2 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerTo_xop__Include(soap, "ns1:context", &(a->ns1__Response::context), ""))
                {   soap_flag_context2--;
                    continue;
                }
            if (soap_flag_dumpGroupID2 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerToint(soap, "ns1:dumpGroupID", &(a->ns1__Response::dumpGroupID), "xsd:int"))
                {   soap_flag_dumpGroupID2--;
                    continue;
                }
            if (soap_flag_dumpID2 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerToint(soap, "ns1:dumpID", &(a->ns1__Response::dumpID), "xsd:int"))
                {   soap_flag_dumpID2--;
                    continue;
                }
            if (soap_flag_garbage2 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerTo_xop__Include(soap, "ns1:garbage", &(a->ns1__Response::garbage), ""))
                {   soap_flag_garbage2--;
                    continue;
                }
            if (soap_flag_problemID2 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerToint(soap, "ns1:problemID", &(a->ns1__Response::problemID), "xsd:int"))
                {   soap_flag_problemID2--;
                    continue;
                }
            if (soap_flag_urlToProblem2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
                if (soap_in_PointerTostd__wstring(soap, "ns1:urlToProblem", &(a->ns1__Response::urlToProblem), "xsd:string"))
                {   soap_flag_urlToProblem2--;
                    continue;
                }
            if (soap_flag_attachUserInfo1 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_bool(soap, "ns1:attachUserInfo", &(a->ns1__NeedFullDumpResponse::attachUserInfo), "xsd:boolean"))
                {   soap_flag_attachUserInfo1--;
                    continue;
                }
            if (soap_flag_restrictedDumpType1 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_unsignedInt(soap, "ns1:restrictedDumpType", &(a->ns1__NeedFullDumpResponse::restrictedDumpType), "xsd:unsignedInt"))
                {   soap_flag_restrictedDumpType1--;
                    continue;
                }
            if (soap_flag___item3 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
                if (soap_inliteral(soap, "-item", &(a->xsd__anyType::__item)))
                {   soap_flag___item3--;
                    continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
                soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
                break;
            if (soap->error)
                return NULL;
        }
        if (soap_element_end_in(soap, tag))
            return NULL;
    }
    else
    {   a = (ns1__NeedFullDumpResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__NeedFullDumpResponse, 0, sizeof(ns1__NeedFullDumpResponse), 0, soap_copy_ns1__NeedFullDumpResponse);
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_attachUserInfo1 > 0 || soap_flag_restrictedDumpType1 > 0))
    {   soap->error = SOAP_OCCURS;
        return NULL;
    }
    return a;
}

int ns1__NeedFullDumpResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
    register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns1__NeedFullDumpResponse);
    if (this->soap_out(soap, tag?tag:"ns1:NeedFullDumpResponse", id, type))
        return soap->error;
    return soap_putindependent(soap);
}

void *ns1__NeedFullDumpResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
    return soap_get_ns1__NeedFullDumpResponse(soap, this, tag, type);
}

SOAP_FMAC3 ns1__NeedFullDumpResponse * SOAP_FMAC4 soap_get_ns1__NeedFullDumpResponse(struct soap *soap, ns1__NeedFullDumpResponse *p, const char *tag, const char *type)
{
    if ((p = soap_in_ns1__NeedFullDumpResponse(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 ns1__NeedFullDumpResponse * SOAP_FMAC2 soap_instantiate_ns1__NeedFullDumpResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns1__NeedFullDumpResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns1__NeedFullDumpResponse, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(ns1__NeedFullDumpResponse);
        if (size)
            *size = sizeof(ns1__NeedFullDumpResponse);
        ((ns1__NeedFullDumpResponse*)cp->ptr)->soap = soap;
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(ns1__NeedFullDumpResponse, n);
        if (size)
            *size = n * sizeof(ns1__NeedFullDumpResponse);
        if (cp->ptr)
            for (int i = 0; i < n; i++)
                ((ns1__NeedFullDumpResponse*)cp->ptr)[i].soap = soap;
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (ns1__NeedFullDumpResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns1__NeedFullDumpResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns1__NeedFullDumpResponse %p -> %p\n", q, p));
    *(ns1__NeedFullDumpResponse*)p = *(ns1__NeedFullDumpResponse*)q;
}

void ns1__NeedMiniDumpResponse::soap_default(struct soap *soap)
{
    this->soap = soap;
    this->ns1__Response::soap_default(soap);
}

void ns1__NeedMiniDumpResponse::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
    (void)soap; /* appease -Wall -Werror */
    this->ns1__Response::soap_serialize(soap);
#endif
}

int ns1__NeedMiniDumpResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
    return soap_out_ns1__NeedMiniDumpResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__NeedMiniDumpResponse(struct soap *soap, const char *tag, int id, const ns1__NeedMiniDumpResponse *a, const char *type)
{
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__NeedMiniDumpResponse), "ns1:NeedMiniDumpResponse"))
        return soap->error;
    /* transient soap skipped */
    if (soap_out_PointerTostd__wstring(soap, "ns1:clientID", -1, &(a->ns1__Response::clientID), ""))
        return soap->error;
    if (soap_out_PointerTo_xop__Include(soap, "ns1:context", -1, &(a->ns1__Response::context), ""))
        return soap->error;
    if (soap_out_PointerToint(soap, "ns1:dumpGroupID", -1, &(a->ns1__Response::dumpGroupID), ""))
        return soap->error;
    if (soap_out_PointerToint(soap, "ns1:dumpID", -1, &(a->ns1__Response::dumpID), ""))
        return soap->error;
    if (soap_out_PointerTo_xop__Include(soap, "ns1:garbage", -1, &(a->ns1__Response::garbage), ""))
        return soap->error;
    if (soap_out_PointerToint(soap, "ns1:problemID", -1, &(a->ns1__Response::problemID), ""))
        return soap->error;
    if (soap_out_PointerTostd__wstring(soap, "ns1:urlToProblem", -1, &(a->ns1__Response::urlToProblem), ""))
        return soap->error;
    return soap_element_end_out(soap, tag);
}

void *ns1__NeedMiniDumpResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{   return soap_in_ns1__NeedMiniDumpResponse(soap, tag, this, type);
}

SOAP_FMAC3 ns1__NeedMiniDumpResponse * SOAP_FMAC4 soap_in_ns1__NeedMiniDumpResponse(struct soap *soap, const char *tag, ns1__NeedMiniDumpResponse *a, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    if (soap_element_begin_in(soap, tag, 0, NULL))
        return NULL;
    a = (ns1__NeedMiniDumpResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__NeedMiniDumpResponse, sizeof(ns1__NeedMiniDumpResponse), soap->type, soap->arrayType);
    if (!a)
        return NULL;
    if (soap->alloced)
    {   a->soap_default(soap);
        if (soap->clist->type != SOAP_TYPE_ns1__NeedMiniDumpResponse)
        {   soap_revert(soap);
            *soap->id = '\0';
            return (ns1__NeedMiniDumpResponse *)a->soap_in(soap, tag, type);
        }
    }
    size_t soap_flag___item3 = 1;
    size_t soap_flag_clientID2 = 1;
    size_t soap_flag_context2 = 1;
    size_t soap_flag_dumpGroupID2 = 1;
    size_t soap_flag_dumpID2 = 1;
    size_t soap_flag_garbage2 = 1;
    size_t soap_flag_problemID2 = 1;
    size_t soap_flag_urlToProblem2 = 1;
    if (soap->body && !*soap->href)
    {
        for (;;)
        {   soap->error = SOAP_TAG_MISMATCH;
            /* transient soap skipped */
            if (soap_flag_clientID2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
                if (soap_in_PointerTostd__wstring(soap, "ns1:clientID", &(a->ns1__Response::clientID), "xsd:string"))
                {   soap_flag_clientID2--;
                    continue;
                }
            if (soap_flag_context2 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerTo_xop__Include(soap, "ns1:context", &(a->ns1__Response::context), ""))
                {   soap_flag_context2--;
                    continue;
                }
            if (soap_flag_dumpGroupID2 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerToint(soap, "ns1:dumpGroupID", &(a->ns1__Response::dumpGroupID), "xsd:int"))
                {   soap_flag_dumpGroupID2--;
                    continue;
                }
            if (soap_flag_dumpID2 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerToint(soap, "ns1:dumpID", &(a->ns1__Response::dumpID), "xsd:int"))
                {   soap_flag_dumpID2--;
                    continue;
                }
            if (soap_flag_garbage2 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerTo_xop__Include(soap, "ns1:garbage", &(a->ns1__Response::garbage), ""))
                {   soap_flag_garbage2--;
                    continue;
                }
            if (soap_flag_problemID2 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerToint(soap, "ns1:problemID", &(a->ns1__Response::problemID), "xsd:int"))
                {   soap_flag_problemID2--;
                    continue;
                }
            if (soap_flag_urlToProblem2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
                if (soap_in_PointerTostd__wstring(soap, "ns1:urlToProblem", &(a->ns1__Response::urlToProblem), "xsd:string"))
                {   soap_flag_urlToProblem2--;
                    continue;
                }
            if (soap_flag___item3 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
                if (soap_inliteral(soap, "-item", &(a->xsd__anyType::__item)))
                {   soap_flag___item3--;
                    continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
                soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
                break;
            if (soap->error)
                return NULL;
        }
        if (soap_element_end_in(soap, tag))
            return NULL;
    }
    else
    {   a = (ns1__NeedMiniDumpResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__NeedMiniDumpResponse, 0, sizeof(ns1__NeedMiniDumpResponse), 0, soap_copy_ns1__NeedMiniDumpResponse);
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    return a;
}

int ns1__NeedMiniDumpResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
    register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns1__NeedMiniDumpResponse);
    if (this->soap_out(soap, tag?tag:"ns1:NeedMiniDumpResponse", id, type))
        return soap->error;
    return soap_putindependent(soap);
}

void *ns1__NeedMiniDumpResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
    return soap_get_ns1__NeedMiniDumpResponse(soap, this, tag, type);
}

SOAP_FMAC3 ns1__NeedMiniDumpResponse * SOAP_FMAC4 soap_get_ns1__NeedMiniDumpResponse(struct soap *soap, ns1__NeedMiniDumpResponse *p, const char *tag, const char *type)
{
    if ((p = soap_in_ns1__NeedMiniDumpResponse(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 ns1__NeedMiniDumpResponse * SOAP_FMAC2 soap_instantiate_ns1__NeedMiniDumpResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns1__NeedMiniDumpResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns1__NeedMiniDumpResponse, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(ns1__NeedMiniDumpResponse);
        if (size)
            *size = sizeof(ns1__NeedMiniDumpResponse);
        ((ns1__NeedMiniDumpResponse*)cp->ptr)->soap = soap;
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(ns1__NeedMiniDumpResponse, n);
        if (size)
            *size = n * sizeof(ns1__NeedMiniDumpResponse);
        if (cp->ptr)
            for (int i = 0; i < n; i++)
                ((ns1__NeedMiniDumpResponse*)cp->ptr)[i].soap = soap;
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (ns1__NeedMiniDumpResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns1__NeedMiniDumpResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns1__NeedMiniDumpResponse %p -> %p\n", q, p));
    *(ns1__NeedMiniDumpResponse*)p = *(ns1__NeedMiniDumpResponse*)q;
}

void ns1__NeedSymbolsThenMiniDumpResponse::soap_default(struct soap *soap)
{
    this->soap = soap;
    this->ns1__Response::soap_default(soap);
    soap_default_bool(soap, &this->ns1__NeedSymbolsThenMiniDumpResponse::askConfirmation);
    this->ns1__NeedSymbolsThenMiniDumpResponse::msSymbols = NULL;
    this->ns1__NeedSymbolsThenMiniDumpResponse::symbols = NULL;
}

void ns1__NeedSymbolsThenMiniDumpResponse::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
    (void)soap; /* appease -Wall -Werror */
    soap_embedded(soap, &this->ns1__NeedSymbolsThenMiniDumpResponse::askConfirmation, SOAP_TYPE_bool);
    soap_serialize_PointerTons5__ArrayOfstring(soap, &this->ns1__NeedSymbolsThenMiniDumpResponse::msSymbols);
    soap_serialize_PointerTons5__ArrayOfstring(soap, &this->ns1__NeedSymbolsThenMiniDumpResponse::symbols);
    this->ns1__Response::soap_serialize(soap);
#endif
}

int ns1__NeedSymbolsThenMiniDumpResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
    return soap_out_ns1__NeedSymbolsThenMiniDumpResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__NeedSymbolsThenMiniDumpResponse(struct soap *soap, const char *tag, int id, const ns1__NeedSymbolsThenMiniDumpResponse *a, const char *type)
{
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__NeedSymbolsThenMiniDumpResponse), "ns1:NeedSymbolsThenMiniDumpResponse"))
        return soap->error;
    /* transient soap skipped */
    if (soap_out_PointerTostd__wstring(soap, "ns1:clientID", -1, &(a->ns1__Response::clientID), ""))
        return soap->error;
    if (soap_out_PointerTo_xop__Include(soap, "ns1:context", -1, &(a->ns1__Response::context), ""))
        return soap->error;
    if (soap_out_PointerToint(soap, "ns1:dumpGroupID", -1, &(a->ns1__Response::dumpGroupID), ""))
        return soap->error;
    if (soap_out_PointerToint(soap, "ns1:dumpID", -1, &(a->ns1__Response::dumpID), ""))
        return soap->error;
    if (soap_out_PointerTo_xop__Include(soap, "ns1:garbage", -1, &(a->ns1__Response::garbage), ""))
        return soap->error;
    if (soap_out_PointerToint(soap, "ns1:problemID", -1, &(a->ns1__Response::problemID), ""))
        return soap->error;
    if (soap_out_PointerTostd__wstring(soap, "ns1:urlToProblem", -1, &(a->ns1__Response::urlToProblem), ""))
        return soap->error;
    if (soap_out_bool(soap, "ns1:askConfirmation", -1, &(a->ns1__NeedSymbolsThenMiniDumpResponse::askConfirmation), ""))
        return soap->error;
    if (soap_out_PointerTons5__ArrayOfstring(soap, "ns1:msSymbols", -1, &(a->ns1__NeedSymbolsThenMiniDumpResponse::msSymbols), ""))
        return soap->error;
    if (soap_out_PointerTons5__ArrayOfstring(soap, "ns1:symbols", -1, &(a->ns1__NeedSymbolsThenMiniDumpResponse::symbols), ""))
        return soap->error;
    return soap_element_end_out(soap, tag);
}

void *ns1__NeedSymbolsThenMiniDumpResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{   return soap_in_ns1__NeedSymbolsThenMiniDumpResponse(soap, tag, this, type);
}

SOAP_FMAC3 ns1__NeedSymbolsThenMiniDumpResponse * SOAP_FMAC4 soap_in_ns1__NeedSymbolsThenMiniDumpResponse(struct soap *soap, const char *tag, ns1__NeedSymbolsThenMiniDumpResponse *a, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    if (soap_element_begin_in(soap, tag, 0, NULL))
        return NULL;
    a = (ns1__NeedSymbolsThenMiniDumpResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__NeedSymbolsThenMiniDumpResponse, sizeof(ns1__NeedSymbolsThenMiniDumpResponse), soap->type, soap->arrayType);
    if (!a)
        return NULL;
    if (soap->alloced)
    {   a->soap_default(soap);
        if (soap->clist->type != SOAP_TYPE_ns1__NeedSymbolsThenMiniDumpResponse)
        {   soap_revert(soap);
            *soap->id = '\0';
            return (ns1__NeedSymbolsThenMiniDumpResponse *)a->soap_in(soap, tag, type);
        }
    }
    size_t soap_flag___item3 = 1;
    size_t soap_flag_clientID2 = 1;
    size_t soap_flag_context2 = 1;
    size_t soap_flag_dumpGroupID2 = 1;
    size_t soap_flag_dumpID2 = 1;
    size_t soap_flag_garbage2 = 1;
    size_t soap_flag_problemID2 = 1;
    size_t soap_flag_urlToProblem2 = 1;
    size_t soap_flag_askConfirmation1 = 1;
    size_t soap_flag_msSymbols1 = 1;
    size_t soap_flag_symbols1 = 1;
    if (soap->body && !*soap->href)
    {
        for (;;)
        {   soap->error = SOAP_TAG_MISMATCH;
            /* transient soap skipped */
            if (soap_flag_clientID2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
                if (soap_in_PointerTostd__wstring(soap, "ns1:clientID", &(a->ns1__Response::clientID), "xsd:string"))
                {   soap_flag_clientID2--;
                    continue;
                }
            if (soap_flag_context2 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerTo_xop__Include(soap, "ns1:context", &(a->ns1__Response::context), ""))
                {   soap_flag_context2--;
                    continue;
                }
            if (soap_flag_dumpGroupID2 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerToint(soap, "ns1:dumpGroupID", &(a->ns1__Response::dumpGroupID), "xsd:int"))
                {   soap_flag_dumpGroupID2--;
                    continue;
                }
            if (soap_flag_dumpID2 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerToint(soap, "ns1:dumpID", &(a->ns1__Response::dumpID), "xsd:int"))
                {   soap_flag_dumpID2--;
                    continue;
                }
            if (soap_flag_garbage2 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerTo_xop__Include(soap, "ns1:garbage", &(a->ns1__Response::garbage), ""))
                {   soap_flag_garbage2--;
                    continue;
                }
            if (soap_flag_problemID2 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerToint(soap, "ns1:problemID", &(a->ns1__Response::problemID), "xsd:int"))
                {   soap_flag_problemID2--;
                    continue;
                }
            if (soap_flag_urlToProblem2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
                if (soap_in_PointerTostd__wstring(soap, "ns1:urlToProblem", &(a->ns1__Response::urlToProblem), "xsd:string"))
                {   soap_flag_urlToProblem2--;
                    continue;
                }
            if (soap_flag_askConfirmation1 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_bool(soap, "ns1:askConfirmation", &(a->ns1__NeedSymbolsThenMiniDumpResponse::askConfirmation), "xsd:boolean"))
                {   soap_flag_askConfirmation1--;
                    continue;
                }
            if (soap_flag_msSymbols1 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerTons5__ArrayOfstring(soap, "ns1:msSymbols", &(a->ns1__NeedSymbolsThenMiniDumpResponse::msSymbols), "ns5:ArrayOfstring"))
                {   soap_flag_msSymbols1--;
                    continue;
                }
            if (soap_flag_symbols1 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerTons5__ArrayOfstring(soap, "ns1:symbols", &(a->ns1__NeedSymbolsThenMiniDumpResponse::symbols), "ns5:ArrayOfstring"))
                {   soap_flag_symbols1--;
                    continue;
                }
            if (soap_flag___item3 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
                if (soap_inliteral(soap, "-item", &(a->xsd__anyType::__item)))
                {   soap_flag___item3--;
                    continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
                soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
                break;
            if (soap->error)
                return NULL;
        }
        if (soap_element_end_in(soap, tag))
            return NULL;
    }
    else
    {   a = (ns1__NeedSymbolsThenMiniDumpResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__NeedSymbolsThenMiniDumpResponse, 0, sizeof(ns1__NeedSymbolsThenMiniDumpResponse), 0, soap_copy_ns1__NeedSymbolsThenMiniDumpResponse);
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_askConfirmation1 > 0))
    {   soap->error = SOAP_OCCURS;
        return NULL;
    }
    return a;
}

int ns1__NeedSymbolsThenMiniDumpResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
    register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns1__NeedSymbolsThenMiniDumpResponse);
    if (this->soap_out(soap, tag?tag:"ns1:NeedSymbolsThenMiniDumpResponse", id, type))
        return soap->error;
    return soap_putindependent(soap);
}

void *ns1__NeedSymbolsThenMiniDumpResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
    return soap_get_ns1__NeedSymbolsThenMiniDumpResponse(soap, this, tag, type);
}

SOAP_FMAC3 ns1__NeedSymbolsThenMiniDumpResponse * SOAP_FMAC4 soap_get_ns1__NeedSymbolsThenMiniDumpResponse(struct soap *soap, ns1__NeedSymbolsThenMiniDumpResponse *p, const char *tag, const char *type)
{
    if ((p = soap_in_ns1__NeedSymbolsThenMiniDumpResponse(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 ns1__NeedSymbolsThenMiniDumpResponse * SOAP_FMAC2 soap_instantiate_ns1__NeedSymbolsThenMiniDumpResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns1__NeedSymbolsThenMiniDumpResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns1__NeedSymbolsThenMiniDumpResponse, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(ns1__NeedSymbolsThenMiniDumpResponse);
        if (size)
            *size = sizeof(ns1__NeedSymbolsThenMiniDumpResponse);
        ((ns1__NeedSymbolsThenMiniDumpResponse*)cp->ptr)->soap = soap;
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(ns1__NeedSymbolsThenMiniDumpResponse, n);
        if (size)
            *size = n * sizeof(ns1__NeedSymbolsThenMiniDumpResponse);
        if (cp->ptr)
            for (int i = 0; i < n; i++)
                ((ns1__NeedSymbolsThenMiniDumpResponse*)cp->ptr)[i].soap = soap;
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (ns1__NeedSymbolsThenMiniDumpResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns1__NeedSymbolsThenMiniDumpResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns1__NeedSymbolsThenMiniDumpResponse %p -> %p\n", q, p));
    *(ns1__NeedSymbolsThenMiniDumpResponse*)p = *(ns1__NeedSymbolsThenMiniDumpResponse*)q;
}

void ns1__HaveSolutionResponse::soap_default(struct soap *soap)
{
    this->soap = soap;
    this->ns1__Response::soap_default(soap);
    soap_default_bool(soap, &this->ns1__HaveSolutionResponse::askConfirmation);
    this->ns1__HaveSolutionResponse::exe = NULL;
    soap_default_ns4__HaveSolutionResponse_SolutionType(soap, &this->ns1__HaveSolutionResponse::type);
    this->ns1__HaveSolutionResponse::url = NULL;
}

void ns1__HaveSolutionResponse::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
    (void)soap; /* appease -Wall -Werror */
    soap_embedded(soap, &this->ns1__HaveSolutionResponse::askConfirmation, SOAP_TYPE_bool);
    soap_serialize_PointerTo_xop__Include(soap, &this->ns1__HaveSolutionResponse::exe);
    soap_serialize_PointerTostd__wstring(soap, &this->ns1__HaveSolutionResponse::url);
    this->ns1__Response::soap_serialize(soap);
#endif
}

int ns1__HaveSolutionResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
    return soap_out_ns1__HaveSolutionResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__HaveSolutionResponse(struct soap *soap, const char *tag, int id, const ns1__HaveSolutionResponse *a, const char *type)
{
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__HaveSolutionResponse), "ns1:HaveSolutionResponse"))
        return soap->error;
    /* transient soap skipped */
    if (soap_out_PointerTostd__wstring(soap, "ns1:clientID", -1, &(a->ns1__Response::clientID), ""))
        return soap->error;
    if (soap_out_PointerTo_xop__Include(soap, "ns1:context", -1, &(a->ns1__Response::context), ""))
        return soap->error;
    if (soap_out_PointerToint(soap, "ns1:dumpGroupID", -1, &(a->ns1__Response::dumpGroupID), ""))
        return soap->error;
    if (soap_out_PointerToint(soap, "ns1:dumpID", -1, &(a->ns1__Response::dumpID), ""))
        return soap->error;
    if (soap_out_PointerTo_xop__Include(soap, "ns1:garbage", -1, &(a->ns1__Response::garbage), ""))
        return soap->error;
    if (soap_out_PointerToint(soap, "ns1:problemID", -1, &(a->ns1__Response::problemID), ""))
        return soap->error;
    if (soap_out_PointerTostd__wstring(soap, "ns1:urlToProblem", -1, &(a->ns1__Response::urlToProblem), ""))
        return soap->error;
    if (soap_out_bool(soap, "ns1:askConfirmation", -1, &(a->ns1__HaveSolutionResponse::askConfirmation), ""))
        return soap->error;
    if (soap_out_PointerTo_xop__Include(soap, "ns1:exe", -1, &(a->ns1__HaveSolutionResponse::exe), ""))
        return soap->error;
    if (soap_out_ns4__HaveSolutionResponse_SolutionType(soap, "ns1:type", -1, &(a->ns1__HaveSolutionResponse::type), ""))
        return soap->error;
    if (soap_out_PointerTostd__wstring(soap, "ns1:url", -1, &(a->ns1__HaveSolutionResponse::url), ""))
        return soap->error;
    return soap_element_end_out(soap, tag);
}

void *ns1__HaveSolutionResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{   return soap_in_ns1__HaveSolutionResponse(soap, tag, this, type);
}

SOAP_FMAC3 ns1__HaveSolutionResponse * SOAP_FMAC4 soap_in_ns1__HaveSolutionResponse(struct soap *soap, const char *tag, ns1__HaveSolutionResponse *a, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    if (soap_element_begin_in(soap, tag, 0, NULL))
        return NULL;
    a = (ns1__HaveSolutionResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__HaveSolutionResponse, sizeof(ns1__HaveSolutionResponse), soap->type, soap->arrayType);
    if (!a)
        return NULL;
    if (soap->alloced)
    {   a->soap_default(soap);
        if (soap->clist->type != SOAP_TYPE_ns1__HaveSolutionResponse)
        {   soap_revert(soap);
            *soap->id = '\0';
            return (ns1__HaveSolutionResponse *)a->soap_in(soap, tag, type);
        }
    }
    size_t soap_flag___item3 = 1;
    size_t soap_flag_clientID2 = 1;
    size_t soap_flag_context2 = 1;
    size_t soap_flag_dumpGroupID2 = 1;
    size_t soap_flag_dumpID2 = 1;
    size_t soap_flag_garbage2 = 1;
    size_t soap_flag_problemID2 = 1;
    size_t soap_flag_urlToProblem2 = 1;
    size_t soap_flag_askConfirmation1 = 1;
    size_t soap_flag_exe1 = 1;
    size_t soap_flag_type1 = 1;
    size_t soap_flag_url1 = 1;
    if (soap->body && !*soap->href)
    {
        for (;;)
        {   soap->error = SOAP_TAG_MISMATCH;
            /* transient soap skipped */
            if (soap_flag_clientID2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
                if (soap_in_PointerTostd__wstring(soap, "ns1:clientID", &(a->ns1__Response::clientID), "xsd:string"))
                {   soap_flag_clientID2--;
                    continue;
                }
            if (soap_flag_context2 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerTo_xop__Include(soap, "ns1:context", &(a->ns1__Response::context), ""))
                {   soap_flag_context2--;
                    continue;
                }
            if (soap_flag_dumpGroupID2 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerToint(soap, "ns1:dumpGroupID", &(a->ns1__Response::dumpGroupID), "xsd:int"))
                {   soap_flag_dumpGroupID2--;
                    continue;
                }
            if (soap_flag_dumpID2 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerToint(soap, "ns1:dumpID", &(a->ns1__Response::dumpID), "xsd:int"))
                {   soap_flag_dumpID2--;
                    continue;
                }
            if (soap_flag_garbage2 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerTo_xop__Include(soap, "ns1:garbage", &(a->ns1__Response::garbage), ""))
                {   soap_flag_garbage2--;
                    continue;
                }
            if (soap_flag_problemID2 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerToint(soap, "ns1:problemID", &(a->ns1__Response::problemID), "xsd:int"))
                {   soap_flag_problemID2--;
                    continue;
                }
            if (soap_flag_urlToProblem2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
                if (soap_in_PointerTostd__wstring(soap, "ns1:urlToProblem", &(a->ns1__Response::urlToProblem), "xsd:string"))
                {   soap_flag_urlToProblem2--;
                    continue;
                }
            if (soap_flag_askConfirmation1 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_bool(soap, "ns1:askConfirmation", &(a->ns1__HaveSolutionResponse::askConfirmation), "xsd:boolean"))
                {   soap_flag_askConfirmation1--;
                    continue;
                }
            if (soap_flag_exe1 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerTo_xop__Include(soap, "ns1:exe", &(a->ns1__HaveSolutionResponse::exe), ""))
                {   soap_flag_exe1--;
                    continue;
                }
            if (soap_flag_type1 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_ns4__HaveSolutionResponse_SolutionType(soap, "ns1:type", &(a->ns1__HaveSolutionResponse::type), "ns4:HaveSolutionResponse.SolutionType"))
                {   soap_flag_type1--;
                    continue;
                }
            if (soap_flag_url1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
                if (soap_in_PointerTostd__wstring(soap, "ns1:url", &(a->ns1__HaveSolutionResponse::url), "xsd:string"))
                {   soap_flag_url1--;
                    continue;
                }
            if (soap_flag___item3 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
                if (soap_inliteral(soap, "-item", &(a->xsd__anyType::__item)))
                {   soap_flag___item3--;
                    continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
                soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
                break;
            if (soap->error)
                return NULL;
        }
        if (soap_element_end_in(soap, tag))
            return NULL;
    }
    else
    {   a = (ns1__HaveSolutionResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__HaveSolutionResponse, 0, sizeof(ns1__HaveSolutionResponse), 0, soap_copy_ns1__HaveSolutionResponse);
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_askConfirmation1 > 0 || soap_flag_type1 > 0))
    {   soap->error = SOAP_OCCURS;
        return NULL;
    }
    return a;
}

int ns1__HaveSolutionResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
    register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns1__HaveSolutionResponse);
    if (this->soap_out(soap, tag?tag:"ns1:HaveSolutionResponse", id, type))
        return soap->error;
    return soap_putindependent(soap);
}

void *ns1__HaveSolutionResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
    return soap_get_ns1__HaveSolutionResponse(soap, this, tag, type);
}

SOAP_FMAC3 ns1__HaveSolutionResponse * SOAP_FMAC4 soap_get_ns1__HaveSolutionResponse(struct soap *soap, ns1__HaveSolutionResponse *p, const char *tag, const char *type)
{
    if ((p = soap_in_ns1__HaveSolutionResponse(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 ns1__HaveSolutionResponse * SOAP_FMAC2 soap_instantiate_ns1__HaveSolutionResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns1__HaveSolutionResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns1__HaveSolutionResponse, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(ns1__HaveSolutionResponse);
        if (size)
            *size = sizeof(ns1__HaveSolutionResponse);
        ((ns1__HaveSolutionResponse*)cp->ptr)->soap = soap;
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(ns1__HaveSolutionResponse, n);
        if (size)
            *size = n * sizeof(ns1__HaveSolutionResponse);
        if (cp->ptr)
            for (int i = 0; i < n; i++)
                ((ns1__HaveSolutionResponse*)cp->ptr)[i].soap = soap;
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (ns1__HaveSolutionResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns1__HaveSolutionResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns1__HaveSolutionResponse %p -> %p\n", q, p));
    *(ns1__HaveSolutionResponse*)p = *(ns1__HaveSolutionResponse*)q;
}

void ns1__ErrorResponse::soap_default(struct soap *soap)
{
    this->soap = soap;
    this->ns1__Response::soap_default(soap);
    this->ns1__ErrorResponse::error = NULL;
}

void ns1__ErrorResponse::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
    (void)soap; /* appease -Wall -Werror */
    soap_serialize_PointerTostd__wstring(soap, &this->ns1__ErrorResponse::error);
    this->ns1__Response::soap_serialize(soap);
#endif
}

int ns1__ErrorResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
    return soap_out_ns1__ErrorResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__ErrorResponse(struct soap *soap, const char *tag, int id, const ns1__ErrorResponse *a, const char *type)
{
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__ErrorResponse), "ns1:ErrorResponse"))
        return soap->error;
    /* transient soap skipped */
    if (soap_out_PointerTostd__wstring(soap, "ns1:clientID", -1, &(a->ns1__Response::clientID), ""))
        return soap->error;
    if (soap_out_PointerTo_xop__Include(soap, "ns1:context", -1, &(a->ns1__Response::context), ""))
        return soap->error;
    if (soap_out_PointerToint(soap, "ns1:dumpGroupID", -1, &(a->ns1__Response::dumpGroupID), ""))
        return soap->error;
    if (soap_out_PointerToint(soap, "ns1:dumpID", -1, &(a->ns1__Response::dumpID), ""))
        return soap->error;
    if (soap_out_PointerTo_xop__Include(soap, "ns1:garbage", -1, &(a->ns1__Response::garbage), ""))
        return soap->error;
    if (soap_out_PointerToint(soap, "ns1:problemID", -1, &(a->ns1__Response::problemID), ""))
        return soap->error;
    if (soap_out_PointerTostd__wstring(soap, "ns1:urlToProblem", -1, &(a->ns1__Response::urlToProblem), ""))
        return soap->error;
    if (soap_out_PointerTostd__wstring(soap, "ns1:error", -1, &(a->ns1__ErrorResponse::error), ""))
        return soap->error;
    return soap_element_end_out(soap, tag);
}

void *ns1__ErrorResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{   return soap_in_ns1__ErrorResponse(soap, tag, this, type);
}

SOAP_FMAC3 ns1__ErrorResponse * SOAP_FMAC4 soap_in_ns1__ErrorResponse(struct soap *soap, const char *tag, ns1__ErrorResponse *a, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    if (soap_element_begin_in(soap, tag, 0, NULL))
        return NULL;
    a = (ns1__ErrorResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__ErrorResponse, sizeof(ns1__ErrorResponse), soap->type, soap->arrayType);
    if (!a)
        return NULL;
    if (soap->alloced)
    {   a->soap_default(soap);
        if (soap->clist->type != SOAP_TYPE_ns1__ErrorResponse)
        {   soap_revert(soap);
            *soap->id = '\0';
            return (ns1__ErrorResponse *)a->soap_in(soap, tag, type);
        }
    }
    size_t soap_flag___item3 = 1;
    size_t soap_flag_clientID2 = 1;
    size_t soap_flag_context2 = 1;
    size_t soap_flag_dumpGroupID2 = 1;
    size_t soap_flag_dumpID2 = 1;
    size_t soap_flag_garbage2 = 1;
    size_t soap_flag_problemID2 = 1;
    size_t soap_flag_urlToProblem2 = 1;
    size_t soap_flag_error1 = 1;
    if (soap->body && !*soap->href)
    {
        for (;;)
        {   soap->error = SOAP_TAG_MISMATCH;
            /* transient soap skipped */
            if (soap_flag_clientID2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
                if (soap_in_PointerTostd__wstring(soap, "ns1:clientID", &(a->ns1__Response::clientID), "xsd:string"))
                {   soap_flag_clientID2--;
                    continue;
                }
            if (soap_flag_context2 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerTo_xop__Include(soap, "ns1:context", &(a->ns1__Response::context), ""))
                {   soap_flag_context2--;
                    continue;
                }
            if (soap_flag_dumpGroupID2 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerToint(soap, "ns1:dumpGroupID", &(a->ns1__Response::dumpGroupID), "xsd:int"))
                {   soap_flag_dumpGroupID2--;
                    continue;
                }
            if (soap_flag_dumpID2 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerToint(soap, "ns1:dumpID", &(a->ns1__Response::dumpID), "xsd:int"))
                {   soap_flag_dumpID2--;
                    continue;
                }
            if (soap_flag_garbage2 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerTo_xop__Include(soap, "ns1:garbage", &(a->ns1__Response::garbage), ""))
                {   soap_flag_garbage2--;
                    continue;
                }
            if (soap_flag_problemID2 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerToint(soap, "ns1:problemID", &(a->ns1__Response::problemID), "xsd:int"))
                {   soap_flag_problemID2--;
                    continue;
                }
            if (soap_flag_urlToProblem2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
                if (soap_in_PointerTostd__wstring(soap, "ns1:urlToProblem", &(a->ns1__Response::urlToProblem), "xsd:string"))
                {   soap_flag_urlToProblem2--;
                    continue;
                }
            if (soap_flag_error1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
                if (soap_in_PointerTostd__wstring(soap, "ns1:error", &(a->ns1__ErrorResponse::error), "xsd:string"))
                {   soap_flag_error1--;
                    continue;
                }
            if (soap_flag___item3 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
                if (soap_inliteral(soap, "-item", &(a->xsd__anyType::__item)))
                {   soap_flag___item3--;
                    continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
                soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
                break;
            if (soap->error)
                return NULL;
        }
        if (soap_element_end_in(soap, tag))
            return NULL;
    }
    else
    {   a = (ns1__ErrorResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__ErrorResponse, 0, sizeof(ns1__ErrorResponse), 0, soap_copy_ns1__ErrorResponse);
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    return a;
}

int ns1__ErrorResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
    register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns1__ErrorResponse);
    if (this->soap_out(soap, tag?tag:"ns1:ErrorResponse", id, type))
        return soap->error;
    return soap_putindependent(soap);
}

void *ns1__ErrorResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
    return soap_get_ns1__ErrorResponse(soap, this, tag, type);
}

SOAP_FMAC3 ns1__ErrorResponse * SOAP_FMAC4 soap_get_ns1__ErrorResponse(struct soap *soap, ns1__ErrorResponse *p, const char *tag, const char *type)
{
    if ((p = soap_in_ns1__ErrorResponse(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 ns1__ErrorResponse * SOAP_FMAC2 soap_instantiate_ns1__ErrorResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns1__ErrorResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns1__ErrorResponse, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(ns1__ErrorResponse);
        if (size)
            *size = sizeof(ns1__ErrorResponse);
        ((ns1__ErrorResponse*)cp->ptr)->soap = soap;
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(ns1__ErrorResponse, n);
        if (size)
            *size = n * sizeof(ns1__ErrorResponse);
        if (cp->ptr)
            for (int i = 0; i < n; i++)
                ((ns1__ErrorResponse*)cp->ptr)[i].soap = soap;
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (ns1__ErrorResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns1__ErrorResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns1__ErrorResponse %p -> %p\n", q, p));
    *(ns1__ErrorResponse*)p = *(ns1__ErrorResponse*)q;
}

void ns1__StopResponse::soap_default(struct soap *soap)
{
    this->soap = soap;
    this->ns1__Response::soap_default(soap);
}

void ns1__StopResponse::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
    (void)soap; /* appease -Wall -Werror */
    this->ns1__Response::soap_serialize(soap);
#endif
}

int ns1__StopResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
    return soap_out_ns1__StopResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__StopResponse(struct soap *soap, const char *tag, int id, const ns1__StopResponse *a, const char *type)
{
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__StopResponse), "ns1:StopResponse"))
        return soap->error;
    /* transient soap skipped */
    if (soap_out_PointerTostd__wstring(soap, "ns1:clientID", -1, &(a->ns1__Response::clientID), ""))
        return soap->error;
    if (soap_out_PointerTo_xop__Include(soap, "ns1:context", -1, &(a->ns1__Response::context), ""))
        return soap->error;
    if (soap_out_PointerToint(soap, "ns1:dumpGroupID", -1, &(a->ns1__Response::dumpGroupID), ""))
        return soap->error;
    if (soap_out_PointerToint(soap, "ns1:dumpID", -1, &(a->ns1__Response::dumpID), ""))
        return soap->error;
    if (soap_out_PointerTo_xop__Include(soap, "ns1:garbage", -1, &(a->ns1__Response::garbage), ""))
        return soap->error;
    if (soap_out_PointerToint(soap, "ns1:problemID", -1, &(a->ns1__Response::problemID), ""))
        return soap->error;
    if (soap_out_PointerTostd__wstring(soap, "ns1:urlToProblem", -1, &(a->ns1__Response::urlToProblem), ""))
        return soap->error;
    return soap_element_end_out(soap, tag);
}

void *ns1__StopResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{   return soap_in_ns1__StopResponse(soap, tag, this, type);
}

SOAP_FMAC3 ns1__StopResponse * SOAP_FMAC4 soap_in_ns1__StopResponse(struct soap *soap, const char *tag, ns1__StopResponse *a, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    if (soap_element_begin_in(soap, tag, 0, NULL))
        return NULL;
    a = (ns1__StopResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__StopResponse, sizeof(ns1__StopResponse), soap->type, soap->arrayType);
    if (!a)
        return NULL;
    if (soap->alloced)
    {   a->soap_default(soap);
        if (soap->clist->type != SOAP_TYPE_ns1__StopResponse)
        {   soap_revert(soap);
            *soap->id = '\0';
            return (ns1__StopResponse *)a->soap_in(soap, tag, type);
        }
    }
    size_t soap_flag___item3 = 1;
    size_t soap_flag_clientID2 = 1;
    size_t soap_flag_context2 = 1;
    size_t soap_flag_dumpGroupID2 = 1;
    size_t soap_flag_dumpID2 = 1;
    size_t soap_flag_garbage2 = 1;
    size_t soap_flag_problemID2 = 1;
    size_t soap_flag_urlToProblem2 = 1;
    if (soap->body && !*soap->href)
    {
        for (;;)
        {   soap->error = SOAP_TAG_MISMATCH;
            /* transient soap skipped */
            if (soap_flag_clientID2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
                if (soap_in_PointerTostd__wstring(soap, "ns1:clientID", &(a->ns1__Response::clientID), "xsd:string"))
                {   soap_flag_clientID2--;
                    continue;
                }
            if (soap_flag_context2 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerTo_xop__Include(soap, "ns1:context", &(a->ns1__Response::context), ""))
                {   soap_flag_context2--;
                    continue;
                }
            if (soap_flag_dumpGroupID2 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerToint(soap, "ns1:dumpGroupID", &(a->ns1__Response::dumpGroupID), "xsd:int"))
                {   soap_flag_dumpGroupID2--;
                    continue;
                }
            if (soap_flag_dumpID2 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerToint(soap, "ns1:dumpID", &(a->ns1__Response::dumpID), "xsd:int"))
                {   soap_flag_dumpID2--;
                    continue;
                }
            if (soap_flag_garbage2 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerTo_xop__Include(soap, "ns1:garbage", &(a->ns1__Response::garbage), ""))
                {   soap_flag_garbage2--;
                    continue;
                }
            if (soap_flag_problemID2 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerToint(soap, "ns1:problemID", &(a->ns1__Response::problemID), "xsd:int"))
                {   soap_flag_problemID2--;
                    continue;
                }
            if (soap_flag_urlToProblem2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
                if (soap_in_PointerTostd__wstring(soap, "ns1:urlToProblem", &(a->ns1__Response::urlToProblem), "xsd:string"))
                {   soap_flag_urlToProblem2--;
                    continue;
                }
            if (soap_flag___item3 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
                if (soap_inliteral(soap, "-item", &(a->xsd__anyType::__item)))
                {   soap_flag___item3--;
                    continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
                soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
                break;
            if (soap->error)
                return NULL;
        }
        if (soap_element_end_in(soap, tag))
            return NULL;
    }
    else
    {   a = (ns1__StopResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__StopResponse, 0, sizeof(ns1__StopResponse), 0, soap_copy_ns1__StopResponse);
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    return a;
}

int ns1__StopResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
    register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns1__StopResponse);
    if (this->soap_out(soap, tag?tag:"ns1:StopResponse", id, type))
        return soap->error;
    return soap_putindependent(soap);
}

void *ns1__StopResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
    return soap_get_ns1__StopResponse(soap, this, tag, type);
}

SOAP_FMAC3 ns1__StopResponse * SOAP_FMAC4 soap_get_ns1__StopResponse(struct soap *soap, ns1__StopResponse *p, const char *tag, const char *type)
{
    if ((p = soap_in_ns1__StopResponse(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 ns1__StopResponse * SOAP_FMAC2 soap_instantiate_ns1__StopResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns1__StopResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns1__StopResponse, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(ns1__StopResponse);
        if (size)
            *size = sizeof(ns1__StopResponse);
        ((ns1__StopResponse*)cp->ptr)->soap = soap;
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(ns1__StopResponse, n);
        if (size)
            *size = n * sizeof(ns1__StopResponse);
        if (cp->ptr)
            for (int i = 0; i < n; i++)
                ((ns1__StopResponse*)cp->ptr)[i].soap = soap;
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (ns1__StopResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns1__StopResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns1__StopResponse %p -> %p\n", q, p));
    *(ns1__StopResponse*)p = *(ns1__StopResponse*)q;
}

void ns1__Response::soap_default(struct soap *soap)
{
    this->soap = soap;
    this->xsd__anyType::soap_default(soap);
    this->ns1__Response::clientID = NULL;
    this->ns1__Response::context = NULL;
    this->ns1__Response::dumpGroupID = NULL;
    this->ns1__Response::dumpID = NULL;
    this->ns1__Response::garbage = NULL;
    this->ns1__Response::problemID = NULL;
    this->ns1__Response::urlToProblem = NULL;
}

void ns1__Response::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
    (void)soap; /* appease -Wall -Werror */
    soap_serialize_PointerTostd__wstring(soap, &this->ns1__Response::clientID);
    soap_serialize_PointerTo_xop__Include(soap, &this->ns1__Response::context);
    soap_serialize_PointerToint(soap, &this->ns1__Response::dumpGroupID);
    soap_serialize_PointerToint(soap, &this->ns1__Response::dumpID);
    soap_serialize_PointerTo_xop__Include(soap, &this->ns1__Response::garbage);
    soap_serialize_PointerToint(soap, &this->ns1__Response::problemID);
    soap_serialize_PointerTostd__wstring(soap, &this->ns1__Response::urlToProblem);
    this->xsd__anyType::soap_serialize(soap);
#endif
}

int ns1__Response::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
    return soap_out_ns1__Response(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__Response(struct soap *soap, const char *tag, int id, const ns1__Response *a, const char *type)
{
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__Response), "ns1:Response"))
        return soap->error;
    /* transient soap skipped */
    if (soap_out_PointerTostd__wstring(soap, "ns1:clientID", -1, &(a->ns1__Response::clientID), ""))
        return soap->error;
    if (soap_out_PointerTo_xop__Include(soap, "ns1:context", -1, &(a->ns1__Response::context), ""))
        return soap->error;
    if (soap_out_PointerToint(soap, "ns1:dumpGroupID", -1, &(a->ns1__Response::dumpGroupID), ""))
        return soap->error;
    if (soap_out_PointerToint(soap, "ns1:dumpID", -1, &(a->ns1__Response::dumpID), ""))
        return soap->error;
    if (soap_out_PointerTo_xop__Include(soap, "ns1:garbage", -1, &(a->ns1__Response::garbage), ""))
        return soap->error;
    if (soap_out_PointerToint(soap, "ns1:problemID", -1, &(a->ns1__Response::problemID), ""))
        return soap->error;
    if (soap_out_PointerTostd__wstring(soap, "ns1:urlToProblem", -1, &(a->ns1__Response::urlToProblem), ""))
        return soap->error;
    return soap_element_end_out(soap, tag);
}

void *ns1__Response::soap_in(struct soap *soap, const char *tag, const char *type)
{   return soap_in_ns1__Response(soap, tag, this, type);
}

SOAP_FMAC3 ns1__Response * SOAP_FMAC4 soap_in_ns1__Response(struct soap *soap, const char *tag, ns1__Response *a, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    if (soap_element_begin_in(soap, tag, 0, NULL))
        return NULL;
    a = (ns1__Response *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__Response, sizeof(ns1__Response), soap->type, soap->arrayType);
    if (!a)
        return NULL;
    if (soap->alloced)
    {   a->soap_default(soap);
        if (soap->clist->type != SOAP_TYPE_ns1__Response)
        {   soap_revert(soap);
            *soap->id = '\0';
            return (ns1__Response *)a->soap_in(soap, tag, type);
        }
    }
    size_t soap_flag___item2 = 1;
    size_t soap_flag_clientID1 = 1;
    size_t soap_flag_context1 = 1;
    size_t soap_flag_dumpGroupID1 = 1;
    size_t soap_flag_dumpID1 = 1;
    size_t soap_flag_garbage1 = 1;
    size_t soap_flag_problemID1 = 1;
    size_t soap_flag_urlToProblem1 = 1;
    if (soap->body && !*soap->href)
    {
        for (;;)
        {   soap->error = SOAP_TAG_MISMATCH;
            /* transient soap skipped */
            if (soap_flag_clientID1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
                if (soap_in_PointerTostd__wstring(soap, "ns1:clientID", &(a->ns1__Response::clientID), "xsd:string"))
                {   soap_flag_clientID1--;
                    continue;
                }
            if (soap_flag_context1 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerTo_xop__Include(soap, "ns1:context", &(a->ns1__Response::context), ""))
                {   soap_flag_context1--;
                    continue;
                }
            if (soap_flag_dumpGroupID1 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerToint(soap, "ns1:dumpGroupID", &(a->ns1__Response::dumpGroupID), "xsd:int"))
                {   soap_flag_dumpGroupID1--;
                    continue;
                }
            if (soap_flag_dumpID1 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerToint(soap, "ns1:dumpID", &(a->ns1__Response::dumpID), "xsd:int"))
                {   soap_flag_dumpID1--;
                    continue;
                }
            if (soap_flag_garbage1 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerTo_xop__Include(soap, "ns1:garbage", &(a->ns1__Response::garbage), ""))
                {   soap_flag_garbage1--;
                    continue;
                }
            if (soap_flag_problemID1 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerToint(soap, "ns1:problemID", &(a->ns1__Response::problemID), "xsd:int"))
                {   soap_flag_problemID1--;
                    continue;
                }
            if (soap_flag_urlToProblem1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
                if (soap_in_PointerTostd__wstring(soap, "ns1:urlToProblem", &(a->ns1__Response::urlToProblem), "xsd:string"))
                {   soap_flag_urlToProblem1--;
                    continue;
                }
            if (soap_flag___item2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
                if (soap_inliteral(soap, "-item", &(a->xsd__anyType::__item)))
                {   soap_flag___item2--;
                    continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
                soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
                break;
            if (soap->error)
                return NULL;
        }
        if (soap_element_end_in(soap, tag))
            return NULL;
    }
    else
    {   a = (ns1__Response *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__Response, 0, sizeof(ns1__Response), 0, soap_copy_ns1__Response);
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    return a;
}

int ns1__Response::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
    register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns1__Response);
    if (this->soap_out(soap, tag?tag:"ns1:Response", id, type))
        return soap->error;
    return soap_putindependent(soap);
}

void *ns1__Response::soap_get(struct soap *soap, const char *tag, const char *type)
{
    return soap_get_ns1__Response(soap, this, tag, type);
}

SOAP_FMAC3 ns1__Response * SOAP_FMAC4 soap_get_ns1__Response(struct soap *soap, ns1__Response *p, const char *tag, const char *type)
{
    if ((p = soap_in_ns1__Response(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 ns1__Response * SOAP_FMAC2 soap_instantiate_ns1__Response(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns1__Response(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns1__Response, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (type && !soap_match_tag(soap, type, "ns1:StopResponse"))
    {   cp->type = SOAP_TYPE_ns1__StopResponse;
        if (n < 0)
        {   cp->ptr = (void*)SOAP_NEW(ns1__StopResponse);
            if (size)
                *size = sizeof(ns1__StopResponse);
            ((ns1__StopResponse*)cp->ptr)->soap = soap;
        }
        else
        {   cp->ptr = (void*)SOAP_NEW_ARRAY(ns1__StopResponse, n);
            if (size)
                *size = n * sizeof(ns1__StopResponse);
            if (cp->ptr)
                for (int i = 0; i < n; i++)
                    ((ns1__StopResponse*)cp->ptr)[i].soap = soap;
        }
        DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
        if (!cp->ptr)
            soap->error = SOAP_EOM;
        return (ns1__StopResponse*)cp->ptr;
    }
    if (type && !soap_match_tag(soap, type, "ns1:ErrorResponse"))
    {   cp->type = SOAP_TYPE_ns1__ErrorResponse;
        if (n < 0)
        {   cp->ptr = (void*)SOAP_NEW(ns1__ErrorResponse);
            if (size)
                *size = sizeof(ns1__ErrorResponse);
            ((ns1__ErrorResponse*)cp->ptr)->soap = soap;
        }
        else
        {   cp->ptr = (void*)SOAP_NEW_ARRAY(ns1__ErrorResponse, n);
            if (size)
                *size = n * sizeof(ns1__ErrorResponse);
            if (cp->ptr)
                for (int i = 0; i < n; i++)
                    ((ns1__ErrorResponse*)cp->ptr)[i].soap = soap;
        }
        DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
        if (!cp->ptr)
            soap->error = SOAP_EOM;
        return (ns1__ErrorResponse*)cp->ptr;
    }
    if (type && !soap_match_tag(soap, type, "ns1:HaveSolutionResponse"))
    {   cp->type = SOAP_TYPE_ns1__HaveSolutionResponse;
        if (n < 0)
        {   cp->ptr = (void*)SOAP_NEW(ns1__HaveSolutionResponse);
            if (size)
                *size = sizeof(ns1__HaveSolutionResponse);
            ((ns1__HaveSolutionResponse*)cp->ptr)->soap = soap;
        }
        else
        {   cp->ptr = (void*)SOAP_NEW_ARRAY(ns1__HaveSolutionResponse, n);
            if (size)
                *size = n * sizeof(ns1__HaveSolutionResponse);
            if (cp->ptr)
                for (int i = 0; i < n; i++)
                    ((ns1__HaveSolutionResponse*)cp->ptr)[i].soap = soap;
        }
        DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
        if (!cp->ptr)
            soap->error = SOAP_EOM;
        return (ns1__HaveSolutionResponse*)cp->ptr;
    }
    if (type && !soap_match_tag(soap, type, "ns1:NeedSymbolsThenMiniDumpResponse"))
    {   cp->type = SOAP_TYPE_ns1__NeedSymbolsThenMiniDumpResponse;
        if (n < 0)
        {   cp->ptr = (void*)SOAP_NEW(ns1__NeedSymbolsThenMiniDumpResponse);
            if (size)
                *size = sizeof(ns1__NeedSymbolsThenMiniDumpResponse);
            ((ns1__NeedSymbolsThenMiniDumpResponse*)cp->ptr)->soap = soap;
        }
        else
        {   cp->ptr = (void*)SOAP_NEW_ARRAY(ns1__NeedSymbolsThenMiniDumpResponse, n);
            if (size)
                *size = n * sizeof(ns1__NeedSymbolsThenMiniDumpResponse);
            if (cp->ptr)
                for (int i = 0; i < n; i++)
                    ((ns1__NeedSymbolsThenMiniDumpResponse*)cp->ptr)[i].soap = soap;
        }
        DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
        if (!cp->ptr)
            soap->error = SOAP_EOM;
        return (ns1__NeedSymbolsThenMiniDumpResponse*)cp->ptr;
    }
    if (type && !soap_match_tag(soap, type, "ns1:NeedMiniDumpResponse"))
    {   cp->type = SOAP_TYPE_ns1__NeedMiniDumpResponse;
        if (n < 0)
        {   cp->ptr = (void*)SOAP_NEW(ns1__NeedMiniDumpResponse);
            if (size)
                *size = sizeof(ns1__NeedMiniDumpResponse);
            ((ns1__NeedMiniDumpResponse*)cp->ptr)->soap = soap;
        }
        else
        {   cp->ptr = (void*)SOAP_NEW_ARRAY(ns1__NeedMiniDumpResponse, n);
            if (size)
                *size = n * sizeof(ns1__NeedMiniDumpResponse);
            if (cp->ptr)
                for (int i = 0; i < n; i++)
                    ((ns1__NeedMiniDumpResponse*)cp->ptr)[i].soap = soap;
        }
        DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
        if (!cp->ptr)
            soap->error = SOAP_EOM;
        return (ns1__NeedMiniDumpResponse*)cp->ptr;
    }
    if (type && !soap_match_tag(soap, type, "ns1:NeedFullDumpResponse"))
    {   cp->type = SOAP_TYPE_ns1__NeedFullDumpResponse;
        if (n < 0)
        {   cp->ptr = (void*)SOAP_NEW(ns1__NeedFullDumpResponse);
            if (size)
                *size = sizeof(ns1__NeedFullDumpResponse);
            ((ns1__NeedFullDumpResponse*)cp->ptr)->soap = soap;
        }
        else
        {   cp->ptr = (void*)SOAP_NEW_ARRAY(ns1__NeedFullDumpResponse, n);
            if (size)
                *size = n * sizeof(ns1__NeedFullDumpResponse);
            if (cp->ptr)
                for (int i = 0; i < n; i++)
                    ((ns1__NeedFullDumpResponse*)cp->ptr)[i].soap = soap;
        }
        DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
        if (!cp->ptr)
            soap->error = SOAP_EOM;
        return (ns1__NeedFullDumpResponse*)cp->ptr;
    }
    if (type && !soap_match_tag(soap, type, "ns1:NeedMoreInfoResponse"))
    {   cp->type = SOAP_TYPE_ns1__NeedMoreInfoResponse;
        if (n < 0)
        {   cp->ptr = (void*)SOAP_NEW(ns1__NeedMoreInfoResponse);
            if (size)
                *size = sizeof(ns1__NeedMoreInfoResponse);
            ((ns1__NeedMoreInfoResponse*)cp->ptr)->soap = soap;
        }
        else
        {   cp->ptr = (void*)SOAP_NEW_ARRAY(ns1__NeedMoreInfoResponse, n);
            if (size)
                *size = n * sizeof(ns1__NeedMoreInfoResponse);
            if (cp->ptr)
                for (int i = 0; i < n; i++)
                    ((ns1__NeedMoreInfoResponse*)cp->ptr)[i].soap = soap;
        }
        DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
        if (!cp->ptr)
            soap->error = SOAP_EOM;
        return (ns1__NeedMoreInfoResponse*)cp->ptr;
    }
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(ns1__Response);
        if (size)
            *size = sizeof(ns1__Response);
        ((ns1__Response*)cp->ptr)->soap = soap;
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(ns1__Response, n);
        if (size)
            *size = n * sizeof(ns1__Response);
        if (cp->ptr)
            for (int i = 0; i < n; i++)
                ((ns1__Response*)cp->ptr)[i].soap = soap;
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (ns1__Response*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns1__Response(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns1__Response %p -> %p\n", q, p));
    *(ns1__Response*)p = *(ns1__Response*)q;
}

void ns1__Pdb70File::soap_default(struct soap *soap)
{
    this->soap = soap;
    this->xsd__anyType::soap_default(soap);
    soap_default_unsignedInt(soap, &this->ns1__Pdb70File::age);
    this->ns1__Pdb70File::path = NULL;
    soap_default_ns3__guid(soap, &this->ns1__Pdb70File::signature);
}

void ns1__Pdb70File::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
    (void)soap; /* appease -Wall -Werror */
    soap_serialize_PointerTostd__wstring(soap, &this->ns1__Pdb70File::path);
    soap_serialize_ns3__guid(soap, &this->ns1__Pdb70File::signature);
    this->xsd__anyType::soap_serialize(soap);
#endif
}

int ns1__Pdb70File::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
    return soap_out_ns1__Pdb70File(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__Pdb70File(struct soap *soap, const char *tag, int id, const ns1__Pdb70File *a, const char *type)
{
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__Pdb70File), "ns1:Pdb70File"))
        return soap->error;
    /* transient soap skipped */
    if (soap_out_unsignedInt(soap, "ns1:age", -1, &(a->ns1__Pdb70File::age), ""))
        return soap->error;
    if (soap_out_PointerTostd__wstring(soap, "ns1:path", -1, &(a->ns1__Pdb70File::path), ""))
        return soap->error;
    if (soap_out_ns3__guid(soap, "ns1:signature", -1, &(a->ns1__Pdb70File::signature), ""))
        return soap->error;
    return soap_element_end_out(soap, tag);
}

void *ns1__Pdb70File::soap_in(struct soap *soap, const char *tag, const char *type)
{   return soap_in_ns1__Pdb70File(soap, tag, this, type);
}

SOAP_FMAC3 ns1__Pdb70File * SOAP_FMAC4 soap_in_ns1__Pdb70File(struct soap *soap, const char *tag, ns1__Pdb70File *a, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    if (soap_element_begin_in(soap, tag, 0, NULL))
        return NULL;
    a = (ns1__Pdb70File *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__Pdb70File, sizeof(ns1__Pdb70File), soap->type, soap->arrayType);
    if (!a)
        return NULL;
    if (soap->alloced)
    {   a->soap_default(soap);
        if (soap->clist->type != SOAP_TYPE_ns1__Pdb70File)
        {   soap_revert(soap);
            *soap->id = '\0';
            return (ns1__Pdb70File *)a->soap_in(soap, tag, type);
        }
    }
    size_t soap_flag___item2 = 1;
    size_t soap_flag_age1 = 1;
    size_t soap_flag_path1 = 1;
    size_t soap_flag_signature1 = 1;
    if (soap->body && !*soap->href)
    {
        for (;;)
        {   soap->error = SOAP_TAG_MISMATCH;
            /* transient soap skipped */
            if (soap_flag_age1 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_unsignedInt(soap, "ns1:age", &(a->ns1__Pdb70File::age), "xsd:unsignedInt"))
                {   soap_flag_age1--;
                    continue;
                }
            if (soap_flag_path1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
                if (soap_in_PointerTostd__wstring(soap, "ns1:path", &(a->ns1__Pdb70File::path), "xsd:string"))
                {   soap_flag_path1--;
                    continue;
                }
            if (soap_flag_signature1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
                if (soap_in_ns3__guid(soap, "ns1:signature", &(a->ns1__Pdb70File::signature), "ns3:guid"))
                {   soap_flag_signature1--;
                    continue;
                }
            if (soap_flag___item2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
                if (soap_inliteral(soap, "-item", &(a->xsd__anyType::__item)))
                {   soap_flag___item2--;
                    continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
                soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
                break;
            if (soap->error)
                return NULL;
        }
        if (soap_element_end_in(soap, tag))
            return NULL;
    }
    else
    {   a = (ns1__Pdb70File *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__Pdb70File, 0, sizeof(ns1__Pdb70File), 0, soap_copy_ns1__Pdb70File);
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_age1 > 0 || soap_flag_signature1 > 0))
    {   soap->error = SOAP_OCCURS;
        return NULL;
    }
    return a;
}

int ns1__Pdb70File::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
    register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns1__Pdb70File);
    if (this->soap_out(soap, tag?tag:"ns1:Pdb70File", id, type))
        return soap->error;
    return soap_putindependent(soap);
}

void *ns1__Pdb70File::soap_get(struct soap *soap, const char *tag, const char *type)
{
    return soap_get_ns1__Pdb70File(soap, this, tag, type);
}

SOAP_FMAC3 ns1__Pdb70File * SOAP_FMAC4 soap_get_ns1__Pdb70File(struct soap *soap, ns1__Pdb70File *p, const char *tag, const char *type)
{
    if ((p = soap_in_ns1__Pdb70File(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 ns1__Pdb70File * SOAP_FMAC2 soap_instantiate_ns1__Pdb70File(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns1__Pdb70File(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns1__Pdb70File, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(ns1__Pdb70File);
        if (size)
            *size = sizeof(ns1__Pdb70File);
        ((ns1__Pdb70File*)cp->ptr)->soap = soap;
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(ns1__Pdb70File, n);
        if (size)
            *size = n * sizeof(ns1__Pdb70File);
        if (cp->ptr)
            for (int i = 0; i < n; i++)
                ((ns1__Pdb70File*)cp->ptr)[i].soap = soap;
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (ns1__Pdb70File*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns1__Pdb70File(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns1__Pdb70File %p -> %p\n", q, p));
    *(ns1__Pdb70File*)p = *(ns1__Pdb70File*)q;
}

void ns1__ModuleSymbolInfo::soap_default(struct soap *soap)
{
    this->soap = soap;
    this->xsd__anyType::soap_default(soap);
    soap_default_bool(soap, &this->ns1__ModuleSymbolInfo::isMicrosoftModule);
    this->ns1__ModuleSymbolInfo::path = NULL;
    this->ns1__ModuleSymbolInfo::pdb = NULL;
    soap_default_unsignedInt(soap, &this->ns1__ModuleSymbolInfo::sizeOfImage);
    soap_default_unsignedInt(soap, &this->ns1__ModuleSymbolInfo::timeDateStamp);
}

void ns1__ModuleSymbolInfo::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
    (void)soap; /* appease -Wall -Werror */
    soap_embedded(soap, &this->ns1__ModuleSymbolInfo::isMicrosoftModule, SOAP_TYPE_bool);
    soap_serialize_PointerTostd__wstring(soap, &this->ns1__ModuleSymbolInfo::path);
    soap_serialize_PointerTons1__Pdb70File(soap, &this->ns1__ModuleSymbolInfo::pdb);
    this->xsd__anyType::soap_serialize(soap);
#endif
}

int ns1__ModuleSymbolInfo::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
    return soap_out_ns1__ModuleSymbolInfo(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__ModuleSymbolInfo(struct soap *soap, const char *tag, int id, const ns1__ModuleSymbolInfo *a, const char *type)
{
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__ModuleSymbolInfo), "ns1:ModuleSymbolInfo"))
        return soap->error;
    /* transient soap skipped */
    if (soap_out_bool(soap, "ns1:isMicrosoftModule", -1, &(a->ns1__ModuleSymbolInfo::isMicrosoftModule), ""))
        return soap->error;
    if (soap_out_PointerTostd__wstring(soap, "ns1:path", -1, &(a->ns1__ModuleSymbolInfo::path), ""))
        return soap->error;
    if (soap_out_PointerTons1__Pdb70File(soap, "ns1:pdb", -1, &(a->ns1__ModuleSymbolInfo::pdb), ""))
        return soap->error;
    if (soap_out_unsignedInt(soap, "ns1:sizeOfImage", -1, &(a->ns1__ModuleSymbolInfo::sizeOfImage), ""))
        return soap->error;
    if (soap_out_unsignedInt(soap, "ns1:timeDateStamp", -1, &(a->ns1__ModuleSymbolInfo::timeDateStamp), ""))
        return soap->error;
    return soap_element_end_out(soap, tag);
}

void *ns1__ModuleSymbolInfo::soap_in(struct soap *soap, const char *tag, const char *type)
{   return soap_in_ns1__ModuleSymbolInfo(soap, tag, this, type);
}

SOAP_FMAC3 ns1__ModuleSymbolInfo * SOAP_FMAC4 soap_in_ns1__ModuleSymbolInfo(struct soap *soap, const char *tag, ns1__ModuleSymbolInfo *a, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    if (soap_element_begin_in(soap, tag, 0, NULL))
        return NULL;
    a = (ns1__ModuleSymbolInfo *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__ModuleSymbolInfo, sizeof(ns1__ModuleSymbolInfo), soap->type, soap->arrayType);
    if (!a)
        return NULL;
    if (soap->alloced)
    {   a->soap_default(soap);
        if (soap->clist->type != SOAP_TYPE_ns1__ModuleSymbolInfo)
        {   soap_revert(soap);
            *soap->id = '\0';
            return (ns1__ModuleSymbolInfo *)a->soap_in(soap, tag, type);
        }
    }
    size_t soap_flag___item2 = 1;
    size_t soap_flag_isMicrosoftModule1 = 1;
    size_t soap_flag_path1 = 1;
    size_t soap_flag_pdb1 = 1;
    size_t soap_flag_sizeOfImage1 = 1;
    size_t soap_flag_timeDateStamp1 = 1;
    if (soap->body && !*soap->href)
    {
        for (;;)
        {   soap->error = SOAP_TAG_MISMATCH;
            /* transient soap skipped */
            if (soap_flag_isMicrosoftModule1 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_bool(soap, "ns1:isMicrosoftModule", &(a->ns1__ModuleSymbolInfo::isMicrosoftModule), "xsd:boolean"))
                {   soap_flag_isMicrosoftModule1--;
                    continue;
                }
            if (soap_flag_path1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
                if (soap_in_PointerTostd__wstring(soap, "ns1:path", &(a->ns1__ModuleSymbolInfo::path), "xsd:string"))
                {   soap_flag_path1--;
                    continue;
                }
            if (soap_flag_pdb1 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerTons1__Pdb70File(soap, "ns1:pdb", &(a->ns1__ModuleSymbolInfo::pdb), "ns1:Pdb70File"))
                {   soap_flag_pdb1--;
                    continue;
                }
            if (soap_flag_sizeOfImage1 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_unsignedInt(soap, "ns1:sizeOfImage", &(a->ns1__ModuleSymbolInfo::sizeOfImage), "xsd:unsignedInt"))
                {   soap_flag_sizeOfImage1--;
                    continue;
                }
            if (soap_flag_timeDateStamp1 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_unsignedInt(soap, "ns1:timeDateStamp", &(a->ns1__ModuleSymbolInfo::timeDateStamp), "xsd:unsignedInt"))
                {   soap_flag_timeDateStamp1--;
                    continue;
                }
            if (soap_flag___item2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
                if (soap_inliteral(soap, "-item", &(a->xsd__anyType::__item)))
                {   soap_flag___item2--;
                    continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
                soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
                break;
            if (soap->error)
                return NULL;
        }
        if (soap_element_end_in(soap, tag))
            return NULL;
    }
    else
    {   a = (ns1__ModuleSymbolInfo *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__ModuleSymbolInfo, 0, sizeof(ns1__ModuleSymbolInfo), 0, soap_copy_ns1__ModuleSymbolInfo);
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_isMicrosoftModule1 > 0 || soap_flag_sizeOfImage1 > 0 || soap_flag_timeDateStamp1 > 0))
    {   soap->error = SOAP_OCCURS;
        return NULL;
    }
    return a;
}

int ns1__ModuleSymbolInfo::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
    register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns1__ModuleSymbolInfo);
    if (this->soap_out(soap, tag?tag:"ns1:ModuleSymbolInfo", id, type))
        return soap->error;
    return soap_putindependent(soap);
}

void *ns1__ModuleSymbolInfo::soap_get(struct soap *soap, const char *tag, const char *type)
{
    return soap_get_ns1__ModuleSymbolInfo(soap, this, tag, type);
}

SOAP_FMAC3 ns1__ModuleSymbolInfo * SOAP_FMAC4 soap_get_ns1__ModuleSymbolInfo(struct soap *soap, ns1__ModuleSymbolInfo *p, const char *tag, const char *type)
{
    if ((p = soap_in_ns1__ModuleSymbolInfo(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 ns1__ModuleSymbolInfo * SOAP_FMAC2 soap_instantiate_ns1__ModuleSymbolInfo(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns1__ModuleSymbolInfo(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns1__ModuleSymbolInfo, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(ns1__ModuleSymbolInfo);
        if (size)
            *size = sizeof(ns1__ModuleSymbolInfo);
        ((ns1__ModuleSymbolInfo*)cp->ptr)->soap = soap;
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(ns1__ModuleSymbolInfo, n);
        if (size)
            *size = n * sizeof(ns1__ModuleSymbolInfo);
        if (cp->ptr)
            for (int i = 0; i < n; i++)
                ((ns1__ModuleSymbolInfo*)cp->ptr)[i].soap = soap;
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (ns1__ModuleSymbolInfo*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns1__ModuleSymbolInfo(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns1__ModuleSymbolInfo %p -> %p\n", q, p));
    *(ns1__ModuleSymbolInfo*)p = *(ns1__ModuleSymbolInfo*)q;
}

void ns1__ArrayOfModuleSymbolInfo::soap_default(struct soap *soap)
{
    this->soap = soap;
    this->xsd__anyType::soap_default(soap);
    soap_default_std__vectorTemplateOfPointerTons1__ModuleSymbolInfo(soap, &this->ns1__ArrayOfModuleSymbolInfo::ModuleSymbolInfo);
}

void ns1__ArrayOfModuleSymbolInfo::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
    (void)soap; /* appease -Wall -Werror */
    soap_serialize_std__vectorTemplateOfPointerTons1__ModuleSymbolInfo(soap, &this->ns1__ArrayOfModuleSymbolInfo::ModuleSymbolInfo);
    this->xsd__anyType::soap_serialize(soap);
#endif
}

int ns1__ArrayOfModuleSymbolInfo::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
    return soap_out_ns1__ArrayOfModuleSymbolInfo(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__ArrayOfModuleSymbolInfo(struct soap *soap, const char *tag, int id, const ns1__ArrayOfModuleSymbolInfo *a, const char *type)
{
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__ArrayOfModuleSymbolInfo), "ns1:ArrayOfModuleSymbolInfo"))
        return soap->error;
    /* transient soap skipped */
    if (soap_out_std__vectorTemplateOfPointerTons1__ModuleSymbolInfo(soap, "ns1:ModuleSymbolInfo", -1, &(a->ns1__ArrayOfModuleSymbolInfo::ModuleSymbolInfo), ""))
        return soap->error;
    return soap_element_end_out(soap, tag);
}

void *ns1__ArrayOfModuleSymbolInfo::soap_in(struct soap *soap, const char *tag, const char *type)
{   return soap_in_ns1__ArrayOfModuleSymbolInfo(soap, tag, this, type);
}

SOAP_FMAC3 ns1__ArrayOfModuleSymbolInfo * SOAP_FMAC4 soap_in_ns1__ArrayOfModuleSymbolInfo(struct soap *soap, const char *tag, ns1__ArrayOfModuleSymbolInfo *a, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    if (soap_element_begin_in(soap, tag, 0, NULL))
        return NULL;
    a = (ns1__ArrayOfModuleSymbolInfo *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__ArrayOfModuleSymbolInfo, sizeof(ns1__ArrayOfModuleSymbolInfo), soap->type, soap->arrayType);
    if (!a)
        return NULL;
    if (soap->alloced)
    {   a->soap_default(soap);
        if (soap->clist->type != SOAP_TYPE_ns1__ArrayOfModuleSymbolInfo)
        {   soap_revert(soap);
            *soap->id = '\0';
            return (ns1__ArrayOfModuleSymbolInfo *)a->soap_in(soap, tag, type);
        }
    }
    size_t soap_flag___item2 = 1;
    if (soap->body && !*soap->href)
    {
        for (;;)
        {   soap->error = SOAP_TAG_MISMATCH;
            /* transient soap skipped */
            if (soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_std__vectorTemplateOfPointerTons1__ModuleSymbolInfo(soap, "ns1:ModuleSymbolInfo", &(a->ns1__ArrayOfModuleSymbolInfo::ModuleSymbolInfo), "ns1:ModuleSymbolInfo"))
                    continue;
            if (soap_flag___item2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
                if (soap_inliteral(soap, "-item", &(a->xsd__anyType::__item)))
                {   soap_flag___item2--;
                    continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
                soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
                break;
            if (soap->error)
                return NULL;
        }
        if (soap_element_end_in(soap, tag))
            return NULL;
    }
    else
    {   a = (ns1__ArrayOfModuleSymbolInfo *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__ArrayOfModuleSymbolInfo, 0, sizeof(ns1__ArrayOfModuleSymbolInfo), 0, soap_copy_ns1__ArrayOfModuleSymbolInfo);
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    return a;
}

int ns1__ArrayOfModuleSymbolInfo::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
    register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns1__ArrayOfModuleSymbolInfo);
    if (this->soap_out(soap, tag?tag:"ns1:ArrayOfModuleSymbolInfo", id, type))
        return soap->error;
    return soap_putindependent(soap);
}

void *ns1__ArrayOfModuleSymbolInfo::soap_get(struct soap *soap, const char *tag, const char *type)
{
    return soap_get_ns1__ArrayOfModuleSymbolInfo(soap, this, tag, type);
}

SOAP_FMAC3 ns1__ArrayOfModuleSymbolInfo * SOAP_FMAC4 soap_get_ns1__ArrayOfModuleSymbolInfo(struct soap *soap, ns1__ArrayOfModuleSymbolInfo *p, const char *tag, const char *type)
{
    if ((p = soap_in_ns1__ArrayOfModuleSymbolInfo(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 ns1__ArrayOfModuleSymbolInfo * SOAP_FMAC2 soap_instantiate_ns1__ArrayOfModuleSymbolInfo(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns1__ArrayOfModuleSymbolInfo(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns1__ArrayOfModuleSymbolInfo, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(ns1__ArrayOfModuleSymbolInfo);
        if (size)
            *size = sizeof(ns1__ArrayOfModuleSymbolInfo);
        ((ns1__ArrayOfModuleSymbolInfo*)cp->ptr)->soap = soap;
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(ns1__ArrayOfModuleSymbolInfo, n);
        if (size)
            *size = n * sizeof(ns1__ArrayOfModuleSymbolInfo);
        if (cp->ptr)
            for (int i = 0; i < n; i++)
                ((ns1__ArrayOfModuleSymbolInfo*)cp->ptr)[i].soap = soap;
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (ns1__ArrayOfModuleSymbolInfo*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns1__ArrayOfModuleSymbolInfo(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns1__ArrayOfModuleSymbolInfo %p -> %p\n", q, p));
    *(ns1__ArrayOfModuleSymbolInfo*)p = *(ns1__ArrayOfModuleSymbolInfo*)q;
}

void ns1__DumpAdditionalInfo::soap_default(struct soap *soap)
{
    this->soap = soap;
    this->xsd__anyType::soap_default(soap);
    soap_default_int(soap, &this->ns1__DumpAdditionalInfo::PCID);
    soap_default_time(soap, &this->ns1__DumpAdditionalInfo::crashDate);
    this->ns1__DumpAdditionalInfo::description = NULL;
    this->ns1__DumpAdditionalInfo::group = NULL;
    soap_default_int(soap, &this->ns1__DumpAdditionalInfo::submitterID);
}

void ns1__DumpAdditionalInfo::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
    (void)soap; /* appease -Wall -Werror */
    soap_embedded(soap, &this->ns1__DumpAdditionalInfo::PCID, SOAP_TYPE_int);
    soap_serialize_PointerTostd__wstring(soap, &this->ns1__DumpAdditionalInfo::description);
    soap_serialize_PointerTostd__wstring(soap, &this->ns1__DumpAdditionalInfo::group);
    soap_embedded(soap, &this->ns1__DumpAdditionalInfo::submitterID, SOAP_TYPE_int);
    this->xsd__anyType::soap_serialize(soap);
#endif
}

int ns1__DumpAdditionalInfo::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
    return soap_out_ns1__DumpAdditionalInfo(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__DumpAdditionalInfo(struct soap *soap, const char *tag, int id, const ns1__DumpAdditionalInfo *a, const char *type)
{
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__DumpAdditionalInfo), "ns1:DumpAdditionalInfo"))
        return soap->error;
    /* transient soap skipped */
    if (soap_out_int(soap, "ns1:PCID", -1, &(a->ns1__DumpAdditionalInfo::PCID), ""))
        return soap->error;
    if (soap_out_time(soap, "ns1:crashDate", -1, &(a->ns1__DumpAdditionalInfo::crashDate), ""))
        return soap->error;
    if (soap_out_PointerTostd__wstring(soap, "ns1:description", -1, &(a->ns1__DumpAdditionalInfo::description), ""))
        return soap->error;
    if (soap_out_PointerTostd__wstring(soap, "ns1:group", -1, &(a->ns1__DumpAdditionalInfo::group), ""))
        return soap->error;
    if (soap_out_int(soap, "ns1:submitterID", -1, &(a->ns1__DumpAdditionalInfo::submitterID), ""))
        return soap->error;
    return soap_element_end_out(soap, tag);
}

void *ns1__DumpAdditionalInfo::soap_in(struct soap *soap, const char *tag, const char *type)
{   return soap_in_ns1__DumpAdditionalInfo(soap, tag, this, type);
}

SOAP_FMAC3 ns1__DumpAdditionalInfo * SOAP_FMAC4 soap_in_ns1__DumpAdditionalInfo(struct soap *soap, const char *tag, ns1__DumpAdditionalInfo *a, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    if (soap_element_begin_in(soap, tag, 0, NULL))
        return NULL;
    a = (ns1__DumpAdditionalInfo *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__DumpAdditionalInfo, sizeof(ns1__DumpAdditionalInfo), soap->type, soap->arrayType);
    if (!a)
        return NULL;
    if (soap->alloced)
    {   a->soap_default(soap);
        if (soap->clist->type != SOAP_TYPE_ns1__DumpAdditionalInfo)
        {   soap_revert(soap);
            *soap->id = '\0';
            return (ns1__DumpAdditionalInfo *)a->soap_in(soap, tag, type);
        }
    }
    size_t soap_flag___item2 = 1;
    size_t soap_flag_PCID1 = 1;
    size_t soap_flag_crashDate1 = 1;
    size_t soap_flag_description1 = 1;
    size_t soap_flag_group1 = 1;
    size_t soap_flag_submitterID1 = 1;
    if (soap->body && !*soap->href)
    {
        for (;;)
        {   soap->error = SOAP_TAG_MISMATCH;
            /* transient soap skipped */
            if (soap_flag_PCID1 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_int(soap, "ns1:PCID", &(a->ns1__DumpAdditionalInfo::PCID), "xsd:int"))
                {   soap_flag_PCID1--;
                    continue;
                }
            if (soap_flag_crashDate1 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_time(soap, "ns1:crashDate", &(a->ns1__DumpAdditionalInfo::crashDate), "xsd:dateTime"))
                {   soap_flag_crashDate1--;
                    continue;
                }
            if (soap_flag_description1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
                if (soap_in_PointerTostd__wstring(soap, "ns1:description", &(a->ns1__DumpAdditionalInfo::description), "xsd:string"))
                {   soap_flag_description1--;
                    continue;
                }
            if (soap_flag_group1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
                if (soap_in_PointerTostd__wstring(soap, "ns1:group", &(a->ns1__DumpAdditionalInfo::group), "xsd:string"))
                {   soap_flag_group1--;
                    continue;
                }
            if (soap_flag_submitterID1 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_int(soap, "ns1:submitterID", &(a->ns1__DumpAdditionalInfo::submitterID), "xsd:int"))
                {   soap_flag_submitterID1--;
                    continue;
                }
            if (soap_flag___item2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
                if (soap_inliteral(soap, "-item", &(a->xsd__anyType::__item)))
                {   soap_flag___item2--;
                    continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
                soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
                break;
            if (soap->error)
                return NULL;
        }
        if (soap_element_end_in(soap, tag))
            return NULL;
    }
    else
    {   a = (ns1__DumpAdditionalInfo *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__DumpAdditionalInfo, 0, sizeof(ns1__DumpAdditionalInfo), 0, soap_copy_ns1__DumpAdditionalInfo);
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_PCID1 > 0 || soap_flag_crashDate1 > 0 || soap_flag_submitterID1 > 0))
    {   soap->error = SOAP_OCCURS;
        return NULL;
    }
    return a;
}

int ns1__DumpAdditionalInfo::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
    register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns1__DumpAdditionalInfo);
    if (this->soap_out(soap, tag?tag:"ns1:DumpAdditionalInfo", id, type))
        return soap->error;
    return soap_putindependent(soap);
}

void *ns1__DumpAdditionalInfo::soap_get(struct soap *soap, const char *tag, const char *type)
{
    return soap_get_ns1__DumpAdditionalInfo(soap, this, tag, type);
}

SOAP_FMAC3 ns1__DumpAdditionalInfo * SOAP_FMAC4 soap_get_ns1__DumpAdditionalInfo(struct soap *soap, ns1__DumpAdditionalInfo *p, const char *tag, const char *type)
{
    if ((p = soap_in_ns1__DumpAdditionalInfo(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 ns1__DumpAdditionalInfo * SOAP_FMAC2 soap_instantiate_ns1__DumpAdditionalInfo(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns1__DumpAdditionalInfo(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns1__DumpAdditionalInfo, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(ns1__DumpAdditionalInfo);
        if (size)
            *size = sizeof(ns1__DumpAdditionalInfo);
        ((ns1__DumpAdditionalInfo*)cp->ptr)->soap = soap;
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(ns1__DumpAdditionalInfo, n);
        if (size)
            *size = n * sizeof(ns1__DumpAdditionalInfo);
        if (cp->ptr)
            for (int i = 0; i < n; i++)
                ((ns1__DumpAdditionalInfo*)cp->ptr)[i].soap = soap;
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (ns1__DumpAdditionalInfo*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns1__DumpAdditionalInfo(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns1__DumpAdditionalInfo %p -> %p\n", q, p));
    *(ns1__DumpAdditionalInfo*)p = *(ns1__DumpAdditionalInfo*)q;
}

void ns1__AppAdditionalInfo::soap_default(struct soap *soap)
{
    this->soap = soap;
    this->xsd__anyType::soap_default(soap);
    this->ns1__AppAdditionalInfo::appName = NULL;
    this->ns1__AppAdditionalInfo::companyName = NULL;
}

void ns1__AppAdditionalInfo::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
    (void)soap; /* appease -Wall -Werror */
    soap_serialize_PointerTostd__wstring(soap, &this->ns1__AppAdditionalInfo::appName);
    soap_serialize_PointerTostd__wstring(soap, &this->ns1__AppAdditionalInfo::companyName);
    this->xsd__anyType::soap_serialize(soap);
#endif
}

int ns1__AppAdditionalInfo::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
    return soap_out_ns1__AppAdditionalInfo(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__AppAdditionalInfo(struct soap *soap, const char *tag, int id, const ns1__AppAdditionalInfo *a, const char *type)
{
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__AppAdditionalInfo), "ns1:AppAdditionalInfo"))
        return soap->error;
    /* transient soap skipped */
    if (soap_out_PointerTostd__wstring(soap, "ns1:appName", -1, &(a->ns1__AppAdditionalInfo::appName), ""))
        return soap->error;
    if (soap_out_PointerTostd__wstring(soap, "ns1:companyName", -1, &(a->ns1__AppAdditionalInfo::companyName), ""))
        return soap->error;
    return soap_element_end_out(soap, tag);
}

void *ns1__AppAdditionalInfo::soap_in(struct soap *soap, const char *tag, const char *type)
{   return soap_in_ns1__AppAdditionalInfo(soap, tag, this, type);
}

SOAP_FMAC3 ns1__AppAdditionalInfo * SOAP_FMAC4 soap_in_ns1__AppAdditionalInfo(struct soap *soap, const char *tag, ns1__AppAdditionalInfo *a, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    if (soap_element_begin_in(soap, tag, 0, NULL))
        return NULL;
    a = (ns1__AppAdditionalInfo *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__AppAdditionalInfo, sizeof(ns1__AppAdditionalInfo), soap->type, soap->arrayType);
    if (!a)
        return NULL;
    if (soap->alloced)
    {   a->soap_default(soap);
        if (soap->clist->type != SOAP_TYPE_ns1__AppAdditionalInfo)
        {   soap_revert(soap);
            *soap->id = '\0';
            return (ns1__AppAdditionalInfo *)a->soap_in(soap, tag, type);
        }
    }
    size_t soap_flag___item2 = 1;
    size_t soap_flag_appName1 = 1;
    size_t soap_flag_companyName1 = 1;
    if (soap->body && !*soap->href)
    {
        for (;;)
        {   soap->error = SOAP_TAG_MISMATCH;
            /* transient soap skipped */
            if (soap_flag_appName1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
                if (soap_in_PointerTostd__wstring(soap, "ns1:appName", &(a->ns1__AppAdditionalInfo::appName), "xsd:string"))
                {   soap_flag_appName1--;
                    continue;
                }
            if (soap_flag_companyName1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
                if (soap_in_PointerTostd__wstring(soap, "ns1:companyName", &(a->ns1__AppAdditionalInfo::companyName), "xsd:string"))
                {   soap_flag_companyName1--;
                    continue;
                }
            if (soap_flag___item2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
                if (soap_inliteral(soap, "-item", &(a->xsd__anyType::__item)))
                {   soap_flag___item2--;
                    continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
                soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
                break;
            if (soap->error)
                return NULL;
        }
        if (soap_element_end_in(soap, tag))
            return NULL;
    }
    else
    {   a = (ns1__AppAdditionalInfo *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__AppAdditionalInfo, 0, sizeof(ns1__AppAdditionalInfo), 0, soap_copy_ns1__AppAdditionalInfo);
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    return a;
}

int ns1__AppAdditionalInfo::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
    register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns1__AppAdditionalInfo);
    if (this->soap_out(soap, tag?tag:"ns1:AppAdditionalInfo", id, type))
        return soap->error;
    return soap_putindependent(soap);
}

void *ns1__AppAdditionalInfo::soap_get(struct soap *soap, const char *tag, const char *type)
{
    return soap_get_ns1__AppAdditionalInfo(soap, this, tag, type);
}

SOAP_FMAC3 ns1__AppAdditionalInfo * SOAP_FMAC4 soap_get_ns1__AppAdditionalInfo(struct soap *soap, ns1__AppAdditionalInfo *p, const char *tag, const char *type)
{
    if ((p = soap_in_ns1__AppAdditionalInfo(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 ns1__AppAdditionalInfo * SOAP_FMAC2 soap_instantiate_ns1__AppAdditionalInfo(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns1__AppAdditionalInfo(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns1__AppAdditionalInfo, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(ns1__AppAdditionalInfo);
        if (size)
            *size = sizeof(ns1__AppAdditionalInfo);
        ((ns1__AppAdditionalInfo*)cp->ptr)->soap = soap;
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(ns1__AppAdditionalInfo, n);
        if (size)
            *size = n * sizeof(ns1__AppAdditionalInfo);
        if (cp->ptr)
            for (int i = 0; i < n; i++)
                ((ns1__AppAdditionalInfo*)cp->ptr)[i].soap = soap;
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (ns1__AppAdditionalInfo*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns1__AppAdditionalInfo(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns1__AppAdditionalInfo %p -> %p\n", q, p));
    *(ns1__AppAdditionalInfo*)p = *(ns1__AppAdditionalInfo*)q;
}

void ns1__Application::soap_default(struct soap *soap)
{
    this->soap = soap;
    this->xsd__anyType::soap_default(soap);
    soap_default_ns3__guid(soap, &this->ns1__Application::applicationGUID);
    soap_default_unsignedShort(soap, &this->ns1__Application::hotfix);
    this->ns1__Application::mainModule = NULL;
    soap_default_unsignedShort(soap, &this->ns1__Application::v1);
    soap_default_unsignedShort(soap, &this->ns1__Application::v2);
    soap_default_unsignedShort(soap, &this->ns1__Application::v3);
    soap_default_unsignedShort(soap, &this->ns1__Application::v4);
}

void ns1__Application::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
    (void)soap; /* appease -Wall -Werror */
    soap_serialize_ns3__guid(soap, &this->ns1__Application::applicationGUID);
    soap_serialize_PointerTostd__wstring(soap, &this->ns1__Application::mainModule);
    this->xsd__anyType::soap_serialize(soap);
#endif
}

int ns1__Application::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
    return soap_out_ns1__Application(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__Application(struct soap *soap, const char *tag, int id, const ns1__Application *a, const char *type)
{
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__Application), "ns1:Application"))
        return soap->error;
    /* transient soap skipped */
    if (soap_out_ns3__guid(soap, "ns1:applicationGUID", -1, &(a->ns1__Application::applicationGUID), ""))
        return soap->error;
    if (soap_out_unsignedShort(soap, "ns1:hotfix", -1, &(a->ns1__Application::hotfix), ""))
        return soap->error;
    if (soap_out_PointerTostd__wstring(soap, "ns1:mainModule", -1, &(a->ns1__Application::mainModule), ""))
        return soap->error;
    if (soap_out_unsignedShort(soap, "ns1:v1", -1, &(a->ns1__Application::v1), ""))
        return soap->error;
    if (soap_out_unsignedShort(soap, "ns1:v2", -1, &(a->ns1__Application::v2), ""))
        return soap->error;
    if (soap_out_unsignedShort(soap, "ns1:v3", -1, &(a->ns1__Application::v3), ""))
        return soap->error;
    if (soap_out_unsignedShort(soap, "ns1:v4", -1, &(a->ns1__Application::v4), ""))
        return soap->error;
    return soap_element_end_out(soap, tag);
}

void *ns1__Application::soap_in(struct soap *soap, const char *tag, const char *type)
{   return soap_in_ns1__Application(soap, tag, this, type);
}

SOAP_FMAC3 ns1__Application * SOAP_FMAC4 soap_in_ns1__Application(struct soap *soap, const char *tag, ns1__Application *a, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    if (soap_element_begin_in(soap, tag, 0, NULL))
        return NULL;
    a = (ns1__Application *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__Application, sizeof(ns1__Application), soap->type, soap->arrayType);
    if (!a)
        return NULL;
    if (soap->alloced)
    {   a->soap_default(soap);
        if (soap->clist->type != SOAP_TYPE_ns1__Application)
        {   soap_revert(soap);
            *soap->id = '\0';
            return (ns1__Application *)a->soap_in(soap, tag, type);
        }
    }
    size_t soap_flag___item2 = 1;
    size_t soap_flag_applicationGUID1 = 1;
    size_t soap_flag_hotfix1 = 1;
    size_t soap_flag_mainModule1 = 1;
    size_t soap_flag_v11 = 1;
    size_t soap_flag_v21 = 1;
    size_t soap_flag_v31 = 1;
    size_t soap_flag_v41 = 1;
    if (soap->body && !*soap->href)
    {
        for (;;)
        {   soap->error = SOAP_TAG_MISMATCH;
            /* transient soap skipped */
            if (soap_flag_applicationGUID1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
                if (soap_in_ns3__guid(soap, "ns1:applicationGUID", &(a->ns1__Application::applicationGUID), "ns3:guid"))
                {   soap_flag_applicationGUID1--;
                    continue;
                }
            if (soap_flag_hotfix1 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_unsignedShort(soap, "ns1:hotfix", &(a->ns1__Application::hotfix), "xsd:unsignedShort"))
                {   soap_flag_hotfix1--;
                    continue;
                }
            if (soap_flag_mainModule1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
                if (soap_in_PointerTostd__wstring(soap, "ns1:mainModule", &(a->ns1__Application::mainModule), "xsd:string"))
                {   soap_flag_mainModule1--;
                    continue;
                }
            if (soap_flag_v11 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_unsignedShort(soap, "ns1:v1", &(a->ns1__Application::v1), "xsd:unsignedShort"))
                {   soap_flag_v11--;
                    continue;
                }
            if (soap_flag_v21 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_unsignedShort(soap, "ns1:v2", &(a->ns1__Application::v2), "xsd:unsignedShort"))
                {   soap_flag_v21--;
                    continue;
                }
            if (soap_flag_v31 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_unsignedShort(soap, "ns1:v3", &(a->ns1__Application::v3), "xsd:unsignedShort"))
                {   soap_flag_v31--;
                    continue;
                }
            if (soap_flag_v41 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_unsignedShort(soap, "ns1:v4", &(a->ns1__Application::v4), "xsd:unsignedShort"))
                {   soap_flag_v41--;
                    continue;
                }
            if (soap_flag___item2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
                if (soap_inliteral(soap, "-item", &(a->xsd__anyType::__item)))
                {   soap_flag___item2--;
                    continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
                soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
                break;
            if (soap->error)
                return NULL;
        }
        if (soap_element_end_in(soap, tag))
            return NULL;
    }
    else
    {   a = (ns1__Application *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__Application, 0, sizeof(ns1__Application), 0, soap_copy_ns1__Application);
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_applicationGUID1 > 0 || soap_flag_hotfix1 > 0 || soap_flag_v11 > 0 || soap_flag_v21 > 0 || soap_flag_v31 > 0 || soap_flag_v41 > 0))
    {   soap->error = SOAP_OCCURS;
        return NULL;
    }
    return a;
}

int ns1__Application::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
    register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns1__Application);
    if (this->soap_out(soap, tag?tag:"ns1:Application", id, type))
        return soap->error;
    return soap_putindependent(soap);
}

void *ns1__Application::soap_get(struct soap *soap, const char *tag, const char *type)
{
    return soap_get_ns1__Application(soap, this, tag, type);
}

SOAP_FMAC3 ns1__Application * SOAP_FMAC4 soap_get_ns1__Application(struct soap *soap, ns1__Application *p, const char *tag, const char *type)
{
    if ((p = soap_in_ns1__Application(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 ns1__Application * SOAP_FMAC2 soap_instantiate_ns1__Application(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns1__Application(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns1__Application, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(ns1__Application);
        if (size)
            *size = sizeof(ns1__Application);
        ((ns1__Application*)cp->ptr)->soap = soap;
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(ns1__Application, n);
        if (size)
            *size = n * sizeof(ns1__Application);
        if (cp->ptr)
            for (int i = 0; i < n; i++)
                ((ns1__Application*)cp->ptr)[i].soap = soap;
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (ns1__Application*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns1__Application(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns1__Application %p -> %p\n", q, p));
    *(ns1__Application*)p = *(ns1__Application*)q;
}

void ns1__ClientLib::soap_default(struct soap *soap)
{
    this->soap = soap;
    this->xsd__anyType::soap_default(soap);
    soap_default_ns4__ClientLib_Architecture(soap, &this->ns1__ClientLib::arch);
    soap_default_ns4__ClientLib_ClientType(soap, &this->ns1__ClientLib::type);
    soap_default_unsignedShort(soap, &this->ns1__ClientLib::v1);
    soap_default_unsignedShort(soap, &this->ns1__ClientLib::v2);
    soap_default_unsignedShort(soap, &this->ns1__ClientLib::v3);
    soap_default_unsignedShort(soap, &this->ns1__ClientLib::v4);
}

void ns1__ClientLib::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
    (void)soap; /* appease -Wall -Werror */
    this->xsd__anyType::soap_serialize(soap);
#endif
}

int ns1__ClientLib::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
    return soap_out_ns1__ClientLib(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__ClientLib(struct soap *soap, const char *tag, int id, const ns1__ClientLib *a, const char *type)
{
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__ClientLib), "ns1:ClientLib"))
        return soap->error;
    /* transient soap skipped */
    if (soap_out_ns4__ClientLib_Architecture(soap, "ns1:arch", -1, &(a->ns1__ClientLib::arch), ""))
        return soap->error;
    if (soap_out_ns4__ClientLib_ClientType(soap, "ns1:type", -1, &(a->ns1__ClientLib::type), ""))
        return soap->error;
    if (soap_out_unsignedShort(soap, "ns1:v1", -1, &(a->ns1__ClientLib::v1), ""))
        return soap->error;
    if (soap_out_unsignedShort(soap, "ns1:v2", -1, &(a->ns1__ClientLib::v2), ""))
        return soap->error;
    if (soap_out_unsignedShort(soap, "ns1:v3", -1, &(a->ns1__ClientLib::v3), ""))
        return soap->error;
    if (soap_out_unsignedShort(soap, "ns1:v4", -1, &(a->ns1__ClientLib::v4), ""))
        return soap->error;
    return soap_element_end_out(soap, tag);
}

void *ns1__ClientLib::soap_in(struct soap *soap, const char *tag, const char *type)
{   return soap_in_ns1__ClientLib(soap, tag, this, type);
}

SOAP_FMAC3 ns1__ClientLib * SOAP_FMAC4 soap_in_ns1__ClientLib(struct soap *soap, const char *tag, ns1__ClientLib *a, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    if (soap_element_begin_in(soap, tag, 0, NULL))
        return NULL;
    a = (ns1__ClientLib *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__ClientLib, sizeof(ns1__ClientLib), soap->type, soap->arrayType);
    if (!a)
        return NULL;
    if (soap->alloced)
    {   a->soap_default(soap);
        if (soap->clist->type != SOAP_TYPE_ns1__ClientLib)
        {   soap_revert(soap);
            *soap->id = '\0';
            return (ns1__ClientLib *)a->soap_in(soap, tag, type);
        }
    }
    size_t soap_flag___item2 = 1;
    size_t soap_flag_arch1 = 1;
    size_t soap_flag_type1 = 1;
    size_t soap_flag_v11 = 1;
    size_t soap_flag_v21 = 1;
    size_t soap_flag_v31 = 1;
    size_t soap_flag_v41 = 1;
    if (soap->body && !*soap->href)
    {
        for (;;)
        {   soap->error = SOAP_TAG_MISMATCH;
            /* transient soap skipped */
            if (soap_flag_arch1 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_ns4__ClientLib_Architecture(soap, "ns1:arch", &(a->ns1__ClientLib::arch), "ns4:ClientLib.Architecture"))
                {   soap_flag_arch1--;
                    continue;
                }
            if (soap_flag_type1 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_ns4__ClientLib_ClientType(soap, "ns1:type", &(a->ns1__ClientLib::type), "ns4:ClientLib.ClientType"))
                {   soap_flag_type1--;
                    continue;
                }
            if (soap_flag_v11 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_unsignedShort(soap, "ns1:v1", &(a->ns1__ClientLib::v1), "xsd:unsignedShort"))
                {   soap_flag_v11--;
                    continue;
                }
            if (soap_flag_v21 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_unsignedShort(soap, "ns1:v2", &(a->ns1__ClientLib::v2), "xsd:unsignedShort"))
                {   soap_flag_v21--;
                    continue;
                }
            if (soap_flag_v31 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_unsignedShort(soap, "ns1:v3", &(a->ns1__ClientLib::v3), "xsd:unsignedShort"))
                {   soap_flag_v31--;
                    continue;
                }
            if (soap_flag_v41 && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_unsignedShort(soap, "ns1:v4", &(a->ns1__ClientLib::v4), "xsd:unsignedShort"))
                {   soap_flag_v41--;
                    continue;
                }
            if (soap_flag___item2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
                if (soap_inliteral(soap, "-item", &(a->xsd__anyType::__item)))
                {   soap_flag___item2--;
                    continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
                soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
                break;
            if (soap->error)
                return NULL;
        }
        if (soap_element_end_in(soap, tag))
            return NULL;
    }
    else
    {   a = (ns1__ClientLib *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__ClientLib, 0, sizeof(ns1__ClientLib), 0, soap_copy_ns1__ClientLib);
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_arch1 > 0 || soap_flag_type1 > 0 || soap_flag_v11 > 0 || soap_flag_v21 > 0 || soap_flag_v31 > 0 || soap_flag_v41 > 0))
    {   soap->error = SOAP_OCCURS;
        return NULL;
    }
    return a;
}

int ns1__ClientLib::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
    register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns1__ClientLib);
    if (this->soap_out(soap, tag?tag:"ns1:ClientLib", id, type))
        return soap->error;
    return soap_putindependent(soap);
}

void *ns1__ClientLib::soap_get(struct soap *soap, const char *tag, const char *type)
{
    return soap_get_ns1__ClientLib(soap, this, tag, type);
}

SOAP_FMAC3 ns1__ClientLib * SOAP_FMAC4 soap_get_ns1__ClientLib(struct soap *soap, ns1__ClientLib *p, const char *tag, const char *type)
{
    if ((p = soap_in_ns1__ClientLib(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 ns1__ClientLib * SOAP_FMAC2 soap_instantiate_ns1__ClientLib(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns1__ClientLib(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns1__ClientLib, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(ns1__ClientLib);
        if (size)
            *size = sizeof(ns1__ClientLib);
        ((ns1__ClientLib*)cp->ptr)->soap = soap;
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(ns1__ClientLib, n);
        if (size)
            *size = n * sizeof(ns1__ClientLib);
        if (cp->ptr)
            for (int i = 0; i < n; i++)
                ((ns1__ClientLib*)cp->ptr)[i].soap = soap;
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (ns1__ClientLib*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns1__ClientLib(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns1__ClientLib %p -> %p\n", q, p));
    *(ns1__ClientLib*)p = *(ns1__ClientLib*)q;
}

void xsd__unsignedShort::soap_default(struct soap *soap)
{
    this->soap = soap;
    this->xsd__anyType::soap_default(soap);
    soap_default_unsignedShort(soap, &this->xsd__unsignedShort::__item);
}

void xsd__unsignedShort::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
    (void)soap; /* appease -Wall -Werror */
    this->xsd__anyType::soap_serialize(soap);
#endif
}

int xsd__unsignedShort::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
    return soap_out_xsd__unsignedShort(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__unsignedShort(struct soap *soap, const char *tag, int id, const xsd__unsignedShort *a, const char *type)
{
    return soap_out_unsignedShort(soap, tag, id, &(a->xsd__unsignedShort::__item), "xsd:unsignedShort");
}

void *xsd__unsignedShort::soap_in(struct soap *soap, const char *tag, const char *type)
{   return soap_in_xsd__unsignedShort(soap, tag, this, type);
}

SOAP_FMAC3 xsd__unsignedShort * SOAP_FMAC4 soap_in_xsd__unsignedShort(struct soap *soap, const char *tag, xsd__unsignedShort *a, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    if (soap_element_begin_in(soap, tag, 1, NULL))
        return NULL;
    if (!(a = (xsd__unsignedShort *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_xsd__unsignedShort, sizeof(xsd__unsignedShort), soap->type, soap->arrayType)))
    {   soap->error = SOAP_TAG_MISMATCH;
        return NULL;
    }
    soap_revert(soap);
    *soap->id = '\0';
    if (soap->alloced)
    {   a->soap_default(soap);
        if (soap->clist->type != SOAP_TYPE_xsd__unsignedShort)
            return (xsd__unsignedShort *)a->soap_in(soap, tag, type);
    }
    if (!soap_in_unsignedShort(soap, tag, &(a->xsd__unsignedShort::__item), "xsd:unsignedShort"))
        return NULL;
    return a;
}

int xsd__unsignedShort::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
    register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_xsd__unsignedShort);
    if (this->soap_out(soap, tag?tag:"xsd:unsignedShort", id, type))
        return soap->error;
    return soap_putindependent(soap);
}

void *xsd__unsignedShort::soap_get(struct soap *soap, const char *tag, const char *type)
{
    return soap_get_xsd__unsignedShort(soap, this, tag, type);
}

SOAP_FMAC3 xsd__unsignedShort * SOAP_FMAC4 soap_get_xsd__unsignedShort(struct soap *soap, xsd__unsignedShort *p, const char *tag, const char *type)
{
    if ((p = soap_in_xsd__unsignedShort(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 xsd__unsignedShort * SOAP_FMAC2 soap_instantiate_xsd__unsignedShort(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xsd__unsignedShort(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xsd__unsignedShort, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(xsd__unsignedShort);
        if (size)
            *size = sizeof(xsd__unsignedShort);
        ((xsd__unsignedShort*)cp->ptr)->soap = soap;
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(xsd__unsignedShort, n);
        if (size)
            *size = n * sizeof(xsd__unsignedShort);
        if (cp->ptr)
            for (int i = 0; i < n; i++)
                ((xsd__unsignedShort*)cp->ptr)[i].soap = soap;
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (xsd__unsignedShort*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xsd__unsignedShort(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying xsd__unsignedShort %p -> %p\n", q, p));
    *(xsd__unsignedShort*)p = *(xsd__unsignedShort*)q;
}

void xsd__unsignedLong::soap_default(struct soap *soap)
{
    this->soap = soap;
    this->xsd__anyType::soap_default(soap);
    soap_default_unsignedLONG64(soap, &this->xsd__unsignedLong::__item);
}

void xsd__unsignedLong::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
    (void)soap; /* appease -Wall -Werror */
    this->xsd__anyType::soap_serialize(soap);
#endif
}

int xsd__unsignedLong::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
    return soap_out_xsd__unsignedLong(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__unsignedLong(struct soap *soap, const char *tag, int id, const xsd__unsignedLong *a, const char *type)
{
    return soap_out_unsignedLONG64(soap, tag, id, &(a->xsd__unsignedLong::__item), "xsd:unsignedLong");
}

void *xsd__unsignedLong::soap_in(struct soap *soap, const char *tag, const char *type)
{   return soap_in_xsd__unsignedLong(soap, tag, this, type);
}

SOAP_FMAC3 xsd__unsignedLong * SOAP_FMAC4 soap_in_xsd__unsignedLong(struct soap *soap, const char *tag, xsd__unsignedLong *a, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    if (soap_element_begin_in(soap, tag, 1, NULL))
        return NULL;
    if (!(a = (xsd__unsignedLong *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_xsd__unsignedLong, sizeof(xsd__unsignedLong), soap->type, soap->arrayType)))
    {   soap->error = SOAP_TAG_MISMATCH;
        return NULL;
    }
    soap_revert(soap);
    *soap->id = '\0';
    if (soap->alloced)
    {   a->soap_default(soap);
        if (soap->clist->type != SOAP_TYPE_xsd__unsignedLong)
            return (xsd__unsignedLong *)a->soap_in(soap, tag, type);
    }
    if (!soap_in_unsignedLONG64(soap, tag, &(a->xsd__unsignedLong::__item), "xsd:unsignedLong"))
        return NULL;
    return a;
}

int xsd__unsignedLong::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
    register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_xsd__unsignedLong);
    if (this->soap_out(soap, tag?tag:"xsd:unsignedLong", id, type))
        return soap->error;
    return soap_putindependent(soap);
}

void *xsd__unsignedLong::soap_get(struct soap *soap, const char *tag, const char *type)
{
    return soap_get_xsd__unsignedLong(soap, this, tag, type);
}

SOAP_FMAC3 xsd__unsignedLong * SOAP_FMAC4 soap_get_xsd__unsignedLong(struct soap *soap, xsd__unsignedLong *p, const char *tag, const char *type)
{
    if ((p = soap_in_xsd__unsignedLong(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 xsd__unsignedLong * SOAP_FMAC2 soap_instantiate_xsd__unsignedLong(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xsd__unsignedLong(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xsd__unsignedLong, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(xsd__unsignedLong);
        if (size)
            *size = sizeof(xsd__unsignedLong);
        ((xsd__unsignedLong*)cp->ptr)->soap = soap;
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(xsd__unsignedLong, n);
        if (size)
            *size = n * sizeof(xsd__unsignedLong);
        if (cp->ptr)
            for (int i = 0; i < n; i++)
                ((xsd__unsignedLong*)cp->ptr)[i].soap = soap;
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (xsd__unsignedLong*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xsd__unsignedLong(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying xsd__unsignedLong %p -> %p\n", q, p));
    *(xsd__unsignedLong*)p = *(xsd__unsignedLong*)q;
}

void xsd__unsignedInt::soap_default(struct soap *soap)
{
    this->soap = soap;
    this->xsd__anyType::soap_default(soap);
    soap_default_unsignedInt(soap, &this->xsd__unsignedInt::__item);
}

void xsd__unsignedInt::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
    (void)soap; /* appease -Wall -Werror */
    this->xsd__anyType::soap_serialize(soap);
#endif
}

int xsd__unsignedInt::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
    return soap_out_xsd__unsignedInt(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__unsignedInt(struct soap *soap, const char *tag, int id, const xsd__unsignedInt *a, const char *type)
{
    return soap_out_unsignedInt(soap, tag, id, &(a->xsd__unsignedInt::__item), "xsd:unsignedInt");
}

void *xsd__unsignedInt::soap_in(struct soap *soap, const char *tag, const char *type)
{   return soap_in_xsd__unsignedInt(soap, tag, this, type);
}

SOAP_FMAC3 xsd__unsignedInt * SOAP_FMAC4 soap_in_xsd__unsignedInt(struct soap *soap, const char *tag, xsd__unsignedInt *a, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    if (soap_element_begin_in(soap, tag, 1, NULL))
        return NULL;
    if (!(a = (xsd__unsignedInt *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_xsd__unsignedInt, sizeof(xsd__unsignedInt), soap->type, soap->arrayType)))
    {   soap->error = SOAP_TAG_MISMATCH;
        return NULL;
    }
    soap_revert(soap);
    *soap->id = '\0';
    if (soap->alloced)
    {   a->soap_default(soap);
        if (soap->clist->type != SOAP_TYPE_xsd__unsignedInt)
            return (xsd__unsignedInt *)a->soap_in(soap, tag, type);
    }
    if (!soap_in_unsignedInt(soap, tag, &(a->xsd__unsignedInt::__item), "xsd:unsignedInt"))
        return NULL;
    return a;
}

int xsd__unsignedInt::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
    register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_xsd__unsignedInt);
    if (this->soap_out(soap, tag?tag:"xsd:unsignedInt", id, type))
        return soap->error;
    return soap_putindependent(soap);
}

void *xsd__unsignedInt::soap_get(struct soap *soap, const char *tag, const char *type)
{
    return soap_get_xsd__unsignedInt(soap, this, tag, type);
}

SOAP_FMAC3 xsd__unsignedInt * SOAP_FMAC4 soap_get_xsd__unsignedInt(struct soap *soap, xsd__unsignedInt *p, const char *tag, const char *type)
{
    if ((p = soap_in_xsd__unsignedInt(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 xsd__unsignedInt * SOAP_FMAC2 soap_instantiate_xsd__unsignedInt(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xsd__unsignedInt(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xsd__unsignedInt, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(xsd__unsignedInt);
        if (size)
            *size = sizeof(xsd__unsignedInt);
        ((xsd__unsignedInt*)cp->ptr)->soap = soap;
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(xsd__unsignedInt, n);
        if (size)
            *size = n * sizeof(xsd__unsignedInt);
        if (cp->ptr)
            for (int i = 0; i < n; i++)
                ((xsd__unsignedInt*)cp->ptr)[i].soap = soap;
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (xsd__unsignedInt*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xsd__unsignedInt(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying xsd__unsignedInt %p -> %p\n", q, p));
    *(xsd__unsignedInt*)p = *(xsd__unsignedInt*)q;
}

void xsd__unsignedByte_::soap_default(struct soap *soap)
{
    this->soap = soap;
    this->xsd__anyType::soap_default(soap);
    soap_default_xsd__unsignedByte(soap, &this->xsd__unsignedByte_::__item);
}

void xsd__unsignedByte_::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
    (void)soap; /* appease -Wall -Werror */
    this->xsd__anyType::soap_serialize(soap);
#endif
}

int xsd__unsignedByte_::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
    return soap_out_xsd__unsignedByte_(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__unsignedByte_(struct soap *soap, const char *tag, int id, const xsd__unsignedByte_ *a, const char *type)
{
    return soap_out_xsd__unsignedByte(soap, tag, id, &(a->xsd__unsignedByte_::__item), "xsd:unsignedByte");
}

void *xsd__unsignedByte_::soap_in(struct soap *soap, const char *tag, const char *type)
{   return soap_in_xsd__unsignedByte_(soap, tag, this, type);
}

SOAP_FMAC3 xsd__unsignedByte_ * SOAP_FMAC4 soap_in_xsd__unsignedByte_(struct soap *soap, const char *tag, xsd__unsignedByte_ *a, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    if (soap_element_begin_in(soap, tag, 1, NULL))
        return NULL;
    if (!(a = (xsd__unsignedByte_ *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_xsd__unsignedByte_, sizeof(xsd__unsignedByte_), soap->type, soap->arrayType)))
    {   soap->error = SOAP_TAG_MISMATCH;
        return NULL;
    }
    soap_revert(soap);
    *soap->id = '\0';
    if (soap->alloced)
    {   a->soap_default(soap);
        if (soap->clist->type != SOAP_TYPE_xsd__unsignedByte_)
            return (xsd__unsignedByte_ *)a->soap_in(soap, tag, type);
    }
    if (!soap_in_xsd__unsignedByte(soap, tag, &(a->xsd__unsignedByte_::__item), "xsd:unsignedByte"))
        return NULL;
    return a;
}

int xsd__unsignedByte_::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
    register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_xsd__unsignedByte_);
    if (this->soap_out(soap, tag?tag:"xsd:unsignedByte", id, type))
        return soap->error;
    return soap_putindependent(soap);
}

void *xsd__unsignedByte_::soap_get(struct soap *soap, const char *tag, const char *type)
{
    return soap_get_xsd__unsignedByte_(soap, this, tag, type);
}

SOAP_FMAC3 xsd__unsignedByte_ * SOAP_FMAC4 soap_get_xsd__unsignedByte_(struct soap *soap, xsd__unsignedByte_ *p, const char *tag, const char *type)
{
    if ((p = soap_in_xsd__unsignedByte_(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 xsd__unsignedByte_ * SOAP_FMAC2 soap_instantiate_xsd__unsignedByte_(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xsd__unsignedByte_(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xsd__unsignedByte_, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(xsd__unsignedByte_);
        if (size)
            *size = sizeof(xsd__unsignedByte_);
        ((xsd__unsignedByte_*)cp->ptr)->soap = soap;
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(xsd__unsignedByte_, n);
        if (size)
            *size = n * sizeof(xsd__unsignedByte_);
        if (cp->ptr)
            for (int i = 0; i < n; i++)
                ((xsd__unsignedByte_*)cp->ptr)[i].soap = soap;
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (xsd__unsignedByte_*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xsd__unsignedByte_(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying xsd__unsignedByte_ %p -> %p\n", q, p));
    *(xsd__unsignedByte_*)p = *(xsd__unsignedByte_*)q;
}

void xsd__string::soap_default(struct soap *soap)
{
    this->soap = soap;
    this->xsd__anyType::soap_default(soap);
    soap_default_std__wstring(soap, &this->xsd__string::__item);
}

void xsd__string::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
    (void)soap; /* appease -Wall -Werror */
    soap_embedded(soap, &this->xsd__string::__item, SOAP_TYPE_std__wstring);
    soap_serialize_std__wstring(soap, &this->xsd__string::__item);
    this->xsd__anyType::soap_serialize(soap);
#endif
}

int xsd__string::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
    return soap_out_xsd__string(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__string(struct soap *soap, const char *tag, int id, const xsd__string *a, const char *type)
{
    return soap_out_std__wstring(soap, tag, id, &(a->xsd__string::__item), "xsd:string");
}

void *xsd__string::soap_in(struct soap *soap, const char *tag, const char *type)
{   return soap_in_xsd__string(soap, tag, this, type);
}

SOAP_FMAC3 xsd__string * SOAP_FMAC4 soap_in_xsd__string(struct soap *soap, const char *tag, xsd__string *a, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    if (soap_element_begin_in(soap, tag, 1, NULL))
        return NULL;
    if (!(a = (xsd__string *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_xsd__string, sizeof(xsd__string), soap->type, soap->arrayType)))
    {   soap->error = SOAP_TAG_MISMATCH;
        return NULL;
    }
    soap_revert(soap);
    *soap->id = '\0';
    if (soap->alloced)
    {   a->soap_default(soap);
        if (soap->clist->type != SOAP_TYPE_xsd__string)
            return (xsd__string *)a->soap_in(soap, tag, type);
    }
    if (!soap_in_std__wstring(soap, tag, &(a->xsd__string::__item), "xsd:string"))
        return NULL;
    return a;
}

int xsd__string::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
    register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_xsd__string);
    if (this->soap_out(soap, tag?tag:"xsd:string", id, type))
        return soap->error;
    return soap_putindependent(soap);
}

void *xsd__string::soap_get(struct soap *soap, const char *tag, const char *type)
{
    return soap_get_xsd__string(soap, this, tag, type);
}

SOAP_FMAC3 xsd__string * SOAP_FMAC4 soap_get_xsd__string(struct soap *soap, xsd__string *p, const char *tag, const char *type)
{
    if ((p = soap_in_xsd__string(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 xsd__string * SOAP_FMAC2 soap_instantiate_xsd__string(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xsd__string(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xsd__string, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(xsd__string);
        if (size)
            *size = sizeof(xsd__string);
        ((xsd__string*)cp->ptr)->soap = soap;
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(xsd__string, n);
        if (size)
            *size = n * sizeof(xsd__string);
        if (cp->ptr)
            for (int i = 0; i < n; i++)
                ((xsd__string*)cp->ptr)[i].soap = soap;
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (xsd__string*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xsd__string(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying xsd__string %p -> %p\n", q, p));
    *(xsd__string*)p = *(xsd__string*)q;
}

void xsd__short::soap_default(struct soap *soap)
{
    this->soap = soap;
    this->xsd__anyType::soap_default(soap);
    soap_default_short(soap, &this->xsd__short::__item);
}

void xsd__short::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
    (void)soap; /* appease -Wall -Werror */
    this->xsd__anyType::soap_serialize(soap);
#endif
}

int xsd__short::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
    return soap_out_xsd__short(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__short(struct soap *soap, const char *tag, int id, const xsd__short *a, const char *type)
{
    return soap_out_short(soap, tag, id, &(a->xsd__short::__item), "xsd:short");
}

void *xsd__short::soap_in(struct soap *soap, const char *tag, const char *type)
{   return soap_in_xsd__short(soap, tag, this, type);
}

SOAP_FMAC3 xsd__short * SOAP_FMAC4 soap_in_xsd__short(struct soap *soap, const char *tag, xsd__short *a, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    if (soap_element_begin_in(soap, tag, 1, NULL))
        return NULL;
    if (!(a = (xsd__short *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_xsd__short, sizeof(xsd__short), soap->type, soap->arrayType)))
    {   soap->error = SOAP_TAG_MISMATCH;
        return NULL;
    }
    soap_revert(soap);
    *soap->id = '\0';
    if (soap->alloced)
    {   a->soap_default(soap);
        if (soap->clist->type != SOAP_TYPE_xsd__short)
            return (xsd__short *)a->soap_in(soap, tag, type);
    }
    if (!soap_in_short(soap, tag, &(a->xsd__short::__item), "xsd:short"))
        return NULL;
    return a;
}

int xsd__short::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
    register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_xsd__short);
    if (this->soap_out(soap, tag?tag:"xsd:short", id, type))
        return soap->error;
    return soap_putindependent(soap);
}

void *xsd__short::soap_get(struct soap *soap, const char *tag, const char *type)
{
    return soap_get_xsd__short(soap, this, tag, type);
}

SOAP_FMAC3 xsd__short * SOAP_FMAC4 soap_get_xsd__short(struct soap *soap, xsd__short *p, const char *tag, const char *type)
{
    if ((p = soap_in_xsd__short(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 xsd__short * SOAP_FMAC2 soap_instantiate_xsd__short(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xsd__short(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xsd__short, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(xsd__short);
        if (size)
            *size = sizeof(xsd__short);
        ((xsd__short*)cp->ptr)->soap = soap;
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(xsd__short, n);
        if (size)
            *size = n * sizeof(xsd__short);
        if (cp->ptr)
            for (int i = 0; i < n; i++)
                ((xsd__short*)cp->ptr)[i].soap = soap;
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (xsd__short*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xsd__short(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying xsd__short %p -> %p\n", q, p));
    *(xsd__short*)p = *(xsd__short*)q;
}

void xsd__long::soap_default(struct soap *soap)
{
    this->soap = soap;
    this->xsd__anyType::soap_default(soap);
    soap_default_LONG64(soap, &this->xsd__long::__item);
}

void xsd__long::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
    (void)soap; /* appease -Wall -Werror */
    this->xsd__anyType::soap_serialize(soap);
#endif
}

int xsd__long::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
    return soap_out_xsd__long(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__long(struct soap *soap, const char *tag, int id, const xsd__long *a, const char *type)
{
    return soap_out_LONG64(soap, tag, id, &(a->xsd__long::__item), "xsd:long");
}

void *xsd__long::soap_in(struct soap *soap, const char *tag, const char *type)
{   return soap_in_xsd__long(soap, tag, this, type);
}

SOAP_FMAC3 xsd__long * SOAP_FMAC4 soap_in_xsd__long(struct soap *soap, const char *tag, xsd__long *a, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    if (soap_element_begin_in(soap, tag, 1, NULL))
        return NULL;
    if (!(a = (xsd__long *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_xsd__long, sizeof(xsd__long), soap->type, soap->arrayType)))
    {   soap->error = SOAP_TAG_MISMATCH;
        return NULL;
    }
    soap_revert(soap);
    *soap->id = '\0';
    if (soap->alloced)
    {   a->soap_default(soap);
        if (soap->clist->type != SOAP_TYPE_xsd__long)
            return (xsd__long *)a->soap_in(soap, tag, type);
    }
    if (!soap_in_LONG64(soap, tag, &(a->xsd__long::__item), "xsd:long"))
        return NULL;
    return a;
}

int xsd__long::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
    register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_xsd__long);
    if (this->soap_out(soap, tag?tag:"xsd:long", id, type))
        return soap->error;
    return soap_putindependent(soap);
}

void *xsd__long::soap_get(struct soap *soap, const char *tag, const char *type)
{
    return soap_get_xsd__long(soap, this, tag, type);
}

SOAP_FMAC3 xsd__long * SOAP_FMAC4 soap_get_xsd__long(struct soap *soap, xsd__long *p, const char *tag, const char *type)
{
    if ((p = soap_in_xsd__long(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 xsd__long * SOAP_FMAC2 soap_instantiate_xsd__long(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xsd__long(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xsd__long, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(xsd__long);
        if (size)
            *size = sizeof(xsd__long);
        ((xsd__long*)cp->ptr)->soap = soap;
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(xsd__long, n);
        if (size)
            *size = n * sizeof(xsd__long);
        if (cp->ptr)
            for (int i = 0; i < n; i++)
                ((xsd__long*)cp->ptr)[i].soap = soap;
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (xsd__long*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xsd__long(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying xsd__long %p -> %p\n", q, p));
    *(xsd__long*)p = *(xsd__long*)q;
}

void xsd__int::soap_default(struct soap *soap)
{
    this->soap = soap;
    this->xsd__anyType::soap_default(soap);
    soap_default_int(soap, &this->xsd__int::__item);
}

void xsd__int::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
    (void)soap; /* appease -Wall -Werror */
    soap_embedded(soap, &this->xsd__int::__item, SOAP_TYPE_int);
    this->xsd__anyType::soap_serialize(soap);
#endif
}

int xsd__int::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
    return soap_out_xsd__int(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__int(struct soap *soap, const char *tag, int id, const xsd__int *a, const char *type)
{
    return soap_out_int(soap, tag, id, &(a->xsd__int::__item), "xsd:int");
}

void *xsd__int::soap_in(struct soap *soap, const char *tag, const char *type)
{   return soap_in_xsd__int(soap, tag, this, type);
}

SOAP_FMAC3 xsd__int * SOAP_FMAC4 soap_in_xsd__int(struct soap *soap, const char *tag, xsd__int *a, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    if (soap_element_begin_in(soap, tag, 1, NULL))
        return NULL;
    if (!(a = (xsd__int *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_xsd__int, sizeof(xsd__int), soap->type, soap->arrayType)))
    {   soap->error = SOAP_TAG_MISMATCH;
        return NULL;
    }
    soap_revert(soap);
    *soap->id = '\0';
    if (soap->alloced)
    {   a->soap_default(soap);
        if (soap->clist->type != SOAP_TYPE_xsd__int)
            return (xsd__int *)a->soap_in(soap, tag, type);
    }
    if (!soap_in_int(soap, tag, &(a->xsd__int::__item), "xsd:int"))
        return NULL;
    return a;
}

int xsd__int::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
    register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_xsd__int);
    if (this->soap_out(soap, tag?tag:"xsd:int", id, type))
        return soap->error;
    return soap_putindependent(soap);
}

void *xsd__int::soap_get(struct soap *soap, const char *tag, const char *type)
{
    return soap_get_xsd__int(soap, this, tag, type);
}

SOAP_FMAC3 xsd__int * SOAP_FMAC4 soap_get_xsd__int(struct soap *soap, xsd__int *p, const char *tag, const char *type)
{
    if ((p = soap_in_xsd__int(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 xsd__int * SOAP_FMAC2 soap_instantiate_xsd__int(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xsd__int(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xsd__int, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(xsd__int);
        if (size)
            *size = sizeof(xsd__int);
        ((xsd__int*)cp->ptr)->soap = soap;
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(xsd__int, n);
        if (size)
            *size = n * sizeof(xsd__int);
        if (cp->ptr)
            for (int i = 0; i < n; i++)
                ((xsd__int*)cp->ptr)[i].soap = soap;
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (xsd__int*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xsd__int(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying xsd__int %p -> %p\n", q, p));
    *(xsd__int*)p = *(xsd__int*)q;
}

void xsd__float::soap_default(struct soap *soap)
{
    this->soap = soap;
    this->xsd__anyType::soap_default(soap);
    soap_default_float(soap, &this->xsd__float::__item);
}

void xsd__float::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
    (void)soap; /* appease -Wall -Werror */
    this->xsd__anyType::soap_serialize(soap);
#endif
}

int xsd__float::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
    return soap_out_xsd__float(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__float(struct soap *soap, const char *tag, int id, const xsd__float *a, const char *type)
{
    return soap_out_float(soap, tag, id, &(a->xsd__float::__item), "xsd:float");
}

void *xsd__float::soap_in(struct soap *soap, const char *tag, const char *type)
{   return soap_in_xsd__float(soap, tag, this, type);
}

SOAP_FMAC3 xsd__float * SOAP_FMAC4 soap_in_xsd__float(struct soap *soap, const char *tag, xsd__float *a, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    if (soap_element_begin_in(soap, tag, 1, NULL))
        return NULL;
    if (!(a = (xsd__float *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_xsd__float, sizeof(xsd__float), soap->type, soap->arrayType)))
    {   soap->error = SOAP_TAG_MISMATCH;
        return NULL;
    }
    soap_revert(soap);
    *soap->id = '\0';
    if (soap->alloced)
    {   a->soap_default(soap);
        if (soap->clist->type != SOAP_TYPE_xsd__float)
            return (xsd__float *)a->soap_in(soap, tag, type);
    }
    if (!soap_in_float(soap, tag, &(a->xsd__float::__item), "xsd:float"))
        return NULL;
    return a;
}

int xsd__float::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
    register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_xsd__float);
    if (this->soap_out(soap, tag?tag:"xsd:float", id, type))
        return soap->error;
    return soap_putindependent(soap);
}

void *xsd__float::soap_get(struct soap *soap, const char *tag, const char *type)
{
    return soap_get_xsd__float(soap, this, tag, type);
}

SOAP_FMAC3 xsd__float * SOAP_FMAC4 soap_get_xsd__float(struct soap *soap, xsd__float *p, const char *tag, const char *type)
{
    if ((p = soap_in_xsd__float(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 xsd__float * SOAP_FMAC2 soap_instantiate_xsd__float(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xsd__float(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xsd__float, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(xsd__float);
        if (size)
            *size = sizeof(xsd__float);
        ((xsd__float*)cp->ptr)->soap = soap;
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(xsd__float, n);
        if (size)
            *size = n * sizeof(xsd__float);
        if (cp->ptr)
            for (int i = 0; i < n; i++)
                ((xsd__float*)cp->ptr)[i].soap = soap;
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (xsd__float*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xsd__float(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying xsd__float %p -> %p\n", q, p));
    *(xsd__float*)p = *(xsd__float*)q;
}

void xsd__duration_::soap_default(struct soap *soap)
{
    this->soap = soap;
    this->xsd__anyType::soap_default(soap);
    soap_default_xsd__duration(soap, &this->xsd__duration_::__item);
}

void xsd__duration_::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
    (void)soap; /* appease -Wall -Werror */
    soap_serialize_xsd__duration(soap, &this->xsd__duration_::__item);
    this->xsd__anyType::soap_serialize(soap);
#endif
}

int xsd__duration_::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
    return soap_out_xsd__duration_(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__duration_(struct soap *soap, const char *tag, int id, const xsd__duration_ *a, const char *type)
{
    return soap_out_xsd__duration(soap, tag, id, &(a->xsd__duration_::__item), "xsd:duration");
}

void *xsd__duration_::soap_in(struct soap *soap, const char *tag, const char *type)
{   return soap_in_xsd__duration_(soap, tag, this, type);
}

SOAP_FMAC3 xsd__duration_ * SOAP_FMAC4 soap_in_xsd__duration_(struct soap *soap, const char *tag, xsd__duration_ *a, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    if (soap_element_begin_in(soap, tag, 1, NULL))
        return NULL;
    if (!(a = (xsd__duration_ *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_xsd__duration_, sizeof(xsd__duration_), soap->type, soap->arrayType)))
    {   soap->error = SOAP_TAG_MISMATCH;
        return NULL;
    }
    soap_revert(soap);
    *soap->id = '\0';
    if (soap->alloced)
    {   a->soap_default(soap);
        if (soap->clist->type != SOAP_TYPE_xsd__duration_)
            return (xsd__duration_ *)a->soap_in(soap, tag, type);
    }
    if (!soap_in_xsd__duration(soap, tag, &(a->xsd__duration_::__item), "xsd:duration"))
        return NULL;
    return a;
}

int xsd__duration_::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
    register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_xsd__duration_);
    if (this->soap_out(soap, tag?tag:"xsd:duration", id, type))
        return soap->error;
    return soap_putindependent(soap);
}

void *xsd__duration_::soap_get(struct soap *soap, const char *tag, const char *type)
{
    return soap_get_xsd__duration_(soap, this, tag, type);
}

SOAP_FMAC3 xsd__duration_ * SOAP_FMAC4 soap_get_xsd__duration_(struct soap *soap, xsd__duration_ *p, const char *tag, const char *type)
{
    if ((p = soap_in_xsd__duration_(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 xsd__duration_ * SOAP_FMAC2 soap_instantiate_xsd__duration_(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xsd__duration_(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xsd__duration_, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(xsd__duration_);
        if (size)
            *size = sizeof(xsd__duration_);
        ((xsd__duration_*)cp->ptr)->soap = soap;
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(xsd__duration_, n);
        if (size)
            *size = n * sizeof(xsd__duration_);
        if (cp->ptr)
            for (int i = 0; i < n; i++)
                ((xsd__duration_*)cp->ptr)[i].soap = soap;
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (xsd__duration_*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xsd__duration_(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying xsd__duration_ %p -> %p\n", q, p));
    *(xsd__duration_*)p = *(xsd__duration_*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_xsd__duration(struct soap *soap, const std::wstring *a)
{   (void)soap; (void)a; /* appease -Wall -Werror */
}
SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__duration(struct soap *soap, const char *tag, int id, const std::wstring *s, const char *type)
{
    if ((soap->mode & SOAP_C_NILSTRING) && s->empty())
        return soap_element_null(soap, tag, id, type);
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, s, SOAP_TYPE_xsd__duration), type) || soap_wstring_out(soap, s->c_str(), 0) || soap_element_end_out(soap, tag))
        return soap->error;
    return SOAP_OK;
}

SOAP_FMAC3 std::wstring * SOAP_FMAC4 soap_in_xsd__duration(struct soap *soap, const char *tag, std::wstring *s, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    if (soap_element_begin_in(soap, tag, 1, NULL))
        return NULL;
    if (!s)
        s = soap_new_std__wstring(soap, -1);
    if (soap->null)
        if (s)
            s->erase();
    if (soap->body && !*soap->href)
    {   wchar_t *t;
        s = (std::wstring*)soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_xsd__duration, sizeof(std::wstring), soap->type, soap->arrayType);
        if (s)
        {   if (!(t = soap_wstring_in(soap, 1, 0, -1)))
                return NULL;
            s->assign(t);
        }
    }
    else
        s = (std::wstring*)soap_id_forward(soap, soap->href, soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_xsd__duration, sizeof(std::wstring), soap->type, soap->arrayType), 0, SOAP_TYPE_xsd__duration, 0, sizeof(std::wstring), 0, soap_copy_xsd__duration);
    if (soap->body && soap_element_end_in(soap, tag))
        return NULL;
    return s;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__duration(struct soap *soap, const std::wstring *a, const char *tag, const char *type)
{
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xsd__duration);
    if (soap_out_xsd__duration(soap, tag?tag:"xsd:duration", id, a, type))
        return soap->error;
    return soap_putindependent(soap);
}

SOAP_FMAC3 std::wstring * SOAP_FMAC4 soap_get_xsd__duration(struct soap *soap, std::wstring *p, const char *tag, const char *type)
{
    if ((p = soap_in_xsd__duration(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

void xsd__double::soap_default(struct soap *soap)
{
    this->soap = soap;
    this->xsd__anyType::soap_default(soap);
    soap_default_double(soap, &this->xsd__double::__item);
}

void xsd__double::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
    (void)soap; /* appease -Wall -Werror */
    this->xsd__anyType::soap_serialize(soap);
#endif
}

int xsd__double::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
    return soap_out_xsd__double(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__double(struct soap *soap, const char *tag, int id, const xsd__double *a, const char *type)
{
    return soap_out_double(soap, tag, id, &(a->xsd__double::__item), "xsd:double");
}

void *xsd__double::soap_in(struct soap *soap, const char *tag, const char *type)
{   return soap_in_xsd__double(soap, tag, this, type);
}

SOAP_FMAC3 xsd__double * SOAP_FMAC4 soap_in_xsd__double(struct soap *soap, const char *tag, xsd__double *a, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    if (soap_element_begin_in(soap, tag, 1, NULL))
        return NULL;
    if (!(a = (xsd__double *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_xsd__double, sizeof(xsd__double), soap->type, soap->arrayType)))
    {   soap->error = SOAP_TAG_MISMATCH;
        return NULL;
    }
    soap_revert(soap);
    *soap->id = '\0';
    if (soap->alloced)
    {   a->soap_default(soap);
        if (soap->clist->type != SOAP_TYPE_xsd__double)
            return (xsd__double *)a->soap_in(soap, tag, type);
    }
    if (!soap_in_double(soap, tag, &(a->xsd__double::__item), "xsd:double"))
        return NULL;
    return a;
}

int xsd__double::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
    register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_xsd__double);
    if (this->soap_out(soap, tag?tag:"xsd:double", id, type))
        return soap->error;
    return soap_putindependent(soap);
}

void *xsd__double::soap_get(struct soap *soap, const char *tag, const char *type)
{
    return soap_get_xsd__double(soap, this, tag, type);
}

SOAP_FMAC3 xsd__double * SOAP_FMAC4 soap_get_xsd__double(struct soap *soap, xsd__double *p, const char *tag, const char *type)
{
    if ((p = soap_in_xsd__double(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 xsd__double * SOAP_FMAC2 soap_instantiate_xsd__double(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xsd__double(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xsd__double, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(xsd__double);
        if (size)
            *size = sizeof(xsd__double);
        ((xsd__double*)cp->ptr)->soap = soap;
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(xsd__double, n);
        if (size)
            *size = n * sizeof(xsd__double);
        if (cp->ptr)
            for (int i = 0; i < n; i++)
                ((xsd__double*)cp->ptr)[i].soap = soap;
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (xsd__double*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xsd__double(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying xsd__double %p -> %p\n", q, p));
    *(xsd__double*)p = *(xsd__double*)q;
}

void xsd__decimal_::soap_default(struct soap *soap)
{
    this->soap = soap;
    this->xsd__anyType::soap_default(soap);
    soap_default_xsd__decimal(soap, &this->xsd__decimal_::__item);
}

void xsd__decimal_::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
    (void)soap; /* appease -Wall -Werror */
    soap_serialize_xsd__decimal(soap, &this->xsd__decimal_::__item);
    this->xsd__anyType::soap_serialize(soap);
#endif
}

int xsd__decimal_::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
    return soap_out_xsd__decimal_(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__decimal_(struct soap *soap, const char *tag, int id, const xsd__decimal_ *a, const char *type)
{
    return soap_out_xsd__decimal(soap, tag, id, &(a->xsd__decimal_::__item), "xsd:decimal");
}

void *xsd__decimal_::soap_in(struct soap *soap, const char *tag, const char *type)
{   return soap_in_xsd__decimal_(soap, tag, this, type);
}

SOAP_FMAC3 xsd__decimal_ * SOAP_FMAC4 soap_in_xsd__decimal_(struct soap *soap, const char *tag, xsd__decimal_ *a, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    if (soap_element_begin_in(soap, tag, 1, NULL))
        return NULL;
    if (!(a = (xsd__decimal_ *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_xsd__decimal_, sizeof(xsd__decimal_), soap->type, soap->arrayType)))
    {   soap->error = SOAP_TAG_MISMATCH;
        return NULL;
    }
    soap_revert(soap);
    *soap->id = '\0';
    if (soap->alloced)
    {   a->soap_default(soap);
        if (soap->clist->type != SOAP_TYPE_xsd__decimal_)
            return (xsd__decimal_ *)a->soap_in(soap, tag, type);
    }
    if (!soap_in_xsd__decimal(soap, tag, &(a->xsd__decimal_::__item), "xsd:decimal"))
        return NULL;
    return a;
}

int xsd__decimal_::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
    register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_xsd__decimal_);
    if (this->soap_out(soap, tag?tag:"xsd:decimal", id, type))
        return soap->error;
    return soap_putindependent(soap);
}

void *xsd__decimal_::soap_get(struct soap *soap, const char *tag, const char *type)
{
    return soap_get_xsd__decimal_(soap, this, tag, type);
}

SOAP_FMAC3 xsd__decimal_ * SOAP_FMAC4 soap_get_xsd__decimal_(struct soap *soap, xsd__decimal_ *p, const char *tag, const char *type)
{
    if ((p = soap_in_xsd__decimal_(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 xsd__decimal_ * SOAP_FMAC2 soap_instantiate_xsd__decimal_(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xsd__decimal_(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xsd__decimal_, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(xsd__decimal_);
        if (size)
            *size = sizeof(xsd__decimal_);
        ((xsd__decimal_*)cp->ptr)->soap = soap;
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(xsd__decimal_, n);
        if (size)
            *size = n * sizeof(xsd__decimal_);
        if (cp->ptr)
            for (int i = 0; i < n; i++)
                ((xsd__decimal_*)cp->ptr)[i].soap = soap;
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (xsd__decimal_*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xsd__decimal_(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying xsd__decimal_ %p -> %p\n", q, p));
    *(xsd__decimal_*)p = *(xsd__decimal_*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_xsd__decimal(struct soap *soap, const std::wstring *a)
{   (void)soap; (void)a; /* appease -Wall -Werror */
}
SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__decimal(struct soap *soap, const char *tag, int id, const std::wstring *s, const char *type)
{
    if ((soap->mode & SOAP_C_NILSTRING) && s->empty())
        return soap_element_null(soap, tag, id, type);
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, s, SOAP_TYPE_xsd__decimal), type) || soap_wstring_out(soap, s->c_str(), 0) || soap_element_end_out(soap, tag))
        return soap->error;
    return SOAP_OK;
}

SOAP_FMAC3 std::wstring * SOAP_FMAC4 soap_in_xsd__decimal(struct soap *soap, const char *tag, std::wstring *s, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    if (soap_element_begin_in(soap, tag, 1, NULL))
        return NULL;
    if (!s)
        s = soap_new_std__wstring(soap, -1);
    if (soap->null)
        if (s)
            s->erase();
    if (soap->body && !*soap->href)
    {   wchar_t *t;
        s = (std::wstring*)soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_xsd__decimal, sizeof(std::wstring), soap->type, soap->arrayType);
        if (s)
        {   if (!(t = soap_wstring_in(soap, 1, 0, -1)))
                return NULL;
            s->assign(t);
        }
    }
    else
        s = (std::wstring*)soap_id_forward(soap, soap->href, soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_xsd__decimal, sizeof(std::wstring), soap->type, soap->arrayType), 0, SOAP_TYPE_xsd__decimal, 0, sizeof(std::wstring), 0, soap_copy_xsd__decimal);
    if (soap->body && soap_element_end_in(soap, tag))
        return NULL;
    return s;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__decimal(struct soap *soap, const std::wstring *a, const char *tag, const char *type)
{
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xsd__decimal);
    if (soap_out_xsd__decimal(soap, tag?tag:"xsd:decimal", id, a, type))
        return soap->error;
    return soap_putindependent(soap);
}

SOAP_FMAC3 std::wstring * SOAP_FMAC4 soap_get_xsd__decimal(struct soap *soap, std::wstring *p, const char *tag, const char *type)
{
    if ((p = soap_in_xsd__decimal(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

void xsd__dateTime::soap_default(struct soap *soap)
{
    this->soap = soap;
    this->xsd__anyType::soap_default(soap);
    soap_default_time(soap, &this->xsd__dateTime::__item);
}

void xsd__dateTime::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
    (void)soap; /* appease -Wall -Werror */
    this->xsd__anyType::soap_serialize(soap);
#endif
}

int xsd__dateTime::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
    return soap_out_xsd__dateTime(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__dateTime(struct soap *soap, const char *tag, int id, const xsd__dateTime *a, const char *type)
{
    return soap_out_time(soap, tag, id, &(a->xsd__dateTime::__item), "xsd:dateTime");
}

void *xsd__dateTime::soap_in(struct soap *soap, const char *tag, const char *type)
{   return soap_in_xsd__dateTime(soap, tag, this, type);
}

SOAP_FMAC3 xsd__dateTime * SOAP_FMAC4 soap_in_xsd__dateTime(struct soap *soap, const char *tag, xsd__dateTime *a, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    if (soap_element_begin_in(soap, tag, 1, NULL))
        return NULL;
    if (!(a = (xsd__dateTime *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_xsd__dateTime, sizeof(xsd__dateTime), soap->type, soap->arrayType)))
    {   soap->error = SOAP_TAG_MISMATCH;
        return NULL;
    }
    soap_revert(soap);
    *soap->id = '\0';
    if (soap->alloced)
    {   a->soap_default(soap);
        if (soap->clist->type != SOAP_TYPE_xsd__dateTime)
            return (xsd__dateTime *)a->soap_in(soap, tag, type);
    }
    if (!soap_in_time(soap, tag, &(a->xsd__dateTime::__item), "xsd:dateTime"))
        return NULL;
    return a;
}

int xsd__dateTime::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
    register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_xsd__dateTime);
    if (this->soap_out(soap, tag?tag:"xsd:dateTime", id, type))
        return soap->error;
    return soap_putindependent(soap);
}

void *xsd__dateTime::soap_get(struct soap *soap, const char *tag, const char *type)
{
    return soap_get_xsd__dateTime(soap, this, tag, type);
}

SOAP_FMAC3 xsd__dateTime * SOAP_FMAC4 soap_get_xsd__dateTime(struct soap *soap, xsd__dateTime *p, const char *tag, const char *type)
{
    if ((p = soap_in_xsd__dateTime(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 xsd__dateTime * SOAP_FMAC2 soap_instantiate_xsd__dateTime(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xsd__dateTime(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xsd__dateTime, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(xsd__dateTime);
        if (size)
            *size = sizeof(xsd__dateTime);
        ((xsd__dateTime*)cp->ptr)->soap = soap;
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(xsd__dateTime, n);
        if (size)
            *size = n * sizeof(xsd__dateTime);
        if (cp->ptr)
            for (int i = 0; i < n; i++)
                ((xsd__dateTime*)cp->ptr)[i].soap = soap;
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (xsd__dateTime*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xsd__dateTime(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying xsd__dateTime %p -> %p\n", q, p));
    *(xsd__dateTime*)p = *(xsd__dateTime*)q;
}

void xsd__byte_::soap_default(struct soap *soap)
{
    this->soap = soap;
    this->xsd__anyType::soap_default(soap);
    soap_default_xsd__byte(soap, &this->xsd__byte_::__item);
}

void xsd__byte_::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
    (void)soap; /* appease -Wall -Werror */
    this->xsd__anyType::soap_serialize(soap);
#endif
}

int xsd__byte_::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
    return soap_out_xsd__byte_(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__byte_(struct soap *soap, const char *tag, int id, const xsd__byte_ *a, const char *type)
{
    return soap_out_xsd__byte(soap, tag, id, &(a->xsd__byte_::__item), "xsd:byte");
}

void *xsd__byte_::soap_in(struct soap *soap, const char *tag, const char *type)
{   return soap_in_xsd__byte_(soap, tag, this, type);
}

SOAP_FMAC3 xsd__byte_ * SOAP_FMAC4 soap_in_xsd__byte_(struct soap *soap, const char *tag, xsd__byte_ *a, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    if (soap_element_begin_in(soap, tag, 1, NULL))
        return NULL;
    if (!(a = (xsd__byte_ *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_xsd__byte_, sizeof(xsd__byte_), soap->type, soap->arrayType)))
    {   soap->error = SOAP_TAG_MISMATCH;
        return NULL;
    }
    soap_revert(soap);
    *soap->id = '\0';
    if (soap->alloced)
    {   a->soap_default(soap);
        if (soap->clist->type != SOAP_TYPE_xsd__byte_)
            return (xsd__byte_ *)a->soap_in(soap, tag, type);
    }
    if (!soap_in_xsd__byte(soap, tag, &(a->xsd__byte_::__item), "xsd:byte"))
        return NULL;
    return a;
}

int xsd__byte_::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
    register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_xsd__byte_);
    if (this->soap_out(soap, tag?tag:"xsd:byte", id, type))
        return soap->error;
    return soap_putindependent(soap);
}

void *xsd__byte_::soap_get(struct soap *soap, const char *tag, const char *type)
{
    return soap_get_xsd__byte_(soap, this, tag, type);
}

SOAP_FMAC3 xsd__byte_ * SOAP_FMAC4 soap_get_xsd__byte_(struct soap *soap, xsd__byte_ *p, const char *tag, const char *type)
{
    if ((p = soap_in_xsd__byte_(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 xsd__byte_ * SOAP_FMAC2 soap_instantiate_xsd__byte_(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xsd__byte_(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xsd__byte_, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(xsd__byte_);
        if (size)
            *size = sizeof(xsd__byte_);
        ((xsd__byte_*)cp->ptr)->soap = soap;
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(xsd__byte_, n);
        if (size)
            *size = n * sizeof(xsd__byte_);
        if (cp->ptr)
            for (int i = 0; i < n; i++)
                ((xsd__byte_*)cp->ptr)[i].soap = soap;
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (xsd__byte_*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xsd__byte_(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying xsd__byte_ %p -> %p\n", q, p));
    *(xsd__byte_*)p = *(xsd__byte_*)q;
}

void xsd__boolean::soap_default(struct soap *soap)
{
    this->soap = soap;
    this->xsd__anyType::soap_default(soap);
    soap_default_bool(soap, &this->xsd__boolean::__item);
}

void xsd__boolean::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
    (void)soap; /* appease -Wall -Werror */
    soap_embedded(soap, &this->xsd__boolean::__item, SOAP_TYPE_bool);
    this->xsd__anyType::soap_serialize(soap);
#endif
}

int xsd__boolean::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
    return soap_out_xsd__boolean(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__boolean(struct soap *soap, const char *tag, int id, const xsd__boolean *a, const char *type)
{
    return soap_out_bool(soap, tag, id, &(a->xsd__boolean::__item), "xsd:boolean");
}

void *xsd__boolean::soap_in(struct soap *soap, const char *tag, const char *type)
{   return soap_in_xsd__boolean(soap, tag, this, type);
}

SOAP_FMAC3 xsd__boolean * SOAP_FMAC4 soap_in_xsd__boolean(struct soap *soap, const char *tag, xsd__boolean *a, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    if (soap_element_begin_in(soap, tag, 1, NULL))
        return NULL;
    if (!(a = (xsd__boolean *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_xsd__boolean, sizeof(xsd__boolean), soap->type, soap->arrayType)))
    {   soap->error = SOAP_TAG_MISMATCH;
        return NULL;
    }
    soap_revert(soap);
    *soap->id = '\0';
    if (soap->alloced)
    {   a->soap_default(soap);
        if (soap->clist->type != SOAP_TYPE_xsd__boolean)
            return (xsd__boolean *)a->soap_in(soap, tag, type);
    }
    if (!soap_in_bool(soap, tag, &(a->xsd__boolean::__item), "xsd:boolean"))
        return NULL;
    return a;
}

int xsd__boolean::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
    register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_xsd__boolean);
    if (this->soap_out(soap, tag?tag:"xsd:boolean", id, type))
        return soap->error;
    return soap_putindependent(soap);
}

void *xsd__boolean::soap_get(struct soap *soap, const char *tag, const char *type)
{
    return soap_get_xsd__boolean(soap, this, tag, type);
}

SOAP_FMAC3 xsd__boolean * SOAP_FMAC4 soap_get_xsd__boolean(struct soap *soap, xsd__boolean *p, const char *tag, const char *type)
{
    if ((p = soap_in_xsd__boolean(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 xsd__boolean * SOAP_FMAC2 soap_instantiate_xsd__boolean(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xsd__boolean(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xsd__boolean, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(xsd__boolean);
        if (size)
            *size = sizeof(xsd__boolean);
        ((xsd__boolean*)cp->ptr)->soap = soap;
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(xsd__boolean, n);
        if (size)
            *size = n * sizeof(xsd__boolean);
        if (cp->ptr)
            for (int i = 0; i < n; i++)
                ((xsd__boolean*)cp->ptr)[i].soap = soap;
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (xsd__boolean*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xsd__boolean(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying xsd__boolean %p -> %p\n", q, p));
    *(xsd__boolean*)p = *(xsd__boolean*)q;
}

void xsd__base64Binary::soap_default(struct soap *soap)
{
    this->soap = soap;
    this->xsd__anyType::soap_default(soap);
    soap_default__xop__Include(soap, &this->xsd__base64Binary::__item);
}

void xsd__base64Binary::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
    (void)soap; /* appease -Wall -Werror */
    soap_embedded(soap, &this->xsd__base64Binary::__item, SOAP_TYPE__xop__Include);
    soap_serialize__xop__Include(soap, &this->xsd__base64Binary::__item);
    this->xsd__anyType::soap_serialize(soap);
#endif
}

int xsd__base64Binary::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
    return soap_out_xsd__base64Binary(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__base64Binary(struct soap *soap, const char *tag, int id, const xsd__base64Binary *a, const char *type)
{
    return soap_out__xop__Include(soap, tag, id, &(a->xsd__base64Binary::__item), "xsd:base64Binary");
}

void *xsd__base64Binary::soap_in(struct soap *soap, const char *tag, const char *type)
{   return soap_in_xsd__base64Binary(soap, tag, this, type);
}

SOAP_FMAC3 xsd__base64Binary * SOAP_FMAC4 soap_in_xsd__base64Binary(struct soap *soap, const char *tag, xsd__base64Binary *a, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    if (soap_element_begin_in(soap, tag, 1, NULL))
        return NULL;
    if (!(a = (xsd__base64Binary *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_xsd__base64Binary, sizeof(xsd__base64Binary), soap->type, soap->arrayType)))
    {   soap->error = SOAP_TAG_MISMATCH;
        return NULL;
    }
    soap_revert(soap);
    *soap->id = '\0';
    if (soap->alloced)
    {   a->soap_default(soap);
        if (soap->clist->type != SOAP_TYPE_xsd__base64Binary)
            return (xsd__base64Binary *)a->soap_in(soap, tag, type);
    }
    if (!soap_in__xop__Include(soap, tag, &(a->xsd__base64Binary::__item), "xsd:base64Binary"))
        return NULL;
    return a;
}

int xsd__base64Binary::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
    register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_xsd__base64Binary);
    if (this->soap_out(soap, tag?tag:"xsd:base64Binary", id, type))
        return soap->error;
    return soap_putindependent(soap);
}

void *xsd__base64Binary::soap_get(struct soap *soap, const char *tag, const char *type)
{
    return soap_get_xsd__base64Binary(soap, this, tag, type);
}

SOAP_FMAC3 xsd__base64Binary * SOAP_FMAC4 soap_get_xsd__base64Binary(struct soap *soap, xsd__base64Binary *p, const char *tag, const char *type)
{
    if ((p = soap_in_xsd__base64Binary(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 xsd__base64Binary * SOAP_FMAC2 soap_instantiate_xsd__base64Binary(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xsd__base64Binary(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xsd__base64Binary, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(xsd__base64Binary);
        if (size)
            *size = sizeof(xsd__base64Binary);
        ((xsd__base64Binary*)cp->ptr)->soap = soap;
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(xsd__base64Binary, n);
        if (size)
            *size = n * sizeof(xsd__base64Binary);
        if (cp->ptr)
            for (int i = 0; i < n; i++)
                ((xsd__base64Binary*)cp->ptr)[i].soap = soap;
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (xsd__base64Binary*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xsd__base64Binary(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying xsd__base64Binary %p -> %p\n", q, p));
    *(xsd__base64Binary*)p = *(xsd__base64Binary*)q;
}

void xsd__anyURI_::soap_default(struct soap *soap)
{
    this->soap = soap;
    this->xsd__anyType::soap_default(soap);
    soap_default_xsd__anyURI(soap, &this->xsd__anyURI_::__item);
}

void xsd__anyURI_::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
    (void)soap; /* appease -Wall -Werror */
    soap_serialize_xsd__anyURI(soap, &this->xsd__anyURI_::__item);
    this->xsd__anyType::soap_serialize(soap);
#endif
}

int xsd__anyURI_::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
    return soap_out_xsd__anyURI_(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__anyURI_(struct soap *soap, const char *tag, int id, const xsd__anyURI_ *a, const char *type)
{
    return soap_out_xsd__anyURI(soap, tag, id, &(a->xsd__anyURI_::__item), "xsd:anyURI");
}

void *xsd__anyURI_::soap_in(struct soap *soap, const char *tag, const char *type)
{   return soap_in_xsd__anyURI_(soap, tag, this, type);
}

SOAP_FMAC3 xsd__anyURI_ * SOAP_FMAC4 soap_in_xsd__anyURI_(struct soap *soap, const char *tag, xsd__anyURI_ *a, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    if (soap_element_begin_in(soap, tag, 1, NULL))
        return NULL;
    if (!(a = (xsd__anyURI_ *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_xsd__anyURI_, sizeof(xsd__anyURI_), soap->type, soap->arrayType)))
    {   soap->error = SOAP_TAG_MISMATCH;
        return NULL;
    }
    soap_revert(soap);
    *soap->id = '\0';
    if (soap->alloced)
    {   a->soap_default(soap);
        if (soap->clist->type != SOAP_TYPE_xsd__anyURI_)
            return (xsd__anyURI_ *)a->soap_in(soap, tag, type);
    }
    if (!soap_in_xsd__anyURI(soap, tag, &(a->xsd__anyURI_::__item), "xsd:anyURI"))
        return NULL;
    return a;
}

int xsd__anyURI_::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
    register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_xsd__anyURI_);
    if (this->soap_out(soap, tag?tag:"xsd:anyURI", id, type))
        return soap->error;
    return soap_putindependent(soap);
}

void *xsd__anyURI_::soap_get(struct soap *soap, const char *tag, const char *type)
{
    return soap_get_xsd__anyURI_(soap, this, tag, type);
}

SOAP_FMAC3 xsd__anyURI_ * SOAP_FMAC4 soap_get_xsd__anyURI_(struct soap *soap, xsd__anyURI_ *p, const char *tag, const char *type)
{
    if ((p = soap_in_xsd__anyURI_(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 xsd__anyURI_ * SOAP_FMAC2 soap_instantiate_xsd__anyURI_(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xsd__anyURI_(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xsd__anyURI_, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(xsd__anyURI_);
        if (size)
            *size = sizeof(xsd__anyURI_);
        ((xsd__anyURI_*)cp->ptr)->soap = soap;
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(xsd__anyURI_, n);
        if (size)
            *size = n * sizeof(xsd__anyURI_);
        if (cp->ptr)
            for (int i = 0; i < n; i++)
                ((xsd__anyURI_*)cp->ptr)[i].soap = soap;
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (xsd__anyURI_*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xsd__anyURI_(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying xsd__anyURI_ %p -> %p\n", q, p));
    *(xsd__anyURI_*)p = *(xsd__anyURI_*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_xsd__anyURI(struct soap *soap, const std::wstring *a)
{   (void)soap; (void)a; /* appease -Wall -Werror */
}
SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__anyURI(struct soap *soap, const char *tag, int id, const std::wstring *s, const char *type)
{
    if ((soap->mode & SOAP_C_NILSTRING) && s->empty())
        return soap_element_null(soap, tag, id, type);
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, s, SOAP_TYPE_xsd__anyURI), type) || soap_wstring_out(soap, s->c_str(), 0) || soap_element_end_out(soap, tag))
        return soap->error;
    return SOAP_OK;
}

SOAP_FMAC3 std::wstring * SOAP_FMAC4 soap_in_xsd__anyURI(struct soap *soap, const char *tag, std::wstring *s, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    if (soap_element_begin_in(soap, tag, 1, NULL))
        return NULL;
    if (!s)
        s = soap_new_std__wstring(soap, -1);
    if (soap->null)
        if (s)
            s->erase();
    if (soap->body && !*soap->href)
    {   wchar_t *t;
        s = (std::wstring*)soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_xsd__anyURI, sizeof(std::wstring), soap->type, soap->arrayType);
        if (s)
        {   if (!(t = soap_wstring_in(soap, 1, 0, -1)))
                return NULL;
            s->assign(t);
        }
    }
    else
        s = (std::wstring*)soap_id_forward(soap, soap->href, soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_xsd__anyURI, sizeof(std::wstring), soap->type, soap->arrayType), 0, SOAP_TYPE_xsd__anyURI, 0, sizeof(std::wstring), 0, soap_copy_xsd__anyURI);
    if (soap->body && soap_element_end_in(soap, tag))
        return NULL;
    return s;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__anyURI(struct soap *soap, const std::wstring *a, const char *tag, const char *type)
{
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xsd__anyURI);
    if (soap_out_xsd__anyURI(soap, tag?tag:"xsd:anyURI", id, a, type))
        return soap->error;
    return soap_putindependent(soap);
}

SOAP_FMAC3 std::wstring * SOAP_FMAC4 soap_get_xsd__anyURI(struct soap *soap, std::wstring *p, const char *tag, const char *type)
{
    if ((p = soap_in_xsd__anyURI(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

void xsd__QName_::soap_default(struct soap *soap)
{
    this->soap = soap;
    this->xsd__anyType::soap_default(soap);
    soap_default_xsd__QName(soap, &this->xsd__QName_::__item);
}

void xsd__QName_::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
    (void)soap; /* appease -Wall -Werror */
    soap_serialize_xsd__QName(soap, &this->xsd__QName_::__item);
    this->xsd__anyType::soap_serialize(soap);
#endif
}

int xsd__QName_::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
    return soap_out_xsd__QName_(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__QName_(struct soap *soap, const char *tag, int id, const xsd__QName_ *a, const char *type)
{
    std::string soap_tmp___item(soap_QName2s(soap, a->__item.c_str()));
    return soap_out_xsd__QName(soap, tag, id, &soap_tmp___item, "xsd:QName");
}

void *xsd__QName_::soap_in(struct soap *soap, const char *tag, const char *type)
{   return soap_in_xsd__QName_(soap, tag, this, type);
}

SOAP_FMAC3 xsd__QName_ * SOAP_FMAC4 soap_in_xsd__QName_(struct soap *soap, const char *tag, xsd__QName_ *a, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    if (soap_element_begin_in(soap, tag, 1, NULL))
        return NULL;
    if (!(a = (xsd__QName_ *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_xsd__QName_, sizeof(xsd__QName_), soap->type, soap->arrayType)))
    {   soap->error = SOAP_TAG_MISMATCH;
        return NULL;
    }
    soap_revert(soap);
    *soap->id = '\0';
    if (soap->alloced)
    {   a->soap_default(soap);
        if (soap->clist->type != SOAP_TYPE_xsd__QName_)
            return (xsd__QName_ *)a->soap_in(soap, tag, type);
    }
    if (!soap_in_xsd__QName(soap, tag, &(a->xsd__QName_::__item), "xsd:QName"))
        return NULL;
    return a;
}

int xsd__QName_::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
    register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_xsd__QName_);
    if (this->soap_out(soap, tag?tag:"xsd:QName", id, type))
        return soap->error;
    return soap_putindependent(soap);
}

void *xsd__QName_::soap_get(struct soap *soap, const char *tag, const char *type)
{
    return soap_get_xsd__QName_(soap, this, tag, type);
}

SOAP_FMAC3 xsd__QName_ * SOAP_FMAC4 soap_get_xsd__QName_(struct soap *soap, xsd__QName_ *p, const char *tag, const char *type)
{
    if ((p = soap_in_xsd__QName_(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 xsd__QName_ * SOAP_FMAC2 soap_instantiate_xsd__QName_(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xsd__QName_(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xsd__QName_, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(xsd__QName_);
        if (size)
            *size = sizeof(xsd__QName_);
        ((xsd__QName_*)cp->ptr)->soap = soap;
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(xsd__QName_, n);
        if (size)
            *size = n * sizeof(xsd__QName_);
        if (cp->ptr)
            for (int i = 0; i < n; i++)
                ((xsd__QName_*)cp->ptr)[i].soap = soap;
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (xsd__QName_*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xsd__QName_(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying xsd__QName_ %p -> %p\n", q, p));
    *(xsd__QName_*)p = *(xsd__QName_*)q;
}

void xsd__IDREF_::soap_default(struct soap *soap)
{
    this->soap = soap;
    this->xsd__anyType::soap_default(soap);
    soap_default_xsd__IDREF(soap, &this->xsd__IDREF_::__item);
}

void xsd__IDREF_::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
    (void)soap; /* appease -Wall -Werror */
    soap_serialize_xsd__IDREF(soap, &this->xsd__IDREF_::__item);
    this->xsd__anyType::soap_serialize(soap);
#endif
}

int xsd__IDREF_::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
    return soap_out_xsd__IDREF_(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__IDREF_(struct soap *soap, const char *tag, int id, const xsd__IDREF_ *a, const char *type)
{
    return soap_out_xsd__IDREF(soap, tag, id, &(a->xsd__IDREF_::__item), "xsd:IDREF");
}

void *xsd__IDREF_::soap_in(struct soap *soap, const char *tag, const char *type)
{   return soap_in_xsd__IDREF_(soap, tag, this, type);
}

SOAP_FMAC3 xsd__IDREF_ * SOAP_FMAC4 soap_in_xsd__IDREF_(struct soap *soap, const char *tag, xsd__IDREF_ *a, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    if (soap_element_begin_in(soap, tag, 1, NULL))
        return NULL;
    if (!(a = (xsd__IDREF_ *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_xsd__IDREF_, sizeof(xsd__IDREF_), soap->type, soap->arrayType)))
    {   soap->error = SOAP_TAG_MISMATCH;
        return NULL;
    }
    soap_revert(soap);
    *soap->id = '\0';
    if (soap->alloced)
    {   a->soap_default(soap);
        if (soap->clist->type != SOAP_TYPE_xsd__IDREF_)
            return (xsd__IDREF_ *)a->soap_in(soap, tag, type);
    }
    if (!soap_in_xsd__IDREF(soap, tag, &(a->xsd__IDREF_::__item), "xsd:IDREF"))
        return NULL;
    return a;
}

int xsd__IDREF_::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
    register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_xsd__IDREF_);
    if (this->soap_out(soap, tag?tag:"xsd:IDREF", id, type))
        return soap->error;
    return soap_putindependent(soap);
}

void *xsd__IDREF_::soap_get(struct soap *soap, const char *tag, const char *type)
{
    return soap_get_xsd__IDREF_(soap, this, tag, type);
}

SOAP_FMAC3 xsd__IDREF_ * SOAP_FMAC4 soap_get_xsd__IDREF_(struct soap *soap, xsd__IDREF_ *p, const char *tag, const char *type)
{
    if ((p = soap_in_xsd__IDREF_(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 xsd__IDREF_ * SOAP_FMAC2 soap_instantiate_xsd__IDREF_(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xsd__IDREF_(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xsd__IDREF_, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(xsd__IDREF_);
        if (size)
            *size = sizeof(xsd__IDREF_);
        ((xsd__IDREF_*)cp->ptr)->soap = soap;
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(xsd__IDREF_, n);
        if (size)
            *size = n * sizeof(xsd__IDREF_);
        if (cp->ptr)
            for (int i = 0; i < n; i++)
                ((xsd__IDREF_*)cp->ptr)[i].soap = soap;
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (xsd__IDREF_*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xsd__IDREF_(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying xsd__IDREF_ %p -> %p\n", q, p));
    *(xsd__IDREF_*)p = *(xsd__IDREF_*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_xsd__IDREF(struct soap *soap, const std::wstring *a)
{   (void)soap; (void)a; /* appease -Wall -Werror */
}
SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__IDREF(struct soap *soap, const char *tag, int id, const std::wstring *s, const char *type)
{
    if ((soap->mode & SOAP_C_NILSTRING) && s->empty())
        return soap_element_null(soap, tag, id, type);
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, s, SOAP_TYPE_xsd__IDREF), type) || soap_wstring_out(soap, s->c_str(), 0) || soap_element_end_out(soap, tag))
        return soap->error;
    return SOAP_OK;
}

SOAP_FMAC3 std::wstring * SOAP_FMAC4 soap_in_xsd__IDREF(struct soap *soap, const char *tag, std::wstring *s, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    if (soap_element_begin_in(soap, tag, 1, NULL))
        return NULL;
    if (!s)
        s = soap_new_std__wstring(soap, -1);
    if (soap->null)
        if (s)
            s->erase();
    if (soap->body && !*soap->href)
    {   wchar_t *t;
        s = (std::wstring*)soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_xsd__IDREF, sizeof(std::wstring), soap->type, soap->arrayType);
        if (s)
        {   if (!(t = soap_wstring_in(soap, 1, 0, -1)))
                return NULL;
            s->assign(t);
        }
    }
    else
        s = (std::wstring*)soap_id_forward(soap, soap->href, soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_xsd__IDREF, sizeof(std::wstring), soap->type, soap->arrayType), 0, SOAP_TYPE_xsd__IDREF, 0, sizeof(std::wstring), 0, soap_copy_xsd__IDREF);
    if (soap->body && soap_element_end_in(soap, tag))
        return NULL;
    return s;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__IDREF(struct soap *soap, const std::wstring *a, const char *tag, const char *type)
{
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xsd__IDREF);
    if (soap_out_xsd__IDREF(soap, tag?tag:"xsd:IDREF", id, a, type))
        return soap->error;
    return soap_putindependent(soap);
}

SOAP_FMAC3 std::wstring * SOAP_FMAC4 soap_get_xsd__IDREF(struct soap *soap, std::wstring *p, const char *tag, const char *type)
{
    if ((p = soap_in_xsd__IDREF(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

void xsd__ID_::soap_default(struct soap *soap)
{
    this->soap = soap;
    this->xsd__anyType::soap_default(soap);
    soap_default_xsd__ID(soap, &this->xsd__ID_::__item);
}

void xsd__ID_::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
    (void)soap; /* appease -Wall -Werror */
    soap_serialize_xsd__ID(soap, &this->xsd__ID_::__item);
    this->xsd__anyType::soap_serialize(soap);
#endif
}

int xsd__ID_::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
    return soap_out_xsd__ID_(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__ID_(struct soap *soap, const char *tag, int id, const xsd__ID_ *a, const char *type)
{
    return soap_out_xsd__ID(soap, tag, id, &(a->xsd__ID_::__item), "xsd:ID");
}

void *xsd__ID_::soap_in(struct soap *soap, const char *tag, const char *type)
{   return soap_in_xsd__ID_(soap, tag, this, type);
}

SOAP_FMAC3 xsd__ID_ * SOAP_FMAC4 soap_in_xsd__ID_(struct soap *soap, const char *tag, xsd__ID_ *a, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    if (soap_element_begin_in(soap, tag, 1, NULL))
        return NULL;
    if (!(a = (xsd__ID_ *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_xsd__ID_, sizeof(xsd__ID_), soap->type, soap->arrayType)))
    {   soap->error = SOAP_TAG_MISMATCH;
        return NULL;
    }
    soap_revert(soap);
    *soap->id = '\0';
    if (soap->alloced)
    {   a->soap_default(soap);
        if (soap->clist->type != SOAP_TYPE_xsd__ID_)
            return (xsd__ID_ *)a->soap_in(soap, tag, type);
    }
    if (!soap_in_xsd__ID(soap, tag, &(a->xsd__ID_::__item), "xsd:ID"))
        return NULL;
    return a;
}

int xsd__ID_::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
    register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_xsd__ID_);
    if (this->soap_out(soap, tag?tag:"xsd:ID", id, type))
        return soap->error;
    return soap_putindependent(soap);
}

void *xsd__ID_::soap_get(struct soap *soap, const char *tag, const char *type)
{
    return soap_get_xsd__ID_(soap, this, tag, type);
}

SOAP_FMAC3 xsd__ID_ * SOAP_FMAC4 soap_get_xsd__ID_(struct soap *soap, xsd__ID_ *p, const char *tag, const char *type)
{
    if ((p = soap_in_xsd__ID_(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 xsd__ID_ * SOAP_FMAC2 soap_instantiate_xsd__ID_(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xsd__ID_(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xsd__ID_, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(xsd__ID_);
        if (size)
            *size = sizeof(xsd__ID_);
        ((xsd__ID_*)cp->ptr)->soap = soap;
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(xsd__ID_, n);
        if (size)
            *size = n * sizeof(xsd__ID_);
        if (cp->ptr)
            for (int i = 0; i < n; i++)
                ((xsd__ID_*)cp->ptr)[i].soap = soap;
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (xsd__ID_*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xsd__ID_(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying xsd__ID_ %p -> %p\n", q, p));
    *(xsd__ID_*)p = *(xsd__ID_*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_xsd__ID(struct soap *soap, const std::wstring *a)
{   (void)soap; (void)a; /* appease -Wall -Werror */
}
SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__ID(struct soap *soap, const char *tag, int id, const std::wstring *s, const char *type)
{
    if ((soap->mode & SOAP_C_NILSTRING) && s->empty())
        return soap_element_null(soap, tag, id, type);
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, s, SOAP_TYPE_xsd__ID), type) || soap_wstring_out(soap, s->c_str(), 0) || soap_element_end_out(soap, tag))
        return soap->error;
    return SOAP_OK;
}

SOAP_FMAC3 std::wstring * SOAP_FMAC4 soap_in_xsd__ID(struct soap *soap, const char *tag, std::wstring *s, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    if (soap_element_begin_in(soap, tag, 1, NULL))
        return NULL;
    if (!s)
        s = soap_new_std__wstring(soap, -1);
    if (soap->null)
        if (s)
            s->erase();
    if (soap->body && !*soap->href)
    {   wchar_t *t;
        s = (std::wstring*)soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_xsd__ID, sizeof(std::wstring), soap->type, soap->arrayType);
        if (s)
        {   if (!(t = soap_wstring_in(soap, 1, 0, -1)))
                return NULL;
            s->assign(t);
        }
    }
    else
        s = (std::wstring*)soap_id_forward(soap, soap->href, soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_xsd__ID, sizeof(std::wstring), soap->type, soap->arrayType), 0, SOAP_TYPE_xsd__ID, 0, sizeof(std::wstring), 0, soap_copy_xsd__ID);
    if (soap->body && soap_element_end_in(soap, tag))
        return NULL;
    return s;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__ID(struct soap *soap, const std::wstring *a, const char *tag, const char *type)
{
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xsd__ID);
    if (soap_out_xsd__ID(soap, tag?tag:"xsd:ID", id, a, type))
        return soap->error;
    return soap_putindependent(soap);
}

SOAP_FMAC3 std::wstring * SOAP_FMAC4 soap_get_xsd__ID(struct soap *soap, std::wstring *p, const char *tag, const char *type)
{
    if ((p = soap_in_xsd__ID(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__wstring(struct soap *soap, std::wstring *p)
{
    (void)soap; /* appease -Wall -Werror */
    p->erase();
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__wstring(struct soap *soap, const std::wstring *a)
{   (void)soap; (void)a; /* appease -Wall -Werror */
}
SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__wstring(struct soap *soap, const char *tag, int id, const std::wstring *s, const char *type)
{
    if ((soap->mode & SOAP_C_NILSTRING) && s->empty())
        return soap_element_null(soap, tag, id, type);
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, s, SOAP_TYPE_std__wstring), type) || soap_wstring_out(soap, s->c_str(), 0) || soap_element_end_out(soap, tag))
        return soap->error;
    return SOAP_OK;
}

SOAP_FMAC3 std::wstring * SOAP_FMAC4 soap_in_std__wstring(struct soap *soap, const char *tag, std::wstring *s, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    if (soap_element_begin_in(soap, tag, 1, NULL))
        return NULL;
    if (!s)
        s = soap_new_std__wstring(soap, -1);
    if (soap->null)
        if (s)
            s->erase();
    if (soap->body && !*soap->href)
    {   wchar_t *t;
        s = (std::wstring*)soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_std__wstring, sizeof(std::wstring), soap->type, soap->arrayType);
        if (s)
        {   if (!(t = soap_wstring_in(soap, 1, 0, -1)))
                return NULL;
            s->assign(t);
        }
    }
    else
        s = (std::wstring*)soap_id_forward(soap, soap->href, soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_std__wstring, sizeof(std::wstring), soap->type, soap->arrayType), 0, SOAP_TYPE_std__wstring, 0, sizeof(std::wstring), 0, soap_copy_std__wstring);
    if (soap->body && soap_element_end_in(soap, tag))
        return NULL;
    return s;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_std__wstring(struct soap *soap, const std::wstring *a, const char *tag, const char *type)
{
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_std__wstring);
    if (soap_out_std__wstring(soap, tag?tag:"string", id, a, type))
        return soap->error;
    return soap_putindependent(soap);
}

SOAP_FMAC3 std::wstring * SOAP_FMAC4 soap_get_std__wstring(struct soap *soap, std::wstring *p, const char *tag, const char *type)
{
    if ((p = soap_in_std__wstring(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 std::wstring * SOAP_FMAC2 soap_instantiate_std__wstring(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__wstring(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__wstring, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(std::wstring);
        if (size)
            *size = sizeof(std::wstring);
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(std::wstring, n);
        if (size)
            *size = n * sizeof(std::wstring);
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (std::wstring*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__wstring(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::wstring %p -> %p\n", q, p));
    *(std::wstring*)p = *(std::wstring*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_xsd__QName(struct soap *soap, std::string *p)
{
    (void)soap; /* appease -Wall -Werror */
    p->erase();
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_xsd__QName(struct soap *soap, const std::string *a)
{   (void)soap; (void)a; /* appease -Wall -Werror */
}
SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__QName(struct soap *soap, const char *tag, int id, const std::string *s, const char *type)
{
    if ((soap->mode & SOAP_C_NILSTRING) && s->empty())
        return soap_element_null(soap, tag, id, type);
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, s, SOAP_TYPE_xsd__QName), type) || soap_string_out(soap, s->c_str(), 0) || soap_element_end_out(soap, tag))
        return soap->error;
    return SOAP_OK;
}

SOAP_FMAC1 std::string * SOAP_FMAC2 soap_in_xsd__QName(struct soap *soap, const char *tag, std::string *s, const char *type)
{
    if (soap_element_begin_in(soap, tag, 1, type))
        return NULL;
    if (!s)
        s = soap_new_std__string(soap, -1);
    if (soap->null)
        if (s)
            s->erase();
    if (soap->body && !*soap->href)
    {   char *t;
        s = (std::string*)soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_xsd__QName, sizeof(std::string), soap->type, soap->arrayType);
        if (s)
        {   if (!(t = soap_string_in(soap, 2, 0, -1)))
                return NULL;
            s->assign(t);
        }
    }
    else
        s = (std::string*)soap_id_forward(soap, soap->href, soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_xsd__QName, sizeof(std::string), soap->type, soap->arrayType), 0, SOAP_TYPE_xsd__QName, 0, sizeof(std::string), 0, soap_copy_xsd__QName);
    if (soap->body && soap_element_end_in(soap, tag))
        return NULL;
    return s;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__QName(struct soap *soap, const std::string *a, const char *tag, const char *type)
{
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xsd__QName);
    if (soap_out_xsd__QName(soap, tag?tag:"xsd:QName", id, a, type))
        return soap->error;
    return soap_putindependent(soap);
}

SOAP_FMAC3 std::string * SOAP_FMAC4 soap_get_xsd__QName(struct soap *soap, std::string *p, const char *tag, const char *type)
{
    if ((p = soap_in_xsd__QName(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 std::string * SOAP_FMAC2 soap_instantiate_xsd__QName(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xsd__QName(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xsd__QName, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(std::string);
        if (size)
            *size = sizeof(std::string);
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(std::string, n);
        if (size)
            *size = n * sizeof(std::string);
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (std::string*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xsd__QName(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::string %p -> %p\n", q, p));
    *(std::string*)p = *(std::string*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__string(struct soap *soap, std::string *p)
{
    (void)soap; /* appease -Wall -Werror */
    p->erase();
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__string(struct soap *soap, const std::string *a)
{   (void)soap; (void)a; /* appease -Wall -Werror */
}
SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__string(struct soap *soap, const char *tag, int id, const std::string *s, const char *type)
{
    if ((soap->mode & SOAP_C_NILSTRING) && s->empty())
        return soap_element_null(soap, tag, id, type);
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, s, SOAP_TYPE_std__string), type) || soap_string_out(soap, s->c_str(), 0) || soap_element_end_out(soap, tag))
        return soap->error;
    return SOAP_OK;
}

SOAP_FMAC3 std::string * SOAP_FMAC4 soap_in_std__string(struct soap *soap, const char *tag, std::string *s, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    if (soap_element_begin_in(soap, tag, 1, NULL))
        return NULL;
    if (!s)
        s = soap_new_std__string(soap, -1);
    if (soap->null)
        if (s)
            s->erase();
    if (soap->body && !*soap->href)
    {   char *t;
        s = (std::string*)soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_std__string, sizeof(std::string), soap->type, soap->arrayType);
        if (s)
        {   if (!(t = soap_string_in(soap, 1, 0, -1)))
                return NULL;
            s->assign(t);
        }
    }
    else
        s = (std::string*)soap_id_forward(soap, soap->href, soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_std__string, sizeof(std::string), soap->type, soap->arrayType), 0, SOAP_TYPE_std__string, 0, sizeof(std::string), 0, soap_copy_std__string);
    if (soap->body && soap_element_end_in(soap, tag))
        return NULL;
    return s;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_std__string(struct soap *soap, const std::string *a, const char *tag, const char *type)
{
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_std__string);
    if (soap_out_std__string(soap, tag?tag:"string", id, a, type))
        return soap->error;
    return soap_putindependent(soap);
}

SOAP_FMAC3 std::string * SOAP_FMAC4 soap_get_std__string(struct soap *soap, std::string *p, const char *tag, const char *type)
{
    if ((p = soap_in_std__string(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 std::string * SOAP_FMAC2 soap_instantiate_std__string(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__string(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__string, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(std::string);
        if (size)
            *size = sizeof(std::string);
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(std::string, n);
        if (size)
            *size = n * sizeof(std::string);
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (std::string*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__string(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::string %p -> %p\n", q, p));
    *(std::string*)p = *(std::string*)q;
}

void xsd__anyType::soap_default(struct soap *soap)
{
    this->soap = soap;
    this->xsd__anyType::__item = NULL;
    /* transient soap skipped */
}

void xsd__anyType::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
    (void)soap; /* appease -Wall -Werror */
    /* transient soap skipped */
#endif
}

int xsd__anyType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
    return soap_out_xsd__anyType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__anyType(struct soap *soap, const char *tag, int id, const xsd__anyType *a, const char *type)
{
    return soap_outliteral(soap, tag, &(a->xsd__anyType::__item), NULL);
}

void *xsd__anyType::soap_in(struct soap *soap, const char *tag, const char *type)
{   return soap_in_xsd__anyType(soap, tag, this, type);
}

SOAP_FMAC3 xsd__anyType * SOAP_FMAC4 soap_in_xsd__anyType(struct soap *soap, const char *tag, xsd__anyType *a, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    if (soap_element_begin_in(soap, tag, 1, NULL))
        return NULL;
    if (!(a = (xsd__anyType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_xsd__anyType, sizeof(xsd__anyType), soap->type, soap->arrayType)))
    {   soap->error = SOAP_TAG_MISMATCH;
        return NULL;
    }
    soap_revert(soap);
    *soap->id = '\0';
    if (soap->alloced)
    {   a->soap_default(soap);
        if (soap->clist->type != SOAP_TYPE_xsd__anyType)
            return (xsd__anyType *)a->soap_in(soap, tag, type);
    }
    if (!soap_inliteral(soap, tag, &(a->xsd__anyType::__item)))
        return NULL;
    return a;
}

int xsd__anyType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
    register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_xsd__anyType);
    if (this->soap_out(soap, tag?tag:"xsd:anyType", id, type))
        return soap->error;
    return soap_putindependent(soap);
}

void *xsd__anyType::soap_get(struct soap *soap, const char *tag, const char *type)
{
    return soap_get_xsd__anyType(soap, this, tag, type);
}

SOAP_FMAC3 xsd__anyType * SOAP_FMAC4 soap_get_xsd__anyType(struct soap *soap, xsd__anyType *p, const char *tag, const char *type)
{
    if ((p = soap_in_xsd__anyType(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 xsd__anyType * SOAP_FMAC2 soap_instantiate_xsd__anyType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xsd__anyType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xsd__anyType, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (type && !soap_match_tag(soap, type, "xsd:ID"))
    {   cp->type = SOAP_TYPE_xsd__ID_;
        if (n < 0)
        {   cp->ptr = (void*)SOAP_NEW(xsd__ID_);
            if (size)
                *size = sizeof(xsd__ID_);
            ((xsd__ID_*)cp->ptr)->soap = soap;
        }
        else
        {   cp->ptr = (void*)SOAP_NEW_ARRAY(xsd__ID_, n);
            if (size)
                *size = n * sizeof(xsd__ID_);
            if (cp->ptr)
                for (int i = 0; i < n; i++)
                    ((xsd__ID_*)cp->ptr)[i].soap = soap;
        }
        DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
        if (!cp->ptr)
            soap->error = SOAP_EOM;
        return (xsd__ID_*)cp->ptr;
    }
    if (type && !soap_match_tag(soap, type, "xsd:IDREF"))
    {   cp->type = SOAP_TYPE_xsd__IDREF_;
        if (n < 0)
        {   cp->ptr = (void*)SOAP_NEW(xsd__IDREF_);
            if (size)
                *size = sizeof(xsd__IDREF_);
            ((xsd__IDREF_*)cp->ptr)->soap = soap;
        }
        else
        {   cp->ptr = (void*)SOAP_NEW_ARRAY(xsd__IDREF_, n);
            if (size)
                *size = n * sizeof(xsd__IDREF_);
            if (cp->ptr)
                for (int i = 0; i < n; i++)
                    ((xsd__IDREF_*)cp->ptr)[i].soap = soap;
        }
        DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
        if (!cp->ptr)
            soap->error = SOAP_EOM;
        return (xsd__IDREF_*)cp->ptr;
    }
    if (type && !soap_match_tag(soap, type, "xsd:QName"))
    {   cp->type = SOAP_TYPE_xsd__QName_;
        if (n < 0)
        {   cp->ptr = (void*)SOAP_NEW(xsd__QName_);
            if (size)
                *size = sizeof(xsd__QName_);
            ((xsd__QName_*)cp->ptr)->soap = soap;
        }
        else
        {   cp->ptr = (void*)SOAP_NEW_ARRAY(xsd__QName_, n);
            if (size)
                *size = n * sizeof(xsd__QName_);
            if (cp->ptr)
                for (int i = 0; i < n; i++)
                    ((xsd__QName_*)cp->ptr)[i].soap = soap;
        }
        DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
        if (!cp->ptr)
            soap->error = SOAP_EOM;
        return (xsd__QName_*)cp->ptr;
    }
    if (type && !soap_match_tag(soap, type, "xsd:anyURI"))
    {   cp->type = SOAP_TYPE_xsd__anyURI_;
        if (n < 0)
        {   cp->ptr = (void*)SOAP_NEW(xsd__anyURI_);
            if (size)
                *size = sizeof(xsd__anyURI_);
            ((xsd__anyURI_*)cp->ptr)->soap = soap;
        }
        else
        {   cp->ptr = (void*)SOAP_NEW_ARRAY(xsd__anyURI_, n);
            if (size)
                *size = n * sizeof(xsd__anyURI_);
            if (cp->ptr)
                for (int i = 0; i < n; i++)
                    ((xsd__anyURI_*)cp->ptr)[i].soap = soap;
        }
        DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
        if (!cp->ptr)
            soap->error = SOAP_EOM;
        return (xsd__anyURI_*)cp->ptr;
    }
    if (type && !soap_match_tag(soap, type, "xsd:base64Binary"))
    {   cp->type = SOAP_TYPE_xsd__base64Binary;
        if (n < 0)
        {   cp->ptr = (void*)SOAP_NEW(xsd__base64Binary);
            if (size)
                *size = sizeof(xsd__base64Binary);
            ((xsd__base64Binary*)cp->ptr)->soap = soap;
        }
        else
        {   cp->ptr = (void*)SOAP_NEW_ARRAY(xsd__base64Binary, n);
            if (size)
                *size = n * sizeof(xsd__base64Binary);
            if (cp->ptr)
                for (int i = 0; i < n; i++)
                    ((xsd__base64Binary*)cp->ptr)[i].soap = soap;
        }
        DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
        if (!cp->ptr)
            soap->error = SOAP_EOM;
        return (xsd__base64Binary*)cp->ptr;
    }
    if (type && !soap_match_tag(soap, type, "xsd:boolean"))
    {   cp->type = SOAP_TYPE_xsd__boolean;
        if (n < 0)
        {   cp->ptr = (void*)SOAP_NEW(xsd__boolean);
            if (size)
                *size = sizeof(xsd__boolean);
            ((xsd__boolean*)cp->ptr)->soap = soap;
        }
        else
        {   cp->ptr = (void*)SOAP_NEW_ARRAY(xsd__boolean, n);
            if (size)
                *size = n * sizeof(xsd__boolean);
            if (cp->ptr)
                for (int i = 0; i < n; i++)
                    ((xsd__boolean*)cp->ptr)[i].soap = soap;
        }
        DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
        if (!cp->ptr)
            soap->error = SOAP_EOM;
        return (xsd__boolean*)cp->ptr;
    }
    if (type && !soap_match_tag(soap, type, "xsd:byte"))
    {   cp->type = SOAP_TYPE_xsd__byte_;
        if (n < 0)
        {   cp->ptr = (void*)SOAP_NEW(xsd__byte_);
            if (size)
                *size = sizeof(xsd__byte_);
            ((xsd__byte_*)cp->ptr)->soap = soap;
        }
        else
        {   cp->ptr = (void*)SOAP_NEW_ARRAY(xsd__byte_, n);
            if (size)
                *size = n * sizeof(xsd__byte_);
            if (cp->ptr)
                for (int i = 0; i < n; i++)
                    ((xsd__byte_*)cp->ptr)[i].soap = soap;
        }
        DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
        if (!cp->ptr)
            soap->error = SOAP_EOM;
        return (xsd__byte_*)cp->ptr;
    }
    if (type && !soap_match_tag(soap, type, "xsd:dateTime"))
    {   cp->type = SOAP_TYPE_xsd__dateTime;
        if (n < 0)
        {   cp->ptr = (void*)SOAP_NEW(xsd__dateTime);
            if (size)
                *size = sizeof(xsd__dateTime);
            ((xsd__dateTime*)cp->ptr)->soap = soap;
        }
        else
        {   cp->ptr = (void*)SOAP_NEW_ARRAY(xsd__dateTime, n);
            if (size)
                *size = n * sizeof(xsd__dateTime);
            if (cp->ptr)
                for (int i = 0; i < n; i++)
                    ((xsd__dateTime*)cp->ptr)[i].soap = soap;
        }
        DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
        if (!cp->ptr)
            soap->error = SOAP_EOM;
        return (xsd__dateTime*)cp->ptr;
    }
    if (type && !soap_match_tag(soap, type, "xsd:decimal"))
    {   cp->type = SOAP_TYPE_xsd__decimal_;
        if (n < 0)
        {   cp->ptr = (void*)SOAP_NEW(xsd__decimal_);
            if (size)
                *size = sizeof(xsd__decimal_);
            ((xsd__decimal_*)cp->ptr)->soap = soap;
        }
        else
        {   cp->ptr = (void*)SOAP_NEW_ARRAY(xsd__decimal_, n);
            if (size)
                *size = n * sizeof(xsd__decimal_);
            if (cp->ptr)
                for (int i = 0; i < n; i++)
                    ((xsd__decimal_*)cp->ptr)[i].soap = soap;
        }
        DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
        if (!cp->ptr)
            soap->error = SOAP_EOM;
        return (xsd__decimal_*)cp->ptr;
    }
    if (type && !soap_match_tag(soap, type, "xsd:double"))
    {   cp->type = SOAP_TYPE_xsd__double;
        if (n < 0)
        {   cp->ptr = (void*)SOAP_NEW(xsd__double);
            if (size)
                *size = sizeof(xsd__double);
            ((xsd__double*)cp->ptr)->soap = soap;
        }
        else
        {   cp->ptr = (void*)SOAP_NEW_ARRAY(xsd__double, n);
            if (size)
                *size = n * sizeof(xsd__double);
            if (cp->ptr)
                for (int i = 0; i < n; i++)
                    ((xsd__double*)cp->ptr)[i].soap = soap;
        }
        DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
        if (!cp->ptr)
            soap->error = SOAP_EOM;
        return (xsd__double*)cp->ptr;
    }
    if (type && !soap_match_tag(soap, type, "xsd:duration"))
    {   cp->type = SOAP_TYPE_xsd__duration_;
        if (n < 0)
        {   cp->ptr = (void*)SOAP_NEW(xsd__duration_);
            if (size)
                *size = sizeof(xsd__duration_);
            ((xsd__duration_*)cp->ptr)->soap = soap;
        }
        else
        {   cp->ptr = (void*)SOAP_NEW_ARRAY(xsd__duration_, n);
            if (size)
                *size = n * sizeof(xsd__duration_);
            if (cp->ptr)
                for (int i = 0; i < n; i++)
                    ((xsd__duration_*)cp->ptr)[i].soap = soap;
        }
        DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
        if (!cp->ptr)
            soap->error = SOAP_EOM;
        return (xsd__duration_*)cp->ptr;
    }
    if (type && !soap_match_tag(soap, type, "xsd:float"))
    {   cp->type = SOAP_TYPE_xsd__float;
        if (n < 0)
        {   cp->ptr = (void*)SOAP_NEW(xsd__float);
            if (size)
                *size = sizeof(xsd__float);
            ((xsd__float*)cp->ptr)->soap = soap;
        }
        else
        {   cp->ptr = (void*)SOAP_NEW_ARRAY(xsd__float, n);
            if (size)
                *size = n * sizeof(xsd__float);
            if (cp->ptr)
                for (int i = 0; i < n; i++)
                    ((xsd__float*)cp->ptr)[i].soap = soap;
        }
        DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
        if (!cp->ptr)
            soap->error = SOAP_EOM;
        return (xsd__float*)cp->ptr;
    }
    if (type && !soap_match_tag(soap, type, "xsd:int"))
    {   cp->type = SOAP_TYPE_xsd__int;
        if (n < 0)
        {   cp->ptr = (void*)SOAP_NEW(xsd__int);
            if (size)
                *size = sizeof(xsd__int);
            ((xsd__int*)cp->ptr)->soap = soap;
        }
        else
        {   cp->ptr = (void*)SOAP_NEW_ARRAY(xsd__int, n);
            if (size)
                *size = n * sizeof(xsd__int);
            if (cp->ptr)
                for (int i = 0; i < n; i++)
                    ((xsd__int*)cp->ptr)[i].soap = soap;
        }
        DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
        if (!cp->ptr)
            soap->error = SOAP_EOM;
        return (xsd__int*)cp->ptr;
    }
    if (type && !soap_match_tag(soap, type, "xsd:long"))
    {   cp->type = SOAP_TYPE_xsd__long;
        if (n < 0)
        {   cp->ptr = (void*)SOAP_NEW(xsd__long);
            if (size)
                *size = sizeof(xsd__long);
            ((xsd__long*)cp->ptr)->soap = soap;
        }
        else
        {   cp->ptr = (void*)SOAP_NEW_ARRAY(xsd__long, n);
            if (size)
                *size = n * sizeof(xsd__long);
            if (cp->ptr)
                for (int i = 0; i < n; i++)
                    ((xsd__long*)cp->ptr)[i].soap = soap;
        }
        DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
        if (!cp->ptr)
            soap->error = SOAP_EOM;
        return (xsd__long*)cp->ptr;
    }
    if (type && !soap_match_tag(soap, type, "xsd:short"))
    {   cp->type = SOAP_TYPE_xsd__short;
        if (n < 0)
        {   cp->ptr = (void*)SOAP_NEW(xsd__short);
            if (size)
                *size = sizeof(xsd__short);
            ((xsd__short*)cp->ptr)->soap = soap;
        }
        else
        {   cp->ptr = (void*)SOAP_NEW_ARRAY(xsd__short, n);
            if (size)
                *size = n * sizeof(xsd__short);
            if (cp->ptr)
                for (int i = 0; i < n; i++)
                    ((xsd__short*)cp->ptr)[i].soap = soap;
        }
        DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
        if (!cp->ptr)
            soap->error = SOAP_EOM;
        return (xsd__short*)cp->ptr;
    }
    if (type && !soap_match_tag(soap, type, "xsd:string"))
    {   cp->type = SOAP_TYPE_xsd__string;
        if (n < 0)
        {   cp->ptr = (void*)SOAP_NEW(xsd__string);
            if (size)
                *size = sizeof(xsd__string);
            ((xsd__string*)cp->ptr)->soap = soap;
        }
        else
        {   cp->ptr = (void*)SOAP_NEW_ARRAY(xsd__string, n);
            if (size)
                *size = n * sizeof(xsd__string);
            if (cp->ptr)
                for (int i = 0; i < n; i++)
                    ((xsd__string*)cp->ptr)[i].soap = soap;
        }
        DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
        if (!cp->ptr)
            soap->error = SOAP_EOM;
        return (xsd__string*)cp->ptr;
    }
    if (type && !soap_match_tag(soap, type, "xsd:unsignedByte"))
    {   cp->type = SOAP_TYPE_xsd__unsignedByte_;
        if (n < 0)
        {   cp->ptr = (void*)SOAP_NEW(xsd__unsignedByte_);
            if (size)
                *size = sizeof(xsd__unsignedByte_);
            ((xsd__unsignedByte_*)cp->ptr)->soap = soap;
        }
        else
        {   cp->ptr = (void*)SOAP_NEW_ARRAY(xsd__unsignedByte_, n);
            if (size)
                *size = n * sizeof(xsd__unsignedByte_);
            if (cp->ptr)
                for (int i = 0; i < n; i++)
                    ((xsd__unsignedByte_*)cp->ptr)[i].soap = soap;
        }
        DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
        if (!cp->ptr)
            soap->error = SOAP_EOM;
        return (xsd__unsignedByte_*)cp->ptr;
    }
    if (type && !soap_match_tag(soap, type, "xsd:unsignedInt"))
    {   cp->type = SOAP_TYPE_xsd__unsignedInt;
        if (n < 0)
        {   cp->ptr = (void*)SOAP_NEW(xsd__unsignedInt);
            if (size)
                *size = sizeof(xsd__unsignedInt);
            ((xsd__unsignedInt*)cp->ptr)->soap = soap;
        }
        else
        {   cp->ptr = (void*)SOAP_NEW_ARRAY(xsd__unsignedInt, n);
            if (size)
                *size = n * sizeof(xsd__unsignedInt);
            if (cp->ptr)
                for (int i = 0; i < n; i++)
                    ((xsd__unsignedInt*)cp->ptr)[i].soap = soap;
        }
        DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
        if (!cp->ptr)
            soap->error = SOAP_EOM;
        return (xsd__unsignedInt*)cp->ptr;
    }
    if (type && !soap_match_tag(soap, type, "xsd:unsignedLong"))
    {   cp->type = SOAP_TYPE_xsd__unsignedLong;
        if (n < 0)
        {   cp->ptr = (void*)SOAP_NEW(xsd__unsignedLong);
            if (size)
                *size = sizeof(xsd__unsignedLong);
            ((xsd__unsignedLong*)cp->ptr)->soap = soap;
        }
        else
        {   cp->ptr = (void*)SOAP_NEW_ARRAY(xsd__unsignedLong, n);
            if (size)
                *size = n * sizeof(xsd__unsignedLong);
            if (cp->ptr)
                for (int i = 0; i < n; i++)
                    ((xsd__unsignedLong*)cp->ptr)[i].soap = soap;
        }
        DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
        if (!cp->ptr)
            soap->error = SOAP_EOM;
        return (xsd__unsignedLong*)cp->ptr;
    }
    if (type && !soap_match_tag(soap, type, "xsd:unsignedShort"))
    {   cp->type = SOAP_TYPE_xsd__unsignedShort;
        if (n < 0)
        {   cp->ptr = (void*)SOAP_NEW(xsd__unsignedShort);
            if (size)
                *size = sizeof(xsd__unsignedShort);
            ((xsd__unsignedShort*)cp->ptr)->soap = soap;
        }
        else
        {   cp->ptr = (void*)SOAP_NEW_ARRAY(xsd__unsignedShort, n);
            if (size)
                *size = n * sizeof(xsd__unsignedShort);
            if (cp->ptr)
                for (int i = 0; i < n; i++)
                    ((xsd__unsignedShort*)cp->ptr)[i].soap = soap;
        }
        DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
        if (!cp->ptr)
            soap->error = SOAP_EOM;
        return (xsd__unsignedShort*)cp->ptr;
    }
    if (type && !soap_match_tag(soap, type, "ns3:char"))
    {   cp->type = SOAP_TYPE_ns3__char__;
        if (n < 0)
        {   cp->ptr = (void*)SOAP_NEW(ns3__char__);
            if (size)
                *size = sizeof(ns3__char__);
            ((ns3__char__*)cp->ptr)->soap = soap;
        }
        else
        {   cp->ptr = (void*)SOAP_NEW_ARRAY(ns3__char__, n);
            if (size)
                *size = n * sizeof(ns3__char__);
            if (cp->ptr)
                for (int i = 0; i < n; i++)
                    ((ns3__char__*)cp->ptr)[i].soap = soap;
        }
        DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
        if (!cp->ptr)
            soap->error = SOAP_EOM;
        return (ns3__char__*)cp->ptr;
    }
    if (type && !soap_match_tag(soap, type, "ns3:duration"))
    {   cp->type = SOAP_TYPE_ns3__duration__;
        if (n < 0)
        {   cp->ptr = (void*)SOAP_NEW(ns3__duration__);
            if (size)
                *size = sizeof(ns3__duration__);
            ((ns3__duration__*)cp->ptr)->soap = soap;
        }
        else
        {   cp->ptr = (void*)SOAP_NEW_ARRAY(ns3__duration__, n);
            if (size)
                *size = n * sizeof(ns3__duration__);
            if (cp->ptr)
                for (int i = 0; i < n; i++)
                    ((ns3__duration__*)cp->ptr)[i].soap = soap;
        }
        DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
        if (!cp->ptr)
            soap->error = SOAP_EOM;
        return (ns3__duration__*)cp->ptr;
    }
    if (type && !soap_match_tag(soap, type, "ns3:guid"))
    {   cp->type = SOAP_TYPE_ns3__guid__;
        if (n < 0)
        {   cp->ptr = (void*)SOAP_NEW(ns3__guid__);
            if (size)
                *size = sizeof(ns3__guid__);
            ((ns3__guid__*)cp->ptr)->soap = soap;
        }
        else
        {   cp->ptr = (void*)SOAP_NEW_ARRAY(ns3__guid__, n);
            if (size)
                *size = n * sizeof(ns3__guid__);
            if (cp->ptr)
                for (int i = 0; i < n; i++)
                    ((ns3__guid__*)cp->ptr)[i].soap = soap;
        }
        DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
        if (!cp->ptr)
            soap->error = SOAP_EOM;
        return (ns3__guid__*)cp->ptr;
    }
    if (type && !soap_match_tag(soap, type, "ns4:ClientLib.Architecture"))
    {   cp->type = SOAP_TYPE_ns4__ClientLib_Architecture_;
        if (n < 0)
        {   cp->ptr = (void*)SOAP_NEW(ns4__ClientLib_Architecture_);
            if (size)
                *size = sizeof(ns4__ClientLib_Architecture_);
            ((ns4__ClientLib_Architecture_*)cp->ptr)->soap = soap;
        }
        else
        {   cp->ptr = (void*)SOAP_NEW_ARRAY(ns4__ClientLib_Architecture_, n);
            if (size)
                *size = n * sizeof(ns4__ClientLib_Architecture_);
            if (cp->ptr)
                for (int i = 0; i < n; i++)
                    ((ns4__ClientLib_Architecture_*)cp->ptr)[i].soap = soap;
        }
        DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
        if (!cp->ptr)
            soap->error = SOAP_EOM;
        return (ns4__ClientLib_Architecture_*)cp->ptr;
    }
    if (type && !soap_match_tag(soap, type, "ns4:ClientLib.ClientType"))
    {   cp->type = SOAP_TYPE_ns4__ClientLib_ClientType_;
        if (n < 0)
        {   cp->ptr = (void*)SOAP_NEW(ns4__ClientLib_ClientType_);
            if (size)
                *size = sizeof(ns4__ClientLib_ClientType_);
            ((ns4__ClientLib_ClientType_*)cp->ptr)->soap = soap;
        }
        else
        {   cp->ptr = (void*)SOAP_NEW_ARRAY(ns4__ClientLib_ClientType_, n);
            if (size)
                *size = n * sizeof(ns4__ClientLib_ClientType_);
            if (cp->ptr)
                for (int i = 0; i < n; i++)
                    ((ns4__ClientLib_ClientType_*)cp->ptr)[i].soap = soap;
        }
        DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
        if (!cp->ptr)
            soap->error = SOAP_EOM;
        return (ns4__ClientLib_ClientType_*)cp->ptr;
    }
    if (type && !soap_match_tag(soap, type, "ns4:HaveSolutionResponse.SolutionType"))
    {   cp->type = SOAP_TYPE_ns4__HaveSolutionResponse_SolutionType_;
        if (n < 0)
        {   cp->ptr = (void*)SOAP_NEW(ns4__HaveSolutionResponse_SolutionType_);
            if (size)
                *size = sizeof(ns4__HaveSolutionResponse_SolutionType_);
            ((ns4__HaveSolutionResponse_SolutionType_*)cp->ptr)->soap = soap;
        }
        else
        {   cp->ptr = (void*)SOAP_NEW_ARRAY(ns4__HaveSolutionResponse_SolutionType_, n);
            if (size)
                *size = n * sizeof(ns4__HaveSolutionResponse_SolutionType_);
            if (cp->ptr)
                for (int i = 0; i < n; i++)
                    ((ns4__HaveSolutionResponse_SolutionType_*)cp->ptr)[i].soap = soap;
        }
        DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
        if (!cp->ptr)
            soap->error = SOAP_EOM;
        return (ns4__HaveSolutionResponse_SolutionType_*)cp->ptr;
    }
    if (type && !soap_match_tag(soap, type, "ns1:ClientLib"))
    {   cp->type = SOAP_TYPE_ns1__ClientLib;
        if (n < 0)
        {   cp->ptr = (void*)SOAP_NEW(ns1__ClientLib);
            if (size)
                *size = sizeof(ns1__ClientLib);
            ((ns1__ClientLib*)cp->ptr)->soap = soap;
        }
        else
        {   cp->ptr = (void*)SOAP_NEW_ARRAY(ns1__ClientLib, n);
            if (size)
                *size = n * sizeof(ns1__ClientLib);
            if (cp->ptr)
                for (int i = 0; i < n; i++)
                    ((ns1__ClientLib*)cp->ptr)[i].soap = soap;
        }
        DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
        if (!cp->ptr)
            soap->error = SOAP_EOM;
        return (ns1__ClientLib*)cp->ptr;
    }
    if (type && !soap_match_tag(soap, type, "ns1:Application"))
    {   cp->type = SOAP_TYPE_ns1__Application;
        if (n < 0)
        {   cp->ptr = (void*)SOAP_NEW(ns1__Application);
            if (size)
                *size = sizeof(ns1__Application);
            ((ns1__Application*)cp->ptr)->soap = soap;
        }
        else
        {   cp->ptr = (void*)SOAP_NEW_ARRAY(ns1__Application, n);
            if (size)
                *size = n * sizeof(ns1__Application);
            if (cp->ptr)
                for (int i = 0; i < n; i++)
                    ((ns1__Application*)cp->ptr)[i].soap = soap;
        }
        DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
        if (!cp->ptr)
            soap->error = SOAP_EOM;
        return (ns1__Application*)cp->ptr;
    }
    if (type && !soap_match_tag(soap, type, "ns1:AppAdditionalInfo"))
    {   cp->type = SOAP_TYPE_ns1__AppAdditionalInfo;
        if (n < 0)
        {   cp->ptr = (void*)SOAP_NEW(ns1__AppAdditionalInfo);
            if (size)
                *size = sizeof(ns1__AppAdditionalInfo);
            ((ns1__AppAdditionalInfo*)cp->ptr)->soap = soap;
        }
        else
        {   cp->ptr = (void*)SOAP_NEW_ARRAY(ns1__AppAdditionalInfo, n);
            if (size)
                *size = n * sizeof(ns1__AppAdditionalInfo);
            if (cp->ptr)
                for (int i = 0; i < n; i++)
                    ((ns1__AppAdditionalInfo*)cp->ptr)[i].soap = soap;
        }
        DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
        if (!cp->ptr)
            soap->error = SOAP_EOM;
        return (ns1__AppAdditionalInfo*)cp->ptr;
    }
    if (type && !soap_match_tag(soap, type, "ns1:DumpAdditionalInfo"))
    {   cp->type = SOAP_TYPE_ns1__DumpAdditionalInfo;
        if (n < 0)
        {   cp->ptr = (void*)SOAP_NEW(ns1__DumpAdditionalInfo);
            if (size)
                *size = sizeof(ns1__DumpAdditionalInfo);
            ((ns1__DumpAdditionalInfo*)cp->ptr)->soap = soap;
        }
        else
        {   cp->ptr = (void*)SOAP_NEW_ARRAY(ns1__DumpAdditionalInfo, n);
            if (size)
                *size = n * sizeof(ns1__DumpAdditionalInfo);
            if (cp->ptr)
                for (int i = 0; i < n; i++)
                    ((ns1__DumpAdditionalInfo*)cp->ptr)[i].soap = soap;
        }
        DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
        if (!cp->ptr)
            soap->error = SOAP_EOM;
        return (ns1__DumpAdditionalInfo*)cp->ptr;
    }
    if (type && !soap_match_tag(soap, type, "ns1:ArrayOfModuleSymbolInfo"))
    {   cp->type = SOAP_TYPE_ns1__ArrayOfModuleSymbolInfo;
        if (n < 0)
        {   cp->ptr = (void*)SOAP_NEW(ns1__ArrayOfModuleSymbolInfo);
            if (size)
                *size = sizeof(ns1__ArrayOfModuleSymbolInfo);
            ((ns1__ArrayOfModuleSymbolInfo*)cp->ptr)->soap = soap;
        }
        else
        {   cp->ptr = (void*)SOAP_NEW_ARRAY(ns1__ArrayOfModuleSymbolInfo, n);
            if (size)
                *size = n * sizeof(ns1__ArrayOfModuleSymbolInfo);
            if (cp->ptr)
                for (int i = 0; i < n; i++)
                    ((ns1__ArrayOfModuleSymbolInfo*)cp->ptr)[i].soap = soap;
        }
        DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
        if (!cp->ptr)
            soap->error = SOAP_EOM;
        return (ns1__ArrayOfModuleSymbolInfo*)cp->ptr;
    }
    if (type && !soap_match_tag(soap, type, "ns1:ModuleSymbolInfo"))
    {   cp->type = SOAP_TYPE_ns1__ModuleSymbolInfo;
        if (n < 0)
        {   cp->ptr = (void*)SOAP_NEW(ns1__ModuleSymbolInfo);
            if (size)
                *size = sizeof(ns1__ModuleSymbolInfo);
            ((ns1__ModuleSymbolInfo*)cp->ptr)->soap = soap;
        }
        else
        {   cp->ptr = (void*)SOAP_NEW_ARRAY(ns1__ModuleSymbolInfo, n);
            if (size)
                *size = n * sizeof(ns1__ModuleSymbolInfo);
            if (cp->ptr)
                for (int i = 0; i < n; i++)
                    ((ns1__ModuleSymbolInfo*)cp->ptr)[i].soap = soap;
        }
        DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
        if (!cp->ptr)
            soap->error = SOAP_EOM;
        return (ns1__ModuleSymbolInfo*)cp->ptr;
    }
    if (type && !soap_match_tag(soap, type, "ns1:Pdb70File"))
    {   cp->type = SOAP_TYPE_ns1__Pdb70File;
        if (n < 0)
        {   cp->ptr = (void*)SOAP_NEW(ns1__Pdb70File);
            if (size)
                *size = sizeof(ns1__Pdb70File);
            ((ns1__Pdb70File*)cp->ptr)->soap = soap;
        }
        else
        {   cp->ptr = (void*)SOAP_NEW_ARRAY(ns1__Pdb70File, n);
            if (size)
                *size = n * sizeof(ns1__Pdb70File);
            if (cp->ptr)
                for (int i = 0; i < n; i++)
                    ((ns1__Pdb70File*)cp->ptr)[i].soap = soap;
        }
        DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
        if (!cp->ptr)
            soap->error = SOAP_EOM;
        return (ns1__Pdb70File*)cp->ptr;
    }
    if (type && !soap_match_tag(soap, type, "ns1:Response"))
    {   cp->type = SOAP_TYPE_ns1__Response;
        if (n < 0)
        {   cp->ptr = (void*)SOAP_NEW(ns1__Response);
            if (size)
                *size = sizeof(ns1__Response);
            ((ns1__Response*)cp->ptr)->soap = soap;
        }
        else
        {   cp->ptr = (void*)SOAP_NEW_ARRAY(ns1__Response, n);
            if (size)
                *size = n * sizeof(ns1__Response);
            if (cp->ptr)
                for (int i = 0; i < n; i++)
                    ((ns1__Response*)cp->ptr)[i].soap = soap;
        }
        DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
        if (!cp->ptr)
            soap->error = SOAP_EOM;
        return (ns1__Response*)cp->ptr;
    }
    if (type && !soap_match_tag(soap, type, "ns5:ArrayOfstring"))
    {   cp->type = SOAP_TYPE_ns5__ArrayOfstring;
        if (n < 0)
        {   cp->ptr = (void*)SOAP_NEW(ns5__ArrayOfstring);
            if (size)
                *size = sizeof(ns5__ArrayOfstring);
            ((ns5__ArrayOfstring*)cp->ptr)->soap = soap;
        }
        else
        {   cp->ptr = (void*)SOAP_NEW_ARRAY(ns5__ArrayOfstring, n);
            if (size)
                *size = n * sizeof(ns5__ArrayOfstring);
            if (cp->ptr)
                for (int i = 0; i < n; i++)
                    ((ns5__ArrayOfstring*)cp->ptr)[i].soap = soap;
        }
        DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
        if (!cp->ptr)
            soap->error = SOAP_EOM;
        return (ns5__ArrayOfstring*)cp->ptr;
    }
    if (type && !soap_match_tag(soap, type, "ns1:StopResponse"))
    {   cp->type = SOAP_TYPE_ns1__StopResponse;
        if (n < 0)
        {   cp->ptr = (void*)SOAP_NEW(ns1__StopResponse);
            if (size)
                *size = sizeof(ns1__StopResponse);
            ((ns1__StopResponse*)cp->ptr)->soap = soap;
        }
        else
        {   cp->ptr = (void*)SOAP_NEW_ARRAY(ns1__StopResponse, n);
            if (size)
                *size = n * sizeof(ns1__StopResponse);
            if (cp->ptr)
                for (int i = 0; i < n; i++)
                    ((ns1__StopResponse*)cp->ptr)[i].soap = soap;
        }
        DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
        if (!cp->ptr)
            soap->error = SOAP_EOM;
        return (ns1__StopResponse*)cp->ptr;
    }
    if (type && !soap_match_tag(soap, type, "ns1:ErrorResponse"))
    {   cp->type = SOAP_TYPE_ns1__ErrorResponse;
        if (n < 0)
        {   cp->ptr = (void*)SOAP_NEW(ns1__ErrorResponse);
            if (size)
                *size = sizeof(ns1__ErrorResponse);
            ((ns1__ErrorResponse*)cp->ptr)->soap = soap;
        }
        else
        {   cp->ptr = (void*)SOAP_NEW_ARRAY(ns1__ErrorResponse, n);
            if (size)
                *size = n * sizeof(ns1__ErrorResponse);
            if (cp->ptr)
                for (int i = 0; i < n; i++)
                    ((ns1__ErrorResponse*)cp->ptr)[i].soap = soap;
        }
        DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
        if (!cp->ptr)
            soap->error = SOAP_EOM;
        return (ns1__ErrorResponse*)cp->ptr;
    }
    if (type && !soap_match_tag(soap, type, "ns1:HaveSolutionResponse"))
    {   cp->type = SOAP_TYPE_ns1__HaveSolutionResponse;
        if (n < 0)
        {   cp->ptr = (void*)SOAP_NEW(ns1__HaveSolutionResponse);
            if (size)
                *size = sizeof(ns1__HaveSolutionResponse);
            ((ns1__HaveSolutionResponse*)cp->ptr)->soap = soap;
        }
        else
        {   cp->ptr = (void*)SOAP_NEW_ARRAY(ns1__HaveSolutionResponse, n);
            if (size)
                *size = n * sizeof(ns1__HaveSolutionResponse);
            if (cp->ptr)
                for (int i = 0; i < n; i++)
                    ((ns1__HaveSolutionResponse*)cp->ptr)[i].soap = soap;
        }
        DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
        if (!cp->ptr)
            soap->error = SOAP_EOM;
        return (ns1__HaveSolutionResponse*)cp->ptr;
    }
    if (type && !soap_match_tag(soap, type, "ns1:NeedSymbolsThenMiniDumpResponse"))
    {   cp->type = SOAP_TYPE_ns1__NeedSymbolsThenMiniDumpResponse;
        if (n < 0)
        {   cp->ptr = (void*)SOAP_NEW(ns1__NeedSymbolsThenMiniDumpResponse);
            if (size)
                *size = sizeof(ns1__NeedSymbolsThenMiniDumpResponse);
            ((ns1__NeedSymbolsThenMiniDumpResponse*)cp->ptr)->soap = soap;
        }
        else
        {   cp->ptr = (void*)SOAP_NEW_ARRAY(ns1__NeedSymbolsThenMiniDumpResponse, n);
            if (size)
                *size = n * sizeof(ns1__NeedSymbolsThenMiniDumpResponse);
            if (cp->ptr)
                for (int i = 0; i < n; i++)
                    ((ns1__NeedSymbolsThenMiniDumpResponse*)cp->ptr)[i].soap = soap;
        }
        DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
        if (!cp->ptr)
            soap->error = SOAP_EOM;
        return (ns1__NeedSymbolsThenMiniDumpResponse*)cp->ptr;
    }
    if (type && !soap_match_tag(soap, type, "ns1:NeedMiniDumpResponse"))
    {   cp->type = SOAP_TYPE_ns1__NeedMiniDumpResponse;
        if (n < 0)
        {   cp->ptr = (void*)SOAP_NEW(ns1__NeedMiniDumpResponse);
            if (size)
                *size = sizeof(ns1__NeedMiniDumpResponse);
            ((ns1__NeedMiniDumpResponse*)cp->ptr)->soap = soap;
        }
        else
        {   cp->ptr = (void*)SOAP_NEW_ARRAY(ns1__NeedMiniDumpResponse, n);
            if (size)
                *size = n * sizeof(ns1__NeedMiniDumpResponse);
            if (cp->ptr)
                for (int i = 0; i < n; i++)
                    ((ns1__NeedMiniDumpResponse*)cp->ptr)[i].soap = soap;
        }
        DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
        if (!cp->ptr)
            soap->error = SOAP_EOM;
        return (ns1__NeedMiniDumpResponse*)cp->ptr;
    }
    if (type && !soap_match_tag(soap, type, "ns1:NeedFullDumpResponse"))
    {   cp->type = SOAP_TYPE_ns1__NeedFullDumpResponse;
        if (n < 0)
        {   cp->ptr = (void*)SOAP_NEW(ns1__NeedFullDumpResponse);
            if (size)
                *size = sizeof(ns1__NeedFullDumpResponse);
            ((ns1__NeedFullDumpResponse*)cp->ptr)->soap = soap;
        }
        else
        {   cp->ptr = (void*)SOAP_NEW_ARRAY(ns1__NeedFullDumpResponse, n);
            if (size)
                *size = n * sizeof(ns1__NeedFullDumpResponse);
            if (cp->ptr)
                for (int i = 0; i < n; i++)
                    ((ns1__NeedFullDumpResponse*)cp->ptr)[i].soap = soap;
        }
        DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
        if (!cp->ptr)
            soap->error = SOAP_EOM;
        return (ns1__NeedFullDumpResponse*)cp->ptr;
    }
    if (type && !soap_match_tag(soap, type, "ns1:NeedMoreInfoResponse"))
    {   cp->type = SOAP_TYPE_ns1__NeedMoreInfoResponse;
        if (n < 0)
        {   cp->ptr = (void*)SOAP_NEW(ns1__NeedMoreInfoResponse);
            if (size)
                *size = sizeof(ns1__NeedMoreInfoResponse);
            ((ns1__NeedMoreInfoResponse*)cp->ptr)->soap = soap;
        }
        else
        {   cp->ptr = (void*)SOAP_NEW_ARRAY(ns1__NeedMoreInfoResponse, n);
            if (size)
                *size = n * sizeof(ns1__NeedMoreInfoResponse);
            if (cp->ptr)
                for (int i = 0; i < n; i++)
                    ((ns1__NeedMoreInfoResponse*)cp->ptr)[i].soap = soap;
        }
        DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
        if (!cp->ptr)
            soap->error = SOAP_EOM;
        return (ns1__NeedMoreInfoResponse*)cp->ptr;
    }
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(xsd__anyType);
        if (size)
            *size = sizeof(xsd__anyType);
        ((xsd__anyType*)cp->ptr)->soap = soap;
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(xsd__anyType, n);
        if (size)
            *size = n * sizeof(xsd__anyType);
        if (cp->ptr)
            for (int i = 0; i < n; i++)
                ((xsd__anyType*)cp->ptr)[i].soap = soap;
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (xsd__anyType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xsd__anyType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying xsd__anyType %p -> %p\n", q, p));
    *(xsd__anyType*)p = *(xsd__anyType*)q;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *a)
{
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default__QName(soap, &a->faultcode);
    soap_default_string(soap, &a->faultstring);
    soap_default_string(soap, &a->faultactor);
    a->detail = NULL;
    a->SOAP_ENV__Code = NULL;
    a->SOAP_ENV__Reason = NULL;
    soap_default_string(soap, &a->SOAP_ENV__Node);
    soap_default_string(soap, &a->SOAP_ENV__Role);
    a->SOAP_ENV__Detail = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a)
{
#ifndef WITH_NOIDREF
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize__QName(soap, &a->faultcode);
    soap_serialize_string(soap, &a->faultstring);
    soap_serialize_string(soap, &a->faultactor);
    soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->detail);
    soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Code);
    soap_serialize_PointerToSOAP_ENV__Reason(soap, &a->SOAP_ENV__Reason);
    soap_serialize_string(soap, &a->SOAP_ENV__Node);
    soap_serialize_string(soap, &a->SOAP_ENV__Role);
    soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->SOAP_ENV__Detail);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Fault(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Fault *a, const char *type)
{
    const char *soap_tmp_faultcode = soap_QName2s(soap, a->faultcode);
    (void)soap; (void)tag; (void)id; (void)type;
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Fault), type))
        return soap->error;
    if (soap_out__QName(soap, "faultcode", -1, (char*const*)&soap_tmp_faultcode, ""))
        return soap->error;
    if (soap_out_string(soap, "faultstring", -1, &a->faultstring, ""))
        return soap->error;
    if (soap_out_string(soap, "faultactor", -1, &a->faultactor, ""))
        return soap->error;
    if (soap_out_PointerToSOAP_ENV__Detail(soap, "detail", -1, &a->detail, ""))
        return soap->error;
    if (soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", -1, &a->SOAP_ENV__Code, ""))
        return soap->error;
    if (soap_out_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", -1, &a->SOAP_ENV__Reason, ""))
        return soap->error;
    if (soap_out_string(soap, "SOAP-ENV:Node", -1, &a->SOAP_ENV__Node, ""))
        return soap->error;
    if (soap_out_string(soap, "SOAP-ENV:Role", -1, &a->SOAP_ENV__Role, ""))
        return soap->error;
    if (soap_out_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", -1, &a->SOAP_ENV__Detail, ""))
        return soap->error;
    return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_in_SOAP_ENV__Fault(struct soap *soap, const char *tag, struct SOAP_ENV__Fault *a, const char *type)
{
    size_t soap_flag_faultcode = 1;
    size_t soap_flag_faultstring = 1;
    size_t soap_flag_faultactor = 1;
    size_t soap_flag_detail = 1;
    size_t soap_flag_SOAP_ENV__Code = 1;
    size_t soap_flag_SOAP_ENV__Reason = 1;
    size_t soap_flag_SOAP_ENV__Node = 1;
    size_t soap_flag_SOAP_ENV__Role = 1;
    size_t soap_flag_SOAP_ENV__Detail = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
        return NULL;
    a = (struct SOAP_ENV__Fault *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Fault, sizeof(struct SOAP_ENV__Fault), 0, NULL, NULL, NULL);
    if (!a)
        return NULL;
    soap_default_SOAP_ENV__Fault(soap, a);
    if (soap->body && !*soap->href)
    {
        for (;;)
        {   soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_faultcode && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
                if (soap_in__QName(soap, "faultcode", &a->faultcode, ""))
                {   soap_flag_faultcode--;
                    continue;
                }
            if (soap_flag_faultstring && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
                if (soap_in_string(soap, "faultstring", &a->faultstring, "xsd:string"))
                {   soap_flag_faultstring--;
                    continue;
                }
            if (soap_flag_faultactor && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
                if (soap_in_string(soap, "faultactor", &a->faultactor, "xsd:string"))
                {   soap_flag_faultactor--;
                    continue;
                }
            if (soap_flag_detail && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerToSOAP_ENV__Detail(soap, "detail", &a->detail, ""))
                {   soap_flag_detail--;
                    continue;
                }
            if (soap_flag_SOAP_ENV__Code && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", &a->SOAP_ENV__Code, ""))
                {   soap_flag_SOAP_ENV__Code--;
                    continue;
                }
            if (soap_flag_SOAP_ENV__Reason && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", &a->SOAP_ENV__Reason, ""))
                {   soap_flag_SOAP_ENV__Reason--;
                    continue;
                }
            if (soap_flag_SOAP_ENV__Node && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
                if (soap_in_string(soap, "SOAP-ENV:Node", &a->SOAP_ENV__Node, "xsd:string"))
                {   soap_flag_SOAP_ENV__Node--;
                    continue;
                }
            if (soap_flag_SOAP_ENV__Role && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
                if (soap_in_string(soap, "SOAP-ENV:Role", &a->SOAP_ENV__Role, "xsd:string"))
                {   soap_flag_SOAP_ENV__Role--;
                    continue;
                }
            if (soap_flag_SOAP_ENV__Detail && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", &a->SOAP_ENV__Detail, ""))
                {   soap_flag_SOAP_ENV__Detail--;
                    continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
                soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
                break;
            if (soap->error)
                return NULL;
        }
        if (soap_element_end_in(soap, tag))
            return NULL;
    }
    else
    {   a = (struct SOAP_ENV__Fault *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Fault, 0, sizeof(struct SOAP_ENV__Fault), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a, const char *tag, const char *type)
{
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Fault);
    if (soap_out_SOAP_ENV__Fault(soap, tag?tag:"SOAP-ENV:Fault", id, a, type))
        return soap->error;
    return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_get_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *p, const char *tag, const char *type)
{
    if ((p = soap_in_SOAP_ENV__Fault(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 struct SOAP_ENV__Fault * SOAP_FMAC2 soap_instantiate_SOAP_ENV__Fault(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Fault(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Fault, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(struct SOAP_ENV__Fault);
        if (size)
            *size = sizeof(struct SOAP_ENV__Fault);
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(struct SOAP_ENV__Fault, n);
        if (size)
            *size = n * sizeof(struct SOAP_ENV__Fault);
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (struct SOAP_ENV__Fault*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Fault(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Fault %p -> %p\n", q, p));
    *(struct SOAP_ENV__Fault*)p = *(struct SOAP_ENV__Fault*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *a)
{
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a)
{
#ifndef WITH_NOIDREF
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->SOAP_ENV__Text);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Reason(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Reason *a, const char *type)
{
    (void)soap; (void)tag; (void)id; (void)type;
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Reason), type))
        return soap->error;
    if (soap->lang)
        soap_set_attr(soap, "xml:lang", soap->lang, 1);
    if (soap_out_string(soap, "SOAP-ENV:Text", -1, &a->SOAP_ENV__Text, ""))
        return soap->error;
    return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_in_SOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason *a, const char *type)
{
    size_t soap_flag_SOAP_ENV__Text = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
        return NULL;
    a = (struct SOAP_ENV__Reason *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0, NULL, NULL, NULL);
    if (!a)
        return NULL;
    soap_default_SOAP_ENV__Reason(soap, a);
    if (soap->body && !*soap->href)
    {
        for (;;)
        {   soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_SOAP_ENV__Text && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
                if (soap_in_string(soap, "SOAP-ENV:Text", &a->SOAP_ENV__Text, "xsd:string"))
                {   soap_flag_SOAP_ENV__Text--;
                    continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
                soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
                break;
            if (soap->error)
                return NULL;
        }
        if (soap_element_end_in(soap, tag))
            return NULL;
    }
    else
    {   a = (struct SOAP_ENV__Reason *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Reason, 0, sizeof(struct SOAP_ENV__Reason), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a, const char *tag, const char *type)
{
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Reason);
    if (soap_out_SOAP_ENV__Reason(soap, tag?tag:"SOAP-ENV:Reason", id, a, type))
        return soap->error;
    return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_get_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *p, const char *tag, const char *type)
{
    if ((p = soap_in_SOAP_ENV__Reason(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 struct SOAP_ENV__Reason * SOAP_FMAC2 soap_instantiate_SOAP_ENV__Reason(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Reason(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Reason, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(struct SOAP_ENV__Reason);
        if (size)
            *size = sizeof(struct SOAP_ENV__Reason);
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(struct SOAP_ENV__Reason, n);
        if (size)
            *size = n * sizeof(struct SOAP_ENV__Reason);
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (struct SOAP_ENV__Reason*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Reason(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Reason %p -> %p\n", q, p));
    *(struct SOAP_ENV__Reason*)p = *(struct SOAP_ENV__Reason*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *a)
{
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->__any = NULL;
    a->__type = 0;
    a->fault = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a)
{
#ifndef WITH_NOIDREF
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_markelement(soap, a->fault, a->__type);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Detail(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Detail *a, const char *type)
{
    (void)soap; (void)tag; (void)id; (void)type;
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Detail), type))
        return soap->error;
    soap_outliteral(soap, "-any", &a->__any, NULL);
    if (soap_putelement(soap, a->fault, "fault", -1, a->__type))
        return soap->error;
    return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_in_SOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail *a, const char *type)
{
    size_t soap_flag___any = 1;
    size_t soap_flag_fault = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
        return NULL;
    a = (struct SOAP_ENV__Detail *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0, NULL, NULL, NULL);
    if (!a)
        return NULL;
    soap_default_SOAP_ENV__Detail(soap, a);
    if (soap->body && !*soap->href)
    {
        for (;;)
        {   soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_fault && soap->error == SOAP_TAG_MISMATCH)
                if ((a->fault = soap_getelement(soap, &a->__type)))
                {   soap_flag_fault = 0;
                    continue;
                }
            if (soap_flag___any && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
                if (soap_inliteral(soap, "-any", &a->__any))
                {   soap_flag___any--;
                    continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
                soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
                break;
            if (soap->error)
                return NULL;
        }
        if (soap_element_end_in(soap, tag))
            return NULL;
    }
    else
    {   a = (struct SOAP_ENV__Detail *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Detail, 0, sizeof(struct SOAP_ENV__Detail), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a, const char *tag, const char *type)
{
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Detail);
    if (soap_out_SOAP_ENV__Detail(soap, tag?tag:"SOAP-ENV:Detail", id, a, type))
        return soap->error;
    return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_get_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *p, const char *tag, const char *type)
{
    if ((p = soap_in_SOAP_ENV__Detail(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 struct SOAP_ENV__Detail * SOAP_FMAC2 soap_instantiate_SOAP_ENV__Detail(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Detail(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Detail, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(struct SOAP_ENV__Detail);
        if (size)
            *size = sizeof(struct SOAP_ENV__Detail);
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(struct SOAP_ENV__Detail, n);
        if (size)
            *size = n * sizeof(struct SOAP_ENV__Detail);
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (struct SOAP_ENV__Detail*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Detail(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Detail %p -> %p\n", q, p));
    *(struct SOAP_ENV__Detail*)p = *(struct SOAP_ENV__Detail*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *a)
{
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default__QName(soap, &a->SOAP_ENV__Value);
    a->SOAP_ENV__Subcode = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a)
{
#ifndef WITH_NOIDREF
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize__QName(soap, &a->SOAP_ENV__Value);
    soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Subcode);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Code(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Code *a, const char *type)
{
    const char *soap_tmp_SOAP_ENV__Value = soap_QName2s(soap, a->SOAP_ENV__Value);
    (void)soap; (void)tag; (void)id; (void)type;
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Code), type))
        return soap->error;
    if (soap_out__QName(soap, "SOAP-ENV:Value", -1, (char*const*)&soap_tmp_SOAP_ENV__Value, ""))
        return soap->error;
    if (soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", -1, &a->SOAP_ENV__Subcode, ""))
        return soap->error;
    return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_in_SOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code *a, const char *type)
{
    size_t soap_flag_SOAP_ENV__Value = 1;
    size_t soap_flag_SOAP_ENV__Subcode = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
        return NULL;
    a = (struct SOAP_ENV__Code *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0, NULL, NULL, NULL);
    if (!a)
        return NULL;
    soap_default_SOAP_ENV__Code(soap, a);
    if (soap->body && !*soap->href)
    {
        for (;;)
        {   soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_SOAP_ENV__Value && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
                if (soap_in__QName(soap, "SOAP-ENV:Value", &a->SOAP_ENV__Value, ""))
                {   soap_flag_SOAP_ENV__Value--;
                    continue;
                }
            if (soap_flag_SOAP_ENV__Subcode && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", &a->SOAP_ENV__Subcode, ""))
                {   soap_flag_SOAP_ENV__Subcode--;
                    continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
                soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
                break;
            if (soap->error)
                return NULL;
        }
        if (soap_element_end_in(soap, tag))
            return NULL;
    }
    else
    {   a = (struct SOAP_ENV__Code *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Code, 0, sizeof(struct SOAP_ENV__Code), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a, const char *tag, const char *type)
{
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Code);
    if (soap_out_SOAP_ENV__Code(soap, tag?tag:"SOAP-ENV:Code", id, a, type))
        return soap->error;
    return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_get_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *p, const char *tag, const char *type)
{
    if ((p = soap_in_SOAP_ENV__Code(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 struct SOAP_ENV__Code * SOAP_FMAC2 soap_instantiate_SOAP_ENV__Code(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Code(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Code, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(struct SOAP_ENV__Code);
        if (size)
            *size = sizeof(struct SOAP_ENV__Code);
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(struct SOAP_ENV__Code, n);
        if (size)
            *size = n * sizeof(struct SOAP_ENV__Code);
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (struct SOAP_ENV__Code*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Code(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Code %p -> %p\n", q, p));
    *(struct SOAP_ENV__Code*)p = *(struct SOAP_ENV__Code*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *a)
{
    (void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a)
{
#ifndef WITH_NOIDREF
    (void)soap; (void)a; /* appease -Wall -Werror */
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Header(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Header *a, const char *type)
{
    (void)soap; (void)tag; (void)id; (void)type;
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Header), type))
        return soap->error;
    return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_in_SOAP_ENV__Header(struct soap *soap, const char *tag, struct SOAP_ENV__Header *a, const char *type)
{
    if (soap_element_begin_in(soap, tag, 0, type))
        return NULL;
    a = (struct SOAP_ENV__Header *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Header, sizeof(struct SOAP_ENV__Header), 0, NULL, NULL, NULL);
    if (!a)
        return NULL;
    soap_default_SOAP_ENV__Header(soap, a);
    if (soap->body && !*soap->href)
    {
        for (;;)
        {   soap->error = SOAP_TAG_MISMATCH;
            if (soap->error == SOAP_TAG_MISMATCH)
                soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
                break;
            if (soap->error)
                return NULL;
        }
        if (soap_element_end_in(soap, tag))
            return NULL;
    }
    else
    {   a = (struct SOAP_ENV__Header *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Header, 0, sizeof(struct SOAP_ENV__Header), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a, const char *tag, const char *type)
{
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Header);
    if (soap_out_SOAP_ENV__Header(soap, tag?tag:"SOAP-ENV:Header", id, a, type))
        return soap->error;
    return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_get_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *p, const char *tag, const char *type)
{
    if ((p = soap_in_SOAP_ENV__Header(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 struct SOAP_ENV__Header * SOAP_FMAC2 soap_instantiate_SOAP_ENV__Header(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Header(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Header, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(struct SOAP_ENV__Header);
        if (size)
            *size = sizeof(struct SOAP_ENV__Header);
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(struct SOAP_ENV__Header, n);
        if (size)
            *size = n * sizeof(struct SOAP_ENV__Header);
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (struct SOAP_ENV__Header*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Header(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Header %p -> %p\n", q, p));
    *(struct SOAP_ENV__Header*)p = *(struct SOAP_ENV__Header*)q;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__UploadSymbol(struct soap *soap, struct __ns1__UploadSymbol *a)
{
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->ns1__UploadSymbol = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__UploadSymbol(struct soap *soap, const struct __ns1__UploadSymbol *a)
{
#ifndef WITH_NOIDREF
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_PointerTo_ns1__UploadSymbol(soap, &a->ns1__UploadSymbol);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__UploadSymbol(struct soap *soap, const char *tag, int id, const struct __ns1__UploadSymbol *a, const char *type)
{
    (void)soap; (void)tag; (void)id; (void)type;
    if (soap_out_PointerTo_ns1__UploadSymbol(soap, "ns1:UploadSymbol", -1, &a->ns1__UploadSymbol, ""))
        return soap->error;
    return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__UploadSymbol * SOAP_FMAC4 soap_in___ns1__UploadSymbol(struct soap *soap, const char *tag, struct __ns1__UploadSymbol *a, const char *type)
{
    size_t soap_flag_ns1__UploadSymbol = 1;
    short soap_flag;
    a = (struct __ns1__UploadSymbol *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__UploadSymbol, sizeof(struct __ns1__UploadSymbol), 0, NULL, NULL, NULL);
    if (!a)
        return NULL;
    soap_default___ns1__UploadSymbol(soap, a);
        for (soap_flag = 0;; soap_flag = 1)
        {   soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_ns1__UploadSymbol && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerTo_ns1__UploadSymbol(soap, "ns1:UploadSymbol", &a->ns1__UploadSymbol, ""))
                {   soap_flag_ns1__UploadSymbol--;
                    continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
                if (soap_flag)
                {   soap->error = SOAP_OK;
                    break;
                }
            if (soap_flag && soap->error == SOAP_NO_TAG)
                break;
            if (soap->error)
                return NULL;
        }
    return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__UploadSymbol(struct soap *soap, const struct __ns1__UploadSymbol *a, const char *tag, const char *type)
{
    register int id = 0;
    if (soap_out___ns1__UploadSymbol(soap, tag?tag:"-ns1:UploadSymbol", id, a, type))
        return soap->error;
    return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__UploadSymbol * SOAP_FMAC4 soap_get___ns1__UploadSymbol(struct soap *soap, struct __ns1__UploadSymbol *p, const char *tag, const char *type)
{
    if ((p = soap_in___ns1__UploadSymbol(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 struct __ns1__UploadSymbol * SOAP_FMAC2 soap_instantiate___ns1__UploadSymbol(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___ns1__UploadSymbol(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE___ns1__UploadSymbol, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(struct __ns1__UploadSymbol);
        if (size)
            *size = sizeof(struct __ns1__UploadSymbol);
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(struct __ns1__UploadSymbol, n);
        if (size)
            *size = n * sizeof(struct __ns1__UploadSymbol);
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (struct __ns1__UploadSymbol*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy___ns1__UploadSymbol(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct __ns1__UploadSymbol %p -> %p\n", q, p));
    *(struct __ns1__UploadSymbol*)p = *(struct __ns1__UploadSymbol*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__RejectedToSendAdditionalInfo(struct soap *soap, struct __ns1__RejectedToSendAdditionalInfo *a)
{
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->ns1__RejectedToSendAdditionalInfo = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__RejectedToSendAdditionalInfo(struct soap *soap, const struct __ns1__RejectedToSendAdditionalInfo *a)
{
#ifndef WITH_NOIDREF
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_PointerTo_ns1__RejectedToSendAdditionalInfo(soap, &a->ns1__RejectedToSendAdditionalInfo);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__RejectedToSendAdditionalInfo(struct soap *soap, const char *tag, int id, const struct __ns1__RejectedToSendAdditionalInfo *a, const char *type)
{
    (void)soap; (void)tag; (void)id; (void)type;
    if (soap_out_PointerTo_ns1__RejectedToSendAdditionalInfo(soap, "ns1:RejectedToSendAdditionalInfo", -1, &a->ns1__RejectedToSendAdditionalInfo, ""))
        return soap->error;
    return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__RejectedToSendAdditionalInfo * SOAP_FMAC4 soap_in___ns1__RejectedToSendAdditionalInfo(struct soap *soap, const char *tag, struct __ns1__RejectedToSendAdditionalInfo *a, const char *type)
{
    size_t soap_flag_ns1__RejectedToSendAdditionalInfo = 1;
    short soap_flag;
    a = (struct __ns1__RejectedToSendAdditionalInfo *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__RejectedToSendAdditionalInfo, sizeof(struct __ns1__RejectedToSendAdditionalInfo), 0, NULL, NULL, NULL);
    if (!a)
        return NULL;
    soap_default___ns1__RejectedToSendAdditionalInfo(soap, a);
        for (soap_flag = 0;; soap_flag = 1)
        {   soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_ns1__RejectedToSendAdditionalInfo && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerTo_ns1__RejectedToSendAdditionalInfo(soap, "ns1:RejectedToSendAdditionalInfo", &a->ns1__RejectedToSendAdditionalInfo, ""))
                {   soap_flag_ns1__RejectedToSendAdditionalInfo--;
                    continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
                if (soap_flag)
                {   soap->error = SOAP_OK;
                    break;
                }
            if (soap_flag && soap->error == SOAP_NO_TAG)
                break;
            if (soap->error)
                return NULL;
        }
    return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__RejectedToSendAdditionalInfo(struct soap *soap, const struct __ns1__RejectedToSendAdditionalInfo *a, const char *tag, const char *type)
{
    register int id = 0;
    if (soap_out___ns1__RejectedToSendAdditionalInfo(soap, tag?tag:"-ns1:RejectedToSendAdditionalInfo", id, a, type))
        return soap->error;
    return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__RejectedToSendAdditionalInfo * SOAP_FMAC4 soap_get___ns1__RejectedToSendAdditionalInfo(struct soap *soap, struct __ns1__RejectedToSendAdditionalInfo *p, const char *tag, const char *type)
{
    if ((p = soap_in___ns1__RejectedToSendAdditionalInfo(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 struct __ns1__RejectedToSendAdditionalInfo * SOAP_FMAC2 soap_instantiate___ns1__RejectedToSendAdditionalInfo(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___ns1__RejectedToSendAdditionalInfo(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE___ns1__RejectedToSendAdditionalInfo, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(struct __ns1__RejectedToSendAdditionalInfo);
        if (size)
            *size = sizeof(struct __ns1__RejectedToSendAdditionalInfo);
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(struct __ns1__RejectedToSendAdditionalInfo, n);
        if (size)
            *size = n * sizeof(struct __ns1__RejectedToSendAdditionalInfo);
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (struct __ns1__RejectedToSendAdditionalInfo*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy___ns1__RejectedToSendAdditionalInfo(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct __ns1__RejectedToSendAdditionalInfo %p -> %p\n", q, p));
    *(struct __ns1__RejectedToSendAdditionalInfo*)p = *(struct __ns1__RejectedToSendAdditionalInfo*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__UploadAdditionalInfo(struct soap *soap, struct __ns1__UploadAdditionalInfo *a)
{
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->ns1__UploadAdditionalInfo = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__UploadAdditionalInfo(struct soap *soap, const struct __ns1__UploadAdditionalInfo *a)
{
#ifndef WITH_NOIDREF
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_PointerTo_ns1__UploadAdditionalInfo(soap, &a->ns1__UploadAdditionalInfo);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__UploadAdditionalInfo(struct soap *soap, const char *tag, int id, const struct __ns1__UploadAdditionalInfo *a, const char *type)
{
    (void)soap; (void)tag; (void)id; (void)type;
    if (soap_out_PointerTo_ns1__UploadAdditionalInfo(soap, "ns1:UploadAdditionalInfo", -1, &a->ns1__UploadAdditionalInfo, ""))
        return soap->error;
    return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__UploadAdditionalInfo * SOAP_FMAC4 soap_in___ns1__UploadAdditionalInfo(struct soap *soap, const char *tag, struct __ns1__UploadAdditionalInfo *a, const char *type)
{
    size_t soap_flag_ns1__UploadAdditionalInfo = 1;
    short soap_flag;
    a = (struct __ns1__UploadAdditionalInfo *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__UploadAdditionalInfo, sizeof(struct __ns1__UploadAdditionalInfo), 0, NULL, NULL, NULL);
    if (!a)
        return NULL;
    soap_default___ns1__UploadAdditionalInfo(soap, a);
        for (soap_flag = 0;; soap_flag = 1)
        {   soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_ns1__UploadAdditionalInfo && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerTo_ns1__UploadAdditionalInfo(soap, "ns1:UploadAdditionalInfo", &a->ns1__UploadAdditionalInfo, ""))
                {   soap_flag_ns1__UploadAdditionalInfo--;
                    continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
                if (soap_flag)
                {   soap->error = SOAP_OK;
                    break;
                }
            if (soap_flag && soap->error == SOAP_NO_TAG)
                break;
            if (soap->error)
                return NULL;
        }
    return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__UploadAdditionalInfo(struct soap *soap, const struct __ns1__UploadAdditionalInfo *a, const char *tag, const char *type)
{
    register int id = 0;
    if (soap_out___ns1__UploadAdditionalInfo(soap, tag?tag:"-ns1:UploadAdditionalInfo", id, a, type))
        return soap->error;
    return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__UploadAdditionalInfo * SOAP_FMAC4 soap_get___ns1__UploadAdditionalInfo(struct soap *soap, struct __ns1__UploadAdditionalInfo *p, const char *tag, const char *type)
{
    if ((p = soap_in___ns1__UploadAdditionalInfo(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 struct __ns1__UploadAdditionalInfo * SOAP_FMAC2 soap_instantiate___ns1__UploadAdditionalInfo(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___ns1__UploadAdditionalInfo(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE___ns1__UploadAdditionalInfo, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(struct __ns1__UploadAdditionalInfo);
        if (size)
            *size = sizeof(struct __ns1__UploadAdditionalInfo);
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(struct __ns1__UploadAdditionalInfo, n);
        if (size)
            *size = n * sizeof(struct __ns1__UploadAdditionalInfo);
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (struct __ns1__UploadAdditionalInfo*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy___ns1__UploadAdditionalInfo(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct __ns1__UploadAdditionalInfo %p -> %p\n", q, p));
    *(struct __ns1__UploadAdditionalInfo*)p = *(struct __ns1__UploadAdditionalInfo*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__UploadFullDump(struct soap *soap, struct __ns1__UploadFullDump *a)
{
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->ns1__UploadFullDump = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__UploadFullDump(struct soap *soap, const struct __ns1__UploadFullDump *a)
{
#ifndef WITH_NOIDREF
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_PointerTo_ns1__UploadFullDump(soap, &a->ns1__UploadFullDump);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__UploadFullDump(struct soap *soap, const char *tag, int id, const struct __ns1__UploadFullDump *a, const char *type)
{
    (void)soap; (void)tag; (void)id; (void)type;
    if (soap_out_PointerTo_ns1__UploadFullDump(soap, "ns1:UploadFullDump", -1, &a->ns1__UploadFullDump, ""))
        return soap->error;
    return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__UploadFullDump * SOAP_FMAC4 soap_in___ns1__UploadFullDump(struct soap *soap, const char *tag, struct __ns1__UploadFullDump *a, const char *type)
{
    size_t soap_flag_ns1__UploadFullDump = 1;
    short soap_flag;
    a = (struct __ns1__UploadFullDump *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__UploadFullDump, sizeof(struct __ns1__UploadFullDump), 0, NULL, NULL, NULL);
    if (!a)
        return NULL;
    soap_default___ns1__UploadFullDump(soap, a);
        for (soap_flag = 0;; soap_flag = 1)
        {   soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_ns1__UploadFullDump && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerTo_ns1__UploadFullDump(soap, "ns1:UploadFullDump", &a->ns1__UploadFullDump, ""))
                {   soap_flag_ns1__UploadFullDump--;
                    continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
                if (soap_flag)
                {   soap->error = SOAP_OK;
                    break;
                }
            if (soap_flag && soap->error == SOAP_NO_TAG)
                break;
            if (soap->error)
                return NULL;
        }
    return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__UploadFullDump(struct soap *soap, const struct __ns1__UploadFullDump *a, const char *tag, const char *type)
{
    register int id = 0;
    if (soap_out___ns1__UploadFullDump(soap, tag?tag:"-ns1:UploadFullDump", id, a, type))
        return soap->error;
    return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__UploadFullDump * SOAP_FMAC4 soap_get___ns1__UploadFullDump(struct soap *soap, struct __ns1__UploadFullDump *p, const char *tag, const char *type)
{
    if ((p = soap_in___ns1__UploadFullDump(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 struct __ns1__UploadFullDump * SOAP_FMAC2 soap_instantiate___ns1__UploadFullDump(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___ns1__UploadFullDump(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE___ns1__UploadFullDump, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(struct __ns1__UploadFullDump);
        if (size)
            *size = sizeof(struct __ns1__UploadFullDump);
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(struct __ns1__UploadFullDump, n);
        if (size)
            *size = n * sizeof(struct __ns1__UploadFullDump);
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (struct __ns1__UploadFullDump*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy___ns1__UploadFullDump(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct __ns1__UploadFullDump %p -> %p\n", q, p));
    *(struct __ns1__UploadFullDump*)p = *(struct __ns1__UploadFullDump*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__UploadMiniDump(struct soap *soap, struct __ns1__UploadMiniDump *a)
{
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->ns1__UploadMiniDump = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__UploadMiniDump(struct soap *soap, const struct __ns1__UploadMiniDump *a)
{
#ifndef WITH_NOIDREF
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_PointerTo_ns1__UploadMiniDump(soap, &a->ns1__UploadMiniDump);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__UploadMiniDump(struct soap *soap, const char *tag, int id, const struct __ns1__UploadMiniDump *a, const char *type)
{
    (void)soap; (void)tag; (void)id; (void)type;
    if (soap_out_PointerTo_ns1__UploadMiniDump(soap, "ns1:UploadMiniDump", -1, &a->ns1__UploadMiniDump, ""))
        return soap->error;
    return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__UploadMiniDump * SOAP_FMAC4 soap_in___ns1__UploadMiniDump(struct soap *soap, const char *tag, struct __ns1__UploadMiniDump *a, const char *type)
{
    size_t soap_flag_ns1__UploadMiniDump = 1;
    short soap_flag;
    a = (struct __ns1__UploadMiniDump *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__UploadMiniDump, sizeof(struct __ns1__UploadMiniDump), 0, NULL, NULL, NULL);
    if (!a)
        return NULL;
    soap_default___ns1__UploadMiniDump(soap, a);
        for (soap_flag = 0;; soap_flag = 1)
        {   soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_ns1__UploadMiniDump && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerTo_ns1__UploadMiniDump(soap, "ns1:UploadMiniDump", &a->ns1__UploadMiniDump, ""))
                {   soap_flag_ns1__UploadMiniDump--;
                    continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
                if (soap_flag)
                {   soap->error = SOAP_OK;
                    break;
                }
            if (soap_flag && soap->error == SOAP_NO_TAG)
                break;
            if (soap->error)
                return NULL;
        }
    return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__UploadMiniDump(struct soap *soap, const struct __ns1__UploadMiniDump *a, const char *tag, const char *type)
{
    register int id = 0;
    if (soap_out___ns1__UploadMiniDump(soap, tag?tag:"-ns1:UploadMiniDump", id, a, type))
        return soap->error;
    return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__UploadMiniDump * SOAP_FMAC4 soap_get___ns1__UploadMiniDump(struct soap *soap, struct __ns1__UploadMiniDump *p, const char *tag, const char *type)
{
    if ((p = soap_in___ns1__UploadMiniDump(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 struct __ns1__UploadMiniDump * SOAP_FMAC2 soap_instantiate___ns1__UploadMiniDump(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___ns1__UploadMiniDump(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE___ns1__UploadMiniDump, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(struct __ns1__UploadMiniDump);
        if (size)
            *size = sizeof(struct __ns1__UploadMiniDump);
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(struct __ns1__UploadMiniDump, n);
        if (size)
            *size = n * sizeof(struct __ns1__UploadMiniDump);
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (struct __ns1__UploadMiniDump*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy___ns1__UploadMiniDump(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct __ns1__UploadMiniDump %p -> %p\n", q, p));
    *(struct __ns1__UploadMiniDump*)p = *(struct __ns1__UploadMiniDump*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__Hello(struct soap *soap, struct __ns1__Hello *a)
{
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->ns1__Hello = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__Hello(struct soap *soap, const struct __ns1__Hello *a)
{
#ifndef WITH_NOIDREF
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_PointerTo_ns1__Hello(soap, &a->ns1__Hello);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__Hello(struct soap *soap, const char *tag, int id, const struct __ns1__Hello *a, const char *type)
{
    (void)soap; (void)tag; (void)id; (void)type;
    if (soap_out_PointerTo_ns1__Hello(soap, "ns1:Hello", -1, &a->ns1__Hello, ""))
        return soap->error;
    return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__Hello * SOAP_FMAC4 soap_in___ns1__Hello(struct soap *soap, const char *tag, struct __ns1__Hello *a, const char *type)
{
    size_t soap_flag_ns1__Hello = 1;
    short soap_flag;
    a = (struct __ns1__Hello *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__Hello, sizeof(struct __ns1__Hello), 0, NULL, NULL, NULL);
    if (!a)
        return NULL;
    soap_default___ns1__Hello(soap, a);
        for (soap_flag = 0;; soap_flag = 1)
        {   soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_ns1__Hello && soap->error == SOAP_TAG_MISMATCH)
                if (soap_in_PointerTo_ns1__Hello(soap, "ns1:Hello", &a->ns1__Hello, ""))
                {   soap_flag_ns1__Hello--;
                    continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
                if (soap_flag)
                {   soap->error = SOAP_OK;
                    break;
                }
            if (soap_flag && soap->error == SOAP_NO_TAG)
                break;
            if (soap->error)
                return NULL;
        }
    return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__Hello(struct soap *soap, const struct __ns1__Hello *a, const char *tag, const char *type)
{
    register int id = 0;
    if (soap_out___ns1__Hello(soap, tag?tag:"-ns1:Hello", id, a, type))
        return soap->error;
    return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__Hello * SOAP_FMAC4 soap_get___ns1__Hello(struct soap *soap, struct __ns1__Hello *p, const char *tag, const char *type)
{
    if ((p = soap_in___ns1__Hello(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 struct __ns1__Hello * SOAP_FMAC2 soap_instantiate___ns1__Hello(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___ns1__Hello(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE___ns1__Hello, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(struct __ns1__Hello);
        if (size)
            *size = sizeof(struct __ns1__Hello);
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(struct __ns1__Hello, n);
        if (size)
            *size = n * sizeof(struct __ns1__Hello);
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (struct __ns1__Hello*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy___ns1__Hello(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct __ns1__Hello %p -> %p\n", q, p));
    *(struct __ns1__Hello*)p = *(struct __ns1__Hello*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__xop__Include(struct soap *soap, struct _xop__Include *a)
{   (void)soap;
    (void)soap; /* appease -Wall -Werror */
    a->__size = 0;
    a->__ptr = NULL;
    a->id = NULL;
    a->type = NULL;
    a->options = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__xop__Include(struct soap *soap, struct _xop__Include const*a)
{
#ifndef WITH_NOIDREF
    if (a->__ptr && !soap_array_reference(soap, a, (struct soap_array*)&a->__ptr, 1, SOAP_TYPE__xop__Include))
        if (a->id || a->type)
            soap->mode |= SOAP_ENC_DIME;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__xop__Include(struct soap *soap, const char *tag, int id, const struct _xop__Include *a, const char *type)
{
#ifndef WITH_LEANER
    id = soap_attachment(soap, tag, id, a, (struct soap_array*)&a->__ptr, a->id, a->type, a->options, 1, type, SOAP_TYPE__xop__Include);
#else
    id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE__xop__Include);
#endif
    if (id < 0)
        return soap->error;
    if (soap_element_begin_out(soap, tag, id, type))
        return soap->error;
    if (soap_putbase64(soap, a->__ptr, a->__size))
        return soap->error;
    return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _xop__Include * SOAP_FMAC4 soap_in__xop__Include(struct soap *soap, const char *tag, struct _xop__Include *a, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    if (soap_element_begin_in(soap, tag, 1, NULL))
        return NULL;
    if (*soap->type && soap_match_tag(soap, soap->type, type) && soap_match_tag(soap, soap->type, ":base64Binary") && soap_match_tag(soap, soap->type, ":base64"))
    {   soap->error = SOAP_TYPE;
        return NULL;
    }
    a = (struct _xop__Include *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__xop__Include, sizeof(struct _xop__Include), 0, NULL, NULL, NULL);
    if (!a)
        return NULL;
    soap_default__xop__Include(soap, a);
    if (soap->body && !*soap->href)
    {
        a->__ptr = soap_getbase64(soap, &a->__size, 0);
#ifndef WITH_LEANER
        if (soap_xop_forward(soap, &a->__ptr, &a->__size, &a->id, &a->type, &a->options))
            return NULL;
#endif
        if ((!a->__ptr && soap->error) || soap_element_end_in(soap, tag))
            return NULL;
    }
    else
    {
#ifndef WITH_LEANER
        if (*soap->href != '#')
        {   if (soap_dime_forward(soap, &a->__ptr, &a->__size, &a->id, &a->type, &a->options))
                return NULL;
        }
        else
#endif
            a = (struct _xop__Include *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__xop__Include, 0, sizeof(struct _xop__Include), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__xop__Include(struct soap *soap, const struct _xop__Include *a, const char *tag, const char *type)
{
    register int id = soap_embed(soap, (void*)a, (struct soap_array*)&a->__ptr, 1, tag, SOAP_TYPE__xop__Include);
    if (soap_out__xop__Include(soap, tag?tag:"xop:Include", id, a, type))
        return soap->error;
    return soap_putindependent(soap);
}

SOAP_FMAC3 struct _xop__Include * SOAP_FMAC4 soap_get__xop__Include(struct soap *soap, struct _xop__Include *p, const char *tag, const char *type)
{
    if ((p = soap_in__xop__Include(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC1 struct _xop__Include * SOAP_FMAC2 soap_instantiate__xop__Include(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__xop__Include(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__xop__Include, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(struct _xop__Include);
        if (size)
            *size = sizeof(struct _xop__Include);
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(struct _xop__Include, n);
        if (size)
            *size = n * sizeof(struct _xop__Include);
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (struct _xop__Include*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__xop__Include(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct _xop__Include %p -> %p\n", q, p));
    *(struct _xop__Include*)p = *(struct _xop__Include*)q;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *const*a)
{
#ifndef WITH_NOIDREF
    if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Reason))
        soap_serialize_SOAP_ENV__Reason(soap, *a);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Reason(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Reason *const*a, const char *type)
{
    id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Reason);
    if (id < 0)
        return soap->error;
    return soap_out_SOAP_ENV__Reason(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Reason ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason **a, const char *type)
{
    if (soap_element_begin_in(soap, tag, 1, NULL))
        return NULL;
    if (!a)
        if (!(a = (struct SOAP_ENV__Reason **)soap_malloc(soap, sizeof(struct SOAP_ENV__Reason *))))
            return NULL;
    *a = NULL;
    if (!soap->null && *soap->href != '#')
    {   soap_revert(soap);
        if (!(*a = soap_in_SOAP_ENV__Reason(soap, tag, *a, type)))
            return NULL;
    }
    else
    {   a = (struct SOAP_ENV__Reason **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0);
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *const*a, const char *tag, const char *type)
{
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Reason);
    if (soap_out_PointerToSOAP_ENV__Reason(soap, tag?tag:"SOAP-ENV:Reason", id, a, type))
        return soap->error;
    return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Reason ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason **p, const char *tag, const char *type)
{
    if ((p = soap_in_PointerToSOAP_ENV__Reason(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *const*a)
{
#ifndef WITH_NOIDREF
    if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Detail))
        soap_serialize_SOAP_ENV__Detail(soap, *a);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Detail(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Detail *const*a, const char *type)
{
    id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Detail);
    if (id < 0)
        return soap->error;
    return soap_out_SOAP_ENV__Detail(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Detail ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail **a, const char *type)
{
    if (soap_element_begin_in(soap, tag, 1, NULL))
        return NULL;
    if (!a)
        if (!(a = (struct SOAP_ENV__Detail **)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail *))))
            return NULL;
    *a = NULL;
    if (!soap->null && *soap->href != '#')
    {   soap_revert(soap);
        if (!(*a = soap_in_SOAP_ENV__Detail(soap, tag, *a, type)))
            return NULL;
    }
    else
    {   a = (struct SOAP_ENV__Detail **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0);
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *const*a, const char *tag, const char *type)
{
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Detail);
    if (soap_out_PointerToSOAP_ENV__Detail(soap, tag?tag:"SOAP-ENV:Detail", id, a, type))
        return soap->error;
    return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Detail ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail **p, const char *tag, const char *type)
{
    if ((p = soap_in_PointerToSOAP_ENV__Detail(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a)
{
#ifndef WITH_NOIDREF
    if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Code))
        soap_serialize_SOAP_ENV__Code(soap, *a);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Code(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Code *const*a, const char *type)
{
    id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Code);
    if (id < 0)
        return soap->error;
    return soap_out_SOAP_ENV__Code(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Code ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code **a, const char *type)
{
    if (soap_element_begin_in(soap, tag, 1, NULL))
        return NULL;
    if (!a)
        if (!(a = (struct SOAP_ENV__Code **)soap_malloc(soap, sizeof(struct SOAP_ENV__Code *))))
            return NULL;
    *a = NULL;
    if (!soap->null && *soap->href != '#')
    {   soap_revert(soap);
        if (!(*a = soap_in_SOAP_ENV__Code(soap, tag, *a, type)))
            return NULL;
    }
    else
    {   a = (struct SOAP_ENV__Code **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0);
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a, const char *tag, const char *type)
{
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Code);
    if (soap_out_PointerToSOAP_ENV__Code(soap, tag?tag:"SOAP-ENV:Code", id, a, type))
        return soap->error;
    return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Code ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code **p, const char *tag, const char *type)
{
    if ((p = soap_in_PointerToSOAP_ENV__Code(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__UploadSymbolResponse(struct soap *soap, _ns1__UploadSymbolResponse *const*a)
{
#ifndef WITH_NOIDREF
    if (!soap_reference(soap, *a, SOAP_TYPE__ns1__UploadSymbolResponse))
        (*a)->soap_serialize(soap);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__UploadSymbolResponse(struct soap *soap, const char *tag, int id, _ns1__UploadSymbolResponse *const*a, const char *type)
{
    id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__UploadSymbolResponse);
    if (id < 0)
        return soap->error;
    return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _ns1__UploadSymbolResponse ** SOAP_FMAC4 soap_in_PointerTo_ns1__UploadSymbolResponse(struct soap *soap, const char *tag, _ns1__UploadSymbolResponse **a, const char *type)
{
    if (soap_element_begin_in(soap, tag, 1, NULL))
        return NULL;
    if (!a)
        if (!(a = (_ns1__UploadSymbolResponse **)soap_malloc(soap, sizeof(_ns1__UploadSymbolResponse *))))
            return NULL;
    *a = NULL;
    if (!soap->null && *soap->href != '#')
    {   soap_revert(soap);
        if (!(*a = (_ns1__UploadSymbolResponse *)soap_instantiate__ns1__UploadSymbolResponse(soap, -1, soap->type, soap->arrayType, NULL)))
            return NULL;
        (*a)->soap_default(soap);
        if (!(*a)->soap_in(soap, tag, NULL))
            return NULL;
    }
    else
    {   _ns1__UploadSymbolResponse ** p = (_ns1__UploadSymbolResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__UploadSymbolResponse, sizeof(_ns1__UploadSymbolResponse), 0);
        a = p;
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__UploadSymbolResponse(struct soap *soap, _ns1__UploadSymbolResponse *const*a, const char *tag, const char *type)
{
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__UploadSymbolResponse);
    if (soap_out_PointerTo_ns1__UploadSymbolResponse(soap, tag?tag:"ns1:UploadSymbolResponse", id, a, type))
        return soap->error;
    return soap_putindependent(soap);
}

SOAP_FMAC3 _ns1__UploadSymbolResponse ** SOAP_FMAC4 soap_get_PointerTo_ns1__UploadSymbolResponse(struct soap *soap, _ns1__UploadSymbolResponse **p, const char *tag, const char *type)
{
    if ((p = soap_in_PointerTo_ns1__UploadSymbolResponse(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__UploadSymbol(struct soap *soap, _ns1__UploadSymbol *const*a)
{
#ifndef WITH_NOIDREF
    if (!soap_reference(soap, *a, SOAP_TYPE__ns1__UploadSymbol))
        (*a)->soap_serialize(soap);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__UploadSymbol(struct soap *soap, const char *tag, int id, _ns1__UploadSymbol *const*a, const char *type)
{
    id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__UploadSymbol);
    if (id < 0)
        return soap->error;
    return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _ns1__UploadSymbol ** SOAP_FMAC4 soap_in_PointerTo_ns1__UploadSymbol(struct soap *soap, const char *tag, _ns1__UploadSymbol **a, const char *type)
{
    if (soap_element_begin_in(soap, tag, 1, NULL))
        return NULL;
    if (!a)
        if (!(a = (_ns1__UploadSymbol **)soap_malloc(soap, sizeof(_ns1__UploadSymbol *))))
            return NULL;
    *a = NULL;
    if (!soap->null && *soap->href != '#')
    {   soap_revert(soap);
        if (!(*a = (_ns1__UploadSymbol *)soap_instantiate__ns1__UploadSymbol(soap, -1, soap->type, soap->arrayType, NULL)))
            return NULL;
        (*a)->soap_default(soap);
        if (!(*a)->soap_in(soap, tag, NULL))
            return NULL;
    }
    else
    {   _ns1__UploadSymbol ** p = (_ns1__UploadSymbol **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__UploadSymbol, sizeof(_ns1__UploadSymbol), 0);
        a = p;
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__UploadSymbol(struct soap *soap, _ns1__UploadSymbol *const*a, const char *tag, const char *type)
{
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__UploadSymbol);
    if (soap_out_PointerTo_ns1__UploadSymbol(soap, tag?tag:"ns1:UploadSymbol", id, a, type))
        return soap->error;
    return soap_putindependent(soap);
}

SOAP_FMAC3 _ns1__UploadSymbol ** SOAP_FMAC4 soap_get_PointerTo_ns1__UploadSymbol(struct soap *soap, _ns1__UploadSymbol **p, const char *tag, const char *type)
{
    if ((p = soap_in_PointerTo_ns1__UploadSymbol(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__RejectedToSendAdditionalInfoResponse(struct soap *soap, _ns1__RejectedToSendAdditionalInfoResponse *const*a)
{
#ifndef WITH_NOIDREF
    if (!soap_reference(soap, *a, SOAP_TYPE__ns1__RejectedToSendAdditionalInfoResponse))
        (*a)->soap_serialize(soap);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__RejectedToSendAdditionalInfoResponse(struct soap *soap, const char *tag, int id, _ns1__RejectedToSendAdditionalInfoResponse *const*a, const char *type)
{
    id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__RejectedToSendAdditionalInfoResponse);
    if (id < 0)
        return soap->error;
    return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _ns1__RejectedToSendAdditionalInfoResponse ** SOAP_FMAC4 soap_in_PointerTo_ns1__RejectedToSendAdditionalInfoResponse(struct soap *soap, const char *tag, _ns1__RejectedToSendAdditionalInfoResponse **a, const char *type)
{
    if (soap_element_begin_in(soap, tag, 1, NULL))
        return NULL;
    if (!a)
        if (!(a = (_ns1__RejectedToSendAdditionalInfoResponse **)soap_malloc(soap, sizeof(_ns1__RejectedToSendAdditionalInfoResponse *))))
            return NULL;
    *a = NULL;
    if (!soap->null && *soap->href != '#')
    {   soap_revert(soap);
        if (!(*a = (_ns1__RejectedToSendAdditionalInfoResponse *)soap_instantiate__ns1__RejectedToSendAdditionalInfoResponse(soap, -1, soap->type, soap->arrayType, NULL)))
            return NULL;
        (*a)->soap_default(soap);
        if (!(*a)->soap_in(soap, tag, NULL))
            return NULL;
    }
    else
    {   _ns1__RejectedToSendAdditionalInfoResponse ** p = (_ns1__RejectedToSendAdditionalInfoResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__RejectedToSendAdditionalInfoResponse, sizeof(_ns1__RejectedToSendAdditionalInfoResponse), 0);
        a = p;
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__RejectedToSendAdditionalInfoResponse(struct soap *soap, _ns1__RejectedToSendAdditionalInfoResponse *const*a, const char *tag, const char *type)
{
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__RejectedToSendAdditionalInfoResponse);
    if (soap_out_PointerTo_ns1__RejectedToSendAdditionalInfoResponse(soap, tag?tag:"ns1:RejectedToSendAdditionalInfoResponse", id, a, type))
        return soap->error;
    return soap_putindependent(soap);
}

SOAP_FMAC3 _ns1__RejectedToSendAdditionalInfoResponse ** SOAP_FMAC4 soap_get_PointerTo_ns1__RejectedToSendAdditionalInfoResponse(struct soap *soap, _ns1__RejectedToSendAdditionalInfoResponse **p, const char *tag, const char *type)
{
    if ((p = soap_in_PointerTo_ns1__RejectedToSendAdditionalInfoResponse(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__RejectedToSendAdditionalInfo(struct soap *soap, _ns1__RejectedToSendAdditionalInfo *const*a)
{
#ifndef WITH_NOIDREF
    if (!soap_reference(soap, *a, SOAP_TYPE__ns1__RejectedToSendAdditionalInfo))
        (*a)->soap_serialize(soap);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__RejectedToSendAdditionalInfo(struct soap *soap, const char *tag, int id, _ns1__RejectedToSendAdditionalInfo *const*a, const char *type)
{
    id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__RejectedToSendAdditionalInfo);
    if (id < 0)
        return soap->error;
    return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _ns1__RejectedToSendAdditionalInfo ** SOAP_FMAC4 soap_in_PointerTo_ns1__RejectedToSendAdditionalInfo(struct soap *soap, const char *tag, _ns1__RejectedToSendAdditionalInfo **a, const char *type)
{
    if (soap_element_begin_in(soap, tag, 1, NULL))
        return NULL;
    if (!a)
        if (!(a = (_ns1__RejectedToSendAdditionalInfo **)soap_malloc(soap, sizeof(_ns1__RejectedToSendAdditionalInfo *))))
            return NULL;
    *a = NULL;
    if (!soap->null && *soap->href != '#')
    {   soap_revert(soap);
        if (!(*a = (_ns1__RejectedToSendAdditionalInfo *)soap_instantiate__ns1__RejectedToSendAdditionalInfo(soap, -1, soap->type, soap->arrayType, NULL)))
            return NULL;
        (*a)->soap_default(soap);
        if (!(*a)->soap_in(soap, tag, NULL))
            return NULL;
    }
    else
    {   _ns1__RejectedToSendAdditionalInfo ** p = (_ns1__RejectedToSendAdditionalInfo **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__RejectedToSendAdditionalInfo, sizeof(_ns1__RejectedToSendAdditionalInfo), 0);
        a = p;
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__RejectedToSendAdditionalInfo(struct soap *soap, _ns1__RejectedToSendAdditionalInfo *const*a, const char *tag, const char *type)
{
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__RejectedToSendAdditionalInfo);
    if (soap_out_PointerTo_ns1__RejectedToSendAdditionalInfo(soap, tag?tag:"ns1:RejectedToSendAdditionalInfo", id, a, type))
        return soap->error;
    return soap_putindependent(soap);
}

SOAP_FMAC3 _ns1__RejectedToSendAdditionalInfo ** SOAP_FMAC4 soap_get_PointerTo_ns1__RejectedToSendAdditionalInfo(struct soap *soap, _ns1__RejectedToSendAdditionalInfo **p, const char *tag, const char *type)
{
    if ((p = soap_in_PointerTo_ns1__RejectedToSendAdditionalInfo(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__UploadAdditionalInfoResponse(struct soap *soap, _ns1__UploadAdditionalInfoResponse *const*a)
{
#ifndef WITH_NOIDREF
    if (!soap_reference(soap, *a, SOAP_TYPE__ns1__UploadAdditionalInfoResponse))
        (*a)->soap_serialize(soap);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__UploadAdditionalInfoResponse(struct soap *soap, const char *tag, int id, _ns1__UploadAdditionalInfoResponse *const*a, const char *type)
{
    id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__UploadAdditionalInfoResponse);
    if (id < 0)
        return soap->error;
    return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _ns1__UploadAdditionalInfoResponse ** SOAP_FMAC4 soap_in_PointerTo_ns1__UploadAdditionalInfoResponse(struct soap *soap, const char *tag, _ns1__UploadAdditionalInfoResponse **a, const char *type)
{
    if (soap_element_begin_in(soap, tag, 1, NULL))
        return NULL;
    if (!a)
        if (!(a = (_ns1__UploadAdditionalInfoResponse **)soap_malloc(soap, sizeof(_ns1__UploadAdditionalInfoResponse *))))
            return NULL;
    *a = NULL;
    if (!soap->null && *soap->href != '#')
    {   soap_revert(soap);
        if (!(*a = (_ns1__UploadAdditionalInfoResponse *)soap_instantiate__ns1__UploadAdditionalInfoResponse(soap, -1, soap->type, soap->arrayType, NULL)))
            return NULL;
        (*a)->soap_default(soap);
        if (!(*a)->soap_in(soap, tag, NULL))
            return NULL;
    }
    else
    {   _ns1__UploadAdditionalInfoResponse ** p = (_ns1__UploadAdditionalInfoResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__UploadAdditionalInfoResponse, sizeof(_ns1__UploadAdditionalInfoResponse), 0);
        a = p;
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__UploadAdditionalInfoResponse(struct soap *soap, _ns1__UploadAdditionalInfoResponse *const*a, const char *tag, const char *type)
{
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__UploadAdditionalInfoResponse);
    if (soap_out_PointerTo_ns1__UploadAdditionalInfoResponse(soap, tag?tag:"ns1:UploadAdditionalInfoResponse", id, a, type))
        return soap->error;
    return soap_putindependent(soap);
}

SOAP_FMAC3 _ns1__UploadAdditionalInfoResponse ** SOAP_FMAC4 soap_get_PointerTo_ns1__UploadAdditionalInfoResponse(struct soap *soap, _ns1__UploadAdditionalInfoResponse **p, const char *tag, const char *type)
{
    if ((p = soap_in_PointerTo_ns1__UploadAdditionalInfoResponse(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__UploadAdditionalInfo(struct soap *soap, _ns1__UploadAdditionalInfo *const*a)
{
#ifndef WITH_NOIDREF
    if (!soap_reference(soap, *a, SOAP_TYPE__ns1__UploadAdditionalInfo))
        (*a)->soap_serialize(soap);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__UploadAdditionalInfo(struct soap *soap, const char *tag, int id, _ns1__UploadAdditionalInfo *const*a, const char *type)
{
    id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__UploadAdditionalInfo);
    if (id < 0)
        return soap->error;
    return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _ns1__UploadAdditionalInfo ** SOAP_FMAC4 soap_in_PointerTo_ns1__UploadAdditionalInfo(struct soap *soap, const char *tag, _ns1__UploadAdditionalInfo **a, const char *type)
{
    if (soap_element_begin_in(soap, tag, 1, NULL))
        return NULL;
    if (!a)
        if (!(a = (_ns1__UploadAdditionalInfo **)soap_malloc(soap, sizeof(_ns1__UploadAdditionalInfo *))))
            return NULL;
    *a = NULL;
    if (!soap->null && *soap->href != '#')
    {   soap_revert(soap);
        if (!(*a = (_ns1__UploadAdditionalInfo *)soap_instantiate__ns1__UploadAdditionalInfo(soap, -1, soap->type, soap->arrayType, NULL)))
            return NULL;
        (*a)->soap_default(soap);
        if (!(*a)->soap_in(soap, tag, NULL))
            return NULL;
    }
    else
    {   _ns1__UploadAdditionalInfo ** p = (_ns1__UploadAdditionalInfo **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__UploadAdditionalInfo, sizeof(_ns1__UploadAdditionalInfo), 0);
        a = p;
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__UploadAdditionalInfo(struct soap *soap, _ns1__UploadAdditionalInfo *const*a, const char *tag, const char *type)
{
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__UploadAdditionalInfo);
    if (soap_out_PointerTo_ns1__UploadAdditionalInfo(soap, tag?tag:"ns1:UploadAdditionalInfo", id, a, type))
        return soap->error;
    return soap_putindependent(soap);
}

SOAP_FMAC3 _ns1__UploadAdditionalInfo ** SOAP_FMAC4 soap_get_PointerTo_ns1__UploadAdditionalInfo(struct soap *soap, _ns1__UploadAdditionalInfo **p, const char *tag, const char *type)
{
    if ((p = soap_in_PointerTo_ns1__UploadAdditionalInfo(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__UploadFullDumpResponse(struct soap *soap, _ns1__UploadFullDumpResponse *const*a)
{
#ifndef WITH_NOIDREF
    if (!soap_reference(soap, *a, SOAP_TYPE__ns1__UploadFullDumpResponse))
        (*a)->soap_serialize(soap);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__UploadFullDumpResponse(struct soap *soap, const char *tag, int id, _ns1__UploadFullDumpResponse *const*a, const char *type)
{
    id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__UploadFullDumpResponse);
    if (id < 0)
        return soap->error;
    return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _ns1__UploadFullDumpResponse ** SOAP_FMAC4 soap_in_PointerTo_ns1__UploadFullDumpResponse(struct soap *soap, const char *tag, _ns1__UploadFullDumpResponse **a, const char *type)
{
    if (soap_element_begin_in(soap, tag, 1, NULL))
        return NULL;
    if (!a)
        if (!(a = (_ns1__UploadFullDumpResponse **)soap_malloc(soap, sizeof(_ns1__UploadFullDumpResponse *))))
            return NULL;
    *a = NULL;
    if (!soap->null && *soap->href != '#')
    {   soap_revert(soap);
        if (!(*a = (_ns1__UploadFullDumpResponse *)soap_instantiate__ns1__UploadFullDumpResponse(soap, -1, soap->type, soap->arrayType, NULL)))
            return NULL;
        (*a)->soap_default(soap);
        if (!(*a)->soap_in(soap, tag, NULL))
            return NULL;
    }
    else
    {   _ns1__UploadFullDumpResponse ** p = (_ns1__UploadFullDumpResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__UploadFullDumpResponse, sizeof(_ns1__UploadFullDumpResponse), 0);
        a = p;
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__UploadFullDumpResponse(struct soap *soap, _ns1__UploadFullDumpResponse *const*a, const char *tag, const char *type)
{
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__UploadFullDumpResponse);
    if (soap_out_PointerTo_ns1__UploadFullDumpResponse(soap, tag?tag:"ns1:UploadFullDumpResponse", id, a, type))
        return soap->error;
    return soap_putindependent(soap);
}

SOAP_FMAC3 _ns1__UploadFullDumpResponse ** SOAP_FMAC4 soap_get_PointerTo_ns1__UploadFullDumpResponse(struct soap *soap, _ns1__UploadFullDumpResponse **p, const char *tag, const char *type)
{
    if ((p = soap_in_PointerTo_ns1__UploadFullDumpResponse(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__UploadFullDump(struct soap *soap, _ns1__UploadFullDump *const*a)
{
#ifndef WITH_NOIDREF
    if (!soap_reference(soap, *a, SOAP_TYPE__ns1__UploadFullDump))
        (*a)->soap_serialize(soap);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__UploadFullDump(struct soap *soap, const char *tag, int id, _ns1__UploadFullDump *const*a, const char *type)
{
    id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__UploadFullDump);
    if (id < 0)
        return soap->error;
    return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _ns1__UploadFullDump ** SOAP_FMAC4 soap_in_PointerTo_ns1__UploadFullDump(struct soap *soap, const char *tag, _ns1__UploadFullDump **a, const char *type)
{
    if (soap_element_begin_in(soap, tag, 1, NULL))
        return NULL;
    if (!a)
        if (!(a = (_ns1__UploadFullDump **)soap_malloc(soap, sizeof(_ns1__UploadFullDump *))))
            return NULL;
    *a = NULL;
    if (!soap->null && *soap->href != '#')
    {   soap_revert(soap);
        if (!(*a = (_ns1__UploadFullDump *)soap_instantiate__ns1__UploadFullDump(soap, -1, soap->type, soap->arrayType, NULL)))
            return NULL;
        (*a)->soap_default(soap);
        if (!(*a)->soap_in(soap, tag, NULL))
            return NULL;
    }
    else
    {   _ns1__UploadFullDump ** p = (_ns1__UploadFullDump **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__UploadFullDump, sizeof(_ns1__UploadFullDump), 0);
        a = p;
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__UploadFullDump(struct soap *soap, _ns1__UploadFullDump *const*a, const char *tag, const char *type)
{
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__UploadFullDump);
    if (soap_out_PointerTo_ns1__UploadFullDump(soap, tag?tag:"ns1:UploadFullDump", id, a, type))
        return soap->error;
    return soap_putindependent(soap);
}

SOAP_FMAC3 _ns1__UploadFullDump ** SOAP_FMAC4 soap_get_PointerTo_ns1__UploadFullDump(struct soap *soap, _ns1__UploadFullDump **p, const char *tag, const char *type)
{
    if ((p = soap_in_PointerTo_ns1__UploadFullDump(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__UploadMiniDumpResponse(struct soap *soap, _ns1__UploadMiniDumpResponse *const*a)
{
#ifndef WITH_NOIDREF
    if (!soap_reference(soap, *a, SOAP_TYPE__ns1__UploadMiniDumpResponse))
        (*a)->soap_serialize(soap);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__UploadMiniDumpResponse(struct soap *soap, const char *tag, int id, _ns1__UploadMiniDumpResponse *const*a, const char *type)
{
    id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__UploadMiniDumpResponse);
    if (id < 0)
        return soap->error;
    return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _ns1__UploadMiniDumpResponse ** SOAP_FMAC4 soap_in_PointerTo_ns1__UploadMiniDumpResponse(struct soap *soap, const char *tag, _ns1__UploadMiniDumpResponse **a, const char *type)
{
    if (soap_element_begin_in(soap, tag, 1, NULL))
        return NULL;
    if (!a)
        if (!(a = (_ns1__UploadMiniDumpResponse **)soap_malloc(soap, sizeof(_ns1__UploadMiniDumpResponse *))))
            return NULL;
    *a = NULL;
    if (!soap->null && *soap->href != '#')
    {   soap_revert(soap);
        if (!(*a = (_ns1__UploadMiniDumpResponse *)soap_instantiate__ns1__UploadMiniDumpResponse(soap, -1, soap->type, soap->arrayType, NULL)))
            return NULL;
        (*a)->soap_default(soap);
        if (!(*a)->soap_in(soap, tag, NULL))
            return NULL;
    }
    else
    {   _ns1__UploadMiniDumpResponse ** p = (_ns1__UploadMiniDumpResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__UploadMiniDumpResponse, sizeof(_ns1__UploadMiniDumpResponse), 0);
        a = p;
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__UploadMiniDumpResponse(struct soap *soap, _ns1__UploadMiniDumpResponse *const*a, const char *tag, const char *type)
{
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__UploadMiniDumpResponse);
    if (soap_out_PointerTo_ns1__UploadMiniDumpResponse(soap, tag?tag:"ns1:UploadMiniDumpResponse", id, a, type))
        return soap->error;
    return soap_putindependent(soap);
}

SOAP_FMAC3 _ns1__UploadMiniDumpResponse ** SOAP_FMAC4 soap_get_PointerTo_ns1__UploadMiniDumpResponse(struct soap *soap, _ns1__UploadMiniDumpResponse **p, const char *tag, const char *type)
{
    if ((p = soap_in_PointerTo_ns1__UploadMiniDumpResponse(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__UploadMiniDump(struct soap *soap, _ns1__UploadMiniDump *const*a)
{
#ifndef WITH_NOIDREF
    if (!soap_reference(soap, *a, SOAP_TYPE__ns1__UploadMiniDump))
        (*a)->soap_serialize(soap);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__UploadMiniDump(struct soap *soap, const char *tag, int id, _ns1__UploadMiniDump *const*a, const char *type)
{
    id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__UploadMiniDump);
    if (id < 0)
        return soap->error;
    return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _ns1__UploadMiniDump ** SOAP_FMAC4 soap_in_PointerTo_ns1__UploadMiniDump(struct soap *soap, const char *tag, _ns1__UploadMiniDump **a, const char *type)
{
    if (soap_element_begin_in(soap, tag, 1, NULL))
        return NULL;
    if (!a)
        if (!(a = (_ns1__UploadMiniDump **)soap_malloc(soap, sizeof(_ns1__UploadMiniDump *))))
            return NULL;
    *a = NULL;
    if (!soap->null && *soap->href != '#')
    {   soap_revert(soap);
        if (!(*a = (_ns1__UploadMiniDump *)soap_instantiate__ns1__UploadMiniDump(soap, -1, soap->type, soap->arrayType, NULL)))
            return NULL;
        (*a)->soap_default(soap);
        if (!(*a)->soap_in(soap, tag, NULL))
            return NULL;
    }
    else
    {   _ns1__UploadMiniDump ** p = (_ns1__UploadMiniDump **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__UploadMiniDump, sizeof(_ns1__UploadMiniDump), 0);
        a = p;
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__UploadMiniDump(struct soap *soap, _ns1__UploadMiniDump *const*a, const char *tag, const char *type)
{
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__UploadMiniDump);
    if (soap_out_PointerTo_ns1__UploadMiniDump(soap, tag?tag:"ns1:UploadMiniDump", id, a, type))
        return soap->error;
    return soap_putindependent(soap);
}

SOAP_FMAC3 _ns1__UploadMiniDump ** SOAP_FMAC4 soap_get_PointerTo_ns1__UploadMiniDump(struct soap *soap, _ns1__UploadMiniDump **p, const char *tag, const char *type)
{
    if ((p = soap_in_PointerTo_ns1__UploadMiniDump(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__HelloResponse(struct soap *soap, _ns1__HelloResponse *const*a)
{
#ifndef WITH_NOIDREF
    if (!soap_reference(soap, *a, SOAP_TYPE__ns1__HelloResponse))
        (*a)->soap_serialize(soap);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__HelloResponse(struct soap *soap, const char *tag, int id, _ns1__HelloResponse *const*a, const char *type)
{
    id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__HelloResponse);
    if (id < 0)
        return soap->error;
    return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _ns1__HelloResponse ** SOAP_FMAC4 soap_in_PointerTo_ns1__HelloResponse(struct soap *soap, const char *tag, _ns1__HelloResponse **a, const char *type)
{
    if (soap_element_begin_in(soap, tag, 1, NULL))
        return NULL;
    if (!a)
        if (!(a = (_ns1__HelloResponse **)soap_malloc(soap, sizeof(_ns1__HelloResponse *))))
            return NULL;
    *a = NULL;
    if (!soap->null && *soap->href != '#')
    {   soap_revert(soap);
        if (!(*a = (_ns1__HelloResponse *)soap_instantiate__ns1__HelloResponse(soap, -1, soap->type, soap->arrayType, NULL)))
            return NULL;
        (*a)->soap_default(soap);
        if (!(*a)->soap_in(soap, tag, NULL))
            return NULL;
    }
    else
    {   _ns1__HelloResponse ** p = (_ns1__HelloResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__HelloResponse, sizeof(_ns1__HelloResponse), 0);
        a = p;
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__HelloResponse(struct soap *soap, _ns1__HelloResponse *const*a, const char *tag, const char *type)
{
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__HelloResponse);
    if (soap_out_PointerTo_ns1__HelloResponse(soap, tag?tag:"ns1:HelloResponse", id, a, type))
        return soap->error;
    return soap_putindependent(soap);
}

SOAP_FMAC3 _ns1__HelloResponse ** SOAP_FMAC4 soap_get_PointerTo_ns1__HelloResponse(struct soap *soap, _ns1__HelloResponse **p, const char *tag, const char *type)
{
    if ((p = soap_in_PointerTo_ns1__HelloResponse(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__Hello(struct soap *soap, _ns1__Hello *const*a)
{
#ifndef WITH_NOIDREF
    if (!soap_reference(soap, *a, SOAP_TYPE__ns1__Hello))
        (*a)->soap_serialize(soap);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__Hello(struct soap *soap, const char *tag, int id, _ns1__Hello *const*a, const char *type)
{
    id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__Hello);
    if (id < 0)
        return soap->error;
    return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _ns1__Hello ** SOAP_FMAC4 soap_in_PointerTo_ns1__Hello(struct soap *soap, const char *tag, _ns1__Hello **a, const char *type)
{
    if (soap_element_begin_in(soap, tag, 1, NULL))
        return NULL;
    if (!a)
        if (!(a = (_ns1__Hello **)soap_malloc(soap, sizeof(_ns1__Hello *))))
            return NULL;
    *a = NULL;
    if (!soap->null && *soap->href != '#')
    {   soap_revert(soap);
        if (!(*a = (_ns1__Hello *)soap_instantiate__ns1__Hello(soap, -1, soap->type, soap->arrayType, NULL)))
            return NULL;
        (*a)->soap_default(soap);
        if (!(*a)->soap_in(soap, tag, NULL))
            return NULL;
    }
    else
    {   _ns1__Hello ** p = (_ns1__Hello **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__Hello, sizeof(_ns1__Hello), 0);
        a = p;
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__Hello(struct soap *soap, _ns1__Hello *const*a, const char *tag, const char *type)
{
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__Hello);
    if (soap_out_PointerTo_ns1__Hello(soap, tag?tag:"ns1:Hello", id, a, type))
        return soap->error;
    return soap_putindependent(soap);
}

SOAP_FMAC3 _ns1__Hello ** SOAP_FMAC4 soap_get_PointerTo_ns1__Hello(struct soap *soap, _ns1__Hello **p, const char *tag, const char *type)
{
    if ((p = soap_in_PointerTo_ns1__Hello(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTons5__ArrayOfstring(struct soap *soap, ns5__ArrayOfstring *const*a)
{
#ifndef WITH_NOIDREF
    if (!soap_reference(soap, *a, SOAP_TYPE_ns5__ArrayOfstring))
        (*a)->soap_serialize(soap);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTons5__ArrayOfstring(struct soap *soap, const char *tag, int id, ns5__ArrayOfstring *const*a, const char *type)
{
    id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ns5__ArrayOfstring);
    if (id < 0)
        return soap->error;
    return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 ns5__ArrayOfstring ** SOAP_FMAC4 soap_in_PointerTons5__ArrayOfstring(struct soap *soap, const char *tag, ns5__ArrayOfstring **a, const char *type)
{
    if (soap_element_begin_in(soap, tag, 1, NULL))
        return NULL;
    if (!a)
        if (!(a = (ns5__ArrayOfstring **)soap_malloc(soap, sizeof(ns5__ArrayOfstring *))))
            return NULL;
    *a = NULL;
    if (!soap->null && *soap->href != '#')
    {   soap_revert(soap);
        if (!(*a = (ns5__ArrayOfstring *)soap_instantiate_ns5__ArrayOfstring(soap, -1, soap->type, soap->arrayType, NULL)))
            return NULL;
        (*a)->soap_default(soap);
        if (!(*a)->soap_in(soap, tag, NULL))
            return NULL;
    }
    else
    {   ns5__ArrayOfstring ** p = (ns5__ArrayOfstring **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ns5__ArrayOfstring, sizeof(ns5__ArrayOfstring), 0);
        a = p;
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTons5__ArrayOfstring(struct soap *soap, ns5__ArrayOfstring *const*a, const char *tag, const char *type)
{
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTons5__ArrayOfstring);
    if (soap_out_PointerTons5__ArrayOfstring(soap, tag?tag:"ns5:ArrayOfstring", id, a, type))
        return soap->error;
    return soap_putindependent(soap);
}

SOAP_FMAC3 ns5__ArrayOfstring ** SOAP_FMAC4 soap_get_PointerTons5__ArrayOfstring(struct soap *soap, ns5__ArrayOfstring **p, const char *tag, const char *type)
{
    if ((p = soap_in_PointerTons5__ArrayOfstring(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTobool(struct soap *soap, bool *const*a)
{
#ifndef WITH_NOIDREF
    soap_reference(soap, *a, SOAP_TYPE_bool);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTobool(struct soap *soap, const char *tag, int id, bool *const*a, const char *type)
{
    id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_bool);
    if (id < 0)
        return soap->error;
    return soap_out_bool(soap, tag, id, *a, type);
}

SOAP_FMAC3 bool ** SOAP_FMAC4 soap_in_PointerTobool(struct soap *soap, const char *tag, bool **a, const char *type)
{
    if (soap_element_begin_in(soap, tag, 1, NULL))
        return NULL;
    if (!a)
        if (!(a = (bool **)soap_malloc(soap, sizeof(bool *))))
            return NULL;
    *a = NULL;
    if (!soap->null && *soap->href != '#')
    {   soap_revert(soap);
        if (!(*a = soap_in_bool(soap, tag, *a, type)))
            return NULL;
    }
    else
    {   a = (bool **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_bool, sizeof(bool), 0);
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTobool(struct soap *soap, bool *const*a, const char *tag, const char *type)
{
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTobool);
    if (soap_out_PointerTobool(soap, tag?tag:"boolean", id, a, type))
        return soap->error;
    return soap_putindependent(soap);
}

SOAP_FMAC3 bool ** SOAP_FMAC4 soap_get_PointerTobool(struct soap *soap, bool **p, const char *tag, const char *type)
{
    if ((p = soap_in_PointerTobool(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTons1__Response(struct soap *soap, ns1__Response *const*a)
{
#ifndef WITH_NOIDREF
    if (!soap_reference(soap, *a, SOAP_TYPE_ns1__Response))
        (*a)->soap_serialize(soap);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTons1__Response(struct soap *soap, const char *tag, int id, ns1__Response *const*a, const char *type)
{
    id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ns1__Response);
    if (id < 0)
        return soap->error;
    return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 ns1__Response ** SOAP_FMAC4 soap_in_PointerTons1__Response(struct soap *soap, const char *tag, ns1__Response **a, const char *type)
{
    if (soap_element_begin_in(soap, tag, 1, NULL))
        return NULL;
    if (!a)
        if (!(a = (ns1__Response **)soap_malloc(soap, sizeof(ns1__Response *))))
            return NULL;
    *a = NULL;
    if (!soap->null && *soap->href != '#')
    {   soap_revert(soap);
        if (!(*a = (ns1__Response *)soap_instantiate_ns1__Response(soap, -1, soap->type, soap->arrayType, NULL)))
            return NULL;
        (*a)->soap_default(soap);
        if (!(*a)->soap_in(soap, tag, NULL))
            return NULL;
    }
    else
    {   ns1__Response ** p = (ns1__Response **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ns1__Response, sizeof(ns1__Response), 0);
        if (!p && soap->error == SOAP_HREF)
        {   soap->error = SOAP_OK;
            p = (ns1__Response **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ns1__StopResponse, sizeof(ns1__StopResponse), 0);
        }
        if (!p && soap->error == SOAP_HREF)
        {   soap->error = SOAP_OK;
            p = (ns1__Response **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ns1__ErrorResponse, sizeof(ns1__ErrorResponse), 0);
        }
        if (!p && soap->error == SOAP_HREF)
        {   soap->error = SOAP_OK;
            p = (ns1__Response **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ns1__HaveSolutionResponse, sizeof(ns1__HaveSolutionResponse), 0);
        }
        if (!p && soap->error == SOAP_HREF)
        {   soap->error = SOAP_OK;
            p = (ns1__Response **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ns1__NeedSymbolsThenMiniDumpResponse, sizeof(ns1__NeedSymbolsThenMiniDumpResponse), 0);
        }
        if (!p && soap->error == SOAP_HREF)
        {   soap->error = SOAP_OK;
            p = (ns1__Response **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ns1__NeedMiniDumpResponse, sizeof(ns1__NeedMiniDumpResponse), 0);
        }
        if (!p && soap->error == SOAP_HREF)
        {   soap->error = SOAP_OK;
            p = (ns1__Response **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ns1__NeedFullDumpResponse, sizeof(ns1__NeedFullDumpResponse), 0);
        }
        if (!p && soap->error == SOAP_HREF)
        {   soap->error = SOAP_OK;
            p = (ns1__Response **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ns1__NeedMoreInfoResponse, sizeof(ns1__NeedMoreInfoResponse), 0);
        }
        a = p;
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTons1__Response(struct soap *soap, ns1__Response *const*a, const char *tag, const char *type)
{
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTons1__Response);
    if (soap_out_PointerTons1__Response(soap, tag?tag:"ns1:Response", id, a, type))
        return soap->error;
    return soap_putindependent(soap);
}

SOAP_FMAC3 ns1__Response ** SOAP_FMAC4 soap_get_PointerTons1__Response(struct soap *soap, ns1__Response **p, const char *tag, const char *type)
{
    if ((p = soap_in_PointerTons1__Response(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTons1__ArrayOfModuleSymbolInfo(struct soap *soap, ns1__ArrayOfModuleSymbolInfo *const*a)
{
#ifndef WITH_NOIDREF
    if (!soap_reference(soap, *a, SOAP_TYPE_ns1__ArrayOfModuleSymbolInfo))
        (*a)->soap_serialize(soap);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTons1__ArrayOfModuleSymbolInfo(struct soap *soap, const char *tag, int id, ns1__ArrayOfModuleSymbolInfo *const*a, const char *type)
{
    id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ns1__ArrayOfModuleSymbolInfo);
    if (id < 0)
        return soap->error;
    return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 ns1__ArrayOfModuleSymbolInfo ** SOAP_FMAC4 soap_in_PointerTons1__ArrayOfModuleSymbolInfo(struct soap *soap, const char *tag, ns1__ArrayOfModuleSymbolInfo **a, const char *type)
{
    if (soap_element_begin_in(soap, tag, 1, NULL))
        return NULL;
    if (!a)
        if (!(a = (ns1__ArrayOfModuleSymbolInfo **)soap_malloc(soap, sizeof(ns1__ArrayOfModuleSymbolInfo *))))
            return NULL;
    *a = NULL;
    if (!soap->null && *soap->href != '#')
    {   soap_revert(soap);
        if (!(*a = (ns1__ArrayOfModuleSymbolInfo *)soap_instantiate_ns1__ArrayOfModuleSymbolInfo(soap, -1, soap->type, soap->arrayType, NULL)))
            return NULL;
        (*a)->soap_default(soap);
        if (!(*a)->soap_in(soap, tag, NULL))
            return NULL;
    }
    else
    {   ns1__ArrayOfModuleSymbolInfo ** p = (ns1__ArrayOfModuleSymbolInfo **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ns1__ArrayOfModuleSymbolInfo, sizeof(ns1__ArrayOfModuleSymbolInfo), 0);
        a = p;
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTons1__ArrayOfModuleSymbolInfo(struct soap *soap, ns1__ArrayOfModuleSymbolInfo *const*a, const char *tag, const char *type)
{
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTons1__ArrayOfModuleSymbolInfo);
    if (soap_out_PointerTons1__ArrayOfModuleSymbolInfo(soap, tag?tag:"ns1:ArrayOfModuleSymbolInfo", id, a, type))
        return soap->error;
    return soap_putindependent(soap);
}

SOAP_FMAC3 ns1__ArrayOfModuleSymbolInfo ** SOAP_FMAC4 soap_get_PointerTons1__ArrayOfModuleSymbolInfo(struct soap *soap, ns1__ArrayOfModuleSymbolInfo **p, const char *tag, const char *type)
{
    if ((p = soap_in_PointerTons1__ArrayOfModuleSymbolInfo(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTons1__DumpAdditionalInfo(struct soap *soap, ns1__DumpAdditionalInfo *const*a)
{
#ifndef WITH_NOIDREF
    if (!soap_reference(soap, *a, SOAP_TYPE_ns1__DumpAdditionalInfo))
        (*a)->soap_serialize(soap);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTons1__DumpAdditionalInfo(struct soap *soap, const char *tag, int id, ns1__DumpAdditionalInfo *const*a, const char *type)
{
    id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ns1__DumpAdditionalInfo);
    if (id < 0)
        return soap->error;
    return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 ns1__DumpAdditionalInfo ** SOAP_FMAC4 soap_in_PointerTons1__DumpAdditionalInfo(struct soap *soap, const char *tag, ns1__DumpAdditionalInfo **a, const char *type)
{
    if (soap_element_begin_in(soap, tag, 1, NULL))
        return NULL;
    if (!a)
        if (!(a = (ns1__DumpAdditionalInfo **)soap_malloc(soap, sizeof(ns1__DumpAdditionalInfo *))))
            return NULL;
    *a = NULL;
    if (!soap->null && *soap->href != '#')
    {   soap_revert(soap);
        if (!(*a = (ns1__DumpAdditionalInfo *)soap_instantiate_ns1__DumpAdditionalInfo(soap, -1, soap->type, soap->arrayType, NULL)))
            return NULL;
        (*a)->soap_default(soap);
        if (!(*a)->soap_in(soap, tag, NULL))
            return NULL;
    }
    else
    {   ns1__DumpAdditionalInfo ** p = (ns1__DumpAdditionalInfo **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ns1__DumpAdditionalInfo, sizeof(ns1__DumpAdditionalInfo), 0);
        a = p;
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTons1__DumpAdditionalInfo(struct soap *soap, ns1__DumpAdditionalInfo *const*a, const char *tag, const char *type)
{
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTons1__DumpAdditionalInfo);
    if (soap_out_PointerTons1__DumpAdditionalInfo(soap, tag?tag:"ns1:DumpAdditionalInfo", id, a, type))
        return soap->error;
    return soap_putindependent(soap);
}

SOAP_FMAC3 ns1__DumpAdditionalInfo ** SOAP_FMAC4 soap_get_PointerTons1__DumpAdditionalInfo(struct soap *soap, ns1__DumpAdditionalInfo **p, const char *tag, const char *type)
{
    if ((p = soap_in_PointerTons1__DumpAdditionalInfo(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTons1__AppAdditionalInfo(struct soap *soap, ns1__AppAdditionalInfo *const*a)
{
#ifndef WITH_NOIDREF
    if (!soap_reference(soap, *a, SOAP_TYPE_ns1__AppAdditionalInfo))
        (*a)->soap_serialize(soap);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTons1__AppAdditionalInfo(struct soap *soap, const char *tag, int id, ns1__AppAdditionalInfo *const*a, const char *type)
{
    id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ns1__AppAdditionalInfo);
    if (id < 0)
        return soap->error;
    return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 ns1__AppAdditionalInfo ** SOAP_FMAC4 soap_in_PointerTons1__AppAdditionalInfo(struct soap *soap, const char *tag, ns1__AppAdditionalInfo **a, const char *type)
{
    if (soap_element_begin_in(soap, tag, 1, NULL))
        return NULL;
    if (!a)
        if (!(a = (ns1__AppAdditionalInfo **)soap_malloc(soap, sizeof(ns1__AppAdditionalInfo *))))
            return NULL;
    *a = NULL;
    if (!soap->null && *soap->href != '#')
    {   soap_revert(soap);
        if (!(*a = (ns1__AppAdditionalInfo *)soap_instantiate_ns1__AppAdditionalInfo(soap, -1, soap->type, soap->arrayType, NULL)))
            return NULL;
        (*a)->soap_default(soap);
        if (!(*a)->soap_in(soap, tag, NULL))
            return NULL;
    }
    else
    {   ns1__AppAdditionalInfo ** p = (ns1__AppAdditionalInfo **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ns1__AppAdditionalInfo, sizeof(ns1__AppAdditionalInfo), 0);
        a = p;
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTons1__AppAdditionalInfo(struct soap *soap, ns1__AppAdditionalInfo *const*a, const char *tag, const char *type)
{
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTons1__AppAdditionalInfo);
    if (soap_out_PointerTons1__AppAdditionalInfo(soap, tag?tag:"ns1:AppAdditionalInfo", id, a, type))
        return soap->error;
    return soap_putindependent(soap);
}

SOAP_FMAC3 ns1__AppAdditionalInfo ** SOAP_FMAC4 soap_get_PointerTons1__AppAdditionalInfo(struct soap *soap, ns1__AppAdditionalInfo **p, const char *tag, const char *type)
{
    if ((p = soap_in_PointerTons1__AppAdditionalInfo(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTons1__Application(struct soap *soap, ns1__Application *const*a)
{
#ifndef WITH_NOIDREF
    if (!soap_reference(soap, *a, SOAP_TYPE_ns1__Application))
        (*a)->soap_serialize(soap);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTons1__Application(struct soap *soap, const char *tag, int id, ns1__Application *const*a, const char *type)
{
    id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ns1__Application);
    if (id < 0)
        return soap->error;
    return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 ns1__Application ** SOAP_FMAC4 soap_in_PointerTons1__Application(struct soap *soap, const char *tag, ns1__Application **a, const char *type)
{
    if (soap_element_begin_in(soap, tag, 1, NULL))
        return NULL;
    if (!a)
        if (!(a = (ns1__Application **)soap_malloc(soap, sizeof(ns1__Application *))))
            return NULL;
    *a = NULL;
    if (!soap->null && *soap->href != '#')
    {   soap_revert(soap);
        if (!(*a = (ns1__Application *)soap_instantiate_ns1__Application(soap, -1, soap->type, soap->arrayType, NULL)))
            return NULL;
        (*a)->soap_default(soap);
        if (!(*a)->soap_in(soap, tag, NULL))
            return NULL;
    }
    else
    {   ns1__Application ** p = (ns1__Application **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ns1__Application, sizeof(ns1__Application), 0);
        a = p;
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTons1__Application(struct soap *soap, ns1__Application *const*a, const char *tag, const char *type)
{
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTons1__Application);
    if (soap_out_PointerTons1__Application(soap, tag?tag:"ns1:Application", id, a, type))
        return soap->error;
    return soap_putindependent(soap);
}

SOAP_FMAC3 ns1__Application ** SOAP_FMAC4 soap_get_PointerTons1__Application(struct soap *soap, ns1__Application **p, const char *tag, const char *type)
{
    if ((p = soap_in_PointerTons1__Application(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTons1__ClientLib(struct soap *soap, ns1__ClientLib *const*a)
{
#ifndef WITH_NOIDREF
    if (!soap_reference(soap, *a, SOAP_TYPE_ns1__ClientLib))
        (*a)->soap_serialize(soap);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTons1__ClientLib(struct soap *soap, const char *tag, int id, ns1__ClientLib *const*a, const char *type)
{
    id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ns1__ClientLib);
    if (id < 0)
        return soap->error;
    return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 ns1__ClientLib ** SOAP_FMAC4 soap_in_PointerTons1__ClientLib(struct soap *soap, const char *tag, ns1__ClientLib **a, const char *type)
{
    if (soap_element_begin_in(soap, tag, 1, NULL))
        return NULL;
    if (!a)
        if (!(a = (ns1__ClientLib **)soap_malloc(soap, sizeof(ns1__ClientLib *))))
            return NULL;
    *a = NULL;
    if (!soap->null && *soap->href != '#')
    {   soap_revert(soap);
        if (!(*a = (ns1__ClientLib *)soap_instantiate_ns1__ClientLib(soap, -1, soap->type, soap->arrayType, NULL)))
            return NULL;
        (*a)->soap_default(soap);
        if (!(*a)->soap_in(soap, tag, NULL))
            return NULL;
    }
    else
    {   ns1__ClientLib ** p = (ns1__ClientLib **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ns1__ClientLib, sizeof(ns1__ClientLib), 0);
        a = p;
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTons1__ClientLib(struct soap *soap, ns1__ClientLib *const*a, const char *tag, const char *type)
{
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTons1__ClientLib);
    if (soap_out_PointerTons1__ClientLib(soap, tag?tag:"ns1:ClientLib", id, a, type))
        return soap->error;
    return soap_putindependent(soap);
}

SOAP_FMAC3 ns1__ClientLib ** SOAP_FMAC4 soap_get_PointerTons1__ClientLib(struct soap *soap, ns1__ClientLib **p, const char *tag, const char *type)
{
    if ((p = soap_in_PointerTons1__ClientLib(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToint(struct soap *soap, int *const*a)
{
#ifndef WITH_NOIDREF
    soap_reference(soap, *a, SOAP_TYPE_int);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToint(struct soap *soap, const char *tag, int id, int *const*a, const char *type)
{
    id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_int);
    if (id < 0)
        return soap->error;
    return soap_out_int(soap, tag, id, *a, type);
}

SOAP_FMAC3 int ** SOAP_FMAC4 soap_in_PointerToint(struct soap *soap, const char *tag, int **a, const char *type)
{
    if (soap_element_begin_in(soap, tag, 1, NULL))
        return NULL;
    if (!a)
        if (!(a = (int **)soap_malloc(soap, sizeof(int *))))
            return NULL;
    *a = NULL;
    if (!soap->null && *soap->href != '#')
    {   soap_revert(soap);
        if (!(*a = soap_in_int(soap, tag, *a, type)))
            return NULL;
    }
    else
    {   a = (int **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_int, sizeof(int), 0);
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToint(struct soap *soap, int *const*a, const char *tag, const char *type)
{
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToint);
    if (soap_out_PointerToint(soap, tag?tag:"int", id, a, type))
        return soap->error;
    return soap_putindependent(soap);
}

SOAP_FMAC3 int ** SOAP_FMAC4 soap_get_PointerToint(struct soap *soap, int **p, const char *tag, const char *type)
{
    if ((p = soap_in_PointerToint(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_xop__Include(struct soap *soap, struct _xop__Include *const*a)
{
#ifndef WITH_NOIDREF
    if (*a)
        soap_serialize__xop__Include(soap, *a);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_xop__Include(struct soap *soap, const char *tag, int id, struct _xop__Include *const*a, const char *type)
{
    id = soap_element_id(soap, tag, id, *a, (struct soap_array*)&(*a)->__ptr, 1, type, SOAP_TYPE__xop__Include);
    if (id < 0)
        return soap->error;
    return soap_out__xop__Include(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _xop__Include ** SOAP_FMAC4 soap_in_PointerTo_xop__Include(struct soap *soap, const char *tag, struct _xop__Include **a, const char *type)
{
    if (soap_element_begin_in(soap, tag, 1, NULL))
        return NULL;
    if (!a)
        if (!(a = (struct _xop__Include **)soap_malloc(soap, sizeof(struct _xop__Include *))))
            return NULL;
    *a = NULL;
    if (!soap->null && *soap->href != '#')
    {   soap_revert(soap);
        if (!(*a = soap_in__xop__Include(soap, tag, *a, type)))
            return NULL;
    }
    else
    {   a = (struct _xop__Include **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__xop__Include, sizeof(struct _xop__Include), 0);
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_xop__Include(struct soap *soap, struct _xop__Include *const*a, const char *tag, const char *type)
{
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_xop__Include);
    if (soap_out_PointerTo_xop__Include(soap, tag?tag:"xop:Include", id, a, type))
        return soap->error;
    return soap_putindependent(soap);
}

SOAP_FMAC3 struct _xop__Include ** SOAP_FMAC4 soap_get_PointerTo_xop__Include(struct soap *soap, struct _xop__Include **p, const char *tag, const char *type)
{
    if ((p = soap_in_PointerTo_xop__Include(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTons1__Pdb70File(struct soap *soap, ns1__Pdb70File *const*a)
{
#ifndef WITH_NOIDREF
    if (!soap_reference(soap, *a, SOAP_TYPE_ns1__Pdb70File))
        (*a)->soap_serialize(soap);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTons1__Pdb70File(struct soap *soap, const char *tag, int id, ns1__Pdb70File *const*a, const char *type)
{
    id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ns1__Pdb70File);
    if (id < 0)
        return soap->error;
    return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 ns1__Pdb70File ** SOAP_FMAC4 soap_in_PointerTons1__Pdb70File(struct soap *soap, const char *tag, ns1__Pdb70File **a, const char *type)
{
    if (soap_element_begin_in(soap, tag, 1, NULL))
        return NULL;
    if (!a)
        if (!(a = (ns1__Pdb70File **)soap_malloc(soap, sizeof(ns1__Pdb70File *))))
            return NULL;
    *a = NULL;
    if (!soap->null && *soap->href != '#')
    {   soap_revert(soap);
        if (!(*a = (ns1__Pdb70File *)soap_instantiate_ns1__Pdb70File(soap, -1, soap->type, soap->arrayType, NULL)))
            return NULL;
        (*a)->soap_default(soap);
        if (!(*a)->soap_in(soap, tag, NULL))
            return NULL;
    }
    else
    {   ns1__Pdb70File ** p = (ns1__Pdb70File **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ns1__Pdb70File, sizeof(ns1__Pdb70File), 0);
        a = p;
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTons1__Pdb70File(struct soap *soap, ns1__Pdb70File *const*a, const char *tag, const char *type)
{
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTons1__Pdb70File);
    if (soap_out_PointerTons1__Pdb70File(soap, tag?tag:"ns1:Pdb70File", id, a, type))
        return soap->error;
    return soap_putindependent(soap);
}

SOAP_FMAC3 ns1__Pdb70File ** SOAP_FMAC4 soap_get_PointerTons1__Pdb70File(struct soap *soap, ns1__Pdb70File **p, const char *tag, const char *type)
{
    if ((p = soap_in_PointerTons1__Pdb70File(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTons1__ModuleSymbolInfo(struct soap *soap, ns1__ModuleSymbolInfo *const*a)
{
#ifndef WITH_NOIDREF
    if (!soap_reference(soap, *a, SOAP_TYPE_ns1__ModuleSymbolInfo))
        (*a)->soap_serialize(soap);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTons1__ModuleSymbolInfo(struct soap *soap, const char *tag, int id, ns1__ModuleSymbolInfo *const*a, const char *type)
{
    id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ns1__ModuleSymbolInfo);
    if (id < 0)
        return soap->error;
    return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 ns1__ModuleSymbolInfo ** SOAP_FMAC4 soap_in_PointerTons1__ModuleSymbolInfo(struct soap *soap, const char *tag, ns1__ModuleSymbolInfo **a, const char *type)
{
    if (soap_element_begin_in(soap, tag, 1, NULL))
        return NULL;
    if (!a)
        if (!(a = (ns1__ModuleSymbolInfo **)soap_malloc(soap, sizeof(ns1__ModuleSymbolInfo *))))
            return NULL;
    *a = NULL;
    if (!soap->null && *soap->href != '#')
    {   soap_revert(soap);
        if (!(*a = (ns1__ModuleSymbolInfo *)soap_instantiate_ns1__ModuleSymbolInfo(soap, -1, soap->type, soap->arrayType, NULL)))
            return NULL;
        (*a)->soap_default(soap);
        if (!(*a)->soap_in(soap, tag, NULL))
            return NULL;
    }
    else
    {   ns1__ModuleSymbolInfo ** p = (ns1__ModuleSymbolInfo **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ns1__ModuleSymbolInfo, sizeof(ns1__ModuleSymbolInfo), 0);
        a = p;
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTons1__ModuleSymbolInfo(struct soap *soap, ns1__ModuleSymbolInfo *const*a, const char *tag, const char *type)
{
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTons1__ModuleSymbolInfo);
    if (soap_out_PointerTons1__ModuleSymbolInfo(soap, tag?tag:"ns1:ModuleSymbolInfo", id, a, type))
        return soap->error;
    return soap_putindependent(soap);
}

SOAP_FMAC3 ns1__ModuleSymbolInfo ** SOAP_FMAC4 soap_get_PointerTons1__ModuleSymbolInfo(struct soap *soap, ns1__ModuleSymbolInfo **p, const char *tag, const char *type)
{
    if ((p = soap_in_PointerTons1__ModuleSymbolInfo(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTostd__wstring(struct soap *soap, std::wstring *const*a)
{
#ifndef WITH_NOIDREF
    if (!soap_reference(soap, *a, SOAP_TYPE_std__wstring))
        soap_serialize_std__wstring(soap, *a);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTostd__wstring(struct soap *soap, const char *tag, int id, std::wstring *const*a, const char *type)
{
    id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_std__wstring);
    if (id < 0)
        return soap->error;
    return soap_out_std__wstring(soap, tag, id, *a, type);
}

SOAP_FMAC3 std::wstring ** SOAP_FMAC4 soap_in_PointerTostd__wstring(struct soap *soap, const char *tag, std::wstring **a, const char *type)
{
    if (soap_element_begin_in(soap, tag, 1, NULL))
        return NULL;
    if (!a)
        if (!(a = (std::wstring **)soap_malloc(soap, sizeof(std::wstring *))))
            return NULL;
    *a = NULL;
    if (!soap->null && *soap->href != '#')
    {   soap_revert(soap);
        if (!(*a = soap_in_std__wstring(soap, tag, *a, type)))
            return NULL;
    }
    else
    {   a = (std::wstring **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_std__wstring, sizeof(std::wstring), 0);
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTostd__wstring(struct soap *soap, std::wstring *const*a, const char *tag, const char *type)
{
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTostd__wstring);
    if (soap_out_PointerTostd__wstring(soap, tag?tag:"string", id, a, type))
        return soap->error;
    return soap_putindependent(soap);
}

SOAP_FMAC3 std::wstring ** SOAP_FMAC4 soap_get_PointerTostd__wstring(struct soap *soap, std::wstring **p, const char *tag, const char *type)
{
    if ((p = soap_in_PointerTostd__wstring(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTounsignedByte(struct soap *soap, unsigned char *const*a)
{
#ifndef WITH_NOIDREF
    soap_reference(soap, *a, SOAP_TYPE_unsignedByte);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTounsignedByte(struct soap *soap, const char *tag, int id, unsigned char *const*a, const char *type)
{
    id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_unsignedByte);
    if (id < 0)
        return soap->error;
    return soap_out_unsignedByte(soap, tag, id, *a, type);
}

SOAP_FMAC3 unsigned char ** SOAP_FMAC4 soap_in_PointerTounsignedByte(struct soap *soap, const char *tag, unsigned char **a, const char *type)
{
    if (soap_element_begin_in(soap, tag, 1, NULL))
        return NULL;
    if (!a)
        if (!(a = (unsigned char **)soap_malloc(soap, sizeof(unsigned char *))))
            return NULL;
    *a = NULL;
    if (!soap->null && *soap->href != '#')
    {   soap_revert(soap);
        if (!(*a = soap_in_unsignedByte(soap, tag, *a, type)))
            return NULL;
    }
    else
    {   a = (unsigned char **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_unsignedByte, sizeof(unsigned char), 0);
        if (soap->body && soap_element_end_in(soap, tag))
            return NULL;
    }
    return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTounsignedByte(struct soap *soap, unsigned char *const*a, const char *tag, const char *type)
{
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTounsignedByte);
    if (soap_out_PointerTounsignedByte(soap, tag?tag:"unsignedByte", id, a, type))
        return soap->error;
    return soap_putindependent(soap);
}

SOAP_FMAC3 unsigned char ** SOAP_FMAC4 soap_get_PointerTounsignedByte(struct soap *soap, unsigned char **p, const char *tag, const char *type)
{
    if ((p = soap_in_PointerTounsignedByte(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__QName(struct soap *soap, char *const*a)
{
#ifndef WITH_NOIDREF
    soap_reference(soap, *a, SOAP_TYPE__QName);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__QName(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
    return soap_outstring(soap, tag, id, a, type, SOAP_TYPE__QName);
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in__QName(struct soap *soap, const char *tag, char **a, const char *type)
{   char **p;
    p = soap_instring(soap, tag, a, type, SOAP_TYPE__QName, 2, 0, -1);
    return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__QName(struct soap *soap, char *const*a, const char *tag, const char *type)
{
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__QName);
    if (soap_out__QName(soap, tag?tag:"byte", id, a, type))
        return soap->error;
    return soap_putindependent(soap);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get__QName(struct soap *soap, char **p, const char *tag, const char *type)
{
    if ((p = soap_in__QName(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_string(struct soap *soap, char **a)
{
    (void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_string
    *a = SOAP_DEFAULT_string;
#else
    *a = (char *)0;
#endif
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_string(struct soap *soap, char *const*a)
{
#ifndef WITH_NOIDREF
    soap_reference(soap, *a, SOAP_TYPE_string);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_string(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
    return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_string);
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_string(struct soap *soap, const char *tag, char **a, const char *type)
{   char **p;
    p = soap_instring(soap, tag, a, type, SOAP_TYPE_string, 1, 0, -1);
    return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_string(struct soap *soap, char *const*a, const char *tag, const char *type)
{
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_string);
    if (soap_out_string(soap, tag?tag:"byte", id, a, type))
        return soap->error;
    return soap_putindependent(soap);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_string(struct soap *soap, char **p, const char *tag, const char *type)
{
    if ((p = soap_in_string(soap, tag, p, type)))
        if (soap_getindependent(soap))
            return NULL;
    return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOfstd__wstring(struct soap *soap, std::vector<std::wstring >*p)
{
    p->clear();
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOfstd__wstring(struct soap *soap, const std::vector<std::wstring >*a)
{
#ifndef WITH_NOIDREF
    for (std::vector<std::wstring >::const_iterator i = a->begin(); i != a->end(); ++i)
        soap_serialize_std__wstring(soap, &(*i));
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOfstd__wstring(struct soap *soap, const char *tag, int id, const std::vector<std::wstring >*a, const char *type)
{
    for (std::vector<std::wstring >::const_iterator i = a->begin(); i != a->end(); ++i)
    {
        if (soap_out_std__wstring(soap, tag, id, &(*i), ""))
            return soap->error;
    }
    return SOAP_OK;
}

SOAP_FMAC3 std::vector<std::wstring >* SOAP_FMAC4 soap_in_std__vectorTemplateOfstd__wstring(struct soap *soap, const char *tag, std::vector<std::wstring >*a, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    short soap_flag;
    for (soap_flag = 0;; soap_flag = 1)
    {   std::wstring n;
        if (tag && *tag != '-')
        {   if (soap_element_begin_in(soap, tag, 1, NULL))
                break;
            soap_revert(soap);
        }
        soap_default_std__wstring(soap, &n);
        if (tag && *tag != '-' && (*soap->id || *soap->href))
        {   if (!soap_container_id_forward(soap, *soap->id?soap->id:soap->href, a, (size_t)a->size(), SOAP_TYPE_std__wstring, SOAP_TYPE_std__vectorTemplateOfstd__wstring, sizeof(std::wstring), 0))
                break;
            if (!soap_in_std__wstring(soap, tag, NULL, "xsd:string"))
                break;
        }
        else if (!soap_in_std__wstring(soap, tag, &n, "xsd:string"))
            break;
        if (!a && !(a = soap_new_std__vectorTemplateOfstd__wstring(soap, -1)))
            return NULL;
        soap_update_pointers(soap, (char*)&n, (char*)&n + sizeof(n), (char*)&(*a->insert(a->end(), n)), (char*)&n);
        if (!tag || *tag == '-')
            return a;
    }
    if (soap_flag && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
    {   soap->error = SOAP_OK;
        return a;
    }
    return NULL;
}

SOAP_FMAC1 std::vector<std::wstring > * SOAP_FMAC2 soap_instantiate_std__vectorTemplateOfstd__wstring(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__vectorTemplateOfstd__wstring(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__vectorTemplateOfstd__wstring, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(std::vector<std::wstring >);
        if (size)
            *size = sizeof(std::vector<std::wstring >);
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(std::vector<std::wstring >, n);
        if (size)
            *size = n * sizeof(std::vector<std::wstring >);
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (std::vector<std::wstring >*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__vectorTemplateOfstd__wstring(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::vector<std::wstring > %p -> %p\n", q, p));
    *(std::vector<std::wstring >*)p = *(std::vector<std::wstring >*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOfPointerTons1__ModuleSymbolInfo(struct soap *soap, std::vector<ns1__ModuleSymbolInfo * >*p)
{
    p->clear();
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOfPointerTons1__ModuleSymbolInfo(struct soap *soap, const std::vector<ns1__ModuleSymbolInfo * >*a)
{
#ifndef WITH_NOIDREF
    for (std::vector<ns1__ModuleSymbolInfo * >::const_iterator i = a->begin(); i != a->end(); ++i)
        soap_serialize_PointerTons1__ModuleSymbolInfo(soap, &(*i));
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOfPointerTons1__ModuleSymbolInfo(struct soap *soap, const char *tag, int id, const std::vector<ns1__ModuleSymbolInfo * >*a, const char *type)
{
    for (std::vector<ns1__ModuleSymbolInfo * >::const_iterator i = a->begin(); i != a->end(); ++i)
    {
        if (soap_out_PointerTons1__ModuleSymbolInfo(soap, tag, id, &(*i), ""))
            return soap->error;
    }
    return SOAP_OK;
}

SOAP_FMAC3 std::vector<ns1__ModuleSymbolInfo * >* SOAP_FMAC4 soap_in_std__vectorTemplateOfPointerTons1__ModuleSymbolInfo(struct soap *soap, const char *tag, std::vector<ns1__ModuleSymbolInfo * >*a, const char *type)
{
    (void)type; /* appease -Wall -Werror */
    short soap_flag;
    for (soap_flag = 0;; soap_flag = 1)
    {   ns1__ModuleSymbolInfo *n;
        if (tag && *tag != '-')
        {   if (soap_element_begin_in(soap, tag, 1, NULL))
                break;
            soap_revert(soap);
        }
        n = NULL;
        if (tag && *tag != '-' && (*soap->id || *soap->href))
        {   if (!soap_container_id_forward(soap, *soap->id?soap->id:soap->href, a, (size_t)a->size(), SOAP_TYPE_ns1__ModuleSymbolInfo, SOAP_TYPE_std__vectorTemplateOfPointerTons1__ModuleSymbolInfo, sizeof(ns1__ModuleSymbolInfo), 1))
                break;
            if (!soap_in_PointerTons1__ModuleSymbolInfo(soap, tag, NULL, "ns1:ModuleSymbolInfo"))
                break;
        }
        else if (!soap_in_PointerTons1__ModuleSymbolInfo(soap, tag, &n, "ns1:ModuleSymbolInfo"))
            break;
        if (!a && !(a = soap_new_std__vectorTemplateOfPointerTons1__ModuleSymbolInfo(soap, -1)))
            return NULL;
        a->push_back(n);
        if (!tag || *tag == '-')
            return a;
    }
    if (soap_flag && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
    {   soap->error = SOAP_OK;
        return a;
    }
    return NULL;
}

SOAP_FMAC1 std::vector<ns1__ModuleSymbolInfo * > * SOAP_FMAC2 soap_instantiate_std__vectorTemplateOfPointerTons1__ModuleSymbolInfo(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
    (void)type; (void)arrayType; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__vectorTemplateOfPointerTons1__ModuleSymbolInfo(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
    struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__vectorTemplateOfPointerTons1__ModuleSymbolInfo, n, soap_fdelete);
    if (!cp)
        return NULL;
    if (n < 0)
    {   cp->ptr = (void*)SOAP_NEW(std::vector<ns1__ModuleSymbolInfo * >);
        if (size)
            *size = sizeof(std::vector<ns1__ModuleSymbolInfo * >);
    }
    else
    {   cp->ptr = (void*)SOAP_NEW_ARRAY(std::vector<ns1__ModuleSymbolInfo * >, n);
        if (size)
            *size = n * sizeof(std::vector<ns1__ModuleSymbolInfo * >);
    }
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
    if (!cp->ptr)
        soap->error = SOAP_EOM;
    return (std::vector<ns1__ModuleSymbolInfo * >*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__vectorTemplateOfPointerTons1__ModuleSymbolInfo(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
    (void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
    DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::vector<ns1__ModuleSymbolInfo * > %p -> %p\n", q, p));
    *(std::vector<ns1__ModuleSymbolInfo * >*)p = *(std::vector<ns1__ModuleSymbolInfo * >*)q;
}

#if defined(__BORLANDC__)
#pragma option pop
#pragma option pop
#endif

/* End of soapC.cpp */
