﻿// TortoiseSVN - a Windows shell extension for easy version control

// Copyright (C) 2007, 2010, 2012, 2021 - TortoiseSVN

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software Foundation,
// 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

#pragma once

//
// registry.h
//   - Helper functions registering and unregistering a component.
//

// This function will register a component in the Registry.
// The component calls this function from its DllRegisterServer function.
HRESULT RegisterServer(HMODULE        hModule,
                       const CLSID&   clsid,
                       const wchar_t* szFriendlyName,
                       const wchar_t* szVerIndProgID,
                       const wchar_t* szProgID,
                       const CLSID&   libid);

// This function will unregister a component.  Components
// call this function from their DllUnregisterServer function.
HRESULT UnregisterServer(const CLSID&   clsid,
                         const wchar_t* szVerIndProgID,
                         const wchar_t* szProgID,
                         const CLSID&   libid);

void RegisterInterface(HMODULE        hModule,        // DLL module handle
                       const CLSID&   clsid,          // Class ID
                       const wchar_t* szFriendlyName, // Friendly Name
                       const CLSID&   libid,
                       const IID&     iid);
void UnregisterInterface(const IID& iid);

HRESULT RegisterTypeLib(HINSTANCE hInstTypeLib, LPCOLESTR lpszIndex);
HRESULT UnRegisterTypeLib(HINSTANCE hInstTypeLib, LPCOLESTR lpszIndex);
