﻿// TortoiseSVN - a Windows shell extension for easy version control

// Copyright (C) 2007, 2009-2011, 2013-2014, 2021 - TortoiseSVN

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software Foundation,
// 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
//
#include "stdafx.h"
#include "RevisionGraphCommand.h"

#include "RevisionGraph/RevisionGraphDlg.h"

bool RevisionGraphCommand::Execute()
{
    CString val    = parser.GetVal(L"pegrev");
    SVNRev  pegRev = val.IsEmpty() ? SVNRev() : SVNRev(val);

    auto dlg = std::make_unique<CRevisionGraphDlg>();
    dlg->SetPath(cmdLinePath.GetUIPathString());
    dlg->SetPegRevision(pegRev);
    if (parser.HasVal(L"output"))
    {
        dlg->SetOutputFile(parser.GetVal(L"output"));
        if (parser.HasVal(L"options"))
            dlg->SetOptions(parser.GetLongVal(L"options"));
        dlg->StartHidden();
    }
    dlg->DoModal();

    return true;
}