﻿// TortoiseSVN - a Windows shell extension for easy version control

// Copyright (C) 2003-2008, 2011-2013, 2015, 2021 - TortoiseSVN

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software Foundation,
// 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
//
#pragma once
#include "SettingsPropPage.h"
#include "registry.h"

/**
 * \ingroup TortoiseProc
 * Settings page to configure miscellaneous stuff.
 */
class CSetMisc : public ISettingsPropPage
{
    DECLARE_DYNAMIC(CSetMisc)

public:
    CSetMisc();
    ~CSetMisc() override;

    UINT GetIconID() override { return IDI_DIALOGS; }

    // Dialog Data
    enum
    {
        IDD = IDD_SETTINGSMISC
    };

protected:
    void         DoDataExchange(CDataExchange* pDX) override; // DDX/DDV support
    BOOL         OnInitDialog() override;
    BOOL         OnApply() override;
    afx_msg void OnChanged();

    DECLARE_MESSAGE_MAP()
private:
    CRegDWORD m_regUnversionedRecurse;
    BOOL      m_bUnversionedRecurse;
    CRegDWORD m_regAutocompletion;
    BOOL      m_bAutocompletion;
    CRegDWORD m_regAutocompletionTimeout;
    DWORD     m_dwAutocompletionTimeout;
    CRegDWORD m_regSpell;
    BOOL      m_bSpell;
    CRegDWORD m_regCheckRepo;
    BOOL      m_bCheckRepo;
    CRegDWORD m_regMaxHistory;
    DWORD     m_dwMaxHistory;
    CRegDWORD m_regShowLockDlg;
    BOOL      m_bShowLockDlg;
    CRegDWORD m_regAutoSelect;
    BOOL      m_bAutoSelect;
    CRegDWORD m_regIncompleteReopen;
    BOOL      m_bIncompleteReopen;
};
