/*
 * Decompiled with CFR 0.152.
 */
package com.anthonycr.grant;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.util.Log;
import com.anthonycr.grant.Permissions;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class PermissionsResultAction {
    private static final String TAG = PermissionsResultAction.class.getSimpleName();
    private final Set<String> mPermissions = new HashSet<String>(1);
    private Looper mLooper = Looper.getMainLooper();

    public PermissionsResultAction() {
    }

    public PermissionsResultAction(@NonNull Looper looper) {
        this.mLooper = looper;
    }

    public abstract void onGranted();

    public abstract void onDenied(String var1);

    public synchronized boolean shouldIgnorePermissionNotFound(String permission2) {
        Log.d((String)TAG, (String)("Permission not found: " + permission2));
        return true;
    }

    @CallSuper
    protected final synchronized boolean onResult(@NonNull String permission2, int result) {
        if (result == 0) {
            return this.onResult(permission2, Permissions.GRANTED);
        }
        return this.onResult(permission2, Permissions.DENIED);
    }

    @CallSuper
    protected final synchronized boolean onResult(final @NonNull String permission2, Permissions result) {
        this.mPermissions.remove(permission2);
        if (result == Permissions.GRANTED) {
            if (this.mPermissions.isEmpty()) {
                new Handler(this.mLooper).post(new Runnable(){

                    @Override
                    public void run() {
                        PermissionsResultAction.this.onGranted();
                    }
                });
                return true;
            }
        } else {
            if (result == Permissions.DENIED) {
                new Handler(this.mLooper).post(new Runnable(){

                    @Override
                    public void run() {
                        PermissionsResultAction.this.onDenied(permission2);
                    }
                });
                return true;
            }
            if (result == Permissions.NOT_FOUND) {
                if (this.shouldIgnorePermissionNotFound(permission2)) {
                    if (this.mPermissions.isEmpty()) {
                        new Handler(this.mLooper).post(new Runnable(){

                            @Override
                            public void run() {
                                PermissionsResultAction.this.onGranted();
                            }
                        });
                        return true;
                    }
                } else {
                    new Handler(this.mLooper).post(new Runnable(){

                        @Override
                        public void run() {
                            PermissionsResultAction.this.onDenied(permission2);
                        }
                    });
                    return true;
                }
            }
        }
        return false;
    }

    @CallSuper
    protected final synchronized void registerPermissions(@NonNull String[] perms) {
        Collections.addAll(this.mPermissions, perms);
    }
}

