/*
 * Decompiled with CFR 0.152.
 */
package com.lansosdk.LanSongFilter;

import android.graphics.PointF;
import com.lansosdk.LanSongFilter.OpenGLUtils;
import com.lansosdk.LanSongFilter.e;
import com.lansosdk.LanSongFilter.f;
import com.lansosdk.LanSongFilter.g;
import com.lansosdk.LanSongFilter.h;
import com.lansosdk.LanSongFilter.i;
import com.lansosdk.LanSongFilter.j;
import com.lansosdk.LanSongFilter.k;
import com.lansosdk.LanSongFilter.l;
import com.lansosdk.LanSongFilter.m;
import com.lansosdk.box.LSOLog;
import com.lansosdk.box.bZ;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.LinkedList;
import java.util.Scanner;

public class LanSongFilter {
    public static final String NO_FILTER_VERTEX_SHADER = "attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\nattribute vec4 inputTextureCoordinate2;\n \nvarying vec2 textureCoordinate;\nvarying vec2 textureCoordinate2;\n \nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = inputTextureCoordinate.xy;\n    textureCoordinate2 = inputTextureCoordinate2.xy;\n}";
    public static final String NO_FILTER_FRAGMENT_SHADER = "varying vec2 textureCoordinate;\nuniform sampler2D inputImageTexture2;\nuniform sampler2D inputImageTexture3;\nuniform sampler2D inputImageTexture4;\n \n uniform lowp float alphaPercent;\n uniform lowp float redPercent;\n uniform lowp float greenPercent;\n uniform lowp float bluePercent;\n\nvoid main() {\n    vec4 color = texture2D(inputImageTexture, textureCoordinate);\n    gl_FragColor=vec4(color.r*redPercent,color.g *greenPercent,color.b *bluePercent,color.a*alphaPercent);}\n";
    public static final String NO_FILTER_FRAGMENT_SHADER_YUAN = "precision mediump float;\nvarying vec2 textureCoordinate;\nuniform sampler2D inputImageTexture;\n \nvoid main() {\n    gl_FragColor = texture2D(inputImageTexture, textureCoordinate);\n}\n";
    private final LinkedList<Runnable> a;
    private final String b;
    private final String c;
    protected int grogramId = -1;
    protected int mGLAttribPosition;
    protected int mGLUniformTexture;
    protected int mGLAttribTextureCoordinate;
    protected int mOutputWidth;
    protected int mOutputHeight;
    private boolean d;
    private String e = "None";
    private Object f = new Object();
    private int g = 0;
    private long h = 0L;
    private long i = Long.MAX_VALUE;
    public boolean disableFilter = false;

    public LanSongFilter() {
        this(NO_FILTER_VERTEX_SHADER, NO_FILTER_FRAGMENT_SHADER);
    }

    public LanSongFilter(String string) {
        this(NO_FILTER_VERTEX_SHADER, NO_FILTER_FRAGMENT_SHADER);
        this.setFilterName(string);
    }

    public LanSongFilter(String string, String string2) {
        this.a = new LinkedList();
        this.b = string;
        this.c = string2;
    }

    public final void init(int n2) {
        if (this.grogramId == -1 && !this.d) {
            this.grogramId = n2;
            this.onInit(n2);
            this.onInitialized();
            this.d = true;
            return;
        }
        LSOLog.e("current filter is initialized: " + this.getClass().getName());
    }

    public final void init() {
        this.onInit();
        this.d = true;
        this.onInitialized();
    }

    public void onInit() {
        if (this.d) {
            return;
        }
        this.grogramId = this.c.equals(NO_FILTER_FRAGMENT_SHADER) ? OpenGLUtils.loadProgram(this.b, NO_FILTER_FRAGMENT_SHADER_YUAN) : OpenGLUtils.loadProgram(this.b, this.c);
        this.mGLAttribPosition = bZ.a(this.grogramId, "position");
        this.mGLUniformTexture = bZ.glGetUniformLocation((int)this.grogramId, (String)"inputImageTexture");
        this.mGLAttribTextureCoordinate = bZ.a(this.grogramId, "inputTextureCoordinate");
        this.d = true;
    }

    public long getStartTimeFromLayerUs() {
        return this.h;
    }

    public long getEndTimeFromLayerUs() {
        return this.i;
    }

    public void setTimeRangeFromLayer(long l2, long l3) {
        if (l3 > 0L && l2 >= 0L) {
            this.h = l2;
            this.i = l2 + l3;
            return;
        }
        this.cancelTimeRange();
    }

    public void cancelTimeRange() {
        this.h = 0L;
        this.i = Long.MAX_VALUE;
    }

    public int getProgramId() {
        return this.grogramId;
    }

    public void onInit(int n2) {
        this.grogramId = n2;
    }

    public boolean isInited() {
        return this.d;
    }

    public String getFragmentShader() {
        return this.c;
    }

    public String getVertexShader() {
        return this.b;
    }

    public int getProgram() {
        return this.grogramId;
    }

    protected int getLocation(String string) {
        return bZ.glGetUniformLocation((int)this.getProgram(), (String)string);
    }

    protected int getUniform(String string) {
        return bZ.glGetUniformLocation((int)this.getProgram(), (String)string);
    }

    public void onInitialized() {
        this.d = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void usedRetain() {
        Object object = this.f;
        synchronized (object) {
            ++this.g;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canDestroy() {
        Object object = this.f;
        synchronized (object) {
            if (this.g <= 0) {
                return true;
            }
            --this.g;
            return this.g == 0;
        }
    }

    public void onDestroy() {
        if (this.d) {
            bZ.glDeleteProgram((int)this.grogramId);
            this.grogramId = -1;
            this.d = false;
        }
    }

    public void onOutputSizeChanged(int n2, int n3) {
        this.mOutputWidth = n2;
        this.mOutputHeight = n3;
    }

    public void onCurrentFrameTime(long l2) {
    }

    public void onDraw(int n2, FloatBuffer floatBuffer, FloatBuffer floatBuffer2) {
        bZ.a(this.grogramId);
        this.runLayerdingOnDrawTasks();
        floatBuffer.position(0);
        bZ.glVertexAttribPointer((int)this.mGLAttribPosition, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)floatBuffer);
        bZ.l(this.mGLAttribPosition);
        floatBuffer2.position(0);
        bZ.glVertexAttribPointer((int)this.mGLAttribTextureCoordinate, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)floatBuffer2);
        bZ.l(this.mGLAttribTextureCoordinate);
        if (n2 != -1) {
            bZ.b(33984);
            bZ.b(3553, n2);
            bZ.d(this.mGLUniformTexture, 0);
        }
        this.onDrawArraysPre();
        bZ.k(4);
        bZ.d(this.mGLAttribPosition);
        bZ.d(this.mGLAttribTextureCoordinate);
        bZ.b(3553, 0);
    }

    public void onDrawArraysPre() {
    }

    public void onDrawArraysAfter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runLayerdingOnDrawTasks() {
        LinkedList<Runnable> linkedList = this.a;
        synchronized (linkedList) {
            while (!this.a.isEmpty()) {
                this.a.removeFirst().run();
            }
            return;
        }
    }

    public boolean isInitialized() {
        return this.d;
    }

    public int getOutputWidth() {
        return this.mOutputWidth;
    }

    public int getOutputHeight() {
        return this.mOutputHeight;
    }

    public int getAttribPosition() {
        return this.mGLAttribPosition;
    }

    public int getAttribTextureCoordinate() {
        return this.mGLAttribTextureCoordinate;
    }

    public int getUniformTexture() {
        return this.mGLUniformTexture;
    }

    public void setFilterName(String string) {
        this.e = string;
    }

    public String getFilterName() {
        return this.e;
    }

    protected void setInteger(int n2, int n3) {
        this.runOnDraw(new e(this, n2, n3));
    }

    protected void setFloat(int n2, float f2) {
        this.runOnDraw(new f(this, n2, f2));
    }

    protected void setFloatVec2(int n2, float[] fArray) {
        this.runOnDraw(new g(this, n2, fArray));
    }

    protected void setFloatVec3(int n2, float[] fArray) {
        this.runOnDraw(new h(this, n2, fArray));
    }

    protected void setFloatVec4(int n2, float[] fArray) {
        this.runOnDraw(new i(this, n2, fArray));
    }

    protected void setFloatArray(int n2, float[] fArray) {
        this.runOnDraw(new j(this, n2, fArray));
    }

    protected void setPoint(int n2, PointF pointF) {
        this.runOnDraw(new k(this, pointF, n2));
    }

    protected void setUniformMatrix3f(int n2, float[] fArray) {
        this.runOnDraw(new l(this, n2, fArray));
    }

    protected void setUniformMatrix4f(int n2, float[] fArray) {
        this.runOnDraw(new m(this, n2, fArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runOnDraw(Runnable runnable) {
        LinkedList<Runnable> linkedList = this.a;
        synchronized (linkedList) {
            this.a.addLast(runnable);
            return;
        }
    }

    public static String convertStreamToString(InputStream closeable) {
        if (((Scanner)(closeable = new Scanner((InputStream)closeable).useDelimiter("\\A"))).hasNext()) {
            return ((Scanner)closeable).next();
        }
        return "";
    }
}

