/*
 * Decompiled with CFR 0.152.
 */
package com.lansosdk.LanSongFilter;

import android.graphics.PointF;
import com.lansosdk.LanSongFilter.LanSongFilter;
import com.lansosdk.box.bZ;

public class LanSongGlassSphereFilter
extends LanSongFilter {
    public static final String SPHERE_FRAGMENT_SHADER = "varying highp vec2 textureCoordinate;\n\n\nuniform highp vec2 center;\nuniform highp float radius;\nuniform highp float aspectRatio;\nuniform highp float refractiveIndex;\n// uniform vec3 lightPosition;\nconst highp vec3 lightPosition = vec3(-0.5, 0.5, 1.0);\nconst highp vec3 ambientLightPosition = vec3(0.0, 0.0, 1.0);\n\nvoid main()\n{\nhighp vec2 textureCoordinateToUse = vec2(textureCoordinate.x, (textureCoordinate.y * aspectRatio + 0.5 - 0.5 * aspectRatio));\nhighp float distanceFromCenter = distance(center, textureCoordinateToUse);\nlowp float checkForPresenceWithinSphere = step(distanceFromCenter, radius);\n\ndistanceFromCenter = distanceFromCenter / radius;\n\nhighp float normalizedDepth = radius * sqrt(1.0 - distanceFromCenter * distanceFromCenter);\nhighp vec3 sphereNormal = normalize(vec3(textureCoordinateToUse - center, normalizedDepth));\n\nhighp vec3 refractedVector = 2.0 * refract(vec3(0.0, 0.0, -1.0), sphereNormal, refractiveIndex);\nrefractedVector.xy = -refractedVector.xy;\n\nhighp vec3 finalSphereColor = texture2D(inputImageTexture, (refractedVector.xy + 1.0) * 0.5).rgb;\n\n// Grazing angle lighting\nhighp float lightingIntensity = 2.5 * (1.0 - pow(clamp(dot(ambientLightPosition, sphereNormal), 0.0, 1.0), 0.25));\nfinalSphereColor += lightingIntensity;\n\n// Specular lighting\nlightingIntensity  = clamp(dot(normalize(lightPosition), sphereNormal), 0.0, 1.0);\nlightingIntensity  = pow(lightingIntensity, 15.0);\nfinalSphereColor += vec3(0.8, 0.8, 0.8) * lightingIntensity;\n\ngl_FragColor = vec4(finalSphereColor, 1.0) * checkForPresenceWithinSphere;\n}\n";
    private PointF a;
    private int b;
    private float c;
    private int d;
    private float e;
    private int f;
    private float g;
    private int h;

    public LanSongGlassSphereFilter() {
        this(new PointF(0.5f, 0.5f), 0.25f, 0.71f);
    }

    public LanSongGlassSphereFilter(PointF pointF, float f2, float f3) {
        super("attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\nattribute vec4 inputTextureCoordinate2;\n \nvarying vec2 textureCoordinate;\nvarying vec2 textureCoordinate2;\n \nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = inputTextureCoordinate.xy;\n    textureCoordinate2 = inputTextureCoordinate2.xy;\n}", SPHERE_FRAGMENT_SHADER);
        this.a = pointF;
        this.c = f2;
        this.g = f3;
    }

    @Override
    public String getFragmentShader() {
        return SPHERE_FRAGMENT_SHADER;
    }

    @Override
    public void onInit(int n2) {
        super.onInit(n2);
        this.b = bZ.glGetUniformLocation((int)this.getProgram(), (String)"center");
        this.d = bZ.glGetUniformLocation((int)this.getProgram(), (String)"radius");
        this.f = bZ.glGetUniformLocation((int)this.getProgram(), (String)"aspectRatio");
        this.h = bZ.glGetUniformLocation((int)this.getProgram(), (String)"refractiveIndex");
    }

    @Override
    public void onInit() {
        super.onInit();
        this.b = bZ.glGetUniformLocation((int)this.getProgram(), (String)"center");
        this.d = bZ.glGetUniformLocation((int)this.getProgram(), (String)"radius");
        this.f = bZ.glGetUniformLocation((int)this.getProgram(), (String)"aspectRatio");
        this.h = bZ.glGetUniformLocation((int)this.getProgram(), (String)"refractiveIndex");
    }

    @Override
    public void onInitialized() {
        super.onInitialized();
        LanSongGlassSphereFilter lanSongGlassSphereFilter = this;
        lanSongGlassSphereFilter.setRadius(lanSongGlassSphereFilter.c);
        LanSongGlassSphereFilter lanSongGlassSphereFilter2 = this;
        lanSongGlassSphereFilter2.setCenter(lanSongGlassSphereFilter2.a);
        LanSongGlassSphereFilter lanSongGlassSphereFilter3 = this;
        lanSongGlassSphereFilter3.setRefractiveIndex(lanSongGlassSphereFilter3.g);
    }

    @Override
    public void onOutputSizeChanged(int n2, int n3) {
        this.e = (float)n3 / (float)n2;
        LanSongGlassSphereFilter lanSongGlassSphereFilter = this;
        float f2 = lanSongGlassSphereFilter.e;
        LanSongGlassSphereFilter lanSongGlassSphereFilter2 = lanSongGlassSphereFilter;
        lanSongGlassSphereFilter.e = f2;
        LanSongGlassSphereFilter lanSongGlassSphereFilter3 = lanSongGlassSphereFilter2;
        lanSongGlassSphereFilter3.setFloat(lanSongGlassSphereFilter3.f, f2);
        super.onOutputSizeChanged(n2, n3);
    }

    public void setRefractiveIndex(float f2) {
        this.g = f2;
        LanSongGlassSphereFilter lanSongGlassSphereFilter = this;
        lanSongGlassSphereFilter.setFloat(lanSongGlassSphereFilter.h, f2);
    }

    public void setCenter(PointF pointF) {
        this.a = pointF;
        LanSongGlassSphereFilter lanSongGlassSphereFilter = this;
        lanSongGlassSphereFilter.setPoint(lanSongGlassSphereFilter.b, pointF);
    }

    public void setRadius(float f2) {
        this.c = f2;
        LanSongGlassSphereFilter lanSongGlassSphereFilter = this;
        lanSongGlassSphereFilter.setFloat(lanSongGlassSphereFilter.d, f2);
    }

    public PointF getCenter() {
        return this.a;
    }

    public float getRadius() {
        return this.c;
    }

    public float getRefractiveIndex() {
        return this.g;
    }
}

