/*
 * Decompiled with CFR 0.152.
 */
package com.lansosdk.LanSongFilter;

import android.graphics.Bitmap;
import com.lansosdk.LanSongFilter.LanSongFilter;
import com.lansosdk.LanSongFilter.Rotation;
import com.lansosdk.LanSongFilter.n;
import com.lansosdk.LanSongFilter.util.TextureRotationUtil;
import com.lansosdk.box.LSOLog;
import com.lansosdk.box.bZ;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.Locale;

public abstract class LanSongInstaFilter
extends LanSongFilter {
    protected static final String VERTEX_SHADER = "attribute vec4 position;\n attribute vec4 inputTextureCoordinate;\n \n varying vec2 textureCoordinate;\n \n void main()\n {\n    gl_Position = position;\n    textureCoordinate = inputTextureCoordinate.xy;\n }\n";
    protected int[] GL_TEXTURES = new int[]{33987, 33988, 33989, 33990, 33991, 33992};
    protected int textureNum;
    protected int[] coordinateAttributes;
    protected int[] inputTextureUniforms;
    protected int[] sourceTextures;
    protected ByteBuffer[] coordinatesBuffers;
    protected Bitmap[] bitmaps;
    private String a;

    public LanSongInstaFilter(String string, int n2) {
        this(VERTEX_SHADER, string, n2);
    }

    public LanSongInstaFilter(String string, String string2, int n2) {
        super(string, string2);
        this.a = string2;
        this.textureNum = n2;
        this.coordinateAttributes = new int[this.textureNum];
        this.inputTextureUniforms = new int[this.textureNum];
        this.sourceTextures = new int[this.textureNum];
        for (int i2 = 0; i2 < this.textureNum; ++i2) {
            this.sourceTextures[i2] = -1;
        }
        this.coordinatesBuffers = new ByteBuffer[this.textureNum];
        this.bitmaps = new Bitmap[this.textureNum];
        this.setRotation(Rotation.NORMAL, false, false);
    }

    public void setRotation(Rotation object, boolean bl2, boolean bl3) {
        object = TextureRotationUtil.getRotation(object, bl2, bl3);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(32).order(ByteOrder.nativeOrder());
        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
        floatBuffer.put((float[])object);
        floatBuffer.flip();
        for (int i2 = 0; i2 < this.textureNum; ++i2) {
            this.coordinatesBuffers[i2] = byteBuffer;
        }
    }

    @Override
    public String getFragmentShader() {
        return this.a;
    }

    @Override
    public void onInit(int n2) {
        super.onInit(n2);
        for (int i2 = 0; i2 < this.textureNum; ++i2) {
            n2 = i2 + 2;
            this.coordinateAttributes[i2] = bZ.a(this.getProgram(), String.format(Locale.getDefault(), "inputTextureCoordinate%d", n2));
            this.inputTextureUniforms[i2] = bZ.glGetUniformLocation((int)this.getProgram(), (String)String.format(Locale.getDefault(), "inputImageTexture%d", n2));
            bZ.l(this.coordinateAttributes[i2]);
            if (this.bitmaps[i2] == null || this.bitmaps[i2].isRecycled()) continue;
            this.a(i2, this.bitmaps[i2]);
        }
    }

    @Override
    public void onInit() {
        super.onInit();
        for (int i2 = 0; i2 < this.textureNum; ++i2) {
            int n2 = i2 + 2;
            this.coordinateAttributes[i2] = bZ.a(this.getProgram(), String.format(Locale.getDefault(), "inputTextureCoordinate%d", n2));
            this.inputTextureUniforms[i2] = bZ.glGetUniformLocation((int)this.getProgram(), (String)String.format(Locale.getDefault(), "inputImageTexture%d", n2));
            bZ.l(this.coordinateAttributes[i2]);
            if (this.bitmaps[i2] == null || this.bitmaps[i2].isRecycled()) continue;
            this.a(i2, this.bitmaps[i2]);
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        if (this.textureNum > 0) {
            try {
                bZ.a(1, this.sourceTextures);
                for (int i2 = 0; i2 < this.textureNum; ++i2) {
                    this.sourceTextures[i2] = -1;
                }
                return;
            }
            catch (Exception exception) {
                LSOLog.e("LanSongIFFilter onDestroy error. ", exception);
            }
        }
    }

    public void setBitmap(int n2, Bitmap bitmap) {
        if (bitmap != null && bitmap.isRecycled()) {
            return;
        }
        if (bitmap == null) {
            return;
        }
        this.bitmaps[n2] = bitmap;
    }

    private void a(int n2, Bitmap bitmap) {
        if (bitmap == null || bitmap.isRecycled()) {
            return;
        }
        this.runOnDraw(new n(this, bitmap, n2));
    }

    @Override
    public void onDrawArraysPre() {
        for (int i2 = 0; i2 < this.textureNum; ++i2) {
            bZ.l(this.coordinateAttributes[i2]);
            bZ.b(this.GL_TEXTURES[i2]);
            bZ.b(3553, this.sourceTextures[i2]);
            bZ.d(this.inputTextureUniforms[i2], i2 + 3);
            this.coordinatesBuffers[i2].position(0);
            bZ.glVertexAttribPointer((int)this.coordinateAttributes[i2], (int)2, (int)5126, (boolean)false, (int)0, (Buffer)this.coordinatesBuffers[i2]);
        }
    }
}

