/*
 * Decompiled with CFR 0.152.
 */
package com.lansosdk.LanSongFilter;

import com.lansosdk.LanSongFilter.LanSongFilter;
import com.lansosdk.box.bZ;

public class LanSongPixelationFilter
extends LanSongFilter {
    public static final String PIXELATION_FRAGMENT_SHADER = "varying vec2 textureCoordinate;\nuniform float imageWidthFactor;\nuniform float imageHeightFactor;\nuniform float pixel;\nvoid main()\n{\n  vec2 uv  = textureCoordinate.xy;\n  float dx = pixel * imageWidthFactor;\n  float dy = pixel * imageHeightFactor;\n  vec2 coord = vec2(dx * floor(uv.x / dx), dy * floor(uv.y / dy));\n  vec3 tc = texture2D(inputImageTexture, coord).xyz;\n  gl_FragColor = vec4(tc, 1.0);\n}";
    private int a;
    private int b;
    private float c = 1.0f;
    private int d;

    public LanSongPixelationFilter() {
        super("attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\nattribute vec4 inputTextureCoordinate2;\n \nvarying vec2 textureCoordinate;\nvarying vec2 textureCoordinate2;\n \nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = inputTextureCoordinate.xy;\n    textureCoordinate2 = inputTextureCoordinate2.xy;\n}", PIXELATION_FRAGMENT_SHADER);
    }

    @Override
    public String getFragmentShader() {
        return PIXELATION_FRAGMENT_SHADER;
    }

    @Override
    public void onInit(int n2) {
        super.onInit(n2);
        this.a = bZ.glGetUniformLocation((int)this.getProgram(), (String)"imageWidthFactor");
        this.b = bZ.glGetUniformLocation((int)this.getProgram(), (String)"imageHeightFactor");
        this.d = bZ.glGetUniformLocation((int)this.getProgram(), (String)"pixel");
        LanSongPixelationFilter lanSongPixelationFilter = this;
        lanSongPixelationFilter.setPixel(lanSongPixelationFilter.c);
    }

    @Override
    public void onInit() {
        super.onInit();
        this.a = bZ.glGetUniformLocation((int)this.getProgram(), (String)"imageWidthFactor");
        this.b = bZ.glGetUniformLocation((int)this.getProgram(), (String)"imageHeightFactor");
        this.d = bZ.glGetUniformLocation((int)this.getProgram(), (String)"pixel");
        LanSongPixelationFilter lanSongPixelationFilter = this;
        lanSongPixelationFilter.setPixel(lanSongPixelationFilter.c);
    }

    @Override
    public void onOutputSizeChanged(int n2, int n3) {
        super.onOutputSizeChanged(n2, n3);
        LanSongPixelationFilter lanSongPixelationFilter = this;
        lanSongPixelationFilter.setFloat(lanSongPixelationFilter.a, 1.0f / (float)n2);
        LanSongPixelationFilter lanSongPixelationFilter2 = this;
        lanSongPixelationFilter2.setFloat(lanSongPixelationFilter2.b, 1.0f / (float)n3);
    }

    public void setPixel(float f2) {
        if (f2 >= 0.0f && f2 <= 100.0f) {
            this.c = f2;
            LanSongPixelationFilter lanSongPixelationFilter = this;
            lanSongPixelationFilter.setFloat(lanSongPixelationFilter.d, this.c);
        }
    }

    public float getPixel() {
        return this.c;
    }
}

