/*
 * Decompiled with CFR 0.152.
 */
package com.lansosdk.LanSongFilter;

import android.graphics.PointF;
import com.lansosdk.LanSongFilter.LanSongFilter;
import com.lansosdk.box.bZ;

public class LanSongSphereRefractionFilter
extends LanSongFilter {
    public static final String SPHERE_FRAGMENT_SHADER = "varying highp vec2 textureCoordinate;\n\n\nuniform highp vec2 center;\nuniform highp float radius;\nuniform highp float aspectRatio;\nuniform highp float refractiveIndex;\n\nvoid main()\n{\nhighp vec2 textureCoordinateToUse = vec2(textureCoordinate.x, (textureCoordinate.y * aspectRatio + 0.5 - 0.5 * aspectRatio));\nhighp float distanceFromCenter = distance(center, textureCoordinateToUse);\nlowp float checkForPresenceWithinSphere = step(distanceFromCenter, radius);\n\ndistanceFromCenter = distanceFromCenter / radius;\n\nhighp float normalizedDepth = radius * sqrt(1.0 - distanceFromCenter * distanceFromCenter);\nhighp vec3 sphereNormal = normalize(vec3(textureCoordinateToUse - center, normalizedDepth));\n\nhighp vec3 refractedVector = refract(vec3(0.0, 0.0, -1.0), sphereNormal, refractiveIndex);\n\ngl_FragColor = texture2D(inputImageTexture, (refractedVector.xy + 1.0) * 0.5) * checkForPresenceWithinSphere;     \n}\n";
    private PointF a;
    private int b;
    private float c;
    private int d;
    private float e;
    private int f;
    private float g;
    private int h;

    public LanSongSphereRefractionFilter() {
        this(new PointF(0.5f, 0.5f), 0.25f, 0.71f);
    }

    public LanSongSphereRefractionFilter(PointF pointF, float f2, float f3) {
        super("attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\nattribute vec4 inputTextureCoordinate2;\n \nvarying vec2 textureCoordinate;\nvarying vec2 textureCoordinate2;\n \nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = inputTextureCoordinate.xy;\n    textureCoordinate2 = inputTextureCoordinate2.xy;\n}", SPHERE_FRAGMENT_SHADER);
        this.a = pointF;
        this.c = f2;
        this.g = f3;
    }

    @Override
    public String getFragmentShader() {
        return SPHERE_FRAGMENT_SHADER;
    }

    @Override
    public void onInit(int n2) {
        super.onInit(n2);
        this.b = bZ.glGetUniformLocation((int)this.getProgram(), (String)"center");
        this.d = bZ.glGetUniformLocation((int)this.getProgram(), (String)"radius");
        this.f = bZ.glGetUniformLocation((int)this.getProgram(), (String)"aspectRatio");
        this.h = bZ.glGetUniformLocation((int)this.getProgram(), (String)"refractiveIndex");
    }

    @Override
    public void onInit() {
        super.onInit();
        this.b = bZ.glGetUniformLocation((int)this.getProgram(), (String)"center");
        this.d = bZ.glGetUniformLocation((int)this.getProgram(), (String)"radius");
        this.f = bZ.glGetUniformLocation((int)this.getProgram(), (String)"aspectRatio");
        this.h = bZ.glGetUniformLocation((int)this.getProgram(), (String)"refractiveIndex");
    }

    @Override
    public void onInitialized() {
        super.onInitialized();
        LanSongSphereRefractionFilter lanSongSphereRefractionFilter = this;
        lanSongSphereRefractionFilter.setRadius(lanSongSphereRefractionFilter.c);
        LanSongSphereRefractionFilter lanSongSphereRefractionFilter2 = this;
        lanSongSphereRefractionFilter2.setCenter(lanSongSphereRefractionFilter2.a);
        LanSongSphereRefractionFilter lanSongSphereRefractionFilter3 = this;
        lanSongSphereRefractionFilter3.setRefractiveIndex(lanSongSphereRefractionFilter3.g);
    }

    @Override
    public void onOutputSizeChanged(int n2, int n3) {
        this.e = (float)n3 / (float)n2;
        LanSongSphereRefractionFilter lanSongSphereRefractionFilter = this;
        float f2 = lanSongSphereRefractionFilter.e;
        LanSongSphereRefractionFilter lanSongSphereRefractionFilter2 = lanSongSphereRefractionFilter;
        lanSongSphereRefractionFilter.e = f2;
        LanSongSphereRefractionFilter lanSongSphereRefractionFilter3 = lanSongSphereRefractionFilter2;
        lanSongSphereRefractionFilter3.setFloat(lanSongSphereRefractionFilter3.f, f2);
        super.onOutputSizeChanged(n2, n3);
    }

    public void setRefractiveIndex(float f2) {
        this.g = f2;
        LanSongSphereRefractionFilter lanSongSphereRefractionFilter = this;
        lanSongSphereRefractionFilter.setFloat(lanSongSphereRefractionFilter.h, f2);
    }

    public void setCenter(PointF pointF) {
        this.a = pointF;
        LanSongSphereRefractionFilter lanSongSphereRefractionFilter = this;
        lanSongSphereRefractionFilter.setPoint(lanSongSphereRefractionFilter.b, pointF);
    }

    public void setRadius(float f2) {
        this.c = f2;
        LanSongSphereRefractionFilter lanSongSphereRefractionFilter = this;
        lanSongSphereRefractionFilter.setFloat(lanSongSphereRefractionFilter.d, f2);
    }

    public PointF getCenter() {
        return this.a;
    }

    public float getRadius() {
        return this.c;
    }

    public float getRefractiveIndex() {
        return this.g;
    }
}

