<!-- omit in toc -->
# Contributing to MCUViewer

First off, thanks for taking the time to contribute! ❤️

All types of contributions are encouraged and valued. Please make sure to read the relevant section before making your contribution. It will make it a lot easier for us maintainers and smooth out the experience for all involved. The community looks forward to your contributions. 🎉

> And if you like the project, but just don't have time to contribute, that's fine. There are other easy ways to support the project and show your appreciation, which we would also be very happy about:
> - Star the project
> - Tweet about it
> - Refer this project in your project's readme
> - Mention the project at local meetups and tell your friends/colleagues

## I Have a Question

> If you want to ask a question, we assume that you have read the [README file](https://github.com/klonyyy/MCUViewer/blob/devel/README.md).

Before you ask a question, it is best to search for existing [Issues](https://github.com/klonyyy/MCUViewer/issues) that might help you. In case you have found a suitable issue and still need clarification, you can write your question in this issue. It is also advisable to search the internet for answers first.

If you then still feel the need to ask a question and need clarification, we recommend to open an [Issue](https://github.com/klonyyy/MCUViewer/issues/new).

<!-- omit in toc -->
### Submitting a Bug Report

A good bug report shouldn't leave others needing to chase you up for more information. Therefore, we ask you to investigate carefully, collect information and describe the issue in detail in your report. Please complete the following steps in advance to help us fix any potential bug as fast as possible.

- Make sure that you are using the latest version.
- Determine if your bug is really a bug and not an error on your side e.g. using incompatible environment components/versions (Make sure that you have read the [README file](https://github.com/klonyyy/MCUViewer/blob/devel/README.md). 
- To see if other users have experienced (and potentially already solved) the same issue you are having, check if there is not already a bug report existing for your bug or error in the [bug tracker](https://github.com/klonyyy/MCUViewer/issues?q=label%3Abug).
- If the issue is new please open an [Issue](https://github.com/klonyyy/MCUViewer/issues/new).

<!-- omit in toc -->
### Before Submitting an Enhancement

- Make sure that you are using the latest version.
- Perform a [search](https://github.com/klonyyy/MCUViewer/issues) to see if the enhancement has already been suggested. If it has, add a comment to the existing issue instead of opening a new one.
- Find out whether your idea fits with the scope and aims of the project. It's up to you to make a strong case to convince the project's developers of the merits of this feature. Keep in mind that we want features that will be useful to the majority of our users and not just a small subset. If you're just targeting a minority of users, consider writing an add-on/plugin library.

<!-- omit in toc -->
### How Do I Submit a Good Enhancement Suggestion?

Enhancement suggestions are tracked as [GitHub issues](https://github.com/klonyyy/MCUViewer/issues).

- Use a **clear and descriptive title** for the issue to identify the suggestion.
- Provide a **step-by-step description of the suggested enhancement** in as many details as possible.
- **Describe the current behavior** and **explain which behavior you expected to see instead** and why. At this point you can also tell which alternatives do not work for you.
- You may want to **include screenshots or screen recordings** which help you demonstrate the steps or point out the part which the suggestion is related to.
- **Explain why this enhancement would be useful** to most MCUViewer users. You may also want to point out the other projects that solved it better and which could serve as inspiration.


## Styleguides

### Code Formatting
Code formatting should be done before submitting any pull requests and performed using clang-format with the .clang-format settings file from repository's main directory. 

### Commit Messages
Please adhere to the ongoing commit message convention: 
Use one of the tags: 
- **docs** - for commits to documentation, changing comments in the code etc.
- **style** - for commits that change the formatting
- **refactor** - for refactor commits (make sure no new features are introduced)
- **fix** - for commits that fix stuff
- **feature** - for completed feature that must compile without errors
- **wip** - for work in progress (for example on fixing a bug or working on a new feature)

the message should always start lower case.

example:
`fix: fixed a bug`
`refactor: refactored module XXX`

## Attribution
This guide is based on the **contributing-gen**. [Make your own](https://github.com/bttger/contributing-gen)!
