# Copyright (c) 2023-2024 Intel Corporation
#
# SPDX-License-Identifier: Apache-2.0

find_program(
  SIMICS
  NAMES simics
  NO_DEFAULT_PATH
  PATHS ENV SIMICS_PROJECT
  # Search exactly for the project's autogenerated 'trampoline' script.
  )

if(SIMICS STREQUAL SIMICS-NOTFOUND)
  message(WARNING "Simics simulator environment is not found at SIMICS_PROJECT:'$ENV{SIMICS_PROJECT}'")
else()
  message(STATUS "Found Simics: ${SIMICS}")

  zephyr_get(SIMICS_SCRIPT_PATH SYSBUILD GLOBAL)
  if(SIMICS_SCRIPT_PATH)
    set(SIMICS_SCRIPT ${SIMICS_SCRIPT_PATH})
  else()
    set(SIMICS_SCRIPT ${BOARD_DIR}/support/${BOARD}.simics)
  endif()

  get_property(SIMICS_ARGS GLOBAL PROPERTY "BOARD_EMU_ARGS_simics")

  file(REAL_PATH $ENV{SIMICS_PROJECT} simics_project_dir_real)

  add_custom_target(run_simics
    COMMAND
    ${SIMICS}
    -no-gui
    --no-win
    --batch-mode
    ${SIMICS_SCRIPT}
    ${SIMICS_ARGS}
    $ENV{SIMICS_EXTRA_ARGS}
    -e run
    WORKING_DIRECTORY ${simics_project_dir_real}
    DEPENDS ${logical_target_for_zephyr_elf}
    USES_TERMINAL
    )

endif()
