# SPDX-License-Identifier: Apache-2.0
if(NOT DEFINED ZEPHYR_BASE)
  message(FATAL_ERROR "ZEPHYR_BASE not set")
endif()

get_filename_component(generator ${CMAKE_MAKE_PROGRAM} NAME)
if(${generator} STREQUAL ninja)
  set(verbose "-v")
else()
  set(verbose "VERBOSE=1")
endif()

message("Cleaning targets:")
message("  clean     - Remove most generated files but keep configuration and backup files")
message("  pristine  - Remove all files in the build directory")
message("")
message("Kconfig targets:")
message("  menuconfig - Update .config using a console-based interface")
message("  guiconfig  - Update .config using a graphical interface")
message("")
message("Other generic targets:")
message("  all          - Build a zephyr application")
message("  run          - Build a zephyr application and run it if the board supports emulation")
message("  flash        - Run \"west flash\"")
message("  debug        - Run \"west debug\"")
message("  debugserver  - Run \"west debugserver\" (or start GDB server on port 1234 for QEMU targets)")
message("  attach       - Run \"west attach\"")
message("  pahole       - Report struct padding (requires the pahole program)")
message("  puncover     - Local web server to view RAM, ROM and stack usage (requires puncover pip module)")
message("  ram_report   - Build and create RAM usage report")
message("  rom_report   - Build and create ROM usage report")
message("  footprint    - Create JSON RAM/ROM usage report in the build directory")
message("  initlevels   - Display the initialization sequence")
message("  boards       - Display supported boards")
message("  shields      - Display supported shields")
message("  usage        - Display this text")
message("  llext-edk    - Build the Linkable Loadable Extension (LLEXT) Extension Development Kit (EDK)")
message("  help         - Display all build system targets")
message("")
message("Build flags:")
message("")
message("  ${generator} ${verbose} [targets] verbose build")
message("  cmake -DW=n   Enable extra gcc checks, n=1,2,3 where")
message("   1: warnings which may be relevant and do not occur too often")
message("   2: warnings which occur quite often but may still be relevant")
message("   3: more obscure warnings, can most likely be ignored")
message("   Multiple levels can be combined with W=12 or W=123")
