/*
 * Copyright 2025 NXP
 *
 * SPDX-License-Identifier: Apache-2.0
 */

#ifndef ZEPHYR_DRIVERS_AUDIO_DIALOG7212_H_
#define ZEPHYR_DRIVERS_AUDIO_DIALOG7212_H_

#ifdef __cplusplus
extern "C" {
#endif

/*! @brief da7212 volume setting range */
#define DIALOG7212_HP_DEFAULT_GAIN        0x2F
#define DIALOG7212_DAC_DEFAULT_GAIN       0x67

/*! @brief Status registers */
#define DIALOG7212_STATUS1             0x02
#define DIALOG7212_PLL_STATUS          0x03
#define DIALOG7212_AUX_L_GAIN_STATUS   0x04
#define DIALOG7212_AUX_R_GAIN_STATUS   0x05
#define DIALOG7212_MIC_1_GAIN_STATUS   0x06
#define DIALOG7212_MIC_2_GAIN_STATUS   0x07
#define DIALOG7212_MIXIN_L_GAIN_STATUS 0x08
#define DIALOG7212_MIXIN_R_GAIN_STATUS 0x09
#define DIALOG7212_ADC_L_GAIN_STATUS   0x0A
#define DIALOG7212_ADC_R_GAIN_STATUS   0x0B
#define DIALOG7212_DAC_L_GAIN_STATUS   0x0C
#define DIALOG7212_DAC_R_GAIN_STATUS   0x0D
#define DIALOG7212_HP_L_GAIN_STATUS    0x0E
#define DIALOG7212_HP_R_GAIN_STATUS    0x0F
#define DIALOG7212_LINE_GAIN_STATUS    0x10

/*! @brief System Initialisation Registers */
#define DIALOG7212_CIF_CTRL        0x1d
#define DIALOG7212_DIG_ROUTING_DAI 0x21
#define DIALOG7212_SR              0x22
#define DIALOG7212_REFERENCES      0x23
#define DIALOG7212_PLL_FRAC_TOP    0x24
#define DIALOG7212_PLL_FRAC_BOT    0x25
#define DIALOG7212_PLL_INTEGER     0x26
#define DIALOG7212_PLL_CTRL        0x27
#define DIALOG7212_DAI_CLK_MODE    0x28
#define DIALOG7212_DAI_CTRL        0x29
#define DIALOG7212_DIG_ROUTING_DAC 0x2A
#define DIALOG7212_ALC_CTRL1       0x2B

/*! @brief Input Gain/ Select Filter Registers */
#define DIALOG7212_AUX_L_GAIN     0x30
#define DIALOG7212_AUX_R_GAIN     0x31
#define DIALOG7212_MIXIN_L_SELECT 0x32
#define DIALOG7212_MIXIN_R_SELECT 0x33
#define DIALOG7212_MIXIN_L_GAIN   0x34
#define DIALOG7212_MIXIN_R_GAIN   0x35
#define DIALOG7212_ADC_L_GAIN     0x36
#define DIALOG7212_ADC_R_GAIN     0x37
#define DIALOG7212_ADC_FILTERS1   0x38
#define DIALOG7212_MIC_1_GAIN     0x39
#define DIALOG7212_MIC_2_GAIN     0x3A

/*! @brief Output Gain/ Select Filter Registers */
#define DIALOG7212_DAC_FILTERS5    0x40
#define DIALOG7212_DAC_FILTERS2    0x41
#define DIALOG7212_DAC_FILTERS3    0x42
#define DIALOG7212_DAC_FILTERS4    0x43
#define DIALOG7212_DAC_FILTERS1    0x44
#define DIALOG7212_DAC_L_GAIN      0x45
#define DIALOG7212_DAC_R_GAIN      0x46
#define DIALOG7212_CP_CTRL         0x47
#define DIALOG7212_HP_L_GAIN       0x48
#define DIALOG7212_HP_R_GAIN       0x49
#define DIALOG7212_LINE_GAIN       0x4A
#define DIALOG7212_MIXOUT_L_SELECT 0x4B
#define DIALOG7212_MIXOUT_R_SELECT 0x4C

/*! @brief System Controller Registers(1) */
#define DIALOG7212_SYSTEM_MODES_INPUT  0x50
#define DIALOG7212_SYSTEM_MODES_OUTPUT 0x51

/*! @brief Control Registers(2) */
#define DIALOG7212_AUX_L_CTRL    0x60
#define DIALOG7212_AUX_R_CTRL    0x61
#define DIALOG7212_MICBIAS_CTRL  0x62
#define DIALOG7212_MIC_1_CTRL    0x63
#define DIALOG7212_MIC_2_CTRL    0x64
#define DIALOG7212_MIXIN_L_CTRL  0x65
#define DIALOG7212_MIXIN_R_CTRL  0x66
#define DIALOG7212_ADC_L_CTRL    0x67
#define DIALOG7212_ADC_R_CTRL    0x68
#define DIALOG7212_DAC_L_CTRL    0x69
#define DIALOG7212_DAC_R_CTRL    0x6A
#define DIALOG7212_HP_L_CTRL     0x6B
#define DIALOG7212_HP_R_CTRL     0x6C
#define DIALOG7212_LINE_CTRL     0x6D
#define DIALOG7212_MIXOUT_L_CTRL 0x6E
#define DIALOG7212_MIXOUT_R_CTRL 0x6F

/*! @brief Configuration Registers */
#define DIALOG7212_LDO_CTRL            0x90
#define DIALOG7212_GAIN_RAMP_CTRL      0x92
#define DIALOG7212_MIC_CONFIG          0x93
#define DIALOG7212_PC_COUNT            0x94
#define DIALOG7212_CP_VOL_THRESHOLD1   0x95
#define DIALOG7212_CP_DELAY            0x96
#define DIALOG7212_CP_DETECTOR         0x97
#define DIALOG7212_DAI_OFFSET          0x98
#define DIALOG7212_DIG_CTRL            0x99
#define DIALOG7212_ALC_CTRL2           0x9A
#define DIALOG7212_ALC_CTRL3           0x9B
#define DIALOG7212_ALC_NOISE           0x9C
#define DIALOG7212_ALC_TARGET_MIN      0x9D
#define DIALOG7212_ALC_TARGET_MAX      0x9E
#define DIALOG7212_ALC_GAIN_LIMITS     0x9F
#define DIALOG7212_ALC_ANA_GAIN_LIMITS 0xA0
#define DIALOG7212_ALC_ANTICLIP_CTRL   0xA1
#define DIALOG7212_ALC_ANTICLIP_LEVEL  0xA2
#define DIALOG7212_DAC_NG_SETUP_TIME   0xAF
#define DIALOG7212_DAC_NG_OFF_THRESH   0xB0
#define DIALOG7212_DAC_NG_ON_THRESH    0xB1
#define DIALOG7212_DAC_NG_CTRL         0xB2
/* #define DIALOG7212_DAC_NG_SPARE     0xB3 */

/*! @brief Tone Generation & Beep Registers */
#define DIALOG7212_TONE_GEN_CFG1    0xB4
#define DIALOG7212_TONE_GEN_CFG2    0xB5
#define DIALOG7212_TONE_GEN_CYCLES  0xB6
#define DIALOG7212_TONE_GEN_FREQ1_L 0xB7
#define DIALOG7212_TONE_GEN_FREQ1_U 0xB8
#define DIALOG7212_TONE_GEN_FREQ2_L 0xB9
#define DIALOG7212_TONE_GEN_FREQ2_U 0xBA
#define DIALOG7212_TONE_GEN_ON_PER  0xBB
#define DIALOG7212_TONE_GEN_OFF_PER 0xBC

/*! @brief System Controller Registers(2) */
#define DIALOG7212_SYSTEM_STATUS 0xE0
#define DIALOG7212_SYSTEM_ACTIVE 0xFD

/********** Driver DA7212 Macros **********/

/*! @brief Status registers mask/shift */
/* DIALOG7212_PLL_STATUS                         0x03*/
#define DIALOG7212_PLL_STATUS_BYPASS_ACTIVE_MASK (1U << 3)
#define DIALOG7212_PLL_STATUS_MCLK_STATUS_MASK   (1U << 2)
#define DIALOG7212_PLL_STATUS_SRM_LOCK_MASK      (1U << 1)
#define DIALOG7212_PLL_STATUS_LOCK_MASK          (1U << 0)

/* DIALOG7212_AUX_L_GAIN_STATUS                  0x04*/
#define DIALOG7212_AUX_L_AMP_GAIN_STATUS_MASK  (0x3F)
#define DIALOG7212_AUX_L_AMP_GAIN_STATUS_SHIFT (0U)
#define DIALOG7212_AUX_L_AMP_GAIN_STATUS(x)    \
	((x) << DIALOG7212_AUX_L_AMP_GAIN_STATUS_SHIFT)

/* DIALOG7212_AUX_R_GAIN_STATUS                  0x05*/
#define DIALOG7212_AUX_R_AMP_GAIN_STATUS_MASK  (0x3F)
#define DIALOG7212_AUX_R_AMP_GAIN_STATUS_SHIFT (0U)
#define DIALOG7212_AUX_R_AMP_GAIN_STATUS(x)    \
	((x) << DIALOG7212_AUX_R_AMP_GAIN_STATUS_SHIFT)

/* DIALOG7212_MIC_1_GAIN_STATUS                  0x06*/
#define DIALOG7212_MIC_1_AMP_GAIN_STATUS_MASK  (0x07)
#define DIALOG7212_MIC_1_AMP_GAIN_STATUS_SHIFT (0U)
#define DIALOG7212_MIC_1_AMP_GAIN_STATUS(x)    \
	((x) << DIALOG7212_MIC_1_AMP_GAIN_STATUS_SHIFT)

/* DIALOG7212_MIC_2_GAIN_STATUS                  0x07*/
#define DIALOG7212_MIC_2_AMP_GAIN_STATUS_MASK  (0x07)
#define DIALOG7212_MIC_2_AMP_GAIN_STATUS_SHIFT (0U)
#define DIALOG7212_MIC_2_AMP_GAIN_STATUS(x)    \
	((x) << DIALOG7212_MIC_2_AMP_GAIN_STATUS_SHIFT)

/* DIALOG7212_MIXIN_L_GAIN_STATUS                0x08*/
#define DIALOG7212_MIXIN_L_AMP_GAIN_STATUS_MASK  (0x0F)
#define DIALOG7212_MIXIN_L_AMP_GAIN_STATUS_SHIFT (0U)
#define DIALOG7212_MIXIN_L_AMP_GAIN_STATUS(x)    \
	((x) << DIALOG7212_MIXIN_L_AMP_GAIN_STATUS_SHIFT)

/* DIALOG7212_MIXIN_R_GAIN_STATUS                0x09*/
#define DIALOG7212_MIXIN_R_AMP_GAIN_STATUS_MASK  (0x0F)
#define DIALOG7212_MIXIN_R_AMP_GAIN_STATUS_SHIFT (0U)
#define DIALOG7212_MIXIN_R_AMP_GAIN_STATUS(x)    \
	((x) << DIALOG7212_MIXIN_R_AMP_GAIN_STATUS_SHIFT)

/* DIALOG7212_ADC_L_GAIN_STATUS                  0x0A*/
#define DIALOG7212_ADC_L_GAIN_STATUS_MASK   (0x7F)
#define DIALOG7212_ADC_L_GAIN_STATUS_SHIFT  (0U)
#define DIALOG7212_ADC_L_GAIN_STATUS_VAL(x) \
	((x) << DIALOG7212_ADC_L_GAIN_STATUS_SHIFT)

/* DIALOG7212_ADC_R_GAIN_STATUS                  0x0B*/
#define DIALOG7212_ADC_R_GAIN_STATUS_MASK   (0x7F)
#define DIALOG7212_ADC_R_GAIN_STATUS_SHIFT  (0U)
#define DIALOG7212_ADC_R_GAIN_STATUS_VAL(x) \
	((x) << DIALOG7212_ADC_R_GAIN_STATUS_SHIFT)

/* DIALOG7212_DAC_L_GAIN_STATUS                  0x0C*/
#define DIALOG7212_DAC_L_GAIN_STATUS_MASK   (0x7F)
#define DIALOG7212_DAC_L_GAIN_STATUS_SHIFT  (0U)
#define DIALOG7212_DAC_L_GAIN_STATUS_VAL(x) \
	((x) << DIALOG7212_DAC_L_GAIN_STATUS_SHIFT)

/* DIALOG7212_DAC_R_GAIN_STATUS                  0x0D*/
#define DIALOG7212_DAC_R_GAIN_STATUS_MASK   (0x7F)
#define DIALOG7212_DAC_R_GAIN_STATUS_SHIFT  (0U)
#define DIALOG7212_DAC_R_GAIN_STATUS_VAL(x) \
	((x) << DIALOG7212_DAC_R_GAIN_STATUS_SHIFT)

/* DIALOG7212_HP_L_GAIN_STATUS                   0x0E*/
#define DIALOG7212_HP_L_AMP_GAIN_STATUS_MASK  (0x3F)
#define DIALOG7212_HP_L_AMP_GAIN_STATUS_SHIFT (0U)
#define DIALOG7212_HP_L_AMP_GAIN_STATUS(x)    \
	((x) << DIALOG7212_HP_L_AMP_GAIN_STATUS_SHIFT)

/* DIALOG7212_HP_R_GAIN_STATUS                   0x0F*/
#define DIALOG7212_HP_R_AMP_GAIN_STATUS_MASK  (0x3F)
#define DIALOG7212_HP_R_AMP_GAIN_STATUS_SHIFT (0U)
#define DIALOG7212_HP_R_AMP_GAIN_STATUS(x)    \
	((x) << DIALOG7212_HP_R_AMP_GAIN_STATUS_SHIFT)

/* DIALOG7212_LINE_GAIN_STATUS                   0x10*/
#define DIALOG7212_LINE_AMP_GAIN_STATUS_MASK  (0x3F)
#define DIALOG7212_LINE_AMP_GAIN_STATUS_SHIFT (0U)
#define DIALOG7212_LINE_AMP_GAIN_STATUS(x)    \
	((x) << DIALOG7212_LINE_AMP_GAIN_STATUS_SHIFT)

/*! @brief System Initialisation Registers mask/shift */
/* DIALOG7212_CIF_CTRL                           0x1d */
#define DIALOG7212_CIF_CTRL_CIF_REG_SOFT_RESET_MASK (1U << 7)
#define DIALOG7212_CIF_CTRL_CIF_I2C_WRITE_MODE_MASK (1U << 0)

/* DIALOG7212_DIG_ROUTING_DAI                    0x21 */
#define DIALOG7212_DIG_ROUTING_DAI_R_SRC_MASK      (0x30)
#define DIALOG7212_DIG_ROUTING_DAI_R_SRC_SHIFT     (4U)
#define DIALOG7212_DIG_ROUTING_DAI_R_SRC_ADC_LEFT  \
	(0U << DIALOG7212_DIG_ROUTING_DAI_R_SRC_SHIFT)
#define DIALOG7212_DIG_ROUTING_DAI_R_SRC_ADC_RIGHT \
	(1U << DIALOG7212_DIG_ROUTING_DAI_R_SRC_SHIFT)
#define DIALOG7212_DIG_ROUTING_DAI_R_SRC_DAI_LEFT  \
	(2U << DIALOG7212_DIG_ROUTING_DAI_R_SRC_SHIFT)
#define DIALOG7212_DIG_ROUTING_DAI_R_SRC_DAI_RIGHT \
	(3U << DIALOG7212_DIG_ROUTING_DAI_R_SRC_SHIFT)
#define DIALOG7212_DIG_ROUTING_DAI_L_SRC_MASK      (0x03)
#define DIALOG7212_DIG_ROUTING_DAI_L_SRC_SHIFT     (0U)
#define DIALOG7212_DIG_ROUTING_DAI_L_SRC_ADC_LEFT  \
	(0U << DIALOG7212_DIG_ROUTING_DAI_L_SRC_SHIFT)
#define DIALOG7212_DIG_ROUTING_DAI_L_SRC_ADC_RIGHT \
	(1U << DIALOG7212_DIG_ROUTING_DAI_L_SRC_SHIFT)
#define DIALOG7212_DIG_ROUTING_DAI_L_SRC_DAI_LEFT  \
	(2U << DIALOG7212_DIG_ROUTING_DAI_L_SRC_SHIFT)
#define DIALOG7212_DIG_ROUTING_DAI_L_SRC_DAI_RIGHT \
	(3U << DIALOG7212_DIG_ROUTING_DAI_L_SRC_SHIFT)

/* DIALOG7212_SR                                 0x22 */
#define DIALOG7212_SR_MASK      (0x0F)
#define DIALOG7212_SR_SHIFT     (0U)
#define DIALOG7212_SR_8KHZ      (1U << DIALOG7212_SR_SHIFT)
#define DIALOG7212_SR_11_025KHZ (2U << DIALOG7212_SR_SHIFT)
#define DIALOG7212_SR_12KHZ     (3U << DIALOG7212_SR_SHIFT)
#define DIALOG7212_SR_16KHZ     (5U << DIALOG7212_SR_SHIFT)
#define DIALOG7212_SR_22KHZ     (6U << DIALOG7212_SR_SHIFT)
#define DIALOG7212_SR_24KHZ     (7U << DIALOG7212_SR_SHIFT)
#define DIALOG7212_SR_32KHZ     (9U << DIALOG7212_SR_SHIFT)
#define DIALOG7212_SR_44_1KHZ   (10U << DIALOG7212_SR_SHIFT)
#define DIALOG7212_SR_48KHZ     (11U << DIALOG7212_SR_SHIFT)
#define DIALOG7212_SR_88_2KHZ   (14U << DIALOG7212_SR_SHIFT)
#define DIALOG7212_SR_96KHZ     (15U << DIALOG7212_SR_SHIFT)

/* DIALOG7212_REFERENCES                         0x23 */
#define DIALOG7212_REFERENCES_VMID_FAST_DISCHARGE_MASK (1U << 5)
#define DIALOG7212_REFERENCES_VMID_FAST_CHARGE_MASK    (1U << 4)
#define DIALOG7212_REFERENCES_BIAS_EN_MASK             (1U << 3)

/* DIALOG7212_PLL_FRAC_TOP                       0x24 */
#define DIALOG7212_PLL_FBDIV_FRAC_TOP_MASK  (0x1F)
#define DIALOG7212_PLL_FBDIV_FRAC_TOP_SHIFT (0U)
#define DIALOG7212_PLL_FBDIV_FRAC_TOP(x)    \
	((x) << DIALOG7212_PLL_FBDIV_FRAC_TOP_SHIFT)

/* DIALOG7212_PLL_FRAC_BOT                       0x25 */
#define DIALOG7212_PLL_FBDIV_FRAC_BOT_MASK  (0xFF)
#define DIALOG7212_PLL_FBDIV_FRAC_BOT_SHIFT (0U)
#define DIALOG7212_PLL_FBDIV_FRAC_BOT(x)   \
	 ((x) << DIALOG7212_PLL_FBDIV_FRAC_BOT_SHIFT)

/* DIALOG7212_PLL_INTEGER                        0x26 */
#define DIALOG7212_PLL_FBDIV_INTEGER_MASK   (0xFF)
#define DIALOG7212_PLL_FBDIV_INTEGER_SHIFT  (0U)
#define DIALOG7212_PLL_FBDIV_INTEGER_BOT(x) \
	((x) << DIALOG7212_PLL_FBDIV_INTEGER_SHIFT)
#define DIALOG7212_PLL_FBDIV_INTEGER_RESET_VALUE (0x20)

/* DIALOG7212_PLL_CTRL                           0x27 */
#define DIALOG7212_PLL_EN_MASK         (1U << 7)
#define DIALOG7212_PLL_SRM_EN_MASK     (1U << 6)
#define DIALOG7212_PLL_32K_MODE_MASK   (1U << 5)
#define DIALOG7212_PLL_MCLKSQR_EN_MASK (1U << 4)
#define DIALOG7212_PLL_INDIV_MASK      (0x06)
#define DIALOG7212_PLL_INDIV_SHIFT     (2U)
#define DIALOG7212_PLL_INDIV_2_10MHZ   (0U << DIALOG7212_PLL_INDIV_SHIFT)
#define DIALOG7212_PLL_INDIV_10_20MHZ  (1U << DIALOG7212_PLL_INDIV_SHIFT)
#define DIALOG7212_PLL_INDIV_20_40MHZ  (2U << DIALOG7212_PLL_INDIV_SHIFT)
#define DIALOG7212_PLL_INDIV_40_80MHZ  (3U << DIALOG7212_PLL_INDIV_SHIFT)

/* DIALOG7212_DAI_CLK_MODE                       0x28 */
#define DIALOG7212_DAI_CLK_EN_MASK            (1U << 7)
#define DIALOG7212_DAI_WCLK_POL_MASK          (1U << 3)
#define DIALOG7212_DAI_CLK_POL_MASK           (1U << 2)
#define DIALOG7212_DAI_BCLKS_PER_WCLK_MASK    (0x03)
#define DIALOG7212_DAI_BCLKS_PER_WCLK_SHIFT   (0U)
#define DIALOG7212_DAI_BCLKS_PER_WCLK_BCLK32  \
	(0U << DIALOG7212_DAI_BCLKS_PER_WCLK_SHIFT)
#define DIALOG7212_DAI_BCLKS_PER_WCLK_BCLK64  \
	(1U << DIALOG7212_DAI_BCLKS_PER_WCLK_SHIFT)
#define DIALOG7212_DAI_BCLKS_PER_WCLK_BCLK128 \
	(2U << DIALOG7212_DAI_BCLKS_PER_WCLK_SHIFT)
#define DIALOG7212_DAI_BCLKS_PER_WCLK_BCLK256 \
	(3U << DIALOG7212_DAI_BCLKS_PER_WCLK_SHIFT)

/* DIALOG7212_DAI_CTRL                           0x29 */
#define DIALOG7212_DAI_EN_MASK                (1U << 7)
#define DIALOG7212_DAI_OE_MASK                (1U << 6)
#define DIALOG7212_DAI_TDM_MODE_EN_MASK       (1U << 5)
#define DIALOG7212_DAI_MONO_MODE_MASK         (1U << 4)
#define DIALOG7212_DAI_WORD_LENGTH_MASK       (0xC)
#define DIALOG7212_DAI_WORD_LENGTH_SHIFT      (2U)
#define DIALOG7212_DAI_WORD_LENGTH_16B        \
	(0U << DIALOG7212_DAI_WORD_LENGTH_SHIFT)
#define DIALOG7212_DAI_WORD_LENGTH_20B        \
	(1U << DIALOG7212_DAI_WORD_LENGTH_SHIFT)
#define DIALOG7212_DAI_WORD_LENGTH_24B        \
	(2U << DIALOG7212_DAI_WORD_LENGTH_SHIFT)
#define DIALOG7212_DAI_WORD_LENGTH_32B        \
	(3U << DIALOG7212_DAI_WORD_LENGTH_SHIFT)
#define DIALOG7212_DAI_FORMAT_MASK            (0x03)
#define DIALOG7212_DAI_FORMAT_SHIFT           (0U)
#define DIALOG7212_DAI_FORMAT_I2S_MODE        \
	(0U << DIALOG7212_DAI_FORMAT_SHIFT)
#define DIALOG7212_DAI_FORMAT_LEFT_JUSTIFIED  \
	(1U << DIALOG7212_DAI_FORMAT_SHIFT)
#define DIALOG7212_DAI_FORMAT_RIGHT_JUSTIFIED \
	(2U << DIALOG7212_DAI_FORMAT_SHIFT)
#define DIALOG7212_DAI_FORMAT_DSP_MODE        \
	(3U << DIALOG7212_DAI_FORMAT_SHIFT)

/* DIALOG7212_DIG_ROUTING_DAC                    0x2A */
#define DIALOG7212_DIG_ROUTING_DAC_R_MONO_MASK        (1U << 7)
#define DIALOG7212_DIG_ROUTING_DAC_R_RSC_MASK         (0x30)
#define DIALOG7212_DIG_ROUTING_DAC_R_RSC_SHIFT        (4U)
#define DIALOG7212_DIG_ROUTING_DAC_R_RSC_ADC_L_OUTPUT \
	(0U << DIALOG7212_DIG_ROUTING_DAC_R_RSC_SHIFT)
#define DIALOG7212_DIG_ROUTING_DAC_R_RSC_ADC_R_OUTPUT \
	(1U << DIALOG7212_DIG_ROUTING_DAC_R_RSC_SHIFT)
#define DIALOG7212_DIG_ROUTING_DAC_R_RSC_DAC_L        \
	(2U << DIALOG7212_DIG_ROUTING_DAC_R_RSC_SHIFT)
#define DIALOG7212_DIG_ROUTING_DAC_R_RSC_DAC_R        \
	(3U << DIALOG7212_DIG_ROUTING_DAC_R_RSC_SHIFT)
#define DIALOG7212_DIG_ROUTING_DAC_L_MONO_MASK        (1U << 3)
#define DIALOG7212_DIG_ROUTING_DAC_L_RSC_MASK         (0x03)
#define DIALOG7212_DIG_ROUTING_DAC_L_RSC_SHIFT        (0U)
#define DIALOG7212_DIG_ROUTING_DAC_L_RSC_ADC_L_OUTPUT \
	(0U << DIALOG7212_DIG_ROUTING_DAC_L_RSC_SHIFT)
#define DIALOG7212_DIG_ROUTING_DAC_L_RSC_ADC_R_OUTPUT \
	(1U << DIALOG7212_DIG_ROUTING_DAC_L_RSC_SHIFT)
#define DIALOG7212_DIG_ROUTING_DAC_L_RSC_DAC_L        \
	(2U << DIALOG7212_DIG_ROUTING_DAC_L_RSC_SHIFT)
#define DIALOG7212_DIG_ROUTING_DAC_L_RSC_DAC_R        \
	(3U << DIALOG7212_DIG_ROUTING_DAC_L_RSC_SHIFT)

/* DIALOG7212_ALC_CTRL1                          0x2B */
#define DIALOG7212_ALC_R_EN_MASK           (1U << 7)
#define DIALOG7212_ALC_CALIB_OVERFLOW_MASK (1U << 5)
#define DIALOG7212_ALC_AUTO_CALIB_EN_MASK  (1U << 4)
#define DIALOG7212_ALC_L_EN_MASK           (1U << 3)
#define DIALOG7212_ALC_CALIB_MODE_MASK     (1U << 2)
#define DIALOG7212_ALC_SYNC_MODE_MASK      (1U << 1)
#define DIALOG7212_ALC_OFFSET_EN_MASK      (1U << 0)

/*! @brief Input Gain/ Select Filter Registers mask/shift */
/* DIALOG7212_AUX_L_GAIN                         0x30 */
#define DIALOG7212_AUX_L_AMP_GAIN_MASK  (0x3F)
#define DIALOG7212_AUX_L_AMP_GAIN_SHIFT (0U)
#define DIALOG7212_AUX_L_AMP_GAIN(x)    \
	((x) << DIALOG7212_AUX_L_AMP_GAIN_SHIFT)

/* DIALOG7212_AUX_R_GAIN                         0x31 */
#define DIALOG7212_AUX_R_AMP_GAIN_MASK  (0x3F)
#define DIALOG7212_AUX_R_AMP_GAIN_SHIFT (0U)
#define DIALOG7212_AUX_R_AMP_GAIN(x)    \
	((x) << DIALOG7212_AUX_R_AMP_GAIN_SHIFT)

/* DIALOG7212_MIXIN_L_SELECT                     0x32 */
#define DIALOG7212_MIXIN_L_SELECT_DMIC_L_EN_MASK (1U << 7)
#define DIALOG7212_MIXIN_L_SELECT_MIXING_R_MASK  (1U << 3)
#define DIALOG7212_MIXIN_L_SELECT_MIC2_SEL_MASK  (1U << 2)
#define DIALOG7212_MIXIN_L_SELECT_MIC1_SEL_MASK  (1U << 1)
#define DIALOG7212_MIXIN_L_SELECT_AUX_L_SEL_MASK (1U << 0)

/* DIALOG7212_MIXIN_R_SELECT                     0x33 */
#define DIALOG7212_MIXIN_R_SELECT_DMIC_R_EN_MASK (1U << 7)
#define DIALOG7212_MIXIN_R_SELECT_MIXING_L_MASK  (1U << 3)
#define DIALOG7212_MIXIN_R_SELECT_MIC2_SEL_MASK  (1U << 2)
#define DIALOG7212_MIXIN_R_SELECT_MIC1_SEL_MASK  (1U << 1)
#define DIALOG7212_MIXIN_R_SELECT_AUX_R_SEL_MASK (1U << 0)

/* DIALOG7212_MIXIN_L_GAIN                       0x34 */
#define DIALOG7212_MIXIN_L_AMP_GAIN_MASK  (0x0F)
#define DIALOG7212_MIXIN_L_AMP_GAIN_SHIFT (0U)
#define DIALOG7212_MIXIN_L_AMP_GAIN(x)    \
	((x) << DIALOG7212_MIXIN_L_AMP_GAIN_SHIFT)

/* DIALOG7212_MIXIN_R_GAIN                       0x35 */
#define DIALOG7212_MIXIN_R_AMP_GAIN_MASK  (0x0F)
#define DIALOG7212_MIXIN_R_AMP_GAIN_SHIFT (0U)
#define DIALOG7212_MIXIN_R_AMP_GAIN(x)    \
	((x) << DIALOG7212_MIXIN_R_AMP_GAIN_SHIFT)

/* DIALOG7212_ADC_L_GAIN                         0x36 */
#define DIALOG7212_ADC_L_DIGITAL_GAIN_MASK  (0x7F)
#define DIALOG7212_ADC_L_DIGITAL_GAIN_SHIFT (0U)
#define DIALOG7212_ADC_L_DIGITAL_GAIN(x)    \
	((x) << DIALOG7212_ADC_L_DIGITAL_GAIN_SHIFT)

/* DIALOG7212_ADC_R_GAIN                         0x37 */
#define DIALOG7212_ADC_R_DIGITAL_GAIN_MASK  (0x7F)
#define DIALOG7212_ADC_R_DIGITAL_GAIN_SHIFT (0U)
#define DIALOG7212_ADC_R_DIGITAL_GAIN(x)    \
	((x) << DIALOG7212_ADC_R_DIGITAL_GAIN_SHIFT)

/* DIALOG7212_ADC_FILTERS1                       0x38 */
#define DIALOG7212_ADC_FILTERS1_ADC_HPF_EN_MASK            (1U << 7)
#define DIALOG7212_ADC_FILTERS1_ADC_AUDIO_HPF_CORNER_MASK  (0x30)
#define DIALOG7212_ADC_FILTERS1_ADC_AUDIO_HPF_CORNER_SHIFT (5U)
#define DIALOG7212_ADC_FILTERS1_ADC_AUDIO_HPF_CORNER_2HZ   \
		(0U << DIALOG7212_ADC_FILTERS1_ADC_AUDIO_HPF_CORNER_SHIFT)
#define DIALOG7212_ADC_FILTERS1_ADC_AUDIO_HPF_CORNER_4HZ   \
		(1U << DIALOG7212_ADC_FILTERS1_ADC_AUDIO_HPF_CORNER_SHIFT)
#define DIALOG7212_ADC_FILTERS1_ADC_AUDIO_HPF_CORNER_8HZ   \
		(2U << DIALOG7212_ADC_FILTERS1_ADC_AUDIO_HPF_CORNER_SHIFT)
#define DIALOG7212_ADC_FILTERS1_ADC_AUDIO_HPF_CORNER_16HZ  \
		(3U << DIALOG7212_ADC_FILTERS1_ADC_AUDIO_HPF_CORNER_SHIFT)
#define DIALOG7212_ADC_FILTERS1_ADC_VOICE_EN_MASK          (1U << 3)
#define DIALOG7212_ADC_FILTERS1_ADC_VOICE_HPF_CORNER_MASK  (0x07)
#define DIALOG7212_ADC_FILTERS1_ADC_VOICE_HPF_CORNER_SHIFT (0U)
#define DIALOG7212_ADC_FILTERS1_ADC_VOICE_HPF_CORNER_2_5HZ \
		(0U << DIALOG7212_ADC_FILTERS1_ADC_VOICE_HPF_CORNER_SHIFT)
#define DIALOG7212_ADC_FILTERS1_ADC_VOICE_HPF_CORNER_25HZ  \
		(1U << DIALOG7212_ADC_FILTERS1_ADC_VOICE_HPF_CORNER_SHIFT)
#define DIALOG7212_ADC_FILTERS1_ADC_VOICE_HPF_CORNER_50HZ  \
		(2U << DIALOG7212_ADC_FILTERS1_ADC_VOICE_HPF_CORNER_SHIFT)
#define DIALOG7212_ADC_FILTERS1_ADC_VOICE_HPF_CORNER_100HZ \
		(3U << DIALOG7212_ADC_FILTERS1_ADC_VOICE_HPF_CORNER_SHIFT)
#define DIALOG7212_ADC_FILTERS1_ADC_VOICE_HPF_CORNER_150HZ \
		(4U << DIALOG7212_ADC_FILTERS1_ADC_VOICE_HPF_CORNER_SHIFT)
#define DIALOG7212_ADC_FILTERS1_ADC_VOICE_HPF_CORNER_200HZ \
		(5U << DIALOG7212_ADC_FILTERS1_ADC_VOICE_HPF_CORNER_SHIFT)
#define DIALOG7212_ADC_FILTERS1_ADC_VOICE_HPF_CORNER_300HZ \
		(6U << DIALOG7212_ADC_FILTERS1_ADC_VOICE_HPF_CORNER_SHIFT)
#define DIALOG7212_ADC_FILTERS1_ADC_VOICE_HPF_CORNER_400HZ \
		(7U << DIALOG7212_ADC_FILTERS1_ADC_VOICE_HPF_CORNER_SHIFT)

/* DIALOG7212_MIC_1_GAIN                         0x39 */
#define DIALOG7212_MIC_1_AMP_GAIN_MASK  (0x07)
#define DIALOG7212_MIC_1_AMP_GAIN_SHIFT (0U)
#define DIALOG7212_MIC_1_AMP_GAIN_N6DB  (0U << DIALOG7212_MIC_1_AMP_GAIN_SHIFT)
#define DIALOG7212_MIC_1_AMP_GAIN_0DB   (1U << DIALOG7212_MIC_1_AMP_GAIN_SHIFT)
#define DIALOG7212_MIC_1_AMP_GAIN_P6DB  (2U << DIALOG7212_MIC_1_AMP_GAIN_SHIFT)
#define DIALOG7212_MIC_1_AMP_GAIN_P12DB (3U << DIALOG7212_MIC_1_AMP_GAIN_SHIFT)
#define DIALOG7212_MIC_1_AMP_GAIN_P18DB (4U << DIALOG7212_MIC_1_AMP_GAIN_SHIFT)
#define DIALOG7212_MIC_1_AMP_GAIN_P24DB (5U << DIALOG7212_MIC_1_AMP_GAIN_SHIFT)
#define DIALOG7212_MIC_1_AMP_GAIN_P30DB (6U << DIALOG7212_MIC_1_AMP_GAIN_SHIFT)
#define DIALOG7212_MIC_1_AMP_GAIN_P36DB (7U << DIALOG7212_MIC_1_AMP_GAIN_SHIFT)

/* DIALOG7212_MIC_2_GAIN                         0x3A */
#define DIALOG7212_MIC_2_AMP_GAIN_MASK  (0x07)
#define DIALOG7212_MIC_2_AMP_GAIN_SHIFT (0U)
#define DIALOG7212_MIC_2_AMP_GAIN_N6DB  (0U << DIALOG7212_MIC_2_AMP_GAIN_SHIFT)
#define DIALOG7212_MIC_2_AMP_GAIN_0DB   (1U << DIALOG7212_MIC_2_AMP_GAIN_SHIFT)
#define DIALOG7212_MIC_2_AMP_GAIN_P6DB  (2U << DIALOG7212_MIC_2_AMP_GAIN_SHIFT)
#define DIALOG7212_MIC_2_AMP_GAIN_P12DB (3U << DIALOG7212_MIC_2_AMP_GAIN_SHIFT)
#define DIALOG7212_MIC_2_AMP_GAIN_P18DB (4U << DIALOG7212_MIC_2_AMP_GAIN_SHIFT)
#define DIALOG7212_MIC_2_AMP_GAIN_P24DB (5U << DIALOG7212_MIC_2_AMP_GAIN_SHIFT)
#define DIALOG7212_MIC_2_AMP_GAIN_P30DB (6U << DIALOG7212_MIC_2_AMP_GAIN_SHIFT)
#define DIALOG7212_MIC_2_AMP_GAIN_P36DB (7U << DIALOG7212_MIC_2_AMP_GAIN_SHIFT)

/*! @brief Output Gain/ Select Filter Registers mask/shift */
/* DIALOG7212_DAC_FILTERS5                       0x40 */
#define DIALOG7212_DAC_FILTERS5_SOFTMUTE_EN_MASK    (1U << 7)
#define DIALOG7212_DAC_FILTERS5_SOFTMUTE_RATE_MASK  (0x07)
#define DIALOG7212_DAC_FILTERS5_SOFTMUTE_RATE_SHIFT (4U)
#define DIALOG7212_DAC_FILTERS5_SOFTMUTE_RATE_1     \
	(0U << DIALOG7212_DAC_FILTERS5_SOFTMUTE_RATE_SHIFT)
#define DIALOG7212_DAC_FILTERS5_SOFTMUTE_RATE_2     \
	(1U << DIALOG7212_DAC_FILTERS5_SOFTMUTE_RATE_SHIFT)
#define DIALOG7212_DAC_FILTERS5_SOFTMUTE_RATE_4     \
	(2U << DIALOG7212_DAC_FILTERS5_SOFTMUTE_RATE_SHIFT)
#define DIALOG7212_DAC_FILTERS5_SOFTMUTE_RATE_8     \
	(3U << DIALOG7212_DAC_FILTERS5_SOFTMUTE_RATE_SHIFT)
#define DIALOG7212_DAC_FILTERS5_SOFTMUTE_RATE_16    \
	(4U << DIALOG7212_DAC_FILTERS5_SOFTMUTE_RATE_SHIFT)
#define DIALOG7212_DAC_FILTERS5_SOFTMUTE_RATE_32    \
	(5U << DIALOG7212_DAC_FILTERS5_SOFTMUTE_RATE_SHIFT)
#define DIALOG7212_DAC_FILTERS5_SOFTMUTE_RATE_64    \
	(6U << DIALOG7212_DAC_FILTERS5_SOFTMUTE_RATE_SHIFT)

/* DIALOG7212_DAC_FILTERS2                       0x41 */
#define DIALOG7212_DAC_FILTERS2_EQ_BAND2_MASK  (0xF0)
#define DIALOG7212_DAC_FILTERS2_EQ_BAND2_SHIFT (4U)
#define DIALOG7212_DAC_FILTERS2_EQ_BAND2(x)    \
	((x) << DIALOG7212_DAC_FILTERS2_EQ_BAND2_SHIFT)
#define DIALOG7212_DAC_FILTERS2_EQ_BAND1_MASK  (0x0F)
#define DIALOG7212_DAC_FILTERS2_EQ_BAND1_SHIFT (0U)
#define DIALOG7212_DAC_FILTERS2_EQ_BAND1(x)    \
	((x) << DIALOG7212_DAC_FILTERS2_EQ_BAND1_SHIFT)

/* DIALOG7212_DAC_FILTERS3                       0x42 */
#define DIALOG7212_DAC_FILTERS3_EQ_BAND4_MASK  (0xF0)
#define DIALOG7212_DAC_FILTERS3_EQ_BAND4_SHIFT (4U)
#define DIALOG7212_DAC_FILTERS3_EQ_BAND4(x)    \
	((x) << DIALOG7212_DAC_FILTERS3_EQ_BAND4_SHIFT)
#define DIALOG7212_DAC_FILTERS3_EQ_BAND3_MASK  (0x0F)
#define DIALOG7212_DAC_FILTERS3_EQ_BAND3_SHIFT (0U)
#define DIALOG7212_DAC_FILTERS3_EQ_BAND3(x)    \
	((x) << DIALOG7212_DAC_FILTERS3_EQ_BAND3_SHIFT)

/* DIALOG7212_DAC_FILTERS4                       0x43 */
#define DIALOG7212_DAC_FILTERS4_EQ_EN_MASK     (1U << 7)
#define DIALOG7212_DAC_FILTERS4_EQ_BAND5_MASK  (0x0F)
#define DIALOG7212_DAC_FILTERS4_EQ_BAND5_SHIFT (0U)
#define DIALOG7212_DAC_FILTERS4_EQ_BAND5(x)    \
	((x) << DIALOG7212_DAC_FILTERS4_EQ_BAND5_SHIFT)

/* DIALOG7212_DAC_FILTERS1                       0x44 */
#define DIALOG7212_DAC_FILTERS1_HPF_EN_MASK                (1U << 7)
#define DIALOG7212_DAC_FILTERS1_DAC_AUDIO_HPF_CORNER_MASK  (0x30)
#define DIALOG7212_DAC_FILTERS1_DAC_AUDIO_HPF_CORNER_SHIFT (5U)
#define DIALOG7212_DAC_FILTERS1_DAC_AUDIO_HPF_CORNER_2HZ   \
	(0U << DIALOG7212_DAC_FILTERS1_DAC_AUDIO_HPF_CORNER_SHIFT)
#define DIALOG7212_DAC_FILTERS1_DAC_AUDIO_HPF_CORNER_4HZ   \
	(1U << DIALOG7212_DAC_FILTERS1_DAC_AUDIO_HPF_CORNER_SHIFT)
#define DIALOG7212_DAC_FILTERS1_DAC_AUDIO_HPF_CORNER_8HZ   \
	(2U << DIALOG7212_DAC_FILTERS1_DAC_AUDIO_HPF_CORNER_SHIFT)
#define DIALOG7212_DAC_FILTERS1_DAC_AUDIO_HPF_CORNER_16HZ  \
	(3U << DIALOG7212_DAC_FILTERS1_DAC_AUDIO_HPF_CORNER_SHIFT)
#define DIALOG7212_DAC_FILTERS1_DAC_VOICE_EN_MASK          (1U << 3)
#define DIALOG7212_DAC_FILTERS1_DAC_VOICE_HPF_CORNER_MASK  (0x07)
#define DIALOG7212_DAC_FILTERS1_DAC_VOICE_HPF_CORNER_SHIFT (0U)
#define DIALOG7212_DAC_FILTERS1_DAC_VOICE_HPF_CORNER_2_5HZ \
	(0U << DIALOG7212_DAC_FILTERS1_DAC_VOICE_HPF_CORNER_SHIFT)
#define DIALOG7212_DAC_FILTERS1_DAC_VOICE_HPF_CORNER_25HZ  \
	(1U << DIALOG7212_DAC_FILTERS1_DAC_VOICE_HPF_CORNER_SHIFT)
#define DIALOG7212_DAC_FILTERS1_DAC_VOICE_HPF_CORNER_50HZ  \
	(2U << DIALOG7212_DAC_FILTERS1_DAC_VOICE_HPF_CORNER_SHIFT)
#define DIALOG7212_DAC_FILTERS1_DAC_VOICE_HPF_CORNER_100HZ \
	(3U << DIALOG7212_DAC_FILTERS1_DAC_VOICE_HPF_CORNER_SHIFT)
#define DIALOG7212_DAC_FILTERS1_DAC_VOICE_HPF_CORNER_150HZ \
	(4U << DIALOG7212_DAC_FILTERS1_DAC_VOICE_HPF_CORNER_SHIFT)
#define DIALOG7212_DAC_FILTERS1_DAC_VOICE_HPF_CORNER_200HZ \
	(5U << DIALOG7212_DAC_FILTERS1_DAC_VOICE_HPF_CORNER_SHIFT)
#define DIALOG7212_DAC_FILTERS1_DAC_VOICE_HPF_CORNER_300HZ \
	(6U << DIALOG7212_DAC_FILTERS1_DAC_VOICE_HPF_CORNER_SHIFT)
#define DIALOG7212_DAC_FILTERS1_DAC_VOICE_HPF_CORNER_400HZ \
	(7U << DIALOG7212_DAC_FILTERS1_DAC_VOICE_HPF_CORNER_SHIFT)

/* DIALOG7212_DAC_L_GAIN                         0x45 */
#define DIALOG7212_DAC_L_DIGITAL_GAIN_MASK  (0x7F)
#define DIALOG7212_DAC_L_DIGITAL_GAIN_SHIFT (0U)
#define DIALOG7212_DAC_L_DIGITAL_GAIN(x)    \
	((x) << DIALOG7212_DAC_L_DIGITAL_GAIN_SHIFT)

/* DIALOG7212_DAC_R_GAIN                         0x46 */
#define DIALOG7212_DAC_R_DIGITAL_GAIN_MASK  (0x7F)
#define DIALOG7212_DAC_R_DIGITAL_GAIN_SHIFT (0U)
#define DIALOG7212_DAC_R_DIGITAL_GAIN(x)    \
	((x) << DIALOG7212_DAC_R_DIGITAL_GAIN_SHIFT)

/* DIALOG7212_CP_CTRL                            0x47 */
#define DIALOG7212_CP_CTRL_EN_MASK                    (1U << 7)
#define DIALOG7212_CP_CTRL_SMALL_SWIT_CH_FREQ_EN_MASK (1U << 6)
#define DIALOG7212_CP_CTRL_MCHANGE_MASK               (0x30)
#define DIALOG7212_CP_CTRL_MCHANGE_SHIFT              (4U)
#define DIALOG7212_CP_CTRL_MCHANGE_CP_MOD             \
	(0U << DIALOG7212_CP_CTRL_MCHANGE_SHIFT)
#define DIALOG7212_CP_CTRL_MCHANGE_PGA                \
	(1U << DIALOG7212_CP_CTRL_MCHANGE_SHIFT)
#define DIALOG7212_CP_CTRL_MCHANGE_DAC                \
	(2U << DIALOG7212_CP_CTRL_MCHANGE_SHIFT)
#define DIALOG7212_CP_CTRL_MCHANGE_OUTPUT             \
	(3U << DIALOG7212_CP_CTRL_MCHANGE_SHIFT)
#define DIALOG7212_CP_CTRL_MOD_MASK                   (0x0C)
#define DIALOG7212_CP_CTRL_MOD_SHIFT                  (2U)
#define DIALOG7212_CP_CTRL_MOD_STANDBY                \
	(0U << DIALOG7212_CP_CTRL_MOD_SHIFT)
#define DIALOG7212_CP_CTRL_MOD_CPVDD_2                \
	(2U << DIALOG7212_CP_CTRL_MOD_SHIFT)
#define DIALOG7212_CP_CTRL_MOD_CPVDD_1                \
	(3U << DIALOG7212_CP_CTRL_MOD_SHIFT)
#define DIALOG7212_CP_CTRL_ANALOG_VLL_MASK            (0x03)
#define DIALOG7212_CP_CTRL_ANALOG_VLL_SHIFT           (0U)
#define DIALOG7212_CP_CTRL_ANALOG_VLL_NO_FEEDBACK     \
	(0U << DIALOG7212_CP_CTRL_ANALOG_VLL_SHIFT)
#define DIALOG7212_CP_CTRL_ANALOG_VLL_LV_BOOSTS_CP    \
	(1U << DIALOG7212_CP_CTRL_ANALOG_VLL_SHIFT)
#define DIALOG7212_CP_CTRL_ANALOG_VLL_LV_RESTART_CP   \
	(2U << DIALOG7212_CP_CTRL_ANALOG_VLL_SHIFT)

/* DIALOG7212_HP_L_GAIN                          0x48 */
#define DIALOG7212_HP_L_AMP_GAIN_MASK  (0x3F)
#define DIALOG7212_HP_L_AMP_GAIN_SHIFT (0U)
#define DIALOG7212_HP_L_AMP_GAIN(x)    \
	((x) << DIALOG7212_HP_L_AMP_GAIN_SHIFT)

/* DIALOG7212_HP_R_GAIN                          0x49 */
#define DIALOG7212_HP_R_AMP_GAIN_MASK  (0x3F)
#define DIALOG7212_HP_R_AMP_GAIN_SHIFT (0U)
#define DIALOG7212_HP_R_AMP_GAIN(x)    \
	((x) << DIALOG7212_HP_R_AMP_GAIN_SHIFT)

/* DIALOG7212_LINE_GAIN                          0x4A */
#define DIALOG7212_LINE_AMP_GAIN_MASK  (0x3F)
#define DIALOG7212_LINE_AMP_GAIN_SHIFT (0U)
#define DIALOG7212_LINE_AMP_GAIN(x)    \
	((x) << DIALOG7212_LINE_AMP_GAIN_SHIFT)

/* DIALOG7212_MIXOUT_L_SELECT                    0x4B */
#define DIALOG7212_MIXOUT_L_SELECT_MIXIN_R_INV_MASK (1U << 6)
#define DIALOG7212_MIXOUT_L_SELECT_MIXIN_L_INV_MASK (1U << 5)
#define DIALOG7212_MIXOUT_L_SELECT_AUX_L_INV_MASK   (1U << 4)
#define DIALOG7212_MIXOUT_L_SELECT_DAC_L_MASK       (1U << 3)
#define DIALOG7212_MIXOUT_L_SELECT_MIXIN_R_MASK     (1U << 2)
#define DIALOG7212_MIXOUT_L_SELECT_MIXIN_L_MASK     (1U << 1)
#define DIALOG7212_MIXOUT_L_SELECT_AUX_L_MASK       (1U << 0)

/* DIALOG7212_MIXOUT_R_SELECT                    0x4C */
#define DIALOG7212_MIXOUT_R_SELECT_MIXIN_L_INV_MASK (1U << 6)
#define DIALOG7212_MIXOUT_R_SELECT_MIXIN_R_INV_MASK (1U << 5)
#define DIALOG7212_MIXOUT_R_SELECT_AUX_R_INV_MASK   (1U << 4)
#define DIALOG7212_MIXOUT_R_SELECT_DAC_R_MASK       (1U << 3)
#define DIALOG7212_MIXOUT_R_SELECT_MIXIN_L_MASK     (1U << 2)
#define DIALOG7212_MIXOUT_R_SELECT_MIXIN_R_MASK     (1U << 1)
#define DIALOG7212_MIXOUT_R_SELECT_AUX_R_MASK       (1U << 0)

/*! @brief System Controller Registers(1) mask/shift */
/* DIALOG7212_SYSTEM_MODES_INPUT                 0x50 */
#define DIALOG7212_SYSTEM_MODES_INPUT_ADC_R_MASK       (1U << 7)
#define DIALOG7212_SYSTEM_MODES_INPUT_ADC_L_MASK       (1U << 6)
#define DIALOG7212_SYSTEM_MODES_INPUT_MIXIN_R_MASK     (1U << 5)
#define DIALOG7212_SYSTEM_MODES_INPUT_MIXIN_L_MASK     (1U << 4)
#define DIALOG7212_SYSTEM_MODES_INPUT_MIC_2_MASK       (1U << 3)
#define DIALOG7212_SYSTEM_MODES_INPUT_MIC_1_MASK       (1U << 2)
#define DIALOG7212_SYSTEM_MODES_INPUT_MIC_BIAS_MASK    (1U << 1)
#define DIALOG7212_SYSTEM_MODES_INPUT_MODE_SUBMIT_MASK (1U << 0)

/* DIALOG7212_SYSTEM_MODES_OUTPUT                0x51 */
#define DIALOG7212_SYSTEM_MODES_OUTPUT_DAC_R_MASK       (1U << 7)
#define DIALOG7212_SYSTEM_MODES_OUTPUT_DAC_L_MASK       (1U << 6)
#define DIALOG7212_SYSTEM_MODES_OUTPUT_HP_R_MASK        (1U << 5)
#define DIALOG7212_SYSTEM_MODES_OUTPUT_HP_L_MASK        (1U << 4)
#define DIALOG7212_SYSTEM_MODES_OUTPUT_LINE_MASK        (1U << 3)
#define DIALOG7212_SYSTEM_MODES_OUTPUT_AUX_R_MASK       (1U << 2)
#define DIALOG7212_SYSTEM_MODES_OUTPUT_AUX_L_MASK       (1U << 1)
#define DIALOG7212_SYSTEM_MODES_OUTPUT_MODE_SUBMIT_MASK (1U << 0)

/*****************Control Registers(2)********************/
/* DIALOG7212_AUX_L_CTRL                         0x60 */
#define DIALOG7212_AUX_L_CTRL_AMP_EN_MASK               (1U << 7)
#define DIALOG7212_AUX_L_CTRL_AMP_MUTE_EN_MASK          (1U << 6)
#define DIALOG7212_AUX_L_CTRL_AMP_RAMP_EN_MASK          (1U << 5)
#define DIALOG7212_AUX_L_CTRL_AMP_ZC_EN_MASK            (1U << 4)
#define DIALOG7212_AUX_L_CTRL_AMP_ZC_SEL_MASK           (0x0C)
#define DIALOG7212_AUX_L_CTRL_AMP_ZC_SEL_SHIFT          (2U)
#define DIALOG7212_AUX_L_CTRL_AMP_ZC_SEL_INPUT_AUX_L    \
	(0U << DIALOG7212_AUX_L_CTRL_AMP_ZC_SEL_SHIFT)
#define DIALOG7212_AUX_L_CTRL_AMP_ZC_SEL_INPUT_AUX_L_IF \
	(1U << DIALOG7212_AUX_L_CTRL_AMP_ZC_SEL_SHIFT)
#define DIALOG7212_AUX_L_CTRL_AMP_ZC_SEL_NO_ZC_POSSIBLE  \
	(2U << DIALOG7212_AUX_L_CTRL_AMP_ZC_SEL_SHIFT)
#define DIALOG7212_AUX_L_CTRL_AMP_ZC_SEL_OUTPUT_AUX_L   \
	(3U << DIALOG7212_AUX_L_CTRL_AMP_ZC_SEL_SHIFT)

/* DIALOG7212_AUX_R_CTRL                         0x61 */
#define DIALOG7212_AUX_R_CTRL_AMP_EN_MASK               (1U << 7)
#define DIALOG7212_AUX_R_CTRL_AMP_MUTE_EN_MASK          (1U << 6)
#define DIALOG7212_AUX_R_CTRL_AMP_RAMP_EN_MASK          (1U << 5)
#define DIALOG7212_AUX_R_CTRL_AMP_ZC_EN_MASK            (1U << 4)
#define DIALOG7212_AUX_R_CTRL_AMP_ZC_SEL_MASK           (0x0C)
#define DIALOG7212_AUX_R_CTRL_AMP_ZC_SEL_SHIFT          (2U)
#define DIALOG7212_AUX_R_CTRL_AMP_ZC_SEL_INPUT_AUX_R    \
	(0U << DIALOG7212_AUX_R_CTRL_AMP_ZC_SEL_SHIFT)
#define DIALOG7212_AUX_R_CTRL_AMP_ZC_SEL_INPUT_AUX_R_IF \
	(1U << DIALOG7212_AUX_R_CTRL_AMP_ZC_SEL_SHIFT)
#define DIALOG7212_AUX_R_CTRL_AMP_ZC_SEL_NO_ZC_POSSIBLE  \
	(2U << DIALOG7212_AUX_R_CTRL_AMP_ZC_SEL_SHIFT)
#define DIALOG7212_AUX_R_CTRL_AMP_ZC_SEL_OUTPUT_AUX_R   \
	(3U << DIALOG7212_AUX_R_CTRL_AMP_ZC_SEL_SHIFT)

/* DIALOG7212_MICBIAS_CTRL                       0x62 */
#define DIALOG7212_MICBIAS_CTRL_MICBIAS2_EN_MASK    (1U << 7)
#define DIALOG7212_MICBIAS_CTRL_MICBIAS2_LEVEL_MASK (0x30)
#define DIALOG7212_MICBIAS_CTRL_MICBIAS2_SHIFT      (4U)
#define DIALOG7212_MICBIAS_CTRL_MICBIAS2_1_6V       \
	(0U << DIALOG7212_MICBIAS_CTRL_MICBIAS2_SHIFT)
#define DIALOG7212_MICBIAS_CTRL_MICBIAS2_2_2V       \
	(1U << DIALOG7212_MICBIAS_CTRL_MICBIAS2_SHIFT)
#define DIALOG7212_MICBIAS_CTRL_MICBIAS2_2_5V       \
	(2U << DIALOG7212_MICBIAS_CTRL_MICBIAS2_SHIFT)
#define DIALOG7212_MICBIAS_CTRL_MICBIAS2_3_0V       \
	(3U << DIALOG7212_MICBIAS_CTRL_MICBIAS2_SHIFT)
#define DIALOG7212_MICBIAS_CTRL_MICBIAS1_EN_MASK    (1U << 3)
#define DIALOG7212_MICBIAS_CTRL_MICBIAS1_LEVEL_MASK (0x03)
#define DIALOG7212_MICBIAS_CTRL_MICBIAS1_SHIFT      (0U)
#define DIALOG7212_MICBIAS_CTRL_MICBIAS1_1_6V       \
	(0U << DIALOG7212_MICBIAS_CTRL_MICBIAS1_SHIFT)
#define DIALOG7212_MICBIAS_CTRL_MICBIAS1_2_2V       \
	(1U << DIALOG7212_MICBIAS_CTRL_MICBIAS1_SHIFT)
#define DIALOG7212_MICBIAS_CTRL_MICBIAS1_2_5V       \
	(2U << DIALOG7212_MICBIAS_CTRL_MICBIAS1_SHIFT)
#define DIALOG7212_MICBIAS_CTRL_MICBIAS1_3_0V       \
	(3U << DIALOG7212_MICBIAS_CTRL_MICBIAS1_SHIFT)

/* DIALOG7212_MIC_1_CTRL                         0x63 */
#define DIALOG7212_MIC_1_CTRL_AMP_EN_MASK             (1U << 7)
#define DIALOG7212_MIC_1_CTRL_AMP_MUTE_EN_MASK        (1U << 6)
#define DIALOG7212_MIC_1_CTRL_AMP_IN_SEL_MASK         (0x0C)
#define DIALOG7212_MIC_1_CTRL_AMP_IN_SEL_SHIFT        (2U)
#define DIALOG7212_MIC_1_CTRL_AMP_IN_SEL_DIFFERENTIAL \
	(0U << DIALOG7212_MIC_1_CTRL_AMP_IN_SEL_SHIFT)
#define DIALOG7212_MIC_1_CTRL_AMP_IN_SEL_MIC_1_P      \
	(1U << DIALOG7212_MIC_1_CTRL_AMP_IN_SEL_SHIFT)
#define DIALOG7212_MIC_1_CTRL_AMP_IN_SEL_MIC_1_N      \
	(2U << DIALOG7212_MIC_1_CTRL_AMP_IN_SEL_SHIFT)

/* DIALOG7212_MIC_2_CTRL                         0x64 */
#define DIALOG7212_MIC_2_CTRL_AMP_EN_MASK             (1U << 7)
#define DIALOG7212_MIC_2_CTRL_AMP_MUTE_EN_MASK        (1U << 6)
#define DIALOG7212_MIC_2_CTRL_AMP_IN_SEL_MASK         (0x0C)
#define DIALOG7212_MIC_2_CTRL_AMP_IN_SEL_SHIFT        (2U)
#define DIALOG7212_MIC_2_CTRL_AMP_IN_SEL_DIFFERENTIAL \
	(0U << DIALOG7212_MIC_2_CTRL_AMP_IN_SEL_SHIFT)
#define DIALOG7212_MIC_2_CTRL_AMP_IN_SEL_MIC_2_P      \
	(1U << DIALOG7212_MIC_2_CTRL_AMP_IN_SEL_SHIFT)
#define DIALOG7212_MIC_2_CTRL_AMP_IN_SEL_MIC_2_N      \
	(2U << DIALOG7212_MIC_2_CTRL_AMP_IN_SEL_SHIFT)

/* DIALOG7212_MIXIN_L_CTRL                       0x65 */
#define DIALOG7212_MIXIN_L_CTRL_AMP_EN_MASK      (1U << 7)
#define DIALOG7212_MIXIN_L_CTRL_AMP_MUTE_EN_MASK (1U << 6)
#define DIALOG7212_MIXIN_L_CTRL_AMP_RAMP_EN_MASK (1U << 5)
#define DIALOG7212_MIXIN_L_CTRL_AMP_ZC_EN_MASK   (1U << 4)
#define DIALOG7212_MIXIN_L_CTRL_AMP_MIX_EN_MASK  (1U << 3)

/* DIALOG7212_MIXIN_R_CTRL                       0x66 */
#define DIALOG7212_MIXIN_R_CTRL_AMP_EN_MASK      (1U << 7)
#define DIALOG7212_MIXIN_R_CTRL_AMP_MUTE_EN_MASK (1U << 6)
#define DIALOG7212_MIXIN_R_CTRL_AMP_RAMP_EN_MASK (1U << 5)
#define DIALOG7212_MIXIN_R_CTRL_AMP_ZC_EN_MASK   (1U << 4)
#define DIALOG7212_MIXIN_R_CTRL_AMP_MIX_EN_MASK  (1U << 3)

/* DIALOG7212_ADC_L_CTRL                         0x67 */
#define DIALOG7212_ADC_L_CTRL_ADC_EN_MASK      (1U << 7)
#define DIALOG7212_ADC_L_CTRL_ADC_MUTE_EN_MASK (1U << 6)
#define DIALOG7212_ADC_L_CTRL_ADC_RAMP_EN_MASK (1U << 5)

#define DIALOG7212_MUTE_MASK                   (3U << 6)
#define DIALOG7212_UNMUTE_MASK                 DIALOG7212_ADC_L_CTRL_ADC_EN_MASK

/* DIALOG7212_ADC_R_CTRL                         0x68 */
#define DIALOG7212_ADC_R_CTRL_ADC_EN_MASK      (1U << 7)
#define DIALOG7212_ADC_R_CTRL_ADC_MUTE_EN_MASK (1U << 6)
#define DIALOG7212_ADC_R_CTRL_ADC_RAMP_EN_MASK (1U << 5)

/* DIALOG7212_DAC_L_CTRL                         0x69 */
#define DIALOG7212_DAC_L_CTRL_DAC_EN_MASK      (1U << 7)
#define DIALOG7212_DAC_L_CTRL_DAC_MUTE_EN_MASK (1U << 6)
#define DIALOG7212_DAC_L_CTRL_DAC_RAMP_EN_MASK (1U << 5)

/* DIALOG7212_DAC_R_CTRL                         0x6A */
#define DIALOG7212_DAC_R_CTRL_DAC_EN_MASK      (1U << 7)
#define DIALOG7212_DAC_R_CTRL_DAC_MUTE_EN_MASK (1U << 6)
#define DIALOG7212_DAC_R_CTRL_DAC_RAMP_EN_MASK (1U << 5)

/* DIALOG7212_HP_L_CTRL                          0x6B */
#define DIALOG7212_HP_L_CTRL_AMP_EN_MASK          (1U << 7)
#define DIALOG7212_HP_L_CTRL_AMP_MUTE_EN_MASK     (1U << 6)
#define DIALOG7212_HP_L_CTRL_AMP_RAMP_EN_MASK     (1U << 5)
#define DIALOG7212_HP_L_CTRL_AMP_ZC_EN_MASK       (1U << 4)
#define DIALOG7212_HP_L_CTRL_AMP_OE_MASK          (1U << 3)
#define DIALOG7212_HP_L_CTRL_AMP_MIN_GAIN_EN_MASK (1U << 2)

/* DIALOG7212_HP_R_CTRL                          0x6C */
#define DIALOG7212_HP_R_CTRL_AMP_EN_MASK          (1U << 7)
#define DIALOG7212_HP_R_CTRL_AMP_MUTE_EN_MASK     (1U << 6)
#define DIALOG7212_HP_R_CTRL_AMP_RAMP_EN_MASK     (1U << 5)
#define DIALOG7212_HP_R_CTRL_AMP_ZC_EN_MASK       (1U << 4)
#define DIALOG7212_HP_R_CTRL_AMP_OE_MASK          (1U << 3)
#define DIALOG7212_HP_R_CTRL_AMP_MIN_GAIN_EN_MASK (1U << 2)

/* DIALOG7212_LINE_CTRL                          0x6D */
#define DIALOG7212_LINE_CTRL_AMP_EN_MASK          (1U << 7)
#define DIALOG7212_LINE_CTRL_AMP_MUTE_EN_MASK     (1U << 6)
#define DIALOG7212_LINE_CTRL_AMP_RAMP_EN_MASK     (1U << 5)
#define DIALOG7212_LINE_CTRL_AMP_OE_MASK          (1U << 3)
#define DIALOG7212_LINE_CTRL_AMP_MIN_GAIN_EN_MASK (1U << 2)

/* DIALOG7212_MIXOUT_L_CTRL                      0x6E */
#define DIALOG7212_MIXOUT_L_CTRL_AMP_EN_MASK          (1U << 7)
#define DIALOG7212_MIXOUT_L_CTRL_AMP_SOFT_MIX_EN_MASK (1U << 4)
#define DIALOG7212_MIXOUT_L_CTRL_AMP_MIX_EN_MASK      (1U << 3)

/* DIALOG7212_MIXOUT_R_CTRL                      0x6F */
#define DIALOG7212_MIXOUT_R_CTRL_AMP_EN_MASK          (1U << 7)
#define DIALOG7212_MIXOUT_R_CTRL_AMP_SOFT_MIX_EN_MASK (1U << 4)
#define DIALOG7212_MIXOUT_R_CTRL_AMP_MIX_EN_MASK      (1U << 3)

/*! @brief Configuration Registers mask/shift */
/* DIALOG7212_LDO_CTRL                           0x90 */
#define DIALOG7212_LDO_CTRL_EN_MASK            (1U << 7)
#define DIALOG7212_LDO_CTRL_LEVEL_SELECT_MASK  (0x30)
#define DIALOG7212_LDO_CTRL_LEVEL_SELECT_SHIFT (4U)
#define DIALOG7212_LDO_CTRL_LEVEL_SELECT_1_05V \
	(0U << DIALOG7212_LDO_CTRL_LEVEL_SELECT_SHIFT)
#define DIALOG7212_LDO_CTRL_LEVEL_SELECT_1_10V \
	(1U << DIALOG7212_LDO_CTRL_LEVEL_SELECT_SHIFT)
#define DIALOG7212_LDO_CTRL_LEVEL_SELECT_1_20V \
	(2U << DIALOG7212_LDO_CTRL_LEVEL_SELECT_SHIFT)
#define DIALOG7212_LDO_CTRL_LEVEL_SELECT_1_40V \
	(3U << DIALOG7212_LDO_CTRL_LEVEL_SELECT_SHIFT)

/* DIALOG7212_GAIN_RAMP_CTRL                     0x92 */
#define DIALOG7212_GAIN_RAMP_CTRL_RATE_MASK      (0x03)
#define DIALOG7212_GAIN_RAMP_CTRL_RATE_SHIFT     (0U)
#define DIALOG7212_GAIN_RAMP_CTRL_RATE_NR_DIV_8  \
	(0U << DIALOG7212_GAIN_RAMP_CTRL_RATE_SHIFT)
#define DIALOG7212_GAIN_RAMP_CTRL_RATE_NR_DIV_16 \
	(1U << DIALOG7212_GAIN_RAMP_CTRL_RATE_SHIFT)
#define DIALOG7212_GAIN_RAMP_CTRL_RATE_NR_MUL_16 \
	(2U << DIALOG7212_GAIN_RAMP_CTRL_RATE_SHIFT)
#define DIALOG7212_GAIN_RAMP_CTRL_RATE_NR_MUL_32 \
	(3U << DIALOG7212_GAIN_RAMP_CTRL_RATE_SHIFT)

/* DIALOG7212_MIC_CONFIG                         0x93 */
#define DIALOG7212_MIC_CONFIG_DMIC_CLK_RATE_MASK    (1U << 2)
#define DIALOG7212_MIC_CONFIG_DMIC_SAMPLEPHASE_MASK (1U << 1)
#define DIALOG7212_MIC_CONFIG_DMIC_DATA_SEL_MASK    (1U << 0)

/* DIALOG7212_PC_COUNT                           0x94 */
#define DIALOG7212_PC_COUNT_RESYNC_MASK (1U << 1)
#define DIALOG7212_PC_COUNT_FREERU_MASK (1U << 0)

/* DIALOG7212_CP_VOL_THRESHOLD1                  0x95 */
#define DIALOG7212_CP_VOL_THRESHOLD1_VDD2_MASK  (0x3F)
#define DIALOG7212_CP_VOL_THRESHOLD1_VDD2_SHIFT (0U)
#define DIALOG7212_CP_VOL_THRESHOLD1_VDD2(x)    \
	((x) << DIALOG7212_CP_VOL_THRESHOLD1_VDD2_SHIFT)

/* DIALOG7212_CP_DELAY                           0x96 */
#define DIALOG7212_CP_DELAY_ON_OFF_MASK          (0xC0)
#define DIALOG7212_CP_DELAY_ON_OFF_SHIFT         (6U)
#define DIALOG7212_CP_DELAY_ON_OFF_LIMITER_ON    \
	(0U << DIALOG7212_CP_DELAY_ON_OFF_SHIFT)
#define DIALOG7212_CP_DELAY_ON_OFF_LIMITER_OFF   \
	(1U << DIALOG7212_CP_DELAY_ON_OFF_SHIFT)
#define DIALOG7212_CP_DELAY_ON_OFF_LIMITER_AUT   \
	(2U << DIALOG7212_CP_DELAY_ON_OFF_SHIFT)
#define DIALOG7212_CP_DELAY_TAU_DELAY_MASK       (0x38)
#define DIALOG7212_CP_DELAY_TAU_DELAY_SHIFT      (3U)
#define DIALOG7212_CP_DELAY_TAU_DELAY_0MS        \
	(0U << DIALOG7212_CP_DELAY_TAU_DELAY_SHIFT)
#define DIALOG7212_CP_DELAY_TAU_DELAY_2MS        \
	(1U << DIALOG7212_CP_DELAY_TAU_DELAY_SHIFT)
#define DIALOG7212_CP_DELAY_TAU_DELAY_4MS        \
	(2U << DIALOG7212_CP_DELAY_TAU_DELAY_SHIFT)
#define DIALOG7212_CP_DELAY_TAU_DELAY_16MS       \
	(3U << DIALOG7212_CP_DELAY_TAU_DELAY_SHIFT)
#define DIALOG7212_CP_DELAY_TAU_DELAY_64MS       \
	(4U << DIALOG7212_CP_DELAY_TAU_DELAY_SHIFT)
#define DIALOG7212_CP_DELAY_TAU_DELAY_128MS      \
	(5U << DIALOG7212_CP_DELAY_TAU_DELAY_SHIFT)
#define DIALOG7212_CP_DELAY_TAU_DELAY_256MS      \
	(6U << DIALOG7212_CP_DELAY_TAU_DELAY_SHIFT)
#define DIALOG7212_CP_DELAY_TAU_DELAY_512MS      \
	(7U << DIALOG7212_CP_DELAY_TAU_DELAY_SHIFT)
#define DIALOG7212_CP_DELAY_FCONTROL_MASK        (0x07)
#define DIALOG7212_CP_DELAY_FCONTROL_SHIFT       (0U)
#define DIALOG7212_CP_DELAY_FCONTROL_1MHZ        \
	(0U << DIALOG7212_CP_DELAY_FCONTROL_SHIFT)
#define DIALOG7212_CP_DELAY_FCONTROL_500KHZ      \
	(1U << DIALOG7212_CP_DELAY_FCONTROL_SHIFT)
#define DIALOG7212_CP_DELAY_FCONTROL_250KHZ      \
	(2U << DIALOG7212_CP_DELAY_FCONTROL_SHIFT)
#define DIALOG7212_CP_DELAY_FCONTROL_125KHZ      \
	(3U << DIALOG7212_CP_DELAY_FCONTROL_SHIFT)
#define DIALOG7212_CP_DELAY_FCONTROL_63KHZ       \
	(4U << DIALOG7212_CP_DELAY_FCONTROL_SHIFT)
#define DIALOG7212_CP_DELAY_FCONTROL_0HZ_OR_1MHZ \
	(5U << DIALOG7212_CP_DELAY_FCONTROL_SHIFT)

/* DIALOG7212_CP_DETECTOR                        0x97 */
#define DIALOG7212_CP_DETECTOR_DROP_MASK  (0x03)
#define DIALOG7212_CP_DETECTOR_DROP_SHIFT (0U)
#define DIALOG7212_CP_DETECTOR_DROP_25MV  \
	(0U << DIALOG7212_CP_DETECTOR_DROP_SHIFT)
#define DIALOG7212_CP_DETECTOR_DROP_50MV  \
	(1U << DIALOG7212_CP_DETECTOR_DROP_SHIFT)
#define DIALOG7212_CP_DETECTOR_DROP_75MV  \
	(2U << DIALOG7212_CP_DETECTOR_DROP_SHIFT)
#define DIALOG7212_CP_DETECTOR_DROP_100MV \
	(3U << DIALOG7212_CP_DETECTOR_DROP_SHIFT)

/* DIALOG7212_DAI_OFFSET                         0x98 */
#define DIALOG7212_DAI_OFFSET_MASK   (0xFF)
#define DIALOG7212_DAI_OFFSET_SHIFT  (0U)
#define DIALOG7212_DAI_OFFSET_VAL(x) \
	(x << DIALOG7212_DAI_OFFSET_SHIFT)

/* DIALOG7212_DIG_CTRL                           0x99 */
#define DIALOG7212_DIG_CTRL_R_INV_MASK (1U << 7)
#define DIALOG7212_DIG_CTRL_L_INV_MASK (1U << 3)

/* DIALOG7212_ALC_CTRL2                          0x9A */
#define DIALOG7212_ALC_CTRL2_RELEASE_MASK  (0xF0)
#define DIALOG7212_ALC_CTRL2_RELEASE_SHIFT (4U)
#define DIALOG7212_ALC_CTRL2_RELEASE(x)    \
	((x) << DIALOG7212_ALC_CTRL2_RELEASE_SHIFT)
#define DIALOG7212_ALC_CTRL2_ATTACK_MASK   (0x0F)
#define DIALOG7212_ALC_CTRL2_ATTACK_SHIFT  (0U)
#define DIALOG7212_ALC_CTRL2_ATTACK(x)     \
	((x) << DIALOG7212_ALC_CTRL2_ATTACK_SHIFT)

/* DIALOG7212_ALC_CTRL3                          0x9B */
#define DIALOG7212_ALC_CTRL3_INTEG_RELEASE_MASK    (0xC0)
#define DIALOG7212_ALC_CTRL3_INTEG_RELEASE_SHIFT   (6U)
#define DIALOG7212_ALC_CTRL3_INTEG_RELEASE_1DIV4   \
	(0U << DIALOG7212_ALC_CTRL3_INTEG_RELEASE_SHIFT)
#define DIALOG7212_ALC_CTRL3_INTEG_RELEASE_1DIV16  \
	(1U << DIALOG7212_ALC_CTRL3_INTEG_RELEASE_SHIFT)
#define DIALOG7212_ALC_CTRL3_INTEG_RELEASE_1DIV256 \
	(2U << DIALOG7212_ALC_CTRL3_INTEG_RELEASE_SHIFT)
#define DIALOG7212_ALC_CTRL3_INTEG_ATTACK_MASK     (0x30)
#define DIALOG7212_ALC_CTRL3_INTEG_ATTACK_SHIFT    (4U)
#define DIALOG7212_ALC_CTRL3_INTEG_ATTACK_1DIV4    \
	(0U << DIALOG7212_ALC_CTRL3_INTEG_ATTACK_SHIFT)
#define DIALOG7212_ALC_CTRL3_INTEG_ATTACK_1DIV16   \
	(1U << DIALOG7212_ALC_CTRL3_INTEG_ATTACK_SHIFT)
#define DIALOG7212_ALC_CTRL3_INTEG_ATTACK_1DIV256  \
	(2U << DIALOG7212_ALC_CTRL3_INTEG_ATTACK_SHIFT)
#define DIALOG7212_ALC_CTRL3_HOLD_MASK             (0x0F)
#define DIALOG7212_ALC_CTRL3_HOLD_SHIFT            (0U)
#define DIALOG7212_ALC_CTRL3_HOLD(x)               \
	((x) << DIALOG7212_ALC_CTRL3_HOLD_SHIFT)

/* DIALOG7212_ALC_NOISE                          0x9C */
#define DIALOG7212_ALC_NOISE_MASK   (0x3F)
#define DIALOG7212_ALC_NOISE_SHIFT  (0U)
#define DIALOG7212_ALC_NOISE_VAL(x) ((x) << DIALOG7212_ALC_NOISE_SHIFT)

/* DIALOG7212_ALC_TARGET_MIN                     0x9D */
#define DIALOG7212_ALC_TARGET_MIN_THRESHOLD_MIN_MASK  (0x3F)
#define DIALOG7212_ALC_TARGET_MIN_THRESHOLD_MIN_SHIFT (0U)
#define DIALOG7212_ALC_TARGET_MIN_THRESHOLD_MIN(x)    \
	((x) << DIALOG7212_ALC_TARGET_MIN_THRESHOLD_MIN_SHIFT)

/* DIALOG7212_ALC_TARGET_MAX                     0x9E */
#define DIALOG7212_ALC_TARGET_MAX_THRESHOLD_MAX_MASK  (0x3F)
#define DIALOG7212_ALC_TARGET_MAX_THRESHOLD_MAX_SHIFT (0U)
#define DIALOG7212_ALC_TARGET_MAX_THRESHOLD_MAX(x)    \
	((x) << DIALOG7212_ALC_TARGET_MAX_THRESHOLD_MAX_SHIFT)

/* DIALOG7212_ALC_GAIN_LIMITS                    0x9F */
#define DIALOG7212_ALC_GAIN_LIMITS_GAIN_MAX_MASK   (0xF0)
#define DIALOG7212_ALC_GAIN_LIMITS_GAIN_MAX_SHIFT  (4U)
#define DIALOG7212_ALC_GAIN_LIMITS_GAIN_MAX(x)     \
	((x) << DIALOG7212_ALC_GAIN_LIMITS_GAIN_MAX_SHIFT)
#define DIALOG7212_ALC_GAIN_LIMITS_ATTEN_MAX_MASK  (0x0F)
#define DIALOG7212_ALC_GAIN_LIMITS_ATTEN_MAX_SHIFT (0U)
#define DIALOG7212_ALC_GAIN_LIMITS_ATTEN_MAX(x)    \
	((x) << DIALOG7212_ALC_GAIN_LIMITS_ATTEN_MAX_SHIFT)

/* DIALOG7212_ALC_ANA_GAIN_LIMITS                0xA0 */
#define DIALOG7212_ALC_ANA_GAIN_LIMITS_MAX_MASK  (0x70)
#define DIALOG7212_ALC_ANA_GAIN_LIMITS_MAX_SHIFT (4U)
#define DIALOG7212_ALC_ANA_GAIN_LIMITS_MAX_0DB   \
	(1U << DIALOG7212_ALC_ANA_GAIN_LIMITS_MAX_SHIFT)
#define DIALOG7212_ALC_ANA_GAIN_LIMITS_MAX_6DB   \
	(2U << DIALOG7212_ALC_ANA_GAIN_LIMITS_MAX_SHIFT)
#define DIALOG7212_ALC_ANA_GAIN_LIMITS_MAX_12DB  \
	(3U << DIALOG7212_ALC_ANA_GAIN_LIMITS_MAX_SHIFT)
#define DIALOG7212_ALC_ANA_GAIN_LIMITS_MAX_18DB  \
	(4U << DIALOG7212_ALC_ANA_GAIN_LIMITS_MAX_SHIFT)
#define DIALOG7212_ALC_ANA_GAIN_LIMITS_MAX_24DB  \
	(5U << DIALOG7212_ALC_ANA_GAIN_LIMITS_MAX_SHIFT)
#define DIALOG7212_ALC_ANA_GAIN_LIMITS_MAX_30DB  \
	(6U << DIALOG7212_ALC_ANA_GAIN_LIMITS_MAX_SHIFT)
#define DIALOG7212_ALC_ANA_GAIN_LIMITS_MAX_36DB  \
	(7U << DIALOG7212_ALC_ANA_GAIN_LIMITS_MAX_SHIFT)
#define DIALOG7212_ALC_ANA_GAIN_LIMITS_MIN_MASK  (0x07)
#define DIALOG7212_ALC_ANA_GAIN_LIMITS_MIN_SHIFT (0U)
#define DIALOG7212_ALC_ANA_GAIN_LIMITS_MIN_0DB   \
	(1U << DIALOG7212_ALC_ANA_GAIN_LIMITS_MIN_SHIFT)
#define DIALOG7212_ALC_ANA_GAIN_LIMITS_MIN_6DB   \
	(2U << DIALOG7212_ALC_ANA_GAIN_LIMITS_MIN_SHIFT)
#define DIALOG7212_ALC_ANA_GAIN_LIMITS_MIN_12DB  \
	(3U << DIALOG7212_ALC_ANA_GAIN_LIMITS_MIN_SHIFT)
#define DIALOG7212_ALC_ANA_GAIN_LIMITS_MIN_18DB  \
	(4U << DIALOG7212_ALC_ANA_GAIN_LIMITS_MIN_SHIFT)
#define DIALOG7212_ALC_ANA_GAIN_LIMITS_MIN_24DB  \
	(5U << DIALOG7212_ALC_ANA_GAIN_LIMITS_MIN_SHIFT)
#define DIALOG7212_ALC_ANA_GAIN_LIMITS_MIN_30DB  \
	(6U << DIALOG7212_ALC_ANA_GAIN_LIMITS_MIN_SHIFT)
#define DIALOG7212_ALC_ANA_GAIN_LIMITS_MIN_36DB  \
	(7U << DIALOG7212_ALC_ANA_GAIN_LIMITS_MIN_SHIFT)

/* DIALOG7212_ALC_ANTICLIP_CTRL                  0xA1 */
#define DIALOG7212_ALC_ANTICLIP_CTRL_EN_MASK (1U << 7)

/* DIALOG7212_ALC_ANTICLIP_LEVEL                 0xA2 */
#define DIALOG7212_ALC_ANTICLIP_LEVEL_MASK   (0x7F)
#define DIALOG7212_ALC_ANTICLIP_LEVEL_SHIFT  (0U)
#define DIALOG7212_ALC_ANTICLIP_LEVEL_VAL(x) \
	((x) << DIALOG7212_ALC_ANTICLIP_LEVEL_SHIFT)

/* DIALOG7212_DAC_NG_SETUP_TIME                  0xAF */
#define DIALOG7212_DAC_NG_SETUP_TIME_RAMPDN_RATE_MASK (1U << 3)
#define DIALOG7212_DAC_NG_SETUP_TIME_RAMPUP_RATE_MASK (1U << 2)
#define DIALOG7212_DAC_NG_SETUP_TIME_MASK             (0x03)
#define DIALOG7212_DAC_NG_SETUP_TIME_SHIFT            (0U)
#define DIALOG7212_DAC_NG_SETUP_TIME_256              \
	(1U << DIALOG7212_DAC_NG_SETUP_TIME_SHIFT)
#define DIALOG7212_DAC_NG_SETUP_TIME_512              \
	(2U << DIALOG7212_DAC_NG_SETUP_TIME_SHIFT)
#define DIALOG7212_DAC_NG_SETUP_TIME_1024             \
	(3U << DIALOG7212_DAC_NG_SETUP_TIME_SHIFT)
#define DIALOG7212_DAC_NG_SETUP_TIME_2048             \
	(4U << DIALOG7212_DAC_NG_SETUP_TIME_SHIFT)

/* DIALOG7212_DAC_NG_OFF_THRESH                  0xB0 */
#define DIALOG7212_DAC_NG_OFF_THRESHOLD_MASK  (0x07)
#define DIALOG7212_DAC_NG_OFF_THRESHOLD_SHIFT (0U)
#define DIALOG7212_DAC_NG_OFF_THRESHOLD_N90DB \
	(0U << DIALOG7212_DAC_NG_OFF_THRESHOLD_SHIFT)
#define DIALOG7212_DAC_NG_OFF_THRESHOLD_N84DB \
	(1U << DIALOG7212_DAC_NG_OFF_THRESHOLD_SHIFT)
#define DIALOG7212_DAC_NG_OFF_THRESHOLD_N78DB \
	(2U << DIALOG7212_DAC_NG_OFF_THRESHOLD_SHIFT)
#define DIALOG7212_DAC_NG_OFF_THRESHOLD_N72DB \
	(3U << DIALOG7212_DAC_NG_OFF_THRESHOLD_SHIFT)
#define DIALOG7212_DAC_NG_OFF_THRESHOLD_N66DB \
	(4U << DIALOG7212_DAC_NG_OFF_THRESHOLD_SHIFT)
#define DIALOG7212_DAC_NG_OFF_THRESHOLD_N60DB \
	(5U << DIALOG7212_DAC_NG_OFF_THRESHOLD_SHIFT)
#define DIALOG7212_DAC_NG_OFF_THRESHOLD_N54DB \
	(6U << DIALOG7212_DAC_NG_OFF_THRESHOLD_SHIFT)
#define DIALOG7212_DAC_NG_OFF_THRESHOLD_N48DB \
	(7U << DIALOG7212_DAC_NG_OFF_THRESHOLD_SHIFT)

/* DIALOG7212_DAC_NG_ON_THRESH                   0xB1 */
#define DIALOG7212_DAC_NG_ON_THRESHOLD_MASK  (0x07)
#define DIALOG7212_DAC_NG_ON_THRESHOLD_SHIFT (0U)
#define DIALOG7212_DAC_NG_ON_THRESHOLD_N90DB \
	(0U << DIALOG7212_DAC_NG_ON_THRESHOLD_SHIFT)
#define DIALOG7212_DAC_NG_ON_THRESHOLD_N84DB \
	(1U << DIALOG7212_DAC_NG_ON_THRESHOLD_SHIFT)
#define DIALOG7212_DAC_NG_ON_THRESHOLD_N78DB \
	(2U << DIALOG7212_DAC_NG_ON_THRESHOLD_SHIFT)
#define DIALOG7212_DAC_NG_ON_THRESHOLD_N72DB \
	(3U << DIALOG7212_DAC_NG_ON_THRESHOLD_SHIFT)
#define DIALOG7212_DAC_NG_ON_THRESHOLD_N66DB \
	(4U << DIALOG7212_DAC_NG_ON_THRESHOLD_SHIFT)
#define DIALOG7212_DAC_NG_ON_THRESHOLD_N60DB \
	(5U << DIALOG7212_DAC_NG_ON_THRESHOLD_SHIFT)
#define DIALOG7212_DAC_NG_ON_THRESHOLD_N54DB \
	(6U << DIALOG7212_DAC_NG_ON_THRESHOLD_SHIFT)
#define DIALOG7212_DAC_NG_ON_THRESHOLD_N48DB \
	(7U << DIALOG7212_DAC_NG_ON_THRESHOLD_SHIFT)

/* DIALOG7212_DAC_NG_CTRL                        0xB2 */
#define DIALOG7212_DAC_NG_CTRL_EN_MASK (1U << 7)

/*! @brief Tone Generation & Beep Registers mask/shift */
/* DIALOG7212_TONE_GEN_CFG1                      0xB4 */
#define DIALOG7212_TONE_GEN_CFG1_START_STOPN_MASK (1U << 7)
#define DIALOG7212_TONE_GEN_CFG1_DMTF_EN_MASK     (1U << 4)
#define DIALOG7212_TONE_GEN_CFG1_DMTF_REG_MASK    (0x0F)
#define DIALOG7212_TONE_GEN_CFG1_DMTF_REG_SHIFT   (0U)
#define DIALOG7212_TONE_GEN_CFG1_DMTF_REG(x)      \
	((x) << DIALOG7212_TONE_GEN_CFG1_DMTF_REG_SHIFT)

/* DIALOG7212_TONE_GEN_CFG2                      0xB5 */
#define DIALOG7212_TONE_GEN_CFG2_GAIN_MASK         (0xF0)
#define DIALOG7212_TONE_GEN_CFG2_GAIN_SHIFT        (4U)
#define DIALOG7212_TONE_GEN_CFG2_GAIN(x)           \
	((x) << DIALOG7212_TONE_GEN_CFG2_GAIN_SHIFT)
#define DIALOG7212_TONE_GEN_CFG2_SWG_SEL_MASK      (0x03)
#define DIALOG7212_TONE_GEN_CFG2_SWG_SEL_SHIFT     (0U)
#define DIALOG7212_TONE_GEN_CFG2_SWG_SEL_SUM__BOTH \
	(0U << DIALOG7212_TONE_GEN_CFG2_SWG_SEL_SHIFT)
#define DIALOG7212_TONE_GEN_CFG2_SWG_SEL_SWG1_ONLY \
	(1U << DIALOG7212_TONE_GEN_CFG2_SWG_SEL_SHIFT)
#define DIALOG7212_TONE_GEN_CFG2_SWG_SEL_SWG2_ONLY \
	(2U << DIALOG7212_TONE_GEN_CFG2_SWG_SEL_SHIFT)
#define DIALOG7212_TONE_GEN_CFG2_SWG_SEL_SUM_BOTH  \
	(3U << DIALOG7212_TONE_GEN_CFG2_SWG_SEL_SHIFT)

/* DIALOG7212_TONE_GEN_CYCLES                    0xB6 */
#define DIALOG7212_TONE_GEN_CYCLES_BEEP_CYCLES_MASK     (0x07)
#define DIALOG7212_TONE_GEN_CYCLES_BEEP_CYCLES_SHIFT    (0U)
#define DIALOG7212_TONE_GEN_CYCLES_BEEP_CYCLES_1        \
	(0U << DIALOG7212_TONE_GEN_CYCLES_BEEP_CYCLES_SHIFT)
#define DIALOG7212_TONE_GEN_CYCLES_BEEP_CYCLES_2        \
	(1U << DIALOG7212_TONE_GEN_CYCLES_BEEP_CYCLES_SHIFT)
#define DIALOG7212_TONE_GEN_CYCLES_BEEP_CYCLES_4        \
	(2U << DIALOG7212_TONE_GEN_CYCLES_BEEP_CYCLES_SHIFT)
#define DIALOG7212_TONE_GEN_CYCLES_BEEP_CYCLES_8        \
	(3U << DIALOG7212_TONE_GEN_CYCLES_BEEP_CYCLES_SHIFT)
#define DIALOG7212_TONE_GEN_CYCLES_BEEP_CYCLES_16       \
	(4U << DIALOG7212_TONE_GEN_CYCLES_BEEP_CYCLES_SHIFT)
#define DIALOG7212_TONE_GEN_CYCLES_BEEP_CYCLES_32       \
	(5U << DIALOG7212_TONE_GEN_CYCLES_BEEP_CYCLES_SHIFT)
#define DIALOG7212_TONE_GEN_CYCLES_BEEP_CYCLES_INFINITE \
	(6U << DIALOG7212_TONE_GEN_CYCLES_BEEP_CYCLES_SHIFT)

/* DIALOG7212_TONE_GEN_FREQ1_L                   0xB7 */
#define DIALOG7212_TONE_GEN_FREQ1_L_MASK   (0xFF)
#define DIALOG7212_TONE_GEN_FREQ1_L_SHIFT  (0U)
#define DIALOG7212_TONE_GEN_FREQ1_L_VAL(x) \
	((x) << DIALOG7212_TONE_GEN_FREQ1_L_SHIFT)

/* DIALOG7212_TONE_GEN_FREQ1_U                   0xB8 */
#define DIALOG7212_TONE_GEN_FREQ1_U_MASK   (0xFF)
#define DIALOG7212_TONE_GEN_FREQ1_U_SHIFT  (0U)
#define DIALOG7212_TONE_GEN_FREQ1_U_VAL(x) \
	((x) << DIALOG7212_TONE_GEN_FREQ1_U_SHIFT)

/* DIALOG7212_TONE_GEN_FREQ2_L                   0xB9 */
#define DIALOG7212_TONE_GEN_FREQ2_L_MASK   (0xFF)
#define DIALOG7212_TONE_GEN_FREQ2_L_SHIFT  (0U)
#define DIALOG7212_TONE_GEN_FREQ2_L_VAL(x) \
	((x) << DIALOG7212_TONE_GEN_FREQ2_L_SHIFT)

/* DIALOG7212_TONE_GEN_FREQ2_U                   0xBA */
#define DIALOG7212_TONE_GEN_FREQ2_U_MASK   (0xFF)
#define DIALOG7212_TONE_GEN_FREQ2_U_SHIFT  (0U)
#define DIALOG7212_TONE_GEN_FREQ2_U_VAL(x) \
	((x) << DIALOG7212_TONE_GEN_FREQ2_U_SHIFT)

/* DIALOG7212_TONE_GEN_ON_PER                    0xBB */
#define DIALOG7212_TONE_GEN_ON_PER_BEEP_ON_PER_MASK  (0x3F)
#define DIALOG7212_TONE_GEN_ON_PER_BEEP_ON_PER_SHIFT (0U)
#define DIALOG7212_TONE_GEN_ON_PER_BEEP_ON_PER(x)    \
	((x) << DIALOG7212_TONE_GEN_ON_PER_BEEP_ON_PER_SHIFT)

/* DIALOG7212_TONE_GEN_OFF_PER                   0xBC */
#define DIALOG7212_TONE_GEN_OFF_PER_BEEP_OFF_PER_MASK  (0x3F)
#define DIALOG7212_TONE_GEN_OFF_PER_BEEP_OFF_PER_SHIFT (0U)
#define DIALOG7212_TONE_GEN_OFF_PER_BEEP_OFF_PER(x)    \
	 ((x) << DIALOG7212_TONE_GEN_OFF_PER_BEEP_OFF_PER_SHIFT)

/*! @brief System Controller Registers(2) */
/* DIALOG7212_SYSTEM_STATUS                      0xE0 */
#define DIALOG7212_SYSTEM_STATUS_SC2_BUSY_MASK (1U << 1)
#define DIALOG7212_SYSTEM_STATUS_SC1_BUSY_MASK (1U << 0)

#ifdef __cplusplus
}
#endif

#endif /* ZEPHYR_DRIVERS_AUDIO_DIALOG7212_H_ */
