/*
 * Copyright (c) 2025 Nordic Semiconductor ASA
 * SPDX-License-Identifier: Apache-2.0
 */

#ifndef ZEPHYR_DRIVERS_COMPARATOR_NRF_COMMON_H_
#define ZEPHYR_DRIVERS_COMPARATOR_NRF_COMMON_H_

#include <nrfx.h>

#if (NRF_COMP_HAS_AIN_AS_PIN || NRF_LPCOMP_HAS_AIN_AS_PIN)
static const uint32_t shim_nrf_comp_ain_map[] = {
#if defined(CONFIG_SOC_NRF54H20) || defined(CONFIG_SOC_NRF9280)
	NRF_PIN_PORT_TO_PIN_NUMBER(0U, 1),
	NRF_PIN_PORT_TO_PIN_NUMBER(1U, 1),
	NRF_PIN_PORT_TO_PIN_NUMBER(2U, 1),
	NRF_PIN_PORT_TO_PIN_NUMBER(3U, 1),
	NRF_PIN_PORT_TO_PIN_NUMBER(4U, 1),
	NRF_PIN_PORT_TO_PIN_NUMBER(5U, 1),
	NRF_PIN_PORT_TO_PIN_NUMBER(6U, 1),
	NRF_PIN_PORT_TO_PIN_NUMBER(7U, 1),
#elif defined(CONFIG_SOC_NRF54L05) || defined(CONFIG_SOC_NRF54L10) || defined(CONFIG_SOC_NRF54L15)
	NRF_PIN_PORT_TO_PIN_NUMBER(4U, 1),
	NRF_PIN_PORT_TO_PIN_NUMBER(5U, 1),
	NRF_PIN_PORT_TO_PIN_NUMBER(6U, 1),
	NRF_PIN_PORT_TO_PIN_NUMBER(7U, 1),
	NRF_PIN_PORT_TO_PIN_NUMBER(11U, 1),
	NRF_PIN_PORT_TO_PIN_NUMBER(12U, 1),
	NRF_PIN_PORT_TO_PIN_NUMBER(13U, 1),
	NRF_PIN_PORT_TO_PIN_NUMBER(14U, 1),
#elif defined(NRF54LM20A_ENGA_XXAA)
	NRF_PIN_PORT_TO_PIN_NUMBER(0U, 1),
	NRF_PIN_PORT_TO_PIN_NUMBER(31U, 1),
	NRF_PIN_PORT_TO_PIN_NUMBER(30U, 1),
	NRF_PIN_PORT_TO_PIN_NUMBER(29U, 1),
	NRF_PIN_PORT_TO_PIN_NUMBER(6U, 1),
	NRF_PIN_PORT_TO_PIN_NUMBER(5U, 1),
	NRF_PIN_PORT_TO_PIN_NUMBER(4U, 1),
	NRF_PIN_PORT_TO_PIN_NUMBER(3U, 1),
#elif defined(NRF54LV10A_ENGA_XXAA)
	NRF_PIN_PORT_TO_PIN_NUMBER(0U, 1),
	NRF_PIN_PORT_TO_PIN_NUMBER(1U, 1),
	NRF_PIN_PORT_TO_PIN_NUMBER(2U, 1),
	NRF_PIN_PORT_TO_PIN_NUMBER(3U, 1),
	NRF_PIN_PORT_TO_PIN_NUMBER(7U, 1),
	NRF_PIN_PORT_TO_PIN_NUMBER(10U, 1),
	NRF_PIN_PORT_TO_PIN_NUMBER(11U, 1),
	NRF_PIN_PORT_TO_PIN_NUMBER(12U, 1),
#endif
};
#endif

#endif /* ZEPHYR_DRIVERS_COMPARATOR_NRF_COMMON_H_ */
