/*
 * Copyright (c) 2025, Nathan Winslow <natelostintimeandspace@gmail.com>
 *
 * SPDX-License-Identifier: Apache-2.0
 */

#ifndef ZEPHYR_DRIVERS_FUELGAUGE_LTC2959_GAUGE_H_
#define ZEPHYR_DRIVERS_FUELGAUGE_LTC2959_GAUGE_H_

#include <zephyr/drivers/i2c.h>
#include <zephyr/drivers/fuel_gauge.h>

enum ltc2959_regs {
	/* Status and Control */
	LTC2959_REG_STATUS = 0x00,
	LTC2959_REG_ADC_CONTROL = 0x01,
	LTC2959_REG_CC_CONTROL = 0x02,

	/* Accumulated Charge (uint32_t) */
	LTC2959_REG_ACC_CHARGE_3 = 0x03,
	LTC2959_REG_ACC_CHARGE_2 = 0x04,
	LTC2959_REG_ACC_CHARGE_1 = 0x05,
	LTC2959_REG_ACC_CHARGE_0 = 0x06,

	/* Charge Thresholds (Low and High, uint32_t each) */
	LTC2959_REG_CHG_THRESH_LOW_3 = 0x07,
	LTC2959_REG_CHG_THRESH_LOW_2 = 0x08,
	LTC2959_REG_CHG_THRESH_LOW_1 = 0x09,
	LTC2959_REG_CHG_THRESH_LOW_0 = 0x0A,
	LTC2959_REG_CHG_THRESH_HIGH_3 = 0x0B,
	LTC2959_REG_CHG_THRESH_HIGH_2 = 0x0C,
	LTC2959_REG_CHG_THRESH_HIGH_1 = 0x0D,
	LTC2959_REG_CHG_THRESH_HIGH_0 = 0x0E,

	/* Voltage (uint16_t) */
	LTC2959_REG_VOLTAGE_MSB = 0x0F,
	LTC2959_REG_VOLTAGE_LSB = 0x10,
	LTC2959_REG_VOLT_THRESH_HIGH_MSB = 0x11,
	LTC2959_REG_VOLT_THRESH_HIGH_LSB = 0x12,
	LTC2959_REG_VOLT_THRESH_LOW_MSB = 0x13,
	LTC2959_REG_VOLT_THRESH_LOW_LSB = 0x14,
	LTC2959_REG_MAX_VOLTAGE_MSB = 0x15,
	LTC2959_REG_MAX_VOLTAGE_LSB = 0x16,
	LTC2959_REG_MIN_VOLTAGE_MSB = 0x17,
	LTC2959_REG_MIN_VOLTAGE_LSB = 0x18,

	/* Current (int16_t) */
	LTC2959_REG_CURRENT_MSB = 0x19,
	LTC2959_REG_CURRENT_LSB = 0x1A,
	LTC2959_REG_CURR_THRESH_HIGH_MSB = 0x1B,
	LTC2959_REG_CURR_THRESH_HIGH_LSB = 0x1C,
	LTC2959_REG_CURR_THRESH_LOW_MSB = 0x1D,
	LTC2959_REG_CURR_THRESH_LOW_LSB = 0x1E,
	LTC2959_REG_MAX_CURRENT_MSB = 0x1F,
	LTC2959_REG_MAX_CURRENT_LSB = 0x20,
	LTC2959_REG_MIN_CURRENT_MSB = 0x21,
	LTC2959_REG_MIN_CURRENT_LSB = 0x22,

	/* Temperature (uint16_t) */
	LTC2959_REG_TEMP_MSB = 0x23,
	LTC2959_REG_TEMP_LSB = 0x24,
	LTC2959_REG_TEMP_THRESH_HIGH_MSB = 0x25,
	LTC2959_REG_TEMP_THRESH_HIGH_LSB = 0x26,
	LTC2959_REG_TEMP_THRESH_LOW_MSB = 0x27,
	LTC2959_REG_TEMP_THRESH_LOW_LSB = 0x28,

	/* GPIO */
	LTC2959_REG_GPIO_VOLTAGE_MSB = 0x29,
	LTC2959_REG_GPIO_VOLTAGE_LSB = 0x2A,
	LTC2959_REG_GPIO_THRESH_HIGH_MSB = 0x2B,
	LTC2959_REG_GPIO_THRESH_HIGH_LSB = 0x2C,
	LTC2959_REG_GPIO_THRESH_LOW_MSB = 0x2D,
	LTC2959_REG_GPIO_THRESH_LOW_LSB = 0x2E,
};

#endif /* END ZEPHYR_DRIVERS_FUELGAUGE_LTC2959_GAUGE_H_ */
