/*
 * Copyright (c) 2024 Nordic Semiconductor ASA
 *
 * SPDX-License-Identifier: Apache-2.0
 */

/* @file
 * @brief nRF Wi-Fi radio-test mode shell module
 */

#include <zephyr/kernel.h>
#include <stdio.h>
#include <stdlib.h>
#include <zephyr/shell/shell.h>
#include <zephyr/init.h>
#include <ctype.h>
#ifdef CONFIG_NRF71_ON_IPC
#include <nrf71_wifi_ctrl.h>
#else
#include <host_rpu_sys_if.h>
#endif
#include <common/fmac_structs_common.h>
#include <queue.h>

struct nrf_wifi_ctx_zep_rt {
	struct nrf_wifi_fmac_priv *fmac_priv;
	struct rpu_conf_params conf_params;
};
